/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SM
#ifdef TARGET_BUILD
#include "trcGenProj/Header/SMF.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SM
#endif
#endif
#include "FunctionTracer.h"

/* others */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <vector>
#include "SMF.h"
#include "etrace_mp.h"
#include "Dispatcher.h"
//#include "RequestResponseSM.h"
//weg #include "QueueFactory.h"

#include "Framework_Errorcodes.h"
#include "Utils.h"

/*lint -save -e1401 */

using namespace std;

/* constants */
#define NOT_IMPLEMENTED_PRINT 1 /* = 1: print all not implemented user callback functions. */
#define MARSHAL_BASE 16

//TODO: find a better way to configure FAKE_THE_IPOD for module tests
int globalFakeTheIpod = 0;
int globalFakeTheCDDA = 0;

/*lint -save -e826 -e1773 -e801 */

// own print implementation. must be replaced to print to trace
void SMF::DebugPrint(const char *format, ...)
{
    va_list vl;
    char cbuf[printStringSize];
    va_start(vl, format);
    vsnprintf(cbuf, sizeof(cbuf), format, vl);
    va_end(vl);

    ETG_TRACE_USR1(("%s",cbuf));
}

void SMF::NotImplemented(const char *name)
{
    ENTRY_INTERNAL
#if NOT_IMPLEMENTED_PRINT
    ETG_TRACE_COMP(("%s: not implemented", name));
#else
    (void)name;
#endif
}

/* the following is only for verification of a state machine. */
#define EXPECT_OFF 0

#if EXPECT_OFF
int SMF::ExpectReset(void) {return 0;}
int SMF::ExpectSetString(char *string) {(void)string; return 0;}
int SMF::Expect(char *inputString) {(void)inputString; return 0;}
int SMF::GetExpectErrorCount(void) { return 0;}
int SMF::PrintEnter(tState *state) {(void)state; return 0;}
int SMF::PrintExit(tState *state)  {(void)state; return 0;}
int SMF::PrintGuard(tTransition *trans) {(void)trans; return 0;}
int SMF::PrintAction(tTransition *trans) {(void)trans; return 0;}
int SMF::PrintConditionAction(tTransition *trans) {(void)trans; return 0;}

#else

#define EXPECT_PRINT_ERROR 1 /* = 1: prints an error if expect failes */
#define EXPECT_PRINT_PROGRESS 1 /* = 1: prints every expect check */

int SMF::ExpectReset(void)
{
    mExpectedString.clear();
    mCurrentExpectString = -1;
    return 0;
}

int SMF::ExpectSetString(const char *inputString)
{
    mExpectedString.push_back(inputString);
    return 0;
}

int SMF::Expect(const char *inputString)
{
    int i;

    /* if no expect strings are registered, do not check them */
    if (mExpectedString.size() == 0) return 1;

    for (i=0; i<(int)mExpectedString.size(); i++) {
        if (mExpectedString[i]) {
            if (!strncmp(inputString, mExpectedString[i], strlen_r(inputString))) {
                mExpectedString[i] = NULL;
                if (++mCurrentExpectString == i) {
#if EXPECT_PRINT_PROGRESS
                    ETG_TRACE_COMP(("%s", inputString));
#endif
                    return 1;
                } else {
                    goto error;
                }
            }
        }
    }
    error:
#if EXPECT_PRINT_ERROR
    DebugPrint("!!! ERROR: %s", inputString);
#endif
    mExpectErrorCount++;
    return 0;
}
int SMF::GetExpectErrorCount(void)
{
    return mExpectErrorCount;
}

int SMF::PrintEnter(tState *state)
{
    char cbuf[printStringSize];
    snprintf(cbuf, sizeof(cbuf), "State: %s: Enter", state->name);
    Expect(cbuf);
    return 0;
}

int SMF::PrintExit(tState *state)
{
    char cbuf[printStringSize];
    snprintf(cbuf, sizeof(cbuf), "State: %s: Exit", state->name);
    Expect(cbuf);
    return 0;
}

int SMF::PrintGuard(tTransition *trans)
{
    char cbuf[printStringSize];
    snprintf(cbuf, sizeof(cbuf), "Trans: %s: Guard", trans->name);
    Expect(cbuf);
    return 0;
}

int SMF::PrintAction(tTransition *trans)
{
    char cbuf[printStringSize];
    snprintf(cbuf, sizeof(cbuf), "Trans: %s: Action", trans->name);
    Expect(cbuf);
    return 1;
}

int SMF::PrintConditionAction(tTransition *trans)
{
    char cbuf[printStringSize];
    snprintf(cbuf, sizeof(cbuf), "Trans: %s: Condition", trans->name);
    Expect(cbuf);
    return 0;
}

#endif // #if EXPECT_ON == 1

SMF::SMF() : mSMFullName(NULL)
{
    //printf("SMF: ptr=%p\n", this);

    /* global state machine counter to numerate the state machine instances for better addressing */
    static int stateMachineCounter = 0;

    pointersGC = NULL;
    numberOfPointersGC = 0;
    mCurrentTrans = NULL;  // CID 17780 (#1 of 2): Uninitialized pointer field (UNINIT_CTOR)
    mSDActionName = NULL;
    mSDTransactionName = NULL;
    memset(mSDEnterAction, 0, sizeof(mSDEnterAction));
    mRootState = NULL;
    mIsCreated = 0;
    mNULL_EVENT = CreateEvent("NULL_EVENT");
    mSMName = new char[strlen_r("SMNameNotSet")+1];
    strcpy((char *)mSMName, "SMNameNotSet");
    mSMFullName = new char[strlen_r("SMNameNotSet(0)")+1];
    strcpy((char *)mSMFullName, "SMNameNotSet(0)");
    snprintf((char *)mSMNamePostfix, sizeof(mSMNamePostfix), "%d", stateMachineCounter++);
    mCurrentExpectString = -1;
    mExpectErrorCount = 0;
    mCurrentContext = NULL;
    mMQExternal = NULL;
    mMQExternalName = NULL;
    mRetryCount = 3;
    mUSSleepTime = 500000L;
    mUserContext= NULL;
    mTransient = false;
}

SMF::~SMF()
{
    //printf("~SMF: ptr=%p\n", this);

    /* deregister SM at Dispatcher (for sure) */
    Dispatcher::GetInstance().DeRegister(this);

    /* loop over all contexts */
    for(int iContext=0; iContext<(int)mContextDirectory.size(); iContext++) {

        tStateContext *context = mContextDirectory[iContext];

        /* cancel a possibly running timer */
        if (context->AnswerTimerID) {
            context->AnswerTimer.CancelTimer(IN context->AnswerTimerID);
            ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s / ctx=%d, id=%d", mSMFullName, iContext, (int)((long)context->AnswerTimerID)));
            context->AnswerTimerID = 0;
        }
    }

    /* free the main message queue */
    if(mMQExternal)
    {
        delete mMQExternal;
        mMQExternal = NULL;
    }

    /* free internal queues for all contexts */
    for(int i=0; i<(int)mContextDirectory.size(); i++) {
        tStateContext *context = mContextDirectory[i];
        if(context->MQInternal)
        {
            delete context->MQInternal;
            context->MQInternal = NULL;
        }
    }

    /* free all GC memory */
    /* also the contexs are deleted here and inside the contexts the Timer object too */
    freeGC();

    /* free all names */
    delete[] mSMName;
    mSMName = NULL;
    delete[] mSMFullName;
    mSMFullName = NULL;
    delete[] mMQExternalName;
    mMQExternalName = NULL;

    /* clear the vector with all delay queue pointers */
    mAllDelayQueues.clear();
    vector<MessageQueue *> emptyAllDelayQueues; // this is done to ensure that all memory will be freed
    mAllDelayQueues.swap(emptyAllDelayQueues);

    /* clear the vector with all known events */
    mKnownEvents.clear();
    vector<tEvent *> emptyKnownEvents; // this is done to ensure that all memory will be freed
    mKnownEvents.swap(emptyKnownEvents);
}

void SMF::SDPrint(const char *cbuf)
{
    ETG_TRACE_USR2(("%128s: %s", mSMName, cbuf));
}

int SMF::SDPrintState(tState *state)
{
    char cbuf[printStringSize];
    if (state->alreadyPrinted) return 0;
    snprintf(cbuf, sizeof(cbuf), "%s::%s [t] \"%s\"", state->name, state->name, state->name);
    SDPrint(cbuf);
    state->alreadyPrinted = 1;
    return 0;
}

int SMF::SDPrintEvent(tState *currentState, tEvent *event, char *arguments)
{
    char cbuf[printStringSize];

    if (arguments) {
        snprintf(cbuf, sizeof(cbuf), "ext:%s.%s(%s) &", currentState->name, event->name, arguments);
    } else {
        snprintf(cbuf, sizeof(cbuf), "ext:%s.%s() &", currentState->name, event->name);
    }

    SDPrint(cbuf);
    return 0;
}

int SMF::SDPrintNotConsumedEvent(tEvent *event)
{
    char cbuf[printStringSize];
    snprintf(cbuf, sizeof(cbuf), "ext:notConsumed.%s &", event->name);
    SDPrint(cbuf);
    return 0;
}

int SMF::SDPrintStateTransition(tState *currentState, tState *compoundState, tState *lastCurrentState, tTransition *trans)
{
    char cbuf[printStringSize];

    if (!lastCurrentState) lastCurrentState = compoundState;

    if (!mSDTransactionName){
        if (trans) {
            mSDTransactionName = (char *)trans->name;
        } else {
            mSDTransactionName = (char *)"UNKNOWN";
        }
    }

    char *currentStateName;
    if (currentState) {
        currentStateName = (char *)currentState->name;
    } else {
        currentStateName = (char *)"UNKNOWN";
    }

    char *lastCurrentStateName;
    if (lastCurrentState) {
        lastCurrentStateName = (char *)lastCurrentState->name;
    } else {
        lastCurrentStateName = (char *)"UNKNOWN";
    }

    snprintf(cbuf, sizeof(cbuf), "%s:>%s.%s%s%s &", lastCurrentStateName, currentStateName,
            mSDTransactionName,
            (mSDActionName ? "/" : ""),
            (mSDActionName ? mSDActionName : "")
    );
    mSDActionName = NULL;
    mSDTransactionName = NULL;
    SDPrint(cbuf);
    if (mSDEnterAction[0]) SDPrint(mSDEnterAction);
    mSDEnterAction[0] = 0;
    return 0;
}

int SMF::SDPrintEnterAction(tState *currentState)
{
    if (currentState) {
        snprintf(mSDEnterAction, sizeof(mSDEnterAction), "%s:>%s.Enter/ %s &", currentState->name, currentState->name, currentState->enterName);
    }
    return 0;
}

int SMF::SDPrintCondition(tState *currentState, tTransition *trans)
{
    char cbuf[printStringSize];

    snprintf(cbuf, sizeof(cbuf), "%s:>%s.Cond/ %s &", currentState->name, currentState->name, trans->conditionName);

    SDPrint(cbuf);
    return 0;
}

int SMF::SDPrintGuard(tState *currentState, tTransition *trans)
{
    char cbuf[printStringSize];

    snprintf(cbuf, sizeof(cbuf), "%s:>%s.Guard/ %s &", currentState->name, currentState->name, trans->guardName);

    SDPrint(cbuf);
    return 0;
}

int SMF::SDPrintExitAction(tState *currentState)
{
    char cbuf[printStringSize];

    snprintf(cbuf, sizeof(cbuf), "%s:>%s.Exit/ %s &", currentState->name, currentState->name, currentState->exitName);

    SDPrint(cbuf);
    return 0;
}

int SMF::SDPrintAction(tTransition *trans, int falseAction)
{
    // is it a transition with a condition?
    if (trans->cond == hasCondition) {
        if (falseAction == 0) {
            mSDTransactionName = (char *)trans->trueName;
            mSDActionName = (char *)trans->actionName;
        } else {
            mSDTransactionName = (char *)trans->falseName;
            mSDActionName = (char *)trans->elseActionName;
        }

        // for a normal action without condition
    } else {
        mSDTransactionName = (char *)trans->name;
        if (trans->actionName != NULL) {
            mSDActionName = (char *)trans->actionName;
        }
    }

    return 0;
}

int SMF::SDStartTransitionSection(void)
{
    SDPrint("ext:External[pe]");
    SDPrint("notConsumed:External[pe]");
    SDPrint("\n");
    return 0;
}

SMF::tState *SMF::_CreateState(const char *name, int stateID, tFn *entry, const char *entryName, tFn *exit, const char *exitName)
{
    ENTRY_INTERNAL
    tState *state;

    state = new tState();
    MP_FATAL_ASSERT(state != NULL);
    registerGC((void *)state, tStateGCType, 1);

    state->name = name;
    state->stateID = stateID;
    state->enter = entry;
    state->enterName = entryName;
    state->exit = exit;
    state->exitName = exitName;
    state->_this = this;

    return state;
}

/* class implementation */
SMF::tState *SMF::CreateState(const char *name, int stateID, tFn *entry, const char *entryName, tFn *exit, const char *exitName)
{
    ENTRY_INTERNAL
    tState *state;

    state = _CreateState(name, stateID, entry, entryName, exit, exitName);

    SDPrintState(state);

    return state;
}

SMF::tState *SMF::CreateHistoryState(const char *name)
{
    ENTRY_INTERNAL
    tState *state;

    state = _CreateState(name, -1, NULL, NULL, NULL, NULL);
    state->type = isHistoryState;
    return state;
}

SMF::tState *SMF::CreateForkState(const char *name)
{
    ENTRY_INTERNAL
    tState *state;

    state = _CreateState(name, -1, NULL, NULL, NULL, NULL);
    state->type = isForkState;
    SDPrintState(state);
    return state;
}

SMF::tState *SMF::CreateCompoundState(const char *name, int stateID, tFn *entry, const char *entryName, tFn *exit, const char *exitName)
{
    ENTRY_INTERNAL
    tState *state;

    state = CreateState(name, stateID, entry, entryName, exit, exitName);
    state->type = isCompoundState;

    return state;
}

SMF::tState *SMF::CreateFinalState(const char *name, int stateID, tFn *entry, const char *entryName)
{
    ENTRY_INTERNAL
    tState *state;

    state = CreateState(name, stateID, entry, entryName, NULL, NULL);
    state->type = isFinalState;

    return state;
}

void SMF::registerGC(void *ptr, tClassType type, int GCon)
{
    if (GCon) {
        lockGC.lock();
        pointersGC = (tPointerGC *)realloc(pointersGC, sizeof(tPointerGC) * (numberOfPointersGC+1));
        pointersGC[numberOfPointersGC].type = type;
        pointersGC[numberOfPointersGC].ptr = ptr;
        numberOfPointersGC++;
        lockGC.unlock();
    }
}


void SMF::freeGC()
{
    lockGC.lock();
    for(size_t i=0; i<numberOfPointersGC; i++) {
        switch(pointersGC[i].type) {
            case tEventGCType:
                delete (tEvent *)pointersGC[i].ptr;
                break;
            case tStateGCType:
                delete (tState *)pointersGC[i].ptr;
                break;
            case tTransitionGCType:
                delete (tTransition *)pointersGC[i].ptr;
                break;
            case tStateContextGCType:
                delete (tStateContext *)pointersGC[i].ptr;
                break;
        }
    }
    free(pointersGC);
    pointersGC = NULL;
    numberOfPointersGC = 0;
    lockGC.unlock();
}

SMF::tTransition *SMF::CreateTransition(const char *name, tFn *guard, const char *guardName, tFn *action, const char *actionName, tState *target, int GCon)
{
    ENTRY_INTERNAL
    tTransition *trans;

    trans = new tTransition();
    MP_FATAL_ASSERT (trans != NULL);
    registerGC((void *)trans, tTransitionGCType, GCon);

    trans->name = name;
    trans->guard = guard;
    trans->guardName = guardName;
    trans->action = action;
    trans->actionName = actionName;
    trans->target = (tState_tag *)target;
    trans->_this = this;

    return trans;
}

SMF::tTransition *SMF::CreateDefaultTransition(const char *name, tFn *guard, const char *guardName, tFn *action, const char *actionName, tState *target)
{
    ENTRY_INTERNAL
    tTransition *trans;

    trans = CreateTransition(name, guard, guardName, action, actionName, target);
    trans->type = isDefaultTransition;

    return trans;
}

SMF::tTransition *SMF::CreateEventTransition(tEvent *event, const char *name, tFn *guard, const char *guardName, tFn *action, const char *actionName, tState *target)
{
    ENTRY_INTERNAL
    tTransition *trans;

    trans = CreateTransition(name, guard, guardName, action, actionName, target);
    trans->type = isEventTransition;
    trans->event = event;

    return trans;
}

SMF::tTransition *SMF::CreateEventConditionalTransition(tEvent *event, const char *name, tState *conditionalPosition, tFn *guard, const char *guardName, tFn *condition, const char *conditionName,
        tFn *actionTrue, const char *actionTrueName, tFn *actionFalse, const char *actionFalseName,
        const char *trueName, tState *targetTrue, const char *falseName, tState *targetFalse)
{
    ENTRY_INTERNAL
    tTransition *trans;

    trans = CreateTransition(name, guard, guardName, actionTrue, actionTrueName, targetTrue);
    trans->type = isEventTransition;
    trans->cond = hasCondition;
    trans->condition = condition;
    trans->conditionName = conditionName;
    trans->conditionalPosition = (tState_tag *)conditionalPosition;
    trans->elseAction = actionFalse;
    trans->elseActionName = actionFalseName;
    trans->elseTarget = (tState_tag *)targetFalse;
    trans->trueName = trueName;
    trans->falseName = falseName;
    trans->event = event;

    return trans;
}
SMF::tTransition *SMF::CreateHistoryTransition(const char *name, tFn *guard, const char *guardName, tFn *action, const char *actionName, tState *target)
{
    ENTRY_INTERNAL
    tTransition *trans;

    trans = CreateTransition(name, guard, guardName, action, actionName, target);
    trans->type = isHistoryTransition;

    return trans;
}

int SMF::AddTransition(tState *state, tTransition *trans)
{
    ENTRY_INTERNAL
    /* is it a event transition? */
    if (trans->type == isEventTransition) {

        trans->event->state.push_back((tState_tag *)state);
        trans->event->noOfStates++; // shortcut for later for loop
        trans->event->trans.push_back((tTransition_tag *)trans);
        trans->event->noOfTrans++; // shortcut for later for loop

        state->transitions.push_back(trans);
        state->noOfTransitions++; // shortcut for later for loop
        trans->source = (tState_tag *)state;

        /* inner transition to compound */
        if (trans->target == NULL) {
            trans->pos = isInnerTransition;
        }

        return 0;

        /* it is a normal transition */
    } else {
        state->transitions.push_back(trans);
        state->noOfTransitions++; // shortcut for later for loop
        trans->source = (tState_tag *)state;

        switch(trans->type) {
            case isHistoryTransition:
                state->hasHistory = 1;
                break;
            default:
                /* inner transition to compound */
                if (trans->target == NULL) {
                    trans->pos = isInnerTransition;
                }
                break;
        }

        return 0;
    }
}

int SMF::AddState(tState *toCompoundState, tState *state)
{
    ENTRY_INTERNAL
    MP_FATAL_ASSERT(toCompoundState->type == isCompoundState);
    state->compound = toCompoundState;
    return 0;
}

void SMF::SetRoot(tState *state)
{
    ENTRY_INTERNAL

    /* set the root state of all */
    mRootState = state;

    /* set the root context as active always */
    state->context->active = 1;

    /* set the current state in its context */
    state->context->currentState = state;

    /* set the compound state */
    state->context->compoundState = state;

    /* set the default current context to the root context */
    mCurrentContext = state->context;
}

void SMF::SetConcurrent(tState *state)
{
    ENTRY_INTERNAL

    /* this state holds a context for all its children */
    state->holdsContext = 1;

    /* create the context */
    state->context = new tStateContext();
    registerGC((void *)state->context, tStateContextGCType, 1);

    state->hasContext = 1; // this state holds a context

    /* add it to the context directory for looping over all contexts */
    mContextDirectory.push_back(state->context);

    /* set the internal queue name */
    state->context->MQInternalName = new char[strlen_r("/mq_in_") + strlen_r(mSMFullName) + 1 + strlen_r(state->name) + 1];
    strcpy((char *)state->context->MQInternalName, "/mq_in_");
    strcat((char *)state->context->MQInternalName, mSMFullName);
    strcat((char *)state->context->MQInternalName, "_");
    strcat((char *)state->context->MQInternalName, state->name);

    /* some values for message/answer handling */
    state->context->AnswerTimeoutValue = AnswerTimeOutValue;
    state->context->AnswerTimerID = 0;
    state->context->SpecialAnswerTimeoutValue = -1;

    /* set the current state */
    state->context->currentState = state;
    state->context->compoundState = state;
}

int SMF::_Reset()
{
    ENTRY_INTERNAL

    if (mRootState) {

        /* reset the root state */
        SetRoot(mRootState);

        /* reset the inited states */
        for(unsigned int i=0; i<mInitedStates.size(); i++) {
            mInitedStates[i]->init = mInitedStates[i]->backupInit;
        }

        return 0;
    }

    return MP_ERR_SM_RESET_FAILED;
}

int SMF::Reset(const void *userContext)
{
    ENTRY_INTERNAL

    return Init(userContext); // includes a reset if state machine was init'ed before
}

int SMF::Init(const void *userContext)
{
    ENTRY_INTERNAL
    int ret = 0;


    /* clear obsolete events from previous */
    if(mMQExternal) mMQExternal->Flush();

    // is this state machine already been initialized?
    if (mIsCreated) {

        // then do a reset of this state machine first
        ret = _Reset();
        if (ret) return ret;
    }

    /* set the user context pointer */
    mUserContext = userContext;

    /*
     * do the very first init of this state machine
     */
    CreateComponent();

    SDStartTransitionSection(); // start transistions in SD diagram

    /* the root is always the start of Init */
    tState *compoundState = (tState *)mRootState->context->compoundState;

    /* check if enter action is defined */
    PrintEnter(compoundState);
    if (compoundState->enter) {
        SDPrintEnterAction((tState *)mRootState->context->currentState);
        (compoundState->enter)(compoundState);
    }

    /* check if init has to be run */
    if ((tTransition *)compoundState->init) {
        tTransition *init = compoundState->init;
        compoundState->init = NULL;

        ret = DoTransition(init);

        mIsCreated = 1;

        return 0;
    }

    return MP_ERR_SM_NO_INIT_TRANSITION_IN_STATEMACHINE_DEFINITION;
}

int SMF::IsPartOf(tState *target, tState *compound)
{
    ENTRY_INTERNAL
    if (target->compound == compound) return 1;
    else return 0;
}

SMF::tStateContext *SMF::GetStateContext(tState *state)
{
    ENTRY_INTERNAL

    /* check if a context already found */
    if (state->context) {
        return state->context;
    }

    /* find a state in the parents where the context is already set */
    tState *stateSearch = state->compound;
    vector<tState *> statesWithoutContexts;
    while(stateSearch->context == NULL) {
        statesWithoutContexts.push_back(stateSearch);
        stateSearch = stateSearch->compound;
    }

    /* set the context in the requested state*/
    state->context = stateSearch->context;

    /* set the context in all states which were passed by and did not have a context already */
    for(int i=0; i<(int)statesWithoutContexts.size(); i++) {
        statesWithoutContexts[i]->context = stateSearch->context;
    }

    return state->context;
}

int SMF::DoTransition(tTransition *trans)
{
    ENTRY_INTERNAL
    //int ret;
    tState  *target = (tState *)trans->target;

    /*
     * Get source context
     */
    /* get the source state */
    tState  *sourceState = (tState *)trans->source;
    if (sourceState == NULL) { // if source is NULL: special startup transition, take target as context holder
        sourceState = (tState *)trans->target;
    }
    tStateContext *sourceContext = GetStateContext(sourceState);
    mCurrentContext = sourceContext;

    /* activate the new context */
    sourceContext->active = 1;

    /* pointer to current state and compound state holder for this transition */
    tState **currentStateStorage = (tState **)&(sourceContext->currentState);
    tState **compoundStateStorage = (tState **)&(sourceContext->compoundState);

    /*
     * Get target context
     */
    /* get the target state */
    tState  *targetState = target;
    if (targetState == NULL) { // if target is NULL then internal transition is meant, so source state has context
        targetState = (tState *)trans->source;
    }
    tStateContext *targetContext = GetStateContext(targetState);

    /* activate the new target context */
    targetContext->active = 1;

    tFn *action = trans->action;

    tState *lastCurrentState = *currentStateStorage; /* remember last current event for state tracing */
    if (!lastCurrentState) lastCurrentState = *compoundStateStorage;

    tState *stateRoot = NULL; // root state for both other states
    vector<tState *> wayToToState; /* reverse way for to-state to go from root */
    int isExternalSelfTransition = 0; /* this is set if a transition is an external self transition */

    /* set member var for advanced debugging of smf to current transition */
    mCurrentTrans = trans;

    /* check guard */
    PrintGuard(trans);
    if (trans->guard) {
        SDPrintGuard(*currentStateStorage, trans);
        if ((trans->guard)(trans) == 0) {
            return 0;
        }
    }

    /*
     * if it is a condition, set the target out of the position of the condition bubble
     */
    if (trans->cond == hasCondition) {

        /* set a new target: the position of the conditional bubble */
        target = (tState *)trans->conditionalPosition;
    }

    /*
     * if the target is set to the source and it is no condition, then it is a self transition, which is outside of the state
     */
    if (target == (tState *)trans->source && trans->cond == hasNoCondition) {

        /* remember that for the further processing of exit and enter */
        isExternalSelfTransition = 1;
    }

    /*
     * if the target of transition is NULL, it is meant as an internal transition.
     * no enter or exists nor any other stuff is to be done.
     */
    if (target == NULL) {

        /* call the action for the transition */
        PrintAction(trans);
        SDPrintAction(trans, 0);
        if (action) {

            /* retry loop on error */
            while(1) {
                tResult error;
                if ((error = (action)(trans)) == 0) break;
                if (ErrorHandler(error, trans, trans->actionName)) break; // the current state remains the same, even it is an error
            }
        }

        SDPrintStateTransition(*currentStateStorage, *compoundStateStorage, lastCurrentState, trans);

        /* end here */
        return 0;
    }

    /*
     * do all exits
     */

    /*
     * find the common root for the current state and the target state
     */
    tState *stateFrom;
    tState *stateTo;

    /* the current state is the beginning of the search */
    stateFrom = (tState *)*currentStateStorage;

    /*
     * do it as long as there is a compound state above the current state
     */
    while(stateFrom->compound) {

        /* search in other tree if this compound is also in */
        stateTo = target;

        /* reset the way back list because last time it were not the right way back */
        wayToToState.clear();

        /* walk through the tree */
        while(stateTo->compound) {

            /* compare the from and to state */
            if (stateFrom == stateTo) {

                /* root compound found */
                stateRoot = stateFrom;

                /* break this loop */
                break;
            }

            /* remember way back */
            wayToToState.push_back(stateTo);

            /* step back one compound */
            stateTo = stateTo->compound;
        }

        /* break if root state found */
        if (stateRoot) {
            if(stateRoot != target && sourceState != target) { //GMMY17-13023
                /* pump all delayed events if the old state to main external queue */
                TransferDelayedEvents(stateRoot);
            }
            break;
        }

        /* store the currently leaved state as history in its compound state */
        if (stateFrom->compound) {
            if (stateFrom->compound->hasHistory) {
                stateFrom->compound->history = stateFrom;
            }
        }

        /*
         * do exits only if source and target context are the same and the state was entered before
         */
        if (sourceContext == targetContext && stateFrom->entered) {

            /* do the exit transition of the currently leaved state */
            PrintExit(stateFrom);
            if (stateFrom->exit) {
                SDPrintExitAction(*currentStateStorage);

                /* retry loop on error */
                while(1) {
                    tResult error;
                    if ((error = (stateFrom->exit)(stateFrom)) == 0) break;
                    if (ErrorHandler(error, trans, stateFrom->exitName)) break;
                }
            }

            /* this state was exited now */
            stateFrom->entered = 0;

            /* pump all delayed events if the old state to main external queue */
            TransferDelayedEvents(stateFrom);
        }

        /* step back one state and try another search */
        stateFrom = stateFrom->compound;

        /*
         * re-set the current state only if the target state has the same context
         */
        if (sourceContext == targetContext) {

            /* correct the current state and the compound state members */
            *currentStateStorage = stateFrom;
            *compoundStateStorage = (*currentStateStorage)->compound;
        }
    }

    /*
     * if it is an external self transition, do the specific exit here
     */
    if (isExternalSelfTransition) {

        /* do this only if state was entered before */
        if ((*currentStateStorage)->entered) {

            PrintExit(*currentStateStorage);
            if ((*currentStateStorage)->exit) {
                SDPrintExitAction(*currentStateStorage);

                /* retry loop on error */
                while(1) {
                    tResult error;
                    if ((error = ((*currentStateStorage)->exit)(*currentStateStorage)) == 0) break;
                    if (ErrorHandler(error, trans, (*currentStateStorage)->exitName)) break;
                }
            }

            /* this state was exited now */
            (*currentStateStorage)->entered = 0;

            /* pump all delayed events if the old state to main external queue */
            TransferDelayedEvents((*currentStateStorage));
        }

        /* and set the stateRoot to NULL to force an entry */
        stateRoot = NULL;
    }

    /*
     * change context to target context (may be the same as source context)
     * switch the Storages
     * switch the mCurrentContext
     */
    mCurrentContext = targetContext;
    currentStateStorage = (tState **)&(targetContext->currentState);
    compoundStateStorage = (tState **)&(targetContext->compoundState);

    /*
     * set the target state as current state (but is not reached yet)
     */
    *currentStateStorage = target;
    *compoundStateStorage = (*currentStateStorage)->compound;

    /*
     * do the action
     *
     * now we have leaved all states that where necessary. Next step is to call the action for
     * the transition. If it is a conditional, there is a special processing:
     */
    if (trans->cond == hasCondition) {

        PrintConditionAction(trans);
        if (trans->condition) {

            tTransition *conditionalResult;

            SDPrintStateTransition(*currentStateStorage, *compoundStateStorage, lastCurrentState, trans);
            SDPrintCondition(*currentStateStorage, trans);

            /* set the artificial conditional result transition after the result of the conditional callback */
            if ((trans->condition)(trans)) {

                /* on true, take the original target */
                conditionalResult = CreateTransition("TRUE", NULL, NULL, trans->action, trans->actionName, (tState *)trans->target, 0 /* no GC */);
            } else {

                /* on false, take the else-target */
                conditionalResult = CreateTransition("FALSE", NULL, NULL, trans->elseAction, trans->elseActionName, (tState *)trans->elseTarget, 0 /* no GC */);
            }

            /* set the parameter to this new transition */
            conditionalResult->arguments = trans->arguments;

            /* do the conditional result as a new internal transition */
            /*ret = */DoTransition(conditionalResult);

            /* free the artificial transition */
            delete  conditionalResult;

            /* break recursion */
            goto exit_function_noprint;
        }

        /* normal action */
    } else {

        /* call the action for the transition */
        PrintAction(trans);
        SDPrintAction(trans, 0);
        if (action) {

            /* retry loop on error */
            while(1) {
                tResult error;
                if ((error = (action)(trans)) == 0) break;
                if (ErrorHandler(error, trans, trans->actionName)) break;
            }
        }
    }

    /*
     * do all enters on the way to the target state:
     */

    /*
     * was a root state found before? than it was no internal transition and there should be a way to the target state
     */
    if (stateRoot) {

        /* go way forward to the target state */
        for (int i = (int)wayToToState.size()-1; i >= 0; i--) {

            /* do the enters only if state was not already entered */
            if (!wayToToState[i]->entered) {

                /* do the enter actions for all compounds */
                PrintEnter(wayToToState[i]);

                if (wayToToState[i]->enter) {
                    SDPrintEnterAction(*currentStateStorage);

                    /* retry loop on error */
                    while(1) {
                        tResult error;
                        if ((error = (wayToToState[i]->enter)(wayToToState[i])) == 0) break;
                        if (ErrorHandler(error, trans, wayToToState[i]->enterName)) break;
                    }
                }

                /* this state was entered now */
                wayToToState[i]->entered = 1;
            }

            /* correct the current state and the compound state members */
            *currentStateStorage = wayToToState[i];
            *compoundStateStorage = (*currentStateStorage)->compound;
        }

        /* is no root state */
    } else {

        /*
         * set the target state as current state (now it is reached)
         */
        *currentStateStorage = target;
        *compoundStateStorage = (*currentStateStorage)->compound;

        /* do an enter only if it was not already entered */
        if (!(*currentStateStorage)->entered) {

            /* do the enter of the target state itself */
            PrintEnter(*currentStateStorage);
            if ((*currentStateStorage)->enter) {
                SDPrintEnterAction(*currentStateStorage);

                /* retry loop on error */
                while(1) {
                    tResult error;
                    if ((error = ((*currentStateStorage)->enter)(*currentStateStorage)) == 0) break;
                    if (ErrorHandler(error, trans, (*currentStateStorage)->enterName)) break;
                }
            }

            /* this state was entered now */
            (*currentStateStorage)->entered = 1;
        }
    }

    /*
     * do the special transition INIT if needed
     */
    if ((tTransition *)(*currentStateStorage)->init) {

        /* set the generated init transition */
        tTransition *init = (*currentStateStorage)->init;

        /* remember: init is done now */
        (*currentStateStorage)->init = NULL;

        SDPrintStateTransition(*currentStateStorage, *compoundStateStorage, lastCurrentState, trans);

        /* do the init transition */
        /*ret = */DoTransition(init);

        /* break recursion */
        goto exit_function_noprint;
    }

    SDPrintStateTransition(*currentStateStorage, *compoundStateStorage, lastCurrentState, trans);

    /*
     * do the special state HISTORY, if needed:
     */
    if ((*currentStateStorage)->hasHistory && (*currentStateStorage)->history) {

        /* generate an artificial history transition */
        tTransition *history = CreateTransition("history", NULL, "", NULL, "", (*currentStateStorage)->history, 0 /* no GC */);

        /* do the history transition */
        /*ret = */DoTransition(history);

        delete history;

        /* break recursion */
        goto exit_function_noprint;
    }

    exit_function_noprint:

    /* check if the final state is a fork state, tha: do the first outgoing transition */
    if ((*currentStateStorage)->type == isForkState) {
        tTransition *fromFork = (*currentStateStorage)->transitions[0];
        DoTransition(fromFork);
    }

    /* check if final state of top context */
    if ((*currentStateStorage)->type == isFinalState)
    {
        /* stop an running answer timer */
        if (targetContext->AnswerTimerID) {
            targetContext->AnswerTimer.CancelTimer(IN targetContext->AnswerTimerID);
            ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s, id=%d", mSMFullName, (int)((long)targetContext->AnswerTimerID)));
            targetContext->AnswerTimerID = 0;
        }

        /* remove all enter states for all states from final state to top of current context */
        tState *leaveState = (tState *)(*currentStateStorage); // starting at final state
        while(leaveState) {

            /* reset the entered flag for this state */
            leaveState->entered = 0;

            /* if top of context reached, break */
            if (leaveState->hasContext) break;

            /* go one step up to next parent */
            leaveState = leaveState->compound;
        }

        /* if the top state context reaches the final state: end the state machine */
        if (targetContext == mRootState->context) {
            return STATE_MACHINE_FINISHED;

            /* if a concurrent state reaches the final state: deactivate the context */
        } else {
            targetContext->active = 0;
        }
    }

    /* reset current context to root context */
    mCurrentContext = mRootState->context;

    /* no final state, return 0 */
    return 0;
}

void SMF::SetInitTransition(tState *state, tTransition *trans)
{
    ENTRY_INTERNAL
    MP_FATAL_ASSERT(state != NULL);
    state->init = trans;
    state->backupInit = trans;
    mInitedStates.push_back(state);
}

SMF::tEvent *SMF::CreateEventInternal(const char *name, int GCon)
{
    ENTRY_INTERNAL
    tEvent *event;

    event = new tEvent();
    MP_FATAL_ASSERT(event != NULL);
    registerGC((void *)event, tEventGCType, GCon);

    event->name = name;

    return event;
}

SMF::tEvent *SMF::CreateEvent(const char *name)
{
    tEvent *event;

    /* create the event */
    event = CreateEventInternal(name);
    if (!event) return NULL;

    /* store this event also in the knownEvent table to establish event sending by name */
    mKnownEvents.push_back(event);
    // debug printf("mKnownEvents.size()=%d\n", mKnownEvents.size());

    return event;
}

int SMF::SetSMName(const char *name)
{
    ENTRY_INTERNAL

    if (mSMName) delete[] mSMName;
    mSMName = new char[strlen_r(name) + 1];
    strcpy((char *)mSMName, name);

    if (mSMFullName) delete[] mSMFullName;
    mSMFullName = new char[strlen_r(name) + strlen_r(mSMNamePostfix) + 3];
    strcpy((char *)mSMFullName, name);
    strcat((char *)mSMFullName, "(");
    strcat((char *)mSMFullName, mSMNamePostfix);
    strcat((char *)mSMFullName, ")");

    if (mMQExternalName) delete[] mMQExternalName;
    mMQExternalName = new char[strlen_r("/mq_ex_") + strlen_r(mSMFullName) + 1];
    strcpy((char *)mMQExternalName, "/mq_ex_");
    strcat((char *)mMQExternalName, mSMFullName);

    return 0;
}

const char* SMF::GetSMName(void)
{
    ENTRY_INTERNAL
    return mSMName;
}

const char* SMF::GetSMNameFull(void)
{
    return mSMFullName;
}

int SMF::GetState(void)
{
    ENTRY_INTERNAL

    if (mRootState) {
        if (mRootState->context) {
            if(mRootState->context->currentState) {
                tState *currentState = (tState *)mRootState->context->currentState;
                return currentState->stateID;
            }
        }
    }

    return MP_ERR_SM_NO_CURRENT_STATE;
}

void SMF::GetCurrentState(char *stateName, size_t size)
{
    ENTRY_INTERNAL
    strncpy(stateName, "no-state", size);

    if (mRootState) {
        if (mRootState->context) {
            if(mRootState->context->currentState) {
                tState *currentState = (tState *)mRootState->context->currentState;
                if (currentState->name) {
                    strncpy(stateName, currentState->name, size);
                }
            }
        }
    }
}

const char *SMF::GetCurrentState()
{
    ENTRY_INTERNAL

    if (mRootState) {
        if (mRootState->context) {
            if(mRootState->context->currentState) {
                tState *currentState = (tState *)mRootState->context->currentState;
                if (currentState->name) {
                    return currentState->name;
                }
            }
        }
    }

    return NULL;
}

tResult SMF::IsInState(tInteger stateEnum)
{
    ENTRY_INTERNAL

    if (mRootState) {
        if (mRootState->context) {
            if(mRootState->context->currentState) {
                tState *current = (tState *)mRootState->context->currentState;

                while(current) {
                    if (current->stateID == stateEnum) return 1;
                    current = current->compound;
                }
            }
        }
    }

    return 0;
}

int SMF::CreateComponent()
{
    ENTRY_INTERNAL

    if (!mMQExternal) mMQExternal = new MessageQueue(mMQExternalName);      // create external queue

    /* create internal queues for all contexts */
    for(int i=0; i<(int)mContextDirectory.size(); i++) {
        tStateContext *context = mContextDirectory[i];
        if (!context->MQInternal) context->MQInternal = new MessageQueue(context->MQInternalName);      // create internal queue
    }

    return 0;
}

int SMF::DecreateComponent()
{
    ENTRY_INTERNAL

    /* loop over all contexts */
    for(int iContext=0; iContext<(int)mContextDirectory.size(); iContext++) {
        tStateContext *context = mContextDirectory[iContext];

        /* cancel a possibly running timer */
        if (context->AnswerTimerID) {
            context->AnswerTimer.CancelTimer(IN context->AnswerTimerID);
            ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s / ctx=%d, id=%d", mSMFullName, iContext, (int)((long)context->AnswerTimerID)));
            context->AnswerTimerID = 0;
        }
    }

    /* flush all queues */
    mMQExternal->Flush();

    /* flush internal queues for all contexts */
    for(int i=0; i<(int)mContextDirectory.size(); i++) {

        tStateContext *context = mContextDirectory[i];
        context->MQInternal->Flush();

        /* Release lock status */
        context->LockStatus = MessageAnswerUnlock;
    }

    return 0;
}

int SMF::SendEvent(const tEvent *event, const int priority ,const char *parameters)
{
    ENTRY
    int ret;
    void *Sendbuf;
    size_t bufferSize;

    MP_FATAL_ASSERT(event != NULL);

    // check if queue is available
    if (!mMQExternal)
    {
        ETG_TRACE_FATAL(("SendEvent: external queue not created or already decreated due to end of SM"));
        return MP_ERR_SM_NO_EXTERNAL_QUEUE;
    }

    // sendBuffer
    if (parameters) {
        bufferSize = strlen_r(event->name) + strlen_r(parameters) +2;
        Sendbuf = mMQExternal->CreateMessageBuffer(bufferSize);
        if (!Sendbuf) return MP_ERR_SM_NO_MEM_FOR_QUEUE_MESSAGE;
        strcpy((char *)Sendbuf, event->name);
        strcat((char *)Sendbuf, " ");
        strcat((char *)Sendbuf, parameters);
    }else{
        bufferSize = strlen_r(event->name) +1;
        Sendbuf = mMQExternal->CreateMessageBuffer(bufferSize);
        if (!Sendbuf) return MP_ERR_SM_NO_MEM_FOR_QUEUE_MESSAGE;
        strcpy((char *)Sendbuf,event->name);
    }

    /* send the message, internal retry loop */
    int retry = mRetryCount;
    while(1) {

        /* try to send message */
        ret = mMQExternal->Push(Sendbuf,bufferSize, priority);
        if (ret != 0) {
            ETG_TRACE_ERR(("Message: %127s can't be sent to queue: %127s",(char *)Sendbuf, mMQExternalName));
        } else {
            break;
        }

        /* do another retry? */
        if (!retry) break;
        ETG_TRACE_ERR(("retry sending to queue: %s", mMQExternalName));
        retry--;

        /* sleep before retry */
        usleep(mUSSleepTime);
    }
#if OLD_IMPL
    // dropBuffer
    mMQExternal->DropMessage(Sendbuf);
#endif

    return ret;
}

int SMF::SendEvent(const tEvent *event, const char *parameters)
{
    ENTRY
    int ret;
    ret = SendEvent(event, Priority_Internal, parameters);
    return ret;
}

int SMF::SendEventToResultInternal(const tEvent *event, const char *parameters)
{
    ENTRY
    int ret;
    ret = SendEvent(event, Priority_External_Resulting_Internal, parameters);
    return ret;
}

int SMF::SendUrgentEvent(const tEvent *event, const char *parameters)
{
    ENTRY
    int ret;
    ret = SendEvent(event, Priority_Urgent, parameters);
    return ret;
}

int SMF::SendForceEvent(const tEvent *event, const char *parameters)
{
    ENTRY

    /* flush the content of the external queue */
    mMQExternal->Flush();

    return SendUrgentEvent(event, parameters);
}

int SMF::SendEventByName(const char *eventName, const char *parameters)
{
    ENTRY
    unsigned int i;
    int ret = SMF_ERR_UNKNOWN_EVENT;

    //TODO: Use SendInternalEventByName (Priority_Internal) for all SendEventByName calls
    /* search for event */
    for (i=0; i<mKnownEvents.size(); i++) {
        // debug printf("mKnownEvents[i]->name: %s\n", mKnownEvents[i]->name);
        if (!strcmp(mKnownEvents[i]->name, eventName)) {
            ret = SendEvent(mKnownEvents[i], Priority_External, parameters);
            break;
        }
    }
    return ret;
}

int SMF::RemoveMessageByName(MessageQueue *queue, const char *messageName)
{
    ENTRY;

    /*
     * remove all messages from the input queue which matches the name given
     */

    /* lock the queue to gain full access */
    queue->DoLock();

    /* loop over all messages to find the ones to be deleted */
    int iMessageNumber = 0;
    // Debug printf("RemoveMessageByName: messageName=%s\n", messageName); fflush(stdout);
    while(true) {

        /* get a message */
        size_t rec_bytes = 0;
        void * RecordBuffer = queue->Peek(iMessageNumber, &rec_bytes);

        /* no more messages */
        if (!RecordBuffer) {
            // Debug printf("RemoveMessageByName: iMessageNumber=%d, no more messages\n", iMessageNumber); fflush(stdout);
            break;
        }
        // Debug printf("RemoveMessageByName: iMessageNumber=%d, RecordBuffer=%s\n", iMessageNumber, (char *)RecordBuffer); fflush(stdout);

        /* check if the message name is present */
        if (!strncmp((const char *)RecordBuffer, messageName, strlen_r(messageName))) {

            // Debug printf("RemoveMessageByName: message found\n"); fflush(stdout);

            /* remove this message from queue (all others are shifted so the iMessageNumber must not be increased) */
            queue->Remove(iMessageNumber);

        } else {
            /* try next message */
            iMessageNumber++;
        }

#if OLD_IMPL
        /* free memory for RecordBuffer */
        free(RecordBuffer);
#endif
    }

    /* unlock the queue */
    queue->UnLock();

    return MP_NO_ERROR;
}


int SMF::RemoveMessageByName(const char *messageName)
{
    ENTRY;

    /* emove all messages from the input queue which matches the name given */
    RemoveMessageByName(mMQExternal, messageName);

    /* remove all messages from all known delay queues */
    for(unsigned int i=0; i<mAllDelayQueues.size(); i++) {
        RemoveMessageByName(mAllDelayQueues[i], messageName);
    }

    return MP_NO_ERROR;
}

int SMF::SendInternalEventByName(const char *eventName, const char *parameters)
{
    ENTRY
    unsigned int i;
    int ret = SMF_ERR_UNKNOWN_EVENT;

    /* search for event */
    for (i=0; i<mKnownEvents.size(); i++) {
        // debug printf("mKnownEvents[i]->name: %s\n", mKnownEvents[i]->name);
        if (!strcmp(mKnownEvents[i]->name, eventName)) {
            ret = SendEvent(mKnownEvents[i], Priority_Internal, parameters);
            break;
        }
    }
    return ret;
}

int SMF::SendAnswer(const char *argument)
{
    ENTRY

    char *answer;
    char *answer_msg;
    int to = 10000L; // wait time out for the answer message fetched out of queue
    int res = MP_NO_ERROR;

    /* check if current context active */
    if (!mCurrentContext) {
        ETG_TRACE_ERR(("SendAnswer: no current context"));
        return MP_ERR_SM_NO_CURRENT_CONTEXT;
    }

    // check if queue is created
    if (!mCurrentContext->MQInternal) {
        ETG_TRACE_FATAL(("SendAnswer: internal queue not created"));
        return MP_ERR_SM_NO_INTERNAL_QUEUE;
    }

    answer=(char *)ReadMQmessage(mCurrentContext->MQInternal, "mMQInternal");
    if(answer != NULL)
    {
        string str (answer);
        size_t messagePos = str.find("::");     /* message position    */
        ETG_TRACE_USR3(("SMF::SendAnswer Value of answer %s",answer));
        if(messagePos != string::npos)
        {

            // read answer from internal queue
            answer=(char *)GetMQmessage(mCurrentContext->MQInternal, "mMQInternal", to);

            // got answer?
            if (answer != NULL) {

                // arguments provided?
                if(argument != NULL) {

                    // assemble answer message
                    answer_msg = new char[strlen_r(answer)+strlen_r(argument)+2];
                    strcpy(answer_msg, answer);
                    strcat(answer_msg, " ");
                    strcat(answer_msg, argument);

                    // send it
                    res = Dispatcher::GetInstance().SendMessage(answer_msg);
                    delete[] answer_msg;

                    // no arguments provided
                } else {

                    // send it
                    res = Dispatcher::GetInstance().SendMessage(answer);
                }

                // free the read message
                mCurrentContext->MQInternal->DropMessage(answer);

                // unlock the message / answer mechanism
                mCurrentContext->LockStatus = MessageAnswerUnlock;
                ETG_TRACE_USR1(("SendAnswer: SM %24s: Unlock [MAQueue] for %s", GetSMNameFull(), mCurrentContext->LockMessage));

                //Send an NULL_EVENT to external queue to allow processing of internal queue once external queue is processed
                SendEvent(mNULL_EVENT,NULL);

                return res;

                // error: no message in internal queue
            } else {

                // unlock mechanism and report error
                mCurrentContext->LockStatus = MessageAnswerUnlock;
                ETG_TRACE_ERR (("SendAnswer: SM %24s: Answer event in internal queue expected - but not found / Unlock [MAQueue] for %s", GetSMNameFull(), mCurrentContext->LockMessage));

                return MP_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND;
            }
        }
        else
        {
            return MP_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND;
        }
    }
    else
    {
        return MP_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND;
    }
    return res;
}

int SMF::SendActionError(const char *argument)
{
    ENTRY

    char *answer;
    char *error;
    char *error_msg;
    int to = 10000L; // wait time out for the answer message fetched out of queue
    int res;

    /* check if current context active */
    if (!mCurrentContext) {
        ETG_TRACE_ERR(("SendAnswer: no current context"));
        return MP_ERR_SM_NO_CURRENT_CONTEXT;
    }

    // check if queue is created
    if (!mCurrentContext->MQInternal) {
        ETG_TRACE_FATAL(("SendAnswer: internal queue not created for SM %s", GetSMNameFull()));
        ETG_TRACE_ERRMEM(("SendAnswer: internal queue not created for SM %s", GetSMNameFull()));
        return MP_ERR_SM_NO_INTERNAL_QUEUE;
    }

    // read answer from internal queue
    answer=(char *)GetMQmessage(mCurrentContext->MQInternal, "mMQInternal", to);

    // got answer?
    if (answer != NULL) {

        // generate error answer event
        const char *eventName = "ACTION_ERROR";
        error = new char[strlen_r(answer)+strlen_r(eventName)+1];
        strcpy(error, answer);
        // extract event from error message
        char *errorEvent = strstr(error, "::");
        if(errorEvent)
        {
            errorEvent = errorEvent + 2;
            strcpy(errorEvent, eventName);
        }

        // arguments provided?
        if(argument != NULL) {

            // assemble answer message
            error_msg = new char[strlen_r(error)+strlen_r(argument)+2];
            strcpy(error_msg, error);
            strcat(error_msg, " ");
            strcat(error_msg, argument);

            // send it
            res = Dispatcher::GetInstance().SendMessage(error_msg);
            delete[] error_msg;

            // no arguments provided
        } else {

            // send it
            res = Dispatcher::GetInstance().SendMessage(error);
        }

        delete[] error;

        // free the read message
        mCurrentContext->MQInternal->DropMessage(answer);

        // unlock the message / answer mechanism
        mCurrentContext->LockStatus=MessageAnswerUnlock;
        ETG_TRACE_USR1(("SendActionError: SM %24s: Unlock [MAQueue] for %s", GetSMNameFull(), mCurrentContext->LockMessage));

        //Send an NULL_EVENT to external queue to allow processing of internal queue once external queue is processed
        SendEvent(mNULL_EVENT,NULL);

        return res;

        // error: no message in internal queue
    } else {

        // unlock mechanism and report error
        mCurrentContext->LockStatus=MessageAnswerUnlock;
        ETG_TRACE_ERR (("SendActionError: SM %24s: Answer event in internal queue expected - but not found / Unlock [MAQueue] for %s", GetSMNameFull(), mCurrentContext->LockMessage));

        return MP_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND;
    }
}

int SMF::SendEventAnswerByName(const char *eventName, const char *eventAnswerName ,const char *parameters)
{
    ENTRY
    unsigned int i;
    int ret = SMF_ERR_UNKNOWN_EVENT;

    /* search for event */
    for (i=0; i<mKnownEvents.size(); i++) {
        // debug printf("size=%d, name=\n", mKnownEvents.size())
        if (!strcmp(mKnownEvents[i]->name, eventName)) {
            ret = SendEventAnswer(mKnownEvents[i], eventAnswerName,parameters);
            break;
        }
    }

    return ret;
}

tResult SMF::ErrorHandler(const tResult error, const tTransition *trans, const char *fnName)
{
    ENTRY
    ETG_TRACE_ERR(("error=%d, transition=%64s, fnName=%64s", error, trans->name, fnName));
    //MP_NORMAL_ASSERT(0);
    return MP_ERR_SM_GENERAL_ERROR;
}

int SMF::SendEventAnswer(const tEvent *event, const char *answer,const char *parameters)
{
    ENTRY
    int ret;
    void *Sendbuf;
    size_t bufferSize;

    MP_FATAL_ASSERT(event != NULL);
    MP_FATAL_ASSERT(answer != NULL);

    /* loop over all active contexts */
    for (int iContext=0; iContext<(int)mContextDirectory.size(); iContext++) {

        tStateContext *context = mContextDirectory[iContext];

        /* is context active? */
        if (!context->active) {
            continue;
        }

        // check if queue is available
        if (!context->MQInternal)
        {
            ETG_TRACE_FATAL(("SendEventAnswer: internal queue not created or already decreated due to end of SM %s", GetSMNameFull()));
            ETG_TRACE_ERRMEM(("SendEventAnswer: internal queue not created or already decreated due to end of SM %s", GetSMNameFull()));
            return MP_ERR_SM_NO_INTERNAL_QUEUE;
        }

        /*Lock*/
        context->MQInternalLock.lock();

        // sendBuffer
        if (parameters) {
            bufferSize = strlen_r(event->name) + strlen_r(parameters) +2;
            Sendbuf = context->MQInternal->CreateMessageBuffer(bufferSize);
            strcpy((char *)Sendbuf, event->name);
            strcat((char *)Sendbuf, " ");
            strcat((char *)Sendbuf, parameters);
        }else{
            bufferSize = strlen_r(event->name) +1;
            Sendbuf = context->MQInternal->CreateMessageBuffer(bufferSize);
            strcpy((char *)Sendbuf, event->name);
        }

        ret = context->MQInternal->Push(Sendbuf,bufferSize, Priority_Internal);
        if (ret != 0) {
            ETG_TRACE_ERR(("Message:%127s can't be sent to queue: %127s",(char *)Sendbuf,context->MQInternalName));
        }

#if OLD_IMPL
        // dropBuffer
        context->MQInternal->DropMessage(Sendbuf);
#endif
        // send answer into queue
        Sendbuf = context->MQInternal->CreateMessageBuffer(strlen_r(answer)+1);
        strcpy((char *)Sendbuf, answer);

        ret = context->MQInternal->Push(Sendbuf, strlen_r(answer)+1,Priority_Internal);
        if (ret != 0) {
            ETG_TRACE_ERR(("Message:%127s can't be sent to queue: %127s",(char *)Sendbuf,context->MQInternalName));
        }

#if OLD_IMPL
        // dropBuffer
        context->MQInternal->DropMessage(Sendbuf);
#endif

        //Send an NULL_EVENT to external queue to allow processing of internal queue in the next mainloop cycle
        SendEvent(mNULL_EVENT,NULL);

        /* Unlock */
        context->MQInternalLock.unlock();

    } // loop over all active contexts

    return 0;
}

int SMF::DelayEvent(void *_trans)
{
    ENTRY_INTERNAL
    tTransition *trans = (tTransition *)_trans;
    void *Sendbuf;
    size_t bufferSize = 0;
    int ret;

    ((tState *)(trans->source))->mDelayQueueLock.lock();

    /* has the source state no delay queue? create it */
    if (!((tState *)(trans->source))->delayQueue) {

        /* generate a name for the delay queue */
        tGeneralString delayQueueName;
        strncpy_r(OUT delayQueueName, IN "delayQ_", IN sizeof(tGeneralString));
        strncat_r(OUT delayQueueName, ((tState *)(trans->source))->name, IN sizeof(tGeneralString));

        /* create the delay queue */
        ((tState *)(trans->source))->delayQueue = new MessageQueue(delayQueueName);
        if (!((tState *)(trans->source))->delayQueue) {
            ETG_TRACE_ERR(("DelayQueue not created"));
            ((tState *)(trans->source))->mDelayQueueLock.unlock();
            return MP_ERR_SM_NO_DELAY_QUEUE_CREATED;
        }

        /* add this queue to the delay queue vector */
        mAllDelayQueues.push_back(((tState *)(trans->source))->delayQueue);
    }
    MessageQueue *delayQueue = ((tState *)(trans->source))->delayQueue; // simplyfier

    /* are arguments present? */
    if (trans->arguments) { // yes

        /* create the send buffer for delay queue */
        bufferSize = strlen_r(trans->event->name) + 1 + strlen_r(trans->arguments) + 1;
        Sendbuf = delayQueue->CreateMessageBuffer(bufferSize);
        if (!Sendbuf) {
            ETG_TRACE_ERR(("Messagebuffer not allocated"));
            ((tState *)(trans->source))->mDelayQueueLock.unlock();
            return MP_ERR_SM_NO_MEM_FOR_DELAY_QUEUE_MESSAGE;
        }

        strcpy((char *)Sendbuf, trans->event->name);
        strcat((char *)Sendbuf, " ");
        strcat((char *)Sendbuf, trans->arguments);

    } else { // no arguments

        /* create the send buffer for delay queue */
        bufferSize = strlen_r(trans->event->name) + 1;
        Sendbuf = delayQueue->CreateMessageBuffer(bufferSize);
        if (!Sendbuf) {
            ETG_TRACE_ERR(("Messagebuffer not allocated"));
            ((tState *)(trans->source))->mDelayQueueLock.unlock();
            return MP_ERR_SM_NO_MEM_FOR_DELAY_QUEUE_MESSAGE;
        }

        strcpy((char *)Sendbuf, trans->event->name);
    }

    ETG_TRACE_USR4(("Delaying Event: %s", (char *)Sendbuf));

    /* send the buffer */
    ret = delayQueue->Push(Sendbuf, bufferSize, Priority_Delayed);
    if (ret != 0) {
        ETG_TRACE_ERR(("Message:%127s can't be sent to queue: %127s", (char *)Sendbuf, delayQueue->GetName()));
    }

    // todo: thm3hi: in valgrind the Sendbuf is marked as memory leak, this can only be the case if the delay queue is never flushed or read out

#if OLD_IMPL
    // dropBuffer
    delayQueue->DropMessage(Sendbuf);
#endif

    ((tState *)(trans->source))->mDelayQueueLock.unlock();

    return ret;
}

int SMF::TransferDelayedEvents(tState *currentState)
{
    ENTRY_INTERNAL
    char *receiveData;
    int to = 2000; //timeout in ms

    currentState->mDelayQueueLock.lock();

    /* is a delay queue present? if not, do nothing */
    if (!currentState->delayQueue) {
        currentState->mDelayQueueLock.unlock();
        return 0;
    }

    MessageQueue *delayQueue = currentState->delayQueue; // simplyfier

    // loop over delayed messages in the delay queue
    while (delayQueue->GetCurMessagesCount()) {

        // read out the message
        receiveData = (char*)GetMQmessage(delayQueue, "mMQDelay", to);

        // data available
        if (receiveData != NULL) {

            /* put it into external queue */
            char *sendData;

            /* get a send buffer */
            sendData = (char *)mMQExternal->CreateMessageBuffer(strlen_r(receiveData)+1);

            /* send it */
            if (sendData) {

                strcpy(sendData, receiveData);
                mMQExternal->Push(sendData,strlen_r(receiveData)+1, Priority_Delayed);
#if OLD_IMPL
                mMQExternal->DropMessage(sendData);
#endif
            } else {
                ETG_TRACE_ERR(("Got no Sendbuffer"));
            }

            /* free the received buffer */
            delayQueue->DropMessage(receiveData);

        } else {
            ETG_TRACE_ERR(("Did not get a receive Buffer"));
        }
    } // loop over all delayed events

    /* remove this queue from the delay queue vector */
    for(unsigned int i=0; i<mAllDelayQueues.size(); i++) {
        if (mAllDelayQueues[i] == delayQueue) {
            mAllDelayQueues.erase(mAllDelayQueues.begin()+i);
            break;
        }
    }

    /* delay queue is empty now, can be deletes */
    delete delayQueue;
    currentState->delayQueue = NULL;

    currentState->mDelayQueueLock.unlock();

    return 0;
}

int SMF::NextEventProcess(char *eventName, char *ptrArguments, tStateContext *processingContext /* defaults to NULL */)
{
    ENTRY_INTERNAL
    unsigned int i;
    unsigned int j;
    tTransition *message;
    tState *toCompound;
    tEvent *event = mNULL_EVENT;

    /* search for event */
    for (i=0; i<mKnownEvents.size(); i++) {
        if (!strcmp(mKnownEvents[i]->name, eventName)) {
            event=mKnownEvents[i];
            break;
        }
    }

    /* found the event? */
    if (i == mKnownEvents.size()) return SMF_ERR_UNKNOWN_EVENT;

    /* loop over all active contexts */

    // thoemel
    // printf("mContextDirectory.size()=%d\n", (int)mContextDirectory.size()); fflush(stdout);

    tState *currentState;
    tState *compoundState;
    tResult doTransitionResult = MP_ERR_SM_NOT_CONSUMED;
    for(int iContext=0; iContext<(int)mContextDirectory.size(); iContext++) {
        tStateContext *context = mContextDirectory[iContext];

        /* is context active? */
        if (!context->active) {
            continue;
        }

        /* is this the context which should be processed only? */
        if (processingContext && context != processingContext) {
            continue;
        }

        /* get the current state of the current context */
        currentState = (tState *)context->currentState;
        compoundState = (tState *)context->compoundState;

        /* is event registered as release event? */
        if (event == context->ReleaseEvent) {

            /* clear it and disarm timer */
            ClearReleaseEvent();
        }

        SDPrintEvent(currentState, event, ptrArguments);

        /* check if event can be consumed by current state */
        for (i=0; i<(int)event->noOfStates; i++) {
            if ((tState *)event->state[i] == currentState) {

                /* append userdata to event */
                ((tTransition *)event->trans[i])->arguments = ptrArguments;

                /* fire transition */
                doTransitionResult = DoTransition((tTransition *)event->trans[i]);
                goto cont;
            }
        }

        /*
         * to ensure that all state machines are stopping in time regardless of their design, the STOP_SM message
         * must be processed in any case. So the search after a Delay Event will be skipped for this message:
         */
        if (strcmp(eventName, "STOP_SM")) {

            /* is in the current state a default transition? */
            for (i=0; i<(int)currentState->noOfTransitions; i++) {
                if (currentState->transitions[i] == NULL) {
                    break;
                } else if (currentState->transitions[i]->type == isDefaultTransition) {

                    tEvent *artificialEvent;
                    tResult res;

                    /* create an artificial event just for this call to pass the original event to the default transition */
                    artificialEvent = CreateEventInternal(eventName, 0 /* no GC */ );
                    currentState->transitions[i]->event = artificialEvent;

                    /* append userdata to event */
                    currentState->transitions[i]->arguments = ptrArguments;

                    const tBoolean delayed_event = currentState->transitions[i]->actionName != NULL && strcmp(currentState->transitions[i]->actionName, "DelayEvent");
                    res = DoTransition(currentState->transitions[i]);

                    delete artificialEvent;

                    if(!res && delayed_event) { //exclude: Default / DelayEvent
                        res = MP_ERR_SM_NOT_CONSUMED;
                    }

                    doTransitionResult = res;
                    goto cont;
                }
            }
        } // if skip DelayEvent search for forced STOP_SM event

        /* transition known to compound state(s)? */
        toCompound = compoundState;

        // loop over compound hierarchy
        while(toCompound) {

            /* loop over states known by this event */
            for (i=0; i<(int)event->noOfStates; i++) {

                // is current test compound known by the current event?
                if (toCompound == (tState *)event->state[i]) {

                    message = (tTransition *)event->trans[i];

                    // search the message in the current test compound
                    for (j=0; j<toCompound->transitions.size(); j++) {
                        if (toCompound->transitions[j] == NULL) {
                            break;
                        } else if (toCompound->transitions[j] == message) {

                            /* append userdata to event */
                            message->arguments = ptrArguments;

                            doTransitionResult = DoTransition(message);
                            goto cont;
                        }
                    }
                }
            }

            /* is in the compound a default transition defined? */
            for (i=0; i<(int)toCompound->noOfTransitions; i++) {
                if (toCompound->transitions[i] == NULL) {
                    break;
                } else if (toCompound->transitions[i]->type == isDefaultTransition) {

                    tEvent *artificialEvent;
                    tResult res;

                    /* create an artificial event just for this call to pass the original event to the default transition */
                    artificialEvent = CreateEventInternal(eventName, 0 /* no GC */);
                    toCompound->transitions[i]->event = artificialEvent;

                    /* append userdata to event */
                    toCompound->transitions[i]->arguments = ptrArguments;

                    const tBoolean delayed_event = toCompound->transitions[i]->actionName != NULL && strcmp(toCompound->transitions[i]->actionName, "DelayEvent");

                    res = DoTransition(toCompound->transitions[i]);

                    delete artificialEvent;

                    if(!res && delayed_event) { //exclude: Default / DelayEvent
                        res = MP_ERR_SM_NOT_CONSUMED;
                    }

                    doTransitionResult = res;
                    goto cont;
                }
            }

            /* next compound */
            toCompound = toCompound->compound;
        }

        cont:
        /* break the loop if this is the context which should be processed only? */
        if (processingContext && context != processingContext) {
            break;
        }

    } // loop over all active contexts

    /* was the transition not consumed by any state? */
    if (doTransitionResult == MP_ERR_SM_NOT_CONSUMED) {

        /* event not yet consumed */
        SDPrintNotConsumedEvent(event);
        {
            char cbuf[1024];
            snprintf(cbuf, sizeof(cbuf), "%s: notConsumed", event->name);
            Expect(cbuf);
        }
    }

    return doTransitionResult;
}

int SMF::CheckForExternalMessage()
{
    ENTRY_INTERNAL
    char *receiveData;
    int ret = 0;

    /* check if queue is still valid, if not, trace it and end this state machine */
    if (!mMQExternal) {
        ETG_TRACE_FATAL(("not expected: external queue already closed - finishing state machine %s", GetSMNameFull()));
        ETG_TRACE_ERRMEM(("not expected: external queue already closed - finishing state machine %s", GetSMNameFull()));
        return STATE_MACHINE_FINISHED;
    }

    // check external queue and wait until message is available
    receiveData = (char *)GetMQmessage(mMQExternal, "mMQExternal", 0);

    if (receiveData != NULL)
    {
        char *posArguments;

        // find delimiter between event and argument
        posArguments = strstr(receiveData, " ");

        // check if arguments are presen
        if (posArguments) {
            *posArguments = 0; // seperate the event name from the argument
            posArguments++; // points now to the arguments
        }

        // check if it was NOT a wake up message
        if (strcmp(receiveData, mNULL_EVENT->name))
        {
            // is an argument present?
            if (posArguments)
            {
                ret = NextEventProcess(receiveData, posArguments);
            }
            else
            {
                ret = NextEventProcess(receiveData, NULL);
            }
        }

        // free the received message
        mMQExternal->DropMessage(receiveData);

    } else {
        ETG_TRACE_ERR(("GetMQmessage was aborted"));
    }

    return ret;
}

int SMF::StateMachine_Main()
{
    ENTRY_INTERNAL

    int result;

    //message/answer events
    result = CheckForInternalMessage();

    if (result != STATE_MACHINE_FINISHED) {

        //simple events (blocking)
        result = CheckForExternalMessage();
    }

    if(STATE_MACHINE_FINISHED == result)
    {
        /* de-register at dispatcher */
        Dispatcher::GetInstance().DeRegister(this);

        /* clear the release event - delete answer timeout */
        ClearReleaseEvent();

        /* release all the queues in use as the state machine is finished */
        DecreateComponent();

        ETG_TRACE_USR1(("Statemachine (%s) is finished",GetSMNameFull()));
    }
    return result;
}

void* SMF::GetMQmessage(MessageQueue* mq, const char *nameOfQueue, int TimeOut)
{
    ENTRY_INTERNAL
    size_t rec_bytes = 0;

    /* check if message queue was created */
    if (mq == NULL) {
        ETG_TRACE_FATAL(("message queue not created: %s", nameOfQueue));
        return NULL;
    }

    /* wait for one record in queue */
    void * RecordBuffer = mq->WaitForMessage(&rec_bytes, TimeOut);

    /* did not received anything? (timeout?) */
    if( RecordBuffer == NULL) {
        return NULL;
    }

    /* check if the received bytes match to the string len */
    if (rec_bytes != (strlen_r((char*)RecordBuffer) + 1))
    {
        ETG_TRACE_FATAL(("Receiving byte error: expect:%d, received:%d (%127s) - in queue: %s",
                rec_bytes, strlen_r((char*) RecordBuffer) + 1, (char *)RecordBuffer, nameOfQueue));
    }

    /* return the pointer to the buffer */
    return RecordBuffer ;
}

void* SMF::ReadMQmessage(MessageQueue* mq, const char *nameOfQueue)
{
    ENTRY_INTERNAL
    size_t rec_bytes = 0;
    if (mq == NULL) {
        ETG_TRACE_FATAL(("message queue not created: %s", nameOfQueue));
        return NULL;
    }
    void * RecordBuffer = mq->ReadCurrentMsg(&rec_bytes);
    if( RecordBuffer == NULL) {
        return NULL;
    }
    if (rec_bytes != (strlen((char*)RecordBuffer) + 1))
    {
        ETG_TRACE_FATAL(("Receiving byte error: expect:%d, received:%d (%127s) - in queue: %s",
                rec_bytes, strlen((char*) RecordBuffer) + 1, (char *)RecordBuffer, nameOfQueue));
    }
    return RecordBuffer ;
}

int SMF::CheckForInternalMessage()
{
    ENTRY_INTERNAL

    tResult res = 0;

    /* loop over all active contexts */
    for(int iContext=0; iContext<(int)mContextDirectory.size(); iContext++) {
        tStateContext *context = mContextDirectory[iContext];

        /* is context active? */
        if (!context->active) {
            continue;
        }

        /* check if queue is still valid, if not, trace it and end this state machine */
        if (!context->MQInternal) {
            ETG_TRACE_FATAL(("not expected: internal queue already closed - finishing state machine %s", GetSMNameFull()));
            ETG_TRACE_ERRMEM(("not expected: internal queue already closed - finishing state machine %s", GetSMNameFull()));
            continue;
        }

        // is mechanism locked?
        if(context->LockStatus != MessageAnswerLock){

            char *receiveData;
            int to = 2000; //timeout in ms

            // check if there are messages in the internal queue
            if (context->MQInternal->GetCurMessagesCount()) {

                // read out the message
                receiveData = (char*)GetMQmessage(context->MQInternal, "mMQInternal", to);

                // receive data available
                if (receiveData != NULL) {

                    char *posArguments;

                    // lock the message/answer mechanism
                    context->LockStatus = MessageAnswerLock;

                    strncpy_r(OUT context->LockMessage, IN receiveData, sizeof(context->LockMessage));
                    ETG_TRACE_USR1(("CheckForInternalMessage: SM %24s locked [MAQueue] for %s", GetSMNameFull(), receiveData));

                    // get the position of the arguments
                    posArguments = strstr(receiveData, " ");

                    // arguments present?
                    if (posArguments) {
                        *posArguments = 0; // separate arguments from message name
                        posArguments++; // now the pointer points to the arguments
                    }

                    /* process the message in the context */
                    if (posArguments) { // arguments present?
                        res = NextEventProcess(receiveData, posArguments, context);
                    } else {
                        res = NextEventProcess(receiveData, NULL, context);
                    }

                    // free the received message
                    context->MQInternal->DropMessage(receiveData);

                    //check if MessageAnswer was consumed
                    if(res == MP_ERR_SM_NOT_CONSUMED) {
                        ETG_TRACE_ERR(("Message not consumed"));
                        /*
                         * message from message/answer pair could not be consumed
                         * read the answer away from queue and drop it
                         */

                        /* read answer from internal queue */
                        char *answer = (char *)GetMQmessage(context->MQInternal, "mMQInternal", to);
                        context->MQInternal->DropMessage(answer); // and throw it away

                        // unlock the message / answer mechanism
                        context->LockStatus=MessageAnswerUnlock;

                    }
                    else if(res == SMF_ERR_UNKNOWN_EVENT)
                    {

                        context->LockStatus=MessageAnswerUnlock;

                        // ETG_TRACE_USR2(("Message consumed"));
                    }
                }
                else
                {
                    ETG_TRACE_ERR(("not expected: No message in internal queue"));
                }
            }
        }
        else
        {
            ETG_TRACE_USR1(("CheckForInternalMessage: SM %24s is still locked [MAQueue] for %s", GetSMNameFull(), context->LockMessage));
        }

    } // loop over all active contexts

    return res;
}

bool SMF::TimerCallBack(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY_INTERNAL
    (void)userData;
    SMF *self = (SMF*)instance;

    Dispatcher::GetInstance().LockActiveStateMachines();
    if(self && Dispatcher::GetInstance().IsRegistered(self)) {
        char *smName = (char *)self->mSMFullName;
        if (!smName) {
            smName = (char *)"*DEAD*";
        }
        ETG_TRACE_USR4(("call TimerCallBack for timeout timer for SM %128s, id=%d", smName, (int)((long)timerID)));

        prctl(PR_SET_NAME, smName, 0, 0, 0, 0);

        // send the time out message
        self->EventAnswerTimeOut();
    } else {
        //GMMY17-12069, GMMY17-10649
        ETG_TRACE_ERR(("Invalid SMF reference!"));
    }
    Dispatcher::GetInstance().UnLockActiveStateMachines();
    return 0;
}

bool SMF::ResponseTimerCallBack(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY_INTERNAL
    tSendResponse *pResponse = (tSendResponse*)userData;
    SMF *self = (SMF*)instance;
    int l_error = 0;
    if(pResponse)
    {
        l_error = pResponse->error;
        ETG_TRACE_USR4(("Error response %d", l_error));
    }
    Dispatcher::GetInstance().LockActiveStateMachines();
    if(self && Dispatcher::GetInstance().IsRegistered(self)) {
        char *smName = (char *)self->mSMFullName;
        if (!smName) {
            smName = (char *)"*DEAD*";
        }
        ETG_TRACE_USR4(("call ResponseTimerCallBack for timeout timer for SM %128s, id=%d", smName, (int)((long)timerID)));
        self->EventNoResponseMsg(smName, l_error);
    } else {
        ETG_TRACE_ERR(("Invalid SMF reference!"));
    }
    Dispatcher::GetInstance().UnLockActiveStateMachines();
    return 0;
}
void SMF::EventAnswerTimeOut()
{
    ENTRY_INTERNAL
    void *Sendbuf;
    int ret;

    ETG_TRACE_ERR(("Answer takes too long: sending ANSWER_TIMEOUT"));

    /* check the members */
    if (!mMQExternal) {
        ETG_TRACE_ERR(("mMQExternal==NULL"));
        return;
    }

    Sendbuf = mMQExternal->CreateMessageBuffer(strlen_r("ANSWER_TIMEOUT") +1);
    if (!Sendbuf) {
        ETG_TRACE_ERR(("%s: out of memory", mMQExternalName));
        MP_FATAL_ASSERT(Sendbuf != NULL);
    }

    strcpy((char *)Sendbuf, "ANSWER_TIMEOUT");

    ret = mMQExternal->Push(Sendbuf,strlen_r("ANSWER_TIMEOUT") +1, Priority_AnwerTimeOut);
    if (ret != 0) {
        ETG_TRACE_ERR(("Message: %127s can't be sent to queue: %127s", (char *)Sendbuf, mMQExternalName));
    }

#if OLD_IMPL
    // dropBuffer
    mMQExternal->DropMessage(Sendbuf);
#endif
}
void SMF::EventNoResponseMsg(char *smName, int error)
{
    ENTRY_INTERNAL
    void *Sendbuf;
    char args[100];
    int ret = 0;
    size_t bufferSize;
    Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "i",
            error);
    if(smName!=NULL)
    {
        ETG_TRACE_USR4(("%s : sending NO_RESPONSE_MSG ", smName));
        if (!mMQExternal) {
            ETG_TRACE_ERR(("mMQExternal==NULL"));
            return;
        }
        bufferSize =  strlen_r("NO_RESPONSE_MSG") + strlen_r(args) + 2;
        Sendbuf = mMQExternal->CreateMessageBuffer(bufferSize);
        if (!Sendbuf) {
            ETG_TRACE_ERR(("%s: out of memory", mMQExternalName));
            MP_FATAL_ASSERT(Sendbuf != NULL);
        }
        strcpy((char *)Sendbuf, "NO_RESPONSE_MSG");
        strcat((char *)Sendbuf, " ");
        strcat((char *)Sendbuf, args);
        ETG_TRACE_USR4(("msg :- %s", Sendbuf));
        ret = mMQExternal->Push(Sendbuf,bufferSize, Priority_AnwerTimeOut);
        if (ret != 0) {
            ETG_TRACE_ERR(("Message: %127s can't be sent to queue: %127s", (char *)Sendbuf, mMQExternalName));
        }
    }
#if OLD_IMPL
    mMQExternal->DropMessage(Sendbuf);
#endif
}

int SMF::SetAnswerTimeout(int TimeOut)
{
    ENTRY_INTERNAL

    if (!mCurrentContext) {
        return MP_ERR_SM_NO_CURRENT_CONTEXT;
    }

    mCurrentContext->AnswerTimeoutValue=TimeOut;

    return 0;
}

int SMF::DoEventAnswer(const char *sendMessage, const char *parameter, const void *userContext, const int answerTimeoutMS,const char *answerTimeoutParams)
{
    ENTRY
    int ret = 0;
    char *messageToSend;
    char *answerMessage;
    const char *answerMessageName = "SUCCESS_REQUEST";

    /* this function must be used by RequestResponseSM only*/
    if(Dispatcher::GetInstance().IsAllTransientBlocked()) {
        return MP_ERR_SM_BLOCKED;
    }

    mTransient = true;

    /* at the first time this SM is used */
    if (!mIsCreated) {

        /* create the request and answer state machine */
        Create();

        /* init it */
        ret = Init(userContext);
        if (ret) return ret;

    } else {

        // reset it
        ret = Reset(userContext);
        if (ret) return ret;
    }

    /* set the answer timeout */
    SetAnswerTimeout(answerTimeoutMS);

    /* register SM at Dispatcher */
    ret = Dispatcher::GetInstance().Register(this);
    if(ret != MP_NO_ERROR) {
        return ret; //StateChangeOFF issue, race condition in shutdown sequence - GMMY17-13669
    }

    /* assemble the message to send */
    if (parameter && strlen_r(parameter) > 0) {
        messageToSend = (char *)malloc(strlen_r(sendMessage) + strlen_r(parameter) + 2);
        if (!messageToSend) return MP_ERR_SM_NO_MEM;
        strcpy(messageToSend, sendMessage);
        strcat(messageToSend, " ");
        strcat(messageToSend, parameter);
    } else {
        messageToSend = (char *)malloc(strlen_r(sendMessage) + 1);
        if (!messageToSend) return MP_ERR_SM_NO_MEM;
        strcpy(messageToSend, sendMessage);
    }

    /* assemble the answer message */
    answerMessage = (char *)malloc(strlen_r(answerMessageName) + strlen_r(GetSMNameFull()) + 3);
    strcpy(answerMessage, GetSMNameFull());
    strcat(answerMessage, "::");
    strcat(answerMessage, answerMessageName);

    /* register the release event */
    // thoemel: is done in the SendMessageAnswer call of Dispatcher

    /* do the message / answer request */
    if(answerTimeoutParams)
    {
        ret = Dispatcher::GetInstance().SendMessageAnswerWithGivenAnsOnTimeOut(messageToSend, answerMessage,answerTimeoutParams);
    }
    else
    {
        ret = Dispatcher::GetInstance().SendMessageAnswer(messageToSend, answerMessage);
    }

    /* message sending worked: */
    if (ret == 0) {

        /* while loop until it ends with final state */
        while(STATE_MACHINE_FINISHED != StateMachine_Main()){};
    } else {

        /* Error case: deregister SM at Dispatcher */
        Dispatcher::GetInstance().DeRegister(this);
    }

    /* free memory */
    free(messageToSend);
    free(answerMessage);

    /* cancel a possibly running timer */
    if (mRootState->context->AnswerTimerID) {
        mRootState->context->AnswerTimer.CancelTimer(IN mRootState->context->AnswerTimerID);
        ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s / rootContext, id=%d", mSMFullName, (int)((long)mRootState->context->AnswerTimerID)));
        mRootState->context->AnswerTimerID = 0;
    }

    /* end */
    return 0;
}

int SMF::DoEventAnswer(const char *sendMessage, m1::msg_t const& msg, const void *userContext, const int answerTimeoutMS,const char *answerTimeoutParams)
{
    ENTRY
    return DoEventAnswer(sendMessage, msg.at(), userContext, answerTimeoutMS, answerTimeoutParams);
}

tResult SMF::RegisterReleaseEvent(const char *event, const char * parameter, const int specialTimeoutValue)
{
    ENTRY
    for (unsigned int i=0; i<mKnownEvents.size(); i++) {
        if (!strcmp(mKnownEvents[i]->name, event)) {
            return RegisterReleaseEvent(mKnownEvents[i], parameter, specialTimeoutValue);
        }
    }

    return SMF_ERR_UNKNOWN_EVENT;
}

tResult SMF::RegisterReleaseEvent(const tEvent *event, const char * parameter, const int specialTimeoutValue )
{
    ENTRY

    if (!mCurrentContext) {
        return MP_ERR_SM_NO_CURRENT_CONTEXT;
    }

    /* clear it and disarm timer */
    ClearReleaseEvent();

    mCurrentContext->ReleaseEvent = event;
    mCurrentContext->SpecialAnswerTimeoutValue = specialTimeoutValue;

    if (parameter) {
        strncpy_r(mCurrentContext->ReleaseEventParameter, parameter,
                sizeof(mCurrentContext->ReleaseEventParameter));
    }

    int timeOutValue = specialTimeoutValue >= 0 ? specialTimeoutValue : mCurrentContext->AnswerTimeoutValue;

    // start the answer timeout timer
    if (timeOutValue) {
        mCurrentContext->AnswerTimer.StartTimer(OUT mCurrentContext->AnswerTimerID, IN (long)timeOutValue, 0L, IN this, IN &TimerCallBack, IN (void *)mCurrentContext->AnswerTimerID);
        ETG_TRACE_USR4(("start Answer timeout timer for SM %20s, id=%d, timeout=%d", mSMFullName, (int)((long)mCurrentContext->AnswerTimerID), timeOutValue));
    }

    return 0;
}
tResult SMF::RegisterNoResponseEvent(const char *event, const int error, const int specialTimeoutValue)
{
    ENTRY

    if (mCurrentContext->ReleaseEvent) {
        if(mCurrentContext->ReleaseEvent->name && event)
        {
            if(!strcmp(mCurrentContext->ReleaseEvent->name, event))
            {
                for (unsigned int i=0; i<mKnownEvents.size(); i++) {
                    if (!strcmp(mKnownEvents[i]->name, event)) {
                        return RegisterNoResponseEvent(mKnownEvents[i], error, specialTimeoutValue);
                    }
                }
            }
        }
    }
    return SMF_ERR_UNKNOWN_EVENT;
}
tResult SMF::RegisterNoResponseEvent(const tEvent *event,const int error, const int specialTimeoutValue )
{
    ENTRY
    if(0 != mResponseTimer.timerId){
        mResponseTimer.rtimer.CancelTimer(mResponseTimer.timerId);
    }
    mResponseTimer.error = error;
    if(event){
        mResponseTimer.res_event = event;
        ETG_TRACE_USR4(("Event name :: %s", event->name));
    }
    if (specialTimeoutValue) {
        mResponseTimer.rtimer.StartTimer(OUT mResponseTimer.timerId, IN (long)specialTimeoutValue, 0L, IN this, IN &ResponseTimerCallBack, IN (void *)&mResponseTimer);
        ETG_TRACE_USR4(("start Answer timeout timer for SM %20s, id=%d, timeout=%d", mSMFullName, (int)((long)mResponseTimer.timerId), specialTimeoutValue));
    }
    return 0;
}
tResult SMF::ClearReleaseEvent()
{
    ENTRY

    if (!mCurrentContext) {
        return MP_ERR_SM_NO_CURRENT_CONTEXT;
    }

    /* is any event registered as release event? */
    if (mCurrentContext->ReleaseEvent) {
        const bool cancelTimer = mCurrentContext->SpecialAnswerTimeoutValue > 0 || (mCurrentContext->SpecialAnswerTimeoutValue == -1 && mCurrentContext->AnswerTimeoutValue > 0);
        mCurrentContext->ReleaseEvent = NULL;
        mCurrentContext->ReleaseEventParameter[0] = 0;
        mCurrentContext->SpecialAnswerTimeoutValue = -1;

        // cancel answer timeout timer
        if (cancelTimer && mCurrentContext->AnswerTimerID) {
            ETG_TRACE_USR4(("stop Answer timeout timer for SM %20s, id=%d", mSMFullName, (int)((long)mCurrentContext->AnswerTimerID)));
            mCurrentContext->AnswerTimer.CancelTimer(IN mCurrentContext->AnswerTimerID);
            mCurrentContext->AnswerTimerID = 0;
        }
    }
    ClearResponseEvent();
    return 0;
}

tResult SMF::ClearResponseEvent()
{
    ENTRY
    if(mResponseTimer.timerId)
    {
        if(mResponseTimer.res_event)
        {
            ETG_TRACE_ERR(("ClearResponseEvent response event %s", mResponseTimer.res_event->name));
            mResponseTimer.rtimer.CancelTimer(mResponseTimer.timerId);
            mResponseTimer.res_event = NULL;
            mResponseTimer.error = 0;
            mResponseTimer.timerId = 0;
        }
    }
    return 0;
}
tResult SMF::ReleaseWaiting()
{
    ENTRY
    tResult res;

    if (!mCurrentContext) {
        return MP_ERR_SM_NO_CURRENT_CONTEXT;
    }

    if(mCurrentContext->ReleaseEvent) {
        res = SendEvent(mCurrentContext->ReleaseEvent, mCurrentContext->ReleaseEventParameter);
        if (res) return res;
    }
    else {
        ETG_TRACE_ERR(("release event is NULL -> cannot release it"));
    }

    return 0;
}

tResult SMF::SetRetryCount(int retryCount)
{
    ENTRY
    mRetryCount = retryCount;
    return 0;
}

tResult SMF::SetRetryWaitTime(unsigned long retryWaitTimeUS)
{
    ENTRY
    mUSSleepTime = retryWaitTimeUS;
    return 0;
}

char *SMF::Marshal(char *serialized, const size_t size, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);
    char *bufferPtr;

    bufferPtr = Marshal(serialized, size, MARSHAL_SEPARATOR, format, vl);

    va_end(vl);

    return bufferPtr;
}

char *SMF::Marshal(char *serialized, const size_t size, const unsigned char separator, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);
    char *bufferPtr;

    bufferPtr = Marshal(serialized, size, separator, format, vl);

    va_end(vl);

    return bufferPtr;
}

char *SMF::MarshalToUtf8(char *serialized, const size_t size, const unsigned char separator, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);

    char *pBuf = new char[size+1];
    if(!pBuf) {
        ETG_TRACE_ERR(("Out of Memory"));
        return NULL;
    }

    Marshal(pBuf, size, separator, format, vl);
    va_end(vl);

    //convert to UTF8
    toUtf8Fake(OUT serialized, IN size, IN pBuf);
    delete [] pBuf;

    return serialized;
}

char *SMF::Marshal(char *serialized, const size_t size, const unsigned char separator, const char *format, va_list vl)
{
    char *fmt = (char *)format;
    unsigned char *ser = (unsigned char *)serialized;
    unsigned char *serEnd = (unsigned char *)serialized + size;
    char *c;

    /* init */
    *ser = 0;

    /* loop over format and arguments */
    while(*fmt) {

        switch(*fmt) {
            case 't': // text string
                c = (char *)va_arg(vl, char *);
                while(c != NULL && *c != 0) {
                    *ser++ = *c++;
                    if (ser == serEnd) {
                        *ser = 0;
                        return serialized;
                    }
                }
                *ser++ = separator;
                *ser = 0;
                break;
            case 'i': // integer
                int integer;
                if (ser >= (serEnd - 16)) {
                    *ser = 0;
                    return serialized;
                }
                integer = va_arg(vl, int);
                ser = (unsigned char *)itoa(integer, (char *)ser, MARSHAL_BASE);
                *ser++ = separator;
                *ser = 0;
                break;
            case 'l': // unsigned long long
                tU64 ulonglong;
                if (ser >= (serEnd - 16)) {
                    *ser = 0;
                    return serialized;
                }
                ulonglong = va_arg(vl, tU64);
                ser = (unsigned char *)ulltoa(ulonglong, (char *)ser, MARSHAL_BASE);
                *ser++ = separator;
                *ser = 0;
                break;
            case 'p': // pointer
                void *pointer;
                if (ser >= (serEnd - 16)) {
                    *ser = 0;
                    return serialized;
                }
                pointer = va_arg(vl, void *);
                ser = (unsigned char *)lltoa((long long)pointer, (char *)ser, MARSHAL_BASE);
                *ser++ = separator;
                *ser = 0;
                break;
            default:
                break;
        }

        /* next format */
        fmt++;
    }

    *ser = 0;
    return serialized;
}

tResult SMF::UnMarshal(const char *serialized, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);
    tResult result;

    result = UnMarshal(serialized, MARSHAL_SEPARATOR, format, vl);

    va_end(vl);
    return result;
}

tResult SMF::UnMarshal(const char *serialized, const unsigned char separator, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);
    tResult result;

    result = UnMarshal(serialized, separator, format, vl);

    va_end(vl);
    return result;
}

tResult SMF::UnMarshalFromUtf8(const char *serialized, const unsigned char separator, const char *format, ...)
{
    va_list vl;
    va_start(vl, format);
    tResult result;

    const size_t size = strlen_r(serialized)+1;
    char *pBuf = new char[size];
    if(!pBuf) {
        ETG_TRACE_ERR(("Out of Memory"));
        return 0;
    }

    //convert from UTF8
    fromUtf8Fake(OUT pBuf, IN size, IN serialized);

    result = UnMarshal(pBuf, separator, format, vl);
    va_end(vl);

    delete [] pBuf;
    return result;
}

tResult SMF::UnMarshal(const char *serialized, const unsigned char separator, const char *format, va_list vl)
{
    char *fmt = (char *)format;
    unsigned char *ser = (unsigned char *)serialized;
    char *c;
    int *readBytes = NULL;

    /* loop over format and arguments */
    while(*fmt) {

        switch(*fmt) {
            case 'a': // take all parameters as one string
                c = (char *)va_arg(vl, char *);
                while(*ser != 0) {
                    *c++ = *ser++;
                }
                *c = 0;
                //if (*ser == 0) return 0;
                if (*ser == 0) goto end;
                ser++;
                break;
            case 't': // text string
                c = (char *)va_arg(vl, char *);
                while(*ser != separator && *ser != 0) {
                    *c++ = *ser++;
                }
                *c = 0;
                //if (*ser == 0) return 0;
                if (*ser == 0) goto end;
                ser++;
                break;
            case 'T': // text string following sizeof() info
            {
                c = (char *)va_arg(vl, char *);
                size_t maxlen=(size_t)va_arg(vl, size_t);
                while(*ser != separator && *ser != 0) {
                    if (maxlen <= 1) {
                        while(*ser++ != separator && *ser != 0){}; // skip forward to next field
                        break; // break loop, target string is filled
                    }
                    *c++ = *ser++; // copy character
                    maxlen--; // count this
                }
                *c = 0; // end target string
                //if (*ser == 0) return 0; // end of marshalled string
                if (*ser == 0) goto end; // end of marshalled string
                ser++;
                break;
            }
            case 'p': // pointer
                void * *pointer;
                pointer = va_arg(vl, void **);
                if (sizeof(void *) == sizeof(unsigned long long)) { //lint !e774 check 64bit system
                    *pointer = (void *)strtoq((char *)ser, (char **)&ser, MARSHAL_BASE);
                } else {
                    *pointer = (void *)strtol((char *)ser, (char **)&ser, MARSHAL_BASE);
                }
                //if (*ser == 0) return 0;
                if (*ser == 0) goto end;
                ser++;
                break;
            case 'i': // integer
                int *integer;
                integer = va_arg(vl, int *);
                *integer = (int)strtol((char *)ser, (char **)&ser, MARSHAL_BASE);
                //if (*ser == 0) return 0;
                if (*ser == 0) goto end;
                ser++;
                break;
            case 'l': // unsigned long long
                tU64 *ulonglong;
                ulonglong = va_arg(vl, tU64 *);
                *ulonglong = (tU64)strtoull((char *)ser, (char **)&ser, MARSHAL_BASE);
                //if (*ser == 0) return 0;
                if (*ser == 0) goto end;
                ser++;
                break;
            case 's':
                readBytes = va_arg(vl, int *);
                *readBytes = 0;
                break;
            default:
                break;
        }

        /* next format */
        fmt++;
    }

    end:
    if (readBytes) {
        *readBytes = (int)(((unsigned long long)ser) - ((unsigned long long)serialized)) - 1;
        if (*ser == 0) {
            (*readBytes)++;
        }
    }

    return 0;
}

tResult SMF::GetTargetState(OUT tState &state)
{
    if (mCurrentTrans->target) {
        state = *(tState *)(mCurrentTrans->target);
    } else if (mCurrentTrans->source) {
        state = *(tState *)(mCurrentTrans->source);
    } else {
        return -1;
    }

    return 0;
}
