/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FRAMEWORK
#ifdef TARGET_BUILD
#include "trcGenProj/Header/Dispatcher.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FRAMEWORK
#endif
#endif

#include "FunctionTracer.h"
#include "TraceDefinitions.h"
#include "Framework_Errorcodes.h"
#include "Utils.h"

#include <string>
#include <Dispatcher.h>
#include <errno.h>

/*lint -save -e801 -e1773 */

using namespace std;

Dispatcher::Dispatcher()
{
    mDestructionFlag = 0;
   // mActiveStateMachinesLock.setNotReantrant();
    mBlockTransient = false;

    int res;
    res = mRemoteStateMachineManager.Init();
    if (res != MP_NO_ERROR) {
        ETG_TRACE_ERR(("Dispatcher(): mRemoteStateMachineManager.Init()=%d", res));
    }
};

Dispatcher::~Dispatcher()
{
    mActiveStateMachinesLock.lock();

    int res;
    res = mRemoteStateMachineManager.DeInit();
    if (res != MP_NO_ERROR) {
        ETG_TRACE_ERR(("~Dispatcher(): mRemoteStateMachineManager.DeInit()=%d", res));
    }

    mActiveStateMachinesLock.unlock();
}

Dispatcher& Dispatcher::GetInstance(void)
{
    static Dispatcher dispatcher;
    return dispatcher;
}

int Dispatcher::Register( const SMF* stateMachine )
{
    ENTRY_INTERNAL
    Locker locker(&mActiveStateMachinesLock);

    int ret = MP_NO_ERROR;

    if(stateMachine != NULL && ((SMF*)stateMachine)->IsTransient() && mBlockTransient) {
        ret = MP_ERR_DISP_SM_NOT_REGISTERED;
        ETG_TRACE_ERR(("Register failed for transient SM %35s", ((SMF*)stateMachine)->GetSMNameFull()));
    } else if(stateMachine != NULL) {
        //CID 20018 (#1 of 1): Dereference after null check (FORWARD_NULL)
        mActiveStateMachines.push_back((SMF*)stateMachine);
        ETG_TRACE_USR1(("stateMachine->GetSMNameFull()=%35s, position=%d", ((SMF*)stateMachine)->GetSMNameFull(), (int)mActiveStateMachines.size()-1));
    } else {
        ret = MP_ERR_DISP_GEN_ERROR;
        ETG_TRACE_ERR(("Null pointer SM"));
    }
    return ret;
}

bool Dispatcher::IsRegistered( const SMF* stateMachine )
{
    ENTRY_INTERNAL
    Locker locker(&mActiveStateMachinesLock);

    for(unsigned int iter=0; iter < mActiveStateMachines.size(); iter++) {
        if(mActiveStateMachines.at(iter) == stateMachine) {
            ETG_TRACE_USR1(("stateMachine->GetSMNameFull()=%35s, position=%d", ((SMF*)stateMachine)->GetSMNameFull(), iter));
            return true;
        }
    }

    return false;
}

void Dispatcher::ForceNoDestruction()
{
    ENTRY_INTERNAL
    mDestructionFlag = 1;
}

int Dispatcher::DeRegister( const SMF* stateMachine )
{
    ENTRY_INTERNAL
    unsigned int iter;
    int ret = MP_ERR_DISP_SM_NOT_REGISTERED;

    /* TODO: work around for undefined destruction sequence between static and dynamic objects, must be solved by a clean solution */
    if (mDestructionFlag) return 0;

    mActiveStateMachinesLock.lock();

#if 0
    for (iter=0; iter< mActiveStateMachines.size(); iter++)
    {
        ETG_TRACE_USR1(("stateMachine->GetSMNameFull()=%35s, position=%d", mActiveStateMachines.at(iter)->GetSMNameFull(), iter));
    }
#endif

    for (iter=0; iter< mActiveStateMachines.size(); iter++)
    {
        if(mActiveStateMachines.at(iter) == stateMachine)
        {
            ETG_TRACE_USR1(("stateMachine->GetSMNameFull()=%35s, position=%d", ((SMF*)stateMachine)->GetSMNameFull(), iter));

            mActiveStateMachines.erase(mActiveStateMachines.begin() + iter);

            ret = MP_NO_ERROR;
            //break;
        }
    }

#if 0
    for (iter=0; iter< mActiveStateMachines.size(); iter++)
    {
        ETG_TRACE_USR1(("stateMachine->GetSMNameFull()=%35s, position=%d", mActiveStateMachines.at(iter)->GetSMNameFull(), iter));
    }
#endif

    mActiveStateMachinesLock.unlock();

    return ret;
}

int Dispatcher::DeRegisterAll( void )
{
    ENTRY

    mActiveStateMachinesLock.lock();
    mActiveStateMachines.clear();
    mActiveStateMachinesLock.unlock();

    return MP_NO_ERROR;
}

int Dispatcher::ReleaseWaitingAllTransient()
{
    ENTRY;
    unsigned int iter;
    int ret = MP_NO_ERROR;

    mActiveStateMachinesLock.lock();

    for (iter=0; iter< mActiveStateMachines.size(); iter++)
    {
        if(mActiveStateMachines.at(iter)->IsTransient())
        {
            ETG_TRACE_USR1(("release of transient stateMachine->GetSMNameFull()=%35s, position=%d", ((SMF*)mActiveStateMachines.at(iter))->GetSMNameFull(), iter));
            /*ret =*/ mActiveStateMachines.at(iter)->ReleaseWaiting();
            ret = mActiveStateMachines.at(iter)->SendEventByName("DONE", (char *)NULL); //PSARCCB-9154
        }
    }
    mActiveStateMachinesLock.unlock();

    return ret;
}

void Dispatcher::BlockAllTransient()
{
    ENTRY;

    //set flag to deny all new created transient SMs
    mBlockTransient = true;

    //release all waiting RequestResponse SMs
    ReleaseWaitingAllTransient();
}

void Dispatcher::UnblockAllTransient()
{
    ENTRY;

    //set flag to allow new creation of transient SMs
    mBlockTransient = false;
}

SMF* Dispatcher::GetSMHandle(const char* name)
{
    ENTRY_INTERNAL
    SMF* sm = NULL;
    unsigned int iter;
    if(NULL != name ){
    for(iter=0; iter < mActiveStateMachines.size(); iter++)
    {
        if(NULL != mActiveStateMachines[iter]->GetSMNameFull()){
            if(!strncmp(mActiveStateMachines[iter]->GetSMNameFull(),name, strlen_r(name)))
            {
                sm = mActiveStateMachines[iter];
                break;
            }
        }
    }
    }

    return sm;
}

#if 1

int Dispatcher::SendMessageAnswerInternal(const char *_message ,const char *_answer, const int localOnly,const char *answerParam)
{
    ENTRY_INTERNAL
    int ret = MP_NO_ERROR;

    mActiveStateMachinesLock.lock();

    /*
     * format of the _message: "StateMachineName::MessageName parameters"
     */

    /* extract info from message */
    tAllParameters message;
    if(_message != NULL){
    strncpy_r(message, _message, sizeof(message));
    }
    char *targetStateMachineName = message;
    char *cptr;

    /* search for end of state machine name */
    cptr = strstr(message, "::");
    if (!cptr) { // not valid: a message name is missing:
        mActiveStateMachinesLock.unlock();
        return MP_ERR_DISP_WRONG_ADRESS_FORMAT;
    }
    *cptr = 0; // end the state machine name

    /* process the message name */
    char *targetMessageName = cptr+2;
    char *messageParameters = NULL;
    cptr = strstr(targetMessageName, " "); // search the message to parameter seperator (space)
    if (cptr) { // message has parameters:
        *cptr = 0; // end the message name there
        messageParameters = cptr+1; // set the start of the parameters
    }

    /* set the target state machine name */
    SMF *targetStateMachine = GetSMHandle(targetStateMachineName);

    /* if an answer is defined: split this into state machine name and answer message name */
    tAllParameters answer;
    strncpy_r(answer, _answer, sizeof(answer));
    char *answerStateMachineName = NULL;
    char *answerMessageName = NULL;
    SMF *answerStateMachine = NULL;
    if (_answer && strlen_r(_answer)) {
        answerStateMachineName = answer;

        /* search for delimiter "::" */
        cptr = strstr(answerStateMachineName, "::");
        if (!cptr) { // no message name found
            mActiveStateMachinesLock.unlock();
            return MP_ERR_DISP_WRONG_ADRESS_FORMAT;
        }
        *cptr = 0; // limit the answer state machine name

        /* set start of message name */
        answerMessageName = cptr+2;

        /* set the answer state machine object */
        answerStateMachine = GetSMHandle(answerStateMachineName);
    }

    /* can the message be processed local? */
    if (targetStateMachine) { // target state machine object known to local process

        /* is an answer defined? */
        if (answerStateMachineName) { // message / answer pair

            /* Register release event */
            if(answerStateMachine != NULL) {
                answerStateMachine->RegisterReleaseEvent(answerMessageName,answerParam);
            }

            /* send message */
            ret = targetStateMachine->SendEventAnswerByName(targetMessageName, (char*)_answer, messageParameters);
            if (ret != 0) {
                ETG_TRACE_ERR(("Error %d on dispatching message/answer %48s/%s", ret, targetMessageName, answerMessageName));
                mActiveStateMachinesLock.unlock();
                return ret;
            }

        } else { // single message

            ret = targetStateMachine->SendEventByName(targetMessageName, messageParameters);
            // error in sending?
            if (ret != 0) {
                ETG_TRACE_ERR(("Error %d on dispatching message %s ", ret, targetMessageName));
                mActiveStateMachinesLock.unlock();
                return ret;
            }
        }

    } else if (!localOnly) { // target state machine not known to local process but message should be sent to remote process

        /* if an answer is defined, register it as release event in case the remote state machine does not answer */
        if(answerStateMachineName)
        {
            /* Register release event*/
            if(answerStateMachine != NULL) {
                answerStateMachine->RegisterReleaseEvent(answerMessageName,answerParam);
            }
        }

        /* send this message to other process(es) */
        ret = mRemoteStateMachineManager.SendMessage(_message, _answer);
        if (ret != MP_NO_ERROR) {
            ETG_TRACE_ERR(("Error %d in sending via RemoteStateMachineManager, message=%s", ret, _message));
            mActiveStateMachinesLock.unlock();
            return ret;
        }

    } else {

        ETG_TRACE_ERR(("No local state machine found and remote sending switched off: message=%s", _message));
    }

    mActiveStateMachinesLock.unlock();
    return ret;
}

#else

int Dispatcher::SendMessageAnswerInternal(const char *message ,const char *answer, const int localOnly)
{
    ENTRY_INTERNAL
    SMF* smObject;
    char *smMessage = NULL;
    char *msgParams = NULL;
    int ret = MP_ERR_DISP_GEN_ERROR;

    mActiveStateMachinesLock.lock();

    /* split the message into SM object name and message name and parameters*/
    string str (message);
    size_t messagePos = str.find("::");  /* message position    */
    size_t paramsPos  = str.find(" ");   /* parameters position */

    if(messagePos != string::npos)
    {
        smObject = GetSMHandle(str.substr ( 0,messagePos).c_str());

        if(smObject != NULL)
        {
            int smMessageNameLen = 1 + strlen_r(str.substr ( messagePos+2,paramsPos-(messagePos+2)).c_str());

            smMessage = new char[smMessageNameLen];
            if (!smMessage) {
                ret = MP_ERR_DISP_NO_MEM;
                goto end;
            }

            strcpy(smMessage,str.substr ( messagePos+2,paramsPos-(messagePos+2)).c_str());
            smMessage[smMessageNameLen-1] = 0; // end the string
            if(paramsPos != string::npos)
            {
                msgParams = new char[1 + strlen_r(str.substr ( paramsPos+1).c_str())];
                if (!msgParams) {
                    ret = MP_ERR_DISP_NO_MEM;
                    goto end;
                }

                strcpy(msgParams,str.substr ( paramsPos+1).c_str());
            }

            if(answer != NULL )
            {
                /* Split the answer into SM object name and answer message name*/
                string strAnswer(answer);
                size_t answerPos = strAnswer.find("::");  /* message position    */

                if(answerPos != string::npos)
                {
                    SMF* answerSMObject = GetSMHandle(strAnswer.substr( 0, answerPos ).c_str());

                    /* Register release event*/
                    if(answerSMObject != NULL)
                    {
                        answerSMObject->RegisterReleaseEvent(strAnswer.substr( answerPos+2 ).c_str());
                    }
                }

                ret = smObject->SendEventAnswerByName(smMessage, (char*)answer, msgParams);
                // error in sending?
                if (ret != 0) {
                    ETG_TRACE_ERR(("Error %d on dispatching message/answer %48s/%s", ret, message, answer));
                }
            }
            else
            {
                ret = smObject->SendEventByName(smMessage,msgParams);
                // error in sending?
                if (ret != 0) {
                    ETG_TRACE_ERR(("Error %d on dispatching message %s ", ret, message));
                }
            }

            if (smMessage) {
                delete[] smMessage ;
            }
            if (msgParams) {
                delete[] msgParams ;
            }

            if (ret == 0) {
                ETG_TRACE_USR4(("Dispatched State machine message %64s to SMObj=0x%x",message, smObject));
            }

        }
        else
        {
            /* if the message should be routed to another process */
            if (!localOnly) {

                /* No local state machine registered as expected in the input message name*/
                ETG_TRACE_USR1(("dbus-broadcast: %s",message));

                /* if an answer is defined, register it as release event in case the remote state machine does not answer */
                if(answer != NULL )
                {
                    /* Split the answer into SM object name and answer message name*/
                    string strAnswer(answer);
                    size_t answerPos = strAnswer.find("::");  /* message position    */

                    if(answerPos != string::npos)
                    {
                        SMF* answerSMObject = GetSMHandle(strAnswer.substr( 0, answerPos ).c_str());

                        /* Register release event*/
                        if(answerSMObject != NULL)
                        {
                            answerSMObject->RegisterReleaseEvent(strAnswer.substr( answerPos+2 ).c_str());
                        }
                    }
                }

                /* send this message to other process(es) */
                ret = mRemoteStateMachineManager.SendMessage(message, answer);
                if (ret != MP_NO_ERROR) {
                    ETG_TRACE_ERR(("Dispatcher::SendMessage: error %d in sending via RemoteStateMachineManager", ret));
                }
            /* message should be send only to local state machines */
            } else {
                ETG_TRACE_ERR(("Dispatcher::SendMessage: Statemachine not registered: %s", message));
                ret = MP_ERR_DISP_SM_NOT_REGISTERED;
            }
        }
    }
    else
    {
        ETG_TRACE_ERR(("Dispatcher::SendMessage->message(%s) is not in the expected format. It should be SMName::eventName ",message));
        ret = MP_ERR_DISP_WRONG_ADRESS_FORMAT;
    }

end:
    mActiveStateMachinesLock.unlock();
    return ret;
}

#endif

int Dispatcher::SendMessageAnswer(const char *message ,const char *answer)
{
    return SendMessageAnswerInternal(message, answer, 0);
}

int Dispatcher::SendMessageAnswerWithGivenAnsOnTimeOut(const char *message ,const char *answer,const char *answerParam)
{
    return SendMessageAnswerInternal(message, answer, 0,answerParam);
}

int Dispatcher::SendMessageAnswerLocal(const char *message, const char *answer)
{
    return SendMessageAnswerInternal(message, answer, 1);
}

int Dispatcher::SendMessageAnswer(const char *message, const char *parameter, const char *answer,const char *timeOutAnswerParam)
{
    ENTRY_INTERNAL
    char *_message;
    int res = MP_ERR_DISP_GEN_ERROR;

    /* parameter empty? send pure message */
    if (!parameter)
    {
        /* If given with Anwser to send along with
           ReleaseEvent on ANSWER_TIMOUT,then call SendMessageAnswerWithGivenAnsOnTimeOut */
        if(timeOutAnswerParam)
        {
            return SendMessageAnswerWithGivenAnsOnTimeOut(message, answer,timeOutAnswerParam);
        }
        else
        {
            return SendMessageAnswer(message, answer);
        }
    }

    /* create the message buffer */
    _message = (char *)malloc(strlen_r(message) + 1 + strlen_r(parameter) + 1);
    if (!_message) return MP_ERR_DISP_NO_MEM;

    /* fill it */
    strcpy(_message, message);
    strcat(_message, " ");
    strcat(_message, parameter);

    /* send it */
    /* If given with Anwser to send along with
    ReleaseEvent on ANSWER_TIMOUT,then call SendMessageAnswerWithGivenAnsOnTimeOut */
    if(timeOutAnswerParam)
    {
        res = SendMessageAnswerWithGivenAnsOnTimeOut(_message, answer,timeOutAnswerParam);
    }
    else
    {
        res = SendMessageAnswer(_message, answer);
    }

    /* free it */
    free(_message);

    return res;
}

int Dispatcher::SendMessage(const char *message )
{
    ENTRY_INTERNAL
    return SendMessageAnswer(message,NULL);
}

int Dispatcher::SendMessage(const char *message, const char *parameter )
{
    ENTRY_INTERNAL
    char *_message;
    int res;

    /* parameter empty? send pure message */
    if (!parameter) return SendMessage(message);

    /* create the message buffer */
    _message = (char *)malloc(strlen_r(message) + 1 + strlen_r(parameter) + 1);
    if (!_message) return MP_ERR_DISP_NO_MEM;

    /* fill it */
    strcpy(_message, message);
    strcat(_message, " ");
    strcat(_message, parameter);

    /* send it */
    res = SendMessageAnswer(_message,NULL);

    /* free it */
    free(_message);

    return res;
}
int Dispatcher::LockActiveStateMachines()
{
    return mActiveStateMachinesLock.lock();
}
void Dispatcher::UnLockActiveStateMachines()
{
     mActiveStateMachinesLock.unlock();
}
