/*
 * Utils.h
 *
 *  Created on: Feb 14, 2013
 *      Author:
 */

#ifndef UTILS_H_
#define UTILS_H_

#include "TraceDefinitions.h"

/**
 * macros to mark parameters data flow direction
 */
#define IN
#define OUT
#define INOUT

/**
 * definiton of the media player assert call
 */
#include <assert.h>
#include <string>
#include <time.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/stat.h>
#include <dirent.h>
#include <algorithm>
#include <iostream>
#include <iomanip>
#include <sstream>
using namespace std;

#ifdef TARGET_BUILD
#if OSAL_OS == OSAL_LINUX

void MP_AssertFunction(const char* exp, const char* file, unsigned int line);

#ifndef FATAL_M_ASSERT_MEDIA
#define FATAL_M_ASSERT_MEDIA(_INT_) ((_INT_) ? (void)(0) : (MP_AssertFunction(#_INT_, __FILE__, (__LINE__)&(~0x80000000))) )
#endif

#ifndef NORMAL_M_ASSERT_MEDIA
#define NORMAL_M_ASSERT_MEDIA(_INT_) ((_INT_) ? (void)(0) : (MP_AssertFunction(#_INT_, __FILE__, (__LINE__)|0x80000000)) )
#endif

#define MP_FATAL_ASSERT FATAL_M_ASSERT_MEDIA
#define MP_NORMAL_ASSERT NORMAL_M_ASSERT_MEDIA
#else
#define MP_FATAL_ASSERT(a)  if(!(a))printf(" ********** FATAL ASSERT @ Function:%s , Line:%d: "#a,__FUNCTION__,__LINE__);
#define MP_NORMAL_ASSERT(a)  if(!(a))printf(" ********** NORMAL ASSERT @ Function:%s , Line:%d: "#a,__FUNCTION__,__LINE__);
#endif
#else
#define MP_FATAL_ASSERT assert
#define MP_NORMAL_ASSERT(a) if(!(a))fprintf(stderr, " ********** NORMAL ASSERT @ Function:%s , Line:%d: "#a,__FUNCTION__,__LINE__);
#endif

char *itoa(int value, char *c, int base);
char *lltoa(long long value, char *c, int base);
char *ulltoa(unsigned long long value, char *c, int base);
int toUtf8Fake(char *outBuffer, const size_t outBufferLen, const char *inBuffer);
int fromUtf8Fake(char *outBuffer, const size_t outBufferLen, const char *inBuffer);
char *strncat_r(char *dest, const char *src, size_t sizeOfDest);
char *strncpy_r(char *dest, const char *src, size_t sizeOfDest);
char *strupper(char *s);
char *strlower(char *s);
char *strtrim(char *str);
string base64_encode(unsigned char const* , unsigned int len);
string base64_decode(string const& s);
void hexDump(FILE *fp, const char *desc, void *addr, int len);
int exists_file(const char *filePath);
int exists_directory(const char *directoryPath); //Roadmap 15009: 100%
int checkIfMounted(const char *mountPoint);
int remove_directory(const char *path); //Roadmap 15009: 100%
char *getMediaPlayerBinPath();
size_t getCurrentRSS();
int isHexadecimalString(char *str);
int strlen_r(const char *src);
mode_t getfileMode(const char* path);
std::string toString(int num);
bool isStartWith(const char* str1,const char* str2);
std::string string_to_hex(const char* inStr,int length=0);
void SetThreadNiceProperty(int tId, int reniceVal);
int RemoveDirectory(string folderPath, bool deleteDir, string matchingPattern = "");
int executeCommand(char *commandStr[],string tempFileName = "");
bool isDirOpenable(const char *path);

#endif /* UTILS_H_ */
