/*
 * ErrorCatcher.h
 *
 *  Created on: Mar 27, 2015
 *      Author: thm3hi
 */

#ifndef LONG_RUNNER_CATCHER_H_
#define LONG_RUNNER_CATCHER_H_

#include <setjmp.h>     /* jmp_buf, setjmp, longjmp */
#include <signal.h>
#include <time.h>

#include "Timer.h"

#define LR_ON 0

#if LR_ON

/*
 * There was an idea to implement a long runner catcher by starting a timer, calling the long-runner
 * function and when the timer expieres a signal handler does a longjmp to the position after
 * the long-runner call.
 *
 * unfortunately the behavior of of longjmp called from a signal handler is not defined.
 * It did in one test but it does not function in general.
 *
 * All implementations of this functions are wiped out.
 *
 * If soemone has a good idea to implement that,
 * we will re-introduce this functionality.
 *
 * Thömel, 31.03.2015
 */

/* prototypes */
void LongRunnerCatcherCreateTimer(timer_t *timerId, const long timeout, const void *context);
void LongRunnerCatcherInit();
void LongRunnerDestroyTimer(const timer_t timerId);

/* defines used by user */
#define LR_INIT /* initializes the long runner catcher */ \
    jmp_buf env; \
    timer_t ecTimerID; \
    LongRunnerCatcherInit();
#define LR_CATCH(timeout, errorValue) /* starts catching of a long runner */ \
    ((LongRunnerCatcherCreateTimer(&ecTimerID, timeout, (void *)&env), setjmp(env)) ? errorValue :
#define LR_CATCH_END /* end of long running catcher */ \
    ); LongRunnerDestroyTimer(ecTimerID);

/*
 * usage:
 *
 * old function call which has to be long running catched in future:
 *
 *   res = someMethodReturningInt(...);
 *
 * catching long runner inside function by using LR macros:
 *
 *   LR_INIT;
 *   res = LR_CATCH(1000, -99) someMethodReturningInt(...) LR_CATCH_END;
 *   if (res == -99) {
 *     printf("long runner catched after 1000 ms\n");
 *   }
 *
 */

#else // LR_ON

/* empty defines used by user */
#define LR_INIT
#define LR_CATCH(timeout, errorValue)
#define LR_CATCH_END

#endif // LR_ON

#endif /* LONG_RUNNER_CATCHER_H_ */
