/*
 * Lock.h
 *
 *  Created on: Aug 22, 2012
 *      Author: tritonsu
 */
#ifndef LOCK_H_
#define LOCK_H_

#ifdef WIN32
#include <windows.h>
#endif

#ifdef __linux__
#include <pthread.h>
#include <assert.h>
#include <errno.h>
#endif

#include <stdio.h>

class Lock
{
public:
    Lock();
    int lock();
    void unlock();
    int setNotReantrant();
    void setTimeout(const unsigned int sec);
    unsigned int getTimeout() {return mToValue;};
    ~Lock();
    int locked() {return isLocked;};

private:
    unsigned int mToValue;
    unsigned int isLocked;
    pthread_mutex_t mutex;
};

class Locker {
public:
    Locker(Lock * pMutex) :
        mpMutex(pMutex) {
        if (mpMutex) {
            mpMutex->lock();
        }
    };

    ~Locker() {
        if (mpMutex) {
            mpMutex->unlock();
        }
    };

private:
    Lock* mpMutex;
};

#endif /* LOCK_H_ */
