/**
 * @addtogroup iPodControl
 * @author Ulrich Deuper
 *
 * Helper class for time measurement (native LINUX style)
 * @{
 */


#ifndef _ELAPSEDTIMER_H_
#define _ELAPSEDTIMER_H_

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

/**
 * Elapsed timer class
 */
class ElapsedTimer {
public:
	ElapsedTimer() {					/**< constructor*/
		Restart();
	};

	void Reset() { 						/**< reset start timeval*/
		start.tv_sec = 0;
		start.tv_usec = 0;
	};

	void Restart(){						/**< restart time sampling*/
		gettimeofday(&start, NULL);
	};

	unsigned long ElapsedUS() const { 		/**< return elapsed microseconds */
		timeval end;
		gettimeofday(&end, NULL);
		return (unsigned long)
		        (
		         (((unsigned long long)  end.tv_sec * 1000000L) +   end.tv_usec) -
		         (((unsigned long long)start.tv_sec * 1000000L) + start.tv_usec)
		        );
	};

	unsigned long ElapsedMS() const { 		/**< return elapsed milliseconds */
		return (ElapsedUS() / 1000);
	};

	unsigned long ElapsedS() const { 			/**< return elapsed seconds */
		return (ElapsedUS() / 1000000);
	};

	void ElapsedPrint(tGeneralString &str) const { 			/**< print elapsed time hh:mm:ss.mmm*/
		unsigned long ms = ElapsedMS();
		snprintf(str, sizeof(str), "%02d:%02d:%02d.%03d", (int)(ms/3600000), (int)((ms/60000)%60), (int)((ms/1000)%60), (int)(ms%1000));
	};

private:
	timeval start;
};

#endif //_ELAPSEDTIMER_H_
/** @} */
