/*
 * BaseTypes.h
 *
 *  Created on: Feb 18, 2013
 *      Author: Dinesh
 */

#ifndef BASETYPES_H_
#define BASETYPES_H_

#include <stdint.h>

/***********************
 * Base type definitions
 ***********************/

/**
 * Type declaration of a general unsigned integer
 */
typedef unsigned int tUInt;

/**
 * Type declaration of a general boolean
 */
typedef int tBoolean;
#define tBoolean_format "i"
#define tBoolean_init 0

/**
 * this typedef is for the output wrapper only
 */
typedef unsigned char tBool;

/**
 * Type declaration of a general signed 8 bit integer
 */
typedef signed char tS8;

/**
 * Type declaration of a general unsigned 8 bit integer
 */
typedef unsigned char tU8;

/**
 * Type declaration of a general unsigned 16 bit integer
 */
typedef unsigned short tU16;

/**
 * Type declaration of a general signed 32 bit integer
 */
typedef uint32_t tU32;

/**
 * Type declaration of a general signed 32 bit integer
 */
typedef int32_t tS32;

/**
 * Type declaration of a general signed 64 bit integer
 */
typedef int64_t tS64;

/**
 * Type declaration of a general unsigned 64 bit integer
 */
typedef uint64_t tU64;


/**
 * Type declaration of a test string
 */
typedef char tTestString[256];
#define tTestString_format "t"

/**
 * Type declaration of a general string
 */
typedef char tGeneralString[256];

/**
 * Type declaration for a special parameter for the request/response state machine to fetch all parameters as one string
 * Also used as general type for all parameter sent via SMF
 */
typedef char tAllParameters[4096];
#define tAllParameters_format "a"


/**
 * Type declaration for return value of a function
 */
typedef int tResult;
#define tResult_format "i"
#define tResult_init 0

/**
 * Type declaration of a general signed integer
 */
typedef int tInteger;
#define tInteger_format "i"
#define tInteger_init 0

/**
 * Type declaration of a general signed 16 bit integer
 */
typedef signed short tS16;


#endif /* BASETYPES_H_ */
