/*
 * FC_MediaPlayer_rootdaemon_client.h
 *
 *  Created on: Jan 16, 2018
 *      Author: Ganesh Rengasamy
 */
#ifndef _FC_MEDIAPLAYER_ROOTDAEMON_CLIENT_H_
#define _FC_MEDIAPLAYER_ROOTDAEMON_CLIENT_H_

#include <RootDaemonTypes.h>
#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>

#define GMP_COMMANDS_DELIM "\377"

static const char* FC_MEDIAPLAYER_CLIENT_NAME = "FC_Mediaplayer";

CmdData execRootCommand(const char * clientName, const int cmdNum,
        const char * args = "", const long timeoutSec = 0);

enum fc_mp_commands_t
{
    GMP_CMD_UNMOUNT, // = 0
    GMP_IAP_LOAD_MODULE,
    GMP_IAP_UNLOAD_MODULE,
    GMP_IAP_COMMON_WRITE,
    GMP_IAP_MOUNT,
    GMP_IAP_UMOUNT,
    GMP_IAP_MOUNT_CONFIGFS,
    GMP_IAP_UMOUNT_CONFIGFS,
    GMP_FILE_CHMOD,
    GMP_MOUNT_OPERATION,

    GMP_CMD_MANUAL_UDEVRELOADRULES
};

//>--Roadmap CMG3G-10221 : 'Scene Recorder '
int setfilePermission(const string path, string mode);
int setMountOperation(const string path, const string fileType, const string mode);
//<--Roadmap CMG3G-10221 : 'Scene Recorder '

int ExecuteUnmountOperation(const string args);
int LoadIAPModules(const string args);
int UnloadIAPModules(const string args);
int ExecuteIAP2CommonWrite(string args);
int ExecuteIAPMountOperation();
int ExecuteIAPUnmountOperation();
int ExecuteIAPMountConfigs(const string args);
int ExecuteIAPUnmountConfigs();
int ChangeFilePermissions(const string args);
int ExecuteMountOperation(string args);
int ReloadUdevRules();

#endif //_FC_MEDIAPLAYER_ROOTDAEMON_CLIENT_H_
