#ifndef _IPODCONTROLTEST_H_
#define _IPODCONTROLTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"

class iPodControlTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( iPodControlTest );
    CPPUNIT_TEST( InitIPC );
#if defined(TARGET_BUILD) && !defined(TARGET_BUILD_GEN3)
    CPPUNIT_TEST( StartAuthenticationCCAApp );
#endif

    CPPUNIT_TEST( InitDeviceConnection );
    CPPUNIT_TEST( SwitchObserver );
    CPPUNIT_TEST( AllocateAudioInput );
    CPPUNIT_TEST( StartStreaming );
    CPPUNIT_TEST( Play );
    CPPUNIT_TEST( Pause );
    CPPUNIT_TEST( SeekTo );
    CPPUNIT_TEST( Resume );
    CPPUNIT_TEST( Stop );
    //CPPUNIT_TEST( DisconnectDevice );

#if defined(TARGET_BUILD) && !defined(TARGET_BUILD_GEN3)
    CPPUNIT_TEST( StopAuthenticationCCAApp );
#endif
    CPPUNIT_TEST_SUITE_END();

public:

    iPodControlTest();

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

#if defined(TARGET_BUILD) && !defined(TARGET_BUILD_GEN3)
    //ipodauthentication
    void StartAuthenticationCCAApp();
    void StopAuthenticationCCAApp();
#endif

    /*test cases*/
    void InitIPC();
    void InitDeviceConnection();
    void DisconnectDevice();
    void AllocateAudioInput();
    void SwitchObserver();
    void StartStreaming();
    void Play();
    void Stop();
    void Pause();
    void Resume();
    void SeekTo();

private:
    TimeTrace ticks;        /**< time object to trace the time taken by testcases */

};

#endif  // _IPODCONTROLTEST_H_
