#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/iPodControlTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#ifdef TARGET_BUILD
//nedded for access to Apple co-processor on Tengine using ipodauthentication (CCA)
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"
#if defined(TARGET_BUILD) && !defined(TARGET_BUILD_GEN3)
#include "IPODAuthnt_main.h"
#endif
#endif

#include "iPodControl.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "RequestResponseSM.h"

#include "iPodControlTest.h"


class iPodTestSM: public RequestResponseSM
{
    int HandleInitRequest()
    {
        return 0;
    }

    int HandleSuccessRequest(const tAllParameters allParameters)
    {
        /* the request/expect state machine has a general SUCCESS_REQUEST message which is not
        // specialized to a service state machine be called, so all kind of parameters must
        // be processed by hand in this method. */
        ETG_TRACE_USR1(("iPodTestSM::HandleSuccessRequest allParameters:%s", allParameters));
        return 0;
    }
};

iPodControlTest::iPodControlTest() {
}

void iPodControlTest::setUp() {
    ticks.begin();
}

void iPodControlTest::tearDown() {
    ticks.elapsed();
}

void iPodControlTest::InitIPC()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start iPodControlTest::InitIPC***"));

    tResult ret = MP_NO_ERROR;

    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));

    /* Call StartAllocateAudioOutput */
    ret = LocalSPM::GetDeviceDispatcher().StartAllocateAudioOutput(IN audioOutputDevice);

    sleep(2); //Wait a little bit until IPC is initialized

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

/**********************************************************************
 * ipodauthentication
 *********************************************************************/
#if defined(TARGET_BUILD) && !defined(TARGET_BUILD_GEN3)
//nedded for access to Apple co-processor on Tengine using ipodauthentication (CCA)
static OSAL_tMQueueHandle hTempMessageQueueHdl = OSAL_C_INVALID_HANDLE;

void iPodControlTest::StartAuthenticationCCAApp() {
    ENTRY;
    ETG_TRACE_USR1((" *** Start iPodControlTest::StartAuthenticationCCAApp***"));

    //SCD init
    scd_init();

    //create MQ
    OSAL_s32MessageQueueCreate("mbx_7777", 100, 8, OSAL_EN_READWRITE,
            &hTempMessageQueueHdl);

    //Start App
    ipodauthnt_main_tclApp::m_poMainAppInstance = new ipodauthnt_main_tclApp();
    if (ipodauthnt_main_tclApp::m_poMainAppInstance != NULL && !ipodauthnt_main_tclApp::m_poMainAppInstance->bInitInstance(
            7777, CCA_C_U16_APP_AVTESTSERVER)) {
        CPPUNIT_ASSERT(false);
        ETG_TRACE_ERR(("iPodControlTest::StartAuthenticationCCAApp() -  initialization failed"));
    } else {
        sleep(1);
        ETG_TRACE_USR2(("iPodControlTest::StartAuthenticationCCAApp() -  initialization done"));
    }

    //transition to INIT state
    amt_tclPowerMessage oPowerMessageStart(7777, CCA_C_U16_APP_AVTESTSERVER,
            AMT_C_U16_PWR_PROXY_START_CONF, 0, 0);

    if (ipodauthnt_main_tclApp::m_poMainAppInstance->bPostIpcMessage(7777,
            ipodauthnt_main_tclApp::m_poMainAppInstance->hGetMyInQueue(),
            &oPowerMessageStart, AIL_C_U32_CCA_PRIO_MSG_POWER)) {
        sleep(1);
    } else {
        CPPUNIT_ASSERT(false);
        ETG_TRACE_ERR(("iPodControlTest::StartAuthenticationCCAApp() - bPostIpcMessage(oPowerMessageStart) failed"));
    }

    //transition to NORMAL state
    amt_tclPowerMessage oPowerMessageNormal(7777, CCA_C_U16_APP_AVTESTSERVER,
            AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ, AMT_C_U32_STATE_NORMAL, 0);

    if (ipodauthnt_main_tclApp::m_poMainAppInstance->bPostIpcMessage(7777,
            ipodauthnt_main_tclApp::m_poMainAppInstance->hGetMyInQueue(),
            &oPowerMessageNormal, AIL_C_U32_CCA_PRIO_MSG_POWER)) {
        sleep(1);
    } else {
        CPPUNIT_ASSERT(false);
        ETG_TRACE_ERR(("iPodControlTest::StartAuthenticationCCAApp() - bPostIpcMessage(oPowerMessageNormal) failed"));
    }

    amt_tclServiceSupplierStatus oServiceSupplierState(7777,
            CCA_C_U16_APP_AVTESTSERVER, CCA_C_U16_SRV_IPODAUTH, CCA_C_U16_APP_IPODAUTH,
            AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE);

    if (ipodauthnt_main_tclApp::m_poMainAppInstance->bPostIpcMessage(7777,
            ipodauthnt_main_tclApp::m_poMainAppInstance->hGetMyInQueue(),
            &oServiceSupplierState, AIL_C_U32_CCA_PRIO_MSG_POWER)) {
        sleep(1);
    } else {
        CPPUNIT_ASSERT(false);
        ETG_TRACE_ERR(("iPodControlTest::StartAuthenticationCCAApp() - bPostIpcMessage(oServiceSupplierState) failed"));
    }
}

void iPodControlTest::StopAuthenticationCCAApp() {
    ENTRY;
    ETG_TRACE_USR1((" *** Start iPodControlTest::StopAuthenticationCCAApp***"));

    if (ipodauthnt_main_tclApp::m_poMainAppInstance != NULL) {

        //transition to INIT state
        amt_tclPowerMessage oPowerMessageEnd(7777,
                CCA_C_U16_APP_AVTESTSERVER, AMT_C_U16_PWR_PROXY_END_APP, 0,
                0);

        if (ipodauthnt_main_tclApp::m_poMainAppInstance->bPostIpcMessage(7777,
                ipodauthnt_main_tclApp::m_poMainAppInstance->hGetMyInQueue(),
                &oPowerMessageEnd, AIL_C_U32_CCA_PRIO_MSG_POWER)) {
            sleep(1);
        } else {
            CPPUNIT_ASSERT(false);
            ETG_TRACE_ERR(("iPodControlTest::StopAuthenticationCCAApp() - bPostIpcMessage(oPowerMessageEnd) failed"));
        }

        //stop App
        ipodauthnt_main_tclApp::m_poMainAppInstance->vDeinitInstance();
        delete ipodauthnt_main_tclApp::m_poMainAppInstance;
        sleep(1);
    }
    else
    {
        ETG_TRACE_ERR(("iPodControlTest::StopAuthenticationCCAApp() - m_poMainAppInstance NULL pointer"));
        CPPUNIT_ASSERT(false);
    }

    //close MQ
    OSAL_s32MessageQueueClose(hTempMessageQueueHdl);
    hTempMessageQueueHdl = OSAL_C_INVALID_HANDLE;
}
#endif //ipodauthentication

/**********************************************************************
 * Test cases
 *********************************************************************/
void iPodControlTest::InitDeviceConnection()
{
    ENTRY;
    ETG_TRACE_USR1((" *** Start iPodControlTest::InitDeviceConnection***"));

    tResult ret = MP_NO_ERROR;
    tDeviceID deviceID;
    tMountPoint mountPoint = IPODCONTROL_HID_DEFAULT;

    /* Call InitDeviceConnection */
    //ret = LocalSPM::GetIPODControl().IsInitRequired(mountPoint, deviceID);

    iPodTestSM objMyRRSM;
	
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_IPOD, IN "IPOD");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Send INIT_DEVICE_CONNECTION message to iPodControlSM */

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tDeviceInfo deviceInfo;
    InitDeviceInfo(deviceInfo);
    deviceInfo.deviceID = deviceID;
    strncpy_r(deviceInfo.mountPoint, mountPoint, sizeof(deviceInfo.mountPoint));
    tDeviceInfoString deviceInfoString;
    DataProvider::MarshalDeviceInfo(deviceInfoString, deviceInfo);

    ret = LocalSPM::GetIPODControl().ParameterINIT_DEVICE_CONNECTION(
            OUT parameterString, IN size, IN deviceInfoString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetIPODControl().SendEventByName("INIT_DEVICE_CONNECTION", IN parameterString);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void iPodControlTest::DisconnectDevice()
{
    ENTRY;
    ETG_TRACE_USR1((" *** Start iPodControlTest::DisconnectDevice***"));

    tResult ret = MP_NO_ERROR;
    tMountPoint mountPoint = IPODCONTROL_HID_DEFAULT;

    /* Call Disconnect iPod */
    ret = LocalSPM::GetIPODControl().Disconnect(mountPoint,IDP_IAP1);
    if(ret == MP_NO_ERROR)
    {
        //give some time for iap detach callback processing
        sleep(1);
    }
    // test result
    CPPUNIT_ASSERT(ret == MP_NO_ERROR);
}

void iPodControlTest::AllocateAudioInput()
{
    ENTRY
    ETG_TRACE_USR1((" ***Start iPodControlTest::AllocateAudioInput***"));

    tResult ret = MP_NO_ERROR;
    tMountPoint mountPoint = IPODCONTROL_HID_DEFAULT;

    /* Call StartAllocateAudioInput */
    //ret = LocalSPM::GetIPODControl().StartAllocateAudioInput(mountPoint);

    iPodTestSM objMyRRSM;

    /* Send ALLOCATE_AUDIO_INPUT message to iPodControlSM */
    char messageString[256];
    strncpy_r(messageString, "iPodControlSM::ALLOCATE_AUDIO_INPUT", sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    tDeviceID deviceID;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, mountPoint);
    //CPPUNIT_ASSERT(res == 0);

    ret = LocalSPM::GetIPODControl().ParameterALLOCATE_AUDIO_INPUT(OUT parameterString,
            IN size, IN deviceID, IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, IPOD_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void iPodControlTest::SwitchObserver()
{
    ENTRY
    ETG_TRACE_USR1((" ***Start iPodControlTest::SwitchObserver***"));

    tResult ret = MP_NO_ERROR;

    /* Call StartSwitchObserver */
    //ret = LocalSPM::GetIPODControl().StartSwitchObserver();

    iPodTestSM objMyRRSM;

    /* Send SWITCH_OBSERVER message to iPodControlSM */
    char messageString[64];
    strncpy_r(messageString, "iPodControlSM::SWITCH_OBSERVER", sizeof(messageString));

    ret = objMyRRSM.DoEventAnswer(IN messageString, (char *)NULL, NULL, IPOD_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void iPodControlTest::StartStreaming()
{
    ENTRY
    ETG_TRACE_USR1((" ***Start iPodControlTest::StartStreaming***"));

    tResult ret = MP_NO_ERROR;
    tMountPoint mountPoint = IPODCONTROL_HID_DEFAULT;

    /* Call StartStreaming */
    //ret = LocalSPM::GetIPODControl().StartStreaming(mountPoint);

    iPodTestSM objMyRRSM;

    /* Send START_STREAMING message to iPodControlSM */
    char messageString[256];
    strncpy_r(messageString, "iPodControlSM::START_STREAMING",
            sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    tDeviceID deviceID;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, mountPoint);
    //CPPUNIT_ASSERT(res == 0);

    ret = LocalSPM::GetIPODControl().ParameterSTART_STREAMING(
            OUT parameterString, IN size, IN deviceID, IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, IPOD_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void iPodControlTest::Play()
{
    ENTRY
    ETG_TRACE_USR1((" ***Start iPodControlTest::iPodControlTest::Play***"));

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_IPOD;
    tDeviceID deviceID = 2;
    tMountPoint mountPoint = IPODCONTROL_HID_DEFAULT;
    tUUID uuid = {0};
    tPlaytime position = 0;
    tObjectID objectID = 4711;
    tURL URL = "/Track=1";
    tStreaming streaming = false;

    /* Call StartPlay */
    //ret = LocalSPM::GetIPODControl().StartPlay(IN deviceType, IN deviceID, IN URL, IN mountPoint, IN position);

    iPodTestSM objMyRRSM;

    /* Send PLAY message to iPodControlSM */
    char messageString[256];
    strncpy_r(messageString, "iPodControlSM::PLAY", sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIPODControl().ParameterPLAY(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint, IN uuid,IN objectID, IN position, IN streaming);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, IPOD_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    sleep(5); //play at least 5s
}

void iPodControlTest::Stop()
{
    ENTRY
    ETG_TRACE_USR1((" ***Start iPodControlTest::Stop***"));

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_IPOD;
    tDeviceID deviceID = 2;
    tMountPoint mountPoint = IPODCONTROL_HID_DEFAULT;
    tURL URL = "/Track=1";

    /* Call StartStop */
    //ret = LocalSPM::GetIPODControl().StartStop(IN deviceType, IN deviceID, IN URL, IN mountPoint);

    iPodTestSM objMyRRSM;

    /* Send STOP message to iPodControlSM */
    char messageString[256];
    strncpy_r(messageString, "iPodControlSM::STOP", sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIPODControl().ParameterSTOP(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, IPOD_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void iPodControlTest::Pause()
{
    ENTRY
    ETG_TRACE_USR1((" ***Start iPodControlTest::Pause***"));

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_IPOD;
    tDeviceID deviceID = 2;
    tMountPoint mountPoint = IPODCONTROL_HID_DEFAULT;
    tURL URL = "/Track=1";

    /* Call StartPause */
    //ret = LocalSPM::GetIPODControl().StartPause(IN deviceType, IN deviceID, IN URL, IN mountPoint);

    iPodTestSM objMyRRSM;

    /* Send PAUSE message to iPodControlSM */
    char messageString[256];
    strncpy_r(messageString, "iPodControlSM::PAUSE", sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIPODControl().ParameterPAUSE(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, IPOD_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    sleep(2); //pause at least 2s
}

void iPodControlTest::Resume()
{
    ENTRY
    ETG_TRACE_USR1((" ***Start iPodControlTest::Resume***"));

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_IPOD;
    tDeviceID deviceID = 2;
    tMountPoint mountPoint = IPODCONTROL_HID_DEFAULT;
    tURL URL = "/Track=1";

    /* Call StartResume */
    //ret = LocalSPM::GetIPODControl().StartResume(IN deviceType, IN deviceID, IN URL, IN mountPoint);

    iPodTestSM objMyRRSM;

    /* Send RESUME message to iPodControlSM */
    char messageString[256];
    strncpy_r(messageString, "iPodControlSM::RESUME", sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIPODControl().ParameterRESUME(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, IPOD_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    sleep(5); //play at least 5s
}

void iPodControlTest::SeekTo()
{
    ENTRY
    ETG_TRACE_USR1((" ***Start iPodControlTest::SeekTo***"));

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_IPOD;
    tDeviceID deviceID = 2;
    tMountPoint mountPoint = IPODCONTROL_HID_DEFAULT;
    tURL URL = "/Track=1";
    tPlaytime position = 105000; //1:45min

    /* Call StartSeekTo */
    //ret = LocalSPM::GetIPODControl().StartSeekTo(IN deviceType, IN deviceID, IN URL, IN mountPoint, IN position);

    iPodTestSM objMyRRSM;

    /* Send SEEK_TO message to iPodControlSM */
    char messageString[256];
    strncpy_r(messageString, "iPodControlSM::SEEK_TO", sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIPODControl().ParameterSEEK_TO(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint, IN position);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, IPOD_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}
