#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/RipperControlTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "CDRipperControl.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "RequestResponseSM.h"
#include "TimeTrace.h"
#include "RipperControlTest.h"
#include "taginfo.h"
#include "MediaPlayerInterface.h"
#include "VarTrace.h"
using namespace TagInfo;

class RipperControlTestSM: public RequestResponseSM
{
    int HandleInitRequest()
    {
        mResult = MP_NO_ERROR;
        return 0;
    }

    int HandleSuccessRequest(const char *allParameters)
    {
        /* the request/expect state machine has a general SUCCESS_REQUEST message which is not
        // specialized to a service state machine be called, so all kind of parameters must
        // be processed by hand in this method. */
        ETG_TRACE_USR1(("RipperControlTestSM::HandleSuccessRequest allParameters:%s", allParameters));
        return 0;
    }

    int HandleActionError(const reason_e reason)
    {
        //ETG_TRACE_ERR(("RipperControlTestSM::HandleActionError reason:%u", reason));
        (void)reason;
        mResult = MP_ERR_ACTION_ERROR;
        return 0;
    }

public:
    tResult mResult;
};


void RipperControlTest::setUp()
{
    ticks.begin();
}

void RipperControlTest::tearDown()
{
    ticks.elapsed();
}


void RipperControlTest::SetAutoRipping()
{
    ENTRY
    tResult retVal= MP_NO_ERROR;
    retVal = MediaPlayerInterface::GetInstance().SetAutoRipping(true);
    GMPTEST_EXPECT(MP_NO_ERROR == retVal);
}

/**********************************************************************
 * Test cases
 *********************************************************************/
void RipperControlTest::StartDiscRipping()
{
    ENTRY
    ETG_TRACE_USR1(("***RipperControlTest::StartDiscRipping***"));
    // TOC structure similar to the received from CDDA is framed and passed to CDRipperControl::IsRippingEnabled
    tCDTOCInfo *ptr = new tCDTOCInfo;
    memset(ptr, 0, sizeof(tCDTOCInfo));
    ptr->u8MinTrack = 1;
    ptr->u8MaxTrack = 8;
    strncpy_r(OUT ptr->albumName, IN "", IN sizeof(ptr->albumName));

    ptr->arTrack[0].u32StartZLBA = 0x200;
    strncpy_r(OUT ptr->arTrack[0].performer, IN "Performer 1", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[0].title, IN "Title a", IN sizeof(tMetadata));

    ptr->arTrack[1].u32StartZLBA = 0x52511;
    strncpy_r(OUT ptr->arTrack[1].performer, IN "Performer 2", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[1].title, IN "Title b", IN sizeof(tMetadata));

    ptr->arTrack[2].u32StartZLBA = 0xb002b;
    strncpy_r(OUT ptr->arTrack[2].performer, IN "Performer 3", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[2].title, IN "Title c", IN sizeof(tMetadata));

    ptr->arTrack[3].u32StartZLBA = 0xf3a1f;
    strncpy_r(OUT ptr->arTrack[3].performer, IN "Performer 4", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[3].title, IN "Title d", IN sizeof(tMetadata));

    ptr->arTrack[4].u32StartZLBA = 0x152849;
    strncpy_r(OUT ptr->arTrack[4].performer, IN "Performer 5", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[4].title, IN "Title e", IN sizeof(tMetadata));

    ptr->arTrack[5].u32StartZLBA = 0x1b1149;
    strncpy_r(OUT ptr->arTrack[5].performer, IN "Performer 6", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[5].title, IN "", IN sizeof(tMetadata));

    ptr->arTrack[6].u32StartZLBA = 0x221e2f;
    strncpy_r(OUT ptr->arTrack[6].performer, IN "Performer 7", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[6].title, IN "", IN sizeof(tMetadata));

    ptr->arTrack[7].u32StartZLBA = 0x281310;
    strncpy_r(OUT ptr->arTrack[7].performer, IN "Performer 8", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[7].title, IN "", IN sizeof(tMetadata));


    tResult ret = MP_NO_ERROR;
    /* Send REMOVE_DEVICE_CONNECTION message to USBControlSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetCDRipperControl().ParameterAUDIO_DISC_DETECTED(OUT parameterString,
            IN size, IN ptr);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ret = LocalSPM::GetCDRipperControl().SendEventByName("AUDIO_DISC_DETECTED", IN parameterString);
    sleep(2);

    tRippedFilePath SourceFilePath;
    strncpy_r(OUT SourceFilePath, IN get_current_dir_name(), IN sizeof(tRippedFilePath));

    //trigger completion event
    ret = LocalSPM::GetCDRipperControl().ParameterRIPPER_STATUS(OUT parameterString,
            IN size, IN 1, IN PE_PBS_PLAYINGSTATE, IN REASON_EMPTY);
    for (int index = 0; index < 8; index++)
    {
        char data[8] = {0};
        snprintf(data, sizeof(data), "%d", index+1);

        tSearchString commandString;
        strncpy_r(commandString, "cp ", sizeof(commandString));
        strncat_r(commandString, SourceFilePath, sizeof(commandString));
        strncat_r(commandString, "/Customer/Simulation/CustomControl/stick_rip/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        strncat_r(commandString, " ", sizeof(commandString));

        strncat_r(commandString, "/var/opt/bosch/dynamic/media/CDRipping/d0e4b2843d9876c9dbfaf8d3c884aebc/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        ETG_TRACE_USR3(("commandString: %s", commandString));
        system(commandString);

        sleep(2);

        ret = LocalSPM::GetCDRipperControl().SendEventByName("RIPPER_STATUS", IN parameterString);
    }

    sleep(3);
    //check number of ripped files
    tNumberOfMediaObjects CountRippedFiles = 0;
    tTOC HashId = "d0e4b2843d9876c9dbfaf8d3c884aebc";
    ret = LocalSPM::GetCDRipperControl().NumberOfFilesRipped(CountRippedFiles, HashId);
    GMPTEST_EXPECT(MP_NO_ERROR == ret);
    GMPTEST_EXPECT(CountRippedFiles == 8);
}

void RipperControlTest::CreateMusicBoxFileList()
{
    ENTRY_TEST

    tResult res = -1;
    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/var/opt/bosch/dynamic/media/CDRipping/", IN sizeof(path));
    res = MediaPlayerInterface::GetInstance().CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN 1);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 3);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 4);
}

void RipperControlTest::InterruptRippingByEject()
{
    ENTRY
    ETG_TRACE_USR1(("***RipperControlTest::InterruptRipping***"));
    // TOC structure similar to the received from CDDA is framed and passed to CDRipperControl::IsRippingEnabled
    tCDTOCInfo *ptr = new tCDTOCInfo;
    memset(ptr, 0, sizeof(tCDTOCInfo));
    ptr->u8MinTrack = 1;
    ptr->u8MaxTrack = 10;
    strncpy_r(OUT ptr->albumName, IN "test_album", IN sizeof(ptr->albumName));

    ptr->arTrack[0].u32StartZLBA = 0x200;
    strncpy_r(OUT ptr->arTrack[0].performer, IN "test_artist 1", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[0].title, IN "test_title 1", IN sizeof(tMetadata));

    ptr->arTrack[1].u32StartZLBA = 0x52511;
    strncpy_r(OUT ptr->arTrack[1].performer, IN "test_artist 2", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[1].title, IN "test_title 2", IN sizeof(tMetadata));

    ptr->arTrack[2].u32StartZLBA = 0xb002b;
    strncpy_r(OUT ptr->arTrack[2].performer, IN "test_artist 3", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[2].title, IN "test_title 3", IN sizeof(tMetadata));

    ptr->arTrack[3].u32StartZLBA = 0xf3a1f;
    strncpy_r(OUT ptr->arTrack[3].performer, IN "test_artist 4", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[3].title, IN "test_title 4", IN sizeof(tMetadata));

    ptr->arTrack[4].u32StartZLBA = 0x152849;
    strncpy_r(OUT ptr->arTrack[4].performer, IN "test_artist 5", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[4].title, IN "test_title 5", IN sizeof(tMetadata));

    ptr->arTrack[5].u32StartZLBA = 0x1b1149;
    strncpy_r(OUT ptr->arTrack[5].performer, IN "test_artist 6", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[5].title, IN "test_title 6", IN sizeof(tMetadata));

    ptr->arTrack[6].u32StartZLBA = 0x221e2f;
    strncpy_r(OUT ptr->arTrack[6].performer, IN "test_artist 7", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[6].title, IN "test_title 7", IN sizeof(tMetadata));

    ptr->arTrack[7].u32StartZLBA = 0x281310;
    strncpy_r(OUT ptr->arTrack[7].performer, IN "test_artist 8", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[7].title, IN "test_title 8", IN sizeof(tMetadata));

    ptr->arTrack[8].u32StartZLBA = 0x301310;
    strncpy_r(OUT ptr->arTrack[8].performer, IN "test_artist 9", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[8].title, IN "test_title 9", IN sizeof(tMetadata));

    ptr->arTrack[9].u32StartZLBA = 0x321310;
    strncpy_r(OUT ptr->arTrack[9].performer, IN "test_artist 10", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[9].title, IN "test_title 10", IN sizeof(tMetadata));


    tResult ret = MP_NO_ERROR;
    /* Send REMOVE_DEVICE_CONNECTION message to USBControlSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetCDRipperControl().ParameterAUDIO_DISC_DETECTED(OUT parameterString,
            IN size, IN ptr);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ret = LocalSPM::GetCDRipperControl().SendEventByName("AUDIO_DISC_DETECTED", IN parameterString);
    sleep(2);

    tRippedFilePath SourceFilePath;
    strncpy_r(OUT SourceFilePath, IN get_current_dir_name(), IN sizeof(tRippedFilePath));

    //trigger completion event
    ret = LocalSPM::GetCDRipperControl().ParameterRIPPER_STATUS(OUT parameterString,
            IN size, IN 1, IN PE_PBS_PLAYINGSTATE, IN REASON_EMPTY);
    for (int index = 0; index < 5; index++)
    {
        char data[8] = {0};
        snprintf(data, sizeof(data), "%d", index+1);

        tSearchString commandString;
        strncpy_r(commandString, "cp ", sizeof(commandString));
        strncat_r(commandString, SourceFilePath, sizeof(commandString));
        strncat_r(commandString, "/Customer/Simulation/CustomControl/stick_rip/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        strncat_r(commandString, " ", sizeof(commandString));

        strncat_r(commandString, "/var/opt/bosch/dynamic/media/CDRipping/477ddbf91d81d799fde44ba6800038b1/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        ETG_TRACE_USR3(("commandString: %s", commandString));
        system(commandString);

        sleep(2);

        ret = LocalSPM::GetCDRipperControl().SendEventByName("RIPPER_STATUS", IN parameterString);
    }

    ret = LocalSPM::GetCDRipperControl().SendEventByName("STOP_RIPPING", IN NULL);

    // wait for a while
    sleep(2);

    // Create TOC item again as it is deleted after processing.
    tCDTOCInfo *ptr_ = new tCDTOCInfo;
    memset(ptr_, 0, sizeof(tCDTOCInfo));
    ptr_->u8MinTrack = 1;
    ptr_->u8MaxTrack = 10;
    strncpy_r(OUT ptr_->albumName, IN "test_album", IN sizeof(ptr_->albumName));

    ptr_->arTrack[0].u32StartZLBA = 0x200;
    strncpy_r(OUT ptr_->arTrack[0].performer, IN "test_artist 1", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[0].title, IN "test_title 1", IN sizeof(tMetadata));

    ptr_->arTrack[1].u32StartZLBA = 0x52511;
    strncpy_r(OUT ptr_->arTrack[1].performer, IN "test_artist 2", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[1].title, IN "test_title 2", IN sizeof(tMetadata));

    ptr_->arTrack[2].u32StartZLBA = 0xb002b;
    strncpy_r(OUT ptr_->arTrack[2].performer, IN "test_artist 3", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[2].title, IN "test_title 3", IN sizeof(tMetadata));

    ptr_->arTrack[3].u32StartZLBA = 0xf3a1f;
    strncpy_r(OUT ptr_->arTrack[3].performer, IN "test_artist 4", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[3].title, IN "test_title 4", IN sizeof(tMetadata));

    ptr_->arTrack[4].u32StartZLBA = 0x152849;
    strncpy_r(OUT ptr_->arTrack[4].performer, IN "test_artist 5", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[4].title, IN "test_title 5", IN sizeof(tMetadata));

    ptr_->arTrack[5].u32StartZLBA = 0x1b1149;
    strncpy_r(OUT ptr_->arTrack[5].performer, IN "test_artist 6", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[5].title, IN "test_title 6", IN sizeof(tMetadata));

    ptr_->arTrack[6].u32StartZLBA = 0x221e2f;
    strncpy_r(OUT ptr_->arTrack[6].performer, IN "test_artist 7", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[6].title, IN "test_title 7", IN sizeof(tMetadata));

    ptr_->arTrack[7].u32StartZLBA = 0x281310;
    strncpy_r(OUT ptr_->arTrack[7].performer, IN "test_artist 8", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[7].title, IN "test_title 8", IN sizeof(tMetadata));

    ptr_->arTrack[8].u32StartZLBA = 0x301310;
    strncpy_r(OUT ptr_->arTrack[8].performer, IN "test_artist 9", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[8].title, IN "test_title 9", IN sizeof(tMetadata));

    ptr_->arTrack[9].u32StartZLBA = 0x321310;
    strncpy_r(OUT ptr_->arTrack[9].performer, IN "test_artist 10", IN sizeof(tMetadata));
    strncpy_r(OUT ptr_->arTrack[9].title, IN "test_title 10", IN sizeof(tMetadata));

    //send TOC info again
    ret = LocalSPM::GetCDRipperControl().ParameterAUDIO_DISC_DETECTED(OUT parameterString,
            IN size, IN ptr_);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ret = LocalSPM::GetCDRipperControl().SendEventByName("AUDIO_DISC_DETECTED", IN parameterString);

    //trigger completion event
    ret = LocalSPM::GetCDRipperControl().ParameterRIPPER_STATUS(OUT parameterString,
            IN size, IN 1, IN PE_PBS_PLAYINGSTATE, IN REASON_EMPTY);

    for (int index = 5; index < 10; index++)
    {
        char data[8] = {0};
        snprintf(data, sizeof(data), "%d", index+1);

        tSearchString commandString;
        strncpy_r(commandString, "cp ", sizeof(commandString));
        strncat_r(commandString, SourceFilePath, sizeof(commandString));
        strncat_r(commandString, "/Customer/Simulation/CustomControl/stick_rip/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        strncat_r(commandString, " ", sizeof(commandString));

        strncat_r(commandString, "/var/opt/bosch/dynamic/media/CDRipping/477ddbf91d81d799fde44ba6800038b1/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        ETG_TRACE_USR3(("commandString: %s", commandString));
        system(commandString);

        sleep(2);
        ret = LocalSPM::GetCDRipperControl().SendEventByName("RIPPER_STATUS", IN parameterString);
    }

    sleep(2);
    //check number of ripped files
    tNumberOfMediaObjects CountRippedFiles = 0;
    tTOC HashId = "477ddbf91d81d799fde44ba6800038b1";
    ret = LocalSPM::GetCDRipperControl().NumberOfFilesRipped(CountRippedFiles, HashId);
    GMPTEST_EXPECT(MP_NO_ERROR == ret);
    GMPTEST_EXPECT(CountRippedFiles == 10);
}


void RipperControlTest::RestartRippingByUser()
{
    ENTRY
    ETG_TRACE_USR1(("***RipperControlTest::RestartRippingByUser***"));
    // TOC structure similar to the received from CDDA is framed and passed to CDRipperControl::IsRippingEnabled
    tCDTOCInfo *ptr = new tCDTOCInfo;
    memset(ptr, 0, sizeof(tCDTOCInfo));
    ptr->u8MinTrack = 1;
    ptr->u8MaxTrack = 6;
    strncpy_r(OUT ptr->albumName, IN "RestartRipping_album", IN sizeof(ptr->albumName));

    ptr->arTrack[0].u32StartZLBA = 0x200;
    strncpy_r(OUT ptr->arTrack[0].performer, IN "RestartRipping_artist 1", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[0].title, IN "RestartRipping_title 1", IN sizeof(tMetadata));

    ptr->arTrack[1].u32StartZLBA = 0x52511;
    strncpy_r(OUT ptr->arTrack[1].performer, IN "RestartRipping_artist 2", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[1].title, IN "RestartRipping_title 2", IN sizeof(tMetadata));

    ptr->arTrack[2].u32StartZLBA = 0xb002b;
    strncpy_r(OUT ptr->arTrack[2].performer, IN "RestartRipping_artist 3", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[2].title, IN "RestartRipping_title 3", IN sizeof(tMetadata));

    ptr->arTrack[3].u32StartZLBA = 0xf3a1f;
    strncpy_r(OUT ptr->arTrack[3].performer, IN "RestartRipping_artist 4", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[3].title, IN "RestartRipping_title 4", IN sizeof(tMetadata));

    ptr->arTrack[4].u32StartZLBA = 0x152849;
    strncpy_r(OUT ptr->arTrack[4].performer, IN "RestartRipping_artist 5", IN sizeof(tMetadata));
    strncpy_r(OUT ptr->arTrack[4].title, IN "RestartRipping_title 5", IN sizeof(tMetadata));

    tResult ret = MP_NO_ERROR;
    /* Send REMOVE_DEVICE_CONNECTION message to USBControlSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetCDRipperControl().ParameterAUDIO_DISC_DETECTED(OUT parameterString,
            IN size, IN ptr);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ret = LocalSPM::GetCDRipperControl().SendEventByName("AUDIO_DISC_DETECTED", IN parameterString);
    sleep(2);

    tRippedFilePath SourceFilePath;
    strncpy_r(OUT SourceFilePath, IN get_current_dir_name(), IN sizeof(tRippedFilePath));

    //trigger completion event
    ret = LocalSPM::GetCDRipperControl().ParameterRIPPER_STATUS(OUT parameterString,
            IN size, IN 1, IN PE_PBS_PLAYINGSTATE, IN REASON_EMPTY);
    for (int index = 0; index < 3; index++)
    {
        char data[8] = {0};
        snprintf(data, sizeof(data), "%d", index+1);

        tSearchString commandString;
        strncpy_r(commandString, "cp ", sizeof(commandString));
        strncat_r(commandString, SourceFilePath, sizeof(commandString));
        strncat_r(commandString, "/Customer/Simulation/CustomControl/stick_rip/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        strncat_r(commandString, " ", sizeof(commandString));

        strncat_r(commandString, "/var/opt/bosch/dynamic/media/CDRipping/03836be3ab3c0d3e371a361fe2105b57/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        ETG_TRACE_USR3(("commandString: %s", commandString));
        system(commandString);

        sleep(2);

        ret = LocalSPM::GetCDRipperControl().SendEventByName("RIPPER_STATUS", IN parameterString);
    }

    ret = MediaPlayerInterface::GetInstance().StopRipping();

    // wait for a while
    sleep(2);

    //start ripping again
    ret = MediaPlayerInterface::GetInstance().StartRipping();

    for (int index = 3; index < 6; index++)
    {
        char data[8] = {0};
        snprintf(data, sizeof(data), "%d", index+1);

        tSearchString commandString;
        strncpy_r(commandString, "cp ", sizeof(commandString));
        strncat_r(commandString, SourceFilePath, sizeof(commandString));
        strncat_r(commandString, "/Customer/Simulation/CustomControl/stick_rip/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        strncat_r(commandString, " ", sizeof(commandString));

        strncat_r(commandString, "/var/opt/bosch/dynamic/media/CDRipping/03836be3ab3c0d3e371a361fe2105b57/Track_", sizeof(commandString));
        strncat_r(commandString, data, sizeof(commandString));
        strncat_r(commandString, ".mp3", sizeof(commandString));

        ETG_TRACE_USR3(("commandString: %s", commandString));
        system(commandString);

        sleep(2);
        ret = LocalSPM::GetCDRipperControl().SendEventByName("RIPPER_STATUS", IN parameterString);
    }

    sleep(2);
    //check number of ripped files
    tNumberOfMediaObjects CountRippedFiles = 0;
    tTOC HashId = "03836be3ab3c0d3e371a361fe2105b57";
    ret = LocalSPM::GetCDRipperControl().NumberOfFilesRipped(CountRippedFiles, HashId);
    GMPTEST_EXPECT(MP_NO_ERROR == ret);
    GMPTEST_EXPECT(CountRippedFiles == 6);
}

void RipperControlTest::ClearRippedContent()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetCDRipperControl().ClearAllRippedContent();
}

void RipperControlTest::StopRippingEvent()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetCDRipperControl().SendEventByName("STOP_RIPPING", IN NULL);
}


void RipperControlTest::CalculateHashID()
{
    ENTRY
    //LocalSPM::GetCDRipperControl().CalculateCDIDHash();
}

void RipperControlTest::CheckFreeSpace()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    /* Send REMOVE_DEVICE_CONNECTION message to USBControlSM */
    ret = LocalSPM::GetCDRipperControl().SendEventByName("CHECK_SPACE", IN "0");

}

void RipperControlTest::PathToRipFile()
{
    ENTRY
    LocalSPM::GetCDRipperControl().StartRipping();
}

void RipperControlTest::UpdateMetadata()
{
    ENTRY
    LocalSPM::GetCDRipperControl().WriteTagtoFile();
}
void RipperControlTest::CreateMusicBoxRecYearList()
{

    ENTRY_TEST
    tResult res;
    tStreaming streaming = false;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tListID> listIDVector;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    vector<tMediaObject> mediaObjectVectorSongs;
    tDeviceID deviceID = 1;
    tListID listID;


    /* create a album list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_YEAR,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    VARTRACE(listID);
    VARTRACE(listSize);
    CPPUNIT_ASSERT(listSize == 1);
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            IN 0,
            IN listSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    VARTRACE(mediaObjectVector);
    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //for(unsigned int i = 0 ; i < listSize ;i++)
        //{
    tag1.yearID = mediaObjectVector[0].yearID;
    VARTRACE(tag1.yearID);
    // snprintf(tag1,sizeof(tFilterTag1),"2002");

    /* second ask for all albums */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_YEAR_ALBUM,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    VARTRACE(listSize);


    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            listSize);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    VARTRACE(mediaObjectVector);
    res = LocalSPM::GetListControl().ReleaseList(IN listID);

    tag1.yearID = mediaObjectVector[0].yearID;
    tag4.album = mediaObjectVector[0].MetadataTag4;


    /* second ask for all SONGS in the album with a particular year */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_YEAR_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            listSize);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    VARTRACE(mediaObjectVector);
    res = LocalSPM::GetListControl().ReleaseList(IN listID);

}

#define DVD_DEVICE_NODE "/dev/sr0.rip" //dev/sr0 is the device node for DVD drive which is an input to cdparanoia. Ex: /dev/sr0/ , dev/sr1 etc. Need to change this param depend upon the current device mpunt point.

void RipperControlTest::RipAudio()
{
    ENTRY_TEST
#ifdef USE_TESTS_WITH_REAL_DVDDRIVE //can be enabled when testing with real dvd device - see ai_mediaplayer/customer/simulation/test/inc/ConfigTest.h

    tURL URL;
    tResult ret = MP_NO_ERROR;
    strncpy_r(OUT URL, IN DVD_DEVICE_NODE, IN sizeof(URL));
    tPEStateString args;
    tAudioOutputDevice m_AudioOutputDevice;

    int_t tracknumber = 5;
    encfmt_e encodeformat = ME_EF_MP3;
    encqlt_e encodequality = ME_EQ_CD;

    ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineRipperSM::SWITCH_OBSERVER", "USBControlSM", "USBControlSM::METHOD_RETURN");
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
    }

    //strncpy_r(OUT m_AudioOutputDevice, IN "/var/opt/bosch/dynamic/media", IN sizeof(m_AudioOutputDevice));
    strncpy_r(OUT m_AudioOutputDevice, IN "/tmp", IN sizeof(m_AudioOutputDevice)); //output to mp3 file /tmp/Track_02.mp3
    SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltlilll", URL, (int)ME_SPEED_NONE, 0, HANDLE_NONE, m_AudioOutputDevice, samplerate_i_none, 0, tracknumber, encodeformat, encodequality);

    ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineRipperSM::PLAY", args, "USBControlSM::PLAY_ANSWER");

    sleep(10);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
#endif //USE_TESTS_WITH_REAL_DVDDRIVE
}

void RipperControlTest::StopRip()
{
    ENTRY_TEST
#ifdef USE_TESTS_WITH_REAL_DVDDRIVE
    tURL URL;
    tResult ret = MP_NO_ERROR;
    strncpy_r(OUT URL, IN DVD_DEVICE_NODE, IN sizeof(URL));
    tPEStateString args;
    tAudioOutputDevice m_AudioOutputDevice;

    int_t tracknumber = 7;
    encfmt_e encodeformat = ME_EF_MP3;
    encqlt_e encodequality = ME_EQ_FM;

    //strncpy_r(OUT m_AudioOutputDevice, IN "/var/opt/bosch/dynamic/media", IN sizeof(m_AudioOutputDevice));
    strncpy_r(OUT m_AudioOutputDevice, IN "/tmp", IN sizeof(m_AudioOutputDevice));
    SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltlilll", URL, (int)ME_SPEED_NONE, 0, HANDLE_NONE, m_AudioOutputDevice, samplerate_i_none, 0, tracknumber, encodeformat, encodequality);

    ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineRipperSM::PLAY", args, "USBControlSM::PLAY_ANSWER");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    sleep(10);

    ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineRipperSM::STOP", NULL, "USBControlSM::STOP_ANSWER");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
#endif //USE_TESTS_WITH_REAL_DVDDRIVE
}

void RipperControlTest::PlayRipAudio()
{
    ENTRY_TEST
#ifdef USE_TESTS_WITH_REAL_DVDDRIVE
    tURL URL;

    strncpy_r(OUT URL, IN "/tmp/Track_5.mp3", IN sizeof(URL));


    tObjectID objectID = 0;
    tPlaytime position = 0; //1:15min

    Play(IN URL, IN objectID, IN position);
#endif //USE_TESTS_WITH_REAL_DVDDRIVE
}


void RipperControlTest::CheckAutoRippingMode()
{
    tBoolean AutoRippingMode;
    LocalSPM::GetCDRipperControl().GetAutoRippingStatus(AutoRippingMode);
    CPPUNIT_ASSERT(false == AutoRippingMode);

    AutoRippingMode = false;
    LocalSPM::GetCDRipperControl().SetAutoRippingMode(AutoRippingMode);
    LocalSPM::GetCDRipperControl().GetAutoRippingStatus(AutoRippingMode);
    CPPUNIT_ASSERT(false == AutoRippingMode);

    AutoRippingMode = true;
    LocalSPM::GetCDRipperControl().SetAutoRippingMode(AutoRippingMode);
    LocalSPM::GetCDRipperControl().GetAutoRippingStatus(AutoRippingMode);
    CPPUNIT_ASSERT(true == AutoRippingMode);



}
void RipperControlTest::IsRippedTrackExistsInFlash()
{
    tBoolean res = LocalSPM::GetCDRipperControl().IsRippedTrackExistsInFlash(1);
    CPPUNIT_ASSERT(false == res);

}
void RipperControlTest::RestartRipping()
{
    tBoolean AutoRippingMode;
    int cdRippingSupport = LocalSPM::GetDataProvider().CDRippingSupport();
    AutoRippingMode = false;
    LocalSPM::GetCDRipperControl().SetAutoRippingMode(AutoRippingMode);
    LocalSPM::GetDataProvider().CDRippingSupport = 0;
    tBoolean res = LocalSPM::GetCDRipperControl().RestartRipping();
    CPPUNIT_ASSERT(false == res);

    AutoRippingMode = true;
    LocalSPM::GetCDRipperControl().SetAutoRippingMode(AutoRippingMode);
    LocalSPM::GetDataProvider().CDRippingSupport = 1;
    res = LocalSPM::GetCDRipperControl().RestartRipping();
    CPPUNIT_ASSERT(true == res);
    LocalSPM::GetDataProvider().CDRippingSupport = cdRippingSupport;

}

void RipperControlTest::RippingStatus()
{
    tUInt RippingState;
    tUInt TotalTracks;
    tUInt CurrentRippingIndex;
    tUInt Percentage;
    int cdRippingSupport = LocalSPM::GetDataProvider().CDRippingSupport();

    LocalSPM::GetDataProvider().CDRippingSupport = 0;
    LocalSPM::GetCDRipperControl().RippingStatus(RippingState,TotalTracks,CurrentRippingIndex,Percentage);
    CPPUNIT_ASSERT(RIPPING_NOT_SUPPORTED == RippingState);
    LocalSPM::GetDataProvider().CDRippingSupport = 1;
    LocalSPM::GetCDRipperControl().RippingStatus(RippingState,TotalTracks,CurrentRippingIndex,Percentage);
    ETG_TRACE_USR4(("RippingStatus : %d",RippingState));
    CPPUNIT_ASSERT(RIPPING_COMPLETED == RippingState);
    LocalSPM::GetDataProvider().CDRippingSupport = cdRippingSupport;


}
void RipperControlTest::GetUsedMemoryOnFlash()
{
    tMemorySize MemoryOnFlashKB;
    LocalSPM::GetCDRipperControl().GetUsedMemoryOnFlash(MemoryOnFlashKB);
    CPPUNIT_ASSERT(0 == MemoryOnFlashKB);


}

void RipperControlTest::CheckRippingEncodingQuality()
{
    tEncodingQuality rippingEncodingQuality;
    LocalSPM::GetCDRipperControl().GetRippingEncodingQuality(OUT rippingEncodingQuality);
    CPPUNIT_ASSERT(Encoding_Quality_CD == rippingEncodingQuality);
    rippingEncodingQuality = Encoding_Quality_high;
    LocalSPM::GetCDRipperControl().SetRippingEncodingQuality(rippingEncodingQuality);
    CPPUNIT_ASSERT(Encoding_Quality_high == rippingEncodingQuality);
    rippingEncodingQuality = Encoding_Quality_FM;
    LocalSPM::GetCDRipperControl().SetRippingEncodingQuality(rippingEncodingQuality);
    CPPUNIT_ASSERT(Encoding_Quality_FM == rippingEncodingQuality);


}
void RipperControlTest::GetRippedFilePath()
{
    tRippedFilePath RippedFilePathExpected ="/var/opt/bosch/dynamic/media/CDRipping/62e7c8062f89a58194c7098db2fde2d7/Track_3";
    tRippedFilePath RippedFilePath;
    tTOC HashID = "62e7c8062f89a58194c7098db2fde2d7";
    tUInt RippedIndex = 3;
    LocalSPM::GetCDRipperControl().GetRippedFilePath(RippedFilePath,HashID,RippedIndex);

    CPPUNIT_ASSERT_MESSAGE( RippedFilePath,0 == strcmp(RippedFilePath,RippedFilePathExpected));


}
void RipperControlTest::CheckMusicBoxFileAvailability()
{
    tBoolean res = LocalSPM::GetCDRipperControl().CheckMusicBoxFileAvailability((char*)"invalidpath");
    CPPUNIT_ASSERT(false == res);

}


