/*
 * MTPLibWrapperTest.h
 *
 *  Created on: May 17, 2013
 *      Author: tritonsu
 */

#ifndef MTPLIBWRAPPERTEST_H_
#define MTPLIBWRAPPERTEST_H_

#include "MTPLibWrapper.h"
#include <vector>

#define  MAXMTPTESTDEVICES         10
#define  MAXMTPTESTSONGS          100
#define  LENOFSTRING               80
#define  LENOFDIRECTORY          1024
#define  INVALID_INDEX             -1






class MTPLibWrapperTest:public MTPLibWrapper
{
public:
    MTPLibWrapperTest();
    ~MTPLibWrapperTest();

    tResult AddTestDevice(char *pDevDirectory /*contains songs of faked device*/);

   virtual void  wLIBMTP_INIT();
   virtual void  wLIBMTP_SetDebug(int level);
   virtual void  wLIBMTP_destroy_file_t(LIBMTP_file_t *file);
   virtual char* wLIBMTP_Get_Modelname(IN LIBMTP_mtpdevice_t *pDevice);
   virtual char* wLIBMTP_Get_Friendlyname(IN LIBMTP_mtpdevice_t *pDevice);
   virtual char* wLIBMTP_Get_Serialnumber(IN LIBMTP_mtpdevice_t *pDevice);
   virtual char* wLIBMTP_Get_Deviceversion(IN LIBMTP_mtpdevice_t *pDevice);
   virtual char* wLIBMTP_Get_Manufacturername(IN LIBMTP_mtpdevice_t *pDevice);
   virtual const char*  wLIBMTP_Get_Filetype_Description  ( LIBMTP_filetype_t  intype );

   virtual int   wLIBMTP_Get_Track_To_File (LIBMTP_mtpdevice_t *pDevice, uint32_t const id, char const *const path, LIBMTP_progressfunc_t const callback, void const *const  data);

   virtual LIBMTP_track_t       *wLIBMTP_Get_Trackmetadata(IN LIBMTP_mtpdevice_t *device, IN uint32_t const trackid);
   virtual LIBMTP_track_t       *wLIBMTP_Get_Tracklisting_Track_With_Callback(IN LIBMTP_mtpdevice_t *pDevice,IN LIBMTP_progressfunc_t const callback, IN void const *const data ,OUT uint32_t *pCurTrackIndex);
   virtual LIBMTP_error_number_t wLIBMTP_Get_Connected_Devices(INOUT LIBMTP_mtpdevice_t **  device_list);
   virtual LIBMTP_file_t        *wLIBMTP_Get_Filelisting_With_Callback(LIBMTP_mtpdevice_t* device, LIBMTP_progressfunc_t const callback, void const *const data);

   virtual LIBMTP_mtpdevice_t *matchDevice2MountPoint(IN char* serialNumber,IN char* deviceVersion, IN char* deviceName);


public: //@todo check if protected would be possible

   typedef struct{
	   LIBMTP_track_t trackInfo;
	   char           cArtist[LENOFSTRING];
	   char           cAlbum[LENOFSTRING];
	   char           cComposer[LENOFSTRING];
	   char           cDate[LENOFSTRING];
	   char           cFilename[LENOFSTRING]; //trackinfo has char pointers this gives memory to fill it to prevent malloc in test
	   char           cGenre[LENOFSTRING];
	   char           cTitle[LENOFSTRING];

   }tTestTrack;

    /*-->use for test only*/
    typedef struct {
        bool bValid;

        //device info
      	LIBMTP_mtpdevice_t device;
      	char cMountPoint[LENOFSTRING*3+3];
        char cModelname[LENOFSTRING];      //device holds char pointers this is the memory to hold it to prevent malloc in test
        char cFriendlyname[LENOFSTRING];
        char cSerialnumber[LENOFSTRING];
        char cDeviceversion[LENOFSTRING];
        char cManufacturername[LENOFSTRING];

        char cDirectoryTest[LENOFDIRECTORY]; //holds directory with test files

        //metatdata info
      	tUInt              numOfSongs;
      	tTestTrack         songList[MAXMTPTESTSONGS];


      }tTestdevs;

      bool      m_bUseLibMTP;
      int       m_deviceIndex;
      tTestdevs m_deviceList[MAXMTPTESTDEVICES];

      int       m_currentTrackIndex;
      /*<--*/

      void    showDevices();
      void    clearDevices();
      tResult clearLastDevice(tUInt i);

      void    fillTestSong(INOUT char *pOutText, IN const char *pAddText, IN tUInt iDeviceIndex, IN tUInt iNumOfSongs);
      void    fillTestDeviceEntry(INOUT char *pOutText,IN const char *pAddText, IN tUInt iDeviceIndex);

      void    getDevice(OUT LIBMTP_mtpdevice_t     *pDevice, IN int index);  //@todo eventually use tResult instead of void
      int     getDeviceIndex(IN LIBMTP_mtpdevice_t *device);
      int     getDeviceIndex();


      tResult addSong(char *pDirPath, char* pFileName, tUInt deviceIndex);

      LIBMTP_error_number_t bCopyFile(char *pSource, char *pDestination, LIBMTP_progressfunc_t const callback);


private:
      std::vector<std::string> vectorFileTypes;
      bool hasSuffix(char *cName);

};
#endif /* MTPLIBWRAPPERTEST_H_ */
