#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_MTP_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPLibWrapperTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_MTP_CONTROL
#endif
#endif


#include "LocalSPM.h"
#include "Dispatcher.h"
#include "FunctionTracer.h"
#include "VarTrace.h"
#include "MediaPlayer_ErrorCodes.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fstream>

#include "MTPLibWrapperTest.h"


const string arr[] = {
      "LIBMTP_FILETYPE_FOLDER",                                /*1*/
      "LIBMTP_FILETYPE_WAV",
      "LIBMTP_FILETYPE_MP3",
      "LIBMTP_FILETYPE_WMA",
      "LIBMTP_FILETYPE_OGG",
      "LIBMTP_FILETYPE_AUDIBLE",
      "LIBMTP_FILETYPE_MP4",
      "LIBMTP_FILETYPE_UNDEF_AUDIO",
      "LIBMTP_FILETYPE_WMV",
      "LIBMTP_FILETYPE_AVI",                                 /*10*/
      "LIBMTP_FILETYPE_MPEG",
      "LIBMTP_FILETYPE_ASF",
      "LIBMTP_FILETYPE_QT",
      "LIBMTP_FILETYPE_UNDEF_VIDEO",
      "LIBMTP_FILETYPE_JPEG",
      "LIBMTP_FILETYPE_JFIF",
      "LIBMTP_FILETYPE_TIFF",
      "LIBMTP_FILETYPE_BMP",
      "LIBMTP_FILETYPE_GIF",
      "LIBMTP_FILETYPE_PICT",                               /*20*/
      "LIBMTP_FILETYPE_PNG",
      "LIBMTP_FILETYPE_VCALENDAR1",
      "LIBMTP_FILETYPE_VCALENDAR2",
      "LIBMTP_FILETYPE_VCARD2",
      "LIBMTP_FILETYPE_VCARD3",
      "LIBMTP_FILETYPE_WINDOWSIMAGEFORMAT",
      "LIBMTP_FILETYPE_WINEXEC",
      "LIBMTP_FILETYPE_TEXT",
      "LIBMTP_FILETYPE_HTML",
      "LIBMTP_FILETYPE_FIRMWARE",                          /*30*/
      "LIBMTP_FILETYPE_AAC",
      "LIBMTP_FILETYPE_MEDIACARD",
      "LIBMTP_FILETYPE_FLAC",
      "LIBMTP_FILETYPE_MP2",
      "LIBMTP_FILETYPE_M4A",
      "LIBMTP_FILETYPE_DOC",
      "LIBMTP_FILETYPE_XML",
      "LIBMTP_FILETYPE_XLS",
      "LIBMTP_FILETYPE_PPT",
      "LIBMTP_FILETYPE_MHT",                              /*40*/
      "LIBMTP_FILETYPE_JP2",
      "LIBMTP_FILETYPE_JPX",
      "LIBMTP_FILETYPE_ALBUM",
      "LIBMTP_FILETYPE_PLAYLIST",
      "LIBMTP_FILETYPE_UNKNOWN"};                        /*45*/

#define NUMOFELEMS 45
#define READLEN (8192*2)   /*byte*/  ///@todo this will be changed if we go for streaming


int MTPLibWrapperTest::getDeviceIndex(IN LIBMTP_mtpdevice_t *pDevice)
{
    int ret = INVALID_INDEX;

    ETG_TRACE_USR4(("MTPLibWrapperTest::getDeviceIndex():%p",pDevice));
    if(NULL != pDevice)
    {
        for(tUInt i=0;i<MAXMTPTESTDEVICES; i++)
        {
            //ETG_TRACE_FATAL(("getDeviceIndex: m_deviceList[%d].bValid = %d",i,m_deviceList[i].bValid))
            if(m_deviceList[i].bValid)
            {
                ETG_TRACE_USR4(("getDeviceIndex:m_deviceList[i].device  : %p",&(m_deviceList[i].device)));
                ETG_TRACE_USR4(("getDeviceIndex:pDevice                 : %p",  pDevice));
                if(pDevice == &(m_deviceList[i].device))
                {
                    ret = i;
                    //ETG_TRACE_FATAL(("getDeviceIndex:found! i=%d",i))
                    break;
                }
            }
        }
    }
    //ETG_TRACE_FATAL(("getDeviceIndex:End"));
    return ret;
}


void MTPLibWrapperTest::clearDevices()
{
    /*init test devices*/
    for(tUInt i=1; i<=MAXMTPTESTDEVICES; i++)
    {
        m_deviceIndex = MAXMTPTESTDEVICES-i; //force to clear each
        this->clearLastDevice(MAXMTPTESTDEVICES-i /*=index*/);
    }
    m_deviceIndex       = -1;
    m_currentTrackIndex = -1;
}


tResult MTPLibWrapperTest::clearLastDevice(tUInt i)
{
     tResult ret = MP_NO_ERROR;

     if(m_deviceIndex == (int)i)
     {
         //device info
         m_deviceList[i].device.cd                       = NULL;
         m_deviceList[i].device.errorstack               = NULL;
         //m_deviceList[i].device.extensions               = NULL;   //@todo check for dependency of correct mtplib works on PC but not on target - why
         m_deviceList[i].device.next                     = NULL;
         m_deviceList[i].device.params                   = NULL;
         m_deviceList[i].device.storage                  = NULL;
         m_deviceList[i].device.usbinfo                  = NULL;

         //m_deviceList[i].device.cached                   = 0;  //@todo check for dependency of correct mtplib works on PC but not on target - why
         m_deviceList[i].device.default_album_folder     = 0;
         m_deviceList[i].device.default_music_folder     = 0;
         m_deviceList[i].device.default_organizer_folder = 0;
         m_deviceList[i].device.default_picture_folder   = 0;
         m_deviceList[i].device.default_playlist_folder  = 0;
         m_deviceList[i].device.default_text_folder      = 0;
         m_deviceList[i].device.default_video_folder     = 0;
         m_deviceList[i].device.default_zencast_folder   = 0;
         m_deviceList[i].device.maximum_battery_level    = 0;
         m_deviceList[i].device.object_bitsize           = 0;

         m_deviceList[i].cModelname[0]                   = '\0';
         m_deviceList[i].cFriendlyname[0]                = '\0';
         m_deviceList[i].cSerialnumber[0]                = '\0';
         m_deviceList[i].cDeviceversion[0]               = '\0';
         m_deviceList[i].cManufacturername[0]            = '\0';

         //track/song info
         for(tUInt k=0; k<MAXMTPTESTSONGS;k++)
         {
             m_deviceList[i].songList[k].cArtist[0]                 = '\0';
             m_deviceList[i].songList[k].cAlbum[0]                  = '\0';
             m_deviceList[i].songList[k].cComposer[0]               = '\0';
             m_deviceList[i].songList[k].cDate[0]                   = '\0';
             m_deviceList[i].songList[k].cFilename[0]               = '\0';
             m_deviceList[i].songList[k].cGenre[0]                  = '\0';
             m_deviceList[i].songList[k].cTitle[0]                  = '\0';

             m_deviceList[i].songList[k].trackInfo.album            = NULL;
             m_deviceList[i].songList[k].trackInfo.artist           = NULL;
             m_deviceList[i].songList[k].trackInfo.composer         = NULL;
             m_deviceList[i].songList[k].trackInfo.date             = NULL;
             m_deviceList[i].songList[k].trackInfo.filename         = NULL;
             m_deviceList[i].songList[k].trackInfo.genre            = NULL;
             m_deviceList[i].songList[k].trackInfo.title            = NULL;
             m_deviceList[i].songList[k].trackInfo.next             = NULL;

             m_deviceList[i].songList[k].trackInfo.bitrate          = 0;
             m_deviceList[i].songList[k].trackInfo.bitrate          = 0;
             m_deviceList[i].songList[k].trackInfo.bitratetype      = 0;
             m_deviceList[i].songList[k].trackInfo.duration         = 0;
             m_deviceList[i].songList[k].trackInfo.filesize         = 0;
             m_deviceList[i].songList[k].trackInfo.filetype         = LIBMTP_FILETYPE_UNKNOWN;
             m_deviceList[i].songList[k].trackInfo.item_id          = 0;
             m_deviceList[i].songList[k].trackInfo.modificationdate = 0;
             m_deviceList[i].songList[k].trackInfo.nochannels       = 0;
             m_deviceList[i].songList[k].trackInfo.parent_id        = 0;
             m_deviceList[i].songList[k].trackInfo.rating           = 0;
             m_deviceList[i].songList[k].trackInfo.samplerate       = 0;
             m_deviceList[i].songList[k].trackInfo.storage_id       = 0;
             m_deviceList[i].songList[k].trackInfo.tracknumber      = 0;
             m_deviceList[i].songList[k].trackInfo.usecount         = 0;
             m_deviceList[i].songList[k].trackInfo.wavecodec        = 0;
         }

         //mark device with content: invalid and not existent
         m_deviceList[i].numOfSongs           = 0;
         m_deviceList[i].bValid               = false;
         m_deviceIndex--;
     }
     else
     {
          ETG_TRACE_FATAL(("clearLastDevices index=%d",i));
          ret = MP_ERR_MTP_NODEVMATCH;
     }

     return ret;
}



//-------------------------------------------------------------------------------------------------------------------------
// specific functions of MTP
//-------------------------------------------------------------------------------------------------------------------------

/*
 * use this in your test case
#ifndef TARGET_BUILD
char *pwd = get_current_dir_name();
strncpy_r(URL, pwd, sizeof(URL));

strncat_r(URL, "/Customer/Simulation/CustomControl/stick_3", sizeof(URL));

strncat_r(URL, "/Customer/Simulation/CustomControl/stick_2/Supertramp/Breakfast_In_America", sizeof(URL));

strncat_r(URL, "/Customer/Simulation/CustomControl/stick_2/Unheilig/Grosse_Freiheit", sizeof(URL));
#else
strncpy_r(URL, "/opt/bosch/test/data/GMP/stick_3", sizeof(URL));

strncpy_r(URL, "/opt/bosch/test/data/GMP/stick_2/Supertramp/Breakfast_In_America", sizeof(URL));

strncpy_r(URL, "/opt/bosch/test/data/GMP/stick_2/Unheilig/Grosse_Freiheit", sizeof(URL));
#endif

*/


tResult MTPLibWrapperTest::AddTestDevice(char *pDevDirectory /*contains songs of faked device*/)
{
    ENTRY_INTERNAL;
    tResult ret = MP_NO_ERROR;
    DIR *pDir = NULL;
    struct dirent *pDirentry;

    m_deviceIndex++;
    m_deviceList[m_deviceIndex].bValid = true;

    ETG_TRACE_USR4(("MTPLibWrapperTest::AddTestDevice(): &(m_deviceList[m_deviceIndex].device %p", &(m_deviceList[m_deviceIndex].device)));

    snprintf(m_deviceList[m_deviceIndex].cDirectoryTest,LENOFDIRECTORY,"%s",pDevDirectory);

    fillTestDeviceEntry(m_deviceList[m_deviceIndex].cModelname,       "devicename",    m_deviceIndex); //model used as devicename
    fillTestDeviceEntry(m_deviceList[m_deviceIndex].cFriendlyname,    "devicename",    m_deviceIndex); //alternatively friendlyname an be used as devicename
    fillTestDeviceEntry(m_deviceList[m_deviceIndex].cSerialnumber,    "serialnumber",  m_deviceIndex);
    fillTestDeviceEntry(m_deviceList[m_deviceIndex].cDeviceversion,   "deviceversion", m_deviceIndex);
    fillTestDeviceEntry(m_deviceList[m_deviceIndex].cManufacturername, "manufacturer",  m_deviceIndex);
    fillTestDeviceEntry(m_deviceList[m_deviceIndex].cMountPoint,      "/deviceversion/serialnumber/",  m_deviceIndex);


    m_deviceList[m_deviceIndex].device.next = NULL;

    if(m_deviceIndex > 0)
    {
        if(true == m_deviceList[m_deviceIndex-1].bValid)
        {
            m_deviceList[m_deviceIndex-1].device.next = &m_deviceList[m_deviceIndex].device;
        }
        else
        {
            ETG_TRACE_FATAL(("AddTestDevice: previous device not valid"));
            ret = MP_ERR_MTP_GENERAL_ERROR;
        }
    }

    /*openDirecory and check for files*/
    if((MP_NO_ERROR == ret) && (NULL != pDevDirectory))
    {
        pDir = opendir(pDevDirectory);
        if(!pDir)
        {
            ETG_TRACE_FATAL(("[ERROR]: LIBMTP_InitTestDevice: could not open pDevDirectory:%s",pDevDirectory));
            ret = MP_ERR_MTP_DIRNOTEXIST;
        }
    }

    if(MP_NO_ERROR == ret)
    {
        int songsfound = 0;
        do
        {
            pDirentry = readdir(pDir);

            if(NULL != pDirentry)
            {
                if(pDirentry->d_type&DT_DIR)  //feature not supported by all filesystems hence I can not use it
                {
                    ETG_TRACE_USR4(("is directory"));
                }
                /*check for ../ and ./ */

                if(   (0    != strcmp(pDirentry->d_name, ".")  )
                   && (0    != strcmp(pDirentry->d_name, "..") )
                   && (true == hasSuffix(pDirentry->d_name) )    ///@todo add 'is file' check
                  )
                {
                    songsfound++;
                    /*assume all entries are valid testfiles i.e. no further error checks done here*/
                    if(songsfound < MAXMTPTESTSONGS)
                    {
                        ret = addSong(pDevDirectory, pDirentry->d_name,m_deviceIndex); /*@todo eventually rename to track instead of song*/
                        if(MP_NO_ERROR == ret)
                        {
                           ETG_TRACE_USR4(("addSong:m_deviceIndex=%d %s",m_deviceIndex,pDirentry->d_name));
                        }
                        else
                        {
                             break;
                        }
                    }
                    else
                    {
                        ETG_TRACE_FATAL(("LIBMTP_InitTestDevice: num of test songs more than MAXMTPTESTSONGS = %d",MAXMTPTESTSONGS));
                        break;
                    }
                }
            }
        } while(pDirentry != NULL);
        closedir(pDir);
    }

    if(MP_NO_ERROR != ret)
    {
        /*roll back*/
        clearLastDevice(m_deviceIndex);
    }
    return ret;
}

void MTPLibWrapperTest::fillTestSong(INOUT char *pOutText, IN const char *pAddText, IN tUInt iDeviceIndex, IN tUInt iNumOfSongs)
{
     if(pOutText)
     {
          snprintf(pOutText,LENOFSTRING, "dev%d_num%d_%s",iDeviceIndex,iNumOfSongs,pAddText);
     }
}

void MTPLibWrapperTest::fillTestDeviceEntry(INOUT char *pOutText,IN const char *pAddText, IN tUInt iDeviceIndex)
{
     if(pOutText)
     {
          snprintf(pOutText,LENOFSTRING,"%d_%s",iDeviceIndex,pAddText);
     }
}

tResult MTPLibWrapperTest::addSong(char *pDirPath, char* pFileName, tUInt deviceIndex)
{
    tResult ret = MP_NO_ERROR;
    int i = deviceIndex;
    int k;

    if(    (NULL  != pDirPath)
        && (NULL  != pFileName)
        && ((int)deviceIndex <= m_deviceIndex)
        && (true  == m_deviceList[deviceIndex].bValid)
      )
    {
         m_deviceList[i].numOfSongs++;
         k = m_deviceList[i].numOfSongs-1;
         m_deviceList[i].songList[k].trackInfo.tracknumber      = k;
         m_deviceList[i].songList[k].trackInfo.item_id          = k;

         m_deviceList[i].songList[k].trackInfo.filename =  m_deviceList[i].songList[k].cFilename;
         if(m_deviceList[i].songList[k].trackInfo.filename)
         {
             strncpy(m_deviceList[i].songList[k].trackInfo.filename, pFileName,LENOFSTRING-1); ///@todo think carefully about -1
         }

         ///@todo think about using taglib to fill valuable data
         m_deviceList[i].songList[k].trackInfo.album    = m_deviceList[i].songList[k].cAlbum;
         m_deviceList[i].songList[k].trackInfo.artist   = m_deviceList[i].songList[k].cArtist;
         m_deviceList[i].songList[k].trackInfo.composer = m_deviceList[i].songList[k].cComposer;
         m_deviceList[i].songList[k].trackInfo.date     = m_deviceList[i].songList[k].cDate;
         m_deviceList[i].songList[k].trackInfo.genre    = m_deviceList[i].songList[k].cGenre;
         m_deviceList[i].songList[k].trackInfo.title    = m_deviceList[i].songList[k].cTitle;


         fillTestSong(INOUT m_deviceList[i].songList[k].trackInfo.album ,  IN "album"    ,IN deviceIndex, IN m_deviceList[i].numOfSongs);
         fillTestSong(INOUT m_deviceList[i].songList[k].trackInfo.artist,  IN "artist"  , IN deviceIndex, IN m_deviceList[i].numOfSongs);
         fillTestSong(INOUT m_deviceList[i].songList[k].trackInfo.composer,IN "composer", IN deviceIndex, IN m_deviceList[i].numOfSongs);
         fillTestSong(INOUT m_deviceList[i].songList[k].trackInfo.date,    IN "date"    , IN deviceIndex, IN m_deviceList[i].numOfSongs);
         fillTestSong(INOUT m_deviceList[i].songList[k].trackInfo.genre,   IN "genre"   , IN deviceIndex, IN m_deviceList[i].numOfSongs);
         fillTestSong(INOUT m_deviceList[i].songList[k].trackInfo.title,   IN "title"   , IN deviceIndex, IN m_deviceList[i].numOfSongs);

         m_deviceList[i].songList[k].trackInfo.next = NULL;
         if(k>0)
         {
             m_deviceList[i].songList[k-1].trackInfo.next = &(m_deviceList[k].songList[k].trackInfo);
         }

         m_deviceList[i].songList[k].trackInfo.bitrate          = 1;
         m_deviceList[i].songList[k].trackInfo.bitrate          = 1;
         m_deviceList[i].songList[k].trackInfo.bitratetype      = 1;
         m_deviceList[i].songList[k].trackInfo.duration         = 1;
         m_deviceList[i].songList[k].trackInfo.filesize         = 1;
         m_deviceList[i].songList[k].trackInfo.filetype         = LIBMTP_FILETYPE_MP3;
         m_deviceList[i].songList[k].trackInfo.modificationdate = 1;
         m_deviceList[i].songList[k].trackInfo.nochannels       = 1;
         m_deviceList[i].songList[k].trackInfo.parent_id        = 1;
         m_deviceList[i].songList[k].trackInfo.rating           = 1;
         m_deviceList[i].songList[k].trackInfo.samplerate       = 1;
         m_deviceList[i].songList[k].trackInfo.storage_id       = 1;
         m_deviceList[i].songList[k].trackInfo.usecount         = 1;
         m_deviceList[i].songList[k].trackInfo.wavecodec        = 1;


    }
    else
    {
        ETG_TRACE_FATAL(("addSong: path or file are NULL"));
    }

    return ret;
}

//-------------------------------------------------------------------------------------------------------------------------
// overwrites functions of MTP
//-------------------------------------------------------------------------------------------------------------------------

MTPLibWrapperTest::MTPLibWrapperTest()
{
    clearDevices();
    vectorFileTypes.assign(arr,arr+NUMOFELEMS);
}

MTPLibWrapperTest::~MTPLibWrapperTest()
{
    clearDevices();
}


void MTPLibWrapperTest::wLIBMTP_INIT(void)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR4(("MTPLibWrapper::wLIBMTP_INIT: stubbed mtplib initialised"));
}

void MTPLibWrapperTest::wLIBMTP_SetDebug(IN int level)
{
    (void)level;
    ENTRY_INTERNAL
}
LIBMTP_track_t* MTPLibWrapperTest::wLIBMTP_Get_Trackmetadata(IN LIBMTP_mtpdevice_t *device, IN uint32_t const trackid)
{
    ENTRY_INTERNAL

    LIBMTP_track_t *pTrack=NULL;

    //match device
    int i = getDeviceIndex(device);

    ETG_TRACE_USR4(("LIBMTP_Get_Trackmetadata: i=%d ",i));
    if(INVALID_INDEX != i)
    {
        ETG_TRACE_USR4(("trackid:%d,m_deviceList[i].numOfSongs:%d",trackid,m_deviceList[i].numOfSongs));
        if(trackid < m_deviceList[i].numOfSongs)
        {
            pTrack = &(m_deviceList[i].songList[trackid].trackInfo);
            ETG_TRACE_USR4(("LIBMTP_Get_Trackmetadata pTrack ok: cFilename:%s",pTrack->filename));
        }
        else
        {
            ETG_TRACE_FATAL(("[ERROR] :LIBMTP_Get_Trackmetadata - invalid trackID"));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR] :LIBMTP_Get_Trackmetadata - invalid index"));
    }

    return pTrack;
}
LIBMTP_error_number_t MTPLibWrapperTest::wLIBMTP_Get_Connected_Devices(INOUT LIBMTP_mtpdevice_t **device_list)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start %s **********", __PRETTY_FUNCTION__));

    LIBMTP_mtpdevice_t *pDevice;
    *device_list = &(m_deviceList[0].device); ///@todo test with several devices
    pDevice = &(m_deviceList[0].device);
    ETG_TRACE_USR4(("MTPLibWrapperTest::LIBMTP_Get_Connected_Devices(): pDevice        :%p", pDevice));
    ETG_TRACE_USR4(("MTPLibWrapperTest::LIBMTP_Get_Connected_Devices(): pDevice->next  :%p", pDevice->next));

    return LIBMTP_ERROR_NONE;
}

LIBMTP_track_t *MTPLibWrapperTest::wLIBMTP_Get_Tracklisting_Track_With_Callback(LIBMTP_mtpdevice_t* pDevice,
                                                                               LIBMTP_progressfunc_t const callback,
                                                                               void const * const data ,
                                                                               uint32_t *pCurTrackIndex)
{
    ///@todo care for error value
    ENTRY_INTERNAL
    (void)callback;
    (void)data;
    LIBMTP_track_t *pTrack = NULL;

    if(pCurTrackIndex)
    {
        *pCurTrackIndex = ++m_currentTrackIndex; //note: is initialised -1
        pTrack = wLIBMTP_Get_Trackmetadata(IN pDevice, IN m_currentTrackIndex);
        if(NULL == pTrack)
        {
            //reset to 0
            m_currentTrackIndex = 0;
        }
    }

    ///@todo simulation here

    return pTrack;
}

char* MTPLibWrapperTest::wLIBMTP_Get_Modelname(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL

    int i;
    char* pName = NULL;

    ETG_TRACE_USR4(("MTPLibWrapperTest::LIBMTP_Get_Modelname: pDevice=%p",pDevice));
    i = getDeviceIndex(pDevice);
    if(i != INVALID_INDEX)
    {
        pName = m_deviceList[i].cModelname;
        ETG_TRACE_USR4(("MTPLibWrapperTest::LIBMTP_Get_Modelname: %s",pName));
    }
    else
    {
         ETG_TRACE_USR3(("ERROR INVALID_INDEX: %s", __PRETTY_FUNCTION__));
    }

    return pName;
}

char* MTPLibWrapperTest::wLIBMTP_Get_Friendlyname(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL

    int i;
    char* pName = NULL;

    i = getDeviceIndex(pDevice);
    if(i != INVALID_INDEX)
    {
        pName = m_deviceList[i].cFriendlyname;
        ETG_TRACE_USR4(("MTPLibWrapperTest::LIBMTP_Get_Friendlyname: %s",pName));
    }
    else
    {
         ETG_TRACE_USR3(("ERROR INVALID_INDEX: %s", __PRETTY_FUNCTION__));
    }

    return pName;
}


char* MTPLibWrapperTest::wLIBMTP_Get_Serialnumber(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL

    char* pName = NULL;

    int i = getDeviceIndex(pDevice);
    if(-1 != i)
    {
        pName = m_deviceList[i].cSerialnumber;
        ETG_TRACE_USR4(("MTPLibWrapperTest::LIBMTP_Get_Serialnumber: %s",pName));
    }
    else
    {
         ETG_TRACE_USR3(("ERROR INVALID_INDEX: %s", __PRETTY_FUNCTION__));
    }


    return pName;
}

char* MTPLibWrapperTest::wLIBMTP_Get_Deviceversion(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL

    char* pName = NULL;

    int i = getDeviceIndex(pDevice);
    if(i != INVALID_INDEX)
    {
        pName = m_deviceList[i].cDeviceversion;
        ETG_TRACE_USR4(("MTPLibWrapperTest::LIBMTP_Get_Deviceversion: %s",pName));
    }
    else
    {
         ETG_TRACE_USR3(("ERROR INVALID_INDEX: %s", __PRETTY_FUNCTION__));
    }

    return pName;
}

char* MTPLibWrapperTest::wLIBMTP_Get_Manufacturername(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL

    char* pName = NULL;

    int i = getDeviceIndex(pDevice);
    if(i != INVALID_INDEX)
    {
        pName = m_deviceList[i].cManufacturername;
        ETG_TRACE_USR4(("MTPLibWrapperTest::LIBMTP_Get_Manufacturername: %s",pName));
    }
    else
    {
         ETG_TRACE_USR3(("ERROR INVALID_INDEX: %s", __PRETTY_FUNCTION__));
    }

    return pName;
}

LIBMTP_error_number_t MTPLibWrapperTest::bCopyFile(char *pSource, char *pDestination, LIBMTP_progressfunc_t const callback)
{
    LIBMTP_error_number_t ret = LIBMTP_ERROR_NONE;

    ETG_TRACE_USR4(("MTPLibWrapperTest::bCopyFile: SOURCE     : %s",pSource));
    ETG_TRACE_USR4(("MTPLibWrapperTest::bCopyFile: DESTINATION: %s",pDestination));
    (void)callback;

    int  len, lenleft,len2Read;
    char byte[READLEN];

    std::ifstream ifs_source (pSource,      std::ifstream::binary);
    std::ofstream ifs_dest   (pDestination, std::ifstream::binary);

    //create directory if not existent
    DIR *pDir = opendir(LOCAL_MTPFILE_PATH_TARGET);
    if(!pDir)
    {
        ETG_TRACE_USR1(("[WARNING]: LIBMTP_InitTestDevice: could not open pDevDirectory:%s create it",LOCAL_MTPFILE_PATH_TARGET));
        int status = mkdir(LOCAL_MTPFILE_PATH_TARGET, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
        ETG_TRACE_USR1(("LIBMTP_InitTestDevice: create it: status=0x%x",status))
    }
    else
    {
        closedir(pDir);
    }

    ifs_source.seekg ((long long int)0, ifs_source.end); //lint
    len = ifs_source.tellg();
    ifs_source.seekg ((long long int)0, ifs_source.beg); //lint

    ///@todo error cases not implemented

    /*
    char data[READLEN+1];
    data[READLEN] = '\0';
    */

    lenleft = len;
    len2Read = 0;

    while(lenleft>0)
    {
        if(lenleft >=READLEN)
        {
            len2Read = READLEN;
        }
        else
        {
            len2Read = lenleft;
        }
        ifs_source.read(byte,len2Read);   //f/for test it's ok to do less error checks here

        ETG_TRACE_USR4(("MTPLibWrapperTest::bCopyFile: len:%d len2Read: %d lenleft:%d",len, len2Read, lenleft));
        /*
        data[0] = byte[0];
        ETG_TRACE_USR4(("byte: %s",data));
        ETG_TRACE_USR4(("byte: 0x%x",data[0]));
        */

        ifs_dest.write(byte,len2Read);

        lenleft = lenleft - len2Read;

        ///@todo callback could be called here
    }

    ifs_source.close();
    ifs_dest.close();


    return ret;
}


int  MTPLibWrapperTest::wLIBMTP_Get_Track_To_File (LIBMTP_mtpdevice_t *pDevice, uint32_t const id, char const *const path, LIBMTP_progressfunc_t const callback, void const *const  data)
{
     ENTRY_INTERNAL

     LIBMTP_error_number_t ret = LIBMTP_ERROR_NONE;
     uint32_t trackID = id;
     char* pFileName = NULL;
     (void)path;
     (void)data;

     char cSource[1024];        ///@todo replace 1024 with define
     char cDestination[1024];
;

     int i = getDeviceIndex(pDevice);

     if(i != INVALID_INDEX)
     {
         if(trackID< m_deviceList[i].numOfSongs)
         {
             pFileName = m_deviceList[i].songList[trackID].cFilename;
             ETG_TRACE_USR4(("MTPLibWrapperTest::LIBMTP_Get_Track_To_File:m_deviceList[%d].songList[%d].cFilename: %s",i,trackID,pFileName));

             snprintf(cSource,sizeof(cSource),"%s/%s",m_deviceList[i].cDirectoryTest,pFileName);
             snprintf(cDestination,sizeof(cDestination),"%s/%s",LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_BIN);

             bCopyFile(cSource, cDestination, callback);
         }
         else
         {
             ETG_TRACE_FATAL(("[ERROR] MTPLibWrapperTest::LIBMTP_Get_Track_To_File: trackID (%d) >= numOfSongs (%d)",trackID,m_deviceList[i].numOfSongs));
             ret = LIBMTP_ERROR_GENERAL;
         }
     }
     else
     {
         ETG_TRACE_FATAL(("MTPLibWrapperTest::LIBMTP_Get_Track_To_File: INVALID_INDEX"));
         ret = LIBMTP_ERROR_GENERAL;
     }


     return ret;
}

int MTPLibWrapperTest::getDeviceIndex()
{
    ETG_TRACE_USR4(("MTPLibWrapperTest::getDeviceIndex(): m_deviceIndex: %d",m_deviceIndex));
    return m_deviceIndex;
}

const char* MTPLibWrapperTest::wLIBMTP_Get_Filetype_Description  (IN LIBMTP_filetype_t  intype )
{
     ENTRY_INTERNAL
    //@todo do some error check
    int i = (int)intype /*(int)LIBMTP_FILETYPE_FOLDER*/; ///@todo this needs to be checked!

    return vectorFileTypes.at(i).c_str();
}


bool MTPLibWrapperTest::hasSuffix(char *cName)
{
    ENTRY_INTERNAL
    bool bRet = false;

    int i=0;
    char suffix[3+1];
    char *pOffset = NULL;

    if(NULL != cName)
    {
        ETG_TRACE_USR4(("MTPLibWrapperTest::hasSuffix: %s",cName));
        pOffset = strrchr(cName,'.');
    }
    if( (NULL != pOffset) && (pOffset[0] != '\0'))
    {
        bRet = true; //function does care for availability of suffix

        while((pOffset[i+1] != '\0') && (i<10))  //@todo what if last elem is not '\0' then we get memory error - care for that later
        {
            suffix[i] = pOffset[i+1];
            i++;
        }
        suffix[3] = '\0';
        ETG_TRACE_USR4(("->MTPLibWrapperTest::hasSuffix: YES : %s",suffix));

    }
    else
    {
        ETG_TRACE_USR4(("->MTPLibWrapperTest::hasSuffix: NO"));
    }

    return bRet;
}



void MTPLibWrapperTest::showDevices()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start %s **********", __PRETTY_FUNCTION__));

    int deviceIndex;
    tNumberOfDevices numberOfMTPDevices = 0;

    LIBMTP_mtpdevice_t *pDevice, *pDeviceList;
    char *cModelname,*cFrienlyname,*cSerialnumber,*cDeviceversion,*Manufacturername;

    wLIBMTP_Get_Connected_Devices(OUT &pDeviceList); //@todo error case

    for(pDevice = pDeviceList; pDevice != NULL; pDevice = pDevice->next)
    {
        ETG_TRACE_USR4(("MTPControlTest::showDevices():pDevice      :%p ",pDevice));
        ETG_TRACE_USR4(("MTPControlTest::showDevices():pDevice->next:%p ",pDevice->next));

        cModelname       = wLIBMTP_Get_Modelname(IN pDevice);
        cFrienlyname     = wLIBMTP_Get_Friendlyname(IN pDevice);
        cSerialnumber    = wLIBMTP_Get_Serialnumber(IN pDevice);
        cDeviceversion   = wLIBMTP_Get_Deviceversion(IN pDevice);
        Manufacturername = wLIBMTP_Get_Manufacturername(IN pDevice);
        numberOfMTPDevices++;

        ETG_TRACE_USR4(("MTPControlTest::showDevices():cModelname         : %s",cModelname));
        ETG_TRACE_USR4(("MTPControlTest::showDevices():cFrienlyname       : %s",cFrienlyname));
        ETG_TRACE_USR4(("MTPControlTest::showDevices():cSerialnumber      : %s",cSerialnumber));
        ETG_TRACE_USR4(("MTPControlTest::showDevices():cDeviceversion     : %s",cDeviceversion));
        ETG_TRACE_USR4(("MTPControlTest::showDevices():Manufacturername   : %s",Manufacturername));

        deviceIndex = getDeviceIndex(IN pDevice);
        if(INVALID_INDEX != deviceIndex)
        {
            ETG_TRACE_USR4(("MTPControlTest::showDevices():cMountPoint    : %s",m_deviceList[deviceIndex].cMountPoint));
            ETG_TRACE_USR4(("MTPControlTest::showDevices():cDirectoryTest : %s",m_deviceList[deviceIndex].cDirectoryTest));

            ETG_TRACE_USR4(("MTPControlTest::showDevices():device         : %p",&(m_deviceList[deviceIndex].device)));
            ETG_TRACE_USR4(("MTPControlTest::showDevices():pDevice        : %p",pDevice));

            ETG_TRACE_USR4(("MTPControlTest::showDevices():pDevice->next  : %p",pDevice->next))

        }
        else
        {
            ETG_TRACE_FATAL(("MTPControlTest::showDevices(): INVALID_INDEX"));
        }

    }

    ETG_TRACE_USR4(("MTPControlTest::showDevices():pMTPLibWrapper-m_deviceIndex:%d ",m_deviceIndex));
    ETG_TRACE_USR4(("MTPControlTest::showDevices():numberOfMTPDevices          :%d ",numberOfMTPDevices));
    ETG_TRACE_USR3(("<-********** OK %s **********", __PRETTY_FUNCTION__));
}


LIBMTP_mtpdevice_t *MTPLibWrapperTest::matchDevice2MountPoint(IN char* serialNumber,IN char* deviceVersion, IN char* deviceName)
{
    ENTRY_INTERNAL;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));

    LIBMTP_mtpdevice_t *pRet = NULL;
    ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint: deviceName   : %s",deviceName));
    ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint: deviceVersion: %s",deviceVersion));
    ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint: serialNumber : %s",serialNumber));

    int   ifound = 0;
    char *strModelname;
    char *strFriendlyname;
    char *strSerialnumber;
    char *strDeviceversion;
    //char *strManufacturername;
    LIBMTP_mtpdevice_t *pDevice;


    for(int i=0;i<MAXMTPTESTDEVICES;i++)
    {
        if(m_deviceList[i].bValid == true)
        {
            pDevice = &(m_deviceList[i].device);
            ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint(): pDevice      =%p",pDevice));
            ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint(): pDevice->next=%p",pDevice->next));
            strModelname        = wLIBMTP_Get_Modelname(pDevice);
            strFriendlyname     = wLIBMTP_Get_Friendlyname(pDevice);           //<--?
            strSerialnumber     = wLIBMTP_Get_Serialnumber(pDevice);           //<--compare to mountpoint
            strDeviceversion    = wLIBMTP_Get_Deviceversion(pDevice);          //<--compare to mountPoint
            //strManufacturername = m_pMTPLibWrapper->LIBMTP_Get_Manufacturername(device);


            ifound = 0;

            if(    (NULL != strModelname)
                && (NULL != strFriendlyname)
                && (NULL !=strSerialnumber)
                && (NULL != strDeviceversion))
            {
                if(ISEQUAL == strcmp(strSerialnumber,serialNumber) )    //1.
                {
                    ifound++;
                    ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint: %d/3 serialNumber matches (%s)",ifound,strSerialnumber));
                }
                if( ISEQUAL == strcmp(strDeviceversion,deviceVersion) ) //2.
                {
                    ifound++;
                    ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint: %d/3 deviceVersion matches (%s)",ifound,strDeviceversion));
                }
#if 0
                if( ISEQUAL == strcmp(strFriendlyname,deviceName) )     //3.  ///@todo check this condition
                {
                    ifound++;
                    ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint: %d/3 deviceName matches (friendlyname) (%s)",ifound,strFriendlyname));
                }
                else if(ISEQUAL == strcmp(strModelname,deviceName) )    //4.
                {
                    ifound++;
                    ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint: %d/3 deviceName matches (modelname) (%s)",ifound,strModelname));
                }
#endif
                if(ifound==2)
                {
                    pRet = pDevice;
                    ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint: ok (pDevice=%p)",pDevice));
                    break;
                }
            }
            else
            {
                ETG_TRACE_FATAL(("MTPLibWrapperTest::matchDevice2MountPoint: LIBMTP_Get_... returned NULL"));
            }
        }
        else
        {
            break;
        }
    }

    if(ifound !=2)   ///@todo ease code which uses ifound==

    {
        pRet = NULL;
        ETG_TRACE_USR4(("MTPLibWrapperTest::matchDevice2MountPoint:  pRet = NULL"));
    }


    return pRet;
}

void MTPLibWrapperTest::wLIBMTP_destroy_file_t(LIBMTP_file_t *file)
{
    ENTRY_INTERNAL;
    (void)file;
    ETG_TRACE_USR3(("Run: %s", __PRETTY_FUNCTION__));
}

LIBMTP_file_t* MTPLibWrapperTest::wLIBMTP_Get_Filelisting_With_Callback(LIBMTP_mtpdevice_t* device, LIBMTP_progressfunc_t const callback, void const *const data)
{
     ENTRY_INTERNAL;
     (void)device;
     (void)callback;
     (void)data;

     LIBMTP_file_t* pFile = NULL;
     ETG_TRACE_USR3(("Run: %s", __PRETTY_FUNCTION__));

     return pFile;
}



