#ifndef _MTPCONTROLUNITTESTSTUB_H_
#define _MTPCONTROLUNITTESTSTUB_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"
#include "MTPControl.h"
#include "MTPLibWrapperTest.h"


class MTPControlUnitTestStubbed : public MTPControl, public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MTPControlUnitTestStubbed );

    //test deviceinfo
#if 1
    CPPUNIT_TEST(LIBMTP_Get_Connected_Devices);
    CPPUNIT_TEST(LIBMTP_Get_Connected_Devices_checkDevPointer);
    CPPUNIT_TEST(LIBMTP_Get_Connected_Devices_m_deviceIndex);
    CPPUNIT_TEST(LIBMTP_Get_Modelname);
    CPPUNIT_TEST(LIBMTP_Get_Friendlyname);
    CPPUNIT_TEST(LIBMTP_Get_Serialnumber);
    CPPUNIT_TEST(LIBMTP_Get_Deviceversion);
    CPPUNIT_TEST(LIBMTP_Get_Manufacturername);

    //test device content
    CPPUNIT_TEST(LIBMTP_Get_Trackmetadata);
    CPPUNIT_TEST(LIBMTP_Get_Trackmetadata_numOfSongs);
    CPPUNIT_TEST(LIBMTP_Get_Track_To_File);
#endif
    //CPPUNIT_TEST(LIBMTP_Get_Tracklisting_Track_With_Callback);
    //CPPUNIT_TEST( matchDevice2MountPointTest );
    //CPPUNIT_TEST( fillMediaObject );

    CPPUNIT_TEST_SUITE_END();

public:

    MTPControlUnitTestStubbed(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*to test mocked MTPLibAdapter*/

    void LIBMTP_Get_Connected_Devices();
    void LIBMTP_Get_Connected_Devices_checkDevPointer();
    void LIBMTP_Get_Connected_Devices_m_deviceIndex();
    void LIBMTP_Get_Tracklisting_Track_With_Callback();
    void LIBMTP_Get_Modelname();
    void LIBMTP_Get_Friendlyname();
    void LIBMTP_Get_Serialnumber();
    void LIBMTP_Get_Deviceversion();
    void LIBMTP_Get_Manufacturername();
    void LIBMTP_Get_Trackmetadata();
    void LIBMTP_Get_Trackmetadata_numOfSongs();
    void LIBMTP_Get_Track_To_File();

    /*test helper functions used by MTPControl*/
    void matchDevice2MountPointTest();
    void fillMediaObject();


    virtual void factoryGetLibMTPWrapper();


private:
    static bool          m_bPrintTestInfo;
    tResult              m_ret;
    TimeTrace            m_ticks;        /**< time object to trace the time taken by testcases */
    MTPLibWrapperTest    m_MTPLibWrapperTest;

    void AddTestDevices();
    void clearDevices();
    void PrintTestInfo();
    bool fileExists(char *cPathFile); ///@todo shift to util
};

#endif  // _MTPControlUnitTestStubbed_H_
