#ifndef _MTPCONTROLUNITTEST_H_
#define _MTPCONTROLUNITTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"
#include "MTPControl.h"


#define MAX_LIBMTP_DEVICES 3

//class MTPControl;

class MTPControlUnitTest : public MTPControl, public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MTPControlUnitTest );

    CPPUNIT_TEST( GenerateMountPointTest );
    CPPUNIT_TEST( GetFileFormat_known );
    CPPUNIT_TEST( GetFileFormat_known_CapitalLetters );
    CPPUNIT_TEST( GetFileFormat_unknown );
    CPPUNIT_TEST( DoGetAlbumArtThread );
    CPPUNIT_TEST( MTPCalcFingerPrint );
    CPPUNIT_TEST( deleteTemporalFile );
    CPPUNIT_TEST( comparePreviousID_equal );
    CPPUNIT_TEST( comparePreviousID_notequal );
    CPPUNIT_TEST( comparePreviousID_notexists );
    CPPUNIT_TEST( comparePreviousID_wrongParm );
    CPPUNIT_TEST( devTable );
    CPPUNIT_TEST( EncodeMountPoint );
    CPPUNIT_TEST( DecodeMountPoint );
    CPPUNIT_TEST( writeIDentifier);

    CPPUNIT_TEST_SUITE_END();

public:

    MTPControlUnitTest(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    void GenerateMountPointTest();
    void GetFileFormat_known();
    void GetFileFormat_known_CapitalLetters();
    void GetFileFormat_unknown();
    void DoGetAlbumArtThread();
    void MTPCalcFingerPrint();
    void deleteTemporalFile();
    void comparePreviousID_equal();
    void comparePreviousID_notequal();
    void comparePreviousID_notexists();
    void comparePreviousID_wrongParm();
    void devTable();
    void EncodeMountPoint();
    void DecodeMountPoint();
    void writeIDentifier();


private:
    tResult              m_ret;
    TimeTrace            m_ticks;        /**< time object to trace the time taken by testcases */

    tResult test_getfileformat(INOUT tUInt &iCount,IN tFileFormat expectedFileFormat,IN const char* cSuffix);
  
    void util_setupInfoID();    ///@todo think about shifting these to MTPControlUtil
    void util_createDirMtp();
    void util_createTmpFile(char *f_cFileName);
    bool util_isExistFile(char *f_cFileName);
    bool util_isContentEqualString(char *f_cFileName,char *f_cContent, unsigned int sizeOfContent);
    void util_filldevinfo(OUT tDeviceInfo &oDevInfo,IN const char* deviceName, IN const char* deviceVersion,IN const char* serialNumber, IN const char* mountPoint);


};

#endif  // _MTPCONTROLTEST_H_
