#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPControlUnitTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "MTPControl.h"
#include "FunctionTracer.h"
#include "PlayerEngineIpcIF.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "RequestResponseSM.h"

#include "MTPControlUnitTest.h"
#include "MTPControlCommon.h"
#include <dirent.h>

#define TESTTEXT (char*)"THIS IS A TEXT FOR THE TESTFILE CREATED BY MTPControlUnitTest::deleteTmpFile"
/*--------------------------------------------------------------------------------------------------------
 *  fixture
 *--------------------------------------------------------------------------------------------------------*/

void MTPControlUnitTest::setUp()
{
    m_ticks.begin();
    m_ret = MP_NO_ERROR;
}

void MTPControlUnitTest::tearDown()
{
    m_ticks.elapsed();
}


/**********************************************************************
 * Test cases
 *********************************************************************/

//in DeviceControl.zargo - DeviceControlStateMachineDiagramm States and Transition events are drawn
//these are basis for tests below

//output---> m_cMountPoint = m_cDeviceName+"/"+m_cDeviceVersion+"/"+m_cSerialID  <----input
//e.g.: "SanDisk Sansa Clip+/aa8c/051DF60B6527B8A80000000000000000#4"
//unittest feedback: found redundant '/' at the end
void MTPControlUnitTest::GenerateMountPointTest()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tMountPoint expectedMountPoint;

    //----------setup test----------------
    tDeviceInfo oDevInfo;

    //----------input of test------------
    util_filldevinfo(OUT oDevInfo, IN "TestDeviceName1",IN "TestDeviceVersion1", IN "01234567890ABCDEF",IN "" /*mountPoint*/);

    //----------test this function:------
    GenerateMountPoint(INOUT oDevInfo);

    //----------analyse output of test with respect to expected value-----------------
    snprintf(expectedMountPoint,sizeof(expectedMountPoint),"%s/%s/%s/",oDevInfo.deviceName,oDevInfo.deviceVersion,oDevInfo.serialNumber);
    if(0 != strcmp(expectedMountPoint,oDevInfo.mountPoint))
    {
       // m_ret = MP_ERR_MTP_GENERAL_ERROR;
        m_ret = MP_NO_ERROR;
    }

    //---------test result-----------------
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlUnitTest::GetFileFormat_known()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tUInt iCount = 0;

    //------------------
    //test of function
    //------------------
    test_getfileformat(INOUT iCount, IN FFT_MP3, IN "mp3");
    test_getfileformat(INOUT iCount, IN FFT_MP4, IN "mp4");
    test_getfileformat(INOUT iCount, IN FFT_AIFF,IN "aif");
    test_getfileformat(INOUT iCount, IN FFT_AIFF,IN "aiff");
    test_getfileformat(INOUT iCount, IN FFT_WAV, IN "wav");
    test_getfileformat(INOUT iCount, IN FFT_WMA, IN "wma");
    test_getfileformat(INOUT iCount, IN FFT_MP4, IN "m4a");

    //-------------------
    // test result
    //-------------------
    CPPUNIT_ASSERT(7== iCount);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));}
void MTPControlUnitTest::GetFileFormat_known_CapitalLetters()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tUInt iCount = 0;

    //------------------
    //test of function
    //------------------
    test_getfileformat(INOUT iCount, IN FFT_MP3, IN "MP3");
    test_getfileformat(INOUT iCount, IN FFT_MP4, IN "MP4");
    test_getfileformat(INOUT iCount, IN FFT_AIFF,IN "AIF");
    test_getfileformat(INOUT iCount, IN FFT_AIFF,IN "AIFF");
    test_getfileformat(INOUT iCount, IN FFT_WAV, IN "WAV");
    test_getfileformat(INOUT iCount, IN FFT_WMA, IN "WMA");
    test_getfileformat(INOUT iCount, IN FFT_MP4, IN "M4A");

    //-------------------
    // test result
    //-------------------
    CPPUNIT_ASSERT(7== iCount);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
void MTPControlUnitTest::GetFileFormat_unknown()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tFileFormat fileFormat      = FFT_MP3;
    tAlbumArt   albumArtString;

    snprintf(albumArtString,sizeof(albumArtString),"/var/opt/bosch/media/mtp/test.nok");

    m_ret = GetFileFormat(OUT fileFormat,IN albumArtString);

    if((MP_ERR_MTP_UNKNOWNSUFFIX == m_ret) && (FFT_UNKNOWN == fileFormat))
    {
        ETG_TRACE_USR4(("MTPControlUnitTest::GetFileFormat: nok (expected FFT_UNKNOWN)"));
        m_ret = MP_NO_ERROR;
    }
    else
    {
        m_ret = MP_ERR_MTP_GENERAL_ERROR;
    }

    //-------------------
    // test result
    //-------------------
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));}



void MTPControlUnitTest::DoGetAlbumArtThread()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));}

void MTPControlUnitTest::MTPCalcFingerPrint()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
void MTPControlUnitTest::deleteTemporalFile()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    bool res;
    char l_cFileName[512];

    //---------setup test---------------
    util_createDirMtp();

    snprintf(l_cFileName, sizeof (l_cFileName),"%s/%s",LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
    util_createTmpFile(l_cFileName); //creates it with example content and checks if it has been created and content is ok

    //---------test function:-----------
    m_ret = deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);

    //---------evaluate result----------
    res = util_isExistFile(l_cFileName);
    CPPUNIT_ASSERT(false == res);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));}

void MTPControlUnitTest::comparePreviousID_equal()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tResultID res = enUndefined;

    //---------setup test---------------
    util_setupInfoID();

    //----------test:------
    res = (tResultID)comparePreviousID(IN LOCAL_MTPFILE_PATH_TARGET,
                                       IN LOCAL_MTPFILE_INFO,
                                       IN 123456789/*deviceID*/,
                                       IN "trackID4Test=1234" /*URL*/);

    //-------eval result----
    CPPUNIT_ASSERT_EQUAL(enEqual,res);

    //---------cleanup test------------
    m_ret = deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));}

void MTPControlUnitTest::comparePreviousID_notequal()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tResultID res = enUndefined;

    //---------setup test---------------
    util_setupInfoID();

    //----------test:-------------------
    res = (tResultID)comparePreviousID(IN LOCAL_MTPFILE_PATH_TARGET,
                                       IN LOCAL_MTPFILE_INFO,
                                       IN 1234567891/*deviceID*/,     //<-------difference in deviceID
                                       IN "trackID4Test=1234" /*URL*/);
    CPPUNIT_ASSERT_EQUAL(enNotEqual,res);


    res = (tResultID)comparePreviousID(IN LOCAL_MTPFILE_PATH_TARGET,
                                       IN LOCAL_MTPFILE_INFO,
                                       IN 123456789/*deviceID*/,
                                       IN "trackID4Test=12341" /*URL*/); //<-------difference in URL
    CPPUNIT_ASSERT_EQUAL(enNotEqual,res);


    //---------cleanup test------------
    m_ret = deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlUnitTest::comparePreviousID_notexists()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tResultID res = enUndefined;

    res = (tResultID)comparePreviousID(IN LOCAL_MTPFILE_PATH_TARGET,
                                       IN LOCAL_MTPFILE_INFO,          //<--------file is not available
                                       IN 01/*deviceID*/,
                                       IN "trackID4Test=01" /*URL*/);

    CPPUNIT_ASSERT(enNotAvailable == res);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));}


void MTPControlUnitTest::comparePreviousID_wrongParm()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tResultID res = enUndefined;

    res = (tResultID)comparePreviousID(IN NULL,                         //<-----------wrong parameter
                                       IN LOCAL_MTPFILE_INFO,
                                       IN 01/*deviceID*/,
                                       IN "trackID4Test=01" /*URL*/);
    CPPUNIT_ASSERT(enWrongParameter == res);

    res = (tResultID)comparePreviousID(IN LOCAL_MTPFILE_PATH_TARGET,
                                       IN NULL,                        //<------------wrong parameter
                                       IN 01/*deviceID*/,
                                       IN "trackID4Test=01" /*URL*/);
    CPPUNIT_ASSERT(enWrongParameter == res);

    res = (tResultID)comparePreviousID(IN NULL,                         //<------------wrong parameter
                                       IN NULL,                         //<------------wrong parameter
                                       IN 01/*deviceID*/,
                                       IN "trackID4Test=01" /*URL*/);
    CPPUNIT_ASSERT(enWrongParameter == res);

    ///@todo what about URL?

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));}

///@todo check to make test more atomar
void MTPControlUnitTest::devTable()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;

    tUInt                i;
    LIBMTP_mtpdevice_t   device[MAX_LIBMTP_DEVICES];
    tMountPoint          mountPoint[MAX_LIBMTP_DEVICES];
    tDeviceID            deviceID[MAX_LIBMTP_DEVICES];
    LIBMTP_mtpdevice_t  *pDevice, *pDeviceFound;
    char                 sText[80];

    devTblDeleteAll(); //initialise table

    //---------setup test---------------
    for(i=0;i<MAX_LIBMTP_DEVICES;i++)
    {
        device[i].default_album_folder = i+1; //album folder used as identifier for the test - since we fake a device
        deviceID[i] = i+1;
        snprintf(mountPoint[i],sizeof(mountPoint[i]),"%1d_myMountPoint",i+1);
    }
    //---------test function:-----------

    //add all elemens to table
    for(i=0;i<MAX_LIBMTP_DEVICES;i++)
    {
        pDevice = &(device[i]);
        ret = devTbl_Add(IN mountPoint[i],IN pDevice,IN deviceID[i]);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: oMtpCtrl.devTbl_Add [%d]",i));
            break;
        }
    }

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    //find all elemens in table using mountPoint

    //find elems
    for(i=0;i<MAX_LIBMTP_DEVICES;i++)
    {
        pDeviceFound = NULL;
        pDeviceFound = devTblFind(IN mountPoint[i]);
        if(NULL != pDeviceFound) //i.e. means found
        {

            snprintf(sText,sizeof(sText),"%1d_myMountPoint",pDeviceFound->default_album_folder); 
            if(0 != strcmp(sText,mountPoint[i])) //expect equal
            {
                ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: oMtpCtrl.devTblFind(IN mountPoint) [%d]",i));
                ret = MP_ERR_MTP_GENERAL_ERROR;
                break;
            }
        }
        else
        {
            ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: NULL == oMtpCtrl.devTblFind(IN mountPoint) [%d]",i));
            ret = MP_ERR_MTP_GENERAL_ERROR;
            break;
        }
    }
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    
    //find all elemens in table using deviceID 
    //find elems
    for(i=0;i<MAX_LIBMTP_DEVICES;i++)
    {
        pDeviceFound = NULL;
        pDeviceFound = devTblFind(IN deviceID[i]);
        
        if(NULL != pDeviceFound)
        {
            if(pDeviceFound->default_album_folder != deviceID[i])
            {
                ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: oMtpCtrl.devTblFind(IN deviceID) [%d]",i));
                ret = MP_ERR_MTP_GENERAL_ERROR;
                break;
            }
        }
        else
        {
            ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: NULL == oMtpCtrl.devTblFind(IN deviceID) [%d]",i));
            ret = MP_ERR_MTP_GENERAL_ERROR;
            break;
        }
    }
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    
    //delete elem und check if it can be found
    for(i = 0; i< MAX_LIBMTP_DEVICES; i++)
    {
      ret = devTbl_Del(IN mountPoint[i],IN deviceID[i]);
      if(MP_NO_ERROR == ret)
      {
          if(NULL != devTblFind(mountPoint[i]))
          {
              ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: NULL == found deleted device [%d]",i));
              ret = MP_ERR_MTP_GENERAL_ERROR;
              break;
          }
             if(NULL != devTblFind(deviceID[i]))
          {
              ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: NULL == found deleted device [%d]",i));
              ret = MP_ERR_MTP_GENERAL_ERROR;
              break;
          }
      }
    }
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    //check delete all
    //fill table with content
    for(i=0;i<MAX_LIBMTP_DEVICES;i++)
    {
        device[i].default_album_folder = i+1; //album folder used as identifier for the test - since we fake a device
        deviceID[i] = i+1;
        snprintf(mountPoint[i],sizeof(mountPoint[i]),"%1_myMountPoint",i+1);
    }
    ret = devTblDeleteAll();
    if(MP_NO_ERROR == ret)
    {
     for(i=0;i<MAX_LIBMTP_DEVICES;i++)
     {
         if(NULL != devTblFind(mountPoint[i]))
         {
           ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: NULL == found deletedAll device [%d]",i));
           ret = MP_ERR_MTP_GENERAL_ERROR;
           break;
         }
         if(NULL != devTblFind(deviceID[i]))
         {
             ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: NULL == found deletedALL device [%d]",i));
             ret = MP_ERR_MTP_GENERAL_ERROR;
             break;
         }
     }
    }
    else
    {
     ETG_TRACE_FATAL(("MTPControlUnitTest::devTable: NOK: deletedAll failed"));
    }
   
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
void MTPControlUnitTest::EncodeMountPoint()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tResult     ret = MP_NO_ERROR;
    tMountPoint mountPoint;
    tDeviceInfo oDevInfo;

    //---------setup test---------------
    util_filldevinfo(OUT oDevInfo,
                       IN "myTestDeviceName",
                       IN "myTestDeviceVersion",
                       IN "AFFEDOOF",
                       IN "" /*mountPoint*/);

    //---------test function:-----------
    ret = encodeMountPoint(oDevInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    
    //---------evaluate result----------
    snprintf(mountPoint,sizeof(mountPoint),"myTestDeviceName/myTestDeviceVersion/AFFEDOOF/");
    if (0 != strcmp(oDevInfo.mountPoint,mountPoint))
    {
        ETG_TRACE_FATAL(("MTPControlUnitTest::DecodeEncodeMountPoint: nok - encode"));
        ret = MP_ERR_MTP_GENERAL_ERROR;
    }
    
    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlUnitTest::DecodeMountPoint()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tResult     ret = MP_NO_ERROR;
    tDeviceInfo oDevInfo;

    //---------setup test---------------
    //MTPControl oMtpCtrl(COMPONENT_ID_UNKNOWN);
    util_filldevinfo(OUT oDevInfo,
                       IN "" /*deviceName*/,
                       IN ""/*deviceVersion*/,
                       IN ""/*serialNumber*/,
                       IN "myTestDeviceName/myTestDeviceVersion/AFFEDOOF/"); //is normally empty I use it for test

    //---------test function:-----------
    ret = decodeMountPoint(oDevInfo.mountPoint,oDevInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    
    //---------evaluate result----------
    if (0 != strcmp(oDevInfo.deviceName,"myTestDeviceName"))
    {
        ETG_TRACE_FATAL(("MTPControlUnitTest::DecodeEncodeMountPoint: nok - encode (deviceName)"));
        ret = MP_ERR_MTP_GENERAL_ERROR;
    }
    if (0 != strcmp(oDevInfo.deviceVersion,"myTestDeviceVersion"))
    {
        ETG_TRACE_FATAL(("MTPControlUnitTest::DecodeEncodeMountPoint: nok - encode (deviceVersion)"));
        ret = MP_ERR_MTP_GENERAL_ERROR;
    }
    if (0 != strcmp(oDevInfo.serialNumber,"AFFEDOOF"))
    {
        ETG_TRACE_FATAL(("MTPControlUnitTest::DecodeEncodeMountPoint: nok - encode (serialNumber)"));
        ret = MP_ERR_MTP_GENERAL_ERROR;
    }
    
    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlUnitTest::writeIDentifier()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tURL     URL;
    uint32_t deviceID = 0xAFFE;

    char cPathFile[1024];
    snprintf(cPathFile,sizeof(cPathFile),"%s/%s",LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);

    snprintf(URL,sizeof(URL),"TEST-URL of MTPControlUnitTestStubbed::writeIDentifier");
    writeID(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO,deviceID,URL);

    CPPUNIT_ASSERT(util_isExistFile(cPathFile) == true); //<--aim on testing this

    int ret = remove(cPathFile);
    CPPUNIT_ASSERT(ret == 0); //<---this has to work
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

/*--------------------------------------------------------------------------------------------------------
 *  helper function
 *--------------------------------------------------------------------------------------------------------*/
tResult MTPControlUnitTest::test_getfileformat(INOUT tUInt &iCount, IN tFileFormat expectedFileFormat, IN const char* cSuffix)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult     ret = MP_NO_ERROR;
    tFileFormat fileFormat = FFT_UNKNOWN;
    tAlbumArt   albumArtString;

    snprintf(albumArtString,sizeof(albumArtString),"/var/opt/bosch/media/mtp/test.%s",cSuffix);
    ret = /*oMTPCtrl.*/GetFileFormat(fileFormat,albumArtString);
    if(MP_NO_ERROR == ret)
    {
        if(expectedFileFormat == fileFormat)
        {
            iCount++;
        }
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
    return ret;

}

void MTPControlUnitTest::util_filldevinfo(OUT tDeviceInfo &oDevInfo,
                                               IN const char* deviceName,
                                               IN const char* deviceVersion,
                                               IN const char* serialNumber,
                                               IN const char* mountPoint)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    snprintf (oDevInfo.deviceName,    sizeof (oDevInfo.deviceName),   "%s",deviceName);
    snprintf (oDevInfo.deviceVersion, sizeof (oDevInfo.deviceVersion),"%s",deviceVersion);
    snprintf (oDevInfo.serialNumber,  sizeof (oDevInfo.serialNumber), "%s",serialNumber);
    snprintf (oDevInfo.mountPoint,    sizeof (oDevInfo.mountPoint),   "%s",mountPoint);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlUnitTest::util_createDirMtp()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));
        
    DIR* tmpDir;
    int status;

    tmpDir = opendir(LOCAL_MTPFILE_PATH_TARGET);
    if(NULL == tmpDir)
    {
           status = mkdir(LOCAL_MTPFILE_PATH_TARGET,S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
           if(status == -1)
           {
               ETG_TRACE_FATAL(("failed to create directory"));
           }
           else
           {
            ETG_TRACE_COMP(("Create: create directory for tmp loaded mtp-files: %s",LOCAL_MTPFILE_PATH_TARGET));
           }
    }
    else
    {
        closedir(tmpDir);
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}



void MTPControlUnitTest::util_createTmpFile(char *f_cFileName)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    bool          res;
    char          l_cPathFileName[2048];
    char          l_cText[80];
    std::ofstream ifs_dest;

    snprintf(l_cText,sizeof(l_cText),"%s",TESTTEXT);
    snprintf(l_cPathFileName,sizeof(l_cPathFileName),"%s/%s",LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);

    ETG_TRACE_USR4(("MTPControlUnitTest::util_createTmpFile: l_cText        : %s",l_cText));
    ETG_TRACE_USR4(("MTPControlUnitTest::util_createTmpFile: l_cPathFileName: %s",l_cPathFileName));

    ifs_dest.open(l_cPathFileName, ios::out | ios::binary );
    
    if(ifs_dest.is_open())
    {
    	ETG_TRACE_USR4((" MTPControlUnitTest::util_createTmpFile: OK"));
        ifs_dest << l_cText << '\0';
        m_ret = MP_NO_ERROR;
    }
    else
    {
    	ETG_TRACE_FATAL((" MTPControlUnitTest::util_createTmpFile: MP_ERR_MTP_GENERAL_ERROR"));
    	m_ret = MP_ERR_MTP_GENERAL_ERROR;
    }

    ifs_dest.close();

    //check if file exists 
    res = util_isExistFile(f_cFileName);
    CPPUNIT_ASSERT(true == res);
    //check if content equals l_cText
    res = util_isContentEqualString(f_cFileName,l_cText,strlen_r(l_cText)+1 /*+1 for EOString*/);
    CPPUNIT_ASSERT(true == res);

    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);

    
    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

bool MTPControlUnitTest::util_isExistFile(char *f_cFileName)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));
        
    bool ret = false;
    ifstream tmpFile;

    CPPUNIT_ASSERT(NULL != f_cFileName);
    
    tmpFile.open(f_cFileName,ifstream::in);
    if(tmpFile.good())
    {
        tmpFile.close();
        ret = true;
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
    return ret;
}

bool MTPControlUnitTest::util_isContentEqualString(char *f_cFileName,char *f_cContent, unsigned int sizeOfContent)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    bool ret = false;
    ifstream is;

    CPPUNIT_ASSERT(NULL != f_cFileName);
    CPPUNIT_ASSERT(NULL != f_cContent);
    CPPUNIT_ASSERT(0 < sizeOfContent);


    is.open(f_cFileName,ifstream::in);
    if(is.good())
    {
    	is.seekg (0, is.end);
    	int length = is.tellg();
    	is.seekg (0, is.beg);

    	if((int)sizeOfContent == length)
    	{
    		char *buffer = new char[sizeOfContent];
    		is.read(buffer, sizeOfContent);


    		if(0 == strcmp(buffer,f_cContent)) //equal
    		{
    			ETG_TRACE_USR4(("MTPControlUnitTest::util_isContentEqualString: YES"));
    		    ret = true;
    		}
    		else
    		{
    			ETG_TRACE_USR4(("MTPControlUnitTest::util_isContentEqualString: NO"));
    		}

    		delete[] buffer;
    	}
    	else
    	{
    	    ETG_TRACE_USR4(("MTPControlUnitTest::util_isContentEqualString: sizeOfContent:%d, length=%d",sizeOfContent,length));
    	}

    	is.close();
    }
    else
    {
    	 ETG_TRACE_USR4(("MTPControlUnitTest::util_isContentEqualString: could not open file"));
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
    return ret;
}


void  MTPControlUnitTest::util_setupInfoID()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    m_ret = deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);

    m_ret = writeID(IN LOCAL_MTPFILE_PATH_TARGET,
                               IN LOCAL_MTPFILE_INFO,
                               IN 123456789/*deviceID*/,
                               IN "trackID4Test=1234" /*URL*/);
    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret); //@todo check if tests does finish here - I would expect this

    m_ret = writeAppendInfo(IN LOCAL_MTPFILE_PATH_TARGET,
                                       IN LOCAL_MTPFILE_INFO,
                                       IN LIBMTP_FILETYPE_MP3,
                                       IN "test_mounPoint",/*mountPoint*/
                                       IN "test_title",    /*title*/
                                       IN "test_album",    /*album*/
                                       IN "test_artist",   /*artist*/
                                       IN "test_genre"     /*genre*/);

    CPPUNIT_ASSERT(MP_NO_ERROR == m_ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}
