/*
 * MTPControlTestUtil.h
 *
 *  Created on: Jul 12, 2013
 *      Author: tritonsu
 */

#ifndef MTPCONTROLTESTUTIL_H_
#define MTPCONTROLTESTUTIL_H_



#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"
#include "MTPControl.h"
#include "RequestResponseSM.h"


/*--------------------------------------------------------------------------------------------------------
 *  defines
 *--------------------------------------------------------------------------------------------------------*/
#define NUMOFTESTDEVICES 2

#define INVALID_POSITION   0
#define INVALID_DEVICEID   0
#define INVALID_CUEINGRATE 0
#define INVALID_URL        (char*)"invalid_url"
#define INVALID_READPOS    (char*)"invalid_readpos"
#define INVALID_MOUNTPOINT (char*)"invalid_mountpoint"
#define INVALID_BINFILE    (char*)"invalid_mtpfiledownloadedfromMTPdevice.bin"
#define EMPTY_STRING       (char*)""

#ifndef TARGET_BUILD
//#define MTPDEVICE_INDEX_0 (char*)"/Customer/Simulation/CustomControl/stick_2/Supertramp/Breakfast_In_America"
#define MTPDEVICE_INDEX_0 (char*)"/Customer/Simulation/CustomControl/stick_2"
#define MTPDEVICE_INDEX_1 (char*)"/Customer/Simulation/CustomControl/stick_2/Unheilig/Grosse_Freiheit"

#define ALBUM_ART_TEST_URL_1    (char*)"/Customer/Simulation/CustomControl/stick_2/Supertramp/Supertramp_-_Singles_-_00_-_Its_Raining_Again.mp3"
#define ALBUM_ART_TEST_URL_2    (char*)"/Customer/Simulation/CustomControl/stick_2/Unheilig/Grosse_Freiheit/Unheilig_-_Grosse_Freiheit_-_16_-_Neuland.mp3"
#define ALBUM_ART_TEST_URL_3    (char*)"/Customer/Simulation/CustomControl/test/music/Garbage/Garbage-Garbage-06-A_Stroke_of_Luck.mp3"
#define ALBUM_ART_TEST_URL_4    (char*)"/Customer/Simulation/CustomControl/test/Garbage-Garbage-03-Only_Happy_When_It_Rains.MP3"
#define ALBUM_ART_TEST_URL_5    (char*)"/Customer/Simulation/CustomControl/test/music/Grönemeyer_-_Anders/Herbert_Grönemeyer_-_Nach_Mir.mp3"
#define ALBUM_ART_TEST_URL_6    (char*)"/Customer/Simulation/CustomControl/stick_3/01_WAV_Speedway.wav"
#define ALBUM_ART_TEST_URL_7    (char*)"/Customer/Simulation/CustomControl/stick_3/has-tags.m4a"
#define ALBUM_ART_TEST_URL_8    (char*)"/Customer/Simulation/CustomControl/stick_3/WMA_with_02_Pictures_embedded.wma"
#else
//#define MTPDEVICE_INDEX_0 (char*)"/opt/bosch/test/data/GMP/stick_2/Supertramp/Breakfast_In_America"
#define MTPDEVICE_INDEX_0 (char*)"/opt/bosch/test/data/GMP/stick_2"
#define MTPDEVICE_INDEX_1 (char*)"/opt/bosch/test/data/GMP/stick_2/Unheilig/Grosse_Freiheit"

#define ALBUM_ART_TEST_URL_1    (char*)"/opt/bosch/test/data/GMP/stick_2/Supertramp/Supertramp_-_Singles_-_00_-_Its_Raining_Again.mp3"
#define ALBUM_ART_TEST_URL_2    (char*)"/opt/bosch/test/data/GMP/stick_2/Unheilig/Grosse_Freiheit/Unheilig_-_Grosse_Freiheit_-_16_-_Neuland.mp3"
#define ALBUM_ART_TEST_URL_3    (char*)"/opt/bosch/test/data/GMP/test/music/Garbage/Garbage-Garbage-06-A_Stroke_of_Luck.mp3"
#define ALBUM_ART_TEST_URL_4    (char*)"/opt/bosch/test/data/GMP/test/Garbage-Garbage-03-Only_Happy_When_It_Rains.MP3"
#define ALBUM_ART_TEST_URL_5    (char*)"/opt/bosch/test/data/GMP/test/music/Grönemeyer_-_Anders/Herbert_Grönemeyer_-_Nach_Mir.mp3"
#define ALBUM_ART_TEST_URL_6    (char*)"/opt/bosch/test/data/GMP/stick_3/01_WAV_Speedway.wav"
#define ALBUM_ART_TEST_URL_7    (char*)"/opt/bosch/test/data/GMP/stick_3/has-tags.m4a"
#define ALBUM_ART_TEST_URL_8    (char*)"/opt/bosch/test/data/GMP/stick_3/WMA_with_02_Pictures_embedded.wma"
#endif

#define TIMOUTTIME_SEC 5000

#include "TypeDefinitions.h"

/******************************************************************************************************
 *
 *   Request Response Machine
 *
 ******************************************************************************************************/
#ifndef NO_REQRESP
class MTPControlTestSM: public RequestResponseSM
{
	virtual int HandleInitRequest();
	virtual int HandleEntryWaitingRequest();
	virtual int HandleSuccessRequest(char *allParameters);
};

class AlbumArtRR : public RequestResponseSM
{
	virtual int HandleInitRequest();
	virtual int HandleSuccessRequest(const char *allParameters);
	virtual int HandleLoopBackMessage(const char *allParameters);

    public:
    tAlbumArtObjectPtr mAlbumArtObjectPointer;
    tResult result;
};
#endif

/******************************************************************************************************
 *
 *   class MTPControlTestUti
 *
 ******************************************************************************************************/
class MTPControlTestUtil{

public:
	MTPControlTestUtil();
	virtual ~MTPControlTestUtil(){};


protected:
    tResult                m_ret;
    TimeTrace              m_ticks;        /**< time object to trace the time taken by testcases */
    MTPControl             m_oMtpCtrl;

    tURL                   m_url;
    tDeviceID              m_deviceID;
    tMountPoint            m_mountPoint;

    char                   m_messageString[256];
    tAllParameters         m_parameterString;
    bool                   m_bMTPLibInitialised;



    void util_InitIPC();
    void util_StartStreaming();
    void util_SwitchObserver();
    void util_AllocateAudioInput();

    void util_stop(        IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url);
    void util_play(        IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url);
    void util_pause(       IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url);
    void util_resume(      IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url);
    void util_seekto(      IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url, IN tPlaytime position);
    void util_fastrewind(  IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url, IN tCueingRate rate);
    void util_fastforward( IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url, IN tCueingRate rate);
    void util_removedevice(IN tDeviceID deviceID, IN tMountPoint mountPoint);
    void util_getmetadata( IN tDeviceID deviceID, IN tMountPoint mountPoint,IN tReadPosition readPosition);

    //void util_getalbumart(char *path, char *file, tResult expectedResult);
    void util_GetAlbumArt(tAlbumArt albumArt,tMimeType expectedMimeType, tImageSize expectedImageSize,tBool artAvailable,const char* imageFileName);

    void util_InitDeviceConnection  (OUT tDeviceID &deviceID, IN  tMountPoint mountPoint);
    void util_RemoveDeviceConnection(IN  tDeviceID  deviceID, IN  tMountPoint mountPoint);
    void util_initDBplusLibMTPStub();

    void util_ClearTestDevicesMTPLibWrapper();
    void util_AddTestDevices2MTPLibWrapper(char *pathTestData);
    void util_deleteTmpFile(const char *cPath, const char *cfileName);

    void util_recreateDB();
    void util_InsertNewMTPDevicetoDB(int index);
    void util_showdevicesDB();
    void util_showdevicesMTPLib();

    void util_InsertNewMTPDevicetoDB(char* serialNumber,
									 char* deviceVersion,
									 char* deviceName,
									 char* UUID,
									 tMemorySize         totalSize,
									 tMemorySize         freeSize);

    void util_getConnectedMTPDevice(OUT bool               &bRealDeviceConneted,
								    OUT tDeviceName         f_strModelname,
								    OUT tDeviceName         f_strFriendlyname,
								    OUT tDeviceSerialNumber f_strSerialnumber,
								    OUT tDeviceVersion      f_strDeviceversion,
								    OUT tDeviceName         f_strManufacturername);

    MessageQueue       *m_pTestResultMsgQ; //MTPControl sends results into such Message if available this is used by the test to decide failed or passed
    MessageQueue* TestIF_createTestResultMsgQ();
    void          TestIF_deleteTestResultMsgQ(IN MessageQueue *pTestResultQ);
    void          TestIF_waitForAnswer(const char *strExpectedAnswer);
    void          TestIF_waitForAnswer(const char *strExpectedAnswer, tSearchString &strAnswer);
    void          TestIF_waitForAnswerAlternative(OUT int &numOfMatchingString,IN const char *strExpectedAnswer1,const char *strExpectedAnswer2);


};
#endif /* MTPCONTROLTESTUTIL_H_ */
