/*
 * MTPControlTestUtil.cpp
 *
 *  Created on: Jul 12, 2013
 *      Author: tritonsu
 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPControlTestUtil.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "FunctionTracer.h"
#include "PlayerEngineIpcIF.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include <dirent.h>

#include "MTPControl.h"
#include "MTPLibWrapper.h"
#include "MTPLibWrapperTest.h"
#include "MTPControlTestUtil.h"

/******************************************************************************************************
 *
 *   util/helper functions
 *
 ******************************************************************************************************/

MTPControlTestUtil::MTPControlTestUtil()
{
    m_pTestResultMsgQ    = NULL;
    m_bMTPLibInitialised = FALSE;
}

void MTPControlTestUtil::util_ClearTestDevicesMTPLibWrapper()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));
    MTPLibWrapper *pMTPLibWrapper; ///@todo ease code
    pMTPLibWrapper = LocalSPM::GetMTPControl().GetpMTPLibWrapper();
    MTPLibWrapperTest *pMTPLibWrapperTest = (MTPLibWrapperTest*)pMTPLibWrapper;
    if(pMTPLibWrapperTest)
    {
        pMTPLibWrapperTest->clearDevices();
        pMTPLibWrapperTest->showDevices();
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_AddTestDevices2MTPLibWrapper(char *pathTestData)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));
    tURL URLDev;
    int deviceIndex;
    MTPLibWrapper *pMTPLibWrapper; ///@todo ease code
    pMTPLibWrapper = LocalSPM::GetMTPControl().GetpMTPLibWrapper();

    //CPPUNIT_ASSERT(0    == gMTPConnected); ///@todo care for 1 for these tests
    //CPPUNIT_ASSERT(NULL != pMTPLibWrapper);

    MTPLibWrapperTest   *pMTPLibWrapperTest = (MTPLibWrapperTest*)pMTPLibWrapper;

    //----------------------------------------
    //add test devices to MTPLibWrapperTest
    //----------------------------------------
    if(pMTPLibWrapperTest && pathTestData)
    {
        char *pwd = get_current_dir_name();

        if(pwd)
        {
#ifndef TARGET_BUILD
            strncpy_r(URLDev, pwd, sizeof(URLDev));
            strncat_r(URLDev, pathTestData, sizeof(URLDev)); //@todo shift to define
#else
            strncpy_r(URLDev, pathTestData, sizeof(URLDev)); //@todo shift to define
#endif

            pMTPLibWrapperTest->AddTestDevice(URLDev);

            deviceIndex = pMTPLibWrapperTest->getDeviceIndex();
            ETG_TRACE_USR4(("util_AddTestDevices2MTPLibWrapper: m_MTPLibWrapperTest.m_deviceIndex=%d , device:%s",deviceIndex, URLDev));

            free(pwd);
        }
        else
        {
            ETG_TRACE_FATAL(("util_ClearAddTestDevices(): ERROR with get_current_dir_name()"));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("util_ClearAddTestDevices(): pMTPLibWrapperTest is NULL"));
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


void MTPControlTestUtil::util_InsertNewMTPDevicetoDB(int index)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult     res;

    tDeviceInfo deviceInfo;

    /* set device data */
    InitDeviceInfo(OUT deviceInfo);

    deviceInfo.activeSource    = 1;
    deviceInfo.connected       = 1;
    deviceInfo.deviceType      = DTY_MTP;
    deviceInfo.connectionState = CS_CONNECTED;
    deviceInfo.fileSystemType = FSTY_UNKNOWN;
    deviceInfo.partitionNumber = PARTITION_NUMBER_NONE;
    deviceInfo.totalSize = 0;
    deviceInfo.freeSize = 0;
    deviceInfo.productID = 1111;
    deviceInfo.connectionType = DCT_USB;
    snprintf(deviceInfo.UUID,         sizeof(deviceInfo.UUID)         -1,"%d_uuid",         index);
    snprintf(deviceInfo.serialNumber, sizeof(deviceInfo.serialNumber) -1,"%d_serialnumber", index);
    snprintf(deviceInfo.deviceVersion,sizeof(deviceInfo.deviceVersion)-1,"%d_deviceversion",index);
    snprintf(deviceInfo.deviceName,   sizeof(deviceInfo.deviceName)   -1,"%d_devicename",   index);
    snprintf(deviceInfo.mountPoint,   sizeof(deviceInfo.mountPoint)   -1,"/%d_deviceversion/%d_serialnumber/",   index,index); //for MTP this is generated - see generateMountPoint
    snprintf(deviceInfo.accessoryName,sizeof(deviceInfo.accessoryName)-1,"%d_accessoryName",index);

    //add device to DB
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}



void MTPControlTestUtil::util_InsertNewMTPDevicetoDB(char* f_serialNumber,
                                                     char* f_deviceVersion,
                                                     char* f_deviceName,
                                                     char* f_UUID,
                                                     tMemorySize f_totalSize,
                                                     tMemorySize f_freeSize)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult     res;

    tDeviceInfo l_deviceInfo;

    /* set device data */
    InitDeviceInfo(OUT l_deviceInfo);

    l_deviceInfo.activeSource    = 0;///@todo check for other tests if 1 is demanded
    l_deviceInfo.connected       = 1;
    l_deviceInfo.deviceType      = DTY_MTP;
    l_deviceInfo.connectionState = CS_CONNECTED;
    snprintf(l_deviceInfo.UUID ,          sizeof (l_deviceInfo.UUID ),         "%s",f_UUID);
    snprintf(l_deviceInfo.serialNumber ,  sizeof (l_deviceInfo.serialNumber ), "%s",f_serialNumber);
    snprintf(l_deviceInfo.deviceVersion,  sizeof (l_deviceInfo.deviceVersion ),"%s",f_deviceVersion);
    snprintf(l_deviceInfo.deviceName,     sizeof (l_deviceInfo.deviceName ),   "%s",f_deviceName);

    //mountPoint = cDeviceName+"/"+cDeviceVersion+"/"+cSerialID+"/"
    //e.g.: SanDisk Sansa Clip+/aa8c/051DF60B6527B8A80000000000000000#4/   //sperator at the end of each entry
    // result: deviceName    : SanDisk Sansa Clip+
    //         deviceVersion : aa8c
    //         serialNumber  : 051DF60B6527B8A80000000000000000#4

    snprintf(l_deviceInfo.mountPoint , sizeof (l_deviceInfo.mountPoint),"%s/%s/%s/",l_deviceInfo.deviceName,l_deviceInfo.deviceVersion,l_deviceInfo.serialNumber);
    l_deviceInfo.fileSystemType  = FSTY_UNKNOWN;
    l_deviceInfo.partitionNumber = PARTITION_NUMBER_NONE;
    l_deviceInfo.totalSize       = f_totalSize;
    l_deviceInfo.freeSize        = f_freeSize;
    l_deviceInfo.productID       = 1111;
    l_deviceInfo.connectionType  = DCT_USB;

    //add device to DB
    res = LocalSPM::GetDBManager().AddDevice(INOUT l_deviceInfo);
    CPPUNIT_ASSERT(res == 0);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


void MTPControlTestUtil::util_recreateDB()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult res;

    //----------------------------
    //recreate the test database
    //----------------------------
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(res == 0);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_InitDeviceConnection(OUT tDeviceID &deviceID, IN tMountPoint mountPoint)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;

    MTPControlTestSM objMyRRSM;
    //---------------------------------------------
    // Send INIT_DEVICE_CONNECTION to MTPControlSM
    //---------------------------------------------
    //expected to be called:
    //  1. tResult GenerateMountPoint(INOUT tDeviceInfo &deviceInfo);
    //  2. tResult IsInitRequired(const tMountPoint mountPoint, const tDeviceID deviceID);

    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN mountPoint);

    ETG_TRACE_USR4(("MTPControlTestUtil::util_InitDeviceConnection: deviceID: %d mountPoint:%s",deviceID,mountPoint));

    //strncpy_r(m_messageString, "MTPControlSM::INIT_DEVICE_CONNECTION", sizeof(m_messageString));

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    tDeviceInfo deviceInfo;
    InitDeviceInfo(deviceInfo);
    deviceInfo.deviceID = deviceID;
    strncpy_r(deviceInfo.mountPoint, mountPoint, sizeof(deviceInfo.mountPoint));
    tDeviceInfoString deviceInfoString;
    DataProvider::MarshalDeviceInfo(deviceInfoString, deviceInfo);

    ret = LocalSPM::GetMTPControl().ParameterINIT_DEVICE_CONNECTION(OUT m_parameterString,
                                                                     IN sizeof(m_parameterString),
                                                                     IN deviceInfoString);

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    //ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS); ///@todo check if MTPControl answer in InitAnwer really reaches this because it sends it to the indexer or if it works because of timout
    ret = LocalSPM::GetMTPControl().SendEventByName("INIT_DEVICE_CONNECTION", IN m_parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_RemoveDeviceConnection(IN  tDeviceID  deviceID, IN  tMountPoint mountPoint)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;

    //---------------------------------------------
    // Send REMOVE_DEVICE_CONNECTION to MTPControlSM
    //---------------------------------------------
    //expected to be called:
    //  1. RemoveDeviceConnection(...) in MTPControl

    ETG_TRACE_USR4(("MTPControlTestUtil::util_RemoveDeviceConnection: deviceID: %d mountPoint:%s",deviceID,mountPoint));

    //strncpy_r(m_messageString, "MTPControlSM::REMOVE_DEVICE_CONNECTION", sizeof(m_messageString));

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ret = LocalSPM::GetMTPControl().ParameterREMOVE_DEVICE_CONNECTION(OUT m_parameterString,
                                                                     IN sizeof(m_parameterString),
                                                                     IN mountPoint,
                                                                     IN deviceID);

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetMTPControl().SendEventByName("REMOVE_DEVICE_CONNECTION", IN m_parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


//play song
void MTPControlTestUtil::util_play(tDeviceID deviceID, tMountPoint mountPoint,tURL url)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;
    tUUID uuid = {0};

    //------------------------------------------
    // Send PLAY message to MTPControlSM
    //------------------------------------------
    ETG_TRACE_USR4(("MTPControlTestUtil::Play():PLAY to MTPControlSM"));
    strncpy(m_messageString, "MTPControlSM::PLAY", sizeof(m_messageString)-1);

    ret = LocalSPM::GetMTPControl().ParameterPLAY(OUT m_parameterString,
                                                  IN sizeof(m_parameterString),
                                                  IN DTY_MTP, /*deviceType*/
                                                  IN deviceID,
                                                  IN url,     /*URL holds the unique track id of a certain device*/
                                                  IN mountPoint,
                                                  IN uuid,
                                                  IN 0,       /*tPEHandle*/
                                                  IN 0,       /*tPlaytime, other example:tPlaytime position = 75000; //1:15min*/
                                                  IN false    /*tStreaming*/);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_stop(IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;

    strncpy(m_messageString, "MTPControlSM::STOP", sizeof(m_messageString)-1);

    ret = LocalSPM::GetMTPControl().ParameterSTOP(OUT m_parameterString,
                                                   IN sizeof(m_parameterString),
                                                   IN DTY_MTP, /*deviceType*/
                                                   IN deviceID,
                                                   IN url,
                                                   IN mountPoint);

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_pause(tDeviceID deviceID, tMountPoint mountPoint, tURL url)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;

    /* Send STOP message to MTPControlSM */
    strncpy(m_messageString, "MTPControlSM::PAUSE", sizeof(m_messageString)-1);
    ret = LocalSPM::GetMTPControl().ParameterPAUSE(OUT m_parameterString,
                                                   IN sizeof(m_parameterString),
                                                   IN DTY_MTP/*deviceType*/,
                                                   IN deviceID,
                                                   IN url,
                                                   IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


void MTPControlTestUtil::util_resume(tDeviceID deviceID, tMountPoint mountPoint, tURL url)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;

    /* Send STOP message to MTPControlSM */
    strncpy(m_messageString, "MTPControlSM::RESUME", sizeof(m_messageString)-1);
    ret = LocalSPM::GetMTPControl().ParameterRESUME(OUT m_parameterString,
                                                     IN sizeof(m_parameterString),
                                                     IN DTY_MTP/*deviceType*/,
                                                     IN deviceID,
                                                     IN url,
                                                     IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}



void MTPControlTestUtil::util_initDBplusLibMTPStub()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));
    //-----------------------
    //recreate DB
    //-----------------------
    util_recreateDB();   //@todo check if it makes sense to shift this to fixture note it'll create dummy devices USB and IPOD maybe one can create it empty

    //------------------------
    //add device to Database
    //------------------------
    //looks like that for index = 0:
    //deviceInfo.deviceType      = DTY_MTP
    //deviceInfo.connectionState = CS_CONNECTED
    //deviceInfo.indexedState    = IDS_NOT_STARTED
    //deviceInfo.UUID            = "0_uuid"
    //deviceInfo.serialNumber    = "0_serialnumber"
    //deviceInfo.deviceVersion   = "0_deviceversion"
    //deviceInfo.deviceName      = "0_devicename"
    util_InsertNewMTPDevicetoDB(0 /*index of device*/);  //index used to create matches to content of devices on MTPLibWrapperTest to ease testing

    // & for index = 1:
    //deviceInfo.deviceType      = DTY_MTP
    //deviceInfo.connectionState = CS_CONNECTED
    //deviceInfo.indexedState    = IDS_NOT_STARTED
    //deviceInfo.UUID            = "1_uuid"
    //deviceInfo.serialNumber    = "1_serialnumber"
    //deviceInfo.deviceVersion   = "1_deviceversion"
    //deviceInfo.deviceName      = "1_devicename"
    util_InsertNewMTPDevicetoDB(1);

    //----------------------------------------------------------------------------
    //tell MTPLibWrapper where to get test data from and fill dummy devices data
    //-----------------------------------------------------------------------------
    util_ClearTestDevicesMTPLibWrapper();
    util_AddTestDevices2MTPLibWrapper(MTPDEVICE_INDEX_0); //add TestDevices to MTPLibWrapperTest
    util_AddTestDevices2MTPLibWrapper(MTPDEVICE_INDEX_1);

    ETG_TRACE_USR3(("<-********** OK %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_seekto(IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url,IN tPlaytime position )
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;

    /* Send SEEK_TO message to MTPControlSM */
    strncpy(m_messageString, "MTPControlSM::SEEK_TO", sizeof(m_messageString)-1);
    ret = LocalSPM::GetMTPControl().ParameterSEEK_TO(OUT m_parameterString,
                                                      IN sizeof(m_parameterString),
                                                      IN DTY_MTP /*deviceType*/,
                                                      IN deviceID,
                                                      IN url,
                                                      IN mountPoint,
                                                      IN position);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_fastforward(IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url,IN tCueingRate rate)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;
    speedstate_e IsPlaybackSpeed = ME_SPEEDSTATE_OFF;

    /* Send SEEK_TO message to MTPControlSM */
    strncpy(m_messageString, "MTPControlSM::FFWD", sizeof(m_messageString)-1);
    ret = LocalSPM::GetMTPControl().ParameterFFWD(OUT m_parameterString,
                                                   IN sizeof(m_parameterString),
                                                   IN DTY_MTP/*deviceType*/,
                                                   IN deviceID,
                                                   IN url,
                                                   IN mountPoint,
                                                   IN rate,
                                                   IN IsPlaybackSpeed);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


void MTPControlTestUtil::util_fastrewind(IN tDeviceID deviceID, IN tMountPoint mountPoint, IN tURL url,IN tCueingRate rate)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;
    speedstate_e IsPlaybackSpeed = ME_SPEEDSTATE_OFF;

    /* Send SEEK_TO message to MTPControlSM */
    strncpy(m_messageString, "MTPControlSM::FREV", sizeof(m_messageString)-1);
    ret = LocalSPM::GetMTPControl().ParameterFREV(OUT m_parameterString,
                                                   IN sizeof(m_parameterString),
                                                   IN DTY_MTP/*deviceType*/,
                                                   IN deviceID,
                                                   IN url,
                                                   IN mountPoint,
                                                   IN rate,
                                                   IN IsPlaybackSpeed);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_removedevice(IN tDeviceID deviceID, IN tMountPoint mountPoint)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;

    /* Send REMOVE_DEVICE_CONNECTION message to MTPControlSM */
    ret = LocalSPM::GetMTPControl().ParameterREMOVE_DEVICE_CONNECTION(OUT m_parameterString,
                                                                       IN sizeof(m_parameterString),
                                                                       IN mountPoint,
                                                                       IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetMTPControl().SendEventByName("REMOVE_DEVICE_CONNECTION", IN m_parameterString);

    sleep(1); ///@todo why can't we use objMyRRSM.DoEventAnswer

    // test result
    CPPUNIT_ASSERT(ret == 0);
    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_getmetadata(IN tDeviceID deviceID, IN tMountPoint mountPoint,IN tReadPosition readPosition)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;

    ETG_TRACE_USR4(("MTPControlTestUtil::util_getmetadata: deviceID  :%d",deviceID));
    ETG_TRACE_USR4(("MTPControlTestUtil::util_getmetadata: mountPoint:%s",mountPoint));
    ETG_TRACE_USR4(("MTPControlTestUtil::util_getmetadata: readPosition  :%p",readPosition));

    /* Send GET_METADATA message to MTPControlSM */
    strncpy(m_messageString, "MTPControlSM::GET_METADATA", sizeof(m_messageString)-1);

    ret = LocalSPM::GetMTPControl().ParameterGET_METADATA(OUT m_parameterString,
                                                           IN sizeof(m_parameterString),
                                                           IN mountPoint,
                                                           IN readPosition,
                                                           IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

//void MTPControlTestUtil::util_getalbumart(char *path, char *file, tResult expectedResult)
void MTPControlTestUtil::util_GetAlbumArt(tAlbumArt albumArt,tMimeType expectedMimeType, tImageSize expectedImageSize,tBool artAvailable,const char* imageFileName)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult    ret = MP_NO_ERROR;
    AlbumArtRR objMyRRSM;
    tAlbumArt  albumArtPath;

    ETG_TRACE_USR4(("Get album art test for url : %s",albumArt));

    /* Frame GET_ALBUM_ART message to USBControlSM */
    strncpy(m_messageString, "MTPControlSM::GET_ALBUM_ART", sizeof(m_messageString)-1);

#ifndef TARGET_BUILD
    char *pwd = get_current_dir_name();
    strncpy(  (char *)albumArtPath, (const char *)pwd, sizeof(tAlbumArt)-1);
    strncat_r((char *)albumArtPath,          albumArt, sizeof(tAlbumArt));
    free(pwd);
#else
    strncpy(  (char *)albumArtPath,  albumArt, sizeof(tAlbumArt));
#endif

    ETG_TRACE_USR4(("Get album art test for albumArtPath : %s",albumArtPath));

    ret = LocalSPM::GetMTPControl().ParameterGET_ALBUM_ART(OUT m_parameterString,
                                                            IN sizeof(m_parameterString),
                                                            IN albumArtPath);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    if(artAvailable)        // expecting that file contains a valid album art , then verify against albumart attributes like size and type
    {
        CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.result);
        ETG_TRACE_USR3(("Albumart found with size:mime->(%d,%d) for url->%s\n",objMyRRSM.mAlbumArtObjectPointer->imageSize,objMyRRSM.mAlbumArtObjectPointer->mimeType,albumArt));
        ETG_TRACE_USR3(("Albumart expected   size:mime->(%d,%d) for url->%s\n",expectedImageSize,expectedMimeType,albumArt));

        CPPUNIT_ASSERT(objMyRRSM.mAlbumArtObjectPointer->mimeType == expectedMimeType);
        CPPUNIT_ASSERT(objMyRRSM.mAlbumArtObjectPointer->imageSize == expectedImageSize);

#ifndef TARGET_BUILD
        FILE *imageFile;
        imageFile = fopen(imageFileName,"wb");
        fwrite(objMyRRSM.mAlbumArtObjectPointer->imageData,1,objMyRRSM.mAlbumArtObjectPointer->imageSize, imageFile);
        fclose(imageFile);
#endif
        free(objMyRRSM.mAlbumArtObjectPointer->imageData);
        delete objMyRRSM.mAlbumArtObjectPointer;
    }
    else        // expecting that given file does not contain any valid album art .
    {
        CPPUNIT_ASSERT(MP_NO_ERROR != objMyRRSM.result);
        ETG_TRACE_USR3(("Expected result: %d, Album art not available for file: %s", objMyRRSM.result, albumArt));
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


void MTPControlTestUtil::util_showdevicesDB()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    tNumberOfDevices numberOfDevices;
    std::vector<tDeviceInfo> deviceInfo;

    res = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfo);
    if(res == MP_NO_ERROR) ///@todo check why it works for other tests
    {
         for (std::vector<tDeviceInfo>::iterator it = deviceInfo.begin() ; it != deviceInfo.end(); ++it)
         {
             if(it->deviceType == DTY_MTP)
             {
                 ETG_TRACE_USR4(("MTPControlTestUtil::util_showdevicesDB(): deviceType    : DTY_MTP"));
                 ETG_TRACE_USR4(("MTPControlTestUtil::util_showdevicesDB(): deviceID      : %d",it->deviceID));
                 ETG_TRACE_USR4(("MTPControlTestUtil::util_showdevicesDB(): deviceName    : %s",it->deviceName));
                 ETG_TRACE_USR4(("MTPControlTestUtil::util_showdevicesDB(): serialNumber  : %s",it->serialNumber));
                 ETG_TRACE_USR4(("MTPControlTestUtil::util_showdevicesDB(): deviceVersion : %s",it->deviceVersion));
                 ETG_TRACE_USR4(("MTPControlTestUtil::util_showdevicesDB(): mountPoint    : %s",it->mountPoint));
             }
             else
             {
                 ETG_TRACE_USR4(("MTPControlTestUtil::util_showdevicesDB(): deviceType    : %d (not DTY_MTP)",it->deviceType));
                 ETG_TRACE_USR4(("MTPControlTestUtil::util_showdevicesDB(): mountPoint    : %s",it->mountPoint));
             }
         }
    }


    ETG_TRACE_USR4(("MTPControlTestUtil::util_showdevicesDB():numberOfDevices:%d ",numberOfDevices));
    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_deleteTmpFile(const char *cPath, const char *cfileName)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    ifstream tmpFile;
    char l_cFileName[2048];

    snprintf(l_cFileName, sizeof (l_cFileName),"%s/%s",cPath,cfileName);

    tmpFile.open(l_cFileName,ifstream::in);
    if(tmpFile.good())
    {
        ETG_TRACE_USR4(("util_deleteTmpFile: File exists (ok)"));
        tmpFile.close();
        if(remove(l_cFileName) !=0)
        {
            ETG_TRACE_FATAL(("[ERROR] util_deleteTmpFile: FAILED"));
        }
    }
    else
    {
        ETG_TRACE_USR4(("util_deleteTmpFile: File not exist (ok)"));
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_showdevicesMTPLib()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    MTPLibWrapper     *pMTPLibWrapper     = LocalSPM::GetMTPControl().GetpMTPLibWrapper();
    MTPLibWrapperTest *pMTPLibWrapperTest = (MTPLibWrapperTest*)pMTPLibWrapper;

    if(pMTPLibWrapperTest)
    {
        pMTPLibWrapperTest->showDevices();
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_InitIPC()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;

    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));

    /* Call StartAllocateAudioOutput */
    ret = LocalSPM::GetDeviceDispatcher().StartAllocateAudioOutput(IN audioOutputDevice);

    sleep(2); //Wait a little bit until IPC is initialized

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}
void MTPControlTestUtil::util_AllocateAudioInput()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;

    /* Send ALLOCATE_AUDIO_INPUT message to MTPControlSM */
    strncpy(m_messageString, "MTPControlSM::ALLOCATE_AUDIO_INPUT", sizeof(m_messageString)-1);
    ret = objMyRRSM.DoEventAnswer(IN m_messageString, (char *)NULL, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_StartStreaming()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;

    /* Send START_STREAMING message to MTPControlSM */
    strncpy(m_messageString, "MTPControlSM::START_STREAMING", sizeof(m_messageString)-1);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, (char *)NULL, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::util_SwitchObserver()
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;

    /* Send SWITCH_OBSERVER message to MTPControlSM */
    strncpy(m_messageString, "MTPControlSM::SWITCH_OBSERVER", sizeof(m_messageString)-1);

    ret = objMyRRSM.DoEventAnswer(IN m_messageString, (char *)NULL, NULL, MTP_CTRL_SM_ANSWER_TIMEOUT_MS);

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


void MTPControlTestUtil::util_getConnectedMTPDevice(OUT bool               &bRealDeviceConnected,
                                                    OUT tDeviceName         f_strModelname,
                                                    OUT tDeviceName         f_strFriendlyname,
                                                    OUT tDeviceSerialNumber f_strSerialnumber,
                                                    OUT tDeviceVersion      f_strDeviceversion,
                                                    OUT tDeviceName         f_strManufacturername)
{

    ENTRY_INTERNAL
    ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    bRealDeviceConnected  = false;

    char *strModelname        = NULL;
    char *strFriendlyname     = NULL;
    char *strSerialnumber     = NULL;
    char *strDeviceversion    = NULL;
    char *strManufacturername = NULL;

    //init empty string
    f_strModelname[0]        = '\0';
    f_strFriendlyname[0]     = '\0';
    f_strSerialnumber[0]     = '\0';
    f_strDeviceversion[0]    = '\0';
    f_strManufacturername[0] = '\0';


    //------------------------------------------------
    //check using libmtp if MTP devices are connected
    //-----------------------------------------------
    if(FALSE == m_bMTPLibInitialised)
    {
        LIBMTP_Init(); //allowed to be called once only
        m_bMTPLibInitialised = true;
    }

    LIBMTP_mtpdevice_t   *pDevice,*pDeviceList;
    //LIBMTP_error_number_t res = LIBMTP_Get_Connected_Devices(&pDeviceList); //@todo don't forget to free

    LIBMTP_raw_device_t *devices;
    int numdevs;
    ETG_TRACE_USR4(("util_getConnectedMTPDevice: calling LIBMTP_Detect_Raw_Devices...."));
    LIBMTP_error_number_t res = LIBMTP_Detect_Raw_Devices(&devices, &numdevs);
    ETG_TRACE_USR4(("util_getConnectedMTPDevice: returned LIBMTP_Detect_Raw_Devices"));
    ETG_TRACE_USR4(("util_getConnectedMTPDevice: numdevs = %d", numdevs));
    if (res != LIBMTP_ERROR_NONE)
    {
        ETG_TRACE_USR4(("util_getConnectedMTPDevice: LIBMTP_Detect_Raw_Devices failed"));
    }

    if (LIBMTP_ERROR_NONE == res)
    {
        for(int iter = 0; iter <= numdevs; iter++)
        {
            ETG_TRACE_USR4(("util_getConnectedMTPDevice: inside iterator, calling LIBMTP_Open_Raw_Device_Uncached"));
            pDeviceList = LIBMTP_Open_Raw_Device_Uncached(&devices[iter]);
            ETG_TRACE_USR4(("util_getConnectedMTPDevice: inside iterator, returned LIBMTP_Open_Raw_Device_Uncached"));
            pDevice = pDeviceList;
            for(; pDevice != NULL; pDevice = pDevice->next)
            {
                ETG_TRACE_USR4(("util_getConnectedMTPDevice:matchDevice2MountPoint(): pDevice      =%p",pDevice));
                ETG_TRACE_USR4(("util_getConnectedMTPDevice:matchDevice2MountPoint(): pDevice->next=%p",pDevice->next));
                strModelname        = LIBMTP_Get_Modelname(pDevice);
                strFriendlyname     = LIBMTP_Get_Friendlyname(pDevice);           //<--?
                strSerialnumber     = LIBMTP_Get_Serialnumber(pDevice);           //<--compare to mountpoint
                strDeviceversion    = LIBMTP_Get_Deviceversion(pDevice);          //<--compare to mountPoint
                strManufacturername = LIBMTP_Get_Manufacturername(pDevice);

                ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getMTPDevices: strModelname        : %s",strModelname));
                ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getMTPDevices: strFriendlyname     : %s",strFriendlyname));
                ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getMTPDevices: strSerialnumber     : %s",strSerialnumber));
                ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getMTPDevices: strDeviceversion    : %s",strDeviceversion));
                ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getMTPDevices: strManufacturername : %s",strManufacturername));

                if(strModelname){        snprintf(f_strModelname,        sizeof(tDeviceName),        "%s",strModelname);}
                if(strFriendlyname)
                {
                    snprintf(f_strFriendlyname,     sizeof(tDeviceName),        "%s",strFriendlyname);
                }
                else
                {
                    // No device friendly name present; so copy the model name to friendly name
                    snprintf(f_strFriendlyname,     sizeof(tDeviceName),        "%s",strModelname);
                }

                if(strSerialnumber){     snprintf(f_strSerialnumber,     sizeof(tDeviceSerialNumber),"%s",strSerialnumber);}
                if(strDeviceversion){    snprintf(f_strDeviceversion,    sizeof(tDeviceVersion),     "%s",strDeviceversion);}
                if(strManufacturername){ snprintf(f_strManufacturername, sizeof(tDeviceName),        "%s",strManufacturername);}

                bRealDeviceConnected = true;
                LIBMTP_Release_Device_List(pDeviceList);

                break; //first device found will be taken
            }
        }
    }
    free(devices);
}

void MTPControlTestUtil::TestIF_waitForAnswer(const char *strExpectedAnswer)
{
    tSearchString strAnswer;
    TestIF_waitForAnswer(strExpectedAnswer,strAnswer);
}

void MTPControlTestUtil::TestIF_waitForAnswer(const char *strExpectedAnswer,tSearchString &strAnswer)
{
    ENTRY_INTERNAL;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));

    //tSearchString strAnswer;
    char sText[1024];
    void  *receive_buffer = NULL;
    size_t receive_size = 0;

    receive_buffer = m_pTestResultMsgQ->WaitForMessage(&receive_size,TIMOUTTIME_SEC);

    CPPUNIT_ASSERT(NULL != receive_buffer);
    CPPUNIT_ASSERT(receive_size > 0);

    snprintf(strAnswer,sizeof(tSearchString),"%s",receive_buffer);
    snprintf(sText,sizeof(sText),"message received:receive_size:%d receive_buffer:%s",receive_size,strAnswer);
    ETG_TRACE_USR3(("%s",sText));

    if(NULL != strExpectedAnswer)
    {
        ETG_TRACE_USR4(("MTPControlTestRealDevice::TestIF_waitForAnswer: check expectedAnswer"));
        CPPUNIT_ASSERT( 0 == strcmp(strAnswer,strExpectedAnswer) );
    }

    free(receive_buffer);
    receive_buffer = NULL;

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestUtil::TestIF_waitForAnswerAlternative(OUT int &numOfMatchingString,IN const char *strExpectedAnswer1,const char *strExpectedAnswer2)
{
    ENTRY_INTERNAL;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));

    //tSearchString strAnswer;
    char          sText[1024];
    void         *receive_buffer = NULL;
    size_t        receive_size   = 0;
    tSearchString strAnswer;

    numOfMatchingString   = -1;
    receive_buffer = m_pTestResultMsgQ->WaitForMessage(&receive_size,TIMOUTTIME_SEC);

    CPPUNIT_ASSERT(NULL != receive_buffer);
    CPPUNIT_ASSERT(receive_size > 0);

    snprintf(strAnswer,sizeof(tSearchString),"%s",receive_buffer);
    snprintf(sText,sizeof(sText),"TestIF_waitForAnswerAlternative:message received:receive_size:%d receive_buffer:%s",receive_size,strAnswer);
    ETG_TRACE_USR3(("%s",sText));

    if((NULL != strExpectedAnswer1) && (NULL != strExpectedAnswer2))
    {
        ETG_TRACE_USR4(("MTPControlTestRealDevice::TestIF_waitForAnswer: check expectedAnswer"));
        if(0 == strcmp(strAnswer,strExpectedAnswer1) )
        {
            ETG_TRACE_USR4(("MTPControlTestUtil::TestIF_waitForAnswerAlternative: matching 1:%s",strExpectedAnswer1));
            numOfMatchingString = 1;
        }
        else if(0 == strcmp(strAnswer,strExpectedAnswer2))
        {
            ETG_TRACE_USR4(("MTPControlTestUtil::TestIF_waitForAnswerAlternative: matching 2:%s",strExpectedAnswer2));
            numOfMatchingString = 2;
        }
    }
    //CPPUNIT_ASSERT(numOfMatchingString !=  -1);

    free(receive_buffer);
    receive_buffer = NULL;

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


///@todo maybe shift to test function just hand over pTestResultQ
MessageQueue* MTPControlTestUtil::TestIF_createTestResultMsgQ()
{
    ENTRY_INTERNAL;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));

    MessageQueue *pTestResultQ= new MessageQueue("MQ4");
    if(NULL == pTestResultQ)
    {
        ETG_TRACE_FATAL(("[ERROR] MTPControlTestUtil::TestIF_createTestResultMsgQ: NULL == pTestResultQ"));
    }
    return pTestResultQ;

}
void MTPControlTestUtil::TestIF_deleteTestResultMsgQ(IN MessageQueue *pTestResultQ)
{
    ENTRY_INTERNAL;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));

    pTestResultQ->Flush();
    delete pTestResultQ;
    pTestResultQ = NULL;
}

/******************************************************************************************************
 *
 *   MTPControlTestSM - see header
 *
 ******************************************************************************************************/
int MTPControlTestSM::HandleInitRequest()
{
    return 0;
}

int MTPControlTestSM::HandleEntryWaitingRequest()
{
    return 0;
}

int MTPControlTestSM::HandleSuccessRequest(char *allParameters)
{
    /* the request/expect state machine has a general SUCCESS_REQUEST message which is not
    // specialized to a service state machine be called, so all kind of parameters must
    // be processed by hand in this method. */
    ETG_TRACE_USR1(("MTPControlTestSM::HandleSuccessRequest allParameters:%s", allParameters));
    return 0;
}

/******************************************************************************************************
 *
 *   AlbumArtRR - see header
 *
 ******************************************************************************************************/

int AlbumArtRR::HandleInitRequest()
{
    mAlbumArtObjectPointer = NULL;
    result = MP_NO_ERROR;
    return 0;
}

int AlbumArtRR::HandleLoopBackMessage(const char *allParameters)
{
    HandleSuccessRequest(NULL);
    return 0;
}

int AlbumArtRR::HandleSuccessRequest(const char *allParameters)
{
    if (!allParameters || strlen_r(allParameters) == 0)
    {
        /* set an error */
        result = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
    }
    /* read out the pointer to the album art object */
    UnMarshal(IN allParameters, "i", OUT &mAlbumArtObjectPointer);

    /* no album art object? */
    if (!mAlbumArtObjectPointer)
    {
        /* set an error */
        result = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
    }
    return 0;
}



