#ifndef _MTPCONTROLTESTREALDEVICE_H_
#define _MTPCONTROLTESTREALDEVICE_H_

#include <cppunit/extensions/HelperMacros.h>

#include "MTPControlTestUtil.h"

class MTPControlTestRealDevice : public MTPControlTestUtil, public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MTPControlTestRealDevice );

    CPPUNIT_TEST( Fingerprint );
    CPPUNIT_TEST( RetrieveMetadata );
    CPPUNIT_TEST( PlaySong );

    CPPUNIT_TEST( RetrieveMetadataAll );
    CPPUNIT_TEST( FingerPrintAndRetrieveMetadataAll );

    CPPUNIT_TEST( FingerPrintAndRetrieveMetadataSingleTrack );

    CPPUNIT_TEST( ReadRootFolder );

    CPPUNIT_TEST_SUITE_END();

public:

    MTPControlTestRealDevice(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    void Fingerprint();
    void RetrieveMetadata();
    void PlaySong();

    void RetrieveMetadataAll();
    void FingerPrintAndRetrieveMetadataAll();
    void FingerPrintAndRetrieveMetadataSingleTrack();
    void ReadRootFolder(void);

private:
    tResult             m_ret;
    TimeTrace           m_ticks;        /**< time object to trace the time taken by testcases */

    tDeviceID           m_deviceID;
    tMountPoint         m_mountPoint;
    tFingerprint        m_lastFingerprint;

    bool                m_bRealDeviceConnected;
    tDeviceName         m_strModelname;
    tDeviceName         m_strFriendlyname;
    tDeviceSerialNumber m_strSerialnumber;
    tDeviceVersion      m_strDeviceversion;
    tDeviceName         m_strManufacturername;
    tMemorySize         m_totalSize;
    tMemorySize         m_freeSize;

};


#endif  // _MTPCONTROLTESTREALDEVICE_H_
