#ifndef _DEVICEDISPATCHERTEST_H_
#define _DEVICEDISPATCHERTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"

class DeviceDispatcherTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( DeviceDispatcherTest );
    CPPUNIT_TEST( Allocate );
    CPPUNIT_TEST( PlayTrack1 );
    CPPUNIT_TEST( SeekToTrack1 );
    CPPUNIT_TEST( BufferTrack2 );
    CPPUNIT_TEST( ChangeToTrack2 );
    CPPUNIT_TEST( PauseAndResumeTrack2 );
    CPPUNIT_TEST( FFwdTrack2 );
    CPPUNIT_TEST( FRevTrack2 );
    CPPUNIT_TEST( StopTrack2 );
    //CPPUNIT_TEST( IPCStressTest );
    CPPUNIT_TEST( DeAllocate );
    CPPUNIT_TEST_SUITE_END();

public:

    DeviceDispatcherTest(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void Allocate();
    void DeAllocate();
    void PlayTrack1();
    void SeekToTrack1();
    void BufferTrack2();
    void ChangeToTrack2();
    void PauseAndResumeTrack2();
    void FFwdTrack2();
    void FRevTrack2();
    void StopTrack2();
    void IPCStressTest();

    /*helper functions*/
    void GetUSBTrack1(tMediaObject &mediaObject);
    void GetUSBTrack2(tMediaObject &mediaObject);

    void Play(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tObjectID objectID,
        const tPlaytime position=0,
        const tStreaming streaming=false);

private:
    TimeTrace ticks;         /**< time object to trace the time taken by testcases */
};

#endif  // _DEVICEDISPATCHERTEST_H_
