#ifndef _DVDCONTROLINTERFACETEST_H_
#define _DVDCONTROLINTERFACETEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "ConfigTest.h"
#include "TypeDefinitions.h"
#include "TimeTrace.h"
#include "DVDControlInterface.h"

class DVDControlInterfaceTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( DVDControlInterfaceTest );

#ifdef USE_TESTS_WITH_REAL_DVDDRIVE
    CPPUNIT_TEST( Initialize );
    CPPUNIT_TEST( SwitchToBackendMode );
    CPPUNIT_TEST( readTOC );
    CPPUNIT_TEST( SwitchToBackendMode );
    CPPUNIT_TEST( getCDTextInfo );
    CPPUNIT_TEST( DirectPlay );
    CPPUNIT_TEST( Pause );
    CPPUNIT_TEST( DirectPlay );
    CPPUNIT_TEST( WaitPlease );
    CPPUNIT_TEST(NavigateDown);
    CPPUNIT_TEST(NavigateUp);
    CPPUNIT_TEST(NavigateDown);
    CPPUNIT_TEST(NavigateEnter);
    CPPUNIT_TEST( WaitPlease );
    CPPUNIT_TEST(NavigateLeft);
    CPPUNIT_TEST(NavigateRight);
    CPPUNIT_TEST(NavigateEnter);
    CPPUNIT_TEST(DirectButtonCommand);
    CPPUNIT_TEST( DeInitialize );
    CPPUNIT_TEST(Next);
    CPPUNIT_TEST(Next);
    CPPUNIT_TEST(Next);
    CPPUNIT_TEST(CMSkipF1);
    CPPUNIT_TEST(CMSkipF2);
    CPPUNIT_TEST(CMSkipF3);
    CPPUNIT_TEST(CMSkipR1);
    CPPUNIT_TEST(CMSkipR2);
    CPPUNIT_TEST(CMSkipR3);
    CPPUNIT_TEST(FastForward);
    CPPUNIT_TEST(FastReverse);
    CPPUNIT_TEST(SlowForward);
    CPPUNIT_TEST(SlowReverse);
    CPPUNIT_TEST( WaitPlease );
    CPPUNIT_TEST( WaitPlease );
    CPPUNIT_TEST(DirectSearch);
    CPPUNIT_TEST( WaitPlease );
    CPPUNIT_TEST(TitleSearch);
    CPPUNIT_TEST(SubtitleOff);
    CPPUNIT_TEST(SubtitleOn);
    CPPUNIT_TEST(SubtitleChange);
    CPPUNIT_TEST(Previous);
    CPPUNIT_TEST(OneTrackPlay);
    CPPUNIT_TEST(ChangePlayerSettingsDRC);
    CPPUNIT_TEST(ChangePlayerOSDFunctionPlayStatus);
    CPPUNIT_TEST(ChangePlayerDisplayAspectRatio);
    CPPUNIT_TEST(ChangePlayerOSDFunctionAngleMark);
    CPPUNIT_TEST(ChangePlayerSettingsLanguage);
    CPPUNIT_TEST(SubtitleOn);
    CPPUNIT_TEST(SubtitleOff);
    CPPUNIT_TEST(SubtitleChange);
    CPPUNIT_TEST(AudioOutputChangeDVD);
    CPPUNIT_TEST(AudioOutputChangeVCD);
    CPPUNIT_TEST(AngleChange);
    CPPUNIT_TEST(DirectSearch);
    CPPUNIT_TEST(TitleSearch);
    CPPUNIT_TEST(TopMenuPlayback);
    CPPUNIT_TEST(MenuPlayback);
    CPPUNIT_TEST(Navigate);
    CPPUNIT_TEST(TouchCommand);
    CPPUNIT_TEST( Repeat);
    CPPUNIT_TEST(RepeatOff);
    CPPUNIT_TEST(Shuffle);
    CPPUNIT_TEST(ShuffleOff);

#endif
    CPPUNIT_TEST_SUITE_END();

public:

    DVDControlInterfaceTest(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void Initialize();
    void DeInitialize();
    void DirectPlay();
    void SwitchToBackendMode();
    void getCDTextInfo();
    void readTOC();
    void Pause();
    void FastReverse();
    void FastForward();
    void Next();
    void Previous();
    void OneTrackPlay();
    void Repeat();
    void RepeatOff();
    void Shuffle();
    void ShuffleOff();
    void Eject();
    void SlowForward();
    void SlowReverse();
    void SubtitleOn();
    void SubtitleOff();
    void SubtitleChange();
    void AudioOutputChangeDVD();
    void AudioOutputChangeVCD();
    void AngleChange();
    void DirectSearch();
    void TitleSearch();
    void CMSkipF1();
    void CMSkipF2();
    void CMSkipF3();
    void CMSkipR1();
    void CMSkipR2();
    void CMSkipR3();
    void DirectButtonCommand();
    void TopMenuPlayback();
    void MenuPlayback();
    void Navigate();
    void NavigateEnter();
    void NavigateUp();
    void NavigateDown();
    void NavigateLeft();
    void NavigateRight();
    void NavigateReturn();
    void TouchCommand();
    void ChangePlayerSettingsLanguage();
    void ChangePlayerSettingsDRC();
    void ChangePlayerDisplayAspectRatio();
    void ChangePlayerOSDFunctionAngleMark();
    void ChangePlayerOSDFunctionPlayStatus();
    void WaitPlease();
private:
    //void Play(const tURL URL, const tObjectID objectID, const tPlaytime position);

    TimeTrace ticks;        /**< time object to trace the time taken by testcases */
    DVDControlInterface m_DVDControlInterface;
};

#endif  // _CDDACONTROLTEST_H_
