#ifndef _CDDACONTROLTEST_H_
#define _CDDACONTROLTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"

class CDDAControlTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( CDDAControlTest );
    CPPUNIT_TEST( SwitchObserver );
    CPPUNIT_TEST( AllocateAudioInput );

    CPPUNIT_TEST( PlayAudio );
    CPPUNIT_TEST( Pause );
    CPPUNIT_TEST( SeekTo );
    CPPUNIT_TEST( Resume );
    CPPUNIT_TEST( Stop );

    CPPUNIT_TEST( PlayAudio );
    CPPUNIT_TEST( SeekTo );
    CPPUNIT_TEST( Stop );

    CPPUNIT_TEST( PlayAudio );
    CPPUNIT_TEST( FrevStartStop );
    CPPUNIT_TEST( Stop );

    CPPUNIT_TEST( PlayAudio );
    CPPUNIT_TEST( FfwdStartStop );
    CPPUNIT_TEST( Stop );
	#if !defined(TARGET_BUILD) 
    CPPUNIT_TEST( CDDAText );
	#endif
    CPPUNIT_TEST_SUITE_END();

public:

    CDDAControlTest(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void SwitchObserver();
    void AllocateAudioInput();
    void PlayAudio();
    void Pause();
    void SeekTo();
    void Resume();
    void FrevStartStop();
    void FfwdStartStop();
    void Stop();
	#if !defined(TARGET_BUILD) 
    void CDDAText();
	#endif
private:
    void Play(const tURL URL, const tObjectID objectID, const tPlaytime position);

    TimeTrace ticks;        /**< time object to trace the time taken by testcases */
};

#endif  // _CDDACONTROLTEST_H_
