#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/CDDAControlTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "CDDAControl.h"
#include "FunctionTracer.h"
#include "PlayerEngineIpcIF.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "RequestResponseSM.h"
#include "TimeTrace.h"

#include "CDDAControlTest.h"

#include "taginfo.h"

//#define DEVICE "/dev/sr0" // internal drive
#define DEVICE "/dev/sr2" // external drive

using namespace TagInfo;

class USBControlTestSM: public RequestResponseSM
{
    int HandleInitRequest()
    {
        mResult = MP_NO_ERROR;
        return 0;
    }

    int HandleSuccessRequest(const char *allParameters)
    {
        /* the request/expect state machine has a general SUCCESS_REQUEST message which is not
        // specialized to a service state machine be called, so all kind of parameters must
        // be processed by hand in this method. */
        ETG_TRACE_USR1(("USBControlTestSM::HandleSuccessRequest allParameters:%s", allParameters));
        return 0;
    }

    int HandleActionError(const me::reason_e reason)
    {
        //ETG_TRACE_ERR(("USBControlTestSM::HandleActionError reason:%u", reason));
        (void)reason;
        mResult = MP_ERR_ACTION_ERROR;
        return 0;
    }

public:
    tResult mResult;
};


void CDDAControlTest::setUp()
{
    ticks.begin();
}

void CDDAControlTest::tearDown()
{
    ticks.elapsed();
}


/**********************************************************************
 * Test cases
 *********************************************************************/

void CDDAControlTest::AllocateAudioInput()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    USBControlTestSM objMyRRSM;

    /* Send ALLOCATE_AUDIO_INPUT message to CDDAControlSM */
    char messageString[64];
    strncpy_r(OUT messageString, IN "CDDAControlSM::ALLOCATE_AUDIO_INPUT", IN sizeof(messageString));

    ret = objMyRRSM.DoEventAnswer(IN messageString, (char *)NULL, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);
}

void CDDAControlTest::SwitchObserver()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    USBControlTestSM objMyRRSM;

    /* Send SWITCH_OBSERVER message to CDDAControlSM */
    char messageString[64];
    strncpy_r(OUT messageString, IN "CDDAControlSM::SWITCH_OBSERVER", IN sizeof(messageString));

    ret = objMyRRSM.DoEventAnswer(IN messageString, (char *)NULL, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);
}

void CDDAControlTest::PlayAudio()
{
    ENTRY_TEST

    tURL URL;

    strncpy_r(OUT URL, IN DEVICE"/file2.cda", IN sizeof(URL));

    tObjectID objectID = 4711;
    tPlaytime position = 75000; //1:15min

    Play(IN URL, IN objectID, IN position);
}

void CDDAControlTest::Play(const tURL URL, const tObjectID objectID, const tPlaytime position)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_CDDA;
    tDeviceID deviceID = 0;
    tMountPoint mountPoint = {0};
    tUUID uuid = {0};
    tStreaming streaming = false;

    USBControlTestSM objMyRRSM;

    LocalSPM::GetDBManager().GetDevice(OUT deviceID, deviceType);

    /* Send PLAY message to CDDAControlSM */
    char messageString[256];
    strncpy_r(OUT messageString, IN "CDDAControlSM::PLAY", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetUSBControl().ParameterPLAY(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint, IN uuid, IN (tPEHandle)objectID, IN position, IN streaming);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);

    sleep(5); //play at least 5s
}

void CDDAControlTest::Pause()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_CDDA;
    tDeviceID deviceID = 2;
    tURL URL;
    tMountPoint mountPoint = {0};

    strncpy_r(OUT URL, IN DEVICE"/file2.cda", IN sizeof(URL));
    LocalSPM::GetDBManager().GetDevice(OUT deviceID, deviceType);

    USBControlTestSM objMyRRSM;

    /* Send PAUSE message to CDDAControlSM */
    char messageString[256];
    strncpy_r(OUT messageString, IN "CDDAControlSM::PAUSE", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetUSBControl().ParameterPAUSE(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);

    sleep(5); //pause at least 2s
}

void CDDAControlTest::Stop()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_CDDA;
    tDeviceID deviceID = 2;
    tURL URL = {0};
    tMountPoint mountPoint = {0};

    USBControlTestSM objMyRRSM;

    LocalSPM::GetDBManager().GetDevice(OUT deviceID, deviceType);

    /* Send STOP message to CDDAControlSM */
    char messageString[256];
    strncpy_r(OUT messageString, IN "CDDAControlSM::STOP", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetUSBControl().ParameterSTOP(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);
}

void CDDAControlTest::Resume()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_CDDA;
    tDeviceID deviceID = 2;
    tURL URL = {0};
    tMountPoint mountPoint = {0};

    USBControlTestSM objMyRRSM;

    LocalSPM::GetDBManager().GetDevice(OUT deviceID, deviceType);

    /* Send RESUME message to CDDAControlSM */
    char messageString[256];
    strncpy_r(OUT messageString, IN "CDDAControlSM::RESUME", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetUSBControl().ParameterRESUME(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);

    sleep(5); //play at least 5s
}

void CDDAControlTest::SeekTo()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_CDDA;
    tDeviceID deviceID = 2;
    tURL URL = {0};
    tMountPoint mountPoint = {0};
    tPlaytime position = 105000; //1:45min

    USBControlTestSM objMyRRSM;

    LocalSPM::GetDBManager().GetDevice(OUT deviceID, deviceType);

    /* Send SEEK_TO message to CDDAControlSM */
    char messageString[256];
    strncpy_r(OUT messageString, IN "CDDAControlSM::SEEK_TO", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetUSBControl().ParameterSEEK_TO(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint, IN position);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);

    sleep(3); // to hear something
}

void CDDAControlTest::FfwdStartStop()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    tDeviceType deviceType = DTY_CDDA;
    tDeviceID deviceID = 2;
    tURL URL = {0};
    tMountPoint mountPoint = {0};
    tCueingRate rate = 10; //after every second jump 10s

    USBControlTestSM objMyRRSM;

    LocalSPM::GetDBManager().GetDevice(OUT deviceID, deviceType);

    /* Send FFWD message to CDDAControlSM */
    char messageString[256];
    strncpy_r(OUT messageString, IN "CDDAControlSM::FFWD", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    speedstate_e IsPlaybackSpeed = ME_SPEEDSTATE_OFF;

    ret = LocalSPM::GetUSBControl().ParameterFFWD(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint, IN rate, IN IsPlaybackSpeed );
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);

    sleep(5); //Do Ffwd for 3s

    /* Send FFWD_STOP message to CDDAControlSM */
    strncpy_r(OUT messageString, IN "CDDAControlSM::FFWD_STOP", IN sizeof(messageString));

    ret = LocalSPM::GetUSBControl().ParameterFFWD_STOP(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint,IN IsPlaybackSpeed);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);
}

void CDDAControlTest::FrevStartStop()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;
    tDeviceType deviceType = DTY_CDDA;
    tDeviceID deviceID = 2;
    tURL URL = {0};
    tMountPoint mountPoint = {0};
    tCueingRate rate = 10; //after every second jump 10s

    USBControlTestSM objMyRRSM;

    LocalSPM::GetDBManager().GetDevice(OUT deviceID, deviceType);

    /* Send FREV message to CDDAControlSM */
    char messageString[256];
    strncpy_r(OUT messageString, IN "CDDAControlSM::FREV", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    speedstate_e IsPlaybackSpeed = ME_SPEEDSTATE_OFF;

    ret = LocalSPM::GetUSBControl().ParameterFREV(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint, IN rate, IN IsPlaybackSpeed);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);

    sleep(5); //Do Frev for 3s

    /* Send FREV_STOP message to CDDAControlSM */
    strncpy_r(OUT messageString, IN "CDDAControlSM::FREV_STOP", IN sizeof(messageString));

    ret = LocalSPM::GetUSBControl().ParameterFREV_STOP(OUT parameterString, IN size,
            IN deviceType, IN deviceID, IN URL, IN mountPoint,IN IsPlaybackSpeed);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, USB_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(MP_NO_ERROR == objMyRRSM.mResult);
}

/* use a request / response state machine for verifying the received AlbumArt data object */
class AlbumArtRR : public RequestResponseSM
{
    int HandleInitRequest()
    {
        mAlbumArtObjectPointer = NULL;
        result = MP_NO_ERROR;
        return 0;
    }

    int HandleLoopBackMessage(const char *allParameters)
    {
        (void)allParameters;
        HandleSuccessRequest(NULL);
        return 0;
    }

    int HandleSuccessRequest(const char *allParameters)
    {
        if (!allParameters || strlen_r(allParameters) == 0)
        {
            /* set an error */
            result = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
        }
        /* read out the pointer to the album art object */
        UnMarshal(IN allParameters, "p", OUT &mAlbumArtObjectPointer);

        /* no album art object? */
        if (!mAlbumArtObjectPointer)
        {
            /* set an error */
            result = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
        }
        return 0;
    }
    public:
    tAlbumArtObjectPtr mAlbumArtObjectPointer;
    tResult result;
};
#if !defined(TARGET_BUILD) 
//Unit test to verify CD text , extract meta data from the CD buffter availabe in test CD .
void CDDAControlTest::CDDAText()
{
	ENTRY_TEST
	//16 track Album Malibu
	unsigned char ref_Malibu[]= {0x03 ,0xce ,0x01 ,0x10 ,0x80 ,0x00 ,0x00 ,0x00  ,0x4d ,0x61 ,0x6c ,0x69 ,0x62 ,0x75 ,0x00 ,0x54
	,0x68 ,0x65 ,0x20 ,0x42 ,0x00 ,0x00 ,0x80 ,0x01  ,0x01 ,0x05 ,0x69 ,0x72 ,0x64 ,0x00 ,0x48 ,0x65
	,0x61 ,0x72 ,0x74 ,0x20 ,0x44 ,0x6f ,0x00 ,0x00  ,0x80 ,0x02 ,0x02 ,0x08 ,0x6e ,0x3f ,0x74 ,0x20
	,0x53 ,0x74 ,0x61 ,0x6e ,0x64 ,0x20 ,0x41 ,0x20  ,0x00 ,0x00 ,0x80 ,0x02 ,0x03 ,0x0f ,0x43 ,0x68
	,0x61 ,0x6e ,0x63 ,0x65 ,0x00 ,0x54 ,0x68 ,0x65  ,0x20 ,0x57 ,0x00 ,0x00 ,0x80 ,0x03 ,0x04 ,0x05
	,0x61 ,0x74 ,0x65 ,0x72 ,0x73 ,0x00 ,0x54 ,0x68  ,0x65 ,0x20 ,0x53 ,0x65 ,0x00 ,0x00 ,0x80 ,0x04
	,0x05 ,0x06 ,0x61 ,0x73 ,0x6f ,0x6e ,0x2f ,0x43  ,0x61 ,0x72 ,0x72 ,0x79 ,0x20 ,0x4d ,0x00 ,0x00
	,0x80 ,0x04 ,0x06 ,0x0f ,0x65 ,0x00 ,0x50 ,0x75  ,0x74 ,0x20 ,0x4d ,0x65 ,0x20 ,0x54 ,0x68 ,0x72
	,0x00 ,0x00 ,0x80 ,0x05 ,0x07 ,0x0a ,0x75 ,0x00  ,0x41 ,0x6d ,0x20 ,0x49 ,0x20 ,0x57 ,0x72 ,0x6f
	,0x6e ,0x67 ,0x00 ,0x00 ,0x80 ,0x06 ,0x08 ,0x0a  ,0x00 ,0x57 ,0x69 ,0x74 ,0x68 ,0x6f ,0x75 ,0x74
	,0x20 ,0x59 ,0x6f ,0x75 ,0x00 ,0x00 ,0x80 ,0x07  ,0x09 ,0x0b ,0x00 ,0x50 ,0x61 ,0x72 ,0x6b ,0x69
	,0x6e ,0x67 ,0x20 ,0x4c ,0x6f ,0x74 ,0x00 ,0x00  ,0x80 ,0x08 ,0x0a ,0x0b ,0x00 ,0x4c ,0x69 ,0x74
	,0x65 ,0x20 ,0x57 ,0x65 ,0x69 ,0x67 ,0x68 ,0x74  ,0x00 ,0x00 ,0x80 ,0x09 ,0x0b ,0x0b ,0x00 ,0x52
	,0x6f ,0x6f ,0x6d ,0x20 ,0x49 ,0x6e ,0x20 ,0x48  ,0x65 ,0x72 ,0x00 ,0x00 ,0x80 ,0x0a ,0x0c ,0x0b
	,0x65 ,0x00 ,0x57 ,0x61 ,0x74 ,0x65 ,0x72 ,0x20  ,0x46 ,0x61 ,0x6c ,0x6c ,0x00 ,0x00 ,0x80 ,0x0b
	,0x0d ,0x0a ,0x20 ,0x28 ,0x49 ,0x6e ,0x74 ,0x65  ,0x72 ,0x6c ,0x75 ,0x75 ,0x75 ,0x62 ,0x00 ,0x00
	,0x80 ,0x0b ,0x0e ,0x0f ,0x65 ,0x29 ,0x00 ,0x59  ,0x6f ,0x75 ,0x72 ,0x20 ,0x50 ,0x72 ,0x69 ,0x6d
	,0x00 ,0x00 ,0x80 ,0x0c ,0x0f ,0x09 ,0x65 ,0x00  ,0x43 ,0x6f ,0x6d ,0x65 ,0x20 ,0x44 ,0x6f ,0x77
	,0x6e ,0x00 ,0x00 ,0x00 ,0x80 ,0x0e ,0x10 ,0x00  ,0x53 ,0x69 ,0x6c ,0x69 ,0x63 ,0x6f ,0x6e ,0x20
	,0x56 ,0x61 ,0x6c ,0x6c ,0x00 ,0x00 ,0x80 ,0x0e  ,0x11 ,0x0f ,0x65 ,0x79 ,0x00 ,0x43 ,0x65 ,0x6c
	,0x65 ,0x62 ,0x72 ,0x61 ,0x74 ,0x65 ,0x00 ,0x00  ,0x80 ,0x0f ,0x12 ,0x09 ,0x00 ,0x54 ,0x68 ,0x65
	,0x20 ,0x44 ,0x72 ,0x65 ,0x61 ,0x6d ,0x65 ,0x72  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x81 ,0xff ,0x13 ,0x0b
	,0x00 ,0x41 ,0x6e ,0x64 ,0x65 ,0x72 ,0x73 ,0x6f  ,0x6e ,0x20 ,0x2e ,0x50 ,0x00 ,0x00 ,0x81 ,0x00
	,0x14 ,0x0b ,0x61 ,0x61 ,0x6b ,0x00 ,0x41 ,0x6e  ,0x64 ,0x65 ,0x72 ,0x73 ,0x6f ,0x6e ,0x00 ,0x00
	,0x81 ,0x01 ,0x15 ,0x08 ,0x20 ,0x2e ,0x50 ,0x61  ,0x61 ,0x6b ,0x00 ,0x41 ,0x6e ,0x64 ,0x65 ,0x72
	,0x00 ,0x00 ,0x81 ,0x02 ,0x16 ,0x05 ,0x73 ,0x6f  ,0x6e ,0x20 ,0x2e ,0x50 ,0x61 ,0x61 ,0x6b ,0x00
	,0x41 ,0x6e ,0x00 ,0x00 ,0x81 ,0x03 ,0x17 ,0x02  ,0x64 ,0x65 ,0x72 ,0x73 ,0x6f ,0x6e ,0x20 ,0x2e
	,0x50 ,0x61 ,0x61 ,0x6b ,0x00 ,0x00 ,0x81 ,0x03  ,0x18 ,0x0f ,0x20 ,0x66 ,0x65 ,0x61 ,0x74 ,0x2e
	,0x20 ,0x42 ,0x4a ,0x20 ,0x54 ,0x68 ,0x00 ,0x00  ,0x81 ,0x03 ,0x19 ,0x0f ,0x65 ,0x20 ,0x43 ,0x68
	,0x69 ,0x63 ,0x61 ,0x67 ,0x6f ,0x20 ,0x4b ,0x69  ,0x00 ,0x00 ,0x81 ,0x03 ,0x1a ,0x0f ,0x64 ,0x00
	,0x41 ,0x6e ,0x64 ,0x65 ,0x72 ,0x73 ,0x6f ,0x6e  ,0x20 ,0x2e ,0x00 ,0x00 ,0x81 ,0x04 ,0x1b };
	LocalSPM::GetCDDAControl().TestsetCDText(ref_Malibu, 1012, 16);
	//11 Tracl P3 CD set
	unsigned char ref_Chang[]={0x02 , 0x1e , 0x01 , 0x0b , 0x80 , 0x00 , 0x00 , 0x00  , 0x43 , 0x68 , 0x61 , 0x6e , 0x67 ,
    0x69 , 0x6e , 0x67, 0x20 , 0x50 , 0x6c , 0x61 , 0x00 , 0x00 , 0x80 , 0x00  , 0x01 , 0x0f , 0x63 , 0x65 , 
    0x73 , 0x00 , 0x43 , 0x6f, 0x6e , 0x74 , 0x61 , 0x63 , 0x74 , 0x00 , 0x00 , 0x00  , 0x80 , 0x02 , 0x02 , 0x00 , 0x53 ,
	        0x6c , 0x65 , 0x65, 0x70 , 0x65 , 0x72 , 0x20 , 0x49 , 0x6e , 0x20 , 0x4d  , 0x00 , 0x00 , 0x80 , 
            0x02 , 0x03 , 0x0f , 0x65 , 0x74, 0x72 , 0x6f , 0x70 , 0x6f , 0x6c , 0x69 , 0x73 , 0x00  , 0x50 , 
            0x6f , 0x00 , 0x00 , 0x80 , 0x03 , 0x04 , 0x02, 0x65 , 0x6d , 0x20 , 0x46 , 0x6f , 0x72 , 0x20 , 0x41  , 0x20 , 0x4e , 0x75 , 0x63 ,
	        0x00 , 0x00 , 0x80 , 0x03, 0x05 , 0x0f , 0x6c , 0x65 , 0x61 , 0x72 , 0x20 , 0x52  , 0x6f , 0x6d , 
            0x61 , 0x6e , 0x63 , 0x65 , 0x00 , 0x00, 0x80 , 0x04 , 0x06 , 0x00 , 0x57 , 0x61 , 0x6c , 0x6c  , 
            0x69 , 0x65 , 0x73 , 0x00 , 0x4c , 0x6f , 0x76 , 0x65, 0x00 , 0x00 , 0x80 , 0x05 , 0x07 , 0x04 , 
            0x72 , 0x20  , 0x41 , 0x75 , 0x64 ,
	        0x69 , 0x74 , 0x69 , 0x6f , 0x6e, 0x00 , 0x50 , 0x00 , 0x00 , 0x80 , 0x06 , 0x08 , 0x01  , 0x6f , 
            0x65 , 0x74 , 0x73 , 0x20 , 0x54 , 0x75 , 0x72, 0x6d , 0x6f , 0x69 , 0x6c , 0x00 , 0x00 , 0x80 , 
            0x06  , 0x09 , 0x0f , 0x20 , 0x4e , 0x6f , 0x2e , 0x33 , 0x36, 0x34 , 0x00 , 0x45 , 0x63 , 0x68 , 
            0x6f , 0x00 , 0x00  , 0x80 , 0x07 ,
	        0x0a , 0x04 , 0x65 , 0x73 , 0x20 , 0x52, 0x65 , 0x6d , 0x61 , 0x69 , 0x6e , 0x20 , 0x46 , 0x6f  , 
            0x00 , 0x00 , 0x80 , 0x07 , 0x0b , 0x0f , 0x72 , 0x65, 0x76 , 0x65 , 0x72 , 0x00 , 0x41 , 0x6c , 
            0x6c , 0x20  , 0x4e , 0x69 , 0x00 , 0x00 , 0x80 , 0x08 , 0x0c , 0x06, 0x67 , 0x68 , 0x74 , 0x20 ,
            0x50 , 0x61 , 0x72 , 0x74  , 0x79 ,
	        0x00 , 0x50 , 0x61 , 0x00 , 0x00 , 0x80 , 0x09, 0x0d , 0x02 , 0x6e , 0x64 , 0x6f , 0x72 , 0x61 , 
            0x27  , 0x73 , 0x20 , 0x42 , 0x6f , 0x78 , 0x00 , 0x00 , 0x00, 0x80 , 0x0a , 0x0e , 0x00 , 0x46 , 
            0x65 , 0x65 , 0x6c  , 0x00 , 0x54 , 0x68 , 0x65 , 0x20 , 0x4c , 0x61 , 0x73, 0x00 , 0x00 , 0x80 ,
            0x0b , 0x0f , 0x07 , 0x74 , 0x20  ,
	        0x45 , 0x6d , 0x6f , 0x74 , 0x69 , 0x6f , 0x6e , 0x00, 0x00 , 0x00 , 0x00 , 0x00 , 0x81 , 0x02 , 
            0x10 , 0x00  , 0x41 , 0x6e , 0x6e , 0x65 , 0x20 , 0x43 , 0x6c , 0x61, 0x72 , 0x6b , 0x00 , 0x41 , 
            0x00 , 0x00 , 0x81 , 0x03  , 0x11 , 0x01 , 0x6e , 0x6e , 0x65 , 0x20 , 0x43 , 0x6c, 0x61 , 0x72 , 
            0x6b , 0x00 , 0x41 , 0x6e , 0x00 ,
	        0x00  , 0x81 , 0x04 , 0x12 , 0x02 , 0x6e , 0x65 , 0x20 , 0x43, 0x6c , 0x61 , 0x72 , 0x6b , 0x00 , 
            0x41 , 0x6e , 0x6e  , 0x00 , 0x00 , 0x81 , 0x05 , 0x13 , 0x03 , 0x65 , 0x20, 0x43 , 0x6c , 0x61 , 
            0x72 , 0x6b , 0x00 , 0x41 , 0x6e  , 0x6e , 0x65 , 0x00 , 0x00 , 0x81 , 0x06 , 0x14 , 0x04, 0x20 , 
            0x43 , 0x6c , 0x61 , 0x72 , 0x6b ,
	        0x00 , 0x41  , 0x6e , 0x6e , 0x65 , 0x20 , 0x00 , 0x00 , 0x81 , 0x07, 0x15 , 0x05 , 0x43 , 0x6c , 
            0x61 , 0x72 , 0x6b , 0x00  , 0x41 , 0x6e , 0x6e , 0x65 , 0x20 , 0x43 , 0x00 , 0x00, 0x81 , 0x08 ,
            0x16 , 0x06 , 0x6c , 0x61 , 0x72 , 0x6b  , 0x00 , 0x41 , 0x6e , 0x6e , 0x65 , 0x20 , 0x43 , 0x6c,
            0x00 , 0x00 , 0x81 , 0x07 , 0x17 ,
	        0x07 , 0x61 , 0x72  , 0x6b , 0x00 , 0x41 , 0x6e , 0x6e , 0x65 , 0x20 , 0x43, 0x6c , 0x61 , 0x00 , 
            0x00 , 0x81 , 0x08 , 0x18 , 0x08  , 0x72 , 0x6b , 0x00 , 0x41 , 0x6e , 0x6e , 0x65 , 0x20, 0x43 ,
            0x6c , 0x61 , 0x72 , 0x00 , 0x00 , 0x81 , 0x00  , 0x19 , 0x09 , 0x6b , 0x00 , 0x41 , 0x6e , 0x6e , 
            0x65, 0x20 , 0x43 , 0x6c , 0x61 ,
	        0x72 , 0x6b , 0x00 , 0x00  , 0x81 , 0x0a , 0x1a , 0x0a , 0x00 , 0x41 , 0x6e , 0x6e, 0x65 , 0x20 , 
            0x43 , 0x6c , 0x61 , 0x72 , 0x6b , 0x00  , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00, 
            0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00  , 0x00 , 0x00 , 0x00 , 0x00 , 0x8f , 0x00 , 0x1b};
	LocalSPM::GetCDDAControl().TestsetCDText(ref_Chang, 1012, 11);
	//Sound of Swan 8 track
	unsigned char ref_Swan[]={0x01 ,0xd6 ,0x01 ,0x08 ,0x80 ,0x00 ,0x00 ,0x00  ,0x53 ,0x6f ,0x75 ,0x6e ,0x64 ,0x20 ,0x6f ,0x66
	,0x20 ,0x53 ,0x77 ,0x61 ,0x00 ,0x00 ,0x80 ,0x00  ,0x01 ,0x0f ,0x6e ,0x00 ,0x30 ,0x31 ,0x20 ,0x44
	,0x61 ,0x6e ,0x63 ,0x65 ,0x20 ,0x77 ,0x00 ,0x00  ,0x80 ,0x01 ,0x02 ,0x0a ,0x69 ,0x74 ,0x68 ,0x20
	,0x42 ,0x61 ,0x63 ,0x68 ,0x00 ,0x30 ,0x32 ,0x20  ,0x00 ,0x00 ,0x80 ,0x02 ,0x03 ,0x03 ,0x53 ,0x6f
	,0x75 ,0x6e ,0x64 ,0x20 ,0x6f ,0x66 ,0x20 ,0x53  ,0x77 ,0x61 ,0x00 ,0x00 ,0x80 ,0x02 ,0x04 ,0x0f
	,0x6e ,0x00 ,0x30 ,0x33 ,0x20 ,0x46 ,0x72 ,0x69  ,0x65 ,0x6e ,0x64 ,0x20 ,0x00 ,0x00 ,0x80 ,0x03
	,0x05 ,0x0a ,0x52 ,0x65 ,0x71 ,0x75 ,0x65 ,0x73  ,0x74 ,0x00 ,0x30 ,0x34 ,0x20 ,0x46 ,0x00 ,0x00
	,0x80 ,0x04 ,0x06 ,0x04 ,0x72 ,0x65 ,0x74 ,0x73  ,0x20 ,0x61 ,0x6e ,0x64 ,0x20 ,0x46 ,0x69 ,0x6e
	,0x00 ,0x00 ,0x80 ,0x04 ,0x07 ,0x0f ,0x67 ,0x65  ,0x72 ,0x73 ,0x00 ,0x30 ,0x35 ,0x20 ,0x49 ,0x6e
	,0x20 ,0x59 ,0x00 ,0x00 ,0x80 ,0x05 ,0x08 ,0x07  ,0x6f ,0x75 ,0x72 ,0x20 ,0x50 ,0x72 ,0x65 ,0x73
	,0x65 ,0x6e ,0x63 ,0x65 ,0x00 ,0x00 ,0x80 ,0x06  ,0x09 ,0x00 ,0x30 ,0x36 ,0x20 ,0x52 ,0x65 ,0x61
	,0x64 ,0x79 ,0x2e ,0x2e ,0x2e ,0x2e ,0x00 ,0x00  ,0x80 ,0x06 ,0x0a ,0x0f ,0x2e ,0x47 ,0x6f ,0x21
	,0x00 ,0x30 ,0x37 ,0x20 ,0x4d ,0x65 ,0x20 ,0x4d  ,0x00 ,0x00 ,0x80 ,0x07 ,0x0b ,0x07 ,0x6f ,0x6d
	,0x20 ,0x61 ,0x6e ,0x64 ,0x20 ,0x4d ,0x6f ,0x6f  ,0x6e ,0x00 ,0x00 ,0x00 ,0x80 ,0x08 ,0x0c ,0x00
	,0x30 ,0x38 ,0x20 ,0x4e ,0x61 ,0x6d ,0x61 ,0x73  ,0x74 ,0x65 ,0x20 ,0x56 ,0x00 ,0x00 ,0x80 ,0x08
	,0x0d ,0x0f ,0x65 ,0x65 ,0x6e ,0x61 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
	,0x81 ,0x01 ,0x0e ,0x00 ,0x4a ,0x6f ,0x68 ,0x6e  ,0x20 ,0x53 ,0x61 ,0x6d ,0x75 ,0x65 ,0x6c ,0x00
	,0x00 ,0x00 ,0x81 ,0x02 ,0x0f ,0x00 ,0x4a ,0x6f  ,0x6e ,0x61 ,0x68 ,0x20 ,0x53 ,0x61 ,0x6d ,0x75
	,0x65 ,0x6c ,0x00 ,0x00 ,0x81 ,0x03 ,0x10 ,0x00  ,0x44 ,0x2e ,0x41 ,0x2e ,0x53 ,0x72 ,0x69 ,0x6e
	,0x69 ,0x76 ,0x61 ,0x73 ,0x00 ,0x00 ,0x81 ,0x04  ,0x11 ,0x00 ,0x4e ,0x69 ,0x76 ,0x61 ,0x73 ,0x20
	,0x50 ,0x72 ,0x61 ,0x73 ,0x61 ,0x6e ,0x00 ,0x00  ,0x81 ,0x04 ,0x12 ,0x0f ,0x6e ,0x61 ,0x00 ,0x53
	,0x68 ,0x79 ,0x61 ,0x6d ,0x20 ,0x42 ,0x65 ,0x6e  ,0x00 ,0x00 ,0x81 ,0x05 ,0x13 ,0x09 ,0x6a ,0x61
	,0x6d ,0x69 ,0x6e ,0x00 ,0x4e ,0x61 ,0x76 ,0x65  ,0x6e ,0x65 ,0x00 ,0x00 ,0x81 ,0x06 ,0x14 ,0x06
	,0x65 ,0x74 ,0x20 ,0x53 ,0x75 ,0x6e ,0x64 ,0x61  ,0x72 ,0x00 ,0x44 ,0x2e ,0x00 ,0x00 ,0x81 ,0x07
	,0x15 ,0x02 ,0x41 ,0x2e ,0x53 ,0x72 ,0x69 ,0x6e  ,0x69 ,0x76 ,0x61 ,0x73 ,0x00 ,0x4e ,0x00 ,0x00
	,0x81 ,0x08 ,0x16 ,0x01 ,0x2e ,0x53 ,0x65 ,0x6c  ,0x76 ,0x61 ,0x6d ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
	,0x00 ,0x00 ,0x8f ,0x00 ,0x17 ,0x00 ,0x01 ,0x01  ,0x08 ,0x03 ,0x0e ,0x09 ,0x00 ,0x00 ,0x00 ,0x00
	,0x00 ,0x00 ,0x00 ,0x00 ,0x8f ,0x01 ,0x18 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x03
	,0x19 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x8f ,0x02  ,0x19 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00};
	LocalSPM::GetCDDAControl().TestsetCDText(ref_Swan, 1012, 8);
// Welcome To New York 13 track
	unsigned char ref_1989[]={0x02 ,0x8a ,0x01 ,0x0d ,0x80 ,0x00 ,0x00 ,0x00  ,0x31 ,0x39 ,0x38 ,0x39 ,0x00 ,0x57 ,0x65 ,0x6c
	,0x63 ,0x6f ,0x6d ,0x65 ,0x00 ,0x00 ,0x80 ,0x01  ,0x01 ,0x07 ,0x20 ,0x54 ,0x6f ,0x20 ,0x4e ,0x65
	,0x77 ,0x20 ,0x59 ,0x6f ,0x72 ,0x6b ,0x00 ,0x00  ,0x80 ,0x02 ,0x02 ,0x00 ,0x42 ,0x6c ,0x61 ,0x6e
	,0x6b ,0x20 ,0x53 ,0x70 ,0x61 ,0x63 ,0x65 ,0x00  ,0x00 ,0x00 ,0x80 ,0x03 ,0x03 ,0x00 ,0x53 ,0x74
	,0x79 ,0x6c ,0x65 ,0x00 ,0x4f ,0x75 ,0x74 ,0x20  ,0x4f ,0x66 ,0x00 ,0x00 ,0x80 ,0x04 ,0x04 ,0x06
	,0x20 ,0x54 ,0x68 ,0x65 ,0x20 ,0x57 ,0x6f ,0x6f  ,0x64 ,0x73 ,0x00 ,0x41 ,0x00 ,0x00 ,0x80 ,0x05
	,0x05 ,0x01 ,0x6c ,0x6c ,0x20 ,0x59 ,0x6f ,0x75  ,0x20 ,0x48 ,0x61 ,0x64 ,0x20 ,0x54 ,0x00 ,0x00
	,0x80 ,0x05 ,0x06 ,0x0f ,0x6f ,0x20 ,0x44 ,0x6f  ,0x20 ,0x57 ,0x61 ,0x73 ,0x20 ,0x53 ,0x74 ,0x61
	,0x00 ,0x00 ,0x80 ,0x05 ,0x07 ,0x0f ,0x79 ,0x00  ,0x53 ,0x68 ,0x61 ,0x6b ,0x65 ,0x20 ,0x49 ,0x74
	,0x20 ,0x4f ,0x00 ,0x00 ,0x80 ,0x06 ,0x08 ,0x0a  ,0x66 ,0x66 ,0x00 ,0x49 ,0x20 ,0x57 ,0x69 ,0x73
	,0x68 ,0x20 ,0x59 ,0x6f ,0x00 ,0x00 ,0x80 ,0x07  ,0x09 ,0x09 ,0x75 ,0x20 ,0x57 ,0x6f ,0x75 ,0x6c
	,0x64 ,0x00 ,0x42 ,0x61 ,0x64 ,0x20 ,0x00 ,0x00  ,0x80 ,0x08 ,0x0a ,0x04 ,0x42 ,0x6c ,0x6f ,0x6f
	,0x64 ,0x00 ,0x57 ,0x69 ,0x6c ,0x64 ,0x65 ,0x73  ,0x00 ,0x00 ,0x80 ,0x09 ,0x0b ,0x06 ,0x74 ,0x20
	,0x44 ,0x72 ,0x65 ,0x61 ,0x6d ,0x73 ,0x00 ,0x48  ,0x6f ,0x77 ,0x00 ,0x00 ,0x80 ,0x0a ,0x0c ,0x03
	,0x20 ,0x59 ,0x6f ,0x75 ,0x20 ,0x47 ,0x65 ,0x74  ,0x20 ,0x54 ,0x68 ,0x65 ,0x00 ,0x00 ,0x80 ,0x0a
	,0x0d ,0x0f ,0x20 ,0x47 ,0x69 ,0x72 ,0x6c ,0x00  ,0x54 ,0x68 ,0x69 ,0x73 ,0x20 ,0x4c ,0x00 ,0x00
	,0x80 ,0x0b ,0x0e ,0x06 ,0x6f ,0x76 ,0x65 ,0x00  ,0x49 ,0x20 ,0x4b ,0x6e ,0x6f ,0x77 ,0x20 ,0x50
	,0x00 ,0x00 ,0x80 ,0x0c ,0x0f ,0x08 ,0x6c ,0x61  ,0x63 ,0x65 ,0x73 ,0x00 ,0x43 ,0x6c ,0x65 ,0x61
	,0x6e ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x81 ,0x00  ,0x10 ,0x00 ,0x54 ,0x61 ,0x79 ,0x6c ,0x6f ,0x72
	,0x20 ,0x53 ,0x77 ,0x69 ,0x66 ,0x74 ,0x00 ,0x00  ,0x81 ,0x01 ,0x11 ,0x00 ,0x54 ,0x61 ,0x79 ,0x6c
	,0x6f ,0x72 ,0x20 ,0x53 ,0x77 ,0x69 ,0x66 ,0x74  ,0x00 ,0x00 ,0x81 ,0x02 ,0x12 ,0x00 ,0x54 ,0x61
	,0x79 ,0x6c ,0x6f ,0x72 ,0x20 ,0x53 ,0x77 ,0x69  ,0x66 ,0x74 ,0x00 ,0x00 ,0x81 ,0x03 ,0x13 ,0x00
	,0x54 ,0x61 ,0x79 ,0x6c ,0x6f ,0x72 ,0x20 ,0x53  ,0x77 ,0x69 ,0x66 ,0x74 ,0x00 ,0x00 ,0x81 ,0x04
	,0x14 ,0x00 ,0x54 ,0x61 ,0x79 ,0x6c ,0x6f ,0x72  ,0x20 ,0x53 ,0x77 ,0x69 ,0x66 ,0x74 ,0x00 ,0x00
	,0x81 ,0x05 ,0x15 ,0x00 ,0x54 ,0x61 ,0x79 ,0x6c  ,0x6f ,0x72 ,0x20 ,0x53 ,0x77 ,0x69 ,0x66 ,0x74
	,0x00 ,0x00 ,0x81 ,0x06 ,0x16 ,0x00 ,0x54 ,0x61  ,0x79 ,0x6c ,0x6f ,0x72 ,0x20 ,0x53 ,0x77 ,0x69
	,0x66 ,0x74 ,0x00 ,0x00 ,0x81 ,0x07 ,0x17 ,0x00  ,0x54 ,0x61 ,0x79 ,0x6c ,0x6f ,0x72 ,0x20 ,0x53
	,0x77 ,0x69 ,0x66 ,0x74 ,0x00 ,0x00 ,0x81 ,0x08  ,0x18 ,0x00 ,0x54 ,0x61 ,0x79 ,0x6c ,0x6f ,0x72
	,0x20 ,0x53 ,0x77 ,0x69 ,0x66 ,0x74 ,0x00 ,0x00  ,0x81 ,0x09 ,0x19 ,0x00 ,0x54 ,0x61 ,0x79 ,0x6c
	,0x6f ,0x72 ,0x20 ,0x53 ,0x77 ,0x69 ,0x66 ,0x74  ,0x00 ,0x00 ,0x81 ,0x0a ,0x1a ,0x00 ,0x54 ,0x61
	,0x79 ,0x6c ,0x6f ,0x72 ,0x20 ,0x53 ,0x77 ,0x69  ,0x66 ,0x74 ,0x00 ,0x00 ,0x81 ,0x0b ,0x1b ,0x00
	,0x54 ,0x61 ,0x79 ,0x6c ,0x6f ,0x72 ,0x20 ,0x53  ,0x77 ,0x69 ,0x66 ,0x74 ,0x00 ,0x00 ,0x81 ,0x0c
	,0x1c ,0x00 ,0x54 ,0x61 ,0x79 ,0x6c ,0x6f ,0x72  ,0x20 ,0x53 ,0x77 ,0x69 ,0x66 ,0x74 ,0x00 ,0x00
	,0x81 ,0x0d ,0x1d ,0x00 ,0x54 ,0x61 ,0x79 ,0x6c  ,0x6f ,0x72 ,0x20 ,0x53 ,0x77 ,0x69 ,0x66 ,0x74
	,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
	,0x00 ,0x00 ,0x00 ,0x00 ,0x8f ,0x00 ,0x1e ,0x00  ,0x01 ,0x01 ,0x0d ,0x03 ,0x11 ,0x10 ,0x00 ,0x00};

	LocalSPM::GetCDDAControl().TestsetCDText(ref_1989, 1012, 13);

	unsigned char ref_Jani[] = {0x02 ,0xe4 ,0x01 ,0x0c ,0x80 ,0x00 ,0x00 ,0x00  ,0x4a ,0x65 ,0x6e ,0x6e ,0x69 ,0x66 ,0x65 ,0x72
    ,0x20 ,0x4c ,0x6f ,0x70 ,0x00 ,0x00 ,0x80 ,0x00  ,0x01 ,0x0c ,0x65 ,0x7a ,0x20 ,0x20 ,0x20 ,0x52
    ,0x65 ,0x62 ,0x69 ,0x72 ,0x74 ,0x68 ,0x00 ,0x00  ,0x80 ,0x01 ,0x02 ,0x00 ,0x47 ,0x65 ,0x74 ,0x20
    ,0x52 ,0x69 ,0x67 ,0x68 ,0x74 ,0x20 ,0x28 ,0x41  ,0x00 ,0x00 ,0x80 ,0x01 ,0x03 ,0x0c ,0x6c ,0x62
    ,0x75 ,0x6d ,0x20 ,0x56 ,0x65 ,0x72 ,0x73 ,0x69  ,0x6f ,0x6e ,0x00 ,0x00 ,0x80 ,0x01 ,0x04 ,0x0c
    ,0x29 ,0x20 ,0x00 ,0x53 ,0x74 ,0x65 ,0x70 ,0x20  ,0x49 ,0x6e ,0x74 ,0x6f ,0x00 ,0x00 ,0x80 ,0x02
    ,0x05 ,0x09 ,0x20 ,0x4d ,0x79 ,0x20 ,0x57 ,0x6f  ,0x72 ,0x6c ,0x64 ,0x20 ,0x28 ,0x41 ,0x00 ,0x00
    ,0x80 ,0x02 ,0x06 ,0x0c ,0x6c ,0x62 ,0x75 ,0x6d  ,0x20 ,0x56 ,0x65 ,0x72 ,0x73 ,0x69 ,0x6f ,0x6e
    ,0x00 ,0x00 ,0x80 ,0x02 ,0x07 ,0x0c ,0x29 ,0x20  ,0x00 ,0x48 ,0x6f ,0x6c ,0x64 ,0x20 ,0x59 ,0x6f
    ,0x75 ,0x20 ,0x00 ,0x00 ,0x80 ,0x03 ,0x08 ,0x09  ,0x44 ,0x6f ,0x77 ,0x6e ,0x20 ,0x28 ,0x66 ,0x65
    ,0x61 ,0x74 ,0x75 ,0x72 ,0x00 ,0x00 ,0x80 ,0x03  ,0x09 ,0x0c ,0x69 ,0x6e ,0x67 ,0x20 ,0x46 ,0x61
    ,0x74 ,0x20 ,0x4a ,0x6f ,0x65 ,0x29 ,0x00 ,0x00  ,0x80 ,0x03 ,0x0a ,0x0c ,0x20 ,0x28 ,0x41 ,0x6c
    ,0x62 ,0x75 ,0x6d ,0x20 ,0x56 ,0x65 ,0x72 ,0x73  ,0x00 ,0x00 ,0x80 ,0x03 ,0x0b ,0x0c ,0x69 ,0x6f
    ,0x6e ,0x29 ,0x20 ,0x00 ,0x57 ,0x68 ,0x61 ,0x74  ,0x65 ,0x76 ,0x00 ,0x00 ,0x80 ,0x04 ,0x0c ,0x06
    ,0x65 ,0x72 ,0x20 ,0x59 ,0x6f ,0x75 ,0x20 ,0x57  ,0x61 ,0x6e ,0x6e ,0x61 ,0x00 ,0x00 ,0x80 ,0x04
    ,0x0d ,0x0c ,0x20 ,0x44 ,0x6f ,0x20 ,0x28 ,0x41  ,0x6c ,0x62 ,0x75 ,0x6d ,0x20 ,0x56 ,0x00 ,0x00
    ,0x80 ,0x04 ,0x0e ,0x0c ,0x65 ,0x72 ,0x73 ,0x69  ,0x6f ,0x6e ,0x29 ,0x20 ,0x00 ,0x43 ,0x68 ,0x65
    ,0x00 ,0x00 ,0x80 ,0x05 ,0x0f ,0x03 ,0x72 ,0x72  ,0x79 ,0x20 ,0x50 ,0x69 ,0x65 ,0x20 ,0x28 ,0x41
    ,0x6c ,0x62 ,0x00 ,0x00 ,0x80 ,0x05 ,0x10 ,0x0c  ,0x75 ,0x6d ,0x20 ,0x56 ,0x65 ,0x72 ,0x73 ,0x69
    ,0x6f ,0x6e ,0x29 ,0x00 ,0x00 ,0x00 ,0x80 ,0x06  ,0x11 ,0x00 ,0x49 ,0x20 ,0x47 ,0x6f ,0x74 ,0x20
    ,0x55 ,0x20 ,0x28 ,0x41 ,0x6c ,0x62 ,0x00 ,0x00  ,0x80 ,0x06 ,0x12 ,0x0c ,0x75 ,0x6d ,0x20 ,0x56
    ,0x65 ,0x72 ,0x73 ,0x69 ,0x6f ,0x6e ,0x29 ,0x20  ,0x00 ,0x00 ,0x80 ,0x07 ,0x13 ,0x00 ,0x53 ,0x74
    ,0x69 ,0x6c ,0x6c ,0x20 ,0x41 ,0x72 ,0x6f ,0x75  ,0x6e ,0x64 ,0x00 ,0x00 ,0x80 ,0x07 ,0x14 ,0x0c
    ,0x20 ,0x28 ,0x41 ,0x6c ,0x62 ,0x75 ,0x6d ,0x20  ,0x56 ,0x65 ,0x72 ,0x73 ,0x00 ,0x00 ,0x80 ,0x07
    ,0x15 ,0x0c ,0x69 ,0x6f ,0x6e ,0x29 ,0x00 ,0x52  ,0x79 ,0x64 ,0x65 ,0x20 ,0x4f ,0x72 ,0x00 ,0x00
    ,0x80 ,0x08 ,0x16 ,0x07 ,0x20 ,0x44 ,0x69 ,0x65  ,0x20 ,0x28 ,0x41 ,0x6c ,0x62 ,0x75 ,0x6d ,0x20
    ,0x00 ,0x00 ,0x80 ,0x08 ,0x17 ,0x0c ,0x56 ,0x65  ,0x72 ,0x73 ,0x69 ,0x6f ,0x6e ,0x29 ,0x00 ,0x49
    ,0x2c ,0x20 ,0x00 ,0x00 ,0x80 ,0x09 ,0x18 ,0x03  ,0x4c ,0x6f ,0x76 ,0x65 ,0x20 ,0x28 ,0x41 ,0x6c
    ,0x62 ,0x75 ,0x6d ,0x20 ,0x00 ,0x00 ,0x80 ,0x09  ,0x19 ,0x0c ,0x56 ,0x65 ,0x72 ,0x73 ,0x69 ,0x6f
    ,0x6e ,0x29 ,0x00 ,0x48 ,0x65 ,0x27 ,0x00 ,0x00  ,0x80 ,0x0a ,0x1a ,0x03 ,0x6c ,0x6c ,0x20 ,0x42
    ,0x65 ,0x20 ,0x42 ,0x61 ,0x63 ,0x6b ,0x20 ,0x28  ,0x00 ,0x00 ,0x80 ,0x0a ,0x1b ,0x0c ,0x41 ,0x6c
    ,0x62 ,0x75 ,0x6d ,0x20 ,0x56 ,0x65 ,0x72 ,0x73  ,0x69 ,0x6f ,0x00 ,0x00 ,0x80 ,0x0a ,0x1c ,0x0c
    ,0x6e ,0x29 ,0x00 ,0x28 ,0x43 ,0x61 ,0x6e ,0x27  ,0x74 ,0x20 ,0x42 ,0x65 ,0x00 ,0x00 ,0x80 ,0x0b
    ,0x1d ,0x09 ,0x6c ,0x69 ,0x65 ,0x76 ,0x65 ,0x29  ,0x20 ,0x54 ,0x68 ,0x69 ,0x73 ,0x20 ,0x00 ,0x00
    ,0x80 ,0x0b ,0x1e ,0x0c ,0x49 ,0x73 ,0x20 ,0x4d  ,0x65 ,0x20 ,0x28 ,0x41 ,0x6c ,0x62 ,0x75 ,0x6d
    ,0x00 ,0x00 ,0x80 ,0x0b ,0x1f ,0x0c ,0x20 ,0x56  ,0x65 ,0x72 ,0x73 ,0x69 ,0x6f ,0x6e ,0x29 ,0x20
    ,0x00 ,0x47 ,0x00 ,0x00 ,0x80 ,0x0c ,0x20 ,0x01  ,0x65 ,0x74 ,0x20 ,0x52 ,0x69 ,0x67 ,0x68 ,0x74
    ,0x20 ,0x28 ,0x66 ,0x65 ,0x00 ,0x00 ,0x80 ,0x0c  ,0x21 ,0x0c ,0x61 ,0x74 ,0x75 ,0x72 ,0x69 ,0x6e
    ,0x67 ,0x20 ,0x46 ,0x61 ,0x62 ,0x6f ,0x00 ,0x00  ,0x80 ,0x0c ,0x22 ,0x0c ,0x6c ,0x6f ,0x75 ,0x73
    ,0x29 ,0x20 ,0x28 ,0x41 ,0x6c ,0x62 ,0x75 ,0x6d  ,0x00 ,0x00 ,0x80 ,0x0c ,0x23 ,0x0c ,0x20 ,0x56
    ,0x65 ,0x72 ,0x73 ,0x69 ,0x6f ,0x6e ,0x29 ,0x20  ,0x00 ,0x00 ,0x00 ,0x00 ,0x81 ,0x00 ,0x24 ,0x00
    ,0x4a ,0x65 ,0x6e ,0x6e ,0x69 ,0x66 ,0x65 ,0x72  ,0x20 ,0x4c ,0x6f ,0x70 ,0x00 ,0x00 ,0x81 ,0x00
    ,0x25 ,0x0c ,0x65 ,0x7a ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x8f ,0x00 ,0x26 ,0x00 ,0x01 ,0x01 ,0x0c ,0x03  ,0x24 ,0x02 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x00 ,0x00 ,0x8f ,0x01 ,0x27 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x03 ,0x28 ,0x00
    ,0x00 ,0x00 ,0x00 ,0x00 ,0x8f ,0x02 ,0x28 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00};
    LocalSPM::GetCDDAControl().TestsetCDText(ref_Jani, 1012, 12);

    unsigned char ref_abc[] ={0x49 ,0x4a ,0x6b ,0x6c ,0x80 ,0x00  ,0x01 ,0x0c ,0x6d ,0x4e ,0x4f ,0x70 ,0x00 ,0x61
    ,0x62 ,0x43 ,0x64 ,0x00 ,0x41 ,0x62 ,0x00 ,0x00  ,0x80 ,0x02 ,0x02 ,0x02 ,0x63 ,0x64 ,0x65 ,0x66
    ,0x47 ,0x68 ,0x00 ,0x61 ,0x42 ,0x63 ,0x64 ,0x45  ,0x00 ,0x00 ,0x80 ,0x03 ,0x03 ,0x05 ,0x66 ,0x67
    ,0x48 ,0x49 ,0x6a ,0x6b ,0x6c ,0x6d ,0x6e ,0x4f  ,0x50 ,0x00 ,0x00 ,0x00 ,0x80 ,0x04 ,0x04 ,0x00
    ,0x61 ,0x62 ,0x63 ,0x44 ,0x65 ,0x46 ,0x47 ,0x68  ,0x69 ,0x6a ,0x4b ,0x6c ,0x00 ,0x00 ,0x80 ,0x04
    ,0x05 ,0x0c ,0x4d ,0x4e ,0x6f ,0x70 ,0x51 ,0x72  ,0x73 ,0x54 ,0x75 ,0x76 ,0x57 ,0x78 ,0x00 ,0x00
    ,0x80 ,0x04 ,0x06 ,0x0c ,0x79 ,0x5a ,0x73 ,0x58  ,0x61 ,0x56 ,0x69 ,0x48 ,0x00 ,0x61 ,0x62 ,0x43
    ,0x00 ,0x00 ,0x80 ,0x05 ,0x07 ,0x03 ,0x64 ,0x00  ,0x61 ,0x62 ,0x63 ,0x44 ,0x65 ,0x46 ,0x47 ,0x68
    ,0x69 ,0x6a ,0x00 ,0x00 ,0x80 ,0x06 ,0x08 ,0x0a  ,0x4b ,0x6c ,0x4d ,0x4e ,0x6f ,0x70 ,0x51 ,0x72
    ,0x73 ,0x54 ,0x75 ,0x76 ,0x00 ,0x00 ,0x80 ,0x06  ,0x09 ,0x0c ,0x57 ,0x78 ,0x79 ,0x5a ,0x73 ,0x58
    ,0x61 ,0x56 ,0x69 ,0x48 ,0x00 ,0x41 ,0x00 ,0x00  ,0x80 ,0x07 ,0x0a ,0x01 ,0x62 ,0x63 ,0x64 ,0x65
    ,0x66 ,0x47 ,0x68 ,0x00 ,0x61 ,0x42 ,0x63 ,0x64  ,0x00 ,0x00 ,0x80 ,0x08 ,0x0b ,0x04 ,0x45 ,0x66
    ,0x67 ,0x48 ,0x49 ,0x6a ,0x6b ,0x6c ,0x6d ,0x6e  ,0x4f ,0x50 ,0x00 ,0x00 ,0x80 ,0x09 ,0x0c ,0x00
    ,0x61 ,0x62 ,0x43 ,0x64 ,0x00 ,0x41 ,0x62 ,0x63  ,0x64 ,0x65 ,0x66 ,0x47 ,0x00 ,0x00 ,0x80 ,0x0a
    ,0x0d ,0x07 ,0x68 ,0x00 ,0x61 ,0x42 ,0x63 ,0x64  ,0x45 ,0x66 ,0x67 ,0x48 ,0x49 ,0x6a ,0x00 ,0x00
    ,0x80 ,0x0b ,0x0e ,0x0a ,0x6b ,0x6c ,0x6d ,0x6e  ,0x4f ,0x50 ,0x00 ,0x61 ,0x62 ,0x63 ,0x44 ,0x65
    ,0x00 ,0x00 ,0x80 ,0x0c ,0x0f ,0x05 ,0x46 ,0x47  ,0x68 ,0x69 ,0x6a ,0x4b ,0x6c ,0x4d ,0x4e ,0x6f
    ,0x70 ,0x51 ,0x00 ,0x00 ,0x80 ,0x0c ,0x10 ,0x0c  ,0x72 ,0x73 ,0x54 ,0x75 ,0x76 ,0x57 ,0x78 ,0x79
    ,0x5a ,0x73 ,0x58 ,0x61 ,0x00 ,0x00 ,0x80 ,0x0c  ,0x11 ,0x0c ,0x56 ,0x69 ,0x48 ,0x00 ,0x00 ,0x00
    ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x81 ,0x00 ,0x12 ,0x00 ,0x61 ,0x62 ,0x43 ,0x64
    ,0x65 ,0x46 ,0x67 ,0x68 ,0x49 ,0x4a ,0x6b ,0x6c  ,0x00 ,0x00 ,0x81 ,0x00 ,0x13 ,0x0c ,0x6d ,0x4e
    ,0x4f ,0x70 ,0x00 ,0x61 ,0x62 ,0x43 ,0x64 ,0x00  ,0x41 ,0x62 ,0x00 ,0x00 ,0x81 ,0x02 ,0x14 ,0x02
    ,0x63 ,0x64 ,0x65 ,0x66 ,0x47 ,0x68 ,0x00 ,0x61  ,0x42 ,0x63 ,0x64 ,0x45 ,0x00 ,0x00 ,0x81 ,0x03
    ,0x15 ,0x05 ,0x66 ,0x67 ,0x48 ,0x49 ,0x6a ,0x6b  ,0x6c ,0x6d ,0x6e ,0x4f ,0x50 ,0x00 ,0x00 ,0x00
    ,0x81 ,0x04 ,0x16 ,0x00 ,0x61 ,0x62 ,0x63 ,0x44  ,0x65 ,0x46 ,0x47 ,0x68 ,0x69 ,0x6a ,0x4b ,0x6c
    ,0x00 ,0x00 ,0x81 ,0x04 ,0x17 ,0x0c ,0x4d ,0x4e  ,0x6f ,0x70 ,0x51 ,0x72 ,0x73 ,0x54 ,0x75 ,0x76
    ,0x57 ,0x78 ,0x00 ,0x00 ,0x81 ,0x04 ,0x18 ,0x0c  ,0x79 ,0x5a ,0x73 ,0x58 ,0x61 ,0x56 ,0x69 ,0x48
    ,0x00 ,0x61 ,0x62 ,0x63 ,0x00 ,0x00 ,0x81 ,0x05  ,0x19 ,0x03 ,0x44 ,0x65 ,0x46 ,0x47 ,0x68 ,0x69
    ,0x6a ,0x4b ,0x6c ,0x4d ,0x4e ,0x6f ,0x00 ,0x00  ,0x81 ,0x05 ,0x1a ,0x0c ,0x70 ,0x51 ,0x72 ,0x73
    ,0x54 ,0x75 ,0x76 ,0x57 ,0x78 ,0x79 ,0x5a ,0x73  ,0x00 ,0x00 ,0x81 ,0x05 ,0x1b ,0x0c ,0x58 ,0x61
    ,0x56 ,0x69 ,0x48 ,0x00 ,0x61 ,0x62 ,0x43 ,0x64  ,0x00 ,0x61 ,0x00 ,0x00 ,0x81 ,0x07 ,0x1c ,0x01
    ,0x42 ,0x63 ,0x64 ,0x45 ,0x66 ,0x67 ,0x48 ,0x49  ,0x6a ,0x6b ,0x6c ,0x6d ,0x00 ,0x00 ,0x81 ,0x07
    ,0x1d ,0x0c ,0x6e ,0x4f ,0x50 ,0x09 ,0x00 ,0x41  ,0x62 ,0x63 ,0x64 ,0x65 ,0x66 ,0x47 ,0x00 ,0x00
    ,0x81 ,0x08 ,0x1e ,0x07 ,0x68 ,0x00 ,0x61 ,0x62  ,0x43 ,0x64 ,0x00 ,0x41 ,0x62 ,0x63 ,0x64 ,0x65
    ,0x00 ,0x00 ,0x81 ,0x0e ,0x1f ,0x05 ,0x66 ,0x47  ,0x68 ,0x00 ,0x61 ,0x42 ,0x63 ,0x64 ,0x45 ,0x66
    ,0x67 ,0x48 ,0x00 ,0x00 ,0x81 ,0x0f ,0x20 ,0x08  ,0x49 ,0x6a ,0x6b ,0x6c ,0x6d ,0x6e ,0x4f ,0x50
    ,0x00 ,0x61 ,0x62 ,0x63 ,0x00 ,0x00 ,0x81 ,0x10  ,0x21 ,0x03 ,0x44 ,0x65 ,0x46 ,0x47 ,0x68 ,0x69
    ,0x6a ,0x4b ,0x6c ,0x4d ,0x4e ,0x6f ,0x00 ,0x00  ,0x81 ,0x10 ,0x22 ,0x0c ,0x70 ,0x51 ,0x72 ,0x73
    ,0x54 ,0x75 ,0x76 ,0x57 ,0x78 ,0x79 ,0x5a ,0x73  ,0x00 ,0x00 ,0x81 ,0x10 ,0x23 ,0x0c ,0x58 ,0x61
    ,0x56 ,0x69 ,0x48 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x8f ,0x00 ,0x24 ,0x00
    ,0x01 ,0x01 ,0x10 ,0x03 ,0x12 ,0x12 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x8f ,0x01
    ,0x25 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x03 ,0x26 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x8f ,0x02 ,0x26 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
    ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00  ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00};
    LocalSPM::GetCDDAControl().TestsetCDText(ref_abc, 1012, 16);
}
#endif
