#ifndef _BTCONTROLTEST_H_
#define _BTCONTROLTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TypeDefinitions.h"
#include "TimeTrace.h"
#include "IpcClient.h"

//extern tBoolean IsGetFolderItemCalled ;
//extern tBoolean IsChangePathCalled ;
//extern tBoolean IsGetMediaPlayerItemCalled;
class BTControlTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( BTControlTest );
    //CPPUNIT_TEST( DoCalculateItemCount );
    //CPPUNIT_TEST( InitIPC );
#if defined(TARGET_BUILD) && !defined(TARGET_BUILD_GEN3)
    //TODO:What Tests to be added Only on target build need to be Decided
    //    CPPUNIT_TEST();
#endif

#if 0
    //Playback Related
    CPPUNIT_TEST(InitializeDevice);
    //CPPUNIT_TEST( SwitchObserver );
    CPPUNIT_TEST( AllocateAudioInput );
    //CPPUNIT_TEST( StartStreaming );
    CPPUNIT_TEST( StartPlay );
    CPPUNIT_TEST( SetPlaybackMode);
    CPPUNIT_TEST( SetRepeatMode);
    //CPPUNIT_TEST( PlaybackAction );
    CPPUNIT_TEST( StopAudioInput );
    //CPPUNIT_TEST( InitializeDevice );
    CPPUNIT_TEST( GetFolderItem);
    CPPUNIT_TEST( ChangePath );
    CPPUNIT_TEST( BTCreateMediaPlayerFileList );
    CPPUNIT_TEST( BTRequestMediaPlayerFileListSlice );
#endif
    CPPUNIT_TEST_SUITE_END();

public:
    BTControlTest();

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

#if defined(TARGET_BUILD) && !defined(TARGET_BUILD_GEN3)
    //TODO:What functions to be tested Only on target build need to be Decided
    //Func Names
#endif

    /*test cases*/
    void InitIPC();
    void InitializeDevice();
    void InitDeviceConnection();
    void DisconnectDevice();
    void AllocateAudioInput();
    void DeAllocateAudioInput();
    void SwitchObserver();
    void StartStreaming();
    void StartPlay();
    void PlaybackAction();
    void GetFolderItem();
    void ChangePath();
    void StopAudioInput();
    void SetPlaybackMode();
    void SetRepeatMode();
    void BTCreateMediaPlayerFileList();
    void BTRequestMediaPlayerFileListSlice();
    void DoCalculateItemCount();

    map<string,tNumOfItems> dummyPathVsItemCount;
private:
    TimeTrace ticks;        /**< time object to trace the time taken by testcases */

};
#endif  // _BTCONTROLTEST_H_
