#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/BTControlTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

//TODO:Target Build to be Decided
#ifdef TARGET_BUILD
#if defined(TARGET_BUILD) && !defined(TARGET_BUILD_GEN3)
#endif
#endif

#include "BTControl.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "RequestResponseSM.h"
#include <netinet/in.h>
#include <list>
#include <string>
#include "VarTrace.h"
using namespace std;

static tListID mBTFileListID;

// Location of Byte Representing the First Byte of Item Name
#define START_OF_FOLDER_NAME 16
#define START_OF_MEDIAELEMENT_NAME 15

//Length
#define SIZE_OF_ITEM_TYPE_CUM_LENGTH 3
#define SIZE_OF_ITEM_LENGTH 2
#define UID_CUM_SEPERATOR_LENGTH 15

#define SEPERATOR "/"

extern bool BTGetLevelInfo(string path,tNumOfItems &TotNumOfItems,tNumOfItems &ElementsInCache);

#include "BTControlTest.h"

class BTTestSM: public RequestResponseSM
{

    int HandleInitRequest()
    {
    	return 0;
    }

    int HandleSuccessRequest(const char *allParameters)
    {

        int ByteCount = 0;
    	/* the request/expect state machine has a general SUCCESS_REQUEST message which is not
        // specialized to a service state machine be called, so all kind of parameters must
        // be processed by hand in this method. */
        //ETG_TRACE_USR1(("BTTestSM::HandleSuccessRequest allParameters:%s", allParameters));
    	if(allParameters != NULL)
    	{
    		ByteCount = strlen_r(allParameters);
    		ParamString = new char[ByteCount+1];
    		strcpy(ParamString,allParameters);
    		return true;
    	}
    	else
    	{
    		return false;
    	}
    }

public:

    	char *ParamString ;

    	BTTestSM()
    	{
    		ParamString = NULL;
    	}
};

BTControlTest::BTControlTest() {

}

void BTControlTest::setUp() {
    ticks.begin();
}

void BTControlTest::tearDown() {
    ticks.elapsed();
}

/**********************************************************************
 * Test cases
 *********************************************************************/

void BTControlTest::InitIPC()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    tAudioOutputDevice audioOutputDevice;
    strncpy_r(audioOutputDevice, "AdevInfo2Out", sizeof(audioOutputDevice));

    /* Call StartAllocateAudioOutput */
    ret = LocalSPM::GetDeviceDispatcher().StartAllocateAudioOutput(IN audioOutputDevice);

    sleep(2); //Wait a little bit until IPC is initialized

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void BTControlTest::InitializeDevice()
{

	ENTRY
    ETG_TRACE_USR1((" *** Start BTControlTest::InitializeDevice***"));


    tResult ret = MP_NO_ERROR;
	tDeviceID deviceID = 2;
    tMountPoint mountPoint = "dev_aa_bb_cc_dd_ee_ff";
    BTTestSM objMyRRSM;


    //Expected DeviceName,ID and Connection State

	tDeviceName DeviceNameExpected = "MyBTDevice";
	tDeviceID DeviceIDExpected = 2;
	tConnectionState ConnectionStateExpected = CS_CONNECTED;

	tDeviceName DeviceNameReceived = {0};
	tDeviceID DeviceIDReceived = 0;
	tConnectionState ConnectionStateReceived = CS_UNSUPPORTED ;

    /* Send INIT_DEVICE_CONNECTION message to BTControlSM */
    char messageString[64];
    strncpy_r(messageString, "BTControlSM::INIT_DEVICE_CONNECTION",
            sizeof(messageString));

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    tDeviceInfo deviceInfo;
    InitDeviceInfo(deviceInfo);
    deviceInfo.deviceID = deviceID;
    strncpy_r(deviceInfo.mountPoint, mountPoint, sizeof(deviceInfo.mountPoint));
    tDeviceInfoString deviceInfoString;
    DataProvider::MarshalDeviceInfo(deviceInfoString, deviceInfo);

    ret = LocalSPM::GetBTControl().ParameterINIT_DEVICE_CONNECTION(
            OUT parameterString, IN size, IN deviceInfoString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    CPPUNIT_ASSERT(objMyRRSM.ParamString != NULL);

    objMyRRSM.UnMarshal(objMyRRSM.ParamString,tDeviceName_format tDeviceID_format tConnectionState_format,&DeviceNameReceived,&DeviceIDReceived,&ConnectionStateReceived);

    CPPUNIT_ASSERT(strcmp(DeviceNameReceived,DeviceNameExpected) == 0);
    CPPUNIT_ASSERT(DeviceIDExpected == DeviceIDReceived);
    CPPUNIT_ASSERT(ConnectionStateExpected == ConnectionStateReceived);
}
void BTControlTest::DisconnectDevice()
{
	#if 0
	ENTRY;
    ETG_TRACE_USR1((" *** Start BTControlTest::DisconnectDevice***"));

    tResult ret = MP_NO_ERROR;
    tMountPoint mountPoint = BTControl_HID_DEFAULT;

    /* Call Disconnect BT */
    ret = LocalSPM::GetBTControl().Disconnect(mountPoint);
    if(ret == MP_NO_ERROR)
    {
        //give some time for iap detach callback processing
        sleep(1);
    }
    // test result
    CPPUNIT_ASSERT(ret == MP_NO_ERROR);
	#endif
}

void BTControlTest::AllocateAudioInput()
{
    ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    BTTestSM objMyRRSM;

	char messageString[64];
	tAllParameters parameterString;
	size_t size = sizeof(parameterString);

	tMountPoint MountPoint = "";


	/* expected PipeName,CodecType,BitRate)*/
	tPipeName expectedPipeName = (unsigned char*)const_cast<char*>("/dev/btaac");
	tCodecType expectedCodecType = CODEC_TYPE_MPEG24AAC;
	tBitRate expectedBitRate = 1500;


    /* Send ALLOCATE_AUDIO_INPUT message to BTControlSM */
    strncpy_r(messageString, "BTControlSM::ALLOCATE_AUDIO_INPUT", sizeof(messageString));

    tDeviceID deviceID;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, MountPoint);
    //CPPUNIT_ASSERT(res == 0);

    ret = LocalSPM::GetBTControl().ParameterALLOCATE_AUDIO_INPUT(OUT parameterString,
            													 IN size,
            													 IN deviceID,
            													 IN MountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);

	tPipeName PipeName = NULL;
	tCodecType CodecType = CODEC_TYPE_INVALID;
	tBitRate BitRate = 0;
	tErrorMessage ErrorMessage = NULL;

	CPPUNIT_ASSERT(objMyRRSM.ParamString != NULL);

	objMyRRSM.UnMarshal(objMyRRSM.ParamString,tPipeName_format tCodecType_format tBitRate_format tErrorMessage_format  ,&PipeName ,&CodecType ,&BitRate ,&ErrorMessage );

	ETG_TRACE_USR4(("PipeName is %s",PipeName));
	ETG_TRACE_USR4(("CodecType is %d",CodecType));
	ETG_TRACE_USR4(("BitRate is %d",BitRate));
	ETG_TRACE_USR4(("ErrorMessage is %s",ErrorMessage));

	CPPUNIT_ASSERT(strcmp((char *)PipeName,(char *)expectedPipeName) == 0);
	CPPUNIT_ASSERT(expectedCodecType == CodecType);
	CPPUNIT_ASSERT(expectedBitRate == BitRate);

	delete[] PipeName;
	if(ErrorMessage != NULL)
	{
		delete[] ErrorMessage;
		ret = false;
	}
	else
	{
		ret = true;
	}
	delete[] objMyRRSM.ParamString;
    // test result
    CPPUNIT_ASSERT(ret);
}
void BTControlTest::SwitchObserver()
{
	ENTRY_TEST

    tResult ret = MP_NO_ERROR;

    BTTestSM objMyRRSM;

    /* Send SWITCH_OBSERVER message to BTControlSM */
    char messageString[64];
    strncpy_r(messageString, "BTControlSM::SWITCH_OBSERVER", sizeof(messageString));

    ret = objMyRRSM.DoEventAnswer(IN messageString, (char *)NULL, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void BTControlTest::StartStreaming()
{

	ENTRY_TEST

	tResult ret = MP_NO_ERROR;
	BTTestSM objMyRRSM;

    /* Send START_STREAMING message to BTControlSM */
    char messageString[256];
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    tMountPoint mountPoint = "";
    strncpy_r(messageString, "BTControlSM::START_STREAMING",sizeof(messageString));

    tDeviceID deviceID;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, mountPoint);
    //CPPUNIT_ASSERT(res == 0);

    ret = LocalSPM::GetBTControl().ParameterSTART_STREAMING(OUT parameterString,
    														IN size,
    														IN deviceID,
    														IN mountPoint);

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}
void BTControlTest::StartPlay()
{
	ENTRY_TEST

	tResult ret = MP_NO_ERROR;

	BTTestSM objMyRRSM;

	/* Send START_PLAY message to BTControlSM */
	char messageString[256];
	tAllParameters parameterString;
	size_t size = sizeof(parameterString);


	//Varaibles to prepare ParameterString
	tDeviceType deviceType = DTY_BLUETOOTH;
	tDeviceID deviceID = 1;
	tURL URL = "";
	tMountPoint mountPoint = "";
	tUUID uuid = "";
	tPEHandle handle = 1;
	tPlaytime position = 0;

	/*expected Metadata */

	tMetadata expectedTitle = "Innum Konjam Neram";
	tMetadata expectedArtist = "Vijay Prakash,Swetha Menon";
	tMetadata expectedAlbum = "Mariyaan";
	tMetadata expectedGenre = "Romance";


	 strncpy_r(messageString, "BTControlSM::PLAY",sizeof(messageString));

	ret = LocalSPM::GetBTControl().ParameterPLAY(OUT parameterString,
																IN size,
	    														IN deviceType ,
	    														IN deviceID,
	    														IN URL,
	    														IN mountPoint,
	    														IN uuid,
	    														IN handle,
	    														IN position,TRUE);

	 CPPUNIT_ASSERT(MP_NO_ERROR == ret);

	 ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);

		tPEPlaybackState status = PE_PBS_LOADINGSTATE;
		tMetadata Title = "";
		tMetadata Artist = "";
		tMetadata Album = "";
		tMetadata Genre = "";

		CPPUNIT_ASSERT(objMyRRSM.ParamString != NULL);

		objMyRRSM.UnMarshal(objMyRRSM.ParamString, tPEPlaybackState_format tMetadata_format tMetadata_format tMetadata_format tMetadata_format  ,&status ,Title ,Artist ,Album ,Genre );

		ETG_TRACE_USR1(("The Current Playback State is %d",status));
		ETG_TRACE_USR1(("Title is %s",Title));
		ETG_TRACE_USR1(("Artist is %s",Artist));
		ETG_TRACE_USR1(("Album is %s",Album));
		ETG_TRACE_USR1(("Genre is %s",Genre));

		CPPUNIT_ASSERT(status != PE_PBS_ERRORSTATE);
		CPPUNIT_ASSERT(strcmp(Title,expectedTitle) == 0);
		CPPUNIT_ASSERT(strcmp(Artist,expectedArtist) == 0);
		CPPUNIT_ASSERT(strcmp(Album,expectedAlbum) == 0);
		CPPUNIT_ASSERT(strcmp(Genre,expectedGenre) == 0);

		ret = true;

		delete[] objMyRRSM.ParamString;

	    // test result
	    CPPUNIT_ASSERT(ret);
}
void BTControlTest::PlaybackAction()
{

	ENTRY_TEST



}
void BTControlTest::GetFolderItem()
{
    ENTRY_TEST

		BTTestSM objMyRRSM;

	    tResult ret = MP_NO_ERROR;

	    char messageString[64];
	    tAllParameters parameterString;
	    size_t size = sizeof(parameterString);

	    tScope Scope = SCOPE_MP_VFS ;
	    tStartItem StartItem = (tStartItem)0;
	    tEndItem EndItem = (tEndItem)7;

		vector<char *> expected_Name_UID_Type;

	    /* set the expected Name_UID_Type */
		expected_Name_UID_Type.push_back(const_cast<char *>("ALBUMS/0,0,0,0,0,0,0,1/0"));
		expected_Name_UID_Type.push_back(const_cast<char *>("ARTISTS/0,0,0,0,0,0,0,2/0"));
		expected_Name_UID_Type.push_back(const_cast<char *>("PLAYLISTS/0,0,0,0,0,0,0,3/0"));
		expected_Name_UID_Type.push_back(const_cast<char *>("SONGS/0,0,0,0,0,0,0,4/0"));
		expected_Name_UID_Type.push_back(const_cast<char *>("COMPILATIONS/0,0,0,0,0,0,0,5/0"));
		expected_Name_UID_Type.push_back(const_cast<char *>("COMPOSERS/0,0,0,0,0,0,0,6/0"));
		expected_Name_UID_Type.push_back(const_cast<char *>("GENRES/0,0,0,0,0,0,0,7/0"));
		expected_Name_UID_Type.push_back(const_cast<char *>("PODCASTS/0,0,0,0,0,0,0,8/0"));
	    /* Send AVP_GET_FOLDER_ITEM message to BTControlSM */
        strncpy_r(messageString, "BTControlSM::AVP_GET_FOLDER_ITEM",sizeof(messageString));

       ret = LocalSPM::GetBTControl().ParameterAVP_GET_FOLDER_ITEM(
    		   	   	   	   	   	   	   	   	   	   	   OUT parameterString,
    		   	   	   	   	   	   	   	   	   	   	   IN size,
    		   	   	   	   	   	   	   	   	   	   	   IN Scope,
    		   	   	   	   	   	   	   	   	   	   	   IN StartItem,
    		   	   	   	   	   	   	   	   	   	   	   IN EndItem);
       CPPUNIT_ASSERT(MP_NO_ERROR == ret);

	   ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);

	   ETG_TRACE_USR1(("AttributeArray deleted"));

		unsigned int iter;
		tBTMethodRequestStatus Status = REQ_NOT_OK ;
		tScope Scope_Ret = SCOPE_MP_VFS;
		tNetworkOrder NetworkOrder = false;
		tByteArray ByteArray = NULL;
		tArrayLength ArrayLength = 0;
		tErrorMessage ErrorMessage = NULL;

		CPPUNIT_ASSERT(objMyRRSM.ParamString != NULL);

		objMyRRSM.UnMarshal(objMyRRSM.ParamString, tBTMethodRequestStatus_format tScope_format tNetworkOrder_format tByteArray_format tArrayLength_format tErrorMessage_format  ,&Status ,&Scope_Ret ,&NetworkOrder ,&ByteArray ,&ArrayLength ,&ErrorMessage );

		CPPUNIT_ASSERT(REQ_OK == Status);

		tByteArray ByteArray_Address = ByteArray;
		tByteArray ByteArray_print = ByteArray;

		ETG_TRACE_USR1(("MethodRequestStatus is %d",Status));
		ETG_TRACE_USR1(("Scope is %d",Scope));
		ETG_TRACE_USR1(("NetworkOrder is %d",NetworkOrder));
		ETG_TRACE_USR1(("ArrayLength is %d",ArrayLength));
		ETG_TRACE_USR1(("ErrorMessage is %s",ErrorMessage));
		for(iter=0;iter<ArrayLength;iter++)
		{
			ETG_TRACE_USR1(("ByteArray_print[%d] : %d\t",iter,*ByteArray_print));
			ByteArray_print++;
		}

		//Parameters to Parse the ByteArray Received
		struct FolderItem_Item_info *l_spcFolderData = NULL;
		struct MediaElement_Item_info *l_spcMediaElementData = NULL;

		char UID_arr[UID_CUM_SEPERATOR_LENGTH]={0};
		char Item_Type=0;
		int Item_Name_Length=0;
		char* ItemName;

		//Params needed to create a complete String
		string Type="";
		string Name="";
		string UID="";
		string Name_UID_Type="";
		list<string> listFolderItems;
		do
			{

				memcpy(&Item_Type,ByteArray,1);
				ETG_TRACE_USR4(("Item_Type is %d",Item_Type));
				ByteArray++;

				//Retrieving the Item-type,length,UID,SubType,CharSetId into a structure.
				if(MEDIA_ELEMENT == Item_Type)
				{
					ETG_TRACE_USR4(("It is MediaElement"));
					l_spcMediaElementData=(struct MediaElement_Item_info *)ByteArray;

					if(AUDIO_FILE == l_spcMediaElementData->Item_Sub_Type)
					{

						ETG_TRACE_USR4(("It is audio File"));

						Item_Type = AUDIO_FILE;
						//It is audio File.
						Type="1";
					}
					else if(VIDEO_FILE == l_spcMediaElementData->Item_Sub_Type)
					{
						ETG_TRACE_USR4(("It is video File."));

						Item_Type = VIDEO_FILE;
						//It is video File.
						Type="2";
					}
					ETG_TRACE_USR4(("make it Point to name of this MediaElement (ie next to Item name Length)"));
					ByteArray= ByteArray+ START_OF_MEDIAELEMENT_NAME;
				}
				else if(FOLDER == Item_Type)
				{
					ETG_TRACE_USR4(("It is FolderItem"));
					l_spcFolderData=(struct FolderItem_Item_info *)ByteArray;

					//It is a Folder
					Type="0";

					ETG_TRACE_USR4(("make it Point to name of this FolderItem(ie next to Item name Length)"));
					ByteArray = ByteArray + START_OF_FOLDER_NAME;
				}
				ETG_TRACE_USR4(("String Type is %s",Type.c_str()));


				if(NetworkOrder)
				{
					if(FOLDER == Item_Type)
					{
						l_spcFolderData->Item_Length=ntohs(l_spcFolderData->Item_Length);
						l_spcFolderData->Item_Name_Length=ntohs(l_spcFolderData->Item_Name_Length);

						ETG_TRACE_USR4(("l_spcFolderData->Item_Length is %d",l_spcFolderData->Item_Length));
						ETG_TRACE_USR4(("l_spcFolderData->Item_Name_Length is %d",l_spcFolderData->Item_Name_Length));
						ETG_TRACE_USR4(("------------------------------------------------------"));
						ETG_TRACE_USR4(("l_spcFolderData->Item_UID[0] is %d",l_spcFolderData->Item_UID[0]));
						ETG_TRACE_USR4(("l_spcFolderData->Item_UID[1] is %d",l_spcFolderData->Item_UID[1]));
						ETG_TRACE_USR4(("l_spcFolderData->Item_UID[2] is %d",l_spcFolderData->Item_UID[2]));
						ETG_TRACE_USR4(("l_spcFolderData->Item_UID[4] is %d",l_spcFolderData->Item_UID[3]));
						ETG_TRACE_USR4(("l_spcFolderData->Item_UID[5] is %d",l_spcFolderData->Item_UID[5]));
						ETG_TRACE_USR4(("l_spcFolderData->Item_UID[6] is %d",l_spcFolderData->Item_UID[6]));
						ETG_TRACE_USR4(("l_spcFolderData->Item_UID[7] is %d",l_spcFolderData->Item_UID[7]));
						ETG_TRACE_USR4(("------------------------------------------------------"));

					}
					else if( MEDIA_ELEMENT == Item_Type)
					{
						l_spcMediaElementData->Item_Length=ntohs(l_spcMediaElementData->Item_Length);
						l_spcMediaElementData->Item_Name_Length=ntohs(l_spcMediaElementData->Item_Name_Length);

						ETG_TRACE_USR4(("l_spcMediaElementData->Item_Length is %d",l_spcMediaElementData->Item_Length));
						ETG_TRACE_USR4(("l_spcMediaElementData->Item_Name_Length is %d",l_spcMediaElementData->Item_Name_Length));
						ETG_TRACE_USR4(("------------------------------------------------------"));
						ETG_TRACE_USR4(("l_spcMediaElementData->Item_UID[0] is %d",l_spcMediaElementData->Item_UID[0]));
						ETG_TRACE_USR4(("l_spcMediaElementData->Item_UID[1] is %d",l_spcMediaElementData->Item_UID[1]));
						ETG_TRACE_USR4(("l_spcMediaElementData->Item_UID[2] is %d",l_spcMediaElementData->Item_UID[2]));
						ETG_TRACE_USR4(("l_spcMediaElementData->Item_UID[4] is %d",l_spcMediaElementData->Item_UID[3]));
						ETG_TRACE_USR4(("l_spcMediaElementData->Item_UID[5] is %d",l_spcMediaElementData->Item_UID[5]));
						ETG_TRACE_USR4(("l_spcMediaElementData->Item_UID[6] is %d",l_spcMediaElementData->Item_UID[6]));
						ETG_TRACE_USR4(("l_spcMediaElementData->Item_UID[7] is %d",l_spcMediaElementData->Item_UID[7]));
						ETG_TRACE_USR4(("------------------------------------------------------"));

					}
				}
				ETG_TRACE_USR4(("Character array to collect Name"));

				if(FOLDER == Item_Type)
				{
					ItemName = new char[(l_spcFolderData->Item_Name_Length)+1];
					Item_Name_Length=l_spcFolderData->Item_Name_Length;

					strncpy(ItemName,(char*)ByteArray,l_spcFolderData->Item_Name_Length);

					ItemName[Item_Name_Length]='\0';
					ByteArray +=l_spcFolderData->Item_Name_Length;

					Name = string(ItemName);
					ETG_TRACE_USR4(("String Name is %s",Name.c_str()));

					ETG_TRACE_USR4(("Decrement the Length of the Array "));
					ArrayLength=ArrayLength-(SIZE_OF_ITEM_TYPE_CUM_LENGTH+(l_spcFolderData->Item_Length));
					ETG_TRACE_USR4(("ArrayLength Now is %d",ArrayLength));
					delete[] ItemName;
				}
				else if(VIDEO_FILE == Item_Type || AUDIO_FILE == Item_Type)
				{
					ItemName = new char[(l_spcMediaElementData->Item_Name_Length)+1];
					Item_Name_Length=l_spcMediaElementData->Item_Name_Length;

					int i;
					for(i=0;i<Item_Name_Length;i++)
					{
						ETG_TRACE_USR4(("*ByteArray is %c",*ByteArray))
						ItemName[i] = *ByteArray;
						ETG_TRACE_USR4(("ItemName[%d] is %c",i,ItemName[i]));
						ByteArray++;
					}
					ItemName[Item_Name_Length]='\0';

					//If MediaElement Present,then zero is sent additionally .So Parsing that byte.
					ByteArray++;

					Name = string(ItemName);
					ETG_TRACE_USR4(("String Name is %s",Name.c_str()));

					ETG_TRACE_USR4(("Decrement the Length of the Array "));
					ETG_TRACE_USR4(("l_spcMediaElementData->Item_Length is %d",l_spcMediaElementData->Item_Length));
					ETG_TRACE_USR4(("ArrayLength is %d", ArrayLength));
					ArrayLength = (ArrayLength-(SIZE_OF_ITEM_TYPE_CUM_LENGTH+(l_spcMediaElementData->Item_Length)));
					ETG_TRACE_USR4(("ArrayLength Now is %d",ArrayLength));
					delete[] ItemName;
				}

				ETG_TRACE_USR4(("Copying the UID into int array to Create String!"));

				int incr,itr=0;

				if(FOLDER == Item_Type)
				{
					for(incr=0;incr<UID_CUM_SEPERATOR_LENGTH;incr++)
					{
						UID_arr[incr]=l_spcFolderData->Item_UID[itr];
						itr++;
						if(!(incr == (UID_CUM_SEPERATOR_LENGTH -1)))
						{
							incr++;
							UID_arr[incr]= ',';
						}
					}
				}
				else if(VIDEO_FILE == Item_Type || AUDIO_FILE == Item_Type)
				{
					for(incr=0;incr < UID_CUM_SEPERATOR_LENGTH;incr++)
					{
						UID_arr[incr]=l_spcMediaElementData->Item_UID[itr];
						itr++;
						if(!(incr == (UID_CUM_SEPERATOR_LENGTH -1)))
						{
							incr++;
							UID_arr[incr]= ',';
						}
					}
				}
				UID_arr[UID_CUM_SEPERATOR_LENGTH] ='\0';
				UID = string(UID_arr);

				ETG_TRACE_USR4(("String UID is %s",UID.c_str()));


				//Creation of Complete String with Name,uid& type.
				ETG_TRACE_USR4(("String Name_UID_Type"));
				Name_UID_Type.append(Name);
				Name_UID_Type.append(SEPERATOR);
				Name_UID_Type.append(UID);
				Name_UID_Type.append(SEPERATOR);
				Name_UID_Type.append(Type);
				ETG_TRACE_USR4(("Name_UID_Type is %s",Name_UID_Type.c_str()));

				//Going to Append it to the QStringList
				ETG_TRACE_USR4(("Going to Append it to the StringList"));
				listFolderItems.push_back (Name_UID_Type);

				//Clear the String Variables
				Name.clear();
				UID.clear();
				Type.clear();
				Name_UID_Type.clear();

			}while(ArrayLength!=0);

	delete[] ByteArray_Address;


	/* compare result with expectations */

	/*compare no.of items*/
	CPPUNIT_ASSERT(listFolderItems.size() == expected_Name_UID_Type.size());

	size_t listSize = 0;
	std::list<string>::iterator it;

	while(listSize < expected_Name_UID_Type.size())
	{
		it = listFolderItems.begin();
		std::advance(it,listSize);

		ETG_TRACE_USR4(("*it is %s",(*it).c_str()));
		ETG_TRACE_USR4(("expected_Name_UID_Type.at(%d) is  %s",listSize,expected_Name_UID_Type.at(listSize)));
		CPPUNIT_ASSERT(strcmp(const_cast<char*>((*it).c_str()),expected_Name_UID_Type.at(listSize)) == 0); 	// check the Name_UID_Type
		listSize++;
	}

	ret = true;
	delete[] objMyRRSM.ParamString;

	// test result
	CPPUNIT_ASSERT(ret);
}
void BTControlTest::ChangePath()
{
	ENTRY_TEST

	    tResult ret = MP_NO_ERROR;

	    char messageString[64];
	    tAllParameters parameterString;
	    size_t size = sizeof(parameterString);

		BTTestSM objMyRRSM;

		//Dummy Params for Testing
	    tDirection Direction = FOLDER_UP;
	    tLevelCount LevelUpCount =(tLevelCount) 1;
	    tLevelCount LevelDownCount =(tLevelCount)0 ;
	    tItemUIDArray ItemUIDArray  = NULL;

	    /* Send AVP_GET_FOLDER_ITEM message to BTControlSM */
	    strncpy_r(messageString, "BTControlSM::AVP_CHANGE_PATH",sizeof(messageString));

	    ret = LocalSPM::GetBTControl().ParameterAVP_CHANGE_PATH(
	       		   	   	   	   	   	   	   	   	   	   	   OUT parameterString,
	       		   	   	   	   	   	   	   	   	   	   	   IN size,
	       		   	   	   	   	   	   	   	   	   	   	   IN Direction,
	       		   	   	   	   	   	   	   	   	   	   	   IN LevelUpCount,
	       		   	   	   	   	   	   	   	   	   	   	   IN LevelDownCount,
	       		   	   	   	   	   	   	   	   	   	   	   IN ItemUIDArray);
	    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

   	    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);

   	 	 	tBTMethodRequestStatus Status = REQ_NOT_OK	;
 			tNumOfItems NumOfItems = 0;
 			tErrorMessage ErrorMessage = NULL ;
 			CPPUNIT_ASSERT(objMyRRSM.ParamString != NULL);
  			objMyRRSM.UnMarshal(objMyRRSM.ParamString, tBTMethodRequestStatus_format tNumOfItems_format tErrorMessage_format  ,&Status ,&NumOfItems ,&ErrorMessage );

  			CPPUNIT_ASSERT(REQ_OK == Status);
  			CPPUNIT_ASSERT(8 == NumOfItems);

			if(ErrorMessage != NULL)
			{
				ret = false;
				ETG_TRACE_USR1(("ErrorMessage is %s",ErrorMessage));
				delete[]  ErrorMessage;
			}
			else
			{
				ret =true;
			}
			delete[] objMyRRSM.ParamString;

			// test result
			CPPUNIT_ASSERT(ret);

}
void BTControlTest::StopAudioInput()
{
	ENTRY_TEST

	tResult ret = MP_NO_ERROR;

	char messageString[64];
	BTTestSM objMyRRSM;

	/*expected Metadata */

	tMetadata expectedTitle = "";
	tMetadata expectedArtist = "";
	tMetadata expectedAlbum = "";
	tMetadata expectedGenre = "";

	/* Send Stop message to BTControlSM */
	strncpy_r(messageString, "BTControlSM::STOP",sizeof(messageString));

	ret = objMyRRSM.DoEventAnswer(IN messageString, IN (char*)NULL, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);

	tPEPlaybackState status;
	tMetadata Title = "";
	tMetadata Artist = "";
	tMetadata Album = "";
	tMetadata Genre = "";

	CPPUNIT_ASSERT(objMyRRSM.ParamString != NULL);

	objMyRRSM.UnMarshal(objMyRRSM.ParamString, tPEPlaybackState_format tMetadata_format tMetadata_format tMetadata_format tMetadata_format  ,&status ,Title ,Artist ,Album ,Genre );

	ETG_TRACE_USR1(("The Current Playback State is %d",status));
	ETG_TRACE_USR1(("Title is %s",Title));
	ETG_TRACE_USR1(("Artist is %s",Artist));
	ETG_TRACE_USR1(("Album is %s",Album));
	ETG_TRACE_USR1(("Genre is %s",Genre));

	CPPUNIT_ASSERT(status != PE_PBS_ERRORSTATE);
	CPPUNIT_ASSERT(strcmp(Title,expectedTitle) == 0);
	CPPUNIT_ASSERT(strcmp(Artist,expectedArtist) == 0);
	CPPUNIT_ASSERT(strcmp(Album,expectedAlbum) == 0);
	CPPUNIT_ASSERT(strcmp(Genre,expectedGenre) == 0);
	delete[] objMyRRSM.ParamString;

	ret = true;

	// test result
	CPPUNIT_ASSERT(ret);
}
void BTControlTest::SetPlaybackMode()
{
	ENTRY_TEST
	tResult ret = MP_NO_ERROR;

	char messageString[64];
	BTTestSM objMyRRSM;

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

	//Variables to Prepare ParameterString
	tDeviceType deviceType = DTY_BLUETOOTH;
	tDeviceID deviceID = 1;
	tMountPoint mountPoint = "";
	tPlaybackMode playbackMode = PBM_RANDOM ;

	/* Send Stop message to BTControlSM */
	strncpy_r(messageString, "BTControlSM::SET_PLAYBACK_MODE",sizeof(messageString));

    ret = LocalSPM::GetBTControl().ParameterSET_PLAYBACK_MODE(
       		   	   	   	   	   	   	   	   	   	   	   OUT parameterString,
       		   	   	   	   	   	   	   	   	   	   	   IN size,
       		   	   	   	   	   	   	   	   	   	   	   IN deviceType,
       		   	   	   	   	   	   	   	   	   	   	   IN deviceID,
       		   	   	   	   	   	   	   	   	   	   	   IN mountPoint,
       		   	   	   	   	   	   	   	   	   	   	   IN playbackMode);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

	ret = objMyRRSM.DoEventAnswer(IN messageString, IN (char*)NULL, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);
	tBTMethodRequestStatus Status = REQ_NOT_OK;
	tErrorMessage ErrorMessage = NULL;
	CPPUNIT_ASSERT(objMyRRSM.ParamString != NULL);

	objMyRRSM.UnMarshal(objMyRRSM.ParamString, tBTMethodRequestStatus_format tErrorMessage_format  ,&Status ,&ErrorMessage );
	CPPUNIT_ASSERT(REQ_OK == Status);
	delete[] objMyRRSM.ParamString;

	if(ErrorMessage != NULL)
	{
		delete[] ErrorMessage;
		ret = false;
	}
	else
	{
		ret = true;
	}

	// test result
	CPPUNIT_ASSERT(ret);

}
void BTControlTest::SetRepeatMode()
{
	ENTRY_TEST
	tResult ret = MP_NO_ERROR;

	char messageString[64];
	BTTestSM objMyRRSM;

	tAllParameters parameterString;
	size_t size = sizeof(parameterString);

	//Variables to Prepare ParameterString
	tDeviceType deviceType = DTY_BLUETOOTH;
	tDeviceID deviceID = 1;
	tMountPoint mountPoint = "";
	tRepeatMode repeatMode = RPT_ALL;

	/* Send Stop message to BTControlSM */
	strncpy_r(messageString, "BTControlSM::SET_REPEAT_MODE",sizeof(messageString));

    ret = LocalSPM::GetBTControl().ParameterSET_REPEAT_MODE(
       		   	   	   	   	   	   	   	   	   	   	   OUT parameterString,
       		   	   	   	   	   	   	   	   	   	   	   IN size,
       		   	   	   	   	   	   	   	   	   	   	   IN deviceType,
       		   	   	   	   	   	   	   	   	   	   	   IN deviceID,
       		   	   	   	   	   	   	   	   	   	   	   IN mountPoint,
       		   	   	   	   	   	   	   	   	   	   	   IN repeatMode);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

	ret = objMyRRSM.DoEventAnswer(IN messageString, IN (char*)NULL, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);
	tBTMethodRequestStatus Status = REQ_NOT_OK;
	tErrorMessage ErrorMessage = NULL;

	CPPUNIT_ASSERT(objMyRRSM.ParamString != NULL);

	objMyRRSM.UnMarshal(objMyRRSM.ParamString, tBTMethodRequestStatus_format tErrorMessage_format  ,&Status ,&ErrorMessage );

	CPPUNIT_ASSERT(REQ_OK == Status);

	if(ErrorMessage != NULL)
	{
		delete[] ErrorMessage;
		ret = false;
	}
	else
	{
		ret = true;
	}
	delete[] objMyRRSM.ParamString;

	// test result
	CPPUNIT_ASSERT(ret);
}

void BTControlTest::BTCreateMediaPlayerFileList()
{
	ENTRY_TEST

    tResult res = 0;
    tListSize listSize = 0;
    tNumberOfMediaObjects numberOfMediaObjects = 0;
    tNumberOfPlayLists numberOfPlayLists = 0;
    tNumberOfFolders numberOfFolders = 0;

    tPath path ;
    memset(path,0,1024);

    tDeviceID deviceID = 2;

//TODO:
#if 0
    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_BLUETOOTH);
    CPPUNIT_ASSERT(res == 0);
#endif

    /* set the path */
    strncpy_r(path, "/", sizeof(path));

    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT mBTFileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_BLUETOOTH_FILELIST,
            IN path,
            IN deviceID,
            true, //streaming
            FTS_AUDIO_VIDEO_PLAYLIST);

    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfMediaObjects == 0);
    CPPUNIT_ASSERT(numberOfPlayLists == 0);
    CPPUNIT_ASSERT(numberOfFolders == 8);
}

void BTControlTest::BTRequestMediaPlayerFileListSlice()
{
	ENTRY_TEST

    tResult res;
    vector<tFiles> mediaFileVector; /* resulting entries */

    /* get the list slice */
	res= LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN mBTFileListID, 0, 8);
    CPPUNIT_ASSERT(res == 0);

    /* check the resulting entries */
    CPPUNIT_ASSERT(mediaFileVector.size() == 8);

    CPPUNIT_ASSERT(strcmp(mediaFileVector[0].fileName, "ALBUMS") == 0);
    CPPUNIT_ASSERT(mediaFileVector[0].type == FT_FOLDER);

    CPPUNIT_ASSERT(strcmp(mediaFileVector[1].fileName, "ARTISTS") == 0);
    CPPUNIT_ASSERT(mediaFileVector[1].type == FT_FOLDER);

    CPPUNIT_ASSERT(strcmp(mediaFileVector[2].fileName, "COMPILATIONS") == 0);
    CPPUNIT_ASSERT(mediaFileVector[4].type == FT_FOLDER);

    CPPUNIT_ASSERT(strcmp(mediaFileVector[3].fileName, "COMPOSERS") == 0);
    CPPUNIT_ASSERT(mediaFileVector[5].type == FT_FOLDER);

    CPPUNIT_ASSERT(strcmp(mediaFileVector[4].fileName, "GENRES") == 0);
    CPPUNIT_ASSERT(mediaFileVector[6].type == FT_FOLDER);

    CPPUNIT_ASSERT(strcmp(mediaFileVector[5].fileName, "PLAYLISTS") == 0);
    CPPUNIT_ASSERT(mediaFileVector[2].type == FT_FOLDER);

    CPPUNIT_ASSERT(strcmp(mediaFileVector[6].fileName, "PODCASTS") == 0);
    CPPUNIT_ASSERT(mediaFileVector[7].type == FT_FOLDER);

    CPPUNIT_ASSERT(strcmp(mediaFileVector[7].fileName, "SONGS") == 0);
    CPPUNIT_ASSERT(mediaFileVector[3].type == FT_FOLDER);

}
void BTControlTest::DoCalculateItemCount()
{
    ENTRY_TEST
    map<string,tNumOfItems>::iterator pathIter;
    string nowPlayingPath="NOW_PLAYING";
    dummyPathVsItemCount[nowPlayingPath] = 50;

    const size_t size1 = sizeof(tAllParameters);
    char *parmas = new char[size1];
    tNumOfItems TotNumOfItems,ElementsInCache;
	SMF::Marshal(parmas, size1-1, DOUBLE_MARSHAL_SEPARATOR, "tiiiii", "/NowPlaying",0,0,0,0,0);
	LocalSPM::GetBTControl().DoCalculateItemCountInGivenPath(IN parmas);
	ETG_TRACE_USR1(("Configured ItemCount is %d",dummyPathVsItemCount[nowPlayingPath]));
	sleep(2);
	BTGetLevelInfo("/NowPlaying",OUT TotNumOfItems,OUT ElementsInCache);
	ETG_TRACE_USR1(("BTControlTest ElementsInCache count is :%d",ElementsInCache));
	CPPUNIT_ASSERT(dummyPathVsItemCount[nowPlayingPath] == ElementsInCache);

}



