#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/iPodControlHelper.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#endif
#endif

#include "FunctionTracer.h"
#include "VarTrace.h"

/* others */
#include "iPodControlHelper.h"
#include "LocalSPM.h"
#include "Dispatcher.h"
#include <TimeTrace.h>

/*lint -save -e1401 */

iPodControlHelper::iPodControlHelper(const tComponentID componentID):ILocalSPM(componentID)
{
    ENTRY_INTERNAL;
}

iPodControlHelper::~iPodControlHelper()
{
    ENTRY_INTERNAL;
}

void iPodControlHelper::Create()
{
    // create the state machine and other internal objects return state
    ENTRY;

    iPodControlHelperSM::Create();

    CreateDone(0);
}

// to init everything
tResult iPodControlHelper::Init(tInitReason reason)
{
    // run the init of the state machine and return error if any
    ENTRY;
    VARTRACE(reason);

    /* Init the state machine */
    iPodControlHelperSM::Init();

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);

    return InitDone(0);
}

tResult iPodControlHelper::InitSM()
{
    ENTRY;

    /* Initialize variables */

    return MP_NO_ERROR;
}

tResult iPodControlHelper::Run()
{
    ENTRY

    LocalSPM::GetThreadFactory().Do(this, 0, NULL);

    return RunDone(0);
}

void iPodControlHelper::Do(int functionID, void *ptr)
{
    ENTRY
    (void)functionID;
    (void)ptr;

    // set the threads name
    LocalSPM::GetThreadFactory().SetName(iPodControlHelperSM::GetSMNameFull());

    //actual thread
    while((iPodControlHelperSM::STATE_MACHINE_FINISHED != iPodControlHelperSM::StateMachine_Main())){}
}

tResult iPodControlHelper::Stop()
{
    ENTRY;

    tResult ret = MP_NO_ERROR;

    /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *)NULL);
    if (MP_NO_ERROR != ret) {
        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
    }

    return ret;
}

tResult iPodControlHelper::StopEventProcessed()
{
    ENTRY;

    /* Send stop done to SPM in the transition to final state in state machine */
    return StopDone(0);
}

tResult iPodControlHelper::Done()
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN this);

    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *)NULL);
    if (MP_NO_ERROR != ret) {
        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
    }

    return ret;
}

tResult iPodControlHelper::DoneEventProcessed()
{
    ENTRY;

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

char *iPodControlHelper::GetSMStateName(OUT tGeneralString stateName, size_t size)
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}

tResult iPodControlHelper::OnDBChangeDeviceType(const tDeviceID deviceID, const tDeviceType newDeviceType)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(newDeviceType);

    //set to disconnected
    LocalSPM::GetDBManager().SetConnectionState(deviceID, CS_DISCONNECTED);
    //change to DTY_BLUTOOTH
    LocalSPM::GetDBManager().SetDeviceType(deviceID, newDeviceType);
    //set back to attached
    LocalSPM::GetDBManager().SetConnectionState(deviceID, CS_ATTACHED);

    return MP_NO_ERROR;
}

tResult iPodControlHelper::OnDBChangeDeviceTypeAndMountPoint(const tDeviceID deviceID, const tDeviceType newDeviceType, const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(newDeviceType);

    //set to disconnected
    LocalSPM::GetDBManager().SetConnectionState(deviceID, CS_DISCONNECTED);
    //change to DTY_BLUTOOTH and also update mount point
    LocalSPM::GetDBManager().SetDeviceTypeAndMountPoint(deviceID, newDeviceType,mountPoint);
    //set back to attached
    LocalSPM::GetDBManager().SetConnectionState(deviceID, CS_ATTACHED);

    return MP_NO_ERROR;
}

tResult iPodControlHelper::OnDBChangeDeviceName(const tDeviceID deviceID, const tDeviceName newDeviceName)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(newDeviceName);

    //change name
     LocalSPM::GetDBManager().SetDeviceName(deviceID, newDeviceName);

    return MP_NO_ERROR;
}

tResult iPodControlHelper::OnDBChangeDiPOSettings(const tDeviceID deviceID, const tDiPOCaps diPOCaps, const tDiPOActive diPOActive, const tDiPOVersion diPOVersion)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(diPOCaps);
    VARTRACE(diPOActive);
    VARTRACE(diPOVersion);

    LocalSPM::GetDBManager().SetDiPOParameters(deviceID, IN diPOCaps, IN diPOActive, IN diPOVersion);

    return MP_NO_ERROR;
}

tResult iPodControlHelper::OnDBChangeConnectionState(const tDeviceID deviceID, const tConnectionState newConnectionState)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(newConnectionState);

    switch(newConnectionState) {
    case CS_DISCONNECTED:
        LocalSPM::GetDBManager().SetConnectionState(deviceID, newConnectionState);

        if(!LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled()) {
            //CMIVI-234 trigger BT iAP reactivation manually, there is no DB_DEVICE_REMOVED trigger due to Hostmode connection

            tDeviceInfo removedDeviceInfo;
            tResult ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT removedDeviceInfo, IN deviceID);

            if(ret == MP_NO_ERROR)
            {
                LocalSPM::GetCustomControl().HandleAppleDeviceRemoved(removedDeviceInfo);
            }
        }

        //clear DiPO settings on iAP2 disconnect
        //mySPIN: update MPLAY_APPCONTROLFI_C_U16_DIPODEVICECONNECTIONS, trigger for app shutdown and release gadgetFS (see SwitchToDeviceMode / umount)
        LocalSPM::GetDBManager().SetDiPOParameters(deviceID, IN tDiPOCaps_init, IN tDiPOActive_init, IN "");
        break;
    default:
        LocalSPM::GetDBManager().SetConnectionState(deviceID, newConnectionState);
        break;
    }

    return MP_NO_ERROR;
}

tResult iPodControlHelper::OnDBChangeNowPlayingListAvailable(const tDeviceID deviceID, const tNowPlayingListAvailable isNowPlayingListAvailable)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(isNowPlayingListAvailable);
	
    LocalSPM::GetDBManager().UpdateNowPlayingListAvailable(deviceID, isNowPlayingListAvailable);
    return MP_NO_ERROR;
}

tResult iPodControlHelper::OnDBSetDeviceUUID(const tDeviceID deviceID, const tUUID deviceUUID)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(deviceUUID);
    LocalSPM::GetDBManager().UpdateDeviceUUID(deviceID, deviceUUID);

    return MP_NO_ERROR;
}
tResult iPodControlHelper::OnDBSetAppleDeviceMACAddress(const tDeviceID deviceID, const tMACAddress appleDeviceMACAddress)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(appleDeviceMACAddress);
    LocalSPM::GetDBManager().UpdateAppleDeviceMACAddress(deviceID, appleDeviceMACAddress);

    return MP_NO_ERROR;
}
tResult iPodControlHelper::OnDBSetAppleDeviceTransportIdentifiers(const tDeviceID deviceID,const tMACAddress appleDeviceMACAddress,const tUSBSerial appleDeviceUSBSerialNumber)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(appleDeviceUSBSerialNumber);
    VARTRACE(appleDeviceMACAddress);
    LocalSPM::GetDBManager().UpdateAppleDeviceMACAddressAndUSBSerialNumber(deviceID, appleDeviceMACAddress,appleDeviceUSBSerialNumber);
    return MP_NO_ERROR;
}

tResult iPodControlHelper::OnDBChangeDeviceState(const tDeviceID deviceID, const tDeviceState newDeviceState)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(newDeviceState);

    if(newDeviceState == DS_NONE) {

        LocalSPM::GetDBManager().SetDeviceState(deviceID, newDeviceState);
    }

    return MP_NO_ERROR;
}
