#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/iPodControlHandle.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#endif
#endif

#include <string.h>
#include "FunctionTracer.h"
#include "VarTrace.h"
#include "LocalSPM.h"
#include "iPodControlHandle.h"

iPodControlHandle::iPodControlHandle()
: mp_IAP2Device(NULL)
, mp_IAP2InitParameter(NULL)
, mp_IAP2AlbumArtBuffer(NULL)
, mp_QueueListBuffer(NULL)
, mp_Context(NULL)
{
    ENTRY;

    InitDeviceInfo(m_DeviceInfo);

    m_OTGType = IPOD_OTG_NONE;
    m_OTGPortNumber = -1;
    m_OTGPath[0] = 0;
    m_PowerPortPath[0] = 0;
    m_UDCDevice[0] = 0;
    m_HubVendorID[0] = 0;
    m_HubProductID[0] = 0;

    m_TimerMap[atsPlayStatus] = new ElapsedTimer();
    m_TimerMap[atsPlayingTrackInfo] = new ElapsedTimer();
    m_TimerMap[pbNotifications] = new ElapsedTimer();
    m_TimerMap[hidSeekLead] = new ElapsedTimer();
    m_TimerMap[iap2InitCallbacks] = new ElapsedTimer();
    m_TimerMap[iap2LastHostModeError] = new ElapsedTimer();
    m_TimerMap[iapInitElapsed] = new ElapsedTimer();

    mp_Context = new iPodControlIndexerContext;
    m_btLimitationActionState = tBTLimitationActionState_init;
    m_isCPWActive = false;

    m_CallDuration = 0;
    InitDiPOLocationInfoType(m_LocationInfoType);
    InitDiPOGPRMCDataStatusValues(m_GPRMCDataStatusValues);
    m_IsWaitingforRoleSwitchResponse = false;
    Reset();
}

iPodControlHandle::~iPodControlHandle()
{
    //delete elapsed timers
    map<tiPodElaspedTime, ElapsedTimer*>::iterator it;
    for (it = m_TimerMap.begin(); it != m_TimerMap.end(); ++it) {
        delete (it->second);
    }

    delete mp_Context;
    mp_IAP2Device = 0;
    mp_IAP2InitParameter = 0;
    mp_IAP2AlbumArtBuffer = 0;
    mp_QueueListBuffer = 0;
}

void iPodControlHandle::Reset(const bool all)
{
    ENTRY;
    VARTRACE(all);

    //keep mountpoint and device id for map reference
    InitMediaObject(m_NowPlayingMediaObject);
    m_NowPlayingMediaObject.sampleRate = 44100;
    m_ElapsedPlaytime = 0;

    m_DeviceInfo.connectionState = CS_DISCONNECTED;

    m_TrackFinished = false;
    m_StreamingMode = false;
    memset(m_FocusApp, 0, sizeof(m_FocusApp));
    m_PEHandle = HANDLE_NONE;
    m_CodecType = tCodecType_init;
    m_LocationInformationUpdate = false;
    m_VehicleStatusUpdate = false;
    m_LastHIDReport = IPOD_HID_REPORT_BUTTON_RELEASED;

    m_iPodID = -1;
    m_Options = 0;
    m_NowPlayingTrackIndex = -1;
    m_NowPlayingTrackCount = -1;
    m_NowPlayingChapterIndex = -1;
    m_PBTrackIndex = -1;
    m_AlbumArtID = -1;
    m_QueueListID = -1;

    //keep OTG port during reinit iap
    //m_OTGType = IPOD_OTG_NONE;
    //m_OTGPortNumber = -1;
    //m_OTGPath[0] = 0;
    //m_PowerPortPath[0] = 0;
    //m_UDCDevice[0] = 0;
    //m_HubVendorID[0] = 0;
    //m_HubProductID[0] = 0;

    m_RoleSwitched = FALSE;

    m_IAP2Mutex.lock();
    mp_IAP2Device = NULL;
    mp_IAP2InitParameter = NULL;
    mp_IAP2AlbumArtBuffer = NULL;
    mp_QueueListBuffer = NULL;
    m_IAP2Mutex.unlock();

    m_PollThreadIndex = -1;
    m_PlayerState = 0;
    m_PlaybackState = PE_PBS_STOPPEDSTATE;
    m_LastPlaybackState = PE_PBS_STOPPEDSTATE;
    m_DBPath = iPodControlMediaPath();
    m_PBPath = iPodControlMediaPath();

    m_IndexerMutex.lock();
    if(mp_Context) {
        mp_Context->Reset();
    }
    m_IndexerMutex.unlock();

    m_PlaybackMode = tPlaybackMode_init;
    m_RepeatMode = tRepeatMode_init;
    m_RepeatInitFlag = true;
    m_diPOCaps = DIPO_CAP_NONE;
    m_btLimitationConnectionState = CS_DISCONNECTED;
    m_CallState.clear();
    InitDiPOCommunications(m_Communications);
    InitBTProfile(m_BTProfile);
    InitDiPOPower(m_PowerUpdate);
    InitDiPODeviceTime(m_DeviceTimeUpdate);

    InitDiPORouteGuidanceUpdate(m_RGUpdate);
    InitDiPORouteGuidanceManeuverUpdate(m_RGManeuverUpdate);
    while(!m_RGQueueUpdate.empty()){
        m_RGQueueUpdate.pop();
    }
    while(!m_RGManeuverQueueUpdate.empty()){
        m_RGManeuverQueueUpdate.pop();
    }
    map<tiPodElaspedTime, ElapsedTimer*>::iterator it;
    for(it = m_TimerMap.begin(); it != m_TimerMap.end(); ++it){
        if(it->first != iap2LastHostModeError) { //Do not reset hostmode error on reconnect
            it->second->Reset();
        }
    }

    if (all) {
        m_AppInfos.clear();

        //add default app infos
        //keep compatibility to MY13

        tAppName appName = {0};
        tProtocolName protocol = {0};
        tBundleSeedID bundleID = {0};
        tAppInfoOption option = AIO_DEVICE_MODE_ONLY;
        for(int i = 1; i <= LocalSPM::GetDataProvider().iPodControlAppInfos(); i++) {
            switch(i) {
            case 1:
                strncpy_r(appName, LocalSPM::GetDataProvider().iPodControlAppInfoAppName_1().c_str(), sizeof(appName));
                strncpy_r(protocol, LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_1().c_str(), sizeof(protocol));
                strncpy_r(bundleID, LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_1().c_str(), sizeof(bundleID));
                option = (tAppInfoOption)LocalSPM::GetDataProvider().iPodControlAppInfoOption_1();
                break;
            case 2:
                strncpy_r(appName, LocalSPM::GetDataProvider().iPodControlAppInfoAppName_2().c_str(), sizeof(appName));
                strncpy_r(protocol, LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_2().c_str(), sizeof(protocol));
                strncpy_r(bundleID, LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_2().c_str(), sizeof(bundleID));
                option = (tAppInfoOption)LocalSPM::GetDataProvider().iPodControlAppInfoOption_2();
                break;
            case 3:
                strncpy_r(appName, LocalSPM::GetDataProvider().iPodControlAppInfoAppName_3().c_str(), sizeof(appName));
                strncpy_r(protocol, LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_3().c_str(), sizeof(protocol));
                strncpy_r(bundleID, LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_3().c_str(), sizeof(bundleID));
                option = (tAppInfoOption)LocalSPM::GetDataProvider().iPodControlAppInfoOption_3();
                break;
            case 4:
                strncpy_r(appName, LocalSPM::GetDataProvider().iPodControlAppInfoAppName_4().c_str(), sizeof(appName));
                strncpy_r(protocol, LocalSPM::GetDataProvider().iPodControlAppInfoProtocol_4().c_str(), sizeof(protocol));
                strncpy_r(bundleID, LocalSPM::GetDataProvider().iPodControlAppInfoBundleID_4().c_str(), sizeof(bundleID));
                option = (tAppInfoOption)LocalSPM::GetDataProvider().iPodControlAppInfoOption_4();
                break;
            default:
                break;
            }
            AddAppInfo(protocol, bundleID, appName, option);
        }
#if 0   //app control test
        m_AppInfos.clear();
        AddAppInfo("com.apple.p1", "1234", "com.apple.p1", AIO_DEVICE_MODE_ONLY); //Test
#endif
        memset(m_LaunchApp, 0, sizeof(m_LaunchApp));
    }
}

bool iPodControlHandle::GetOption(const tiPodOptions option) {
    ENTRY_INTERNAL;
    return (m_Options & (1<<option));
}

void iPodControlHandle::SetOption(const tiPodOptions option, const bool set) {
    ENTRY_INTERNAL;
    m_Options = set ? (m_Options | (1<<option)) : (m_Options & ~(1<<option));
}

void iPodControlHandle::ResetElapsedTime(const tiPodElaspedTime elapsedtime) {
    ENTRY;
    ETG_TRACE_USR3(("iPodControlHandle::ResetElapsedTime(elapsedtime=%d)", (int)elapsedtime));
    m_TimerMap[elapsedtime]->Restart();
}

unsigned long iPodControlHandle::GetElapsedTimeMS(const tiPodElaspedTime elapsedtime) {
    ENTRY_INTERNAL;
    return m_TimerMap[elapsedtime]->ElapsedMS();
}

int iPodControlHandle::CreateConfiOSApp(IPOD_IOS_APP * &pApps) {
    ENTRY_INTERNAL;
    vector<tIPODAppInfo> appInfos = GetAppInfos(false, false); //iAP1

    if (appInfos.size()) {
        pApps = new IPOD_IOS_APP[appInfos.size()];
        if (pApps) {
            for (unsigned int i = 0; i < appInfos.size(); i++) {
                pApps[i].metaData = 0;
                pApps[i].protocol = new U8[sizeof(tProtocolName)];
                if (pApps[i].protocol) {
                    memcpy(pApps[i].protocol, appInfos[i].protocol,
                            sizeof(tProtocolName));
                }
                pApps[i].bundle = new U8[sizeof(tBundleSeedID)];
                if (pApps[i].bundle) {
                    memcpy(pApps[i].bundle, appInfos[i].bundleID,
                            sizeof(tBundleSeedID));
                }
            }
            return appInfos.size();
        }
    }
    return 0;
}

void iPodControlHandle::DeleteConfiOSApp(const IPOD_IOS_APP * pApps, const int numApps) {
    ENTRY_INTERNAL;
    if (pApps) {
        for (int i = 0; i < numApps; i++) {
            delete pApps[i].protocol;
            delete pApps[i].bundle;
        }
        delete[] pApps;
    }
}

tBoolean iPodControlHandle::AddAppInfo(const tProtocolName protocol, const tBundleSeedID bundleID, const tAppName appName, const tAppInfoOption option) {
    ENTRY_INTERNAL;
    tBoolean addInfo = true;
    for (unsigned int i = 0; i < m_AppInfos.size(); i++) {
        if(!strncmp(m_AppInfos[i].protocol, protocol, strlen_r(protocol)) &&
           !strncmp(m_AppInfos[i].bundleID, bundleID, strlen_r(bundleID)) &&
           !strncmp(m_AppInfos[i].appName, appName, strlen_r(appName)) &&
           m_AppInfos[i].option == option) {
            ETG_TRACE_USR3(("%s AppInfo found in list", __PRETTY_FUNCTION__));
            addInfo = false;
            break;
        }
    }

    if(addInfo) {
        //new info
        tIPODAppInfo appInfo;
        appInfo.sessionID = 0;
        strncpy_r(appInfo.protocol, protocol, sizeof(appInfo.protocol));
        strncpy_r(appInfo.bundleID, bundleID, sizeof(appInfo.bundleID));
        strncpy_r(appInfo.appName, appName, sizeof(appInfo.appName));
        appInfo.option = option;
        m_AppInfos.push_back(appInfo);
        ETG_TRACE_USR3(("%s AppInfo added to list", __PRETTY_FUNCTION__));
    }

    VARTRACE(protocol);
    VARTRACE(bundleID);
    VARTRACE(appName);
    VARTRACE(option);
    VARTRACE(addInfo);
    return addInfo;
}
tBoolean iPodControlHandle::AddAppInfoFromSPI(const tProtocolName protocol, const tBundleSeedID bundleID, const tAppName appName, const tAppInfoOption option) {
    ENTRY_INTERNAL;
    tBoolean addInfo = true;
    for (unsigned int i = 0; i < m_AppInfosFromSPI.size(); i++) {
        if(!strncmp(m_AppInfosFromSPI[i].protocol, protocol, strlen(protocol)) &&
           !strncmp(m_AppInfosFromSPI[i].bundleID, bundleID, strlen(bundleID)) &&
           !strncmp(m_AppInfosFromSPI[i].appName, appName, strlen(appName)) &&
           m_AppInfosFromSPI[i].option == option) {
            ETG_TRACE_USR3(("%s AppInfo found in list", __PRETTY_FUNCTION__));
            addInfo = false;
            break;
        }
    }
    if(addInfo) {
        tIPODAppInfo appInfo;
        appInfo.sessionID = 0;
        strncpy_r(appInfo.protocol, protocol, sizeof(appInfo.protocol));
        strncpy_r(appInfo.bundleID, bundleID, sizeof(appInfo.bundleID));
        strncpy_r(appInfo.appName, appName, sizeof(appInfo.appName));
        appInfo.option = option;
        m_AppInfosFromSPI.push_back(appInfo);
        ETG_TRACE_USR3(("%s AppInfo added to list", __PRETTY_FUNCTION__));
    }
    VARTRACE(protocol);
    VARTRACE(bundleID);
    VARTRACE(appName);
    VARTRACE(option);
    VARTRACE(addInfo);
    return addInfo;
}

vector<tIPODAppInfo> iPodControlHandle::GetAppInfos(const bool hostmode, const bool nativeTransport) const
{
    ENTRY_INTERNAL;
    vector<tIPODAppInfo> appInfos;
    for (unsigned int i = 0; i < m_AppInfos.size(); i++) {
        if(m_AppInfos[i].option == AIO_HOST_AND_DEVICE_MODE ||
           (m_AppInfos[i].option == AIO_DEVICE_MODE_ONLY && !hostmode) ||
           (m_AppInfos[i].option == AIO_HOSTMODE_ONLY && hostmode) ||
           (m_AppInfos[i].option == AIO_EA_NATIVE_TRANSPORT && nativeTransport)) {
            appInfos.push_back(m_AppInfos[i]);
        }
    }
    return appInfos;
}
vector<tIPODAppInfo> iPodControlHandle::GetAppInfosFromSPI() const
{
    ENTRY_INTERNAL;
    return m_AppInfosFromSPI;
}
void iPodControlHandle::ClearAppInfosFromSPI()
{
    ENTRY_INTERNAL;
    m_AppInfosFromSPI.clear();
}

tBoolean iPodControlHandle::RemoveAppInfo(const tAppName appName, tSessionID &sessionID) {
    ENTRY_INTERNAL;
    tBoolean removedInfo = false;
    for (unsigned int i = 0; i < m_AppInfos.size(); i++) {
        if( !strncmp(m_AppInfos[i].appName, appName, strlen_r(appName))) {
            ETG_TRACE_USR3(("%s AppInfo removed from list", __PRETTY_FUNCTION__));
            sessionID = m_AppInfos[i].sessionID;
            m_AppInfos.erase(m_AppInfos.begin() + i);
            removedInfo = true;
            break;
        }
    }
    VARTRACE(appName);
    VARTRACE(sessionID);
    VARTRACE(removedInfo);
    return removedInfo;
}

tSessionID iPodControlHandle::GetSessionIDFromAppName(const tAppName appName) {
    ENTRY_INTERNAL;
    for (unsigned int i = 0; i < m_AppInfos.size(); i++) {
        if (!strncmp(m_AppInfos[i].appName, appName, strlen_r(appName))) {
            return m_AppInfos[i].sessionID;
        }
    }
    ETG_TRACE_ERR(("%s session id not found in list", __PRETTY_FUNCTION__));
    return 0;
}

unsigned int iPodControlHandle::GetProtocolIDFromAppName(const tAppName appName) {
    ENTRY_INTERNAL;
    for (unsigned int i = 0; i < m_AppInfos.size(); i++) {
        if (!strncmp(m_AppInfos[i].appName, appName, strlen_r(appName))) {
            return i+1; //protocolIndex starts with 1
        }
    }
    ETG_TRACE_ERR(("protocol id not found in list"));
    return 0;
}

void iPodControlHandle::GetActiveSessionList(vector<string> &list){
    ENTRY_INTERNAL;
    for (unsigned int i = 0; i < m_AppInfos.size(); i++) {
        if (m_AppInfos[i].sessionID > 0 ) {
            list.push_back(string(m_AppInfos[i].appName));
        }
    }
}

void iPodControlHandle::SetSessionIDByIndex(const tSessionID sessionId,
        const unsigned char protocolIndex, tAppName &appName) {
    ENTRY_INTERNAL;
    int appIndex = protocolIndex -1; //protocolIndex starts with 1
    if (appIndex >= 0 && appIndex < (int)m_AppInfos.size()) {
        m_AppInfos[appIndex].sessionID = sessionId;
        strncpy_r(appName, m_AppInfos[appIndex].appName, sizeof(appName));
    } else {
        ETG_TRACE_ERR(("%s invalid protocolIndex", __PRETTY_FUNCTION__));
        VARTRACE(protocolIndex);
        appName[0] = 0;
    }
}

void iPodControlHandle::ClearSessionID(const tSessionID sessionId,
        tAppName &appName) {
    ENTRY_INTERNAL;
    tBoolean foundID = false;
    for (unsigned int i = 0; i < m_AppInfos.size(); i++) {
        if (m_AppInfos[i].sessionID == sessionId) {
            foundID = true;
            m_AppInfos[i].sessionID = 0;
            strncpy_r(appName, m_AppInfos[i].appName, sizeof(appName));
            break;
        }
    }
    if (!foundID) {
        ETG_TRACE_ERR(("%s invalid sessionId",  __PRETTY_FUNCTION__));
        VARTRACE(sessionId);
        appName[0] = 0;
    }
}

void iPodControlHandle::GetAppNameBySessionID(const tSessionID sessionId,
        tAppName &appName) {
    ENTRY_INTERNAL;
    tBoolean foundID = false;
    for (unsigned int i = 0; i < m_AppInfos.size(); i++) {
        if (m_AppInfos[i].sessionID == sessionId) {
            foundID = true;
            strncpy_r(appName, m_AppInfos[i].appName, sizeof(appName));
            break;
        }
    }
    if (!foundID) {
        ETG_TRACE_ERR(("%s invalid sessionId", __PRETTY_FUNCTION__));
        VARTRACE(sessionId);
        appName[0] = 0;
    }
}

void iPodControlHandle::GetAppNameByProtocolID(const unsigned char protocolId, tAppName &appName,
        tSessionID &sessionId) {
    ENTRY_INTERNAL;
    int appIndex = protocolId -1; //protocolIndex starts with 1
    if (appIndex >= 0 && appIndex < (int)m_AppInfos.size()) {
        sessionId = m_AppInfos[appIndex].sessionID;
        strncpy_r(appName, m_AppInfos[appIndex].appName, sizeof(appName));
    } else {
        ETG_TRACE_ERR(("Invalid protocol Index"));
        VARTRACE(protocolId);
        appName[0] = 0;
        sessionId = 0;
    }
}

void iPodControlHandle::GetProtocolNameByProtocolID(const unsigned char protocolId, tProtocolName &protocolName)
{
    ENTRY_INTERNAL;
    int appIndex = protocolId -1; //protocolIndex starts with 1
    if (appIndex >= 0 && appIndex < (int)m_AppInfos.size()) {
        strncpy_r(protocolName, m_AppInfos[appIndex].protocol, sizeof(protocolName));
    } else {
        ETG_TRACE_ERR(("Invalid protocol Index"));
        VARTRACE(protocolId);
        protocolName[0] = 0;
    }
}

void iPodControlHandle::TraceOptions()
{
    ENTRY_INTERNAL;
    ETG_TRACE_USR3(("*******************************"));
#ifdef TARGET_BUILD
    ETG_TRACE_USR3(("*** TARRGET BUILD"));
#else
    ETG_TRACE_USR3(("*** NO TARGET BUILD"));
#endif
#ifdef TARGET_BUILD_GEN3
    ETG_TRACE_USR3(("*** GEN3"));
#else
    ETG_TRACE_USR3(("*** GEN2"));
#endif
    ETG_TRACE_USR3(("*** IAP1 SUPPORT: %d", LocalSPM::GetDataProvider().iPodControlSupportIAP1()));
    ETG_TRACE_USR3(("*** IAP2 SUPPORT: %d", LocalSPM::GetDataProvider().iPodControlSupportIAP2()));
    ETG_TRACE_USR3(("*******************************"));
    ETG_TRACE_USR3(("*** IPOD FEATURE OPTIONS 0x%08x",     m_Options));
    ETG_TRACE_USR3(("*** hasIAP2Option          %s", GetOption(hasIAP2Option) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasVideoOption         %s", GetOption(hasVideoOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasTrackInfoOption     %s", GetOption(hasTrackInfoOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasTaggingOption       %s", GetOption(hasTaggingOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasAlbumArtOption      %s", GetOption(hasAlbumArtOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasDeselectDBOption    %s", GetOption(hasDeselectDBOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasPlaySelectionOption %s", GetOption(hasPlaySelectionOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasPlayPauseOption     %s", GetOption(hasPlayPauseOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasAppLaunchOption     %s", GetOption(hasAppLaunchOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasExtPlayStatusOption %s", GetOption(hasExtPlayStatusOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasRemoteControlOption %s", GetOption(hasRemoteControlOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasDisplayImageOption  %s", GetOption(hasDisplayImageOption) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*** hasBluetoothiAP2Link   %s", GetOption(hasBluetoothiAP2Link) ? "YES" : "NO"));
    ETG_TRACE_USR3(("*******************************"));
}
