/*
 * GracenoteProxy.cpp
 *
 *  Created on: July 19, 2017
 *      Author: abinaya(abc1cob)
 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CDRIPPER_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/GracenoteProxy.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CDRIPPER_CONTROL
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

#include <netinet/in.h>

#include "GracenoteProxy.h"
#include "GracenoteIpcIF.h"
#include "LocalSPM.h"
#include <iostream>
#include <sstream>
#include <string>


GracenoteProxy& GracenoteProxy::GetInstance(void)
{
    static GracenoteProxy instance;
    return instance;
}

GracenoteProxy::GracenoteProxy(void)
{

    mMessageHandlersMutex.lock();
    mMessageHandlers.clear();
    mMessageHandlersMutex.unlock();
    //mSMObserver = CD_RIPPER;
    mIsCDRipperControlActive = false;
}

void GracenoteProxy::setRipperControlState(bool bIsActive)
{
    if(bIsActive)
    {
        mIsCDRipperControlActive = true;
    }
    else
    {
        mIsCDRipperControlActive = false;
    }
}

bool GracenoteProxy::belongs(const char* messageName, const char* params)
{
    //ENTRY
    return false;
}

bool GracenoteProxy::belongs(tU32 serial)
{
    mMessageHandlersMutex.lock();

    if(mMessageHandlers.empty())
    {
        mMessageHandlersMutex.unlock();
        return false;
    }

    if (mMessageHandlers.find(serial) == mMessageHandlers.end())
    {
        mMessageHandlersMutex.unlock();
        return false;
    }
    else
    {
        mMessageHandlersMutex.unlock();
        return true;
    }
}

void GracenoteProxy::RouteSignal(const char* name, const char* params)
{
    ENTRY

    ETG_TRACE_USR1(("GracenoteProxy signal received %128s:%s",name,params));
}

void GracenoteProxy::RouteMethodAnswer(tU32 serial, const char* params)
{
    ENTRY

    mMessageHandlersMutex.lock();
    (this->*mMessageHandlers[serial])(params,false);

    //Erase the Entry giving the Key as it is no more needed
    mMessageHandlers.erase(serial);
    mMessageHandlersMutex.unlock();
}

void GracenoteProxy::RouteMethodRequest(tU32 serial, const char* name, const char* params)
{
    (void)serial;
    (void)name;
    (void)params;
}

void GracenoteProxy::RouteError(tU32 serial, const char* error)
{
    ENTRY

    mMessageHandlersMutex.lock();
    (this->*mMessageHandlers[serial])(error,true);

    //Erase the Entry giving the Key as it is no more needed
    mMessageHandlers.erase(serial);
    mMessageHandlersMutex.unlock();
}


/*Method calls to Gracenote Agent*/
tResult GracenoteProxy::InitSettingsMethodCall(tGracenoteLookupMode lookupMode )
{

    ENTRY

    tResult ret = MP_NO_ERROR;
    tInteger serial = 0;


        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Gracenote_InitSettings, IN (tS16)lookupMode );
        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            ret = MP_ERR_DBUS;
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &GracenoteProxy::InitSettingsMethodReturn;
            mMessageHandlersMutex.unlock();
        }

    return ret;
}
tResult GracenoteProxy::FetchAlbumInfoMethodCall(tU32 numberOfTracks,tStartAddressArray startingAddress)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tInteger serial = 0;
    std::string TOCInfo;
    for(unsigned int i = 0; i <= numberOfTracks ; i++)
    {
        if(i != 0)
        {
            TOCInfo += " ";
        }
        else
        {
            startingAddress[i] = 150;
        }
        VARTRACE(startingAddress[i]);
        TOCInfo += std::to_string((startingAddress[i]));
    }
    VARTRACE((char*)TOCInfo.c_str());
    serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Gracenote_FetchAlbumInfo,(char*)TOCInfo.c_str());
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &GracenoteProxy::FetchAlbumInfoMethodReturn;
        mMessageHandlersMutex.unlock();
    }

    return ret;
}
tResult GracenoteProxy::FetchAlbumInfoMethodCall(const char* TOCInfo)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tInteger serial = 0;
    VARTRACE(TOCInfo);
    serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Gracenote_FetchAlbumInfo,TOCInfo);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &GracenoteProxy::FetchAlbumInfoMethodReturn;
        mMessageHandlersMutex.unlock();
    }

    return ret;
}
tResult GracenoteProxy::FetchMetadataInfoMethodCall(tU32 albumID)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tInteger serial = 0;


        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Gracenote_FetchMetadataInfo, (tS16)albumID);
        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            ret = MP_ERR_DBUS;
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &GracenoteProxy::FetchMetadataInfoMethodReturn;
            mMessageHandlersMutex.unlock();
        }

    return ret;
}

tResult GracenoteProxy::FetchAlbumArtInfoMethodCall(const tAlbumArtPath albumArtPath,tU32 albumID)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tInteger serial = 0;

        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Gracenote_FetchAlbumArtInfo, (tS16)albumID ,(char*)albumArtPath);
        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            ret = MP_ERR_DBUS;
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &GracenoteProxy::FetchAlbumArtInfoMethodReturn;
            mMessageHandlersMutex.unlock();
        }

    return ret;
}
/*Method calls to Gracenote Agent*/
void  GracenoteProxy::InitSettingsMethodReturn(const char* params,bool isError)
{
    ENTRY

     tAllParameters parameterString;
     size_t size = sizeof(parameterString);
      unsigned int  InitResult = 0;

     if(isError)
     {
         ETG_TRACE_ERR(("InitSettingsMethodReturn Failed with error %s",params));
     }
     //Pointers for the Null terminated Char array received

     //Variables to Parse and retrieve the variables from the Null terminated Char array received

     //Find the Status of Response
     else
     {
         if(strlen(params))
         {
             ETG_TRACE_USR4(("params:%s",params));
             sscanf(params,"%d",&InitResult);
             ETG_TRACE_USR4(("InitResult:%d",InitResult));
         }
         else
         {
             //Do Nothing
         }
     }

     tResult ret = MP_NO_ERROR;
     ret = LocalSPM::GetInstance().GetCDRipperControl().ParameterGRACENOTE_INIT(OUT parameterString,IN size,(tGracenoteInitStatus)InitResult);


     if( MP_NO_ERROR != ret )
     {
         ETG_TRACE_ERR(("Error while preparing parameter string"));
     }
     else
     {
        ret = LocalSPM::GetCDRipperControl().SendEventByName( IN "GRACENOTE_INIT", IN parameterString);

         if( MP_NO_ERROR != ret )
         {
             ETG_TRACE_ERR(("Error while sending internal event via SMF"));
         }
     }
}

void  GracenoteProxy::FetchAlbumInfoMethodReturn(const char* params,bool isError)
{
    ENTRY

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tS16 numberOfAlbums = 0;
        int mediaAgentErrorCodes = 0;
        char* albumString = NULL;
        if(isError)
        {
            ETG_TRACE_ERR(("FetchAlbumInfoMethodReturn Failed with error %s",params));
        }
        //Pointers for the Null terminated Char array received

        //Variables to Parse and retrieve the variables from the Null terminated Char array received

        //Find the Status of Response
        else
        {
            if(strlen(params))
            {
                ETG_TRACE_USR4(("params:%s",params));
              //  sscanf(params,"%hd,%ms,%hd",&numberOfAlbums,&albumString,&mediaAgentErrorCodes);
                std::istringstream ss(params);
                std::string token;
                int paramIndex = 0;
                while(std::getline(ss, token, ',')) {
                if(paramIndex == 0)
                {
                    stringstream convert(token);
                    convert >> numberOfAlbums;
                }
                if(paramIndex == 1)
                {
                    albumString = (char*) malloc (token.size()+1);
                    if(albumString)
                    {
                        strncpy_r(albumString,(char*)token.c_str(),token.size()+1);
                    }
                }
                if(paramIndex == 2)
                {
                    stringstream convert(token);
                    convert >> mediaAgentErrorCodes ;

                }
                paramIndex++;
                }
                ETG_TRACE_USR4(("numberOfAlbums:%d",numberOfAlbums));
                ETG_TRACE_USR4(("albumString:%s",albumString));
            }
            else
            {
                //Do Nothing
            }
        }

        tResult ret = MP_NO_ERROR;
        ret = LocalSPM::GetInstance().GetCDRipperControl().ParameterGRACENOTE_ALBUM_INFO(OUT parameterString,IN size,numberOfAlbums,albumString,(tGracenoteMediaErrorCodes)mediaAgentErrorCodes);


        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
           ret = LocalSPM::GetCDRipperControl().SendEventByName( IN "GRACENOTE_ALBUM_INFO", IN parameterString);

            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
}

void  GracenoteProxy::FetchMetadataInfoMethodReturn(const char* params,bool isError)
{
    ENTRY

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tS16 numberOfTracks = 0;
        char* metadataString = NULL;
        tS16 mediaAgentErrorCodes = 0;
        if(isError)
        {
            ETG_TRACE_ERR(("FetchMetadataInfoMethodReturn Failed with error %s",params));
        }
        //Pointers for the Null terminated Char array received

        //Variables to Parse and retrieve the variables from the Null terminated Char array received

        //Find the Status of Response
        else
        {
            if(strlen(params))
            {
                ETG_TRACE_USR4(("params:%s",params));
                //sscanf(params,"%ms,%hd",&metadataString,&mediaAgentErrorCodes);
                std::istringstream ss(params);
                std::string token;
                int paramIndex = 0;
                while(std::getline(ss, token, ',')) {
                if(paramIndex == 1)
                {
                    stringstream convert(token);
                    convert >> mediaAgentErrorCodes;
                }
                if(paramIndex == 0)
                {
                    metadataString = (char*) malloc (token.size()+1);
                    if(metadataString)
                    {
                        strncpy_r(metadataString,(char*)token.c_str(),token.size()+1);
                    }
                }
                paramIndex++;
                }
            }
            else
            {
                //Do Nothing
            }
        }

        tResult ret = MP_NO_ERROR;
       ret = LocalSPM::GetInstance().GetCDRipperControl().ParameterGRACENOTE_METADATA_INFO(OUT parameterString,IN size,metadataString,(tGracenoteMediaErrorCodes)mediaAgentErrorCodes);


        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
           ret = LocalSPM::GetCDRipperControl().SendEventByName( IN "GRACENOTE_METADATA_INFO", IN parameterString);

            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
}

void  GracenoteProxy::FetchAlbumArtInfoMethodReturn(const char* params,bool isError)
{
    ENTRY

     tAllParameters parameterString;
     size_t size = sizeof(parameterString);
     tS16 albumArtDownloadResult = 0;
     char* albumartFileName = NULL;
     int albumartFileSize = 0;


     if(isError)
     {
         ETG_TRACE_ERR(("FetchAlbumArtInfoMethodReturn Failed with error %s",params));
     }
     //Pointers for the Null terminated Char array received

     //Variables to Parse and retrieve the variables from the Null terminated Char array received

     //Find the Status of Response
     else
     {
         if(strlen(params))
         {
             ETG_TRACE_USR4(("params:%s",params));
            // sscanf(params,"%hd,%ms,%d",&albumArtDownloadResult,&albumartFileName,&albumartFileSize);
             std::istringstream ss(params);
             std::string token;
             int paramIndex = 0;
             while(std::getline(ss, token, ',')) {
             if(paramIndex == 0)
             {
                 stringstream convert(token);
                 convert >> albumArtDownloadResult;
             }
             if((paramIndex == 1) && (token.size() > 0))
             {
                 albumartFileName = (char*) malloc (token.size()+1);
                 if(albumartFileName)
                 {
                     memset(albumartFileName,0,token.size()+1);
                     strncpy_r(albumartFileName,(char*)token.c_str(),token.size()+1);
                 }
             }
             if(paramIndex == 2)
             {
                 stringstream convert(token);
                 convert >> albumartFileSize ;

             }
             paramIndex++;
             }
             ETG_TRACE_USR4(("bALbumArtDownloadResult:%d",albumArtDownloadResult));
         }
         else
         {
             //Do Nothing
         }
     }

     tResult ret = LocalSPM::GetInstance().GetCDRipperControl().ParameterGRACENOTE_ALBUM_ART_FETCHED(OUT parameterString,IN size,(tAlbumArtDownload)albumArtDownloadResult,albumartFileName,albumartFileSize);


     if( MP_NO_ERROR != ret )
     {
         ETG_TRACE_ERR(("Error while preparing parameter string"));
     }
     else
     {
         ret = LocalSPM::GetCDRipperControl().SendEventByName( IN "GRACENOTE_ALBUM_ART_FETCHED", IN parameterString);

         if( MP_NO_ERROR != ret )
         {
             ETG_TRACE_ERR(("Error while sending internal event via SMF"));
         }
     }
}


void GracenoteProxy::GetGracenoteVersion(tGracenoteVersion &version)
{
    ENTRY

       bool isSystemBus = 0;
       int reply_timeout = 1000;
       bool isError;
       string result;
       DbusParam interfaceNameParam;
       interfaceNameParam.type = DBUS_TYPE_STRING;
       interfaceNameParam.value.append(IPC_GRACENOTE_INTERFACE);
       DbusParam propertyNameParam;
       propertyNameParam.type = DBUS_TYPE_STRING;
       propertyNameParam.value.append("Version");

       DbusParamList dbusParamList;
       dbusParamList.push_back(interfaceNameParam);
       dbusParamList.push_back(propertyNameParam);
       LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipc_Gracenote_Get, IN dbusParamList,isSystemBus,reply_timeout,isError,result);
       strncpy_r(version,(char*)result.c_str(),result.size()+1);
       VARTRACE(version);
       return;
}
void GracenoteProxy::SetGracenoteDatabseLookUpMode(tGracenoteLookupMode lookupMode)
{
    ENTRY
    bool isSystemBus = 0;
    int reply_timeout = 1000;
    bool isError;
    string result;
    DbusParam interfaceNameParam;
    interfaceNameParam.type = DBUS_TYPE_STRING;
    interfaceNameParam.value.append(IPC_GRACENOTE_INTERFACE);
    DbusParam propertyNameParam1,propertyNameParam2,propertyNameParam3;


    propertyNameParam1.type = DBUS_TYPE_STRING;
    propertyNameParam1.value.append("LookUpMode");

    propertyNameParam2.type = DBUS_TYPE_VARIANT;

    propertyNameParam3.type = DBUS_TYPE_INT16;

    stringstream ss;
    ss << lookupMode;
    string lookupModeString = ss.str();

    propertyNameParam3.value.append(lookupModeString);
    propertyNameParam2.ParamList.push_back(propertyNameParam3);


    DbusParamList dbusParamList;
    dbusParamList.push_back(interfaceNameParam);
    dbusParamList.push_back(propertyNameParam1);
    dbusParamList.push_back(propertyNameParam2);

    LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipc_Gracenote_Set, IN dbusParamList,isSystemBus,reply_timeout,isError,result);

}
void GracenoteProxy::GetGracenoteDatabseLookUpMode(tGracenoteLookupMode &lookupMode)
{
    ENTRY

       bool isSystemBus = 0;
       int reply_timeout = 1000;
       bool isError;
       string result;
       DbusParam interfaceNameParam;
       interfaceNameParam.type = DBUS_TYPE_STRING;
       interfaceNameParam.value.append(IPC_GRACENOTE_INTERFACE);
       DbusParam propertyNameParam;
    propertyNameParam.type = DBUS_TYPE_STRING;
    propertyNameParam.value.append("LookUpMode");

       DbusParamList dbusParamList;
       dbusParamList.push_back(interfaceNameParam);
       dbusParamList.push_back(propertyNameParam);
       LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipc_Gracenote_Get, IN dbusParamList,isSystemBus,reply_timeout,isError,result);
       unsigned int u8lookupMode = atoi(result.c_str());
       lookupMode = (tGracenoteLookupMode)u8lookupMode;
}



