
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DEVICE_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/DeviceDispatcher.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DEVICE_CONTROL
#endif
#endif

#include "FunctionTracer.h"
#include "VarTrace.h"
#include "LocalSPM.h"
#include "Dispatcher.h"

#include "DeviceDispatcher.h"
#include "RequestResponseSM.h"

//SPM part

void DeviceDispatcher::Create()
{
    ENTRY

    /* Create the state machine */
    DeviceDispatcherSM::Create();

    CreateDone(0);
}

tResult DeviceDispatcher::Init(tInitReason reason)
{
    ENTRY
    VARTRACE(reason);

    /* Init the state machine */
    DeviceDispatcherSM::Init();
    SetAnswerTimeout(DEV_DISP_SM_ANSWER_TIMEOUT_MS); // Set general answer timeout

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);

    return InitDone(0);
}

tResult DeviceDispatcher::InitSM()
{
    ENTRY

    /* Initialize variables */
    m_NewContext.deviceType = DTY_UNKNOWN;
    m_NewContext.deviceID = DEVICE_ID_NOT_SET;
    m_NewContext.URL[0] = '\0';
    m_NewContext.mountPoint[0] = '\0';
    m_NewContext.uuid[0] = '\0';
    m_NewContext.handle = HANDLE_NONE;
    m_NewContext.position = 0;
    m_NewContext.streaming = false;

    m_OldContext.deviceType = DTY_UNKNOWN;
    m_OldContext.deviceID = DEVICE_ID_NOT_SET;
    m_OldContext.URL[0] = '\0';
    m_OldContext.mountPoint[0] = '\0';
    m_OldContext.uuid[0] = '\0';
    m_OldContext.handle = HANDLE_NONE;
    m_OldContext.position = 0;
    m_OldContext.streaming = false;

    m_LastError = REASON_OK;
    m_CurrentMuteState = MUS_DEMUTED;

    return MP_NO_ERROR;
}

tResult DeviceDispatcher::Run()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::Run"));

    LocalSPM::GetThreadFactory().Do(IN this, 0, NULL);

    return RunDone(0);
}

void DeviceDispatcher::Do(int functionID, void *ptr)
{
    ENTRY
    (void)functionID;
    (void)ptr;

    //set the threads name
    LocalSPM::GetThreadFactory().SetName(DeviceDispatcherSM::GetSMNameFull());

    //actual thread
    while(DeviceDispatcherSM::STATE_MACHINE_FINISHED != DeviceDispatcherSM::StateMachine_Main()){}
}

tResult DeviceDispatcher::Stop()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DeviceDispatcher::StopEventProcessed()
{
    ENTRY

    /* Send stop done to SPM in the transition to final state in state machine */
    return StopDone(0);
}

tResult DeviceDispatcher::Done()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN this);

    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DeviceDispatcher::DoneEventProcessed()
{
    ENTRY

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

char *DeviceDispatcher::GetSMStateName(OUT tGeneralString stateName, size_t size)
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}

//Playback control part

tResult DeviceDispatcher::StartAllocateAudioOutput(const tAudioOutputDevice audioOutputDevice)
{
    ENTRY
    VARTRACE(audioOutputDevice)
    ETG_TRACE_USR3(("DeviceDispatcher::StartAllocateAudioOutput audioOutputDevice:%s", CHECK_NULL(audioOutputDevice)));
#if 0
    char *szFunc = (char *)__PRETTY_FUNCTION__;
    ETG_TRACE_USR3(("%s", szFunc));
    char *pdest = strstr(szFunc, "(");
    if(pdest)
    {
        ETG_TRACE_USR3(("%s", pdest));
        *pdest = 0;
        ETG_TRACE_USR3(("%s", szFunc));
    }
#endif

    tResult ret = MP_NO_ERROR;

    /* Prepare Parameter string to set ALSA output device in DeviceControls */
    char msgToSendString[64];
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIPODControl().ParameterSET_OUTPUT_DEVICE(OUT parameterString, IN size, IN audioOutputDevice);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    /* Set ALSA output device to iPodControl */
    strncpy_r(OUT msgToSendString, IN "iPodControlSM::SET_OUTPUT_DEVICE", IN sizeof(msgToSendString));
    ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    /* Set ALSA output device to USBControl */
    strncpy_r(OUT msgToSendString, IN "USBControlSM::SET_OUTPUT_DEVICE", IN sizeof(msgToSendString));
    ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    if (LocalSPM::GetDataProvider().IsDeviceTypeSupported(DTY_MTP))
    {
        /* Set ALSA output device to MTPControl */
        strncpy_r(OUT msgToSendString, IN "MTPControlSM::SET_OUTPUT_DEVICE", IN sizeof(msgToSendString));
        ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    if (LocalSPM::GetDataProvider().IsDeviceTypeSupported(DTY_BLUETOOTH))
    {
        /* Set ALSA output device to BTControl */
        strncpy_r(OUT msgToSendString, IN "BTControlSM::SET_OUTPUT_DEVICE", IN sizeof(msgToSendString));
        ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    if (LocalSPM::GetDataProvider().IsDeviceTypeSupported(DTY_CDDA))
    {
        /* Set ALSA output device to CDDAControl */
        strncpy_r(OUT msgToSendString, IN "CDDAControlSM::SET_OUTPUT_DEVICE", IN sizeof(msgToSendString));
        ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    if (LocalSPM::GetDataProvider().ContentSharingEnabled())
    {
        /* Set ALSA output device to CSControl */
        strncpy_r(OUT msgToSendString, IN "CSControlSM::SET_OUTPUT_DEVICE", IN sizeof(msgToSendString));
        ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
#if 0   //Is also sent by MediaEngineSM::PLAY request of each device control
        /* Set ALSA output device to MediaEngine too */
        strncpy_r(OUT msgToSendString, IN "MediaEngineSM::SET_OUTPUT_DEVICE", IN sizeof(msgToSendString));
        ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
#endif

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tReturnValue returnValue = true;

        ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(IN METHOD_RETURN, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    } else {

        /* Send AssignAudioInputDevice to PlayerEngine via DBUS */
        RegisterReleaseEvent(METHOD_RETURN);
        ret = LocalSPM::GetIPCProvider().AssignAudioOutputDevice(IN this, IN audioOutputDevice);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::AssignAudioOutputDevice (ErrorCode:%s)", errorString(ret)));
        }
    }

    CheckCarPlayResume();

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DeviceDispatcher::CheckCarPlayResume()
{
    ENTRY;

    if(LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled()) {
        //check for DiPPStopReson suspended
        const tDiPOStopReason diPOStopReason = (tDiPOStopReason)LocalSPM::GetDataProvider().DiPOStopReason();
        VARTRACE(diPOStopReason);
        if(diPOStopReason == DIPO_STOP_REASON_SOURCE_SUSPENDED) {
            //get active device
            tDeviceInfo deviceInfo;
            if(MP_NO_ERROR == LocalSPM::GetCustomControl().ActiveMediaDeviceGet(deviceInfo) ) {
                //check active device for CarPlay
                VARTRACE(deviceInfo.deviceID);
                if(IsAppleDevice(deviceInfo.deviceType) && IsDiPOCapability_CarPlay(deviceInfo.diPOCaps)) {
                    //call SPI RESUME in order to UNBORROW iPhone audio
                    LocalSPM::GetOutputWrapper().ResumeMediaPlayback(IN deviceInfo.deviceID);
                }
            }
        }
    }
    return MP_NO_ERROR;
}

tResult DeviceDispatcher::StartDeAllocateAudioOutput()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartDeAllocateAudioOutput"));

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tReturnValue returnValue = true;

        ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(IN METHOD_RETURN, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
#if 0
        /* Send DeAllocateOutDevice to PlayerEngine via DBUS */
        RegisterReleaseEvent(METHOD_RETURN);
        ret = LocalSPM::GetIPCProvider().DeAllocateOutDevice(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::DeAllocateOutDevice (ErrorCode:%s)", errorString(ret)));
        }
#else
        //DeAllocateOutDevice not required since separate ALSA device AdevMP1Out
        //fixed parallel usage of playerengine [GMMY17-11719]
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tReturnValue returnValue = true;

        ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(IN METHOD_RETURN, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
#endif
    }

    return ret;
}

tResult DeviceDispatcher::StartIsDeviceTypeDifferent()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartIsDeviceTypeDifferent"));

    tResult ret = MP_NO_ERROR;

    /*
     * Send expected event to waiting state machine immediately
     */
    ret = SendEvent(IN DEVICE_TYPE_ANSWER, (char *)NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }
    return ret;
}

tResult DeviceDispatcher::IsDeviceTypeDifferent()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::IsDeviceTypeDifferent"));

    if(false == LocalSPM::GetDataProvider().ExclusiveAlsaDevice() ||
       false == LocalSPM::GetDataProvider().UseMediaEngine() ||
       IsAppleDevice(m_OldContext.deviceType) ||
       m_OldContext.deviceType == DTY_DVD_DRIVE ||
       m_OldContext.deviceType == DTY_BLUETOOTH) {

        return true;
    }

    tReturnValue returnValue = false;
    //tResult ret = MP_NO_ERROR;

    if((m_NewContext.deviceType != m_OldContext.deviceType)
       ||
       (REASON_RESTART_ERROR == m_LastError))
    {
        returnValue = true;
    }

#if 0
    /* Send GET_AUDIO_DEVICE_ANSWER(success=SC_YES) event */
    char msgToSendString[64];
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterGET_AUDIO_DEVICE_ANSWER(OUT parameterString, IN size, IN m_NewContext.deviceID, IN SC_YES);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    strncpy_r(OUT msgToSendString, IN "PlayerManagerSM::GET_AUDIO_DEVICE_ANSWER", IN sizeof(msgToSendString));
    ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }
#endif

    return returnValue;
}

tResult DeviceDispatcher::StartStopViaContext()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartStopViaContext (changed device & changed type)"));

    tResult ret = MP_NO_ERROR;

    /* Send STOP message to special device control SM */
    if((DEVICE_ID_NOT_SET != m_OldContext.deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN m_OldContext.deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, m_OldContext.deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::STOP", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterSTOP(OUT parameterString,
                IN size,
                IN m_OldContext.deviceType,
                IN m_OldContext.deviceID,
                IN m_OldContext.URL,
                IN m_OldContext.mountPoint);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::STOP_ANSWER", IN sizeof(answerMsgString));
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send STOP message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send STOP message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                m_OldContext.deviceID, m_OldContext.deviceType));

        ret = SendEvent(IN STOP_ANSWER, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartPauseViaContext()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartPauseViaContext (changed device & same type)"));

    tResult ret = MP_NO_ERROR;

    /* Send STOP message to special device control SM */
    if((DEVICE_ID_NOT_SET != m_OldContext.deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN m_OldContext.deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, m_OldContext.deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::PAUSE", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterSTOP(OUT parameterString,
                IN size,
                IN m_OldContext.deviceType,
                IN m_OldContext.deviceID,
                IN m_OldContext.URL,
                IN m_OldContext.mountPoint);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PAUSE_ANSWER", IN sizeof(answerMsgString));
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send PAUSE message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send STOP message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                m_OldContext.deviceID, m_OldContext.deviceType));

        ret = SendEvent(IN PAUSE_ANSWER, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}


tResult DeviceDispatcher::StartAllocateAudioInput()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartAllocateAudioInput"));

    tResult ret = MP_NO_ERROR;

    /* Send ALLOCATE_AUDIO_INPUT message to special device control SM */
    if((DEVICE_ID_NOT_SET != m_NewContext.deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN m_NewContext.deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, m_NewContext.deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::ALLOCATE_AUDIO_INPUT", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterALLOCATE_AUDIO_INPUT(OUT parameterString,
                IN size,
                IN m_NewContext.deviceID,
                IN m_NewContext.mountPoint);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::ALLOCATE_AUDIO_INPUT_ANSWER", IN sizeof(answerMsgString));
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send ALLOCATE_AUDIO_INPUT message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send ALLOCATE_AUDIO_INPUT message not necessary because of invalid parameter for new device -> deviceID: %u, deviceType: %u",
                m_NewContext.deviceID, m_NewContext.deviceType));

        ret = SendEvent(IN ALLOCATE_AUDIO_INPUT_ANSWER, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartSwitchObserver()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartSwitchObserver"));

    tResult ret = MP_NO_ERROR;

    /* Send SWITCH_OBSERVER message to special device control SM */
    if((DEVICE_ID_NOT_SET != m_NewContext.deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN m_NewContext.deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, m_NewContext.deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::SWITCH_OBSERVER", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterSWITCH_OBSERVER(OUT parameterString,
                IN size,
                IN m_NewContext.deviceID,
                IN m_NewContext.mountPoint);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::SWITCH_OBSERVER_ANSWER", IN sizeof(answerMsgString));
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send SWITCH_OBSERVER message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send SWITCH_OBSERVER message not necessary because of invalid parameter for new device -> deviceID: %u, deviceType: %u",
                m_NewContext.deviceID, m_NewContext.deviceType));

        ret = SendEvent(IN SWITCH_OBSERVER_ANSWER, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartPlay()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartPlay"));

    tResult ret = MP_NO_ERROR;

    /* Reset last error */
    m_LastError = REASON_OK;

    /* Send PLAY message to special device control SM */
    if((DEVICE_ID_NOT_SET != m_NewContext.deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN m_NewContext.deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        /* Create vector of tU64 (batchPlaybackListPtr) for batch play*/
        if((0 < m_NewContext.streaming) //=ListID
           &&
           (IsBatchPlayable(m_NewContext.deviceID)))
        {
            tListID listID = m_NewContext.streaming;
            VARTRACE(listID);
            //check ListType and filter out LTY_CURRENT_SELECTION
            tListInfo listInfo;
            tBoolean withListSize = false;
            ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while getting list info at ListControl (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                VARTRACE(listInfo.listType);
                if(listInfo.listType != LTY_CURRENT_SELECTION)
                {
                    tListSize maxListSize = LocalSPM::GetDataProvider().LimitNumberObjectsPerDevice();

                    /* Vector of tU64 (batchPlaybackListPtr) will be deleted in specific device control (iPodControl) */
                    tBatchPlaybackList *batchPlaybackListPtr = new tBatchPlaybackList;

                    if(batchPlaybackListPtr)
                    {
                        /* get all UUID's for the list */
                        ret = LocalSPM::GetListControl().RequestMediaPlayerIndexedUUIDListSlice(OUT batchPlaybackListPtr, IN listID, 0, maxListSize);

                        /* if at least one UUID was found ... */
                        if (ret == MP_NO_ERROR && batchPlaybackListPtr->size()) // CID 18100 (#1 of 1): Unused value (UNUSED_VALUE)
                        {
                            /* set the context uuid list pointer to be sent to the iPODControl */
                            snprintf(m_NewContext.uuid, sizeof(m_NewContext.uuid), "batchlist=%p", batchPlaybackListPtr);
                        }
                        else
                        {
                            /* no UUID found: delete the vector */
                            delete batchPlaybackListPtr;
                        }
                    }
                }
            }
        }

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, m_NewContext.deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::PLAY", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterPLAY(OUT parameterString,
                IN size,
                IN m_NewContext.deviceType,
                IN m_NewContext.deviceID,
                IN m_NewContext.URL,
                IN m_NewContext.mountPoint,
                IN m_NewContext.uuid,
                IN m_NewContext.handle,
                IN m_NewContext.position,
                IN m_NewContext.streaming);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAY_ANSWER_NEW", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAY_ANSWER", IN sizeof(answerMsgString));
        }
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send PLAY message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send PLAY message not necessary because of invalid parameter for new device -> deviceID: %u, deviceType: %u",
                m_NewContext.deviceID, m_NewContext.deviceType));

        ret = SendEvent(IN PLAY_ANSWER, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartStreaming()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartStreaming"));

    tResult ret = MP_NO_ERROR;

    /* Send START_STREAMING message to special device control SM */
    if((DEVICE_ID_NOT_SET != m_NewContext.deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN m_NewContext.deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, m_NewContext.deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::START_STREAMING", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterSTART_STREAMING(OUT parameterString,
                IN size,
                IN m_NewContext.deviceID,
                IN m_NewContext.mountPoint);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::START_STREAMING_ANSWER", IN sizeof(answerMsgString));
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send START_STREAMING message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send START_STREAMING message not necessary because of invalid parameter for new device -> deviceID: %u, deviceType: %u",
                m_NewContext.deviceID, m_NewContext.deviceType));

        ret = SendEvent(IN START_STREAMING_ANSWER, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartMute()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartMute"));

    tResult ret = MP_NO_ERROR;

    tMuteState currentMuteState = getMuteState();
    if((LocalSPM::GetDataProvider().MicroMutes()) && (!IsAppleDevice(m_NewContext.deviceType)) && (currentMuteState == MUS_DEMUTED))
    {
        /* Send mute request to AudioManagement via OutputWrapper */
        RegisterReleaseEvent(MUTE_ANSWER, (char *)NULL, 3000L);// Set special answer timeout

        tMuteState muteState = MUS_MUTED;
        ret = LocalSPM::GetOutputWrapper().RequestMuteState(IN muteState);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while requesting mute at OutputWrapper (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Go on -> Send expected event to waiting state machine immediately */
        ret = SendEvent(IN MUTE_ANSWER, NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartDemute()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartDemute"));
    ETG_TRACE_USR3(("DeviceDispatcher::StartDemute:position= %d", m_NewContext.position));
    tResult ret = MP_NO_ERROR;

    tMuteState currentMuteState = getMuteState();
    if((LocalSPM::GetDataProvider().MicroMutes()) && (!IsAppleDevice(m_NewContext.deviceType)) && (currentMuteState == MUS_MUTED))
    {
        /* Send demute request to AudioManagement via OutputWrapper if configured */
        //RegisterReleaseEvent(DEMUTE_ANSWER);
        //SetAnswerTimeout(3000L); // Set special answer timeout
        tMuteState muteState = MUS_DEMUTED;
        tRampType rampType = SLOW_RAMP ;
        if( tPosition_init == m_NewContext.position)
        {
            rampType = LocalSPM::GetDataProvider().UnmuteRampTypeForStartOfTrack();
        }
        ret = LocalSPM::GetOutputWrapper().RequestMuteState(IN muteState, IN rampType);

        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while requesting demute at OutputWrapper (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartStop(const tDeviceType deviceType,
                                    const tDeviceID deviceID,
                                    const tURL URL,
                                    const tMountPoint mountPoint)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartStop arg deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s",
          deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint)));

    ETG_TRACE_USR3(("DeviceDispatcher::StartStop old deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s",
          m_OldContext.deviceType, m_OldContext.deviceID, CHECK_NULL(m_OldContext.URL), CHECK_NULL(m_OldContext.mountPoint)));

    ETG_TRACE_USR3(("DeviceDispatcher::StartStop new deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s",
            m_NewContext.deviceType, m_NewContext.deviceID, CHECK_NULL(m_NewContext.URL), CHECK_NULL(m_NewContext.mountPoint)));

    //NCG3D-138082: Cleanup activity:Demute the source if there is any mute already done in this source to avoid issues in next source.
    if(LocalSPM::GetDataProvider().MicroMutes() && !IsAppleDevice(deviceType))
    {
        tMuteState currentMuteState = getMuteState();
        if(MUS_MUTED == currentMuteState)
        {
            ETG_TRACE_USR3(("Source is muted.Demute source before next playback"));
            StartDemute();
        }
    }
//DVD Start Pause behavior changed similar to other streaming devices , SA_PAUSE will behave like SA_OFF NCG3D-144026
    if(LocalSPM::GetDataProvider().ExclusiveAlsaDevice() &&
            LocalSPM::GetDataProvider().UseMediaEngine() &&
            !IsAppleDevice(deviceType) &&
            deviceType != DTY_BLUETOOTH &&
            deviceType != DTY_DVD_DRIVE
            )
    {
        tDeviceInfo deviceInfo;
        if(MP_NO_ERROR == LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID) &&
                true == deviceInfo.connected ) {

                ETG_TRACE_USR3(("DeviceDispatcher::StartStop:mapped to StartPause.  deviceInfo.connected = %d ( 1=true, 0=false)", deviceInfo.connected));
                return StartPause(deviceType, deviceID, URL, mountPoint);
        } else {

                ETG_TRACE_USR3(("DeviceDispatcher::StartStop:not connected.  deviceInfo.connected = %d ( 1=true, 0=false)", deviceInfo.connected));
            }

    } else {

        ETG_TRACE_USR3(("DeviceDispatcher::StartStop:not mapped to StartPause"));
    }

    tResult ret = MP_NO_ERROR;

    /* Send STOP message to special device control SM */
    if((DEVICE_ID_NOT_SET != deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::STOP", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterSTOP(OUT parameterString,
                IN size,
                IN deviceType,
                IN deviceID,
                IN URL,
                IN mountPoint);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(answerMsgString));
        }
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send STOP message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send STOP message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                deviceID, deviceType));

        ret = SendEvent(IN PLAYBACK_STATUS_RESPONSE, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Reset context parameters */
    ResetContext();

    return ret;
}

tResult DeviceDispatcher::StartPause(const tDeviceType deviceType,
                                     const tDeviceID deviceID,
                                     const tURL URL,
                                     const tMountPoint mountPoint)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartPause deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s",
          deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint)));

    tResult ret = MP_NO_ERROR;

    /* Send PAUSE message to special device control SM */
    if((DEVICE_ID_NOT_SET != deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::PAUSE", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterPAUSE(OUT parameterString,
                IN size,
                IN deviceType,
                IN deviceID,
                IN URL,
                IN mountPoint);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(answerMsgString));
        }
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send PAUSE message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send PAUSE message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                deviceID, deviceType));

        ret = SendEvent(IN PLAYBACK_STATUS_RESPONSE, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartPause()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartPause deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s",
            m_NewContext.deviceType, m_NewContext.deviceID, CHECK_NULL(m_NewContext.URL), CHECK_NULL(m_NewContext.mountPoint)));

    tResult ret = MP_NO_ERROR;

    /* Send PAUSE message to special device control SM */
    if((DEVICE_ID_NOT_SET != m_NewContext.deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN m_NewContext.deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, m_NewContext.deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::PAUSE", IN sizeof(msgToSendString));
        /*get the arguments from context*/
        ret = LocalSPM::GetUSBControl().ParameterPAUSE(OUT parameterString,
                IN size,
                IN m_NewContext.deviceType,
                IN m_NewContext.deviceID,
                IN m_NewContext.URL,
                IN m_NewContext.mountPoint);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(answerMsgString));
        }
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send PAUSE message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send PAUSE message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                m_NewContext.deviceID, m_NewContext.deviceType));

        ret = SendEvent(IN PLAYBACK_STATUS_RESPONSE, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartResume(const tDeviceType deviceType,
                                      const tDeviceID deviceID,
                                      const tURL URL,
                                      const tMountPoint mountPoint)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartResume deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s",
          deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint)));

    tResult ret = MP_NO_ERROR;

    /* Send RESUME message to special device control SM */
    if((DEVICE_ID_NOT_SET != deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::RESUME", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterRESUME(OUT parameterString,
                IN size,
                IN deviceType,
                IN deviceID,
                IN URL,
                IN mountPoint);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(answerMsgString));
        }
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send Resume message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send RESUME message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                deviceID, deviceType));

        ret = SendEvent(IN PLAYBACK_STATUS_RESPONSE, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartFfwdStart(const tDeviceType deviceType,
                                         const tDeviceID deviceID,
                                         const tURL URL,
                                         const tMountPoint mountPoint,
                                         const tCueingRate rate,
                                         const speedstate_e IsPlaybackSpeed)
{
    ENTRY

    ETG_TRACE_USR3(("DeviceDispatcher::StartFfwdStart deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, rate:%u, IsPlaybackSpeed:%u",
          deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint), rate, IsPlaybackSpeed));

    tResult ret = MP_NO_ERROR;

    /* Send FFWD message to special device control SM */
    if((DEVICE_ID_NOT_SET != deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::FFWD", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterFFWD(OUT parameterString,
                IN size,
                IN deviceType,
                IN deviceID,
                IN URL,
                IN mountPoint,
                IN rate,
                IN IsPlaybackSpeed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(answerMsgString));
        }
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send FFWD message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send FFWD message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                deviceID, deviceType));

        ret = SendEvent(IN PLAYBACK_STATUS_RESPONSE, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartFfwdStop(const tDeviceType deviceType,
                                        const tDeviceID deviceID,
                                        const tURL URL,
                                        const tMountPoint mountPoint,
                                        const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartFfwdStart deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s",
          deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint)));

    tResult ret = MP_NO_ERROR;

    /* Send FFWD_STOP message to special device control SM */
    if((DEVICE_ID_NOT_SET != deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::FFWD_STOP", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterFFWD_STOP(OUT parameterString,
                IN size,
                IN deviceType,
                IN deviceID,
                IN URL,
                IN mountPoint,
                IN IsPlaybackSpeed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(answerMsgString));
        }
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send FFWD_STOP message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send FFWD_STOP message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                deviceID, deviceType));

        ret = SendEvent(IN PLAYBACK_STATUS_RESPONSE, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartFrevStart(const tDeviceType deviceType,
                                         const tDeviceID deviceID,
                                         const tURL URL,
                                         const tMountPoint mountPoint,
                                         const tCueingRate rate,
                                         const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartFrevStart deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, rate:%u, IsPlaybackSpeed=%u",
          deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint), rate, IsPlaybackSpeed));

    tResult ret = MP_NO_ERROR;

    /* Send FREV message to special device control SM */
    if((DEVICE_ID_NOT_SET != deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::FREV", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterFREV(OUT parameterString,
                IN size,
                IN deviceType,
                IN deviceID,
                IN URL,
                IN mountPoint,
                IN rate,
                IN IsPlaybackSpeed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(answerMsgString));
        }
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send FREV message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send FREV message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                deviceID, deviceType));

        ret = SendEvent(IN PLAYBACK_STATUS_RESPONSE, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartFrevStop(const tDeviceType deviceType,
                                        const tDeviceID deviceID,
                                        const tURL URL,
                                        const tMountPoint mountPoint,
                                        const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartFrevStart deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s",
          deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint)));

    tResult ret = MP_NO_ERROR;

    /* Send FREV_STOP message to special device control SM */
    if((DEVICE_ID_NOT_SET != deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::FREV_STOP", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterFREV_STOP(OUT parameterString,
                IN size,
                IN deviceType,
                IN deviceID,
                IN URL,
                IN mountPoint,
                IN IsPlaybackSpeed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(answerMsgString));
        }
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send FREV_STOP message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send FREV_STOP message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                deviceID, deviceType));

        ret = SendEvent(IN PLAYBACK_STATUS_RESPONSE, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartSeekTo(const tDeviceType deviceType,
                                    const tDeviceID deviceID,
                                    const tURL URL,
                                    const tMountPoint mountPoint,
                                    const tPlaytime position)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartSeekTo deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, position:%u",
          deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint), position));

    tResult ret = MP_NO_ERROR;

    /* Send SEEK_TO message to special device control SM */
    if((DEVICE_ID_NOT_SET != deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::SEEK_TO", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterSEEK_TO(OUT parameterString,
                IN size,
                IN deviceType,
                IN deviceID,
                IN URL,
                IN mountPoint,
                IN position);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        //if(LocalSPM::GetDataProvider().UseMediaEngine())
        //{
            strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::PLAYTIME_STATUS", IN sizeof(answerMsgString));
        //}
        //else
        //{
        //    strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::TICK_TIME_ELAPSED", IN sizeof(answerMsgString));
        //}
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send SEEK_TO message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send SEEK_TO message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                deviceID, deviceType));

        ret = SendEvent(IN PLAYTIME_STATUS, (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::StartBuffer(const tDeviceType deviceType,
                                      const tDeviceID deviceID,
                                      const tURL URL,
                                      const tMountPoint mountPoint,
                                      const tPEHandle handle)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::StartBuffer deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s",
          deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint)));
    VARTRACE(handle);

    tResult ret = MP_NO_ERROR;

    /* Send BUFFER message to special device control SM */
    if((DEVICE_ID_NOT_SET != deviceID)
       &&
       (LocalSPM::GetDataProvider().IsDeviceTypeSupported(IN deviceType)))
    {
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        tDeviceControlName deviceControlName;
        GetDeviceControlName(deviceControlName, deviceType);

        strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
        strncat_r(OUT msgToSendString, IN "::BUFFER", IN sizeof(msgToSendString));

        ret = LocalSPM::GetUSBControl().ParameterBUFFER(OUT parameterString,
                IN size,
                IN deviceType,
                IN deviceID,
                IN URL,
                IN mountPoint,
                IN handle);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        strncpy_r(OUT answerMsgString, IN "DeviceDispatcherSM::BUFFER_ANSWER", IN sizeof(answerMsgString));

        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send BUFFER message not necessary ->
         * Fake device control SM response: Send expected event to waiting state machine immediately
         */
        ETG_TRACE_USR4(("Send BUFFER message not necessary because of invalid parameter for current device -> deviceID: %u, deviceType: %u",
                deviceID, deviceType));

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tSuccess success = SC_NO;

        ret = ParameterBUFFER_ANSWER(OUT parameterString, IN size, IN success);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(BUFFER_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::ActionStatus(const tReturnValue returnValue)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::ActionStatus returnValue:%u", returnValue));

    tResult ret = MP_NO_ERROR;

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterALLOCATE_ANSWER(OUT parameterString, IN size, IN returnValue);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DeviceDispatcher::PlaybackStatus(const tPEPlaybackState status)
{
    ENTRY

    tMetadata metadata = {0};
    tTitle title = {0};
    tMediaType mediaType = MTY_UNKNOWN;

    PlaybackStatusPlay(IN status, IN metadata, IN metadata, IN metadata, IN metadata, IN title, IN mediaType);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DeviceDispatcher::PlaybackStatusPlay(const tPEPlaybackState status,
                                         const tMetadata metadata1,
                                         const tMetadata metadata2,
                                         const tMetadata metadata3,
                                         const tMetadata metadata4,
                                         const tTitle metadataTitle,
                                         const tMediaType mediaType,
                                         const tConvertFlag metadataConvertFlag,
                                         const tUUID uuid)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::PlaybackStatusPlay status:%u, metadataTitle:%40s, mediaType:%u, convertFlag:%u, uuid:%40s",
            status, CHECK_NULL(metadataTitle), mediaType, metadataConvertFlag, CHECK_NULL(uuid)));
    ETG_TRACE_USR3(("DeviceDispatcher::PlaybackStatusPlay metadata1:%40s, metadata2:%40s, metadata3:%40s, metadata4:%s",
            CHECK_NULL(metadata1), CHECK_NULL(metadata2), CHECK_NULL(metadata3), CHECK_NULL(metadata4)));

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterPLAY_ANSWER(OUT parameterString,
            IN size,
            IN status,
            IN metadata1,
            IN metadata2,
            IN metadata3,
            IN metadata4,
            IN metadataTitle,
            IN mediaType,
            IN metadataConvertFlag,
            IN uuid);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DeviceDispatcher::PlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterPLAY_ANSWER_NEW(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

#if 0 //-> Obsolete event SEEK_TO_ANSWER
tResult DeviceDispatcher::PlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime)
{
    ENTRY
    VARTRACE2(elapsedPlaytime, totalPlaytime);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterSEEK_TO_ANSWER(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}
#endif

tResult DeviceDispatcher::PlaytimeStatusNew(const tPEHandle handle, const tDeviceID deviceID, const tPETimeInfo timeInfo)
{
    ENTRY
    (void)handle;
    (void)deviceID;
    (void)timeInfo;

    tResult ret = MP_NO_ERROR;

    // SEEK_TO_ANSWER_NEW event modified in PlayermanagerSM. It doenthave nay parameters. So call SendAnswer with NULL parameter.
    ret = SendAnswer(NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DeviceDispatcher::BufferStatus(const tSuccess success)
{
    ENTRY
    VARTRACE(success);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterBUFFER_ANSWER(OUT parameterString, IN size, IN success);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DeviceDispatcher::MuteStatus(const tMuteState muteState)
{
    ENTRY
    VARTRACE(muteState);

    tResult ret = MP_NO_ERROR;

    setMuteState(muteState);
    /* Sends the internal event MUTE_ANSWER if status is MUTED */
    if(MUS_MUTED == muteState)
    {
        ret = SendEvent(IN MUTE_ANSWER, NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DeviceDispatcher::SendMuteStatus(const tMuteState muteState)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::SendMuteStatus muteState:%u", muteState));

    tResult ret = MP_NO_ERROR;

    /* Send MUTE_STATUS message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterMUTE_STATUS(OUT parameterString, IN size, IN muteState);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(MUTE_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DeviceDispatcher::HandleAnswerTimeout()
{
    ENTRY
    ETG_TRACE_ERR(("DeviceDispatcher::HandleAnswerTimeout"));

    tResult ret = MP_NO_ERROR;

    /* Send releasing event to own waiting state machine */
    ret = ReleaseWaiting();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while releasing waiting via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DeviceDispatcher::MessageNotConsumed()
{
    ENTRY
    ETG_TRACE_ERR(("DeviceDispatcher::MessageNotConsumed"));

    #if 0 //Do not SendAnswer without reason, it may cause failure within communication to DeviceDispatcher
    /* Send answer to possible waiting state machine to release own SM in case of message answer pair*/
    tResult ret = SendAnswer(NULL);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }
#endif

    return MP_NO_ERROR;
}

tResult DeviceDispatcher::HandleStreamError(const me::reason_e reason)
{
    ENTRY
    //ETG_TRACE_USR3(("DeviceDispatcher::HandleStreamError reason:%u", reason));
    VARTRACE(reason);

    tResult ret = MP_NO_ERROR;

    /* Remember last error */
    if(REASON_OK > reason)
    {
        m_LastError = reason;
    }

    /* Send STREAM_ERROR message to PlayerManager */
    char messageString[64];
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    strncpy_r(OUT messageString, IN "PlayerManagerSM::STREAM_ERROR", IN sizeof(messageString));

    ret = LocalSPM::GetPlayerManager().ParameterSTREAM_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DeviceDispatcher::HandleActionError(const me::reason_e reason)
{
    ENTRY
    //ETG_TRACE_USR3(("DeviceDispatcher::HandleActionError reason:%u", reason));
    VARTRACE(reason);

    tResult ret = MP_NO_ERROR;

    /* Clear release event and disarm timer of own state machine in case of still waiting */
    ret = ClearReleaseEvent();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while clearing release event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    /* Remember last error */
    if(REASON_OK > reason)
    {
       if(REASON_DEVICE_ERROR == reason)
        {
            /* Reset context parameters */
            ResetContext();
        }
        else
        {
            m_LastError = reason;
        }

    }

    /* Send ACTION_ERROR message to PlayerManager */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendActionError(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DeviceDispatcher::IsDeviceDifferent()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::IsDeviceDifferent"));

    tReturnValue returnValue = false;

    /* Reset answer timeout to default */
    SetAnswerTimeout(DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    if((m_NewContext.deviceID != m_OldContext.deviceID)
       ||
       (REASON_RESTART_ERROR == m_LastError))
    {
        returnValue = true;
    }

    return returnValue;
}

tResult DeviceDispatcher::IsAllocateSuccessful(const tReturnValue returnValue)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::IsAllocateSuccessful returnValue:%u", returnValue));

    if(false == returnValue)
    {
        ETG_TRACE_ERR(("Allocate of audio output device failed!"));
    }

    return returnValue;
}

tResult DeviceDispatcher::IsDeAllocateSuccessful(const tReturnValue returnValue)
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::IsDeAllocateSuccessful returnValue:%u", returnValue));

    if(false == returnValue)
    {
        ETG_TRACE_ERR(("Deallocate of audio output device failed!"));
    }
    else
    {
        /* Reset context parameters */
        //ResetContext();
    }

    return returnValue;
}

tResult DeviceDispatcher::RouteMessageAnswer(const tDeviceType deviceType, const char *message, const char *parameter, const char *answer) const
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::RouteMessageAnswer deviceType:%u, message:%40s, parameter:%128s, answer:%s",
            deviceType, CHECK_NULL(message), CHECK_NULL(parameter), CHECK_NULL(answer)));

    tResult ret = MP_NO_ERROR;

    tDeviceControlName deviceControlName;
    GetDeviceControlName(deviceControlName, deviceType);

    char msgToSendString[64];
    strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
    strncat_r(OUT msgToSendString, IN "::", IN sizeof(msgToSendString));
    strncat_r(OUT msgToSendString, IN message, IN sizeof(msgToSendString));

    ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameter, IN answer);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DeviceDispatcher::RouteMessage(const tDeviceType deviceType, const char *message, const char *parameter) const
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::RouteMessage deviceType:%u, message:%40s, parameter:%128s",
            deviceType, CHECK_NULL(message), CHECK_NULL(parameter)));

    tResult ret = MP_NO_ERROR;

    tDeviceControlName deviceControlName;
    GetDeviceControlName(deviceControlName, deviceType);

    char msgToSendString[64];
    strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
    strncat_r(OUT msgToSendString, IN "::", IN sizeof(msgToSendString));
    strncat_r(OUT msgToSendString, IN message, IN sizeof(msgToSendString));

    ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameter);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DeviceDispatcher::GetDeviceControlName(tDeviceControlName &name, const tDeviceType deviceType) const
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    if(name)
    {
    switch (deviceType)
        {
            case DTY_USB:
            case DTY_SD:
            case DTY_FLASH:
            case DTY_CDROM:
            case DTY_MUSICBOX:
                strncpy_r(OUT name, IN "USBControlSM", IN sizeof(name));
                break;
            case DTY_IPOD:
            case DTY_IPHONE:
                strncpy_r(OUT name, IN "iPodControlSM", IN sizeof(name));
                break;
            case DTY_MTP:
                strncpy_r(OUT name, IN "MTPControlSM", IN sizeof(name));
                break;
            case DTY_BLUETOOTH:
                strncpy_r(OUT name, IN "BTControlSM", IN sizeof(name));
                break;
            case DTY_CDDA:
                strncpy_r(OUT name, IN "CDDAControlSM", IN sizeof(name));
                break;
            case DTY_CS:
                strncpy_r(OUT name, IN "CSControlSM", IN sizeof(name));
                break;
            case DTY_DVD_DRIVE:
                strncpy_r(OUT name, IN "DVDControlSM", IN sizeof(name));
                break;
            default:
                strncpy_r(OUT name, IN "DeviceDispatcherSM", IN sizeof(name));
                break;
        }
    }

    return ret;
}

tResult DeviceDispatcher::StoreContext(const tDeviceType deviceType,
                                       const tDeviceID deviceID,
                                       const tURL URL,
                                       const tMountPoint mountPoint,
                                       const tUUID uuid,
                                       const tPEHandle handle,
                                       const tPlaytime position,
                                       const tStreaming streaming)
{
    ENTRY
    //ETG_TRACE_USR3(("DeviceDispatcher::StoreContext deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, uuid:%40s, position:%ums, streaming:%u",
    //        deviceType, deviceID, CHECK_NULL(URL), CHECK_NULL(mountPoint), CHECK_NULL(uuid), position, streaming));
    //VARTRACE(handle);

    m_OldContext = m_NewContext;

    m_NewContext.deviceType = deviceType;
    m_NewContext.deviceID = deviceID;
    strncpy_r(OUT m_NewContext.URL, IN URL, IN sizeof(m_NewContext.URL));
    strncpy_r(OUT m_NewContext.mountPoint, IN mountPoint, IN sizeof(m_NewContext.mountPoint));
    strncpy_r(OUT m_NewContext.uuid, IN uuid, IN sizeof(m_NewContext.uuid));
    m_NewContext.handle = handle;
    m_NewContext.position = position;
    m_NewContext.streaming = streaming;

    return MP_NO_ERROR;
}

tResult DeviceDispatcher::ResetContext()
{
    ENTRY
    ETG_TRACE_USR3(("DeviceDispatcher::ResetContext"));

    m_NewContext.deviceType = DTY_UNKNOWN;
    m_NewContext.deviceID = DEVICE_ID_NOT_SET;
    m_NewContext.URL[0] = '\0';
    m_NewContext.mountPoint[0] = '\0';
    m_NewContext.uuid[0] = '\0';
    m_NewContext.handle = HANDLE_NONE;
    m_NewContext.position = 0;
    m_NewContext.streaming = false;

    m_LastError = REASON_OK;

    return MP_NO_ERROR;
}

tResult DeviceDispatcher::SendUmount(tErrorCode &errorCode, const tDeviceID deviceID) const
{
    ENTRY;
    VARTRACE(deviceID);

    tResult ret = MP_NO_ERROR;
    errorCode = MP_ERR_UMOUNT_NOT_SUPPORTED;

    /* use a request / response state machine to request umount from the devicecontrol (usb/ipod/mtp etc) */
    class UmountRR: public RequestResponseSM {
        int HandleInitRequest() {
            SetAnswerTimeout(10000L); // Set special answer timeout for Umount request
            mResult = MP_NO_ERROR;
            return 0;
        }

        int HandleSuccessRequest(const char *allParameters) {
            if (!allParameters || strlen_r(allParameters) == 0) {
                /* set an error */
                mResult = MP_ERR_UMOUNT_ERROR;
            } else {
                /* read out the pointer to the umount result */
                UnMarshal(IN allParameters, "i", OUT &mResult);
            }
            return 0;
        }

        int HandleEntryWaitingRequest() {
            return 0;
        }
    public:
        tResult mResult;
    };

    /* it must always be a real device that is requested */
    if (deviceID == MY_MEDIA) return MP_NO_ERROR;

    /* get device infos to get the device type */
    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (ret) return ret;

    /* get the name of the device control to address the correct state machine */
    tDeviceControlName deviceControlName;
    ret = GetDeviceControlName(OUT deviceControlName, IN deviceInfo.deviceType);
    if (ret) return ret;

    /* compose the message name */
    char msgToSendString[64];
    strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
    strncat_r(OUT msgToSendString, IN "::UMOUNT", IN sizeof(msgToSendString));

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    ret = LocalSPM::GetUSBControl().ParameterUMOUNT(OUT parameterString, IN size, IN deviceID, IN deviceInfo.mountPoint);
    if (ret) return ret;

    UmountRR rrUmount;
    ret = rrUmount.DoEventAnswer(IN msgToSendString, IN parameterString);
    if (ret) return ret;

    errorCode = rrUmount.mResult;

    VARTRACE(errorCode);
    return ret;
}

tBoolean DeviceDispatcher::GetLastPlayedPath(const tDeviceID deviceID,OUT tPath lastPlayedPath)
{
    ENTRY;
    VARTRACE(deviceID);
    tBoolean ret = 0;

    /* it must always be a real device that is requested */
    tDeviceInfo deviceInfo;
    if (deviceID != MY_MEDIA && !LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID))
    {
        VARTRACE(deviceInfo.deviceType);
        switch (deviceInfo.deviceType)
        {
            case DTY_MTP:
                ret = LocalSPM::GetMTPControl().GetLastPlayedPath(deviceID,lastPlayedPath);
                ETG_TRACE_USR4(("DeviceDispatcher::GetLastPlayedPath  : %s ",lastPlayedPath));
                break;
            default:
                break;
        }
    }
    VARTRACE(ret);
    return ret;
}


tBoolean DeviceDispatcher::IsBatchPlayable(const tDeviceID deviceID)
{
    ENTRY;
    VARTRACE(deviceID);
    tBoolean ret = 0;

    /* it must always be a real device that is requested */
    tDeviceInfo deviceInfo;
    if (deviceID != MY_MEDIA && !LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID))
    {
        VARTRACE(deviceInfo.deviceType);
        switch (deviceInfo.deviceType)
        {
            case DTY_USB:
            case DTY_SD:
            case DTY_FLASH:
            case DTY_CDROM:
                ret = LocalSPM::GetUSBControl().IsBatchPlayable(deviceID);
                break;
            case DTY_IPOD:
            case DTY_IPHONE:
                ret = LocalSPM::GetIPODControl().IsBatchPlayable(deviceID);
                break;
            case DTY_MTP:
                ret = LocalSPM::GetMTPControl().IsBatchPlayable(deviceID);
                break;
            case DTY_BLUETOOTH:
                ret = LocalSPM::GetBTControl().IsBatchPlayable(deviceID);
                break;
            case DTY_CDDA:
                ret = LocalSPM::GetCDDAControl().IsBatchPlayable(deviceID);
                break;
            case DTY_CS:
                ret = LocalSPM::GetCSControl().IsBatchPlayable(deviceID);
                break;
            default:
                break;
        }
    }
    VARTRACE(ret);
    return ret;
}

void DeviceDispatcher::setMuteState(const tMuteState muteState)
{
    m_CurrentMuteState =  muteState;
}

tMuteState DeviceDispatcher::getMuteState()
{
    return m_CurrentMuteState;
}
