
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DVD_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/DVDControlInterface.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DVD_CONTROL
#endif
#endif

#include "DVDControlInterface.h"
#include <stdio.h>
#include <string.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>
#include <fcntl.h>
#include "LocalSPM.h"
#include "TraceDefinitions.h"
#include "FunctionTracer.h"
#include "VarTrace.h"


 unsigned char m_dataBuffer[DATA_BUFFER_LENGTH];
 unsigned char m_resumeInfoBuffer[DATA_BUFFER_LENGTH];
 tScsiCmd scsiCmd;
 sg_io_hdr_t aSCSICommandBuffer;
 tCMDDataStruct m_CMDDataStruct;
 Lock m_Mutex;
 Lock m_CommandBufferMutex;
 Lock m_DeviceActiveLock;
 sem_t m_Semaphore;
 sem_t m_SemPoll;
 struct timespec semTime;
 bool m_bBackendMode;
 bool m_bPlaybackPossible;
 bool m_PlaybackStateChange = false;
 bool  m_bPolling = true;
 bool m_bOneTrackPlay = false;
 bool m_bOneTrackPlayPauseByUser = false;
 tDiscInfo m_discInfo;
 tPLayBackInfo m_PlayBackInfo;
 tDVDPlayBackState m_PlayBackState;
 bool m_BEModeSwitchToPause;
 tCDText mtrackInformation[CD_MAX_TRACK_NUMBER + 1];
 tU8 m_discType;
 tU8 m_discError;
 tU8 m_discMechanicalStatus;
 DVDControlInterfaceCallback *mCallbacks;
 tMountPoint m_MountPoint;
 tDVDSubtitleInfo subtitleInfo;
 tDVDAudioOutputInfo audioOutputInfo;
 tDVDAngleInfo angleInfo;
 tDVDAudioChannelInfo audioChannelInfo;
 tU8 audioInfoBuffer;
 tU8 m_aspectRatio;
 tDVDSetupInfo m_DVDSetupInfo;
 bool m_bSkipStatus;
 bool m_bButtonStatus;
 bool m_bOnSequenceStart;
 bool m_bKeyResponse = true;
 bool m_bIsDeviceActive = false;
 bool m_bThreadActive = false;
 bool m_bSendKeyCommandUpdate = false;
 bool m_bRevertToBEMode = false ;
 bool m_bSwitchModeResumeInfo = false;
 bool m_bDisablePolling = false;
 bool m_bMenuPlayback = false;
 bool m_bDataDisc = false;
tOperationModeStatus m_DriveMode = INVALID_MODE;
#define FUNCTION_ID_DVD_POLL               1
#define OP_INFO_DATA_LENGTH         0x40
#define DISC_INFO_DATA_LENGTH       0x18
#define CD_DEFAULT_TEXT_LENGTH 8
#define LUN 0
#define DRIVE_TO_HOST_DIRECTION 0x80
#define HOST_TO_DRIVE_DIRECTION 0x0
#define BACKEND_OPCODE 0xD0
#define REQUEST_SENSE_LENGTH          0x12
#define MAX_RETRY_COUNT 5
#define POLLING_FUNC_ID 1
#define VALUE_0XF0 0xF0
#define VALUE_0X0F 0x0F
unsigned char PowerOnCMD[5]={0x30,1,1,1,0};
#define PowerOnCMDLength 5
unsigned char PowerOffCMD[5]={0x30,1,0,1,0};
#define PowerOffCMDLength 5
unsigned char OperationInformationDataRequestcmd[3]={0x40,0,0xff};
#define OperationInformationDataRequestcmdLength 3
unsigned char DiscInformationDataRequestcmd[3]={0x40,0x01,0xff};
#define DiscInformationDataRequestcmdLength 3
unsigned char SetupInformationDataRequestCmd[3]={0xB0,0,0xFF};
#define SetupInformationDataRequestCmdLength 3
unsigned char SwitchtoBackendModeCmd[3]={0x30,0x03,0x01};
#define SwitchtoBackendModeCmdLength 3
unsigned char SwitchtoMassStorageModeCmd[3]={0x30,0x03,0x00};
#define SwitchtoMassStorageModeCmdLength 3
unsigned char SetupInformationDataSetCmd[0xA0]={0};
#define SetupInformationDataSetCmdLength 0xA0
unsigned char ResumeInformationDataSetCmd[5]={0};
#define ResumeInformationDataSetCmdLength 5
#define DataBufferLength 256
unsigned char DataBuffer[256]={0};
unsigned char LoadCMD[3]={0x30,0,0};
#define LoadCMDLength 3
unsigned char EjectCMD[3]={0x30,0,1};
#define EjectCMDLength 3
unsigned char CDTextTitleRequestcmd[6]={0x41,0,0,0,0,0x80};
unsigned char CDTextPerformerRequestcmd[6]={0x41,0,0,0,0,0x81};
unsigned char playbackModeKeyCMD[7]={0x50,0x0A,0,0,0,0,0};
int DvdVideoRegionCodeArray[7] = {0xFF, 0x01, 0x02 , 0x04 ,0x08 , 0x10 , 0x20 } ;
#define CDTextRequestcmdLength 6
#define LanguageIndex 4
#define TrackIndex 2
#define KeyCMDLength 2
#define KeyResponseCmdLength 3
#define TemperatureResponseLength 5
#define KeyCMDExtendedLength 4
#define playbackModeKeyCMDLength 7
#define PlaybackModeByte 2
#define ONETRACKPLAY 0x06
#define playBackTrackByte 6
#define htons(A) ((((unsigned short)(A) & 0xff00) >> 8) | \
        (((unsigned short)(A) & 0x00ff) << 8))

long resumeSize;


DVDControlInterface::DVDControlInterface()
{
    memset(m_OpInfoData,0,sizeof(m_OpInfoData));
    memset(mTOCResponseBuffer,0,sizeof(mTOCResponseBuffer));
    m_discType = 0x00;
    m_discMechanicalStatus = 0xff;
    m_discError =0x00;
    isResumeInformationSetupCompleted = false;
    m_bBackendMode = false;
    m_bPlaybackPossible = false;
    memset(mtrackInformation,0,sizeof(mtrackInformation));
    mTocRead = false;
    memset(&mToc,0,sizeof(mToc));
    mTrackCount = 0;
    m_BEModeSwitchToPause = true;
    m_bCDTextInfoRead = false;
    mCallbacks = NULL ;
    memset(m_MountPoint,0,sizeof(m_MountPoint));
    memset( &m_discInfo, 0, sizeof( m_discInfo));
    memset( &m_PlayBackInfo , 0 , sizeof( m_PlayBackInfo));
    memset( &m_PlayBackState , 0 , sizeof( m_PlayBackState));
    memset( &subtitleInfo , 0xff , sizeof( subtitleInfo));
    memset( &audioOutputInfo , 0xff , sizeof( audioOutputInfo));
    memset( &angleInfo , 0xff , sizeof( angleInfo));
    memset( &audioChannelInfo , 0xff , sizeof( audioChannelInfo));
    memset(m_resumeInfoBuffer, 0 ,DATA_BUFFER_LENGTH);
   // readResumeInfoFromFile();
    m_PlayBackInfo.m_playbackState = 0xFF;
    audioInfoBuffer = 0;
    m_aspectRatio = 0xff;
    m_bSkipStatus = false;
    m_bButtonStatus = false;
    m_DriveMode = INVALID_MODE;
    m_DVDSetupInfo.RegionCode = (tDvdVideoRegionCode)DvdVideoRegionCodeArray[0];
    m_DVDSetupInfo.DVDVideoAudioLang[0] = 0xFF;
    m_DVDSetupInfo.DVDVideoAudioLang[1] = 0xFF;
    m_DVDSetupInfo.DVDVideoSubtitleLang[0] = 0xFF;
    m_DVDSetupInfo.DVDVideoSubtitleLang[1] = 0xFF;
    m_DVDSetupInfo.DVDVideoMenuLang[0] = 0xFF;
    m_DVDSetupInfo.DVDVideoMenuLang[1] = 0xFF;
    m_DVDSetupInfo.DisplayMode = DEFAULT_DISPLAY_16_9;
    m_DVDSetupInfo.AngleMark = false;
    m_DVDSetupInfo.PlayStatus = false;
    m_DVDSetupInfo.VideoOutputmode = DEFAULT_DISPLAY_NTSC ;
    m_DVDSetupInfo.ComponentVideo = COMPONENT_VIDEO_MODE;
    m_DVDSetupInfo.downMixing = AUDIO_CHANNEL_STEREO_SUPPORT;
    m_DVDSetupInfo.DRCSetting = NORMAL_COMPRESSION;
    m_bOnSequenceStart = false;
    clearCDText();
}
void DVDControlInterface::readResumeInfoFromFile()
{
    ENTRY
    FILE * pFile;
    size_t result;

    pFile = fopen ( "resume.bin" , "rb" );
    if (pFile==NULL) {return ;};

    // obtain file size:
      fseek (pFile , 0 , SEEK_END);
      resumeSize = ftell (pFile);
      rewind (pFile);
    // copy the file into the buffer:
    result = fread (m_resumeInfoBuffer,1,resumeSize,pFile);

    ETG_TRACE_USR4((" DATA READ FROM FILE IS %x , resume size is  %x ",result,resumeSize));

    // terminate
    fclose (pFile);
    return ;
}
DVDControlInterface::~DVDControlInterface()
{
        memset(m_OpInfoData,0x00,sizeof(m_OpInfoData));
        memset(mTOCResponseBuffer,0x00,sizeof(mTOCResponseBuffer));
        m_discType = 0x00;
        m_discMechanicalStatus = 0xff;
        m_discError =0x00;
        isResumeInformationSetupCompleted = false;
        m_bBackendMode = false;
        m_bPlaybackPossible = false;
        memset(mtrackInformation,0x00,sizeof(mtrackInformation));
        mTocRead = false;
        memset(&mToc,0x00,sizeof(mToc));
        mTrackCount = 0;
        m_BEModeSwitchToPause = false;
        m_bCDTextInfoRead = false;
        memset(m_MountPoint,0x00,sizeof(m_MountPoint));
        memset( &m_PlayBackInfo , 0x00 , sizeof( m_PlayBackInfo));
        memset( &m_PlayBackState , 0x00 , sizeof( m_PlayBackState));
        memset( &subtitleInfo , 0xff , sizeof( subtitleInfo));
        memset( &audioOutputInfo , 0xff , sizeof( audioOutputInfo));
        memset( &angleInfo , 0xff , sizeof( angleInfo));
        memset( &audioChannelInfo , 0xff , sizeof( audioChannelInfo));
        mCallbacks = NULL ;
        resetToc();
        clearCDText();
        audioInfoBuffer = 0;
        m_aspectRatio = 0xff;
        m_bSkipStatus = false;
        m_bThreadActive = false;
}


int DVDControlInterface::DeInitialize()
{
    ENTRY
    int status = 0;
    int retryCount = 0;
    // semaphore post !!
    if(m_bPolling == false)
    {
        m_bPolling = true;
        sem_post(&m_SemPoll);
    }
    SwitchtoMassStorageMode();
    while((m_bBackendMode) && (retryCount < 20))
    {
        usleep(POLLING_TIMEOUT*4);
        retryCount++;
        VARTRACE(retryCount);
        VARTRACE(m_bBackendMode);
    }
    m_bThreadActive = false;
    return status;
}


void DVDControlInterface::PrepareResumeInformationDataSetCmd()
{
    ResumeInformationDataSetCmd[0]=0x60;
    ResumeInformationDataSetCmd[1]=0x01;
    ResumeInformationDataSetCmd[2]=0xFF;
    ResumeInformationDataSetCmd[3]=0x00;
    ResumeInformationDataSetCmd[4]=0x00;
}

void DVDControlInterface::PrepareSetupInformationDataSetCmd()
{

    SetupInformationDataSetCmd[0x00]=0x60;
    SetupInformationDataSetCmd[0x01]=0x00;
    SetupInformationDataSetCmd[0x02]=0xFF;
    SetupInformationDataSetCmd[0x03]= m_DVDSetupInfo.RegionCode;
    SetupInformationDataSetCmd[0x04]=PLAYER_DISC_SETTING;
    SetupInformationDataSetCmd[0x05]=OSD_SUPPORT;
    SetupInformationDataSetCmd[0x06]=0xFF;
    SetupInformationDataSetCmd[0x07]=POWER_ON_RESET;
    SetupInformationDataSetCmd[0x22]=0x01;
    SetupInformationDataSetCmd[0x42]=0x02;
    SetupInformationDataSetCmd[0x43]=m_DVDSetupInfo.DVDVideoAudioLang[0];
    SetupInformationDataSetCmd[0x44]=m_DVDSetupInfo.DVDVideoAudioLang[1];
    SetupInformationDataSetCmd[0x45]=m_DVDSetupInfo.DVDVideoSubtitleLang[0];
    SetupInformationDataSetCmd[0x46]=m_DVDSetupInfo.DVDVideoSubtitleLang[1];
    SetupInformationDataSetCmd[0x47]=m_DVDSetupInfo.DVDVideoMenuLang[0];
    SetupInformationDataSetCmd[0x48]=m_DVDSetupInfo.DVDVideoMenuLang[1];
    SetupInformationDataSetCmd[0x4B]=DEFAULT_INVALID;
    SetupInformationDataSetCmd[0x4C]=DEFAULT_INVALID;
    SetupInformationDataSetCmd[0x4D]='U';
    SetupInformationDataSetCmd[0x4E]='S';
    if(m_DVDSetupInfo.AngleMark == true)
    {
        SetupInformationDataSetCmd[0x50]=m_DVDSetupInfo.DisplayMode | ANGLE_MARK_ON;
    }
    else
    {
        SetupInformationDataSetCmd[0x50]=m_DVDSetupInfo.DisplayMode | ANGLE_MARK_OFF;
    }
    SetupInformationDataSetCmd[0x55]=AUDIO_FILE_SUPPORT;
    SetupInformationDataSetCmd[0x62]=0x03;
    SetupInformationDataSetCmd[0x64]=m_DVDSetupInfo.VideoOutputmode;
    if(m_DVDSetupInfo.PlayStatus == true)
    {
    SetupInformationDataSetCmd[0x66]=OSD_PLAY_STATUS_ON;
    }
    SetupInformationDataSetCmd[0x67]=0xFF;
    SetupInformationDataSetCmd[0x68]=m_DVDSetupInfo.ComponentVideo;
    SetupInformationDataSetCmd[0x82]=0x04;
    SetupInformationDataSetCmd[0x83]=m_DVDSetupInfo.downMixing;
    SetupInformationDataSetCmd[0x8A]=m_DVDSetupInfo.DRCSetting;
#if 0
    SetupInformationDataSetCmd[0x00]=0x60;
    SetupInformationDataSetCmd[0x01]=0x00;
    SetupInformationDataSetCmd[0x02]=0xFF;
    SetupInformationDataSetCmd[0x03]=0x02;
    SetupInformationDataSetCmd[0x04]=0x38;
    SetupInformationDataSetCmd[0x05]=0x08;
    SetupInformationDataSetCmd[0x06]=0xFF;
    SetupInformationDataSetCmd[0x07]=0x01;
    SetupInformationDataSetCmd[0x22]=0x01;
    SetupInformationDataSetCmd[0x42]=0x02;
    SetupInformationDataSetCmd[0x43]=0xFF;
    SetupInformationDataSetCmd[0x44]=0xFF;
    SetupInformationDataSetCmd[0x45]=0xFF;
    SetupInformationDataSetCmd[0x46]=0xFF;
    SetupInformationDataSetCmd[0x47]='n';
    SetupInformationDataSetCmd[0x48]='e';
    SetupInformationDataSetCmd[0x4B]=0xFF;
    SetupInformationDataSetCmd[0x4C]=0xFF;
    SetupInformationDataSetCmd[0x4D]='S';
    SetupInformationDataSetCmd[0x4E]='U';
    SetupInformationDataSetCmd[0x50]=0x40;
    SetupInformationDataSetCmd[0x55]=0xE0;
    SetupInformationDataSetCmd[0x62]=0x03;
    SetupInformationDataSetCmd[0x66]=0x80;
    SetupInformationDataSetCmd[0x67]=0xFF;
    SetupInformationDataSetCmd[0x68]=0xA0;
    SetupInformationDataSetCmd[0x82]=0x04;
    SetupInformationDataSetCmd[0x8A]=0xA0;
#endif
}

int  DVDControlInterface::SendSetupInformationData(bool queue)
{
    ENTRY
    int status = MP_NO_ERROR;
    PrepareSetupInformationDataSetCmd();
    if(queue)
    {
        status = ExecuteMessage(SetupInformationDataSetCmd,SetupInformationDataSetCmdLength);
    }
    else
    {
        status = SendBackEndCMDHostToDrive(SetupInformationDataSetCmd,SetupInformationDataSetCmdLength);
    }
    return status;
}

void  DVDControlInterface::StoreSetupInformationData(tDVDSetupInfo& setupInfo)
{
    ENTRY
    memcpy(&m_DVDSetupInfo , &setupInfo , sizeof(tDVDSetupInfo));
    return ;
}
tResult DVDControlInterface::ChangeSetupInformationData(tDVDSetupInfo& setupInfo)
{
    ENTRY
    memcpy(&m_DVDSetupInfo , &setupInfo , sizeof(tDVDSetupInfo));
    tResult status = SendSetupInformationData(true);
    return status;
}
void  DVDControlInterface::GetSetupInformationData(tDVDSetupInfo& setupInfo)
{
    ENTRY
    memcpy(&setupInfo , &m_DVDSetupInfo , sizeof(tDVDSetupInfo));
    return ;
}
int  DVDControlInterface::SendResumeInformationData()
{
    ENTRY
   // readResumeInfoFromFile();
    int status = MP_NO_ERROR;
    m_bSwitchModeResumeInfo = true;
    if(m_resumeInfoBuffer[0] != BE_COMMAND_RESPONSE_INFO)
    {
        PrepareResumeInformationDataSetCmd();
        status = SendBackEndCMDHostToDrive(ResumeInformationDataSetCmd,ResumeInformationDataSetCmdLength);
    }
    else
    {
        ETG_TRACE_USR4((" resume info data sent from db storage "));
        status = SendBackEndCMDHostToDrive(m_resumeInfoBuffer,sizeof(m_resumeInfoBuffer));
    }
    return status;
}
int  DVDControlInterface::SendDiscInformationDataRequest(bool queue)
{
    ENTRY
    int status = MP_NO_ERROR;
    if(queue)
    {
        status = ExecuteMessage(DiscInformationDataRequestcmd,DiscInformationDataRequestcmdLength);
    }
    else
    {
        status = SendBackEndCMDHostToDrive(DiscInformationDataRequestcmd,DiscInformationDataRequestcmdLength);
    }
    return status;
}
int  DVDControlInterface::SendOperInformationDataRequest(bool queue)
{
    ENTRY
    int status = MP_NO_ERROR;
    if(queue)
    {
        status = ExecuteMessage(OperationInformationDataRequestcmd,OperationInformationDataRequestcmdLength);
    }
    else
    {
        status = SendBackEndCMDHostToDrive(OperationInformationDataRequestcmd,OperationInformationDataRequestcmdLength);
    }
    return status;
}
void DVDControlInterface::StoreResumeInformationData(unsigned char* dataBuffer, unsigned int length , bool bDriveResumeInfo)
{
    ENTRY
    if((dataBuffer != NULL) && (length <= DATA_BUFFER_LENGTH))
    {
        memset(m_resumeInfoBuffer, 0 ,DATA_BUFFER_LENGTH);
        memcpy(m_resumeInfoBuffer,dataBuffer,length);
        if(bDriveResumeInfo)
        {
            m_resumeInfoBuffer[0] = BE_COMMAND_RESPONSE_INFO;
            /*  FILE * pFile = NULL;
              pFile = fopen ("resume.bin", "wb");
              if(pFile)
              {
              fwrite (m_resumeInfoBuffer , 1, length, pFile);
              ETG_TRACE_USR4((" DATA WRITTEN IN FILE IS %x ",length));
              fclose (pFile);
              }*/
            // signal call back
            if(mCallbacks)
            {
                mCallbacks->signalResumeInfo(m_resumeInfoBuffer);
            }

        }
        else
        {
           // printf("\n resume data stored at startup from db  is : \n");
        }
    }
    return;
}

int  DVDControlInterface::AnalyseCDTextResponse(unsigned char* dataBuffer , int bufferLength)
{
    ENTRY
    if(bufferLength < 0x20) // MINIMUM LENGTH REQUIRED
    {
        ETG_TRACE_USR4((" Text Info data length < 0x20 length is %x ",bufferLength));
        return -1;
    }
    else
    {

        if(dataBuffer[2] == TEXT_AVAILABLE)
        {
            unsigned char datalength = dataBuffer[0x1E];
            unsigned char trackIndex = dataBuffer[3];
            mtrackInformation[trackIndex].u8CharacterCode = dataBuffer[6];
            mtrackInformation[trackIndex].u8LanguageIndex = dataBuffer[5];
            if(datalength != 0)
            {
                if(dataBuffer[7] == CD_TEXT_TITLE)
                {
                        if(bufferLength >= (0x20+datalength))
                        {
                           //convert and copy
                            memcpy(mtrackInformation[trackIndex].u8Title,&dataBuffer[0x20] ,datalength);
                        }
                }
                else if(dataBuffer[7] == CD_TEXT_PERFORMER)
                {
                        if(bufferLength >= (0x20+datalength))
                        {
                            //convert and copy
                            memcpy(mtrackInformation[trackIndex].u8Performer, &dataBuffer[0x20] ,datalength);
                        }
                }
                mtrackInformation[trackIndex].valid = true;
            }
        }
        else
        {
            ETG_TRACE_USR4((" Text Info not available for track number %x type is %x ",dataBuffer[3] ,dataBuffer[7]));
            mtrackInformation[dataBuffer[3]].valid = true;
        }
    }
return MP_NO_ERROR;
}


int  DVDControlInterface::AnalyseDataRead(unsigned char* dataBuffer , int bufferLength)
{
    int status = MP_NO_ERROR;
    if (bufferLength < 1)
    {
        ETG_TRACE_USR4(("Response Data --No Data , buffer length is %d ", bufferLength));
        return -1 ;
    }
    else if ( dataBuffer[0] == BE_COMMAND_NULL_DATA )
    {
        ETG_TRACE_USR4(("Response Data --NULL Data %x", dataBuffer[0]));
        return 0;
    }
    else if (bufferLength > 1)
    {
        switch(dataBuffer[0]) {
            case BE_COMMAND_REQUEST_INFO:
            {
                switch(dataBuffer[1]) {
                    case BE_COMMAND_REQUEST_INFO_SETUP :
                    {
                        ETG_TRACE_USR4(("Response Data --Request Setup Info %x  %x", dataBuffer[0],dataBuffer[1]));
                        m_bOnSequenceStart = true;
                        usleep(POLLING_TIMEOUT);
                        status=SendSetupInformationData();
                        if(status!=MP_NO_ERROR)
                        {
                            ETG_TRACE_ERR(("SendSetupInformationData Failed"));
                        }
                    }
                    break;
                    case BE_COMMAND_REQUEST_INFO_RESUME:
                    {
                        ETG_TRACE_USR4(("Response Data --Request Resume Info %x  %x", dataBuffer[0],dataBuffer[1]));
                        usleep(POLLING_TIMEOUT);
                        status=SendResumeInformationData();
                        if(status!=MP_NO_ERROR)
                        {
                            ETG_TRACE_ERR(("SendResumeInformationData Failed"));
                        }
                    }
                    break;
                    default :
                        ETG_TRACE_USR4(("Response Data --Request Info unknown %x  %x", dataBuffer[0],dataBuffer[1]));
                }
            }
            break;
            case BE_COMMAND_COMP_NOTIFICATION:
            {
                switch(dataBuffer[1]) {
                    case BE_COMMAND_COMP_NOTIFICATION_SETUP :
                        ETG_TRACE_USR4(("Response Data --Setup Complete Notification %x  %x", dataBuffer[0],dataBuffer[1]));
                        AnalyzeSetupInformationData(dataBuffer, bufferLength);
                        break;
                    case BE_COMMAND_COMP_NOTIFICATION_RESUME:
                        ETG_TRACE_USR4(("Response Data --Resume Complete Notification %x  %x", dataBuffer[0],dataBuffer[1]));
                        if(!isResumeInformationSetupCompleted)
                        {
                            isResumeInformationSetupCompleted = true;
                            usleep(POLLING_TIMEOUT);
                            if((m_bSwitchModeResumeInfo == true) && (m_bBackendMode == false))
                            {
                            m_bSwitchModeResumeInfo = false;
                                //IF DATA DISC DO NOT SWITCH TO BACKEND MODE
                                //DVD CALL BACK EVENT FOR DATA DISC
                                if(m_bDataDisc == false)
                                {
                                    status = SwitchtoBackendMode(false);
                                }
                                else
                                {
                                    m_bDataDisc = false;
                                    if(mCallbacks)
                                    {
                                        mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,DISC_DATA);
                                    }
                                }
                            }
                        }
                        StoreResumeInformationData(dataBuffer, bufferLength , true);
                        break;
                    case BE_COMMAND_COMP_NOTIFICATION_FUNCTION:
                        ETG_TRACE_USR4(("Response Data --Function Complete Notification %x  %x", dataBuffer[0],dataBuffer[1]));
                        break;
                    default :
                        ETG_TRACE_USR4(("Response Data --Complete Notification unknown %x  %x", dataBuffer[0],dataBuffer[1]));
                }
            }
            break;
            case BE_COMMAND_RESPONSE_AUDIO_INFO:
            {
                ETG_TRACE_USR4(("Response Data --Audio info response %x  %x  %x", dataBuffer[0],dataBuffer[1],dataBuffer[2]));
                AnalyzeAudioInfoData(dataBuffer,bufferLength);
            }
            break;
            case BE_COMMAND_RESPONSE_DATA_INFO:
            {
                switch(dataBuffer[1]) {
                    case BE_COMMAND_RESPONSE_DATA_INFO_OPERATION :
                        ETG_TRACE_USR4(("Response Data --OPERATION INFORMATION DATA %x  %x", dataBuffer[0],dataBuffer[1]));
                        if(bufferLength==OP_INFO_DATA_LENGTH)
                        {
                            AnalyzeOperationInfoData(dataBuffer,bufferLength);

                        }else
                        {
                            ETG_TRACE_ERR(("OPERATION INFORMATION Length received wrongly %x  Expected%x", bufferLength,OP_INFO_DATA_LENGTH));
                        }
                        break;
                    case BE_COMMAND_RESPONSE_DATA_INFO_DISC:
                        if(bufferLength==DISC_INFO_DATA_LENGTH)
                        {
                            AnalyzeDiscInfoData(dataBuffer,bufferLength);

                        }else
                        {
                            ETG_TRACE_ERR(("DISC INFORMATION DATA Length received wrongly %x  Expected%x", bufferLength,DISC_INFO_DATA_LENGTH));
                        }
                        break;
                    case BE_COMMAND_RESPONSE_DATA_INFO_FOLDER:
                        ETG_TRACE_USR4(("Response Data --FOLDER INFORMATION DATA %x  %x", dataBuffer[0],dataBuffer[1]));
                        break;
                    case BE_COMMAND_RESPONSE_DATA_INFO_VERSION:
                        ETG_TRACE_USR4(("Response Data --VERSION INFORMATION DATA %x  %x", dataBuffer[0],dataBuffer[1]));
                        break;
                    case BE_COMMAND_RESPONSE_DATA_INFO_TEMPERATURE:
                        ETG_TRACE_USR4(("Response Data --TEMPERATURE INFORMATION DATA %x  %x", dataBuffer[0],dataBuffer[1]));
                        AnalyzeTemperatureResponse(dataBuffer,bufferLength);
                        break;
                    default :
                        ETG_TRACE_USR4(("Response Data --DATA INFORMATION unknown %x  %x", dataBuffer[0],dataBuffer[1]));
                }
            }
            break;
            case BE_COMMAND_RESPONSE_TEXT:
            {
                switch(dataBuffer[1]) {
                    case BE_COMMAND_RESPONSE_TEXT_CD :
                    {
                        ETG_TRACE_USR4(("Response Data --CD TEXT Response %x  %x", dataBuffer[0],dataBuffer[1]));
                        AnalyseCDTextResponse(dataBuffer,bufferLength);
                    }
                        break;
                    case BE_COMMAND_RESPONSE_TEXT_FILE_NAME:
                        ETG_TRACE_USR4(("Response Data --FILE NAME TEXT Response %x  %x", dataBuffer[0],dataBuffer[1]));
                        break;
                    case BE_COMMAND_RESPONSE_TEXT_FILE_INFO:
                        ETG_TRACE_USR4(("Response Data --FILE INFO TEXT Response %x  %x", dataBuffer[0],dataBuffer[1]));
                        break;
                    case BE_COMMAND_RESPONSE_TEXT_DVD_VR:
                        ETG_TRACE_USR4(("Response Data --DVD VR TEXT Response %x  %x", dataBuffer[0],dataBuffer[1]));
                        break;
                    default :
                        ETG_TRACE_USR4(("Response Data --TEXT INFORMATION unknown %x  %x", dataBuffer[0],dataBuffer[1]));
                }
            }
            break;
            case BE_COMMAND_RESPONSE_KEY:
            {
                ETG_TRACE_USR4(("Response Data --Key Command response %x  %x", dataBuffer[0],dataBuffer[1]));
                AnalyzeKeyResponse(dataBuffer,bufferLength);
            }
            break;
            default :
                ETG_TRACE_USR4(("Response Data --Unknown Data Response %x  %x", dataBuffer[0],dataBuffer[1]));
        }
        return status;
    }
    else
    {
        return MP_ERR_DVD_COMMAND_EXECUTION;
    }
}
void DVDControlInterface::AnalyzeKeyResponse(unsigned char* dataBuffer , int bufferLength)
{
    m_bKeyResponse = true ;
    ETG_TRACE_USR4(("\n  AnalyzeKeyResponse m_bKeyResponse is %x",m_bKeyResponse));
    if(bufferLength < KeyResponseCmdLength)
    {
        ETG_TRACE_ERR(("KeyResponseCmdLength received wrongly %x  Expected%x", bufferLength,KeyResponseCmdLength));
        return ;
    }
    if(m_bSendKeyCommandUpdate == true)
    {
        ETG_TRACE_USR4(("signalEvent DVD_EVENT_KEY_RESPONSE -  %x", dataBuffer[2]));
        if(mCallbacks)
        {
        mCallbacks->signalEvent(DVD_EVENT_KEY_RESPONSE ,dataBuffer[2]);
        }
        m_bSendKeyCommandUpdate = false;
    }
    return;

}

void DVDControlInterface::AnalyzeTemperatureResponse(unsigned char* dataBuffer , int bufferLength)
{
    ENTRY
    if(bufferLength < TemperatureResponseLength)
    {
        ETG_TRACE_ERR(("TemperatureResponseLength received wrongly %x  Expected%x", bufferLength,TemperatureResponseLength));
        return ;
    }

        ETG_TRACE_USR4(("signalEventTemperatureChange -  %x %x", dataBuffer[3],dataBuffer[4]));
        tU16 temperature = CD_8TO16(dataBuffer[3], dataBuffer[4]);
        if(mCallbacks)
        {
        mCallbacks->signalEventTemperatureChange(temperature);
        }
    return;

}

void DVDControlInterface::AnalyzeSetupInformationData(unsigned char* SetupInformationData , int bufferLength)
{
   ENTRY
    if(bufferLength < SetupInformationDataSetCmdLength)
    {
        ETG_TRACE_ERR(("SETUP INFORMATION Length received wrongly %x  Expected%x", bufferLength,SetupInformationDataSetCmdLength));
        return ;
    }

    m_DVDSetupInfo.RegionCode = (tDvdVideoRegionCode)SetupInformationData[0x03];
    ETG_TRACE_USR4(("AnalyseSetupInformationData"));
    ETG_TRACE_USR4((" RegionCode : %x", m_DVDSetupInfo.RegionCode));

    m_DVDSetupInfo.DVDVideoAudioLang[0]=SetupInformationData[0x43];
    m_DVDSetupInfo.DVDVideoAudioLang[1]=SetupInformationData[0x44];
    ETG_TRACE_USR4((" DVDVideoAudioLang : %x %x", m_DVDSetupInfo.DVDVideoAudioLang[0],m_DVDSetupInfo.DVDVideoAudioLang[1]));
    m_DVDSetupInfo.DVDVideoSubtitleLang[0]=SetupInformationData[0x45];
    m_DVDSetupInfo.DVDVideoSubtitleLang[1]=SetupInformationData[0x46];
    ETG_TRACE_USR4((" DVDVideoSubtitleLang : %x %x", m_DVDSetupInfo.DVDVideoSubtitleLang[0],m_DVDSetupInfo.DVDVideoSubtitleLang[1]));
    m_DVDSetupInfo.DVDVideoMenuLang[0]=SetupInformationData[0x47];
    m_DVDSetupInfo.DVDVideoMenuLang[1]=SetupInformationData[0x48];
    ETG_TRACE_USR4((" DVDVideoMenuLang : %x %x", m_DVDSetupInfo.DVDVideoMenuLang[0],m_DVDSetupInfo.DVDVideoMenuLang[1]));
    if((SetupInformationData[0x50] &  ANGLE_MARK_ON) == ANGLE_MARK_ON)
    {
        m_DVDSetupInfo.AngleMark = true;
    }
    else
    {
        m_DVDSetupInfo.AngleMark = false;
    }
    ETG_TRACE_USR4((" AngleMark : %x", m_DVDSetupInfo.AngleMark));
    m_DVDSetupInfo.DisplayMode = (tDisplaySetting)(SetupInformationData[0x50] & 0x03);
    ETG_TRACE_USR4((" DisplayMode : %x", m_DVDSetupInfo.DisplayMode));
    m_DVDSetupInfo.VideoOutputmode = (tVideoOutputMode)SetupInformationData[0x64];
    ETG_TRACE_USR4((" VideoOutputmode : %x", m_DVDSetupInfo.VideoOutputmode));
    if(SetupInformationData[0x66]  == OSD_PLAY_STATUS_ON)
    {
        m_DVDSetupInfo.PlayStatus = true;
    }
    else
    {
        m_DVDSetupInfo.PlayStatus = false;
    }
    ETG_TRACE_USR4((" PlayStatus : %x", m_DVDSetupInfo.PlayStatus));
    m_DVDSetupInfo.ComponentVideo = (tComponentVideoMode)SetupInformationData[0x68];
    ETG_TRACE_USR4((" ComponentVideo : %x", m_DVDSetupInfo.ComponentVideo ));
    m_DVDSetupInfo.downMixing = (tAudioChannelDownMixing)SetupInformationData[0x83];
    ETG_TRACE_USR4((" downMixing : %x", m_DVDSetupInfo.downMixing));
    m_DVDSetupInfo.DRCSetting = (tDRC)SetupInformationData[0x8A];
    ETG_TRACE_USR4((" DRCSetting : %x", m_DVDSetupInfo.DRCSetting));

    if(mCallbacks)
    {
    mCallbacks->signalEventSetupInfoChange(m_DVDSetupInfo);
    }
    return;

}
int  DVDControlInterface::AnalyzeOperationInfoData(unsigned char* dataBuffer , int bufferLength)
{

   int status = MP_NO_ERROR;
   if(m_discError != dataBuffer[4])
   {
       m_discError = dataBuffer[4];
       switch(dataBuffer[4]) {
        case DISC_NO_ERROR :
            ETG_TRACE_USR4(("OperationInfoData:DISC_NO_ERROR"));
            break;
        case DISC_DVD_VIDEO_REGION_CODE_ERROR:
            ETG_TRACE_USR4(("OperationInfoData:DISC_DVD_VIDEO_REGION_CODE_ERROR"));
            break;
        case DISC_DVD_VIDEO_PARENTAL_LEVEL_ERROR:
            ETG_TRACE_USR4(("OperationInfoData:DISC_DVD_VIDEO_PARENTAL_LEVEL_ERROR"));
            break;
        case DISC_DVD_DESCRAMBLE_FAILED :
            ETG_TRACE_USR4(("OperationInfoData:DISC_DVD_DESCRAMBLE_FAILED"));
            break;
        case DISC_READ_ERROR:
            ETG_TRACE_USR4(("OperationInfoData:DISC_READ_ERROR"));
            break;
        case DISC_UNKNOWN_ERROR:
            ETG_TRACE_USR4(("OperationInfoData:DISC_UNKNOWN_ERROR"));
            break;
        case DISC_UNKNOWN_CD_ERROR:
            ETG_TRACE_USR4(("OperationInfoData:DISC_UNKNOWN_CD_ERROR"));
            break;
        case DISC_UNKNOWN_DVD_ERROR:
            ETG_TRACE_USR4(("OperationInfoData:DISC_UNKNOWN_DVD_ERROR"));
            break;
        case DISC_UPDATE_DISC_ERROR :
            ETG_TRACE_USR4(("OperationInfoData:DISC_UPDATE_DISC_ERROR"));
            break;
        case DISC_MECHA_ERROR:
            ETG_TRACE_USR4(("OperationInfoData:DISC_MECHA_ERROR"));
            break;
        case DISC_HOT_ERROR:
            ETG_TRACE_USR4(("OperationInfoData:DISC_HOT_ERROR"));
            break;
        default :
            ETG_TRACE_USR4(("OperationInfoData:DISC_ERROR unidentified"));
            break;
    }
       if(mCallbacks)
       {
       mCallbacks->signalEvent(DVD_EVENT_DISC_ERROR,m_discError);
       }
   }
   if(m_discMechanicalStatus != dataBuffer[5])
   {
       m_discMechanicalStatus =  dataBuffer[5];
       switch(m_discMechanicalStatus) {

            case DISC_CHUCKING :
                ETG_TRACE_USR4(("OperationInfoData:DISC_CHUCKING"));
                break;
            case DURING_DISC_LOADING:
                ETG_TRACE_USR4(("OperationInfoData:DURING_DISC_LOADING"));
                break;
            case DISC_EJECT_FINISH_DISC_EXIST:
                ETG_TRACE_USR4(("OperationInfoData:DISC_EJECT_FINISH_DISC_EXIST"));
                m_BEModeSwitchToPause = true;
                clearCDText();
                ETG_TRACE_USR4(("OperationInfoData:m_BEModeSwitchToPause %x",m_BEModeSwitchToPause));
                break;
            case DURING_DISC_EJECT :
                ETG_TRACE_USR4(("OperationInfoData:DURING_DISC_EJECT"));
                break;
            case DISC_EJECT_FINISH_NO_DISC:
                ETG_TRACE_USR4(("OperationInfoData:DISC_EJECT_FINISH_NO_DISC"));
                m_BEModeSwitchToPause = true;
                clearCDText();
                ETG_TRACE_USR4(("OperationInfoData:m_BEModeSwitchToPause %x",m_BEModeSwitchToPause));
                break;
            case DISC_STOP:
                ETG_TRACE_USR4(("OperationInfoData:DISC_STOP"));
                break;
            case DISC_MECHANISM_UNDECIDED:
                ETG_TRACE_USR4(("OperationInfoData:DISC_MECHANISM_UNDECIDED"));
                break;
            default :
                ETG_TRACE_USR4(("OperationInfoData:DISC Mechanism unidentified"));
                break;
        }
       if(mCallbacks)
       {
       mCallbacks->signalEvent(DVD_EVENT_MECHANICAL_STATUS,m_discMechanicalStatus);
       }
   }
    if(m_discType != dataBuffer[6])
    {
        m_discType = dataBuffer[6];
        switch(m_discType) {

            case DISC_UNDECIDED :
                ETG_TRACE_USR4(("OperationInfoData:DISC_UNDECIDED"));
                break;
            case DISC_NONE:
                ETG_TRACE_USR4(("OperationInfoData:DISC_NONE"));
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_JUDGING:
                ETG_TRACE_USR4(("OperationInfoData:DISC_JUDGING"));
                break;
            case DISC_AUDIO_CD:
                ETG_TRACE_USR4(("OperationInfoData:DISC_AUDIO_CD"));
                audioOutputInfo.SoundFormat = 0xff; // reset it to invalid , ripping is now based on sound format
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_VCD_VER_1 :
                ETG_TRACE_USR4(("OperationInfoData:DISC_VCD_VER_1"));
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_VCD_VER_2_PBC_OFF:
                ETG_TRACE_USR4(("OperationInfoData:DISC_VCD_VER_2_PBC_OFF"));
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_SUPER_VCD_PBC_OFF:
                ETG_TRACE_USR4(("OperationInfoData:DISC_SUPER_VCD_PBC_OFF"));
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_VCD_VER_2_PBC_ON:
                ETG_TRACE_USR4(("OperationInfoData:DISC_VCD_VER_2_PBC_ON"));
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_SUPER_VCD_PBC_ON:
                ETG_TRACE_USR4(("OperationInfoData:DISC_SUPER_VCD_PBC_ON"));
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_DVD_VIDEO :
                ETG_TRACE_USR4(("OperationInfoData:DISC_DVD_VIDEO"));
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_DVD_AUDIO:
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_DVD_VR:
                ETG_TRACE_USR4(("OperationInfoData:DISC_DVD_VR"));
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case DISC_DATA:
                ETG_TRACE_USR4(("OperationInfoData:DISC_DATA"));
                if(mCallbacks)
                {
                mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                }
                break;
            case POWER_OFF:
                ETG_TRACE_USR4(("OperationInfoData:POWER_OFF"));
                break;
            case POWER_ON_STATE_SHIFT:
                ETG_TRACE_USR4(("OperationInfoData:POWER_ON_STATE_SHIFT"));
                break;
            case POWER_OFF_STATE_SHIFT:
                ETG_TRACE_USR4(("OperationInfoData:POWER_OFF_STATE_SHIFT"));
                break;
            default :
                ETG_TRACE_USR4(("OperationInfoData:DISC type unidentified"));
                break;
        }

    }
    if(m_DriveMode != dataBuffer[0x1b])
    {
        m_DriveMode = (tOperationModeStatus) dataBuffer[0x1b];
        ETG_TRACE_USR4(("OperationInfoData:Disc Mode Changed"));

        //SIGNAL EVENT
        if(mCallbacks)
        {
            mCallbacks->signalEvent(DVD_EVENT_DRIVEMODE,m_DriveMode);
        }
    }
    // Current operation mode of dvd drive
    switch(dataBuffer[0x1b])
    {
        case MASS_STORAGE_MODE:
        {
            ETG_TRACE_USR4(("OperationInfoData:Drive in Mass storage Mode"));
            if(m_bBackendMode == true)
            {
                m_bBackendMode = false;

            }
            if(m_bRevertToBEMode)
            {

                status = SwitchtoBackendMode(false);
                m_bRevertToBEMode = false;
                m_bDisablePolling = false;
            }
            else if(m_bDisablePolling  == true)
            {

                m_bPolling = false;
                m_bDisablePolling = false;
                ETG_TRACE_USR4(("\n #### read TOC m_bPOlling value %x \n",m_bPolling));
                usleep(POLLING_TIMEOUT * 2);

            }
        }
            break;
        case TRANSITION_TO_MASS_STORAGE_MODE:
            ETG_TRACE_USR4(("OperationInfoData:transition to Mass Storage Mode"));

            break;
        case BACKEND_MODE:
        {
            ETG_TRACE_USR4(("OperationInfoData:Drive in Back end Mode"));
            if(m_bBackendMode == false)
            {
                m_bBackendMode = true;

                m_BEModeSwitchToPause = true;
                ETG_TRACE_USR4(("OperationInfoData:m_BEModeSwitchToPause %x",m_BEModeSwitchToPause));
            }

        }
            break;
        case TRANSITION_TO_BACKEND_MODE:
            ETG_TRACE_USR4(("OperationInfoData:transition to Back end Mode"));
            break;
        default :
            ETG_TRACE_USR4(("OperationInfoData:DISC Mode unidentified"));
            break;
    }
    // Current playing  track/chapter information
    // 0E - OF -- TRACK
    m_PlayBackInfo.mCurrentTrackPlaying = CD_8TO16(dataBuffer[0x0E], dataBuffer[0x0F]);
    // 0C-0D -- GROUP
    m_PlayBackInfo.mCurrentGroupPlaying = CD_8TO16(dataBuffer[0x0C], dataBuffer[0x0D]);
    m_PlayBackInfo.currentTrackTotalHours = dataBuffer[0x39];
    m_PlayBackInfo.currentTrackTotalMinutes = dataBuffer[0x3A];
    m_PlayBackInfo.currentTrackTotalSeconds = dataBuffer[0x3B];
    m_PlayBackInfo.currentChapterRemHours = dataBuffer[0x36];
    m_PlayBackInfo.currentChapterRemMinutes = dataBuffer[0x37];
    m_PlayBackInfo.currentChapterRemSeconds = dataBuffer[0x38];
    m_PlayBackInfo.currentTrackIndex =  dataBuffer[0x24];
    m_PlayBackInfo.totalChapter = CD_8TO16(dataBuffer[0x10], dataBuffer[0x11]);
    if(m_PlayBackInfo.m_playbackState != dataBuffer[7])
    {
        m_bPlaybackPossible = true;
        m_PlaybackStateChange = true;
        m_PlayBackInfo.m_playbackState = dataBuffer[7];
        switch(dataBuffer[7])
        {
            case DVD_STOP :
               {
                ETG_TRACE_USR4(("OperationInfoData:STOP"));

                    if(m_BEModeSwitchToPause == true)
                     {
                         m_BEModeSwitchToPause = false;
                         ETG_TRACE_USR4(("OperationInfoData:m_BEModeSwitchToPause %x",m_BEModeSwitchToPause));

                     }
                }
                break;
            case RESUME_STOP:
            {
                ETG_TRACE_USR4(("OperationInfoData:RESUME_STOP"));
                if(m_BEModeSwitchToPause == true)
                     {
                    if(getDeviceActive() == true)
                    {
                        directPlay();
                    }
                        m_BEModeSwitchToPause = false;
                        ETG_TRACE_USR4(("OperationInfoData:m_BEModeSwitchToPause %x",m_BEModeSwitchToPause));

                     }
            }
                break;
            case DVD_PAUSE:
            {
                ETG_TRACE_USR4(("OperationInfoData:PAUSE"));
                // One track play moves to pause state by itself , hence this flag is used to trigger next song
                if(( m_bOneTrackPlay == true) && (m_bOneTrackPlayPauseByUser == false))
                {
                    #if 0
                    if((dataBuffer[0x26] == 0) && (dataBuffer[0x25] == 0) && (dataBuffer[0x24] == 0))
                    {
                    previous(false);
                    }
                    else
                    {
                    next(false);
                    }
                    #endif
                    directPlay();
                    m_bOneTrackPlay = false;
                }
                if(m_bOneTrackPlayPauseByUser == true)
                {
                    m_bOneTrackPlayPauseByUser = false;
                }

            }
                break;
            case DVD_PLAY :
            {
                ETG_TRACE_USR4(("OperationInfoData:PLAY"));
                ETG_TRACE_USR4(("OperationInfoData: %x",m_BEModeSwitchToPause));
                if(m_BEModeSwitchToPause == true)
                {
                    if(getDeviceActive() == false)
                    {
                        tResult stop_status = stop(false);
                    }
                    else
                    {
                        m_BEModeSwitchToPause = false;
                    }
                }

            }
                break;
            case PAUSE_PARENTAL_REQUEST:
                ETG_TRACE_USR4(("OperationInfoData:PAUSE_PARENTAL_REQUEST"));
                break;
            case AUTO_PAUSE_STILL:
                ETG_TRACE_USR4(("OperationInfoData:AUTO_PAUSE_STILL"));
                break;
            case FAST_FWD_1:
                ETG_TRACE_USR4(("OperationInfoData:FAST_FWD_1"));
                break;
            case FAST_FWD_2:
                ETG_TRACE_USR4(("OperationInfoData:FAST_FWD_2"));
                break;
            case FAST_FWD_3 :
                ETG_TRACE_USR4(("OperationInfoData:FAST_FWD_3"));
                break;
            case FAST_BWD_1:
                ETG_TRACE_USR4(("OperationInfoData:FAST_BWD_1"));
                break;
            case FAST_BWD_2:
                ETG_TRACE_USR4(("OperationInfoData:FAST_BWD_2"));
                break;
            case FAST_BWD_3:
                ETG_TRACE_USR4(("OperationInfoData:FAST_BWD_3"));
                break;
            case SLOW_FWD_1:
                ETG_TRACE_USR4(("OperationInfoData:SLOW_FWD_1"));
                break;
            case SLOW_FWD_2:
                ETG_TRACE_USR4(("OperationInfoData:SLOW_FWD_2"));
                break;
            case SLOW_FWD_3 :
                ETG_TRACE_USR4(("OperationInfoData:SLOW_FWD_3"));
                break;
            case SLOW_BWD_1:
                ETG_TRACE_USR4(("OperationInfoData:SLOW_BWD_1"));
                break;
            case SLOW_BWD_2:
                ETG_TRACE_USR4(("OperationInfoData:SLOW_BWD_2"));
                break;
            case SLOW_BWD_3:
                ETG_TRACE_USR4(("OperationInfoData:SLOW_BWD_3"));
                break;
            default :
            {
                ETG_TRACE_USR4(("OperationInfoData:PLAY BACK STATUS unidentified"));
                m_bPlaybackPossible = false;
                break;
            }

        }
        if(mCallbacks && m_bPlaybackPossible)
          {
              m_PlayBackInfo.PTimeHours = dataBuffer[0x24];
              m_PlayBackInfo.PTimeMinutes = dataBuffer[0x25];
              m_PlayBackInfo.PTimeSeconds = dataBuffer[0x26];
              ETG_TRACE_USR4(("\n PTime %x:%x:%x   \n" ,m_PlayBackInfo.PTimeHours, m_PlayBackInfo.PTimeMinutes , m_PlayBackInfo.PTimeSeconds));
              convertPlayTimeInformation();
              mCallbacks->signalPlayBackState(m_PlayBackState);

          }
    }
    else
    {
        m_PlaybackStateChange = false;
    }
    switch(dataBuffer[8]) {
        case NOT_SEARCHING :
            ETG_TRACE_USR4(("OperationInfoData:NOT_SEARCHING"));
            break;
        case FORWARD_SEARCH:
            ETG_TRACE_USR4(("OperationInfoData:FORWARD_SEARCH"));
            break;
        case REVERSE_SEARCH:
            ETG_TRACE_USR4(("OperationInfoData:REVERSE_SEARCH"));
            break;
        case TRACK_REPEAT_SEARCH :
            ETG_TRACE_USR4(("OperationInfoData:TRACK_REPEAT_SEARCH"));
            break;
        case DISC_REPEAT_SEARCH:
            ETG_TRACE_USR4(("OperationInfoData:DISC_REPEAT_SEARCH"));
            break;
        case TRACK_SCAN_SEARCH:
            ETG_TRACE_USR4(("OperationInfoData:TRACK_SCAN_SEARCH"));
            break;
        case TRACK_RANDOM_SEARCH:
            ETG_TRACE_USR4(("OperationInfoData:TRACK_RANDOM_SEARCH"));
            break;
        case A_TIME_SEARCH:
            ETG_TRACE_USR4(("OperationInfoData:A_TIME_SEARCH"));
            break;
        case FORWARD_FOLDER_SEARCH:
            ETG_TRACE_USR4(("OperationInfoData:FORWARD_FOLDER_SEARCH"));
            break;
        case REVERSE_FOLDER_SEARCH:
            ETG_TRACE_USR4(("OperationInfoData:REVERSE_FOLDER_SEARCH"));
            break;
        default :
            ETG_TRACE_USR4(("OperationInfoData:DISC Mechanism unidentified"));
    }
    if(m_PlayBackInfo.m_playBackMode !=(dataBuffer[9]))
    {
        m_bOneTrackPlay = false;
    m_PlayBackInfo.m_playBackMode = dataBuffer[9];
    switch(m_PlayBackInfo.m_playBackMode) {
           case FUNCTION_OFF :
               ETG_TRACE_USR4(("OperationInfoData:FUNCTION_OFF"));
               break;
           case TRACK_SCAN:
               ETG_TRACE_USR4(("OperationInfoData:TRACK_SCAN"));
               break;
           case TRACK_CHAPTER_REPEAT:
               ETG_TRACE_USR4(("OperationInfoData:TRACK_CHAPTER_REPEAT"));
               break;
           case RANDOM :
               ETG_TRACE_USR4(("OperationInfoData:RANDOM"));
               break;
           case GROUP_TITLE_REPEAT:
               ETG_TRACE_USR4(("OperationInfoData:GROUP_TITLE_REPEAT"));
               break;
           case ONE_TRACK_PLAY:
               ETG_TRACE_USR4(("OperationInfoData:ONE_TRACK_PLAY"));
               m_bOneTrackPlay = true;
               break;
           case DISC_REPEAT_ON:
               ETG_TRACE_USR4(("OperationInfoData:DISC_REPEAT_ON"));
               break;
           default :
               ETG_TRACE_USR4(("OperationInfoData:DISC Mechanism unidentified"));
               break;
       }

        if(mCallbacks && m_bPlaybackPossible)
        {
            ETG_TRACE_USR4(("signalEvent DVD_EVENT_PLAYBACK_MODE %x " , m_PlayBackInfo.m_playBackMode));
            mCallbacks->signalEvent(DVD_EVENT_PLAYBACK_MODE,m_PlayBackInfo.m_playBackMode);
        }
    }
    if(m_PlaybackStateChange == false)
    {
        CheckPlayTimeInfo(dataBuffer);
    }
    CheckSubtitleInfo(dataBuffer);
    CheckAngleInfo(dataBuffer[0x35]);
    CheckCurrentAudioOutputInfo(dataBuffer);
    CheckDisplayAspectRatio(dataBuffer[0x0A]);
    CheckCMSkipAvailability(dataBuffer[0x0A]);
    CheckDirectButtonAvailability(dataBuffer[0x0A]);
    CheckCommand(dataBuffer[0x0A]);
    return status;
}

void DVDControlInterface::CheckPlayTimeInfo(unsigned char* dataBuffer)
{

    ENTRY;
    unsigned char defaultPlaytime[9];
    memset(defaultPlaytime,0xbb,9);
    VARTRACE(m_PlayBackInfo.PTimeHours);
    VARTRACE(m_PlayBackInfo.PTimeMinutes);
    VARTRACE(m_PlayBackInfo.PTimeSeconds);
    // PLAY TIME UPDATES --> If the playtime differs and is not equivalent to bb then update playtime
    if((memcmp(&m_PlayBackInfo,&dataBuffer[0x24],3) != 0 ) && (memcmp(&dataBuffer[0x24],&defaultPlaytime[0],3) != 0))
    {
        m_PlayBackInfo.PTimeHours = dataBuffer[0x24];
        m_PlayBackInfo.PTimeMinutes = dataBuffer[0x25];
        m_PlayBackInfo.PTimeSeconds = dataBuffer[0x26];
        m_PlayBackInfo.ATimeHours = dataBuffer[0x27];
        m_PlayBackInfo.ATimeMinutes = dataBuffer[0x28];
        m_PlayBackInfo.ATimeSeconds = dataBuffer[0x29];
        m_PlayBackInfo.RTimeHours = dataBuffer[0x2A];
        m_PlayBackInfo.RTimeMinutes = dataBuffer[0x2B];
        m_PlayBackInfo.RTimeSeconds = dataBuffer[0x2C];
        ETG_TRACE_USR4(("\n PTime %x:%x:%x   \n" ,m_PlayBackInfo.PTimeHours, m_PlayBackInfo.PTimeMinutes , m_PlayBackInfo.PTimeSeconds));
        ETG_TRACE_USR4(("\n ATime %x:%x:%x   \n" ,m_PlayBackInfo.ATimeHours, m_PlayBackInfo.ATimeMinutes , m_PlayBackInfo.ATimeSeconds));
        ETG_TRACE_USR4(("\n RTime %x:%x:%x  \n" ,m_PlayBackInfo.RTimeHours, m_PlayBackInfo.RTimeMinutes , m_PlayBackInfo.RTimeSeconds));
        ETG_TRACE_USR4(("\n track info  %x- %x \n" ,m_PlayBackInfo.mCurrentTrackPlaying, m_PlayBackInfo.mCurrentGroupPlaying));
        ETG_TRACE_USR4(("\n total Chapter  %x \n" ,m_PlayBackInfo.totalChapter));
        ETG_TRACE_USR4(("\n CurrentTrackTotalTime %x:%x:%x   \n" , m_PlayBackInfo.currentTrackTotalHours,  m_PlayBackInfo.currentTrackTotalMinutes  , m_PlayBackInfo.currentTrackTotalSeconds));
        if(mCallbacks)
        {
            convertPlayTimeInformation();
            mCallbacks->signalPlayBackState(m_PlayBackState);
        }
    }
    return;
}

void DVDControlInterface::CheckAngleInfo(unsigned char data)
{
    //angle information update
    if((angleInfo.AngleNumber != (data & VALUE_0XF0) >> 4) || (angleInfo.TotalAngle != (data & VALUE_0X0F)))
    {
        angleInfo.AngleNumber = (data & VALUE_0XF0) >> 4;
        angleInfo.TotalAngle = (data & VALUE_0X0F);
        ETG_TRACE_USR4(("signalEvent DVD_ANGLE_CHANGED  NUMBER %x/%x '" , angleInfo.AngleNumber,angleInfo.TotalAngle));
        if(mCallbacks)
        {
            mCallbacks->signalEventAngleChange(angleInfo);
        }
    }
    return;
}

void DVDControlInterface::CheckSubtitleInfo(unsigned char* dataBuffer)
{
    //Subtitle Information Update - when the statechanges bn ON/OFF and current subtitle number changes we send a call back
        if((subtitleInfo.SubtitleStatus != ((dataBuffer[0x31] & 0x80) >> 7)) ||(subtitleInfo.CurrentSubtitleNumber != (dataBuffer[0x31] & 0x7F)))
        {
            subtitleInfo.SubtitleStatus = (dataBuffer[0x31] & 0x80) >> 7;
            subtitleInfo.CurrentSubtitleNumber = (dataBuffer[0x31] & 0x7F);
            subtitleInfo.TotalSubtitleNumber = dataBuffer[0x32];
            subtitleInfo.SubtitleLangCode[0] = dataBuffer[0x33];
            subtitleInfo.SubtitleLangCode[1] = dataBuffer[0x34];
            ETG_TRACE_USR4(("signalEvent DVD_SUBTITLE_CHANGED STATUS %x NUMBER %x/%x code'%x %x'" , subtitleInfo.SubtitleStatus, subtitleInfo.CurrentSubtitleNumber,subtitleInfo.TotalSubtitleNumber,subtitleInfo.SubtitleLangCode[0] ,subtitleInfo.SubtitleLangCode[1]));
            if(mCallbacks)
            {
                mCallbacks->signalEventSubtitleChange(subtitleInfo);
            }
        }
        return;
}

void DVDControlInterface::CheckCurrentAudioOutputInfo(unsigned char* dataBuffer)
{
    if(dataBuffer)
    {
        //audio information update
        if((audioOutputInfo.AudioOutputDVD != (dataBuffer[0x2D] & VALUE_0XF0) >> 4) || (audioOutputInfo.SoundFormat != dataBuffer[0x2E]))
        {
            audioOutputInfo.totalAudioChannels = (dataBuffer[0x2D] & VALUE_0X0F);
            audioOutputInfo.AudioOutputDVD = (dataBuffer[0x2D] & VALUE_0XF0) >> 4;
            audioOutputInfo.AudioOutputVCD = (dataBuffer[0x2D] & VALUE_0XF0) >> 4;
            audioOutputInfo.AudioOutputDVDVR = (dataBuffer[0x2D] & VALUE_0XF0) >> 4;
            audioOutputInfo.SoundFormat = dataBuffer[0x2E];
            audioOutputInfo.AudioLangCode[0] = dataBuffer[0x2F];
            audioOutputInfo.AudioLangCode[1]= dataBuffer[0x30];


            ETG_TRACE_USR4(("signalEvent DVD_CURRENT_AUDIO_CHANGED -CHANNEL %x/%x FORMAT %x lang '%x %x'" , audioOutputInfo.AudioOutputDVD, audioOutputInfo.totalAudioChannels,audioOutputInfo.SoundFormat, audioOutputInfo.AudioLangCode[0], audioOutputInfo.AudioLangCode[1]));
            if(mCallbacks)
            {

                mCallbacks->signalEventCurrentAudioChange(audioOutputInfo);
            }
        }
    }
   return;
}

void DVDControlInterface::CheckDisplayAspectRatio(unsigned char data)
{
    if(m_aspectRatio != (data & ASPECT_RATIO_16_9))
    {
        m_aspectRatio = (data & ASPECT_RATIO_16_9);
        ETG_TRACE_USR4(("signalEvent DVD DISPLAY MODE CHANGED  %x'" , m_aspectRatio));

        if(mCallbacks)
        {

            mCallbacks->signalEvent(DVD_EVENT_DISPLAY_MODE,m_aspectRatio);
        }
    }
    return;
}

void DVDControlInterface::CheckCMSkipAvailability(unsigned char data)
{
    // SKIP FUnctionality check
    bool bSkipStatus = false;
    if(m_discType == DISC_DVD_VIDEO)
    {
        if ((data & DVD_MENU) == 0)
        {
            bSkipStatus = true;
        }
    }
    else if(m_discType == DISC_DVD_VR)
    {
        if ((data & DVD_PLAYBACK_ZONE_AUDIO) != DVD_PLAYBACK_ZONE_AUDIO)
       {
            bSkipStatus = true;
       }
    }
    if(bSkipStatus != m_bSkipStatus)
    {
        m_bSkipStatus = bSkipStatus;
        ETG_TRACE_USR4(("signalEvent DVD CM SKIP STATUS CHANGED  %x'" , m_bSkipStatus));
        if(mCallbacks)
        {

            mCallbacks->signalEvent(DVD_EVENT_SKIP_MODE,m_bSkipStatus);
        }
    }
    return;
}
void DVDControlInterface::CheckCommand(unsigned char data)
{
 ENTRY
    bool bCommandStatus = false;
    if((m_discType == DISC_DVD_VIDEO)||(m_discType == DISC_DVD_AUDIO))
    {
        bool bMenuPlayback = false;
        if ((data & DVD_MENU) == 0)// MENU Playback is not set
        {
            bCommandStatus = true;
        }
        else
        {
            bMenuPlayback = true;
        }
        if (m_bMenuPlayback != bMenuPlayback)
        {
            m_bMenuPlayback = bMenuPlayback;
            // signal event that menuplayback is available or not
            ETG_TRACE_USR4(("signalEvent DVD MENU STATUS CHANGED  %x'" , m_bMenuPlayback));
            if(mCallbacks)
            {

                mCallbacks->signalEvent(DVD_EVENT_MENUPLAYBACK_MODE,m_bMenuPlayback);
            }

        }
    }

    if(audioOutputInfo.bCommandEnable !=  bCommandStatus)
    {
        audioOutputInfo.bCommandEnable = bCommandStatus;
#if 0
     if(mCallbacks)
        {

            mCallbacks->signalEventCurrentAudioChange(audioOutputInfo);
        }
#endif
    }
    if((m_discType == DISC_DVD_AUDIO) && (bCommandStatus == true))
    {
        if ((data & DVD_PLAYBACK_ZONE_AUDIO) != DVD_PLAYBACK_ZONE_AUDIO)// Playing zone is not audio
        {
            bCommandStatus = true;
        }
        else
        {
            bCommandStatus = false;
        }
    }
    if(subtitleInfo.bCommandEnable !=  bCommandStatus)
    {

        subtitleInfo.bCommandEnable = bCommandStatus;
#if 0
        if(mCallbacks)
        {
             mCallbacks->signalEventSubtitleChange(subtitleInfo);
        }
#endif
    }
    if(angleInfo.bCommandEnable !=  bCommandStatus)

    {
        angleInfo.bCommandEnable = bCommandStatus;
#if 0

        if(mCallbacks)
        {
            mCallbacks->signalEventAngleChange(angleInfo);
        }
#endif
    }
    return;
}
void DVDControlInterface::CheckDirectButtonAvailability(unsigned char data)
{
    // SKIP FUnctionality check
   bool  bButtonStatus = false;
   if ((data & DVD_BUTTON_OPERATION_STATUS_VALID) == DVD_BUTTON_OPERATION_STATUS_VALID)
   {
        bButtonStatus = true;
   }
   if(bButtonStatus != m_bButtonStatus)

   {
       m_bButtonStatus = bButtonStatus;
       ETG_TRACE_USR4(("signalEvent DVD DIRECT SELECT COMMAND AVAILABILITY STATUS CHANGED  %x'" , m_bButtonStatus));
        if(mCallbacks)
        {

            mCallbacks->signalEvent(DVD_EVENT_DIRECTSELECT_MODE,m_bButtonStatus);
        }
   }
   return;
}
int  DVDControlInterface::AnalyzeDiscInfoData(unsigned char* dataBuffer , int bufferLength)
{

    int status = 0;
    int totalTrack = 0;
    switch(dataBuffer[2]) {

            case DISC_NO_ACCESS :
            {
                totalTrack = dataBuffer[4];
                m_discInfo.trackTimeMinutes = dataBuffer[5];
                m_discInfo.trackTimeSeconds = dataBuffer[6];
                ETG_TRACE_USR4(("DiscInfoData:DISC_NO_ACCESS track %x , tracktime %x : %x",m_discInfo.totalTrack ,m_discInfo.trackTimeMinutes,m_discInfo.trackTimeSeconds));
            }
                break;
            case DISC_NONE:
                ETG_TRACE_USR4(("DiscInfoData:DISC_NONE"));
                break;
            case DISC_ERROR:
                ETG_TRACE_USR4(("DiscInfoData:DISC_ERROR"));
                break;
            case DISC_AUDIO_CD:
            {
                totalTrack = dataBuffer[4];
                m_discInfo.trackTimeMinutes = dataBuffer[5];
                m_discInfo.trackTimeSeconds = dataBuffer[6];
                ETG_TRACE_USR4(("DiscInfoData:DISC_AUDIO_CD track %x , tracktime %x : %x",m_discInfo.totalTrack ,m_discInfo.trackTimeMinutes,m_discInfo.trackTimeSeconds));
            }
            break;
            case DISC_AUDIO_CD_WITH_TEXT:
            {
                totalTrack = dataBuffer[4];
                m_discInfo.trackTimeMinutes = dataBuffer[5];
                m_discInfo.trackTimeSeconds = dataBuffer[6];
                ETG_TRACE_USR4(("DiscInfoData:DISC_AUDIO_CD_TEXT track %x , tracktime %x : %x",m_discInfo.totalTrack ,m_discInfo.trackTimeMinutes,m_discInfo.trackTimeSeconds));
            }
            break;
            case DISC_VCD_VER_1 :
                ETG_TRACE_USR4(("DiscInfoData:DISC_VCD_VER_1"));
                {
                    totalTrack = dataBuffer[4];
                    m_discInfo.trackTimeMinutes = dataBuffer[5];
                    m_discInfo.trackTimeSeconds = dataBuffer[6];
                }
                //mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                break;
            case DISC_VCD_VER_2_PBC_OFF:
                ETG_TRACE_USR4(("DiscInfoData:DISC_VCD_VER_2_PBC_OFF"));
                {
                    totalTrack = dataBuffer[4];
                    m_discInfo.trackTimeMinutes = dataBuffer[5];
                    m_discInfo.trackTimeSeconds = dataBuffer[6];
                }
               // mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                break;
            case DISC_SUPER_VCD_PBC_OFF:
                ETG_TRACE_USR4(("DiscInfoData:DISC_SUPER_VCD_PBC_OFF"));
                {
                    totalTrack = dataBuffer[4];
                    m_discInfo.trackTimeMinutes = dataBuffer[5];
                    m_discInfo.trackTimeSeconds = dataBuffer[6];
                }
               // mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                break;
            case DISC_VCD_VER_2_PBC_ON:
                ETG_TRACE_USR4(("DiscInfoData:DISC_VCD_VER_2_PBC_ON"));
                {
                    totalTrack = dataBuffer[4];
                    m_discInfo.trackTimeMinutes = dataBuffer[5];
                    m_discInfo.trackTimeSeconds = dataBuffer[6];
                }
               // mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                break;
            case DISC_SUPER_VCD_PBC_ON:
                ETG_TRACE_USR4(("DiscInfoData:DISC_SUPER_VCD_PBC_ON"));
                {
                    totalTrack = dataBuffer[4];
                    m_discInfo.trackTimeMinutes = dataBuffer[5];
                    m_discInfo.trackTimeSeconds = dataBuffer[6];
                }
               // mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                break;
            case DISC_DVD_VIDEO :
                ETG_TRACE_USR4(("DiscInfoData:DISC_DVD_VIDEO"));
                {
                    totalTrack = dataBuffer[4];
                    m_discInfo.discIDCodeLower = dataBuffer[5];
                    m_discInfo.discIDCodeUpper = dataBuffer[6];
                }
               // mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                break;
            case DISC_DVD_AUDIO:
                ETG_TRACE_USR4(("DiscInfoData:DISC_DVD_AUDIO"));
                {
                    totalTrack = dataBuffer[4];
                    m_discInfo.discIDCodeLower = dataBuffer[5];
                    m_discInfo.discIDCodeUpper = dataBuffer[6];
                }
                break;
            case DISC_DVD_VR:
                ETG_TRACE_USR4(("DiscInfoData:DISC_DVD_VR"));
                {
                    totalTrack = dataBuffer[4];
                    m_discInfo.discIDCodeLower = dataBuffer[5];
                    m_discInfo.discIDCodeUpper = dataBuffer[6];
                }
                //mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                break;
            case DISC_DATA:
                ETG_TRACE_USR4(("DiscInfoData:DISC_DATA"));
                //mCallbacks->signalEvent(DVD_EVENT_DISC_TYPE,m_discType);
                break;
            default :
                ETG_TRACE_USR4(("DiscInfoData:DISC type unidentified"));
                break;
        }
        if(totalTrack != m_discInfo.totalTrack)
        {
           m_discInfo.totalTrack = totalTrack;
           mCallbacks->signalEvent(DVD_EVENT_TRACK_CHANGE,m_discInfo.totalTrack);
        }
    ETG_TRACE_USR4(("DiscInfoData:track %x , tracktime %x : %x",m_discInfo.totalTrack ,m_discInfo.trackTimeMinutes,m_discInfo.trackTimeSeconds));
return status;
}

void  DVDControlInterface::AnalyzeAudioInfoData(unsigned char* dataBuffer , int bufferLength)
{
        ENTRY
        if (bufferLength < 5)
        {
            return;
        }
        audioChannelInfo.frequency  = (dataBuffer[2] & 0x0F);
        if((dataBuffer[2] & 0x80) == 0x80)
        {
            audioChannelInfo.subWooferAvailable = true;
        }
        else
        {
            audioChannelInfo.subWooferAvailable = false;
        }
        audioChannelInfo.totalChannels = (dataBuffer[2] & 0x30) >> 4;
        ETG_TRACE_USR4(("signalEvent DVD__AUDIO_CHANGED - total CHANNEL %x sub woofer %x frequency %d" , audioChannelInfo.totalChannels, audioChannelInfo.subWooferAvailable,(int)audioChannelInfo.frequency));
        if(mCallbacks)
        {

            mCallbacks->signalEventAudioInfoChange(audioChannelInfo);
        }
        return ;
}

int DVDControlInterface::SwitchtoBackendMode(bool queue)
{
    ENTRY
    int status= MP_NO_ERROR;
    if(m_bPolling == false)
    {
        m_bPolling = true;
        sem_post(&m_SemPoll);
    }

  //  if(!m_bBackendMode)
  //  {
        if(queue == false)
        {
            status=SendBackEndCMDHostToDrive(SwitchtoBackendModeCmd,SwitchtoBackendModeCmdLength);
        }
        else
        {
            status = ExecuteMessage(SwitchtoBackendModeCmd,SwitchtoBackendModeCmdLength);
        }
  //  }
    return status;
}
int DVDControlInterface::SwitchtoMassStorageMode(bool queue)
{
    ENTRY
    int status= MP_NO_ERROR;

   // ETG_TRACE_USR4(("\n I AM INSIDE SwitchtoMassStorageMode  - m_bBackendMode is %x \n",m_bBackendMode));
    if(m_bBackendMode)
    {
      // ETG_TRACE_USR4(("\n !!!!!!!!!!!! I AM INSIDE SwitchtoMassStorageMode \n"));
        if(queue == false)
        {
            status=SendBackEndCMDHostToDrive(SwitchtoMassStorageModeCmd,SwitchtoMassStorageModeCmdLength);
        }
        else
        {
            status = ExecuteMessage(SwitchtoMassStorageModeCmd,SwitchtoMassStorageModeCmdLength);
        }
    }
    return status;
}
void  DVDControlInterface::DoPolling()
{
    //ENTRY_INTERNAL;
    while(m_bThreadActive)
    {
        //ETG_TRACE_USR4(("\n # Do Polling: m_bPOlling value %x \n",m_bPolling));
        if(m_bPolling)
        {
            usleep(POLLING_TIMEOUT);
            if(isMessageAvailable())
            {
                ETG_TRACE_USR4(("###### command is in queue :%x  %x #########",m_CMDDataStruct.cmd[0],m_CMDDataStruct.cmd[1] ));
                SendMessageFromQueue();
            }
            else
            {

                memset(m_dataBuffer,0,256);
                int length = 0;
                int status = ReadDataFromDriveToHost(m_dataBuffer,256,length);
              /*  for(int i=0;i<length;i++)
                {
                    printf("%x = %x\t",i,m_dataBuffer[i]);
                }*/
                if(status != MP_NO_ERROR)
                {
                    ETG_TRACE_ERR(("###### ReadDataFromDriveToHost status :%x #########",status));
                   // break;
                }
                //ETG_TRACE_USR4(("ReadDataFromDriveToHost status :%x",status,sizeofDataRead));
                // AnalyzeDataResponse(buffer,sizeofDataRead);
                AnalyseDataRead(m_dataBuffer,length);
            }
        }else
        {
             sem_wait(&m_SemPoll);
        }
    }

}

bool DVDControlInterface::isMessageAvailable()
{
    bool ret=false;
    m_Mutex.lock();
    ret=m_CMDDataStruct.cmd ? true : false;
    m_Mutex.unlock();
    return ret;
}

void DVDControlInterface::Do(int functionID, void *ptr) // finished: 100%
{
    ENTRY
    (void)ptr;

    //set the threads name
    LocalSPM::GetThreadFactory().SetName("Polling");
    switch (functionID)
    {
        case POLLING_FUNC_ID:
        {
            DoPolling();
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("BTControl::Do: No thread defined for functionID: %d", functionID));
            break;
        }
    }
}
tResult DVDControlInterface::readDiscInformation( bool queue)
{
    ENTRY
    tResult status ;
    if(queue)
    {

         status = ExecuteMessage(DiscInformationDataRequestcmd,DiscInformationDataRequestcmdLength);
    }
    else
    {
        status = SendBackEndCMDHostToDrive(DiscInformationDataRequestcmd,DiscInformationDataRequestcmdLength);
    }
    return status;
}
tResult DVDControlInterface::readCDTEXTAlbum(bool queue)
{
    ENTRY
    tResult status = MP_NO_ERROR ;
    CDTextTitleRequestcmd[TrackIndex] = 0;
    CDTextPerformerRequestcmd[TrackIndex] = 0;
    if(queue)
    {
    status = ExecuteMessage(CDTextTitleRequestcmd,CDTextRequestcmdLength);
    status = ExecuteMessage(CDTextPerformerRequestcmd,CDTextRequestcmdLength);
    }
    else
    {
        status = SendBackEndCMDHostToDrive(CDTextTitleRequestcmd,CDTextRequestcmdLength);
        usleep(POLLING_TIMEOUT);
        status = SendBackEndCMDHostToDrive(CDTextTitleRequestcmd,CDTextRequestcmdLength);
    }
    return status;
}
tResult DVDControlInterface::readCDTEXTbyTrack(unsigned char tracknumber,bool queue)
{
    ENTRY
    tResult status = MP_NO_ERROR ;
    CDTextTitleRequestcmd[TrackIndex] = tracknumber;
    CDTextPerformerRequestcmd[TrackIndex] = tracknumber;
    if(queue)
    {
    status = ExecuteMessage(CDTextTitleRequestcmd,CDTextRequestcmdLength);
    status = ExecuteMessage(CDTextPerformerRequestcmd,CDTextRequestcmdLength);
    }
    else
    {
        status = SendBackEndCMDHostToDrive(CDTextTitleRequestcmd,CDTextRequestcmdLength);
        usleep(POLLING_TIMEOUT);
        status = SendBackEndCMDHostToDrive(CDTextPerformerRequestcmd,CDTextRequestcmdLength);
    }
    return status;
}

tResult DVDControlInterface::play(IN const tURL url, IN const me::speed_e speed, IN const tPlaytime position, IN const tPEHandle handle)
{
    ENTRY
    m_PlayBackInfo.m_PEhandle = handle;
    m_PlayBackInfo.PBState = PE_PBS_PLAYINGSTATE;
    bool bPlay = true;
    /* start playing */
    if((m_discType == DISC_AUDIO_CD) && (strlen_r(url) != 0))
    {
        /* read out the index from the url given */
        char *cptrFile = strstr((char *)url, (char *)"file");
        if (!cptrFile) {
            return MP_ERR_CDDA_WRONG_URL;
        }
        unsigned int currentTrackPlaying = atoi(cptrFile+4); /* files are numbered beginning from 1 */
        ETG_TRACE_USR4(("\n play for audio cd called track number  %x  \n",currentTrackPlaying));
        if(currentTrackPlaying > m_discInfo.totalTrack) {
            return MP_ERR_CDDA_WRONG_URL;
        }
        ETG_TRACE_USR4(("\n one track play called  %x  \n",currentTrackPlaying));
        oneTrackPlay(currentTrackPlaying);
        bPlay = false;

    }
    if(bPlay && m_bPlaybackPossible && m_bBackendMode )
    {
    unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY, KEY_PLAY ,CONTINOUS_PLAY_FUNC_ON, PLAY_ONLY};
    return ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
    }
    else
    {
        return MP_NO_ERROR;
    }
}
tResult DVDControlInterface::directPlay()
{
    ENTRY
    tResult status ;
    ETG_TRACE_USR4(("\n m_bPlaybackPossible  %x   m_bBackendMode %x  \n" ,m_bPlaybackPossible,m_bBackendMode));
    if(m_bPlaybackPossible && m_bBackendMode )
    {
    unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY, KEY_PLAY,CONTINOUS_PLAY_FUNC_ON, PLAY_ONLY};
    status = SendBackEndCMDHostToDrive(KeyCMD,KeyCMDExtendedLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;
}
tResult DVDControlInterface::oneTrackPlay(unsigned char trackNumber)
{
    ENTRY
    tResult status = MP_NO_ERROR;
    playbackModeKeyCMD[PlaybackModeByte] = ONETRACKPLAY;
    playbackModeKeyCMD[playBackTrackByte] = trackNumber;
    ETG_TRACE_USR4(("\n m_bPlaybackPossible  %x   m_bBackendMode %x  \n" ,m_bPlaybackPossible,m_bBackendMode));
    if(m_bPlaybackPossible && m_bBackendMode )
    {
    status = ExecuteMessage(playbackModeKeyCMD,playbackModeKeyCMDLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    if(status == MP_NO_ERROR)
    {
        // One track play moves to pause state by itself , hence this flag is used to trigger next song
        m_bOneTrackPlay = true;
    }
    return status;
}

tResult DVDControlInterface::setPlaybackMode(tPlaybackFunctionControl playbackmode)
{
    ENTRY
    tResult status ;
    playbackModeKeyCMD[PlaybackModeByte] = playbackmode;
    playbackModeKeyCMD[playBackTrackByte] = 0;
    ETG_TRACE_USR4(("\n m_bPlaybackPossible  %x   m_bBackendMode %x  \n" ,m_bPlaybackPossible,m_bBackendMode));
    if(m_bPlaybackPossible && m_bBackendMode )
    {
    status = ExecuteMessage(playbackModeKeyCMD,playbackModeKeyCMDLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}
tResult DVDControlInterface::pause(bool queue)
{
    ENTRY
    tResult status ;
    m_PlayBackInfo.PBState = PE_PBS_PAUSEDSTATE;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
          // One track play moves to pause state by itself , hence this flag is used to trigger next song
          // If pause is called by user , then it has to be reset
          if( m_bOneTrackPlay == true)
                {

                    m_bOneTrackPlayPauseByUser = true;
                }
        unsigned char KeyCMD[KeyCMDLength]={BE_COMMAND_REQUEST_KEY,KEY_PAUSE};
        if (queue == false)
        {
            return SendBackEndCMDHostToDrive(KeyCMD,KeyCMDLength);
        }
        else
        {
            return ExecuteMessage(KeyCMD,KeyCMDLength);
        }

    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}

tResult DVDControlInterface::resume()
{
    ENTRY
    tResult status ;
    m_PlayBackInfo.PBState = PE_PBS_PLAYINGSTATE;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY,KEY_PLAY ,CONTINOUS_PLAY_FUNC_ON, PLAY_ONLY};
        return ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}

tResult DVDControlInterface::stop(bool queue)
{
    ENTRY
        m_PlayBackInfo.PBState = PE_PBS_STOPPEDSTATE;
    tResult status ;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDLength]={BE_COMMAND_REQUEST_KEY,KEY_STOP};
        if (queue == false)
        {
            status = SendBackEndCMDHostToDrive(KeyCMD,KeyCMDLength);
        }
        else
        {
            status = ExecuteMessage(KeyCMD,KeyCMDLength);
        }
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}

tResult DVDControlInterface::next(bool queue )
{
    ENTRY
    tResult status ;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY,KEY_UP,0x0,0x0};
        if(queue)
        {
            status =  ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
        }
        else
        {
            status =  SendBackEndCMDHostToDrive(KeyCMD,KeyCMDExtendedLength);

        }
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}
tResult DVDControlInterface::previous(bool queue )
{
    ENTRY
    tResult status ;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY,KEY_DOWN,0x0, 0x0};
        if(queue)
        {
        if(m_PlayBackInfo.PTimeSeconds <= 3) // 3 seconds bandwidth for previous song
        {
         status =   ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
        }
        status = ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
        }
        else
        {
            status =  SendBackEndCMDHostToDrive(KeyCMD,KeyCMDExtendedLength);
        }
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}
tResult DVDControlInterface::seek(IN const me::speed_e speed, IN const tPlaytime position)
{
    tResult status = MP_NO_ERROR;
    return status;
}

tResult DVDControlInterface::frevStart(tCueingRate rate)
{
    ENTRY
    tResult status ;
        m_PlayBackInfo.PBState = PE_PBS_FASTREVERSESTATE;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY, KEY_FAST_BWD, (unsigned char)rate, DEFUALT_RESERVED};
        return ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}

tResult DVDControlInterface::srevStart(tCueingRate rate)
{
    ENTRY
    tResult status ;
        m_PlayBackInfo.PBState = PE_PBS_FASTREVERSESTATE;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY, KEY_SLOW_BWD, (unsigned char)rate, DEFUALT_RESERVED};
        return ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}

tResult DVDControlInterface::frevStop()
{
    ENTRY
    tResult status ;
        m_PlayBackInfo.PBState = PE_PBS_PLAYINGSTATE;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDLength]={BE_COMMAND_REQUEST_KEY,KEY_RELEASE};
        return ExecuteMessage(KeyCMD,KeyCMDLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;
}

tResult DVDControlInterface::ffwdStart(tCueingRate rate)
{
    ENTRY
    tResult status ;
        m_PlayBackInfo.PBState = PE_PBS_FASTFORWARDSTATE;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY, KEY_FAST_FWD , (unsigned char)rate, DEFUALT_RESERVED};
        return ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}
tResult DVDControlInterface::sfwdStart(tCueingRate rate)
{
    ENTRY
    tResult status ;
        m_PlayBackInfo.PBState = PE_PBS_FASTFORWARDSTATE;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY, KEY_SLOW_FWD , (unsigned char)rate, DEFUALT_RESERVED};
        return ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;

}
tResult DVDControlInterface::ffwdStop()
{
    ENTRY
    tResult status ;
    m_PlayBackInfo.PBState = PE_PBS_PLAYINGSTATE;
    if(m_bPlaybackPossible && m_bBackendMode )
    {
        unsigned char KeyCMD[KeyCMDLength]={BE_COMMAND_REQUEST_KEY,KEY_RELEASE};
        return ExecuteMessage(KeyCMD,KeyCMDLength);
    }
    else
    {
        status = MP_ERR_DVD_PLAYBACK ;
    }
    return status;


}

void DVDControlInterface::getParameter(OUT tPEHandle &handle,OUT tPEPlaybackState &peState, OUT me::reason_e &reason, OUT me::speed_e &speed)
{
    handle =  m_PlayBackInfo.m_PEhandle;
    return;
}


void DVDControlInterface::resetToc()
{
    mTocRead = false;
    memset(&mToc,0x00,sizeof(mToc));
    mTrackCount = 0;
}

void DVDControlInterface::RegisterCallbacks(DVDControlInterfaceCallback *callbacks)
{
   if(callbacks != NULL)
    {
       mCallbacks = callbacks;
    }
}


tResult  DVDControlInterface::Initialize(const tMountPoint mountPoint , int ConfigureFPGA , int regionCode, bool isDataDisc)
{
    ENTRY
    tResult status = MP_NO_ERROR;
    m_bDataDisc = isDataDisc;
    strncpy_r(m_MountPoint,mountPoint,sizeof(m_MountPoint));

    if(ConfigureFPGA == 1)
    {
        m_DVDSetupInfo.VideoOutputmode = NTSC_DISPLAY ;
    }
    m_DVDSetupInfo.RegionCode = (tDvdVideoRegionCode)regionCode;
    VARTRACE("dvd region code::");
    VARTRACE(regionCode);
    if (sem_init(&m_Semaphore, 0, 0) == -1)
    {
        ETG_TRACE_ERR(("\n Semaphore not initialized \n"));
        status = MP_DVD_INTERFACE_ERROR;
    }
     if (sem_init(&m_SemPoll, 0, 0) == -1)
    {
        ETG_TRACE_ERR(("\n m_SemPoll not initialized \n"));
        status = MP_DVD_INTERFACE_ERROR;
    }

     m_bThreadActive = true;
    int threadIndex = LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DVD_POLL, IN NULL);
    if(threadIndex < 0)
    {
        ETG_TRACE_ERR((" DVD POLL THREAD NOT STARTED"));
        m_bThreadActive = false;
        return false;
    }
    usleep(POLLING_TIMEOUT*5);
    if(m_bOnSequenceStart == false)
    {
        SwitchtoBackendMode(true);
        usleep(POLLING_TIMEOUT*2);
        //ExecuteMessage(LoadCMD,LoadCMDLength);
        //usleep(POLLING_TIMEOUT*2);
        SendDiscInformationDataRequest(true);
        usleep(POLLING_TIMEOUT*2);
        SendOperInformationDataRequest(true);
    }
    return status;

}

tResult  DVDControlInterface::ExecuteMessage(tU8* cmd,tU32 cmdLength, bool bkeyResponseRequired)
{
    ENTRY_INTERNAL
    tResult status = MP_NO_ERROR ;

    if((cmd != NULL) && (cmdLength > 0))
    {
        checkForKeyCommand(cmd[0]); // if key command wait till the previous response  recv
        status = AddMessageToQueue(cmd,cmdLength,bkeyResponseRequired);

        if(status == MP_NO_ERROR)
        {
            if (clock_gettime(CLOCK_REALTIME, &semTime) != -1)
            {
            semTime.tv_sec += 2 ; // maximum timeout 2s
            //semaphore wait , wait till the message gets executed by the polling thread
            sem_timedwait(&m_Semaphore,&semTime);
            //read the status
            status = ReadStatusAndClearMessageFromQueue();
            ETG_TRACE_USR4(("\n executing message completion , status is %d  \n",status));

            }
            else
            {
                status = MP_ERR_DVD_COMMAND_EXECUTION;
                ETG_TRACE_ERR(("\n  ExecuteMessage DVD failed , not able to get real time for sem wait \n"));
            }

        }

    }
    else
    {
        status = MP_ERR_DVD_COMMAND_EXECUTION;
        ETG_TRACE_ERR(("\n executing message  failed \n"));
    }

    return  status;
}

tResult  DVDControlInterface::AddMessageToQueue(tU8* cmd,tU32 cmdLength, bool bkeyResponseRequired)
{
    ENTRY_INTERNAL
    tResult status = MP_NO_ERROR ;
    if((cmd != NULL) && (cmdLength > 0))
    {
        m_Mutex.lock();
        m_CMDDataStruct.cmd = new unsigned char[cmdLength];
        memcpy(m_CMDDataStruct.cmd , cmd ,cmdLength);
        m_CMDDataStruct.dataLength = cmdLength ;
        m_CMDDataStruct.result = MP_NO_ERROR;
        m_CMDDataStruct.keyResponseRequired = bkeyResponseRequired;
        m_Mutex.unlock();
        ETG_TRACE_USR4(("\n AddMessageToQueue - adding message success \n %x",m_CMDDataStruct.cmd));
    }
    else
    {
        status = MP_ERR_DVD_COMMAND_EXECUTION;
        ETG_TRACE_ERR(("\n AddMessageToQueue -adding message  failed \n"));
    }
    return  status;
}

void  DVDControlInterface::SendMessageFromQueue()
{
    ENTRY_INTERNAL
    m_Mutex.lock();
    if((m_CMDDataStruct.cmd != NULL) && (m_CMDDataStruct.dataLength > 0))
    {
        tResult status= MP_NO_ERROR;
        ETG_TRACE_USR4(("\n SendMessageFromQueue -- sending message ...... \n"));
        status=SendBackEndCMDHostToDrive(m_CMDDataStruct.cmd,m_CMDDataStruct.dataLength);
        if(status != MP_NO_ERROR)
        {
            ETG_TRACE_ERR(("\n SendMessageFromQueue --sending message from DVD Control to drive failed \n"));

        }
        else{
            if(m_CMDDataStruct.cmd[0] == BE_COMMAND_REQUEST_KEY && m_CMDDataStruct.keyResponseRequired == true)
            {
                // set flag to send key command response via DVDCallback , from DVDControl it updates the corresponding property.
                m_bSendKeyCommandUpdate = true;
            }
            m_CMDDataStruct.keyResponseRequired = true;
        }
        m_CMDDataStruct.result = status;
    }
    m_Mutex.unlock();
    sem_post(&m_Semaphore);
    return ;
}

tResult DVDControlInterface::ReadStatusAndClearMessageFromQueue()
{
    ENTRY
    m_Mutex.lock();
    if(m_CMDDataStruct.cmd != NULL)
    {
        delete[] m_CMDDataStruct.cmd;
        m_CMDDataStruct.cmd = NULL;
    }
    m_CMDDataStruct.dataLength = 0;
    tResult status = m_CMDDataStruct.result;
    m_CMDDataStruct.result = MP_NO_ERROR;
    m_Mutex.unlock();
    return  status;
}


void DVDControlInterface::prepare_SG_IO_Command(bool awaitingResponse)
{


    ENTRY_INTERNAL
    memset(scsiCmd.senseBuffer, 0, sizeof(scsiCmd.senseBuffer));


    aSCSICommandBuffer.cmdp    =  scsiCmd.p_CommandBuffer;
    aSCSICommandBuffer.cmd_len = scsiCmd.commandLength;

    aSCSICommandBuffer.dxferp      = scsiCmd.p_ResponseBuffer;
    aSCSICommandBuffer.dxfer_len   = scsiCmd.responseBufferLength;

    aSCSICommandBuffer.sbp         = scsiCmd.senseBuffer;
    aSCSICommandBuffer.mx_sb_len   = (unsigned char)sizeof(scsiCmd.senseBuffer);

    aSCSICommandBuffer.interface_id = 'S'; //INTERFACE_ID
    if (awaitingResponse) {
        aSCSICommandBuffer.dxfer_direction = SG_DXFER_FROM_DEV;
    } else {
        aSCSICommandBuffer.dxfer_direction = SG_DXFER_TO_DEV;
    }
    aSCSICommandBuffer.timeout         = DVD_SCSI_IF_SG_CMD_TIMEOUT_MS;
}

int DVDControlInterface::run_SG_IO_Command()
{
    ENTRY_INTERNAL

    int res = MP_ERR_DVD_COMMAND_EXECUTION;
    int fd = 0;
    int retryCount = 0;
    while((res == MP_ERR_DVD_COMMAND_EXECUTION)&&(retryCount < MAX_RETRY_COUNT))
    {
        fd = open(m_MountPoint, O_RDONLY | O_NONBLOCK);
        if (fd == -1) {
            ETG_TRACE_ERR(("DVDControlInterface::run_SG_IO_Command: open error: %d/%s", errno, strerror(errno)));
            res =  MP_ERR_DVD_COMMAND_EXECUTION;
        }
        else
        {
            res = MP_NO_ERROR;
        }
        retryCount++ ;
    }
    // The open command fails after the maximum retry count , return error
    if(res == MP_ERR_DVD_COMMAND_EXECUTION)
    {
        return res;
    }
    res = ioctl(fd, (unsigned long)SG_IO, &aSCSICommandBuffer);
    if (res == -1) {
        ETG_TRACE_ERR(("DVDControlInterface::run_SG_IO_Command: ioctl error: %d/%s", errno, strerror(errno)));
        res = MP_ERR_DVD_COMMAND_EXECUTION;
    }
    else
    {
        if((aSCSICommandBuffer.dxfer_direction == SG_DXFER_TO_DEV) && (((char*)aSCSICommandBuffer.dxferp)[0] == BE_COMMAND_REQUEST_KEY))
        {
            m_bKeyResponse = false;
            ETG_TRACE_USR4(("\n  run_SG_IO_Command m_bKeyResponse is %x",m_bKeyResponse));
        }
    }
    close(fd);
    return res;
}
void DVDControlInterface::checkForKeyCommand(unsigned char commandByte)
{
    if( commandByte == BE_COMMAND_REQUEST_KEY)
    {
      if(m_bKeyResponse)
      {
          ETG_TRACE_USR4(("\n  checkForKeyCommand m_bKeyResponse is %x",m_bKeyResponse));
          return;
      }
      else
      {
          for(unsigned int i = 0 ; i< MAX_RETRY_COUNT ; i++)
          {
              usleep(POLLING_TIMEOUT*2);
              if(m_bKeyResponse)
              {
                 break;
              }
          }
      }
    }
    return;
}
int DVDControlInterface::ReadDataFromDriveToHost(unsigned char* buffer,short bufferLength, int& dataTransferedLength)
{
    ENTRY_INTERNAL

    int res = 0;
    command_packet cdb;
    memset(&cdb,0x0,sizeof(command_packet));
    cdb.opcode=BACKEND_OPCODE;
    cdb.direction=DRIVE_TO_HOST_DIRECTION;
    cdb.len=htons(bufferLength);
    m_CommandBufferMutex.lock();
    memset(&scsiCmd,0,sizeof(tScsiCmd));
    scsiCmd.p_CommandBuffer=(unsigned char*)&cdb;
    scsiCmd.commandLength=sizeof(command_packet);
    scsiCmd.p_ResponseBuffer=buffer;
    scsiCmd.responseBufferLength=bufferLength;
    prepare_SG_IO_Command(true);
    res =run_SG_IO_Command();
    m_CommandBufferMutex.unlock();
    if(res!= 0)
    {
        return res;
        ETG_TRACE_ERR(("\n ReadDataFromDriveToHost failed %d \n",res));
    }
    dataTransferedLength = bufferLength - aSCSICommandBuffer.resid;
    return 0;
}

int  DVDControlInterface::SendBackEndCMDHostToDrive(tU8* cmd,tU16 cmdLength)
{

    ENTRY_INTERNAL

    if(cmd != NULL)
    {

        int res = 0;
        command_packet cdb;
        memset(&cdb,0x0,sizeof(command_packet));
        cdb.opcode=BACKEND_OPCODE;
        cdb.direction=HOST_TO_DRIVE_DIRECTION;
        cdb.len=htons(cmdLength);
        m_CommandBufferMutex.lock();
        memset(&scsiCmd,0,sizeof(tScsiCmd));
        scsiCmd.p_CommandBuffer=(unsigned char*)&cdb;
        scsiCmd.commandLength=sizeof(command_packet);
        scsiCmd.p_ResponseBuffer=cmd;
        scsiCmd.responseBufferLength=cmdLength;
        prepare_SG_IO_Command(false);
        res = run_SG_IO_Command();
        m_CommandBufferMutex.unlock();
        if(res!= 0)
        {
            return res;
            ETG_TRACE_ERR(("\n SendBackEndCMDHostToDrive failed %d \n",res));
        }
    }
    return 0;
}

int  DVDControlInterface::SwitchtoMassStorageModeDisablePolling()
{
    ENTRY
           tResult res = MP_NO_ERROR;
           SwitchtoMassStorageMode();
           int retryCount = 0;
           m_bRevertToBEMode = false;
           while((m_bBackendMode) && (retryCount < 20))
           {
           usleep(POLLING_TIMEOUT*4);
           retryCount++;
           ETG_TRACE_USR4(("\n #### read TOC mass storage mode retry %x \n",retryCount));
           }
           if(m_bBackendMode != true)
           {
           m_bPolling = false;
           ETG_TRACE_USR4(("\n #### read TOC m_bPOlling value %x \n",m_bPolling));
           usleep(POLLING_TIMEOUT * 2);
           }
           else
           {
               m_bDisablePolling = true;
               res = MP_DVD_INTERFACE_ERROR;
           }

     return res;

}
tResult DVDControlInterface::readToc( tCDTOCInfo&  TOCAddressBuffer)
{
    ENTRY
    tResult res = MP_NO_ERROR;
    resetToc();
    if(m_discType == DISC_AUDIO_CD)
    {
       m_bPolling = false;
       usleep(POLLING_TIMEOUT * 4);
       if((res ==  MP_NO_ERROR) /*&& (m_bBackendMode == false)*/)
       {
            unsigned char mCommandBuffer[12] = {0};
            /* define the command */
            mCommandBuffer[0] = READ_TOC; /*0x43*/
            mCommandBuffer[1] = 0x00; //MSF_MSF;
            mCommandBuffer[2] = 0x00; //FORMAT_TOC;
            int bufferSizeOffset = 7;
            int responseSize = sizeof(mTOCResponseBuffer);
            mCommandBuffer[bufferSizeOffset] = (unsigned char)((responseSize >> 8) & 0xFF);
            mCommandBuffer[bufferSizeOffset + 1] = (unsigned char)(responseSize & 0xFF);
            m_CommandBufferMutex.lock();
            memset(&scsiCmd,0,sizeof(tScsiCmd));
            scsiCmd.p_CommandBuffer = (unsigned char*)&mCommandBuffer[0];
            scsiCmd.commandLength = sizeof(mCommandBuffer);
            scsiCmd.p_ResponseBuffer = &mTOCResponseBuffer[0];
            scsiCmd.responseBufferLength=sizeof(mTOCResponseBuffer);
            prepare_SG_IO_Command(true);
            res =run_SG_IO_Command();
            m_CommandBufferMutex.unlock();


            /* extract data from io buffer which device command has filled */
            if (res == MP_NO_ERROR) {

                unsigned char *pucBuff = mTOCResponseBuffer;
                tCDTOCInfo *prToc = &mToc;
                unsigned int dataTransferedLength = sizeof(mTOCResponseBuffer) - aSCSICommandBuffer.resid;
                ETG_TRACE_USR4(("\n #######1 data length read TOC datalength %d  responseBufferLength %d resid %d \n",dataTransferedLength,scsiCmd.responseBufferLength,aSCSICommandBuffer.resid));
                int tocLen = (unsigned int)CD_8TO16(pucBuff[0], pucBuff[1]);
                unsigned char u8T;
                unsigned char u8Track;
                unsigned char u8TOCValid = CD_INVALID;
                strncpy_r(prToc->m_MountPoint,m_MountPoint,sizeof(m_MountPoint));
                if(tocLen >= CD_SCSI_IF_TOC_ENTRY_LEN)
                {
                  prToc->u8MinTrack = pucBuff[2];
                  prToc->u8MaxTrack = pucBuff[3];
                  mTrackCount = (prToc->u8MaxTrack - prToc->u8MinTrack) + 1;

                  /*************** Test traces for field reset issue: To be removed later ****************/
                  ETG_TRACE_USR4(("readToc:prToc->u8MinTrack: %d",prToc->u8MinTrack));
                  ETG_TRACE_USR4(("readToc:prToc->u8MaxTrack: %d",prToc->u8MaxTrack));
                  ETG_TRACE_USR4(("readToc:DVDControlInterface::readToc: prToc->u8MinTrack = %d",prToc->u8MinTrack));
                  ETG_TRACE_USR4(("readToc:DVDControlInterface::readToc: prToc->u8MaxTrack = %d",prToc->u8MaxTrack));
                  ETG_TRACE_USR4(("readToc:mTrackCount:%d",mTrackCount));
                  ETG_TRACE_USR4(("readToc:DVDControlInterface::readToc: mTrackCount = %d",mTrackCount));


                  pucBuff = &pucBuff[4];
                  for(u8T = 0; u8T < mTrackCount; u8T++)
                  {
                    pucBuff  = &mTOCResponseBuffer[4 + ((unsigned int)u8T * CD_SCSI_IF_TOC_ENTRY_LEN)];
                    u8Track = pucBuff[2];
                    prToc->arTrack[u8T].u8AdrCtrl    = pucBuff[1];
                    prToc->arTrack[u8T].u32StartZLBA = CD_8TO32(pucBuff[4],pucBuff[5],
                                                                       pucBuff[6],
                                                                       pucBuff[7]);
                    ETG_TRACE_USR4(("readToc:track %d u8AdrCtrl  :%x",u8T,prToc->arTrack[u8T].u8AdrCtrl ));
                    ETG_TRACE_USR4(("readToc:track %d u32StartZLBA = %x",u8T,prToc->arTrack[u8T].u32StartZLBA ));
                  } //for(u8T = 0; u8T < u8TrackCount; u8T++)



                  /* define the command */
                   memset(mCommandBuffer,0,sizeof(mCommandBuffer));
                   mCommandBuffer[0] = READ_CAPACITY;
                   memset(mTOCResponseBuffer,0,sizeof(mTOCResponseBuffer));
                   mCommandBuffer[bufferSizeOffset] = (unsigned char)((responseSize >> 8) & 0xFF);
                   mCommandBuffer[bufferSizeOffset + 1] = (unsigned char)(responseSize & 0xFF);
                  /* do the device command */
                   m_CommandBufferMutex.lock();
                   memset(&scsiCmd,0,sizeof(tScsiCmd));
                   scsiCmd.p_CommandBuffer=(unsigned char*)&mCommandBuffer[0];
                   scsiCmd.commandLength=sizeof(mCommandBuffer);
                   scsiCmd.p_ResponseBuffer=&mTOCResponseBuffer[0];
                   scsiCmd.responseBufferLength=sizeof(mTOCResponseBuffer);
                   prepare_SG_IO_Command(true);
                   res =run_SG_IO_Command();
                   m_CommandBufferMutex.unlock();

                  if (res == MP_NO_ERROR) {

                      dataTransferedLength = scsiCmd.responseBufferLength - aSCSICommandBuffer.resid;
                      ETG_TRACE_USR4(("\n #######2 data length read TOC datalength %d  responseBufferLength %d resid %d \n",dataTransferedLength,scsiCmd.responseBufferLength,aSCSICommandBuffer.resid));
                      pucBuff = mTOCResponseBuffer;
                      prToc->u32LastZLBA = CD_8TO32(pucBuff[0],
                                                    pucBuff[1], pucBuff[2], pucBuff[3]);
                      prToc->u8Valid = CD_VALID;
                      u8TOCValid = prToc->u8Valid;
                      ETG_TRACE_USR4(("readToc:u32LastZLBA  :%x", prToc->u32LastZLBA));
                      ETG_TRACE_USR4(("readToc:u8Valid = %x",prToc->u8Valid ));

                  } else {
                      prToc->u8Valid = CD_INVALID;
                      u8TOCValid = prToc->u8Valid;
                  }

                  if(mTrackCount < 0)
                  {
                      prToc->u8Valid = CD_INVALID;
                      u8TOCValid = prToc->u8Valid;
                  }

                } else {
                    prToc->u8Valid = CD_INVALID;
                    u8TOCValid = prToc->u8Valid;
                }

                if (u8TOCValid) {
                    mTocRead = true;
                } else {
                    ETG_TRACE_ERR(("CDDADeviceInterface::getToc: invalid TOC"));
                }

                /* if toc valid, try to read cd text */
                if (u8TOCValid) {

                    {
                        /* fill in some general info */
                        for(int i=0; i<mTrackCount; i++) {

                            /* not the very last track: */
                            if (i < (mTrackCount-1)) {

                                // track 0 is a dummy track with information */
                                prToc->arTrack[i].playTime = prToc->arTrack[i+2].u32StartZLBA - prToc->arTrack[i+1].u32StartZLBA;

                                /* only for the last track: */
                            } else {

                                // track 0 is a dummy track with information */
                                prToc->arTrack[i].playTime = prToc->u32LastZLBA - prToc->arTrack[i+1].u32StartZLBA;
                            }

                            prToc->arTrack[i].playTime /= CD_SECTORS_PER_SECOND;   // convert to seconds
                            prToc->arTrack[i].playTime *= 1000;                    // in milliseconds
                            ETG_TRACE_USR4(("readToc:track %d playTime = %d",i,prToc->arTrack[i].playTime));
                        }



                        /* define the command */
                         memset(mCommandBuffer,0,sizeof(mCommandBuffer));
                         mCommandBuffer[0] = READ_TOC; /*0x43*/
                         mCommandBuffer[1] = 0x02; //MSF_MSF;
                         mCommandBuffer[2] = 0x05; //FORMAT_CDTEXT;
                         memset(mTOCResponseBuffer,0,sizeof(mTOCResponseBuffer));
                         mCommandBuffer[bufferSizeOffset] = (unsigned char)((responseSize >> 8) & 0xFF);
                         mCommandBuffer[bufferSizeOffset + 1] = (unsigned char)(responseSize & 0xFF);
                        /* do the device command */
                        m_CommandBufferMutex.lock();
                         memset(&scsiCmd,0,sizeof(tScsiCmd));
                         scsiCmd.p_CommandBuffer=(unsigned char*)&mCommandBuffer[0];
                         scsiCmd.commandLength=sizeof(mCommandBuffer);
                         scsiCmd.p_ResponseBuffer=&mTOCResponseBuffer[0];
                         scsiCmd.responseBufferLength=sizeof(mTOCResponseBuffer);
                         prepare_SG_IO_Command(true);
                         res =run_SG_IO_Command();
                         m_CommandBufferMutex.unlock();
                        if (res == MP_NO_ERROR) {

                            dataTransferedLength = scsiCmd.responseBufferLength - aSCSICommandBuffer.resid;
                            if(dataTransferedLength != 0)
                            {
                                ETG_TRACE_USR4(("\n #######3 data length read TOC datalength %d  responseBufferLength %d resid %d \n",dataTransferedLength,scsiCmd.responseBufferLength,aSCSICommandBuffer.resid));
                                int dataLen = CD_8TO16(mTOCResponseBuffer[0], mTOCResponseBuffer[1]);
                                if (dataLen) { // got CD text:

                                    ETG_TRACE_USR4(("\n #######4 set CD Text , data length is %d ",dataLen));
                                    /* read that out */
                                    setCDText(dataLen,mTOCResponseBuffer);
                                }
                            }
                        }
                    }
                }

            }
            /* wait a little to help drive */
            usleep(100000);

        }
       //post sem
       if(m_bPolling == false)
       {
           VARTRACE(m_bPolling);
           m_bPolling = true;
           sem_post(&m_SemPoll);
       }
    }
    memcpy(&TOCAddressBuffer, &mToc ,sizeof(tCDTOCInfo));
    return res;
}




tResult DVDControlInterface::setCDText(unsigned int u32ATACDTextLen , unsigned char* pu8RawATA)
{
    ENTRY

    tResult u32Ret = MP_NO_ERROR;
    tCDTOCInfo *prToc = &mToc;
    /*
     * read out the CDTEXT
     */
    pu8RawATA = pu8RawATA + 4;
    if(u32ATACDTextLen > CDAUDIO_ATA_CDTEXT_RAW_BUFFER_LEN)
    {
        ETG_TRACE_FATAL(("!!! Overflow for setCDText u32ATACDTextLen %d!!!",u32ATACDTextLen))
        return MP_ERR_CDDA_CDTEXT;
    }
    if((u32ATACDTextLen>=4))
    {
        LocalSPM::GetDataProvider().parseCddaResponseBuffer(pu8RawATA,u32ATACDTextLen,mTrackCount);

        MapCDDAMetadata Title;
        MapCDDAMetadata Artist;
        string Album;
        LocalSPM::GetDataProvider().getCddaMetaDataForTitle(OUT Album, OUT Title, mTrackCount);
        LocalSPM::GetDataProvider().getCddaMetaDataForArtist(OUT Artist, mTrackCount);

        if(Album.size())// album title
        {
            for(int index = 0; index < mTrackCount; index++)
            {
                strncpy_r(prToc->albumName , Album.c_str(), sizeof(prToc->albumName));

                LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(prToc->albumName), sizeof(prToc->albumName));
                ETG_TRACE_USR4(("\n readToc: #######5 Album Text = %s",prToc->albumName));
            }
        }
        for(MapCDDAMetadata::iterator it = Title.begin();it!=Title.end();it++)
        {
            strncpy_r(prToc->arTrack[it->first].title, it->second.c_str(), sizeof(prToc->arTrack[it->first].title));
            LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(prToc->arTrack[it->first].title), sizeof(prToc->arTrack[it->first].title));
            ETG_TRACE_USR4(("\n #######5 song title= %s",prToc->arTrack[it->first].title));
        }
        for(MapCDDAMetadata::iterator it = Artist.begin();it!=Artist.end();it++)
        {
            strncpy_r(prToc->arTrack[it->first].performer, it->second.c_str(), sizeof(prToc->arTrack[it->first].performer));
            LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(prToc->arTrack[it->first].performer), sizeof(prToc->arTrack[it->first].performer));
            ETG_TRACE_USR4(("\n song composer= %s",prToc->arTrack[it->first].performer));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("!!!setCDText u32ATACDTextLen %d!!!",u32ATACDTextLen))
    }
    return u32Ret;
}

unsigned char DVDControlInterface::getNumberOfTracks()
{
   ENTRY

   ETG_TRACE_USR4(("\n  getNumberOfTracks--> %x",m_discInfo.totalTrack));
    if( m_discInfo.totalTrack == 0)
    {
        int status =  SendDiscInformationDataRequest(true);
        if(status == MP_NO_ERROR)
        {
            usleep(POLLING_TIMEOUT*2);
        }

    }
    for(int retryCount = 0 ; retryCount < 5; retryCount++ )
    {
        ETG_TRACE_USR4(("\n  getNumberOfTracks--> retry count %x",retryCount));
        if(m_discInfo.totalTrack != 0)
         {

             ETG_TRACE_USR4(("\n  getNumberOfTracks--> %x",m_discInfo.totalTrack));
             break;
         }
        else
         {
             usleep(POLLING_TIMEOUT*4);
         }
    }
    return m_discInfo.totalTrack ;
}
tResult DVDControlInterface::getTrackTextInfo(OUT tFiles *tocDataOneTrack,unsigned char trackIndex)
{
    ENTRY;
    ETG_TRACE_USR4(("\n disc type is %x ",m_discType));
    tResult status=0;
     if(m_discType == DISC_AUDIO_CD)
     {
         ETG_TRACE_USR4(("\n  getCDTextInfo is called disc type is DISC_AUDIO_CD"));
         status = getCDTextInfo(tocDataOneTrack,trackIndex);

     }
     else
     {
       // dummy list with only one element
         if(tocDataOneTrack)
         {
            tocDataOneTrack->type = FT_VIDEO;
            if(m_discType == DISC_DVD_AUDIO)
            {
            tocDataOneTrack->type = FT_AUDIO;
            }
            tocDataOneTrack->trackNumber = (unsigned int)trackIndex;
            snprintf(tocDataOneTrack->fileName, sizeof(tocDataOneTrack->fileName), "file%d.dvd", trackIndex);
            tocDataOneTrack->fileFormat = FFT_UNKNOWN;
            tocDataOneTrack->notPlayable = FNP_PLAYABLE;
            snprintf(tocDataOneTrack->metaData1, sizeof(tocDataOneTrack->metaData1), "title%d", m_PlayBackInfo.mCurrentGroupPlaying);
            snprintf(tocDataOneTrack->metaData2, sizeof(tocDataOneTrack->metaData2), "totalChapter%d", m_PlayBackInfo.totalChapter);
            snprintf(tocDataOneTrack->metaData3, sizeof(tocDataOneTrack->metaData3), "chapter%d", trackIndex);
            if(trackIndex > 1 )
            {
                tocDataOneTrack->isEOF = 1;
            }
         }
     }
    return status;
}

#if 0
tResult DVDControlInterface::getCDTextInfoFromBackendCache(OUT tFiles *tocDataOneTrack,unsigned char trackIndex)
{
    ENTRY;
    tResult status=0;

    if(m_bCDTextInfoRead == false)
    {
        status = readCDText();
    }
    // DEBUG PURPOSE
    if(m_bCDTextInfoRead)
    {
       ETG_TRACE_USR4((" getCDTextInfo ::::: track number %x/%x title %s ",trackIndex ,m_discInfo.totalTrack, mtrackInformation[trackIndex].u8Title));
       ETG_TRACE_USR4((" performer %s ",mtrackInformation[trackIndex].u8Performer));
       if(mtrackInformation[trackIndex].valid == false)
       {
           status=readCDTEXTbyTrack((unsigned char)trackIndex);
           usleep(POLLING_TIMEOUT*2);
       }
    }


    if(m_bCDTextInfoRead && tocDataOneTrack)
    {
        tocDataOneTrack->type = FT_AUDIO;
        tocDataOneTrack->trackNumber = (unsigned int)trackIndex;
        snprintf(tocDataOneTrack->fileName, sizeof(tocDataOneTrack->fileName), "file%d.cda", trackIndex);
        tocDataOneTrack->fileFormat = FFT_UNKNOWN;
        tocDataOneTrack->notPlayable = FNP_PLAYABLE;
        if(mtrackInformation[0].u8Title)
        {
            strncpy_r(tocDataOneTrack->metaData4,(const char*)mtrackInformation[0].u8Title, sizeof(tocDataOneTrack->metaData4));
            LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(tocDataOneTrack->metaData4), sizeof(tocDataOneTrack->metaData4));
        }
        if(mtrackInformation[trackIndex].u8Performer)
        {
            strncpy_r(tocDataOneTrack->metaData2, (const char*)mtrackInformation[trackIndex].u8Performer, sizeof(tocDataOneTrack->metaData2));
            LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(tocDataOneTrack->metaData2), sizeof(tocDataOneTrack->metaData2));
        }
        if(mtrackInformation[trackIndex].u8Title)
        {
            strncpy_r(tocDataOneTrack->metaData3, (const char*)mtrackInformation[trackIndex].u8Title, sizeof(tocDataOneTrack->metaData3));
            LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(tocDataOneTrack->metaData3), sizeof(tocDataOneTrack->metaData3));
        }
        if(trackIndex > m_discInfo.totalTrack )
        {
            tocDataOneTrack->isEOF = 1;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("!!! CD text not Read !!!"));
    }




    return status;
}
#endif

tResult DVDControlInterface::getCDTextInfo(OUT tFiles *tocDataOneTrack,unsigned char trackIndex)
{
    ENTRY;
    tResult status=0;
    if((tocDataOneTrack) && (trackIndex > 0))
    {
        tocDataOneTrack->type = FT_AUDIO;
        tocDataOneTrack->trackNumber = (unsigned int)trackIndex;
        snprintf(tocDataOneTrack->fileName, sizeof(tocDataOneTrack->fileName), "file%d.cda", trackIndex);
        tocDataOneTrack->fileFormat = FFT_UNKNOWN;
        tocDataOneTrack->notPlayable = FNP_PLAYABLE;
        strncpy_r(tocDataOneTrack->metaData4,(const char*)mToc.albumName, sizeof(tocDataOneTrack->metaData4));
        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(tocDataOneTrack->metaData4), sizeof(tocDataOneTrack->metaData4));
        strncpy_r(tocDataOneTrack->metaData2, (const char*)mToc.arTrack[trackIndex-1].performer, sizeof(tocDataOneTrack->metaData2));
        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(tocDataOneTrack->metaData2), sizeof(tocDataOneTrack->metaData2));
        strncpy_r(tocDataOneTrack->metaData3, (const char*)mToc.arTrack[trackIndex-1].title, sizeof(tocDataOneTrack->metaData3));
        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(tocDataOneTrack->metaData3), sizeof(tocDataOneTrack->metaData3));
        if(trackIndex > m_discInfo.totalTrack )
        {
            tocDataOneTrack->isEOF = 1;
        }
    }
    else
    {
        ETG_TRACE_FATAL(("!!! CD text not Read !!!"));
    }
    ETG_TRACE_USR4(("!!! getCDTextInfo ::: track index %d !!!",(unsigned int)trackIndex));
    ETG_TRACE_USR4(("!!! getCDTextInfo ::: metadata4  %s !!!",tocDataOneTrack->metaData4));
    ETG_TRACE_USR4(("!!! getCDTextInfo ::: metadata2  %s !!!",tocDataOneTrack->metaData2));
    ETG_TRACE_USR4(("!!! getCDTextInfo ::: metadata3  %s !!!",tocDataOneTrack->metaData3));
    return status;
}


tResult DVDControlInterface::readCDText()
{
    ENTRY
    tResult status = 0;
    unsigned int totalTrack = 0;
    totalTrack = (unsigned int)(m_discInfo.totalTrack);

    if(totalTrack == 0)
    {
        status =  SendDiscInformationDataRequest(true);
        usleep(POLLING_TIMEOUT*2);
        totalTrack = (unsigned int)(m_discInfo.totalTrack);
    }
    if(totalTrack != 0)
    {
            status=readCDTEXTAlbum();
            if(status == MP_NO_ERROR)
            {
                for(unsigned int i=1 ; i <= totalTrack ;i++)
                {
                    usleep(POLLING_TIMEOUT*2);
                    status=readCDTEXTbyTrack((unsigned char)i);
                    m_bCDTextInfoRead = true;
                    if(status != MP_NO_ERROR)
                    {
                        clearCDText();
                        break;
                    }
                    usleep(POLLING_TIMEOUT*2); // take some time to fetch all information
                }
                usleep(POLLING_TIMEOUT*6); // take some time to fetch all information
            }

    }
    return status;
}
#if 0
tResult DVDControlInterface::fillDefaultCDText()
{
    for(int trackIndex = 0 ; trackIndex < m_audioCDInfo.totalTrack +1 ;trackIndex++)
    {
        mtrackInformation[trackIndex].u8CharacterCode = 0;
        mtrackInformation[trackIndex].u8LanguageIndex = 0;
        mtrackInformation[trackIndex].u8Title = new unsigned char[CD_DEFAULT_TEXT_LENGTH];
        if(mtrackInformation[trackIndex].u8Title)
        {
            if(trackIndex == 0)
            {
               //album name will be unkwown
                snprintf(mtrackInformation[trackIndex].u8Title, CD_DEFAULT_TEXT_LENGTH ,"unknown");
            }
            else
            {
                snprintf(mtrackInformation[trackIndex].u8Title, CD_DEFAULT_TEXT_LENGTH , "Track%d", trackIndex);
            }
        }
        else
        {
            return MP_DVD_INTERFACE_ERROR ;
        }
        mtrackInformation[trackIndex].u8Performer = new unsigned char[CD_DEFAULT_TEXT_LENGTH];
        if(mtrackInformation[trackIndex].u8Performer)
        {
        snprintf(mtrackInformation[trackIndex].u8Performer, CD_DEFAULT_TEXT_LENGTH ,"unknown");
        }
        else
        {
            return MP_DVD_INTERFACE_ERROR ;
        }

    }
}
#endif
void DVDControlInterface::clearCDText()
{
    ENTRY
    for(int trackIndex = 0 ; trackIndex < CD_MAX_TRACK_NUMBER +1;trackIndex++)
    {
        mtrackInformation[trackIndex].u8CharacterCode = 0;
        mtrackInformation[trackIndex].u8LanguageIndex = 0;
        memset(mtrackInformation[trackIndex].u8Title , 0 , DATA_BUFFER_LENGTH);
        memset(mtrackInformation[trackIndex].u8Performer , 0 , DATA_BUFFER_LENGTH);
    }
    m_bCDTextInfoRead = false;
}
void DVDControlInterface::convertPlayTimeInformation()
{
    ENTRY
    m_PlayBackState.PBState = PE_PBS_LOADINGSTATE;
    m_PlayBackState.speed = (me::speed_e)0;
    switch(m_PlayBackInfo.m_playbackState)
    {
        case DVD_STOP :
        case RESUME_STOP:
            m_PlayBackState.PBState  = PE_PBS_STOPPEDSTATE;
            break;
        case DVD_PAUSE:
        case AUTO_PAUSE_STILL:
            m_PlayBackState.PBState  = PE_PBS_PAUSEDSTATE;
            break;
        case DVD_PLAY :
            m_PlayBackState.PBState  = PE_PBS_PLAYINGSTATE;
            break;
        case FAST_FWD_1:
            m_PlayBackState.PBState  = PE_PBS_FASTFORWARDSTATE;
            m_PlayBackState.speed = (me::speed_e)1;
            break;
        case FAST_FWD_2:
            m_PlayBackState.PBState  = PE_PBS_FASTFORWARDSTATE;
            m_PlayBackState.speed = (me::speed_e)2;
            break;
        case FAST_FWD_3:
            m_PlayBackState.PBState  = PE_PBS_FASTFORWARDSTATE;
            m_PlayBackState.speed = (me::speed_e)3;
            break;
        case SLOW_FWD_1:
            m_PlayBackState.PBState  = PE_PBS_FASTFORWARDSTATE;
            m_PlayBackState.speed = (me::speed_e)1;
            break;
        case SLOW_FWD_2:
            m_PlayBackState.PBState  = PE_PBS_FASTFORWARDSTATE;
            m_PlayBackState.speed = (me::speed_e)2;
            break;
        case SLOW_FWD_3 :
            m_PlayBackState.PBState  = PE_PBS_FASTFORWARDSTATE;
            m_PlayBackState.speed = (me::speed_e)3;
            break;
        case FAST_BWD_1:
            m_PlayBackState.PBState  = PE_PBS_FASTREVERSESTATE;
            m_PlayBackState.speed = (me::speed_e)1;
            break;
        case FAST_BWD_2:
            m_PlayBackState.PBState  = PE_PBS_FASTREVERSESTATE;
            m_PlayBackState.speed = (me::speed_e)2;
            break;
        case FAST_BWD_3:
            m_PlayBackState.PBState  = PE_PBS_FASTREVERSESTATE;
            m_PlayBackState.speed = (me::speed_e)3;
            break;
        case SLOW_BWD_1:
            m_PlayBackState.PBState  = PE_PBS_FASTREVERSESTATE;
            m_PlayBackState.speed = (me::speed_e)1;
            break;
        case SLOW_BWD_2:
            m_PlayBackState.PBState  = PE_PBS_FASTREVERSESTATE;
            m_PlayBackState.speed = (me::speed_e)2;
            break;
        case SLOW_BWD_3:
            m_PlayBackState.PBState  = PE_PBS_FASTREVERSESTATE;
            m_PlayBackState.speed = (me::speed_e)3;
            break;
        default :
            m_PlayBackState.PBState = PE_PBS_ERRORSTATE;
            break;
    }
    tPlaytime elapsedPlaytime = 0;
    tPlaytime totalPlaytime = 0;
    unsigned char defaultPlaytimebuffer[12];
    memset(defaultPlaytimebuffer,0xbb,12);
    if(memcmp(&m_PlayBackInfo, defaultPlaytimebuffer,12) != 0) // if it is not 0xbb then update else we will populate junk values in hmi
    {

        if(m_PlayBackInfo.currentTrackTotalHours  == 0xbb)
        {
            m_PlayBackInfo.currentTrackTotalHours = 0;
        }
        if(m_PlayBackInfo.currentTrackTotalMinutes  == 0xbb)
        {
            m_PlayBackInfo.currentTrackTotalMinutes = 0;
        }
        convertHexEquivalentDecimal(m_PlayBackInfo.PTimeHours);
        convertHexEquivalentDecimal(m_PlayBackInfo.PTimeMinutes);
        convertHexEquivalentDecimal(m_PlayBackInfo.PTimeSeconds);
        convertHexEquivalentDecimal(m_PlayBackInfo.currentChapterRemHours);
        convertHexEquivalentDecimal(m_PlayBackInfo.currentChapterRemMinutes);
        convertHexEquivalentDecimal(m_PlayBackInfo.currentChapterRemSeconds);
        //TotalPlaytime is current track's remaining time but for DVD Video and DVD Audio Total Time is the addition of Play time and remaining chapter time
        if((m_discType == DISC_DVD_VIDEO) || (m_discType == DISC_DVD_AUDIO))
        {
            /*VARTRACE(m_PlayBackInfo.PTimeHours);
            VARTRACE(m_PlayBackInfo.PTimeMinutes);
            VARTRACE(m_PlayBackInfo.PTimeSeconds);
            VARTRACE(m_PlayBackInfo.currentChapterRemHours);
            VARTRACE(m_PlayBackInfo.currentChapterRemMinutes);
            VARTRACE(m_PlayBackInfo.currentChapterRemSeconds);*/
            m_PlayBackInfo.currentTrackTotalHours = m_PlayBackInfo.PTimeHours + m_PlayBackInfo.currentChapterRemHours;
            m_PlayBackInfo.currentTrackTotalMinutes = m_PlayBackInfo.PTimeMinutes + m_PlayBackInfo.currentChapterRemMinutes;
            m_PlayBackInfo.currentTrackTotalSeconds = m_PlayBackInfo.PTimeSeconds + m_PlayBackInfo.currentChapterRemSeconds;
            /*VARTRACE(m_PlayBackInfo.currentTrackTotalHours);
            VARTRACE(m_PlayBackInfo.currentTrackTotalMinutes);
            VARTRACE(m_PlayBackInfo.currentTrackTotalSeconds);*/
        }
        else
        {
            convertHexEquivalentDecimal(m_PlayBackInfo.currentTrackTotalHours);
            convertHexEquivalentDecimal(m_PlayBackInfo.currentTrackTotalMinutes);
            convertHexEquivalentDecimal(m_PlayBackInfo.currentTrackTotalSeconds);
        }
        elapsedPlaytime = ((m_PlayBackInfo.PTimeHours * 3600) + (m_PlayBackInfo.PTimeMinutes *60) + m_PlayBackInfo.PTimeSeconds) * 1000;
        totalPlaytime = ((m_PlayBackInfo.currentTrackTotalHours * 3600) + (m_PlayBackInfo.currentTrackTotalMinutes *60) + m_PlayBackInfo.currentTrackTotalSeconds) * 1000;


    }
    ETG_TRACE_USR4((" ELAPSED TIME %d total time %d",elapsedPlaytime,totalPlaytime));

    m_PlayBackState.position.ms = (tPEMilliseconds)elapsedPlaytime;
    m_PlayBackState.duration.ms = (tPEMilliseconds)totalPlaytime;

    m_PlayBackState.m_PEhandle = m_PlayBackInfo.m_PEhandle;
    m_PlayBackState.mCurrentGroupPlaying= m_PlayBackInfo.mCurrentGroupPlaying;
    m_PlayBackState.mCurrentTrackPlaying = m_PlayBackInfo.mCurrentTrackPlaying;

    return;
}

tResult DVDControlInterface::setSubtitle(tSubtitleControl selection , unsigned char subtitleNumber)
{
    ENTRY
    unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY,KEY_SUBTITLE,(unsigned char)selection,subtitleNumber};
    int status = MP_NO_ERROR;
    status = ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
    return status;

}

tResult DVDControlInterface::setAudioChannel(unsigned char selection , unsigned char audioChannel)
{
    ENTRY
    unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY,KEY_AUDIO,selection,audioChannel};
    int status = MP_NO_ERROR;
    status = ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
    return status;

}

tResult DVDControlInterface::sendNavigationCommand(unsigned char naviKey)
{
    ENTRY
    int status = MP_NO_ERROR;
    switch(naviKey)
    {
      case UPPER:
      case LOWER:
      case RIGHT:
      case LEFT:
      {
          unsigned char KeyCMD[3]={BE_COMMAND_REQUEST_KEY, KEY_CURSOR, naviKey};
          status = ExecuteMessage(KeyCMD,sizeof(KeyCMD));
          break;
      }
      case KEY_RETURN:
      case KEY_ENTER:
      {
          unsigned char KeyCMD[KeyCMDLength]={BE_COMMAND_REQUEST_KEY,naviKey};
          status = ExecuteMessage(KeyCMD,KeyCMDLength);
          break;
      }
      default :
          ETG_TRACE_USR4((" sendNavigationCommand: Not a valid key %x",naviKey));
          break;
    }
    return status;
}
tResult DVDControlInterface::directSearch(tU16 groupNumber,tU16 trackNumber)
{
    ENTRY
    int status = MP_NO_ERROR;
    unsigned char KeyCMD[6]={BE_COMMAND_REQUEST_KEY,KEY_DIRECT_SEARCH,(unsigned char)(groupNumber>>8), (unsigned char)(groupNumber & 0xff),(unsigned char)(trackNumber>>8), (unsigned char)(trackNumber & 0xff)};
    ETG_TRACE_USR4((" Command: %x %x %x %x",KeyCMD[2],KeyCMD[3],KeyCMD[4],KeyCMD[5]));
    status = ExecuteMessage(KeyCMD,sizeof(KeyCMD));
    return status;
}

tResult DVDControlInterface::titleSearch(tU16 titleNumber)
{
   ENTRY
   int status = MP_NO_ERROR;
   unsigned char KeyCMD[4]={BE_COMMAND_REQUEST_KEY,KEY_TITLE_SEARCH,(unsigned char)(titleNumber>>8), (unsigned char)(titleNumber & 0xff)};
   ETG_TRACE_USR4((" Command: %x %x ",KeyCMD[2],KeyCMD[3]));
   status = ExecuteMessage(KeyCMD,sizeof(KeyCMD));
   return status;
}

tResult DVDControlInterface::directNumber(tU16 directNumber)
{
   ENTRY
   char hex_tmp[10]={0};
   sprintf(hex_tmp,"0x%d", directNumber);
   directNumber = strtol(hex_tmp, NULL , 0);
   int status = MP_NO_ERROR;
   ETG_TRACE_USR4((" DVDControlInterface: direct number to select is : %x ",directNumber));
   unsigned char KeyCMD[4]={BE_COMMAND_REQUEST_KEY,KEY_DIRECT_NUMBER,(unsigned char)(directNumber>>8), (unsigned char)(directNumber & 0xff)};
   status = ExecuteMessage(KeyCMD,sizeof(KeyCMD));
   return status;
}
tResult DVDControlInterface::setAngle(unsigned char selection , unsigned char angleNumber)
{
    ENTRY

    unsigned char KeyCMD[KeyCMDExtendedLength]={BE_COMMAND_REQUEST_KEY,KEY_ANGLE,selection,angleNumber};
    int status = MP_NO_ERROR;
    status = ExecuteMessage(KeyCMD,KeyCMDExtendedLength);
    return status;

}

tResult DVDControlInterface::ejectDisc()
{
    ENTRY


     if(!m_bBackendMode)
     {
     SwitchtoBackendMode();
     }

    for(unsigned int i = 0 ; i < 10; i++)
    {
        usleep(POLLING_TIMEOUT*4); // wait for switch to backend mode
        if(m_bBackendMode == true)
        {
            break;
        }
    }

    int status = MP_NO_ERROR;
    if(m_bBackendMode == true)
    {
     usleep(POLLING_TIMEOUT*15); // wait for sometime 500ms else device Open call fails in the next run
    status = ExecuteMessage(EjectCMD,sizeof(EjectCMD));
    }
    else
    {
     ETG_TRACE_ERR((" EJECT Command Failed , drive not in backend mode"));
     status =  MP_ERR_DVD_COMMAND_EXECUTION;
    }
    return status;
}

tResult DVDControlInterface::CMSkip(tSkipTiming skipTime)
{
    int status = MP_NO_ERROR;
    if(m_bSkipStatus)
    {
    unsigned char KeyCMD[3]={BE_COMMAND_REQUEST_KEY,KEY_SKIP,(unsigned char)skipTime};
    status = ExecuteMessage(KeyCMD,sizeof(KeyCMD));
    }
    else
    {
        status = MP_DVD_SKIP_NOT_POSSIBLE;
    }
    return status;
}

tResult DVDControlInterface::setMenuPlayback(tMenuControl menuSelection)
{
    int status = 0;
    unsigned char KeyCMD[3]={BE_COMMAND_REQUEST_KEY,KEY_MENU,(unsigned char)menuSelection};
    status = ExecuteMessage(KeyCMD,sizeof(KeyCMD));
    return status;
}

tResult DVDControlInterface::sendTouchCommand(TouchInput& ptouchInput)
{
    ENTRY
    unsigned char TouchKeyCMD[11];
    TouchKeyCMD[0] = BE_COMMAND_REQUEST_KEY;
    TouchKeyCMD[1] = KEY_TOUCH;
    TouchKeyCMD[2] = (unsigned char)(ptouchInput.CurrentX>>8);
    TouchKeyCMD[3] = (unsigned char)(ptouchInput.CurrentX & 0xff);
    TouchKeyCMD[4] = (unsigned char)(ptouchInput.CurrentY>>8);
    TouchKeyCMD[5] = (unsigned char)(ptouchInput.CurrentY & 0xff);
    TouchKeyCMD[6] = (unsigned char)(ptouchInput.OverallX>>8);
    TouchKeyCMD[7] = (unsigned char)(ptouchInput.OverallX & 0xff);
    TouchKeyCMD[8] = (unsigned char)(ptouchInput.OverallY>>8);
    TouchKeyCMD[9] = (unsigned char)(ptouchInput.OverallY & 0xff);
    TouchKeyCMD[10] = (unsigned char)(ptouchInput.touchCommand);
    int status = 0;
    status = ExecuteMessage(TouchKeyCMD,sizeof(TouchKeyCMD),false);
    return status;
}

tResult DVDControlInterface::setDeviceActive(bool deviceStatus ,int setFPGARegistry)
{
    ENTRY
    Locker locker(&m_DeviceActiveLock);
    m_bIsDeviceActive = deviceStatus;
    if (deviceStatus == true)
    {
        m_PlayBackInfo.m_playBackMode   =  0xFF;
        if(setFPGARegistry == 1)
        {
        selectFPGAForDVDPlayback();
        }
    }
    return MP_NO_ERROR;
}

bool DVDControlInterface::getDeviceActive()
{
    ENTRY
    Locker locker(&m_DeviceActiveLock);
    return m_bIsDeviceActive;
}

void DVDControlInterface::convertHexEquivalentDecimal(unsigned char &byte)
{
  char hex_tmp[5]={0};
  sprintf(hex_tmp,"%x", byte);
  int i = atoi (hex_tmp);
  byte = (unsigned char)i;
}

void DVDControlInterface::selectFPGAForDVDPlayback()
{
     ENTRY
    selectDvdI2sline();
    selectDvdBT656Line();
    return;
}
/**
 * Helper function to select dtvi2s line.
 */
void DVDControlInterface::selectDvdI2sline()
{
     ENTRY
    unsigned char i2saudio;
    T_I2CDATA i2c_Audio;
    i2c_Audio.devicebusname = I2C_DEVICE;
    i2c_Audio.deviceaddr = SUB_PCB_FPGA_ADDR;
    i2c_Audio.registersubaddr = 0x23;
    if(i2cRead(i2c_Audio,&i2saudio,1) > FPGA_DEVICE_OPEN_ERR)
    {
        i2saudio &= 0x5F;  // BIT 7,6 should be reset 5,4 Should be 01 for i2s_in1
        i2saudio |= 0x50;
        //i2saudio = 0x58;
        if(i2cWrite(i2c_Audio,&i2saudio,1) > FPGA_DEVICE_OPEN_ERR)
        {
            ETG_TRACE_USR4((" selectDvdI2sline : i2s_in1  param for DVD set "));
        }
    }

}


/**
 * Helper function to select BT656 line.
 */
void DVDControlInterface::selectDvdBT656Line()
{
    //setting BT-656 switch
     ENTRY
    unsigned char i2cvideo;
    T_I2CDATA i2c_video;
    i2c_video.devicebusname = I2C_DEVICE;
    i2c_video.deviceaddr = SUB_PCB_FPGA_ADDR;
    i2c_video.registersubaddr = SUB_PCB_FPGA_GPOUT2_ADDR;
    if(i2cRead(i2c_video,&i2cvideo,1) > FPGA_DEVICE_OPEN_ERR)
    {
        i2cvideo  |= 0x80; // 7th bit set to 1 to enable DVD
        //i2cvideo  = 0xCA; // 7th bit set to 1 to enable DVD
        if(i2cWrite(i2c_video,&i2cvideo,1) > FPGA_DEVICE_OPEN_ERR)
        {
            ETG_TRACE_USR4((" selectDvdBT656Line : Video param for DVD set "));
        }
    }


    unsigned char ntscdatabobbing[33][2] =
    {
            {0xA0,0x00},{0xA1,0x00},{0xA2,0xcf},{0xA3,0x02},{0xA4,0x04},{0xA5,0x00},{0xA6,0xf3},{0xA7,0x00},
            {0xA8,0x00},{0xA9,0x10},{0xAA,0xcf},{0xAB,0x02},{0xAC,0xef},{0xAD,0x00},{0xAE,0x5f},{0xAF,0x00},
            {0xB0,0x87},{0xB1,0x00},{0xB2,0xb3},{0xB3,0x06},{0xB4,0xd7},{0xB5,0x00},{0xB6,0xa7},{0xB7,0x03},
            {0xB8,0xf5},{0xB9,0x00},{0xBA,0xfa},{0xBB,0x00},{0xBC,0x04},{0xBD,0x00},{0xBE,0xf4},{0xBF,0x00},
            {0xC0,0x01}
    };
    T_I2CDATA i2c_Ntsc;
    i2c_Ntsc.devicebusname = I2C_DEVICE;
    i2c_Ntsc.deviceaddr = SUB_PCB_FPGA_ADDR;

    for(unsigned int idx=0;idx<33;++idx)
    {

            i2c_Ntsc.registersubaddr = ntscdatabobbing[idx][0];
            if (!(i2cWrite(i2c_Ntsc,&ntscdatabobbing[idx][1],1)> FPGA_DEVICE_OPEN_ERR))
            {
                ETG_TRACE_USR4((" video ip registry: i2cWrite  failed "));
                break;
            }

        usleep(1000);
    }
}


/**
 * Helper function to Read data to Selected I2C Registry.
 *
 * Steps to Read from a specific location or sub address.
 * 1.Dummy Write for sub address.
 *  a.Send start condition.
 *  b.Send 7-bit slave address with write bit (R/W = 0).
 *  c.Send sub address or location on I2C device where u want to read from, after this the internal
 *   address pointer of I2C device points to location where u want to read from.
 * 2.Read from sub address.
 *  a.Send a repeated start condition.
 *  b.Send 7-bit slave address with read bit (R/W = 1).
 *  c.Now slave will send data to master and master will acknowledge after each byte read.
 *    If it’s the last byte to be read from slave then master will send a not acknowledge.
 *  d.Master send a stop condition to end the transfer.
 *
 *  Note: In case to read directly from device, dummy write is not required and
 *  this interface should not be used.
 *
 */
int DVDControlInterface::i2cRead(T_I2CDATA i2cdata,unsigned char* inputbufr,unsigned char len)
{
     ENTRY
    int retVal = FPGA_DEVICE_OPEN_ERR;
    unsigned char outbufr;
    struct i2c_rdwr_ioctl_data datapackets;
    struct i2c_msg msgs[2];
    int i2cFd = open(i2cdata.devicebusname,O_RDWR);
    if(i2cFd > FPGA_DEVICE_OPEN_ERR)
    {
        outbufr = i2cdata.registersubaddr;
        msgs[0].addr = i2cdata.deviceaddr;
        msgs[0].flags= 0;
        msgs[0].len = sizeof(outbufr);
        msgs[0].buf = &outbufr;

        msgs[1].addr = i2cdata.deviceaddr;
        msgs[1].flags = I2C_M_RD;
        msgs[1].len = len;
        msgs[1].buf = inputbufr;

        datapackets.msgs = msgs;
        datapackets.nmsgs = 2;

        int noofbytes = ioctl(i2cFd, I2C_RDWR, &datapackets);
        ETG_TRACE_USR4((" i2cRead ,no.of bytes read : %d ",noofbytes));
        if(noofbytes < 0)
        {

             ETG_TRACE_ERR((" i2cRead   : Read Failure !!!"));
        }
        else
        {
            retVal = 0;
        }
        close(i2cFd);
    }
    else
    {
          ETG_TRACE_ERR((" i2cRead   : Device Open Failure !!!"));
    }
    return retVal;
}


/**
 * Helper function to Write data to Selected I2C Registry.
 *
 * Steps to Read from a specific location or sub address.
 * a.Send start condition.
 * b.Send 7-bit slave address with write bit (R/W = 0).
 * c.Send data bytes to write.
 * d.Master send a stop condition to end the transfer.
 *
 */
int DVDControlInterface::i2cWrite(T_I2CDATA i2cdata,unsigned char* data,unsigned char len)
{
     ENTRY
    int retVal = FPGA_DEVICE_OPEN_ERR;
    struct i2c_rdwr_ioctl_data datapackets;
    struct i2c_msg msgs[1];
    int i2cFd = open(i2cdata.devicebusname,O_WRONLY);
    unsigned char outbuff[64]; // max page size: 64 bytes :Todo check if limit is required,as per protocol we can any no.of bytes.
    if((i2cFd > FPGA_DEVICE_OPEN_ERR))
    {
        if((len < 64) && (data != NULL))
        {
            outbuff[0] = i2cdata.registersubaddr;// supports only 8 bit address selection.
            for(unsigned char idx = 0;idx < len ; ++idx)
            {
                outbuff[1+idx] = data[idx];
            }
            msgs[0].addr = i2cdata.deviceaddr;  //Only 7bit slave address
            msgs[0].flags= 0;
            msgs[0].len = (len + 1);            // data length + registry sub address.
            msgs[0].buf = outbuff;
            retVal = 0;

            datapackets.msgs = msgs;
            datapackets.nmsgs = 1;
            int noofbytes = ioctl(i2cFd, I2C_RDWR, &datapackets);
            ETG_TRACE_USR4((" i2cWrite ,no.of bytes written : %d ",noofbytes));
            if(noofbytes < 0)
            {
                 ETG_TRACE_ERR((" i2cWrite   : Write Failure !!!"));
            }
            else
            {
                retVal = 0;
            }
        }
        close(i2cFd);
    }
    else
    {
        ETG_TRACE_ERR((" i2cWrite   : Device open Failure !!!"));
    }
    return retVal;
}

tResult DVDControlInterface::getTemperature()
{

    ENTRY
    unsigned char TempKeyCMD[3];
    TempKeyCMD[0] = BE_COMMAND_REQUEST_DATA_INFO;
    TempKeyCMD[1] = BE_COMMAND_REQUEST_DATA_INFO_TEMPERATURE;
    TempKeyCMD[2] = 0x00;
    tResult status = MP_NO_ERROR;
    status = ExecuteMessage(TempKeyCMD,sizeof(TempKeyCMD));
    return status;
}

tOperationModeStatus DVDControlInterface::getDriveMode()
{
    ENTRY
    if(m_bBackendMode == true)
    {

        return BACKEND_MODE ;

    }
    else
    {
        return  MASS_STORAGE_MODE ;
    }
}

void DVDControlInterface::revertModetoBackend()
{
    ENTRY
    VARTRACE(m_bBackendMode);
    if(m_bDisablePolling == true)
    {
        m_bRevertToBEMode = true ;
    }
    VARTRACE(m_bRevertToBEMode);
    return;
}
