#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CS_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/CSControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CS_CONTROL
#endif
#endif

#include "LocalSPM.h"
#include "Dispatcher.h"
#include "FunctionTracer.h"
#include "MediaPlayer_ErrorCodes.h"
#include <sys/types.h>
#include <dirent.h>
#include <signal.h>
#include "FastUTF8.h"
#include "VarTrace.h"
#include "TimeTrace.h"

#include "CSControl.h"
#include "RequestResponseSM.h"
//SPM part

void CSControl::Create()
{
    ENTRY

    /* Create the state machine */
    CSControlSM::Create();

    CreateDone(0);
}

tResult CSControl::Init(tInitReason reason)
{
    ENTRY
    VARTRACE(reason);

    /* Init the state machine */
    CSControlSM::Init();
    SetAnswerTimeout(CS_CTRL_SM_ANSWER_TIMEOUT_MS); // Set answer timeout

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);

    return InitDone(0);
}

tResult CSControl::InitSM()
{
    ENTRY

    m_Mutex.lock();
    InitMediaObject(OUT m_PlayMediaObject);
    m_Mutex.unlock();

    m_StartPosition = 0;
    m_AudioOutputDevice[0] = '\0';

    return MP_NO_ERROR;
}

tResult CSControl::Run()
{
    ENTRY

    /*Create and start threads */
    LocalSPM::GetThreadFactory().Do(IN this, 0, NULL); //CSControl inclusive state machine

    return RunDone(0);
}

void CSControl::Do(int functionID, void *ptr)
{
    ENTRY

    //set the threads name
    LocalSPM::GetThreadFactory().SetName(CSControlSM::GetSMNameFull());

    switch(functionID)
    {
        case 0:
        {
            while(CSControlSM::STATE_MACHINE_FINISHED != CSControlSM::StateMachine_Main()){}
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("CSControl::Do: No thread defined for functionID: %d", functionID));
            break;
        }
    }
}

tResult CSControl::Stop()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CSControl::StopEventProcessed()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    if(!LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Unregister for further playback events */
        ret = LocalSPM::GetIPCProvider().UnregisterObserver(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::UnregisterObserver (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Send stop done to SPM in the transition to final state in state machine */
    return StopDone(0);
}

tResult CSControl::Done()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN this);

    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CSControl::DoneEventProcessed()
{
    ENTRY

    //Cleanup threads
    LocalSPM::GetThreadFactory().CleanUpThreads(this);

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

char *CSControl::GetSMStateName(tGeneralString stateName, size_t size)
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}


//Playback control part

tResult CSControl::StartAllocateAudioInput(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tReturnValue returnValue = true;

    ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(METHOD_RETURN, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartDeAllocateAudioInput()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* For USB no need to deallocate audio input device */

    /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tReturnValue returnValue = true;

    ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(METHOD_RETURN, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartSwitchObserver(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine()) { //pip2hi

        /* Switch the observer to this state machine */
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::SWITCH_OBSERVER", "CSControlSM", "CSControlSM::METHOD_RETURN");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send SwitchObserver to PlayerEngine via DBUS */
        RegisterReleaseEvent(METHOD_RETURN);
        ret = LocalSPM::GetIPCProvider().SwitchObserver(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::SwitchObserver (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartStreaming(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tPEPlaybackState status = PE_PBS_LOADINGSTATE;

    /* For USB no need to start streaming */
    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake MediaEngine response: Send expected event to waiting state machine immediately */
        me::reason_e reason = REASON_OK;
        me::speed_e speed = ME_SPEED_NORMAL;

        m_Mutex.lock();
        tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
        m_Mutex.unlock();

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterSTART_STREAMING_ANSWER(OUT parameterString, IN size, IN handle, IN status, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(START_STREAMING_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tMetadata metadata = { 0 };

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartStopStreaming()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* For USB no need to stop streaming
     * Send STOP_STREAMING_ANSWER message to release own waiting state */
    ret = ParameterSTOP_STREAMING_ANSWER(OUT parameterString, IN size, IN deviceID);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(STOP_STREAMING_ANSWER, IN parameterString);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StopStreamingAnswer(tDeviceID deviceID)
{
    ENTRY
    (void)deviceID;
    tPEPlaybackState status = PE_PBS_STOPPEDSTATE;

    /* Send answer to waiting state machine */
    if( LocalSPM::GetDataProvider().UseMediaEngine() )
    {
        m_Mutex.lock();
        tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
        m_Mutex.unlock();

        PlaybackStatusNew(IN handle, IN status, IN REASON_OK, IN ME_SPEED_NORMAL);
    }
    else
    {
        tMetadata metadata = { 0 };

        PlaybackStatus(IN status, IN metadata, IN metadata, IN metadata, IN metadata);
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartPlay(const tDeviceType deviceType,
                              const tDeviceID deviceID,
                              const tURL URL,
                              const tMountPoint mountPoint,
                              const tUUID uuid,
                              const tPEHandle handle,
                              const tPlaytime position,
                              const tStreaming streaming)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    (void)uuid;
    VARTRACE(handle);
    VARTRACE(position);
    VARTRACE(streaming);

    /* Update media object to play */
    m_Mutex.lock();
    InitMediaObject(OUT m_PlayMediaObject);
    m_PlayMediaObject.objectID = (tObjectID)handle;
    m_PlayMediaObject.deviceID = deviceID;
    strncpy_r(OUT m_PlayMediaObject.fileName, IN URL, IN sizeof(m_PlayMediaObject.fileName));
    strncpy_r(OUT m_PlayMediaObject.mountPoint, IN mountPoint, IN sizeof(m_PlayMediaObject.mountPoint));
    m_Mutex.unlock();

    m_StartPosition = position;

    /* Send METADATA_FOR_PLAYBACK message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tURL mountPointURL = {0};
    strncpy_r(mountPointURL, "/opt/bosch/test/data/GMP/stick_2/Supertramp/Breakfast_In_America/Supertramp_-_Breakfast_in_America_-_03_-_Goodbye_Stranger.mp3", sizeof(mountPointURL));
    ParameterMETADATA_FOR_PLAYBACK(OUT parameterString, IN size, IN handle, IN mountPointURL);
    SendEvent(METADATA_FOR_PLAYBACK, IN parameterString);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartPlayWithMetadata(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", mountPointURL, (int)ME_SPEED_NORMAL, m_StartPosition, handle, m_AudioOutputDevice);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "CSControlSM::PLAY_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        tPlaypointFormat playpointFormat = PPF_ABSOLUTE; //absolute time in milliseconds
        tURL mountPointURL2PE;
        // thm4hi: problem is: the player engine in ubuntu does not react as the one in the target.

#if TARGET_BUILD
        /* thm4hi: for old player engine: do a fake conversion to utf8 */
        toUtf8Fake(OUT mountPointURL2PE, IN sizeof(mountPointURL2PE), IN mountPointURL);
#else
        strncpy_r(OUT mountPointURL2PE, IN mountPointURL, IN sizeof(mountPointURL2PE));
#endif

        /* Send NewPlaySlot to PlayerEngine via DBUS */
        RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().NewPlaySlot(IN this, IN mountPointURL2PE, IN m_StartPosition, IN playpointFormat);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::NewPlaySlot (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartPlaybackAction(const tDeviceType deviceType, //Roadmap 13008 RemoteControl
            const tDeviceID deviceID, const tURL URL, const tMountPoint mountPoint,
            const tPlaybackAction playbackAction, const tNextPrevSkipCount skipcount) //finished 0%
{
    ENTRY;
    VARTRACE(deviceType);
    VARTRACE(deviceID);
    VARTRACE(URL);
    VARTRACE(mountPoint);
    VARTRACE(playbackAction);
    VARTRACE(skipcount);

    switch (playbackAction) {
    case PBA_PLAY:
        StartResume(deviceType, deviceID, URL, mountPoint);
        break;
    case PBA_PAUSE:
    case PBA_STOP:
        StartPause(deviceType, deviceID, URL, mountPoint);
        break;
    case PBA_PREV:
        break;
    case PBA_NEXT:
        break;
    case PBA_FFWD_START:
        StartFfwdStart(deviceType, deviceID, URL, mountPoint, 10);
        break;
    case PBA_FREV_START:
        StartFrevStart(deviceType, deviceID, URL, mountPoint, 10);
        break;
    case PBA_FREV_STOP:
        StartFrevStop(deviceType, deviceID, URL, mountPoint);
        break;
    case PBA_FFWD_STOP:
        StartFfwdStop(deviceType, deviceID, URL, mountPoint);
        break;
    default:
        ETG_TRACE_ERR(("StartPlaybackAction unsupported action"));
        break;
    }

    m_Mutex.lock();
    const tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_Mutex.unlock();
    const tPEPlaybackState status = PE_PBS_STOPPEDSTATE;
    const me::reason_e reason = REASON_OK;
    const me::speed_e speed = ME_SPEED_NORMAL;

    //send answer
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ParameterPLAYBACK_ACTION_ANSWER(OUT parameterString, IN size, IN handle, IN status, IN reason, IN speed);
    SendEvent(PLAYBACK_ACTION_ANSWER, IN parameterString);

    return MP_NO_ERROR;
}

tResult CSControl::StartStop(const tDeviceType deviceType,
                              const tDeviceID deviceID,
                              const tURL URL,
                              const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::STOP", NULL, "CSControlSM::STOP_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StopSlot to PlayerEngine via DBUS */
        RegisterReleaseEvent(STOP_ANSWER);
        ret = LocalSPM::GetIPCProvider().StopSlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StopSlot (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Reset media object to play */
    ETG_TRACE_USR3(("Reset media object to play"));
    m_Mutex.lock();
    InitMediaObject(OUT m_PlayMediaObject);
    m_Mutex.unlock();

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartPause(const tDeviceType deviceType,
                               const tDeviceID deviceID,
                               const tURL URL,
                               const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", mountPointURL, (int)ME_SPEED_NONE, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);
        /* explanation: the gcc seems to find a wrong method without a second elipsis parameter.
         * It find the va_list version of this method which is private to SMF. */

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PAUSE", args, "CSControlSM::PAUSE_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send PauseSlot to PlayerEngine via DBUS */
        tPlaytime position = 0; //dummy position, only used in case of being not in state playing
        tPlaypointFormat playpointFormat = PPF_ABSOLUTE; //absolute time in milliseconds

        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tURL mountPointURL2PE;
        // thm4hi: problem is: the player engine in ubuntu does not react as the one in the target.
    #ifdef TARGET_BUILD
        /* thm4hi: for old player engine: do a fake conversion to utf8 */
        toUtf8Fake(OUT mountPointURL2PE, IN sizeof(mountPointURL2PE), IN mountPointURL);
    #else
        strncpy_r(OUT mountPointURL2PE, IN mountPointURL, IN sizeof(mountPointURL2PE));
    #endif

        RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().PauseSlot(IN this, IN mountPointURL2PE, IN position, IN playpointFormat);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::PauseSlot (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartResume(const tDeviceType deviceType,
                                const tDeviceID deviceID,
                                const tURL URL,
                                const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", mountPointURL, (int)ME_SPEED_NORMAL, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "CSControlSM::RESUME_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send ResumePlaySlot to PlayerEngine via DBUS */
        RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().ResumePlaySlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::ResumePlaySlot (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartFfwdStart(const tDeviceType deviceType,
                                   const tDeviceID deviceID,
                                   const tURL URL,
                                   const tMountPoint mountPoint,
                                   const tCueingRate rate,
                                   const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    (void)IsPlaybackSpeed;
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(rate);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(IN mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", mountPointURL, rate, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "CSControlSM::FFWD_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StartFfwdSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StartFfSlot(IN this, IN rate);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StartFfSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_FASTFORWARDSTATE;
        tMetadata metadata1 = {0};
        strncpy_r(OUT metadata1, IN URL, IN sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartFfwdStop(const tDeviceType deviceType,
                                  const tDeviceID deviceID,
                                  const tURL URL,
                                  const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", mountPointURL, (int)ME_SPEED_NORMAL, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "CSControlSM::FFWD_STOP_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StopFfwdSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StopFfSlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StopFfSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_PLAYINGSTATE;
        tMetadata metadata1 = {0};
        strncpy_r(OUT metadata1, IN URL, IN sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }


    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartFrevStart(const tDeviceType deviceType,
                                   const tDeviceID deviceID,
                                   const tURL URL,
                                   const tMountPoint mountPoint,
                                   const tCueingRate rate,
                                   const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    (void)IsPlaybackSpeed;

    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(rate);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", mountPointURL, -(int)rate, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "CSControlSM::FREV_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StartFrevSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StartFrevSlot(IN this, IN rate);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StartFrevSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_FASTREVERSESTATE;
        tMetadata metadata1 = {0};
        strncpy_r(OUT metadata1, IN URL, IN sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartFrevStop(const tDeviceType deviceType,
                                  const tDeviceID deviceID,
                                  const tURL URL,
                                  const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", mountPointURL, (int)ME_SPEED_NORMAL, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "CSControlSM::FREV_STOP_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StopFrevSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StopFrevSlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StopFrevSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_PLAYINGSTATE;
        tMetadata metadata1 = {0};
        strncpy_r(OUT metadata1, IN URL, IN sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }


    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartSeekTo(const tDeviceType deviceType,
                                const tDeviceID deviceID,
                                const tURL URL,
                                const tMountPoint mountPoint,
                                const tPlaytime position)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(position);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        m_Mutex.lock();
        tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
        m_Mutex.unlock();

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiil", mountPointURL, (int)ME_SPEED_NONE, position, handle);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::SEEK_TO", args, "CSControlSM::SEEK_TO_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send SeekToSlot to PlayerEngine via DBUS */
        tPlaypointFormat playpointFormat = PPF_ABSOLUTE; //absolute time in milliseconds

        //RegisterReleaseEvent(TICK_TIME_ELAPSED);
        ret = LocalSPM::GetIPCProvider().SeekToSlot(IN this, IN position, IN playpointFormat);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::SeekToSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPlaytime elapsedPlaytime = position;
        tPlaytime totalPlaytime = PLAYTIME_NONE;

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(TICK_TIME_ELAPSED, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::StartBuffer(const tDeviceType deviceType,
                               const tDeviceID deviceID,
                               const tURL URL,
                               const tMountPoint mountPoint,
                               const tPEHandle handle)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(handle);

    //@@@ code?

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::DiscardBuffer()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    //@@ code??

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return ret;
}

tResult CSControl::ActionStatus(const tReturnValue returnValue)
{
    ENTRY
    VARTRACE(returnValue);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::BufferStatus(const tSuccess success)
{
    ENTRY
    VARTRACE(success);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

#if 0
    /* map reason to success */
    tSuccess success = SC_NO;
    if (reason >= REASON_OK) {
        success = SC_YES;
    }
#endif

    ret = LocalSPM::GetPlayerManager().ParameterBUFFER_ANSWER(OUT parameterString, IN size, IN success);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::PlaybackStatus(const tPEPlaybackState status,
                                  const tMetadata metadata1,
                                  const tMetadata metadata2,
                                  const tMetadata metadata3,
                                  const tMetadata metadata4,
                                  const tObjectID ObjectID)
{
    ENTRY
    VARTRACE6(status, metadata1, metadata2, metadata3, metadata4, MTY_UNKNOWN);

    tResult ret = MP_NO_ERROR;
    m_Mutex.lock();
    tMediaObject mediaObject =  m_PlayMediaObject;
    m_Mutex.unlock();

    /* Send answer to waiting state machine */
    if( PE_PBS_ERRORSTATE == status )
    {
        /* Validate error code */
        me::reason_e reason;
        ret = ValidateErrorCode(OUT reason, IN metadata2, IN mediaObject.mountPoint);

        /* Send action error instead of answer to waiting state machine */
        HandleActionError(IN reason);
    }
    else
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER(OUT parameterString,
                IN size,
                IN status,
                IN mediaObject.MetadataField1,
                IN mediaObject.MetadataField2,
                IN mediaObject.MetadataField3,
                IN mediaObject.MetadataField4,
                IN mediaObject.title,
                IN mediaObject.mediaType,
                IN mediaObject.metadataConvertFlag,
                IN mediaObject.UUID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::ForwardPlaybackStatus(const tPEPlaybackState status,
                                          const tMetadata metadata1,
                                          const tMetadata metadata2,
                                          const tMetadata metadata3,
                                          const tMetadata metadata4,
                                          const tObjectID ObjectID)
{
    ENTRY
    VARTRACE6(status, metadata1, metadata2, metadata3, metadata4, MTY_UNKNOWN);

    tResult ret = MP_NO_ERROR;
    m_Mutex.lock();
    tMediaObject mediaObject =  m_PlayMediaObject;
    m_Mutex.unlock();

    if( PE_PBS_ERRORSTATE == status )
    {
        /* Validate error code */
        me::reason_e reason;
        ret = ValidateErrorCode(OUT reason, IN metadata2, IN mediaObject.mountPoint);

        /* Forward stream error */
        ForwardStreamError(IN reason);
    }
    else
    {
        /* Send PLAYBACK_STATUS_RESPONSE message to PlayerManger to update playback state */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(messageString));

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString,
                IN size,
                IN status,
                IN mediaObject.MetadataField1,
                IN mediaObject.MetadataField2,
                IN mediaObject.MetadataField3,
                IN mediaObject.MetadataField4,
                IN mediaObject.title,
                IN mediaObject.mediaType,
                IN mediaObject.metadataConvertFlag,
                IN mediaObject.UUID,
                IN ObjectID);

    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult CSControl::PlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime)
{
    ENTRY
    VARTRACE2(elapsedPlaytime, totalPlaytime);

#if 0
    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterSEEK_TO_ANSWER(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }
#else
    m_Mutex.lock();
    tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    tPETimeInfoStruct timeInfoStruct;
    InitPETimeInfoStruct(timeInfoStruct);
    timeInfoStruct.position.ms = (tPEMilliseconds)elapsedPlaytime;
    timeInfoStruct.duration.ms = (tPEMilliseconds)totalPlaytime;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
                 IN size-1,
                 IN DOUBLE_MARSHAL_SEPARATOR,
                 IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
                 IN timeInfoStruct.position.bytes,
                 IN timeInfoStruct.position.pct,
                 IN timeInfoStruct.position.ms,
                 IN timeInfoStruct.duration.bytes,
                 IN timeInfoStruct.duration.ms);

    PlaytimeStatusNew(IN handle, IN timeInfoString);
#endif

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::ForwardPlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime)
{
    ENTRY
    VARTRACE2(elapsedPlaytime, totalPlaytime);

    tResult ret = MP_NO_ERROR;

#if 0
    /* Send TICK_TIME_ELAPSED message to PlayerManger to update playtime */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::TICK_TIME_ELAPSED", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }
#else
    m_Mutex.lock();
    tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    tPETimeInfoStruct timeInfoStruct;
    InitPETimeInfoStruct(timeInfoStruct);
    timeInfoStruct.position.ms = (tPEMilliseconds)elapsedPlaytime;
    timeInfoStruct.duration.ms = (tPEMilliseconds)totalPlaytime;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
                 IN size-1,
                 IN DOUBLE_MARSHAL_SEPARATOR,
                 IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
                 IN timeInfoStruct.position.bytes,
                 IN timeInfoStruct.position.pct,
                 IN timeInfoStruct.position.ms,
                 IN timeInfoStruct.duration.bytes,
                 IN timeInfoStruct.duration.ms);

    ret = ForwardPlaytimeStatusNew(IN handle, IN timeInfoString);
#endif

    return ret;
}

tResult CSControl::HandleActionError(const me::reason_e reason)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send action error instead of answer to waiting state machine */
    ret = LocalSPM::GetDeviceDispatcher().ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendActionError(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CSControl::ActionError(const me::reason_e reason)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send action error to own state machine*/
    ret = ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(ACTION_ERROR ,IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CSControl::ForwardStreamError(const me::reason_e reason) const
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send STREAM_ERROR message to PlayerManger */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::STREAM_ERROR", IN sizeof(messageString));

    ret = LocalSPM::GetPlayerManager().ParameterSTREAM_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CSControl::PlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    if(REASON_OK > reason)
    {
        me::reason_e localReason = reason;
        tMountPoint mountPoint;

        m_Mutex.lock();
        strncpy_r(OUT mountPoint, IN m_PlayMediaObject.mountPoint, IN sizeof(mountPoint));
        m_Mutex.unlock();

        if (REASON_URL_ERROR == localReason)
        {
            /* Check if read request on root (mountPoint) is possible */
            if (!exists_directory(mountPoint))
            {
                localReason = REASON_DEVICE_ERROR;
            }
        }

        /* Send action error instead of answer to waiting state machine */
        HandleActionError(IN localReason);
    }
    else
    {
        /* Send answer to waiting state machine */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER_NEW(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::ForwardPlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tObjectID objectID = m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    if(((tObjectID)handle != objectID)
       &&
       (PE_PBS_STOPPEDSTATE != playbackState))

    {
        ETG_TRACE_ERR(("Obsolete playback status -> Do not forward objectID:%u", (tObjectID)handle));
    }
    else
    {
        //Remark: Interpretation of non error reasons is done in PlayerManager::ForwardPlaybackStatusNew
        if(REASON_OK > reason)
        {
            me::reason_e localReason = reason;
            tMountPoint mountPoint;

            m_Mutex.lock();
            strncpy_r(OUT mountPoint, IN m_PlayMediaObject.mountPoint, IN sizeof(mountPoint));
            m_Mutex.unlock();

            if (REASON_URL_ERROR == localReason)
            {
                /* Check if read request on root (mountPoint) is possible */
                if (!exists_directory(mountPoint))
                {
                    localReason = REASON_DEVICE_ERROR;
                }
            }

            /* Forward stream error */
            ForwardStreamError(IN localReason);
        }
        else
        {
            /* Send PLAYBACK_STATUS message to PlayerManger to update playback status */
            char messageString[64];
            strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_STATUS", IN sizeof(messageString));
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

tResult CSControl::ForwardNowPlayingStatus(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tMediaObject mediaObject = m_PlayMediaObject;
    m_Mutex.unlock();

    if((tObjectID)handle != mediaObject.objectID)
    {
        if( !LocalSPM::GetDataProvider().GaplessPlay() )
        {
            ETG_TRACE_ERR(("Obsolete nowPlaying status -> Do not forward objectID:%u", (tObjectID)handle));
        }
        else
        {
            ETG_TRACE_USR1(("Received nowPlaying status of a new object (objectID (received/last):%u/%u)", (tObjectID)handle, mediaObject.objectID));

            //@@@ code?? : get metadata from ?
        }
    }
    else
    {
        /* Send NOW_PLAYING_STATUS message to PlayerManger to update nowPlaying info of object */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::NOW_PLAYING_STATUS", IN sizeof(messageString));
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString,
                IN size,
                IN handle,
                IN mediaObject.MetadataField1,
                IN mediaObject.MetadataField2,
                IN mediaObject.MetadataField3,
                IN mediaObject.MetadataField4,
                IN mediaObject.title,
                IN mediaObject.mediaType,
                IN mediaObject.bitRate,
                IN mediaObject.sampleRate,
                IN mediaObject.audioChannelFormat,
                IN mediaObject.metadataConvertFlag,
                IN NULL,
                IN NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult CSControl::ForwardNowPlayingStatusWithMetadata(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tMediaObject mediaObject = m_PlayMediaObject;
    m_Mutex.unlock();

    if((tObjectID)handle != mediaObject.objectID)
    {
        ETG_TRACE_ERR(("Received metadata of wrong object (objectID (received/expected):%u/%u)", (tObjectID)handle, mediaObject.objectID));
        return MP_NO_ERROR;
    }

    /* Send NOW_PLAYING_STATUS message to PlayerManger to update nowPlaying info of object */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::NOW_PLAYING_STATUS", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString,
            IN size,
            IN handle,
            IN mediaObject.MetadataField1,
            IN mediaObject.MetadataField2,
            IN mediaObject.MetadataField3,
            IN mediaObject.MetadataField4,
            IN mediaObject.title,
            IN mediaObject.mediaType,
            IN mediaObject.bitRate,
            IN mediaObject.sampleRate,
            IN mediaObject.audioChannelFormat,
            IN mediaObject.metadataConvertFlag,
            IN NULL,
            IN NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CSControl::PlaytimeStatusNew(const tPEHandle handle, const tPETimeInfo timeInfo)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(timeInfo);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tDeviceID deviceID = m_PlayMediaObject.deviceID;
    m_Mutex.unlock();

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN handle, IN deviceID, IN timeInfo);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::ForwardPlaytimeStatusNew(const tPEHandle handle, const tPETimeInfo timeInfo)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(timeInfo);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tObjectID objectID = m_PlayMediaObject.objectID;
    tDeviceID deviceID = m_PlayMediaObject.deviceID;
    m_Mutex.unlock();

    if ((tObjectID)handle != objectID)
    {
        ETG_TRACE_ERR(("Obsolete playtime status -> Do not forward objectID:%u", (tObjectID)handle));
    }
    else
    {
        /* Send PLAYTIME_STATUS message to PlayerManger to update playtime */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYTIME_STATUS", IN sizeof(messageString));
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetPlayerManager().ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN handle, IN deviceID, IN timeInfo);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult CSControl::HandleAnswerTimeout()
{
    ENTRY
    ETG_TRACE_ERR(("CSControl::HandleAnswerTimeout"));

    tResult ret = MP_NO_ERROR;

    /* Send releasing event to own waiting state machine */
    ret = ReleaseWaiting();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while releasing waiting via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CSControl::MessageNotConsumed()
{
    ENTRY
    ETG_TRACE_ERR(("CSControl::MessageNotConsumed"));
#if 0 //Do not SendAnswer without reason, it may cause failure within communication to DeviceDispatcher
    /* Send answer to possible waiting state machine to release own SM in case of message answer pair*/
    tResult ret = SendAnswer(NULL);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }
#endif
    return MP_NO_ERROR;
}

tResult CSControl::ValidateErrorCode(me::reason_e &reason, const tMetadata errorCode, const tMountPoint mountPoint) const
{
    ENTRY_INTERNAL

    tUInt errorEnum = atoi(errorCode);

    switch(errorEnum)
    {
    case MEDIAPLAYER_ERROR_DEVICE_NOT_FOUND:
    case MEDIAPLAYER_ERROR_AUDIO_DEVICE_ALREADY_IN_USE:
        reason = REASON_DEVICE_ERROR;
        break;
    case MEDIAPLAYER_ERROR_FILE_DOES_NOT_EXISTS:
    case MEDIAPLAYER_ERROR_CANNOT_DECODE_MEDIA:
    case MEDIAPLAYER_ERROR_UNKNOWN_ERROR:
    default:
        reason = REASON_FORMAT_ERROR;
        break;
    }

    return MP_NO_ERROR;
}

tResult CSControl::SetOutputDevice(const tAudioOutputDevice audioOutputDevice)
{
    ENTRY
    VARTRACE(audioOutputDevice);

    /* Store audio output device (alsa device name) internally */
    strncpy_r(OUT m_AudioOutputDevice, IN audioOutputDevice, IN sizeof(m_AudioOutputDevice));

    return MP_NO_ERROR;
}

tResult CSControl::SendPlaybackStatus(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    //VARTRACE(handle);
    //VARTRACE(playState);
    //VARTRACE(reason);
    //VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    /* Send PLAYBACK_STATUS event to own state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterPLAYBACK_STATUS(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(PLAYBACK_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CSControl::SendNowPlayingStatus(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    //VARTRACE(handle);
    //VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    /* Send NOW_PLAYING_STATUS event to own state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    ret = ParameterNOW_PLAYING_STATUS(OUT parameterString, IN size, IN handle, IN mountPointURL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(NOW_PLAYING_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CSControl::SendPlaytimeStatus(const tPEHandle handle, const tPETimeInfoStruct timeInfoStruct)
{
    ENTRY
    //VARTRACE(handle);
    //VARTRACE(timeInfoStruct);

    tResult ret = MP_NO_ERROR;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
            IN size-1,
            IN DOUBLE_MARSHAL_SEPARATOR,
            IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
            IN timeInfoStruct.position.bytes,
            IN timeInfoStruct.position.pct,
            IN timeInfoStruct.position.ms,
            IN timeInfoStruct.duration.bytes,
            IN timeInfoStruct.duration.ms);

    /* Send PLAYTIME_STATUS event to own state machine */
    tAllParameters parameterString;
    size = sizeof(parameterString);
    ret = ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN handle, IN timeInfoString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(PLAYTIME_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}


//Indexing part

tResult CSControl::IsInitRequired(const tDeviceInfoString deviceInfoString)
{
    ENTRY;
    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);

    /* In case of USB no initialization is necessary -> return NoInitAnswer (former false case) */
    return NoInitAnswer(IN deviceInfoString);
}

tResult CSControl::SendInitInit(const tDeviceInfoString deviceInfoString)
{
    ENTRY;
    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);

    //@@@ code?

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::NoInitAnswer(const tDeviceInfoString deviceInfoString)
{
    ENTRY;
    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);

    tResult ret = MP_NO_ERROR;

    /* Send INIT_DEVICE_CONNECTION message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tConnectionState connectionState = CS_CONNECTED;

    ret = LocalSPM::GetIndexer().ParameterDEVICE_INITIALIZED(OUT parameterString, IN size, IN deviceInfo.deviceName, IN deviceInfo.deviceID, IN connectionState);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = LocalSPM::GetIndexer().SendEventByName("DEVICE_INITIALIZED", IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::IsInitDeviceConnection(const tMountPoint mountPoint) const
{
   ENTRY
   VARTRACE(mountPoint);

   /* For USB no implementation -> return false */
   return false;
}

tResult CSControl::Disconnect(const tMountPoint mountPoint) const
{
   ENTRY
   VARTRACE(mountPoint);

   /* For USB no implementation */
   return MP_NO_ERROR;
}

tResult CSControl::OnDeviceInitialized(const tMountPoint mountPoint, const tConnectionState connectionState) const
{
   ENTRY
   VARTRACE(mountPoint);
   VARTRACE(connectionState);

   /* For USB no implementation */
   return MP_NO_ERROR;
}

tResult CSControl::GetNumberOfFiles(const tDeviceID deviceID)
{
    //Device type is not supported for indexing, nevertheless indexer requires the total number of playable files from this device
    //Added for VAG iPod streaming

    ENTRY;
    VARTRACE(deviceID);

    //@@@ code
    tNumberOfFiles numberOfFiles = 1;

    /* Send ANSWER message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    LocalSPM::GetIndexer().ParameterNUMBER_OF_FILES_ANSWER(OUT parameterString, IN size, IN deviceID, IN numberOfFiles);
    SendAnswer(IN parameterString);

   return MP_NO_ERROR;
}

tResult CSControl::CalcFingerprint(const tMountPoint mountPoint, const tDeviceID deviceID, const tFingerprint lastFingerprint)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(lastFingerprint);

    tResult ret = MP_NO_ERROR;

    tFingerprint fingerprint = { 0 };
    tFingerprintStatus fingerprintStatus = FPS_NOT_AVAIL;
    tNumberOfFiles numberOfFiles = 1; //there is always one dedicated streaming object
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ParameterPUT_FINGERPRINT(OUT parameterString, IN size, IN fingerprint, IN fingerprintStatus, IN numberOfFiles, IN deviceID);
    SendEvent(PUT_FINGERPRINT, IN parameterString);

    return ret;
}

tResult CSControl::OnFingerprint(const tFingerprint fingerprint,
                                  const tFingerprintStatus fingerprintStatus,
                                  const tNumberOfFiles numberOfFiles,
                                  const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(fingerprint);
    VARTRACE(fingerprintStatus);
    VARTRACE(numberOfFiles);
    VARTRACE(deviceID);

    tResult ret = MP_NO_ERROR;


    /* Send FINGERPRINT_AVAIL message to IndexerSM */
    char messageString[64];
    strncpy(messageString, "IndexerSM::FINGERPRINT_AVAIL", sizeof(messageString) - 1);
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIndexer().ParameterFINGERPRINT_AVAIL(OUT parameterString,
            IN size,
            IN fingerprint,
            IN fingerprintStatus,
            IN numberOfFiles,
            IN deviceID);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    //ret = SendAnswer(IN parameterString);
    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::IsNextMetadataAvailable(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(readPosition);

    //check for the first call by readPosition
    return (readPosition[0] == 0);
}

tResult CSControl::RetrieveMetadataFromDevice(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(readPosition);

    //no indexing possible
    tMetadataStatus metadataStatus = MDS_FINISHED;
    tMediaObjectPtr mediaObjectPtr = NULL;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ParameterPUT_METADATA(OUT parameterString, IN size, IN metadataStatus, IN mediaObjectPtr);
    SendEvent(PUT_METADATA, IN parameterString);

    return MP_NO_ERROR;
}

tResult CSControl::SendPutMetadata(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(readPosition);

    //Send a content streaming dummy object

    /* Send PUT_METADATA message to own SM */
    tMetadataStatus metadataStatus = MDS_SUCCESS;
    tMediaObjectPtr mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata

    if (mediaObjectPtr) {
        //set general parameter
        InitMediaObject(OUT *mediaObjectPtr);
        mediaObjectPtr->deviceID = deviceID;
        strncpy_r(mediaObjectPtr->fileName, "StreamingObject", sizeof(mediaObjectPtr->fileName));
        mediaObjectPtr->catType = CTY_SONG;
        mediaObjectPtr->mediaType = MTY_MUSIC_FILE;
        mediaObjectPtr->fileType = FT_AUDIO;
        strncpy_r(mediaObjectPtr->MetadataField1, "Streaming", sizeof(mediaObjectPtr->MetadataField1));
        strncpy_r(mediaObjectPtr->MetadataField2, "Streaming", sizeof(mediaObjectPtr->MetadataField2));
        strncpy_r(mediaObjectPtr->MetadataField3, "Streaming", sizeof(mediaObjectPtr->MetadataField3));
        strncpy_r(mediaObjectPtr->MetadataField4, "Streaming", sizeof(mediaObjectPtr->MetadataField4));
        strncpy_r(mediaObjectPtr->title, "Streaming", sizeof(mediaObjectPtr->title));
    }

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ParameterPUT_METADATA(OUT parameterString, IN size, IN metadataStatus, IN mediaObjectPtr);
    SendEvent(PUT_METADATA, IN parameterString);

    return MP_NO_ERROR;
}

tResult CSControl::AnswerMetadata(const tMetadataStatus metadataStatus, tMediaObjectPtr mediaObjectPtr)
{
    ENTRY
    VARTRACE(metadataStatus);

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    tResult ret = LocalSPM::GetIndexer().ParameterMETADATA_ANSWER(OUT parameterString,
            IN size,
            IN mediaObjectPtr, //lint -e429 freed by calling thread
            IN metadataStatus);

    //CID 10316 (#1 of 1): Unchecked return value (CHECKED_RETURN)
    if (MP_NO_ERROR != ret) {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
        parameterString[0] = '\0';
    }

    SendAnswer(IN parameterString);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::RetrieveMetadataFromCache(tMetadata &metadata) const
{
    /* Obsolete: DeviceControl is sending a media object instead of a metatdata string so an assembly is not necessary */
    ENTRY
    (void)metadata;
    return MP_NO_ERROR;
}

tResult CSControl::RemoveDeviceConnection(const tMountPoint mountPoint, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);

    tResult ret = MP_NO_ERROR;

    //@@@ code

    return ret;
}

//AlbumArt part

tResult CSControl::GetAlbumArt(const tAlbumArt albumArtString)
{
    ENTRY
    VARTRACE(albumArtString);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::HandleGetAlbumArtAnswer(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY

    /*Send the album art data as answer to request GetAlbumArt (Note : requested from DataProvider)*/
    tAllParameters parameterString = {0};
    SMF::Marshal(IN parameterString, sizeof(parameterString)-1, "p",IN ptrToAlbumArtObject);

    SendAnswer(IN parameterString);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CSControl::AlbumArtAnswerNotConsumed(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY;
    if(ptrToAlbumArtObject) {
        if(ptrToAlbumArtObject->imageData) {
            delete [] ptrToAlbumArtObject->imageData;
        }
        delete ptrToAlbumArtObject;
        ETG_TRACE_USR3(("AlbumArt buffer cleared"));
    }
    return MP_NO_ERROR;
}

tResult CSControl::SendAlbumArtAnswer(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY_INTERNAL;

    tResult ret = MP_NO_ERROR;

    /* Send GET_ALBUM_ART_ANSWER message to own SM */
    tAllParameters parameterString = {0};
    SMF::Marshal(IN parameterString, sizeof(parameterString)-1, "p", IN ptrToAlbumArtObject);

    ret = SendEvent(GET_ALBUM_ART_ANSWER, IN parameterString);

    return ret;
}

tResult CSControl::Umount(const tDeviceID deviceID, const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE2(mountPoint, deviceID);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    SMF::Marshal(parameterString, size - 1, "i", 0);

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tBoolean CSControl::IsBatchPlayable(const tDeviceID deviceID)
{
    ENTRY;
    VARTRACE(deviceID);
    return 0;
}

tResult CSControl::GetNextObjectToIndex(tMetadataStatus &metadataStatus,
                                         const tDeviceID deviceID,
                                         const tMountPoint mountPoint,
                                         const tReadPosition readPosition)
{
    ENTRY_INTERNAL
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(readPosition);

    tResult ret = MP_NO_ERROR;
    metadataStatus = MDS_SUCCESS;

    //@@@ code

    return ret;
}

void CSControl::TransferMetaTags(void *_info, tMediaObject &mediaObject)
{
    //@@@ nothing to do
}

void CSControl::DoReadMetadataForPlaybackThread(const tURL completeFileName)
{
    ENTRY
    VARTRACE(completeFileName);

    tResult ret = MP_NO_ERROR;
    tReturnValue returnValue = TRUE;

    /* Get metadata of media object for playback */
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    ret = LocalSPM::GetDBManager().GetFileFormat(OUT mediaObject.fileFormat, OUT mediaObject.fileType, IN completeFileName);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("unable to get file format for the url: %s", completeFileName));
        returnValue = FALSE;
    }
    else
    {
        if(FT_VIDEO == mediaObject.fileType )
        {
            /* Read video metadata */
            returnValue = ReadVideoMetadataFromFile(INOUT mediaObject, IN completeFileName);
        }
        else
        {
            /* Read audio metadata */
            returnValue = ReadAudioMetadataFromFile(INOUT mediaObject, IN completeFileName);
        }
    }

    m_Mutex.lock();

    tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_PlayMediaObject.notPlayable = mediaObject.notPlayable;

    if(returnValue)
    {
        /* Copy metadata */
        m_PlayMediaObject.mediaType = mediaObject.mediaType;
        strncpy_r(OUT m_PlayMediaObject.title, IN mediaObject.title, IN sizeof(m_PlayMediaObject.title));
        strncpy_r(OUT m_PlayMediaObject.MetadataField1, IN mediaObject.MetadataField1, IN sizeof(m_PlayMediaObject.MetadataField1));
        strncpy_r(OUT m_PlayMediaObject.MetadataField2, IN mediaObject.MetadataField2, IN sizeof(m_PlayMediaObject.MetadataField2));
        strncpy_r(OUT m_PlayMediaObject.MetadataField3, IN mediaObject.MetadataField3, IN sizeof(m_PlayMediaObject.MetadataField3));
        strncpy_r(OUT m_PlayMediaObject.MetadataField4, IN mediaObject.MetadataField4, IN sizeof(m_PlayMediaObject.MetadataField4));
        m_PlayMediaObject.totalPlaytime = mediaObject.totalPlaytime;
        m_PlayMediaObject.trackNumber = mediaObject.trackNumber;
        m_PlayMediaObject.metadataConvertFlag = mediaObject.metadataConvertFlag;
    }

    m_Mutex.unlock();

    /* Send METADATA_FOR_PLAYBACK message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterMETADATA_FOR_PLAYBACK(OUT parameterString, IN size, IN handle, IN completeFileName);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(METADATA_FOR_PLAYBACK, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    delete[] completeFileName;
}

#define PERF_MEAS 1

tReturnValue CSControl::ReadAudioMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
{
    ENTRY
    VARTRACE(completeFileName);

    tReturnValue returnValue = TRUE;

    mediaObject.mediaType = MTY_MUSIC_FILE;

#if 0
#if PERF_MEAS
    TimeTrace ticks("ReadAudioMetadataFromFile");
#endif

    //@@@: read toc data

#if PERF_MEAS
    ticks.elapsed();
#endif

    if(FALSE == returnValue)
    {
        ETG_TRACE_ERR(("CSControl::ReadAudioMetadataFromFile -> metadata could not be retrieved for file : %s", completeFileName));
    }
    else
    {
        VARTRACE5(mediaObject.title, mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField3, mediaObject.MetadataField4);
        VARTRACE(mediaObject.totalPlaytime);
        VARTRACE(mediaObject.trackNumber);
        VARTRACE(mediaObject.notPlayable);
    }
#endif

    return returnValue;
}

tReturnValue CSControl::ReadVideoMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
{
    ENTRY
    VARTRACE(completeFileName);
    tReturnValue returnValue = TRUE;

    //@@@ no video data

    return returnValue;
}

tReturnValue CSControl::ReadImageMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
{
    ENTRY
    VARTRACE(completeFileName);

    tReturnValue returnValue = TRUE;

    //@@@ no image

    return returnValue;
}

tReturnValue CSControl::CollectData(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL
    VARTRACE(mountPoint);

    tReturnValue returnValue = TRUE;

    if(0 == LocalSPM::GetDataProvider().CollectMetadata())
    {
        //ETG_TRACE_USR1(("No metadata extraction configured"));
        return TRUE;
    }

    /* Collect data together */
    /* Only a few parts of the media object are filled if it is taken from a LTY_FILELIST_UNSORTED list
     * mediaObject.objectID
     * mediaObject.fileName
     * mediaObject.fileType
     * mediaObject.fileFormat
     * mediaObject.title (= mediaObject.fileName without path but with extension)
     * mediaObject.deviceID
     * mediaObject.deviceType
     * mediaObject.deviceVersion
     * mediaObject.mountPoint
     * mediaObject.catType
     * mediaObject.mediaType
     * mediaObject.albumArtString
     *
     * The rest has to be added here
     */

    //tph: TODO ReadMetadata in thread

    //@@@: reduce code

    //tURL completeFileName;
    //strncpy_r(OUT completeFileName, IN m_ScanMediaObject.mountPoint, IN sizeof(completeFileName));
    //strncat_r(OUT completeFileName, IN m_ScanMediaObject.fileName, IN sizeof(completeFileName));

    return returnValue;
}
