#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_BT_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/BTControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_BT_CONTROL
#endif
#endif

#include "LocalSPM.h"
#include "Dispatcher.h"
#include "BTDaemonProxy.h"
#include "BTDaemonIpcIF.h"
#include "BTControl.h"
#include "FunctionTracer.h"
#include "VarTrace.h"
#include "ElapsedTimer.h"
#include "MediaPlayer_ErrorCodes.h"
#include "TimeTrace.h"
#include <netinet/in.h>
#include <BTCursor.h>
#include "FreeImage.h"

#define MEDIAPLAYER 1
const int AUDIO_PLAYER = 0x01;
//const int VIDEO_PLAYER = 0x02;
const int BROADCASTING_AUDIO_PLAYER = 0x04;
//const int BROADCASTING_VIDEO_PLAYER = 0x08;

#define FEATURE_BIT_MASK_EIGTH_BYTE 18
#define FEATURE_BIT_MASK_NINETH_BYTE 19
#define AVRCP_14_SUPPORT_BIT  0x04
#define BROWSE_SUPPORT_BIT  0x08
#define BROWSE_ONLY_ON_ADDRESS_BIT  0x80
#define DB_AWARE_BIT        0x40
#define UID_PERSISTENCY_BIT 0x04
#define SIZE_OF_ITEM_TYPE_CUM_LENGTH 3
#define EVENTS_SUPPORTED 1

#define APPLE_VENDOR_ID_1   0x004C
#define APPLE_VENDOR_ID_2   0x05AC


#define FUNCTION_ID_DB_CHANGE_SHUFFLE_SUPPORT  1
#define FUNCTION_ID_DB_CHANGE_REPEAT_SUPPORT   2
#define FUNCTION_ID_DELETE_VT_BLUETOOTH_CACHE    3
#define FUNCTION_ID_DB_CHANGE_DEVICE_VERSION 4
#define FUNCTION_ID_CALCULATE_ITEM_COUNT 5
#define FUNCTION_ID_ALBUMART 6
#define FUNCTION_ID_NOWPLAYINGLISTAVAILABILITY 7

#define NOW_PLAYING_DEFAULT 1
#define FOLDER_ITEM_BATCH_SIZE 20
#define DEVICE_MAX_VOLUME 127
#define AUDIO_MAX_VOLUME 40
#define RETRIAL_TIME_INTERVAL 1000
#define MAX_NO_OF_PLAY_RETRIES 7

#define INVALID_VOLUME -1

#define DEFAULT_TIMER_ID 0

//SPM part

extern tBoolean IsSelectedItemPlayable(string mSelectedItemParentPath,string mSelectedItemName);
extern tBoolean BTGetFolderUID(unsigned char *ReqPath,unsigned int l_uiLevelDownCnt,tItemUIDArray ItemUIDArray);
extern bool BTGetItemObjectPath(const string item, string &objectPath);
extern bool BTGetPosItemInFolder(const string item ,int &item_pos);
extern void BTCacheEraseNowplaying();
extern bool BTGetLevelInfo(string path,tNumOfItems &TotNumOfItems,tNumOfItems &ElementsInCache);
extern void BTStoreBrowseLevelInfo(string path,tNumOfItems NumOfItems);
extern void BTCacheWrite(string CursorPath,map<unsigned int,tBrowseElement> &ElementsRetrieved);
extern void BTCachCheckAndUpdate(string CursorPath,map<unsigned int,tBrowseElement> &ElementsRetrieved,tBoolean& contentUpdated,tBoolean& itemsErased);
extern bool BTCacheDeleteOtherThanNowPlaying();

void BTControl::Create() // finished: 100%
{
    ENTRY;

    /* Create the state machine */
    BTControlSM::Create();

    CreateDone(0);
}

tResult BTControl::Init(tInitReason reason) // finished: 100%
{
    ENTRY;
    VARTRACE(reason);

    /* Init the state machine */
    BTControlSM::Init();            //--Component ID
    SetAnswerTimeout(6800L);        // Set answer timer

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);
    LocalSPM::GetInstance().GetIPCProvider().RegisterListener(&BTDaemonProxy::GetInstance());
    sem_init(&m_TaskSyncSem, 0, 0);
    m_response = REASON_OK;

    m_AudioOutputDevice[0] = '\0';
    return InitDone(0);
}

tResult BTControl::InitSM() // finished: 100%
{
    ENTRY

    //init variables
    tBool isInit=true;
    ClearFlags(isInit);
    ClearDeviceDetails();
    m_RemoteActivityDeviceID = DEVICE_ID_NOT_SET;
    mRetryPlayTimerCount = 0;
    mRetryPlayTimerID = DEFAULT_TIMER_ID;
    SetStateOfPlayinStartPlay(PLAY_NOT_SENT);
    return MP_NO_ERROR;
}

tResult BTControl::Run() // finished: 100%
{
    ENTRY;

    /*Create and start threads */
    LocalSPM::GetThreadFactory().Do(IN this, 0, NULL); //BTControl inclusive state machine

    return RunDone(0);
}

void BTControl::Do(int functionID, void *ptr) // finished: 100%
{
    ENTRY;
    (void)ptr;

    //setting different name for each thread for unique identification
    switch (functionID)
    {
        case 0:
        {
            LocalSPM::GetThreadFactory().SetName(BTControlSM::GetSMNameFull());
            while (BTControlSM::STATE_MACHINE_FINISHED != BTControlSM::StateMachine_Main()) { }
            break;
        }
        case FUNCTION_ID_DB_CHANGE_SHUFFLE_SUPPORT:
        {
            LocalSPM::GetThreadFactory().SetName("BTControlChangeShuffleSupport");
            ETG_TRACE_USR3(("%s FUNCTION_ID_DB_CHANGE_SHUFFLE_SUPPORT", __PRETTY_FUNCTION__));
            DoDBChangeShuffleSupport((char *) ptr);
            break;
        }
        case FUNCTION_ID_DB_CHANGE_REPEAT_SUPPORT:
        {
            LocalSPM::GetThreadFactory().SetName("BTControlChangeRepeatSupport");
            ETG_TRACE_USR3(("%s FUNCTION_ID_DB_CHANGE_REPEAT_SUPPORT", __PRETTY_FUNCTION__));
            DoDBChangeRepeatSupport((char *) ptr);
            break;
        }
        case FUNCTION_ID_DELETE_VT_BLUETOOTH_CACHE:
        {
            LocalSPM::GetThreadFactory().SetName("BTControlDeleteVTBluetoothCache");
            ETG_TRACE_USR3(("%s FUNCTION_ID_DELETE_VT_BLUETOOTH_CACHE", __PRETTY_FUNCTION__));
            DoDeleteVTBluetoothCache((char *) ptr);
            break;
        }
        case FUNCTION_ID_DB_CHANGE_DEVICE_VERSION:
        {
            LocalSPM::GetThreadFactory().SetName("BTControlDBChangeDeviceVersion");
            ETG_TRACE_USR3(("%s FUNCTION_ID_DB_CHANGE_DEVICE_VERSION", __PRETTY_FUNCTION__));
            DoDBChangeDeviceVersion((char *) ptr);
            break;
        }
        case FUNCTION_ID_CALCULATE_ITEM_COUNT:
        {
            LocalSPM::GetThreadFactory().SetName("BTControlCalculateItemCount");
            ETG_TRACE_USR3(("%s FUNCTION_ID_CALCULATE_ITEM_COUNT", __PRETTY_FUNCTION__));
            DoCalculateItemCountInGivenPath((char *) ptr);
            break;
        }
        case FUNCTION_ID_ALBUMART:
        {
            LocalSPM::GetThreadFactory().SetName("BTControlAlbumArt");
            ETG_TRACE_USR3(("%s FUNCTION_ID_ALBUMART", __PRETTY_FUNCTION__));
            DoGetAlbumArtThread((const char *)ptr);
            break;
        }
        case FUNCTION_ID_NOWPLAYINGLISTAVAILABILITY:
        {
            LocalSPM::GetThreadFactory().SetName("BTControlNowPlayingListAvailable");
            ETG_TRACE_USR3(("%s FUNCTION_ID_NOWPLAYINGLISTAVAILABILITY", __PRETTY_FUNCTION__));
            DoDBChangeNowPlayingListSupport((char *)ptr);
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("BTControl::Do: No thread defined for functionID: %d", functionID));
            break;
        }
    }
}

tResult BTControl::Done() // finished: 100%
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN this);

    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *) NULL);
    if (MP_NO_ERROR != ret) {
        //ETG_TRACE_ERR(("Error while sending internal event via SMF"));
    }

    return ret;
}

tResult BTControl::Stop() // finished: 100%
{
    ENTRY
    tResult ret = MP_NO_ERROR;

   /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *) NULL);
    if (MP_NO_ERROR != ret) {
        //ETG_TRACE_ERR(("Error while sending internal event via SMF"));
    }

    return ret;
}
tResult BTControl::StopEventProcessed() // finished: 100%
{
    ENTRY
    /* Send stop done to SPM in the transition to final state in state machine */

    tResult ret = MP_NO_ERROR;

    if(!LocalSPM::GetDataProvider().UseMediaEngine()) { //pip2hi

        /* unregister for further playback events */
        ret = LocalSPM::GetIPCProvider().UnregisterObserver(IN this);
        if (ret != MP_NO_ERROR) {
            ETG_TRACE_ERR(("BTControl::StopEventProcessed() - UnregisterObserver() failed"));
        }
    }
    return StopDone(0);
}

char *BTControl::GetSMStateName(OUT tGeneralString stateName, size_t size)
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}

tResult BTControl::NoInitAnswer(const tDeviceInfoString deviceInfoString) // finished: 100%
{
    ENTRY;

    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    ETG_TRACE_USR3(("BTControl::NoInitAnswer deviceID:%u, mountPoint:%s", deviceInfo.deviceID, deviceInfo.mountPoint));

    return MP_NO_ERROR;
}

tResult BTControl::GetNumberOfFiles(const tDeviceID deviceID)
{
    //Device type is not supported for indexing, nevertheless indexer requires the total number of playable files from this device
    //Added for VAG iPod streaming

    ENTRY;
    VARTRACE(deviceID);

    tNumberOfFiles numberOfFiles = 0; //TODO: return total number of files here

    /* Send ANSWER message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    LocalSPM::GetIndexer().ParameterNUMBER_OF_FILES_ANSWER(OUT parameterString, IN size, IN deviceID, IN numberOfFiles);
    SendAnswer(IN parameterString);

    return MP_NO_ERROR;
}

tResult BTControl::HandleActionError(const me::reason_e reason)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send action error instead of answer to waiting state machine */
    ret = LocalSPM::GetDeviceDispatcher().ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendActionError(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult BTControl::StartSwitchObserver(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    if(mConnectedDeviceInfo.deviceID == DEVICE_ID_NOT_SET) /*No device available*/
    {
        ETG_TRACE_ERR(("BTControl::StartSwitchObserver -> No device available "));

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ret = ParameterACTION_ERROR(OUT parameterString, IN size, IN REASON_DEVICE_ERROR);
        ret = SendEvent(ACTION_ERROR, parameterString);

        return MP_NO_ERROR;
    }

    ret = BTDaemonProxy::GetInstance().SwitchObserver(DTY_BLUETOOTH);
    if(!ret)
    {
        ETG_TRACE_USR3(("BTDaemonProxy SwitchObserver Successful"));
    }
    else
    {
        ETG_TRACE_USR3(("BTDaemonProxy SwitchObserver failed"));
    }

    if(LocalSPM::GetDataProvider().UseMediaEngine()) { //pip2hi

        /* Switch the observer to this state machine */
#if 1
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::SWITCH_OBSERVER", "BTControlSM", "BTControlSM::METHOD_RETURN");
#else
        Dispatcher::GetInstance().SendMessage("MediaEngineSM::SWITCH_OBSERVER", "BTControlSM");

        /* MediaEngine will not answer, so fake the answer */
        ret = SendEvent(METHOD_RETURN, IN "0");
        if( MP_NO_ERROR != ret ) {
            ETG_TRACE_ERR(("BTControl::StartSwitchObserver() - Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
#endif
    } else {

        RegisterReleaseEvent(METHOD_RETURN);
        /* Send SwitchObserver to PlayerEngine via DBUS */
        ret = LocalSPM::GetIPCProvider().SwitchObserver(IN this);
        if (ret != MP_NO_ERROR) {
            ETG_TRACE_ERR(("BTControl::StartSwitchObserver() - SwitchObserver() failed"));
        }
    }

    mConnectedDeviceInfo.activeSource = 0x01;

    //As BT Component is active now,Clear the RemoteActivity Flags(if needed).
    if(mIsRemoteActivityNeeded)
    {
        ClearRemoteActivityFlags();
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::StartStreaming(const tDeviceID /*deviceID*/, const tMountPoint mountPoint)
{
    ENTRY;
    (void)mountPoint;

    tResult ret = MP_NO_ERROR;

    m_RemoteActivityDeviceID = DEVICE_ID_NOT_SET;

    if(mConnectedDeviceInfo.deviceID == DEVICE_ID_NOT_SET) /*No device available*/
    {
        ETG_TRACE_ERR(("BTControl::StartStreaming -> No device available "));

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ret = ParameterACTION_ERROR(OUT parameterString, IN size, IN REASON_DEVICE_ERROR);
        ret = SendEvent(ACTION_ERROR, parameterString);

        return MP_NO_ERROR;
    }

    //static streaming configuration parameter for AVRCP 1.4 Device
    tEncoding encoding = {0};
    const tBitRate bitrate = mBitRate;
    const me::samplerate_i sampleRate = 44100;
    const channels_i channels = 2;                    //Number of channels of the decoded audio
    const samplewidth_i sampleWidth = 16;             // Width of the sample in bits
    const sampledepth_i sampleDepth = 16;             // Depth of the sample in bits
    const signedness_e sampleSignedness = SIGNEDNESS_SIGNED; // 1 as sample is signed.
    const endianess_e sampleEndianness = ENDIANESS_LE; // 0 as it is Little Endian

    switch(mCodecType)
    {
        case CODEC_TYPE_SBC:
        {
            ETG_TRACE_USR4(("CODEC_TYPE_SBC "));
            strncpy_r(OUT encoding,IN "sbc",IN sizeof(encoding));
        }
        break;
        case CODEC_TYPE_MPEG12AUDIO:
        {
            ETG_TRACE_USR4(("CODEC_TYPE_MPEG12AUDIO "));
            strncpy_r(OUT encoding,IN "mp3",IN sizeof(encoding));
        }
        break;
        case CODEC_TYPE_MPEG24AAC:
        {
            ETG_TRACE_USR4(("CODEC_TYPE_MPEG24AAC "));
            strncpy_r(OUT encoding,IN "aac",IN sizeof(encoding));
        }
        break;
        default:
        {
            ETG_TRACE_USR4(("default case "));
        }
        break;
    }

    if(!LocalSPM::GetDataProvider().UseMediaEngine()) { //pip2hi

        /*
        For:GMMY17-4562
        1.BTControl shouldnt wait for PLAYBACK_STATUS_RESPONSE event from PlayerEngine on invoking PlayFromDeviceSlot.
        2.The PlayerEngine will send The event only after setting the PipeLine to Playing state.It will happen
          only when it finds data in the input file.This will happen only on sending PLAY Command to Device.
        2.Hence,Immediately release the Event
        */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);

        /* Send PlayFromDevice to PlayerEngine via DBUS */
        ret = LocalSPM::GetIPCProvider().PlayFromDeviceSlot(IN this,
                IN encoding, IN bitrate, IN sampleRate, IN channels,
                IN sampleWidth, IN sampleDepth, IN sampleSignedness,
                IN sampleEndianness);
        if (ret != MP_NO_ERROR)
        {
            ETG_TRACE_ERR(("BTControl::StartStreaming() - PlayFromDeviceSlot() failed"));
        }
        SendEvent(PLAYBACK_STATUS_RESPONSE,NULL);
    }
    else {

        tURL url;
        snprintf(url, sizeof(tURL), "%s.%s.bt", m_AudioInputDevice, encoding);

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", url, 1 /* speed */, -1 /*position*/, HANDLE_NONE, m_AudioOutputDevice);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "BTControlSM::START_STREAMING_ANSWER");

        if(MP_NO_ERROR != ret) {
            ETG_TRACE_ERR(("BTControl:StartStreaming() - failed"));
        }
        /*
        For:PSARCCB-3035
        1.BTControl should't wait for START_STREAMING_ANSWER event from MediaEngine.
        2.The MediaEngine will send the event only after setting the PipeLine to Playing state.It will happen
          only when it finds data in the input file.This will happen only on sending PLAY Command to Device.
        3.Hence,Immediately release the Event.
         */
        //SendEvent(START_STREAMING_ANSWER,NULL);
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::StartStopStreaming()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* For BT no need to stop streaming
     * Send STOP_STREAMING_ANSWER message to release own waiting state */
    ret = ParameterSTOP_STREAMING_ANSWER(OUT parameterString, IN size, IN deviceID);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(STOP_STREAMING_ANSWER, IN parameterString);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::StopStreamingAnswer(tDeviceID deviceID)
{
    ENTRY
    (void)deviceID;
    tPEPlaybackState status = PE_PBS_STOPPEDSTATE;

    tObjectID ObjectID = OBJECT_ID_NONE;
    /* Send answer to waiting state machine */
    if( LocalSPM::GetDataProvider().UseMediaEngine() )
    {
        PlaybackStatusNew(IN mHandle, IN status, IN REASON_OK, IN ME_SPEED_NORMAL);
    }
    else
    {
        tMetadata metadata = { 0 };
        PlaybackStatus(IN status, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::StartPlay(const tDeviceType deviceType,
        const tDeviceID deviceID, const tURL URL, const tMountPoint mountPoint, const tUUID uuid,
        const tPEHandle handle, const tPlaytime position, const tStreaming streaming)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    const tBoolean playOnRemoteActivity = (deviceID != DEVICE_ID_NOT_SET) && (deviceID == m_RemoteActivityDeviceID);
    VARTRACE(playOnRemoteActivity);
    // Store ListID bound to /NowPlaying for list change updation NCG3D-85428 .
    if(playOnRemoteActivity)
    {
        NowPlayingListID = (tListID)streaming;
    }
    m_RemoteActivityDeviceID = DEVICE_ID_NOT_SET;
    if(mConnectedDeviceInfo.deviceID == DEVICE_ID_NOT_SET) /*No device available*/
    {
        ETG_TRACE_ERR(("BTControl::StartPlay -> No device available "));

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ret = ParameterACTION_ERROR(OUT parameterString, IN size, IN REASON_DEVICE_ERROR);
        ret = SendEvent(ACTION_ERROR, parameterString);

        return MP_NO_ERROR;
    }

    VARTRACE(deviceType);
    VARTRACE(deviceID);
    VARTRACE(URL);
    VARTRACE(mountPoint);
    ETG_TRACE_USR4(("StartPlay: uuid:%s",uuid));
    VARTRACE(handle);
    VARTRACE(position);
    VARTRACE(streaming);

    /*To move BTControlSM to startPlay state*/
    SendEvent(METADATA_FOR_PLAYBACK, NULL);

    mHandle = handle;
    mIsBTControlActive = true;
    BTDaemonProxy::GetInstance().UpdateBTDeviceControlState((tBoolean)true);
    tUUID evoUUIDForPlayItemContains = "/org/bluez/hci1/dev_";//For Play item the UUID should contain "/org/bluez/hci1/dev_" for evolution stack .
    /*Start play from browse*/
    //URL contains "/dummy-now-playing/" for the invalid list , so additional check is introduced to make sure the UUID is valid.
    //addtional check :: (check for a particular string that would be a part of UUID for Evolution stack).
    if((strlen_r(URL) /*&& mIsBTControlActive */) && ((!LocalSPM::GetDataProvider().UseEvolutionBtStack()) || (isStartWith(evoUUIDForPlayItemContains,uuid))))    /*GMMY16-20632:Very First StartPlay call can come with a valid item path.So mIsBTControlActive is Ignored*/
    {
        /*To move BTControlSM to idle state and answer waiting SM*/
        if(!playOnRemoteActivity)
        {
            SendPlaybackStatus(IN mCurrentPlaybackState);
        }
        else
        {
            SendPlaybackStatus(IN PE_PBS_LOADINGSTATEFORREMOTEACTIVITY);
        }

        string Item = string((const char*)URL);
        unsigned int foundString = Item.find_last_of("/\\");
        if(string::npos == foundString)
        {
            ETG_TRACE_USR3(("Invalid URL Received to Play"));
            return ret;
        }
        mSelectedItemParentPath  = Item.substr(0,foundString);
        mSelectedItemName = Item.substr(foundString+1);
        if(!mSelectedItemParentPath.size())mSelectedItemParentPath = PATH_DELIMITER;
        ETG_TRACE_USR3(("mSelectedItemParentPath is %s",mSelectedItemParentPath.c_str()));
        ETG_TRACE_USR3(("mSelectedItemName is %s",mSelectedItemName.c_str()));
        tItemUID ItemUID =(tItemUID)const_cast<char*>(mSelectedItemParentPath.c_str());

        tBoolean isPlayable = IsSelectedItemPlayable(mSelectedItemParentPath,mSelectedItemName);
        ETG_TRACE_USR3(("IsSelectedItemPlayable:%d",isPlayable));

        /*Check if browsed element is playable (e.g some Folders might not be playable)*/
        if(isPlayable)
        {
            tAllParameters parameterString="";
            size_t size = sizeof(parameterString);
            tDirection Direction = LEVEL_CHANGE_INVALID;
            tLevelCount LevelUpCount = 0;
            tLevelCount LevelDownCount = 0;

            if(!LocalSPM::GetDataProvider().UseEvolutionBtStack() ||  playOnRemoteActivity == false)
            {
                setIsPlayItemFromBrowseNeeded(true);

                //The media item interfaces created will remove on changing the folder. ListItems will recreate the interfaces.
                //So need to request Listitems always.
                mIsRequestListItemNeeded = true;
                strncpy_r(OUT mPlayItemUID,IN uuid,IN sizeof(mPlayItemUID));
                ret = ParameterAVP_CHANGE_PATH(OUT parameterString,
                        IN size,
                        IN Direction,
                        IN LevelUpCount,
                        IN LevelDownCount,
                        IN ItemUID);
                SendEvent(AVP_CHANGE_PATH,parameterString);
            }
        }
    }
    else /*Start play from source switch to play the last mode of the device*/
    {
        tPEPlaybackState LastPlaybackState = PE_PBS_LOADINGSTATE;
        tPEPlaybackState LatestPlaybackStateFromDevice = PE_PBS_LOADINGSTATE;
        //Get the last playback state while BTControl ctive from BTDeamonProxy.
        BTDaemonProxy::GetInstance().GetLastActivePlaybackState(OUT LastPlaybackState);
        BTDaemonProxy::GetInstance().GetLatestPlaybackStateFromDevice(OUT LatestPlaybackStateFromDevice);

        const tBoolean ignoreLastModePause = LocalSPM::GetDataProvider().IsIgnoreLastModePauseNeeded(deviceID);
        const bool keepPausedState = LocalSPM::GetDataProvider().KeepLastPlaybackStateForStreamingDevicesEnabled() &&((LastPlaybackState == PE_PBS_PAUSEDSTATE) && (false == ignoreLastModePause));

        VARTRACE(keepPausedState);
        VARTRACE(mCurrentPlaybackState);
        VARTRACE(LatestPlaybackStateFromDevice);

        /* Don't send play command to device if the Current playback state is playing or the last playback state was paused.*/
        if((false == playOnRemoteActivity) && !keepPausedState && (!(LocalSPM::GetDataProvider().BTSourcePausedBySIRI())))
        {
            //mIsBTControlActive = true;
            // Send Play to BT device
            tBTControlCmd Command = BT_CMD_PLAY;
            tBTButtonEvent ButtonAction = BUTTON_CLICK;
            if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
            {
                RegisterReleaseEvent(AVP_CTRL_CMD_METHOD_RETURN);
            }
            ret = BTDaemonProxy::GetInstance().AvpCtrlCmd(Command,ButtonAction);
            StartRetryPlayTimer();

            if (ret != MP_NO_ERROR)
            {
                ETG_TRACE_ERR(("AvpCtrlCmd failed"));
            }
            else
            {
                SetStateOfPlayinStartPlay(PLAY_SENT);
            }

            /*todo : remove this once proper response is received*/
            SendPlaybackStatus(IN PE_PBS_LOADINGSTATE);
        }
        else
        {
            if(true == playOnRemoteActivity)
            {
                SendPlaybackStatus(IN PE_PBS_LOADINGSTATEFORREMOTEACTIVITY);
            }
            else
            {
                if(LocalSPM::GetDataProvider().BTSourcePausedBySIRI())
                {
                    mCurrentPlaybackState =  LatestPlaybackStateFromDevice;
                    LocalSPM::GetDataProvider().BTSourcePausedBySIRI = 0;
                }
                //Request metadata for the Currently playing track
                ret = BTDaemonProxy::GetInstance().RequestMetadata();
                /*To move BTControlSM to idle state and answer waiting SM*/
                SendPlaybackStatus(IN mCurrentPlaybackState);
            }
        }

        if(ignoreLastModePause)
        {
            LocalSPM::GetDataProvider().RemoveDeviceFromLastModePauseList(IN deviceID);
        }

        if(false == playOnRemoteActivity)
        {
            SendRemoteActivity(IN mConnectedDeviceInfo.mountPoint);


            //Update the current volume to device.

            if((LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT()) && (LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice()))
            {
                tAbsoluteVolumeSupportValues absoluteVolumeSupportValues;
                absoluteVolumeSupportValues = BTDaemonProxy::GetInstance().GetAbsoluteVolumeSupportValues();

                if(INVALID_VOLUME != absoluteVolumeSupportValues.currentVolumeReceivedFromAudio)

                {
                    tAllParameters parameterStringforVolume;
                    size_t size1 = sizeof(parameterStringforVolume);
                    tDeviceType SMObserver = DTY_BLUETOOTH;
                    ret = LocalSPM::GetInstance().GetBTControl().ParameterUPDATE_VOLUME_TO_DEVICE(OUT parameterStringforVolume, IN size1, IN absoluteVolumeSupportValues.currentVolumeReceivedFromAudio);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while preparing parameter string"));
                    }
                    else
                    {
                        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN SMObserver, IN "UPDATE_VOLUME_TO_DEVICE", IN parameterStringforVolume);
                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                        }
                    }
                }
            }
        }

    if(!LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
    {
        //mAttributeValueRequested = ALPS_ATTR_SHUFFEL;
        ret = BTDaemonProxy::GetInstance().AvpListVal(ALPS_ATTR_SHUFFEL);
    }
    }
    //Below code to update nowplaying is for informing HMI the valid now-playing list is created after the dummy-now-playing , during device initialisation.
    ETG_TRACE_USR3(("value for UseEvolutionBtStack: %d , playOnRemoteActivity : %d",LocalSPM::GetDataProvider().UseEvolutionBtStack(),playOnRemoteActivity));
    if((LocalSPM::GetDataProvider().UseEvolutionBtStack()) &&  (true == playOnRemoteActivity))
    {
        tAllParameters parameterString_1;
        size_t size_1 = sizeof(parameterString_1);
        ETG_TRACE_USR3(("Btcontrol :  Forward nowplaying if play because of remoteactivty"));
        char messageString_1[64];
        strncpy_r(OUT messageString_1, IN "PlayerManagerSM::NOW_PLAYING_STATUS", IN sizeof(messageString_1));
        ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString_1, IN size_1, IN m_CurrentMediaObject.objectID, IN m_CurrentMediaObject.MetadataField1,
                IN m_CurrentMediaObject.MetadataField2, IN m_CurrentMediaObject.MetadataField3, IN m_CurrentMediaObject.MetadataField4, IN m_CurrentMediaObject.MetadataField3,IN MTY_AUDIO_STREAM, IN (tBitRate)0, IN (me::samplerate_i)0, IN ACF_UNKNOWN,IN (tConvertFlag)0,IN NULL,IN m_CurrentMediaObject.albumArtString);
        if (MP_NO_ERROR != ret) {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
            parameterString_1[0] = '\0';
        }
        Dispatcher::GetInstance().SendMessage( IN messageString_1, IN parameterString_1);
    }

    //Fix for NCG3D-218567 - Update AlbumartStatus to PlayerManager again from here.
    //There is a chance that because of PlayerManager::PlayMediaObjectStreaming()
    //Remote activity for NowplayingList) the previous ALBUM_ART_STATUS message will remove from PlayerManger message queue.
    if(strlen(m_CurrentMediaObject.albumArtString) > 0)
    {
        SendAlbumArtStatusToPlayerManager(true);
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::PlaybackStatus(const tPEPlaybackState status,
        const tMetadata metadata1,
        const tMetadata metadata2,
        const tMetadata metadata3,
        const tMetadata metadata4,
        const tObjectID ObjectID)

{
    //TODO: in case of PE_PBS_ERRORSTATE: SendActionError(ACTION_ERROR) else: SendAnswer(PLAY_ANSWER)
    ENTRY
    tResult ret = MP_NO_ERROR;

    tPEPlaybackState PlaybackstatusTobeUpdated = status;

    //The invalid state due to remote activity should not be stored internally as it is dummy state and will not be updated to HMI
    if(PE_PBS_LOADINGSTATEFORREMOTEACTIVITY != status)
    {
        mCurrentPlaybackState = status;
    }
    else
    {
        //Playermanager will not forward the update only if the playback state is loading
        PlaybackstatusTobeUpdated = PE_PBS_LOADINGSTATE;
    }

    ETG_TRACE_USR1(("The Current Playback State is %d",mCurrentPlaybackState));

    tAllParameters parameterString = "";
    size_t size = sizeof(parameterString);

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        tPEHandle handle = mHandle;
        me::reason_e reason = REASON_OK;
        me::speed_e speed = ME_SPEED_NORMAL;

        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAYBACK_STATUS(OUT parameterString,
                IN size,
                IN handle,
                IN PlaybackstatusTobeUpdated,
                IN reason,
                IN speed);
    }
    else
    {
        //ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString,IN size,IN mCurrentPlaybackState,IN metadata1,IN metadata2,IN metadata3,IN metadata4);
        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER(OUT parameterString,
                IN size,
                IN PlaybackstatusTobeUpdated,
                IN metadata1,
                IN metadata2,
                IN metadata3,
                IN metadata4,
                IN metadata3,
                IN MTY_AUDIO_STREAM,
                IN (tConvertFlag)0,
                IN NULL);
    }
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::ForwardPlaybackStatus(const tPEPlaybackState status,
        const tMetadata metadata1,
        const tMetadata metadata2,
        const tMetadata metadata3,
        const tMetadata metadata4,
        const tObjectID ObjectID)
{
    //TODO: in case of PE_PBS_ERRORSTATE: SendMessage(STREAM_ERROR) else: SendMessage(PLAYBACK_STATUS_RESPONSE)
    ENTRY
    tResult ret = MP_NO_ERROR;

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    tMetadata localmetadata1 = {0};
    tMetadata localmetadata2 = {0};
    tMetadata localmetadata3 = {0};
    tMetadata localmetadata4 = {0};
    tPEPlaybackState PlaybackstatusTobeUpdated = status; // for checking if playbackstatus is updated becacuse of startplay on remoteactivity and if so it will be updated as loading state

    ETG_TRACE_USR1(("ForwardPlaybackStatus new status:%d mCurrentPlaybackState:%d",status,mCurrentPlaybackState));
    ETG_TRACE_USR1(("mConnectedDeviceInfo.activeSource:%d",mConnectedDeviceInfo.activeSource));

    /*device switches to play mode*/
    if((APPLE_VENDOR_ID_1 == mConnectedDeviceInfo.productID || APPLE_VENDOR_ID_2 == mConnectedDeviceInfo.productID ||LocalSPM::GetDataProvider().RemoteActivitySupportForNonAppleDevice())
            && (status == PE_PBS_PLAYINGSTATE) && (status != mCurrentPlaybackState)
            && (LocalSPM::GetDataProvider().ActivateBTDeviceOnRemoteActivity()||
                    (LocalSPM::GetDataProvider().AutoPlayBTOnRequestviaSiri() && mIsSiriSessionActive)))
    {
        /*Request BT device to be set as active on remote activity e.g Siri*/
        if(mConnectedDeviceInfo.activeSource == 0x00)
        {
            //Donot request immediately but Remember to do.Do it when valid Playtime update comes
            mIsRemoteActivityNeeded = true;
            mActionOnPlayTime = STORE_VALID_PLAY_TIME;
            //Set the bool value bRemoteActivityReqViaSiri as true to avoid starting timer after on HandleVRSessionStatus.
            if(LocalSPM::GetDataProvider().AutoPlayBTOnRequestviaSiri())
            {
                bRemoteActivityReqViaSiri = true;
            }
        }
    }

    //The invalid state due to remote activity should not be stored internally as it is dummy state and will not be updated to HMI
    if(PE_PBS_LOADINGSTATEFORREMOTEACTIVITY != status)
    {
        mCurrentPlaybackState = status;
    }
    else
    {
        //Playermanager will not forward the update only if the playback state is loading
        PlaybackstatusTobeUpdated = PE_PBS_LOADINGSTATE;
    }

    /*If RemoteActivity Still not happened even though the playback status changed from PLAYING,then forget doing REMOTE_ACTVITY
    issue scenario :Phone informs as PLAYING but invalid time updates received.Phone itself sent TRACK_CHANGE and moved to STOPPED State.*/
    if((true == mIsRemoteActivityNeeded) && (mCurrentPlaybackState != PE_PBS_PLAYINGSTATE))
    {
        ClearRemoteActivityFlags();
    }

    ETG_TRACE_USR1(("ForwardPlaybackStatus status:%d,metadata1:%128s,metadata2:%128s",status,metadata1,metadata2));
    ETG_TRACE_USR1(("metadata3:%128s,metadata4:%128s",metadata3,metadata4));

    if(!mConnectedDeviceInfo.activeSource || !strcmp(metadata1,"UNKNOWN"))
    {
        ETG_TRACE_ERR(("BTControl::ForwardPlaybackStatus() - Ignore playback status response as BTControl is not active or UNKNOWN metadata responses"));
        return ret;
    }

    /*Send any update to PlayerManager ONLY IF BTControl is active*/
    if(mIsBTControlActive)
    {

        if(LocalSPM::GetDataProvider().UseArlSrcBtAudio())
        {
            /* Check the metadata values. Fill UNKNOWN text if value is empty. */
            if(0 < strlen_r(metadata1))
            {
                strncpy_r(OUT localmetadata1, IN metadata1, IN sizeof(tMetadata));
            }
            else
            {
                strncpy_r(OUT localmetadata1, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(tMetadata));
            }
            if(0 < strlen_r(metadata2))
            {
                strncpy_r(OUT localmetadata2, IN metadata2, IN sizeof(tMetadata));
            }
            else
            {
                strncpy_r(OUT localmetadata2, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(tMetadata));
            }
            if(0 < strlen_r(metadata3))
            {
                strncpy_r(OUT localmetadata3, IN metadata3, IN sizeof(tMetadata));
            }
            else
            {
                strncpy_r(OUT localmetadata3, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(tMetadata));
            }
            if(0 < strlen_r(metadata4))
            {
                strncpy_r(OUT localmetadata4, IN metadata4, IN sizeof(tMetadata));
            }
            else
            {
                strncpy_r(OUT localmetadata4, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(tMetadata));
            }
        }
        /* Send PLAYBACK_STATUS_RESPONSE message to PlayerManger to update playback state */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(messageString));

        if(LocalSPM::GetDataProvider().UseArlSrcBtAudio())
        {
            ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN PlaybackstatusTobeUpdated, IN localmetadata1,
                    IN localmetadata2, IN localmetadata3, IN localmetadata4, IN localmetadata3, IN MTY_AUDIO_STREAM,IN (tConvertFlag)0,IN NULL,ObjectID);
        }
        else
        {
            ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN PlaybackstatusTobeUpdated, IN metadata1,
                    IN metadata2, IN metadata3, IN metadata4, IN metadata3, IN MTY_AUDIO_STREAM,IN (tConvertFlag)0,IN NULL,ObjectID);
        }
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("BTControl::ForwardPlaybackStatus() - Error while preparing parameter string"));
            parameterString[0] = '\0';
        }

        //Check Coveart status and update albumart string
        std::string objectIDmatcher=GetObjectIDMatcher(ObjectID);
        VARTRACE(objectIDmatcher.c_str());
        VARTRACE(m_CurrentMediaObject.albumArtString);
        if(!mCurrentAlbumartPath.empty() && (mCurrentAlbumartPath.find(objectIDmatcher) != std::string::npos))
        {
            strncpy_r(OUT m_CurrentMediaObject.albumArtString, IN mCurrentAlbumartPath.c_str(), IN sizeof(tAlbumArt));
        }
        else
        {
            SendAlbumArtStatusToPlayerManager(false);
            strncpy_r(OUT m_CurrentMediaObject.albumArtString, IN "", IN sizeof(tAlbumArt));
        }


        Dispatcher::GetInstance().SendMessage( IN messageString,IN parameterString);
        strncpy_r(OUT m_CurrentMediaObject.MetadataField1, IN metadata1, IN sizeof(tMetadata));
        strncpy_r(OUT m_CurrentMediaObject.MetadataField2, IN metadata2, IN sizeof(tMetadata));
        strncpy_r(OUT m_CurrentMediaObject.MetadataField3, IN metadata3, IN sizeof(tMetadata));
        strncpy_r(OUT m_CurrentMediaObject.MetadataField4, IN metadata4, IN sizeof(tMetadata));
        m_CurrentMediaObject.objectID = ObjectID;
        /* Send NOW_PLAYING_STATUS message to PlayerManger to update playback state */
        if((PE_PBS_PAUSEDSTATE == mCurrentPlaybackState) || (strlen(m_CurrentMediaObject.albumArtString) > 0)){
            char messageString_1[64];
            strncpy_r(OUT messageString_1, IN "PlayerManagerSM::NOW_PLAYING_STATUS", IN sizeof(messageString_1));

            tAllParameters parameterString_1;
            size_t size_1 = sizeof(parameterString_1);

            if(LocalSPM::GetDataProvider().UseArlSrcBtAudio())
            {
                ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString_1, IN size_1, IN ObjectID, IN localmetadata1,
                        IN localmetadata2, IN localmetadata3, IN localmetadata4, IN localmetadata3,IN MTY_AUDIO_STREAM, IN (tBitRate)0, IN (me::samplerate_i)0, IN ACF_UNKNOWN,IN (tConvertFlag)0,IN NULL,IN m_CurrentMediaObject.albumArtString);
            }
            else
            {

                ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString_1, IN size_1, IN ObjectID, IN metadata1,
                        IN metadata2, IN metadata3, IN metadata4, IN metadata3,IN MTY_AUDIO_STREAM, IN (tBitRate)0, IN (me::samplerate_i)0, IN ACF_UNKNOWN,IN (tConvertFlag)0,IN NULL,IN m_CurrentMediaObject.albumArtString);
            }
            if (MP_NO_ERROR != ret) {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
                parameterString[0] = '\0';
            }
            Dispatcher::GetInstance().SendMessage( IN messageString_1, IN parameterString_1);
        }
    }
    else
    {
        //Do not Send any update to PlayerManager as BTControl is not the Active Device Control.
    }

    //Fetch coverart from device if the coverart info available.
    if(LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt() && (CONNECTED == mConnectedDeviceInfo.coverArtConStatus))
    {
        if(strlen(m_CurrentMediaObject.albumArtString) == 0)
        {
            tBTCoverArtInfo coverArtInfo = GetCoverArtInfo();

            if((coverArtInfo.objectID == m_CurrentMediaObject.objectID) && !coverArtInfo.coverArthandle.empty() && !coverArtInfo.mediaItemObjectPath.empty())
            {
                BTDaemonProxy::GetInstance().AvpGetImage(IN coverArtInfo);
            }
            else
            {
                VARTRACE(coverArtInfo.mediaItemObjectPath.c_str());
                ETG_TRACE_USR4(("Invalid CoveArtinfo or it is not matching with current track"));
            }
        }
        else if(strlen(m_CurrentMediaObject.albumArtString) > 0)
        {
            SendAlbumArtStatusToPlayerManager(true);
        }
    }
    else
    {
        ETG_TRACE_USR4(("BT CoverArt feature not enabled or CoverArtConnection status is false"));
    }

    return MP_NO_ERROR;
}
tResult BTControl::MessageNotConsumed()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    return ret;
}

tResult BTControl::SetOutputDevice(const tAudioOutputDevice audioOutputDevice)
{
    ENTRY
    VARTRACE(audioOutputDevice);

    /* Store audio output device (alsa device name) internally */
    strncpy_r(OUT m_AudioOutputDevice, IN audioOutputDevice, IN sizeof(tAudioOutputDevice));

    return MP_NO_ERROR;
}

tResult BTControl::StartPlaybackAction(const tDeviceType deviceType, const tDeviceID deviceID,
            const tURL URL, const tMountPoint mountPoint,const tPlaybackAction playbackAction, const tNextPrevSkipCount skipcount)
{
    ENTRY
    (void)deviceType;
    (void)deviceID;
    //The URL can be an empty value , when playback action is triggered internally.
    (void)URL;
    (void)mountPoint;
    (void)skipcount;

    tBTControlCmd command = BT_CMD_PLAY;
    tBTButtonEvent buttonAction = BUTTON_CLICK;

    /* map to bt specific action*/
    switch(playbackAction)
    {
        case PBA_PLAY:
            command = BT_CMD_PLAY;
            break;
        case PBA_PAUSE:
            command = BT_CMD_PAUSE;
            //Playback action Pause is requested from the HMI , so stop the play retrial timer, to avoid retrial play command to device.
            StopRetryPlayTimer();
            break;
        case PBA_NEXT:
            command = BT_CMD_NEXTTRACK;
            break;
        case PBA_PREV:
            command = BT_CMD_PREVTRACK;
            break;
        case PBA_STOP:
            command = BT_CMD_STOP;
            //Playback action stop is requested from the HMI , so stop the play retrial timer, to avoid retrial play command to device.
            StopRetryPlayTimer();
            break;
        case PBA_FREV_START:
            buttonAction = BUTTON_PRESS;
            command = BT_CMD_REWIND;
            mIsFastRevInProgress = true;
            //Playback action frev_start is requested from the HMI , so stop the play retrial timer, to avoid retrial play command to device.
            StopRetryPlayTimer();
            break;
        case PBA_FREV_STOP:
            buttonAction = BUTTON_RELEASE;
            command = BT_CMD_REWIND;
            mIsFastRevInProgress = false;
            //Playback action frev_stop is requested from the HMI , so stop the play retrial timer, to avoid retrial play command to device.
            StopRetryPlayTimer();
            break;
        case PBA_FFWD_START:
            buttonAction = BUTTON_PRESS;
            command = BT_CMD_FORWARD;
            //Playback action ffwd_start is requested from the HMI , so stop the play retrial timer, to avoid retrial play command to device.
            StopRetryPlayTimer();
            break;
        case PBA_FFWD_STOP:
            buttonAction = BUTTON_RELEASE;
            command = BT_CMD_FORWARD;
            //Playback action ffwd_stop is requested from the HMI , so stop the play retrial timer, to avoid retrial play command to device.
            StopRetryPlayTimer();
            break;
        default:
            break;
    }

    /*request for the playback action with the bt-daemon*/
    BTDaemonProxy::GetInstance().AvpCtrlCmd(command,buttonAction);
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
      /*acknowledge the request : todo : answer after received the update*/
      tAllParameters parameterString;
      size_t size = sizeof(parameterString);
      ParameterPLAYBACK_ACTION_ANSWER(OUT parameterString, IN size, IN (tPEHandle)0, IN mCurrentPlaybackState, IN (me::reason_e)0, IN (me::speed_e)0);
      SendEvent(PLAYBACK_ACTION_ANSWER, IN parameterString);
    }
    else
    {
        RegisterReleaseEvent(PLAYBACK_ACTION_ANSWER);
    }
    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::PlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, //Roadmap 13008
            const me::reason_e reason, const me::speed_e speed)
{
    ENTRY;
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);
    VARTRACE(mCurrentPlaybackState);

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    tPEPlaybackState pbState = playbackState;
    /* mCurrentPlaybackState is dependent on info from both Playback engine (i.e PlayerEngine/MediaEngine) and Device's PlaybackState.
    Similar to ForwardPlaybackStatus & PlaybackStatus,PlaybackStatusNew also made to update mCurrentPlaybackState */
    /*Should not send the playback status (PE_PBS_PLAYINGSTATE) received in START_STREAMING_ANSWER to HMI because it is sending from Mediaengine after   setting the pipe. Update only the playback status update received from the device for streaming devices.
     */
    if((mCurrentPlaybackState != playbackState) && (playbackState == PE_PBS_PLAYINGSTATE))
    {
        ETG_TRACE_USR4(("Send the playback status as PE_PBS_LOADINGSTATE"));
        pbState = PE_PBS_LOADINGSTATE;
    }
    else
    {
        mCurrentPlaybackState = playbackState;
    }

    if(REASON_OK > reason)
    {
        /* Send action error instead of answer to waiting state machine */
        ret = LocalSPM::GetDeviceDispatcher().ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendActionError(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {

        /* Send answer to waiting state machine */
        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER_NEW(OUT parameterString, IN size, IN handle, IN pbState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}


tResult BTControl::GetAlbumArt(const tAlbumArt albumArtString)
{
    ENTRY

    VARTRACE(LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt());
    if(LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt())
    {
        char *pAlbumArtString = new char[sizeof(tAlbumArt)];      // will be deleted by the thread function
        strncpy_r(OUT pAlbumArtString, IN albumArtString, IN sizeof(tAlbumArt));

        /*Create a worker thread to extract the album art */
        LocalSPM::GetThreadFactory().Do (IN this, FUNCTION_ID_ALBUMART, (void*)pAlbumArtString, this); //lint -e 429 freed by calling thread
    }
    else
    {
        (void)albumArtString;

        /*album art not supported*/

        /* Status response: Send answer to waiting state  */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ParameterGET_ALBUM_ART_ANSWER(parameterString, size, IN NULL);
        SendEvent(GET_ALBUM_ART_ANSWER, IN parameterString);
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::HandleGetAlbumArtAnswer(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY;

    tResult ret = MP_NO_ERROR;

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    ParameterGET_ALBUM_ART_ANSWER(parameterString, size, IN ptrToAlbumArtObject);

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        if (ptrToAlbumArtObject)
        {
            if (ptrToAlbumArtObject->imageData)
            {
                free(ptrToAlbumArtObject->imageData);
            }
            delete ptrToAlbumArtObject;
            ETG_TRACE_USR3(("AlbumArt buffer cleared"));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::SetPlaybackMode(const tDeviceType deviceType,const tDeviceID deviceID,
                                    const tMountPoint mountPoint,const tPlaybackMode playbackMode)
{
    ENTRY
    (void)deviceType;
    (void)deviceID;
    (void)mountPoint;

    tResult ret = MP_NO_ERROR;
    tBTShuffleMode Value = ALPS_SHUFFLE_INVALID;
    tBTPlayerSettingAttributeMode Mode = ALPS_ATTR_SHUFFEL;

    mPlaybackModeRequested = playbackMode;
    switch(mPlaybackModeRequested)
    {
        case PBM_NORMAL:
        Value = ALPS_SHUFFLE_OFF;
            break;

        case PBM_RANDOM:
        Value = ALPS_SHUFFLE_ALL;
            break;

        //case PBM_RANDOM_ALL: //Currently BT Devices doesnt support this value.
        default:
            break;
    }

    if(Value != ALPS_SHUFFLE_INVALID)
    {
        ret = BTDaemonProxy::GetInstance().AvpSetPlaybackModeVal(IN Mode,IN Value);
    }
    return ret;
}

tResult BTControl::AvpSetPlaybackModeMethodReturn(tBTMethodRequestStatus Status,tErrorMessage ErrorMessage)
{
    ENTRY
    (void)ErrorMessage;

    ETG_TRACE_USR4(("BTControl::SetPlaybackModeModeMethodReturn Status:%d",Status));

    /* To update the current PlaybackMode to HMI,If the Device doesn't support ALPS_EVENT_PLAYER_APPLICATION_SETTING_CHANGED notification,
    rely on the Acknowledgement for the Request Sent*/
    if(string(mConnectedDeviceInfo.deviceVersion) == "1.3" && !(mEventsSupported & ALPS_EVENT_PLAYER_APPLICATION_SETTING_CHANGED))
    {
        if(REQ_OK == Status)
        {
            mCurrentplaybackMode = mPlaybackModeRequested;

            char messageString[64];
            strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_MODE_STATUS", IN sizeof(messageString));
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            LocalSPM::GetPlayerManager().ParameterPLAYBACK_MODE_STATUS( OUT parameterString, IN size, IN mConnectedDeviceInfo.deviceID, IN mCurrentplaybackMode);
            return Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        }
        else
        {
            ETG_TRACE_USR4(("AvpSetVal for Shuffle Mode Failed"));
            return MP_NO_ERROR;
        }
    }
    return MP_NO_ERROR;
}
tResult BTControl::SetRepeatMode(const tDeviceType deviceType,const tDeviceID deviceID,
                                 const tMountPoint mountPoint,const tRepeatMode repeatMode)
{

    ENTRY
    (void)deviceType;
    (void)deviceID;
    (void)mountPoint;

    tResult ret = MP_NO_ERROR;
    tBTRepeatMode Value = ALPS_REPEAT_INVALID;
    tBTPlayerSettingAttributeMode Mode = ALPS_ATTR_REPEAT;

    mRepeatModeRequested = repeatMode;
    switch(mRepeatModeRequested)
    {
        case RPT_NONE:
            Value = ALPS_REPEAT_OFF;
            break;

        case RPT_ONE:
            Value = ALPS_REPEAT_SINGLE;
            break;

        case RPT_LIST:
            Value = ALPS_REPEAT_ALL;
            break;

        case RPT_LIST_WITH_SUBLISTS: //Currently BT Devices doesnt support thsese values.
        case RPT_ALL:
        default:
            break;
    }
    if(ALPS_REPEAT_INVALID != Value)
    {
        ret = BTDaemonProxy::GetInstance().AvpSetRepeatModeVal(IN Mode,IN Value);
    }
    return ret;
}

tResult BTControl::AvpSetRepeatModeMethodReturn(tBTMethodRequestStatus Status,tErrorMessage ErrorMessage)
{
    ENTRY
    (void)ErrorMessage;

    ETG_TRACE_USR4(("BTControl::SetRepeatModeMethodReturn Status:%d",Status));

    /* To update the current Repeatmode to HMI,If the Device doesn't support ALPS_EVENT_PLAYER_APPLICATION_SETTING_CHANGED notification,
    rely on the Acknowledgement for the Request Sent*/
    if(string(mConnectedDeviceInfo.deviceVersion) == "1.3" && !(mEventsSupported & ALPS_EVENT_PLAYER_APPLICATION_SETTING_CHANGED))
    {
        if(REQ_OK == Status)
        {
            mCurrentRepeatMode = mRepeatModeRequested;

            char messageString[64];
            strncpy_r(OUT messageString, IN "PlayerManagerSM::REPEAT_MODE_STATUS", IN sizeof(messageString));
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            LocalSPM::GetPlayerManager().ParameterREPEAT_MODE_STATUS( OUT parameterString, IN size, IN mConnectedDeviceInfo.deviceID, IN mCurrentRepeatMode);
            return Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        }
        else
        {
            ETG_TRACE_USR4(("AvpSetVal for Repeat Mode Failed"));
            return MP_NO_ERROR;
        }
    }
    return MP_NO_ERROR;
}

tResult BTControl::ActionStatus(const tReturnValue returnValue)
{
    ENTRY

    ETG_TRACE_USR3(("BTControl::ActionStatus() returnValue:%u", returnValue));

    tResult ret = MP_NO_ERROR;

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("BTControl::ActionStatus() - Error while preparing parameter string"));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);

    //Don't return an error because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::DoneEventProcessed() // finished: 100%
{
    ENTRY

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

tResult BTControl::ForwardPlaytimeStatus(const tPlaytime elapsedPlaytime,
           tPlaytime totalPlaytime)
{
    ENTRY
    ETG_TRACE_USR3(("BTControl::ForwardPlaytimeStatus elapsed:%d,total:%d",elapsedPlaytime,totalPlaytime));

    tResult ret = MP_NO_ERROR;
    if(mConnectedDeviceInfo.activeSource)
    {
#if 0
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ret = LocalSPM::GetPlayerManager().ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("BTControl::ForwardPlaytimeStatus() - Error while preparing parameter string"));
            parameterString[0] = '\0';
        }

        /* Send TICK_TIME_ELAPSED message to PlayerManger to update playtime */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::TICK_TIME_ELAPSED", IN sizeof(messageString));

        ret = Dispatcher::GetInstance().SendMessage(IN messageString,IN parameterString);

        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
#else
        tPETimeInfoStruct timeInfoStruct;
        InitPETimeInfoStruct(timeInfoStruct);
        timeInfoStruct.position.ms = elapsedPlaytime;
        timeInfoStruct.duration.ms = totalPlaytime;

        VARTRACE(timeInfoStruct.position.ms);
        VARTRACE(timeInfoStruct.duration.ms);

        /* Marshal struct of timeInfo into a string */
        tPETimeInfo timeInfoString;
        size_t size = sizeof(timeInfoString);
        SMF::Marshal(OUT timeInfoString,
                     IN size-1,
                     IN DOUBLE_MARSHAL_SEPARATOR,
                     IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
                     IN timeInfoStruct.position.bytes,
                     IN timeInfoStruct.position.pct,
                     IN timeInfoStruct.position.ms,
                     IN timeInfoStruct.duration.bytes,
                     IN timeInfoStruct.duration.ms);

        /* Send PLAYTIME_STATUS message to PlayerManger to update playtime */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYTIME_STATUS", IN sizeof(messageString));
        tAllParameters parameterString;
        size = sizeof(parameterString);

        ret = LocalSPM::GetPlayerManager().ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN mHandle, IN mConnectedDeviceInfo.deviceID, IN timeInfoString);
        if (MP_NO_ERROR != ret){
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret){
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
#endif
    }
    //Request Remote activity on receiving valid playtime update.
    else
    {
        /*If playtime Received while BT Device not an Active source and mIsRemoteActivityNeeded being TRUE,
        Check elapsed playtime informed from the device keeps incrementing.
        If found Incrementing,then it means the Device has begun real streaming.
        Hence activate the BT Device
         */
        if(mIsRemoteActivityNeeded)
        {
            ValidatePlayTimeAndActivateBTDevice(elapsedPlaytime,totalPlaytime);
        }
    }
    return ret;
}
tResult BTControl::ValidatePlayTimeAndActivateBTDevice(const tPlaytime &elapsedPlayTime,const tPlaytime &totalPlayTime)
{
    tResult ret  = MP_NO_ERROR;

    //If device is not in playing state,then ClearRemoteActivityFlags i.e forget the RemoteActivity to do
    if(PE_PBS_PLAYINGSTATE == mCurrentPlaybackState)
    {
        /*Dont check the playtime update.Observed for some android devices elapsed time not updating peoprly*/
        if(LocalSPM::GetDataProvider().RemoteActivitySupportForNonAppleDevice() && APPLE_VENDOR_ID_1 != mConnectedDeviceInfo.productID
            && APPLE_VENDOR_ID_2 != mConnectedDeviceInfo.productID)
        {
            ret = ActivateBTDevice();

            if(ret != MP_NO_ERROR)
            {
                ETG_TRACE_USR4(("ActivateBTDevice  Failed"));
            }

            return ret;
        }

        /*If mActionOnPlayTime is "STORE_VALID_PLAY_TIME",store only if a valid Playtime received
          Else,wait for a valid playtime update to remember .*/
        if(STORE_VALID_PLAY_TIME == mActionOnPlayTime)
        {
            if(totalPlayTime)
            {
                StorePlayTimeReceived(totalPlayTime,elapsedPlayTime);
            }
            else
            {
                ETG_TRACE_ERR(("Error:Invalid Playtime update from Device.Waiting for valid time to decide on RemoteActivity"));
            }
        }
        /* If mActionOnPlayTime is COMPARE_PLAY_TIME,then it means valid playtime is already stored.
           Compare the incoming playtime with the Stored one.
           1.If Total Playtime is same,then check whether the time has elapsed or not.
             a)If Elapsed,then this confirms phone's player is playing ->Activate BT Device
             b)If not Elapsed,then check for the next update and do nothing now.
           2.If Total Playtime is not same,then store it(if its a valid).
        */
        else if(COMPARE_PLAY_TIME == mActionOnPlayTime)
        {
            if(totalPlayTime == mTotalPlayTime)
            {
                if(elapsedPlayTime > mElapsedPlayTime)
                {
                    ETG_TRACE_USR4(("Phone Playtime started Incrementing.Considered as Phone began Streaming"));
                    ret = ActivateBTDevice();

                    if(ret != MP_NO_ERROR)
                    {
                        ETG_TRACE_USR4(("ActivateBTDevice  Failed"));
                    }
                }
            }
            //A new track with Different Total playtime became current track
            else if(totalPlayTime)
            {
                StorePlayTimeReceived(totalPlayTime,elapsedPlayTime);
            }
        }
    }
    else
    {
        ClearRemoteActivityFlags();
    }

    return ret;
}
void BTControl::StorePlayTimeReceived(const tPlaytime &totalPlayTime,const tPlaytime &elapsedPlayTime,const tBTActionOnPlayTime ActionOnPlayTime /*COMPARE_PLAY_TIME */)
{
    mTotalPlayTime = totalPlayTime;
    mElapsedPlayTime = elapsedPlayTime;
    mActionOnPlayTime = ActionOnPlayTime;
}
tResult BTControl::ActivateBTDevice()
{
    ENTRY;

    tResult ret  = MP_NO_ERROR;
    tBoolean isPlayerActive;
    ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isPlayerActive);
    if (ret) return ret;

    //update clients (in this case connectivity) that the device has updated play and is ready for activation [for RTC bug : Bug 280485]
    if(LocalSPM::GetDataProvider().updateReadyToPlay())
    {
        char msgToSendString[64];
        tAllParameters parameters;
        size_t paramSize = sizeof(parameters);
        tPEPlaybackState playbackState = PE_PBS_PLAYINGSTATE;

        strncpy_r(OUT msgToSendString, IN "CustomControlSM::UPDATE_READY_TO_PLAY", IN sizeof(msgToSendString));

        ret = LocalSPM::GetCustomControl().ParameterUPDATE_READY_TO_PLAY(OUT parameters, IN paramSize, IN mConnectedDeviceInfo.serialNumber , IN  playbackState);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameters[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameters);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    /*Request for mediaplayer AV activation*/
    /* In projects having unique logical channel for BT Media source ,
       Irrespective of isPlayerActive depend on mConnectedDeviceInfo.activeSource for AVActivation request*/
    if(LocalSPM::GetDataProvider().UseArlSrcBtAudio() && !mConnectedDeviceInfo.activeSource)
    {
        ret = LocalSPM::GetOutputWrapper().RequestAVActivation(1,LC_BT_AUDIO,0,mConnectedDeviceInfo.deviceID);
        if (ret)return ret;
    }
    else if(isPlayerActive == FALSE)
    {
        ret = LocalSPM::GetOutputWrapper().RequestAVActivation(1,LC_MAIN_AUDIO);
        if (ret)return ret;
    }

    SendRemoteActivity(IN mConnectedDeviceInfo.mountPoint);

#if 0
    char messageString_1[64];
    tAllParameters parameterString_1;
    size_t size_1 = sizeof(parameterString_1);
    strncpy_r(OUT messageString_1, IN "PlayerManagerSM::REMOTE_ACTIVITY", IN sizeof(messageString_1));

    ret = LocalSPM::GetPlayerManager().ParameterREMOTE_ACTIVITY(OUT parameterString_1, IN size_1, IN mConnectedDeviceInfo.deviceID);
    if (ret)return ret;

    ret = Dispatcher::GetInstance().SendMessage(IN messageString_1, IN parameterString_1);
    if (ret)return ret;
#endif
    if(m_SiriSessionTimerID)
    {
        ClearSiriSessionFlags();
    }

    mActionOnPlayTime = REMOTE_ACTIVITY_REQUEST_POSTED;

    return ret;
}

tResult BTControl::AvpGetFolderItem(tScope Scope,
                                    tStartItem StartItem,
                                    tEndItem EndItem)
{
    ENTRY
    VARTRACE(StartItem);
    VARTRACE(EndItem);
    ETG_TRACE_USR3(("BTControl::AvpGetFolderItem start:%d, end:%d",StartItem,EndItem));

    RegisterReleaseEvent(AVP_GET_FOLDER_ITEM_METHOD_RETURN);
    BTDaemonProxy::GetInstance().AvpGetFolderItem(IN Scope,IN StartItem,IN  EndItem);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::AvpGetFolderItemMethodReturn(tBTMethodRequestStatus status,
                                                tScope scope,
                                                tNetworkOrder networkOrder,
                                                tByteArray byteArray,
                                                tArrayLength arrayLength,
                                                tErrorMessage errorMessage)
{

    ENTRY

    tAllParameters parameterString="";
    size_t size = sizeof(parameterString);

    if(status == REQ_OK)
    {
        ETG_TRACE_USR1(("scope is %d",scope));
        ETG_TRACE_USR1(("networkOrder is %d",networkOrder));
        ETG_TRACE_USR1(("arrayLength is %d",arrayLength));
        ETG_TRACE_USR1(("byteArray is %p",byteArray));

        if(!arrayLength)
        {
            status = REQ_NOT_OK;
        }
    }
    else
    {
        ETG_TRACE_USR1(("GetFolderItem Req is NOT_OK"));
    }
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        ParameterAVP_GET_FOLDER_ITEM_METHOD_RETURN(OUT parameterString,IN size,IN status,IN scope,IN networkOrder,IN byteArray,IN arrayLength,IN errorMessage);
        SendAnswer(IN parameterString);

    }else
    {
        if(mIsPlayItemFromBrowseNeeded)
        {
            DoPlayItemFromBrowse();

        }
        else
        {
            ParameterAVP_GET_FOLDER_ITEM_METHOD_RETURN(OUT parameterString,IN size,IN status,IN scope,IN networkOrder,IN byteArray,IN arrayLength,IN errorMessage);
            SendAnswer(IN parameterString);
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::AvpChangePath (tDirection direction,
                                 tLevelCount levelUpCount,
                                 tLevelCount levelDownCount,
                                 tItemUIDArray itemUidArray)
{
    ENTRY
    string reqPath = string((const char *)itemUidArray);
    ETG_TRACE_USR3(("ReqPath is %s",reqPath.c_str()));
    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString="";
    size_t size = sizeof(parameterString);
    tBTMethodRequestStatus status = REQ_NOT_OK;
    tNumOfItems numOfItems = 0 ;
    tErrorMessage errorMessage = NULL;
    ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN errorMessage,IN reqPath.c_str()); //parameterString for negative values .


    if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        tBTPlayerInfo PlayerInfo = BTDaemonProxy::GetInstance().GetPlayerInfo();
        ETG_TRACE_USR3(("getIsAvpChangePathFromStartPlay : %d",getIsAvpChangePathFromStartPlay()));
        RegisterReleaseEvent(AVP_CHANGE_PATH_METHOD_RETURN,parameterString); //Register release event should not set the "status" with positive value.
        tDeviceInfo ConnectedDeviceInfo;
        ConnectedDeviceInfo = GetConnectedDeviceInfo();
        VARTRACE(PlayerInfo.isBrowsable);
        // Stop AvpChangePath if the player is not browsable
        if((DEVICE_ID_NOT_SET == ConnectedDeviceInfo.deviceID) || (!(ConnectedDeviceInfo.connected)) || (!(PlayerInfo.isBrowsable)))
        {
            SendEvent(AVP_CHANGE_PATH_METHOD_RETURN,parameterString);
            return MP_NO_ERROR;
        }
        if(reqPath.find("/NowPlaying") != string::npos)
        {
            tPEPlaybackState NowPlayingStatus = BTDaemonProxy::GetInstance().GetNowPlayingStatus();
            VARTRACE(NowPlayingStatus);
            // Stop AvpChangePath if path is /Nowplaying and stopped state
            if(!((PE_PBS_PLAYINGSTATE == NowPlayingStatus) || (PE_PBS_PAUSEDSTATE == NowPlayingStatus) || (PE_PBS_FASTFORWARDSTATE == NowPlayingStatus) || (PE_PBS_FASTREVERSESTATE == NowPlayingStatus) || (PE_PBS_SEEKTOSTATE == NowPlayingStatus)))
            {
                mCurrentReqPath = reqPath;
                SendEvent(AVP_CHANGE_PATH_METHOD_RETURN,parameterString);
                return MP_NO_ERROR;
            }
        }
    }


    if(mCurrentReqPath == reqPath)
    {
        ETG_TRACE_USR3(("AvpChangePath called by Internal Event"));
        ret = DoChangePath(direction,levelUpCount,levelDownCount,itemUidArray);

        /* Send releasing event to own waiting state machine */
        if(ret != MP_NO_ERROR)
        {
            ETG_TRACE_USR3(("DoChangePath Failed"));
        }
        else
        {
            ETG_TRACE_USR3(("DoChangePath Successfull"));
        }
    }
    else
    {
        if(GetCurrentBrowsePath() == NULL || strcmp((const char*)GetCurrentBrowsePath(),reqPath.c_str()))
        {
            //Store the newly Requested path by VTBluetooth even if mCurrentBrowsePath & reqPath are same
            mCurrentReqPath = reqPath;
            ETG_TRACE_USR3(("AvpChangePath mCurrentReqPath:%s",mCurrentReqPath.c_str()));
            ret = SetCurrentBrowsedPath((unsigned char *)const_cast<char*>(reqPath.c_str()));
            if(ret == MP_NO_ERROR)
            {
                ETG_TRACE_USR3(("SetCurrentBrowsedPath Successful"));
            }
            else
            {
                ETG_TRACE_USR3(("SetCurrentBrowsedPath Failed"));
                mDirectionRequested = LEVEL_CHANGE_INVALID;
                SendEvent(AVP_CHANGE_PATH_METHOD_RETURN,parameterString);
            }
        }
        else
        {
            ETG_TRACE_USR3(("mCurrentBrowsePath == reqPath"));
            mCurrentReqPath = reqPath;
            if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
            {
                if("/NowPlaying" == reqPath)
                {
                    status = REQ_OK;
                    numOfItems = 0;
                    ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN errorMessage,IN reqPath.c_str());
                    SendEvent(AVP_CHANGE_PATH_METHOD_RETURN,parameterString);
                }
                else
                {
                    BTDaemonProxy::GetInstance().AvpGetNumberOfItemsInCurrentFolder();
                }
            }
            else
            {
                mDirectionRequested = LEVEL_CHANGE_NOT_NEEDED;
                SendEvent(AVP_CHANGE_PATH_METHOD_RETURN,parameterString);
            }
        }


    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::AvpChangePathMethodReturn(tBTMethodRequestStatus Status,
                                             tNumOfItems NumOfItems,
                                             tErrorMessage ErrorMessage,const tPath argPath)
{

     ENTRY
     ETG_TRACE_USR1(("Status is %d",Status));
     ETG_TRACE_USR1(("NumOfItems is %d",NumOfItems));
     ETG_TRACE_USR1(("ErrorMessage is %s",ErrorMessage));
     VARTRACE(argPath);
     tResult ret = MP_NO_ERROR;
     tAllParameters parameterString="";
     size_t size = sizeof(parameterString);
     tDirection Direction = LEVEL_CHANGE_INVALID;
     tLevelCount LevelUpCount = 0;
     tLevelCount LevelDownCount = 0;
     tItemUID ItemUID = NULL;

  if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
  {
     ETG_TRACE_USR1(("Status is %d",Status));
     ETG_TRACE_USR1(("NumOfItems is %d",NumOfItems));
     ETG_TRACE_USR1(("ErrorMessage is %s",ErrorMessage));

    if(mDirectionRequested == LEVEL_CHANGE_NOT_NEEDED && mIsPlayItemFromBrowseNeeded)
    {
        mDirectionRequested = LEVEL_CHANGE_INVALID;
        ETG_TRACE_USR3(("Item Selected to Play is in the mCurrentBrowsePath"));
        DoPlayItemFromBrowse();
        return ret;
    }
    else if(mDirectionRequested == LEVEL_CHANGE_NOT_NEEDED)
    {
        NumOfItems = mCurBrowsedPthItemCnt;
        ETG_TRACE_USR4(("mCurBrowsedPthItemCnt:%d mCurrentReqPath:%s",mCurBrowsedPthItemCnt,mCurrentReqPath.c_str()));
        if(!NumOfItems && mCurrentReqPath == PATH_DELIMITER)
        {
            Status = REQ_NOT_OK;
        }
        else
        {
             Status = REQ_OK;
             if(GetCurrentBrowsePath() != NULL)
             {
                 ClearCurrentBrowsePath();
             }
             SetCurrentBrowsePath(mCurrentReqPath);

             if(GetCurrentBrowsePath() != NULL)
             {
                 ETG_TRACE_USR3(("AvpChangePath Called Just to get no.of Items in the Current Folder:%s",GetCurrentBrowsePath()));
             }
        }
        ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN Status,IN NumOfItems,IN ErrorMessage,IN argPath);
        ret = SendAnswer(IN parameterString);
        mCurrentReqPath = "";
        return ret;
    }
    //To handle the Failure of SetCurrentBrowsedPath
    else if(mDirectionRequested == LEVEL_CHANGE_INVALID)
    {
        ETG_TRACE_USR3(("Error happened in Setting up the Browse Path!"));
        ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN Status,IN NumOfItems,IN ErrorMessage,IN argPath);
        ret = SendAnswer(IN parameterString);
        mCurrentReqPath = "";
        return ret;
    }

    if(REQ_OK == Status)
    {
        if(mDirectionRequested == FOLDER_UP)
        {
            if(mLevelUpCount != 0)mLevelUpCount--;
            if(mLevelUpCount > 0)
            {
                ETG_TRACE_USR3(("No.of Remaining Level-up Needed to be done is %d",mLevelUpCount));
                Direction = FOLDER_UP;
                ItemUID = (tItemUID)const_cast<char*>(mCurrentReqPath.c_str());
            }
            else
            {
                ETG_TRACE_USR3(("Level-up completed.Need to do Level-down if any !"));
                if(mLevelDownCount > 0)
                {
                    Direction = FOLDER_DOWN;
                    ETG_TRACE_USR3(("No.of Remaining Level-down Needed to be done is %d",mLevelDownCount));
                    ItemUID = (tItemUID)const_cast<char*>(mCurrentReqPath.c_str());
                }
                else
                {
                    ETG_TRACE_USR3(("Needed Level Changes were Done!"));
                    if(GetCurrentBrowsePath() != NULL)
                    {
                       //   free(mCurrentBrowsePath);
                        ClearCurrentBrowsePath();
                    }
                    // mCurrentBrowsePath = (unsigned char*)strdup(mCurrentReqPath.c_str());
                    SetCurrentBrowsePath(mCurrentReqPath);
                    mIsStoreInfoNeeded = true;
                    mCurrentReqPath = "";
                    mLevelUpCount = 0;
                    mLevelDownCount = 0;
                    ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN Status,IN NumOfItems,IN ErrorMessage,IN argPath);
                    ret = SendAnswer(IN parameterString);
                    return ret;
                }
            }
        }
        else if(mDirectionRequested == FOLDER_DOWN)
        {
            if(mLevelDownCount != 0)mLevelDownCount--;

            if(mLevelDownCount > 0)
            {
                mUIDArray = mUIDArray + SIZE_OF_ITEM_UID;
                Direction = FOLDER_DOWN;
                ETG_TRACE_USR3(("No.of Remaining Level-down Needed to be done is %d",mLevelDownCount));
                ItemUID = (tItemUID)const_cast<char*>(mCurrentReqPath.c_str());
            }
            else
            {

                ETG_TRACE_USR3(("Needed Level Changes were Done!"));

                if(GetCurrentBrowsePath() != NULL)
                {
                    ClearCurrentBrowsePath();
                }
                SetCurrentBrowsePath(mCurrentReqPath);

                free(mUIDArray_Address);
                mIsStoreInfoNeeded = true;
                mCurrentReqPath = "";
                mLevelUpCount = 0;
                mLevelDownCount = 0;
                mUIDArray_Address = NULL;
                if(mIsPlayItemFromBrowseNeeded)
                {
                    DoPlayItemFromBrowse();
                    return ret;
                }
                ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN Status,IN NumOfItems,IN ErrorMessage,IN argPath);
                ret = SendAnswer(IN parameterString);
                return ret;
            }
        }
    }
    else
    {
        ETG_TRACE_USR3(("Request has failed as we are either in ROOT (OR) the UID is invalid (OR) ReleaseWaiting() (OR) SetCurrentBrowsedPath failed "));
        ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN Status,IN NumOfItems,IN ErrorMessage,IN argPath);
        ret = SendAnswer(IN parameterString);
        if(mUIDArray_Address != NULL) free(mUIDArray_Address);
        mUIDArray_Address = NULL;
        mIsStoreInfoNeeded = true;
        mLevelUpCount = 0;
        mLevelDownCount = 0;
        mCurrentReqPath = "";
        return ret;
    }

    ret = ParameterAVP_CHANGE_PATH(OUT parameterString,
                                    IN size,
                                    IN Direction,
                                    IN LevelUpCount,
                                    IN LevelDownCount,
                                    IN ItemUID);

    SendEvent(AVP_CHANGE_PATH,parameterString);
     }
  else
  {
      if(REQ_OK == Status)
      {
            if (GetCurrentBrowsePath() != NULL && mCurrentReqPath.size() > 0)
          {
                VARTRACE(GetCurrentBrowsePath());
              VARTRACE(mCurrentReqPath.size());
              VARTRACE(mIsPlayItemFromBrowseNeeded);
              VARTRACE(mCurrentReqPath.c_str());
              if (!strcmp((char*) GetCurrentBrowsePath(), mCurrentReqPath.c_str()))
              {
                  if (mIsPlayItemFromBrowseNeeded)
                  {
                      DoPlayItemFromBrowse();
                      return ret;
                  }
              }

          }

        if(GetCurrentBrowsePath() != NULL)
        {
            ClearCurrentBrowsePath();
        }

            string stringmCurrentBrowsePath;
            stringmCurrentBrowsePath = argPath;
            VARTRACE(argPath);
            ETG_TRACE_USR3(("avpchangepathmethodreturn stringmCurrentBrowsePath is :%s",stringmCurrentBrowsePath.c_str()));

            //If requested path is begin with "/Filesystem" or "/NowPlaying"
            if (stringmCurrentBrowsePath.find("/Filesystem") != string::npos || stringmCurrentBrowsePath.find("/NowPlaying") != string::npos)
            {
                if(stringmCurrentBrowsePath.find("/Filesystem") != string::npos)
                {
                    stringmCurrentBrowsePath = stringmCurrentBrowsePath.substr(strlen("/Filesystem"),stringmCurrentBrowsePath.size());
                    if (stringmCurrentBrowsePath.size() == 0)
                    {
                        stringmCurrentBrowsePath.append("/");
                        SetCurrentBrowsePath(stringmCurrentBrowsePath);
                    }
                    else
                    {
                        string CurrentReqPathForChangeWithoutSlash = GetStringWithoutSlash(GetCurrentReqPathForChange());
                        string newPath = stringmCurrentBrowsePath;
                        string stringmCurrentBrowsePathWithoutSlash = GetStringWithoutSlash(newPath);
                        if(!strcmp(CurrentReqPathForChangeWithoutSlash.c_str(),stringmCurrentBrowsePathWithoutSlash.c_str()))
                        {
                            ETG_TRACE_USR3(("CurrentReqPathForChangeWithoutSlash == stringmCurrentBrowsePathWithoutSlash"));
                            SetCurrentBrowsePath(GetCurrentReqPathForChange());
                        }
                        else
                        {
                            ETG_TRACE_USR3(("CurrentReqPathForChangeWithoutSlash != stringmCurrentBrowsePathWithoutSlash"));
                            SetCurrentBrowsePath(stringmCurrentBrowsePath);
                        }
                        //stringmCurrentBrowsePath.clear();
                    }

                }
                else
              {
                  if(NumOfItems== 0)
                  {
                      NumOfItems = NOW_PLAYING_DEFAULT;
                      StartNowplayingListUpdate();
                  }
                    SetCurrentBrowsePath(stringmCurrentBrowsePath);
                }

                if(GetCurrentBrowsePath() != NULL)
                {
                    VARTRACE(GetCurrentBrowsePath());
                }
                else
                {
                    ETG_TRACE_USR3(("mCurrentBrowsePath is NULL"));
                }


                if((strcmp(mCurrentReqPath.c_str(),(char*)GetCurrentBrowsePath())))
            {
                ETG_TRACE_USR3(("caling AvpChangePath again to reach reqPath:%s",mCurrentReqPath.c_str()));
                ret = ParameterAVP_CHANGE_PATH(OUT parameterString,
                                                        IN size,
                                                        IN Direction,
                                                        IN LevelUpCount,
                                                        IN LevelDownCount,
                                                        IN (unsigned char*)mCurrentReqPath.c_str());

                        SendEvent(AVP_CHANGE_PATH,parameterString);
                        return ret;

                }
                else
                {
                    SetCurrentBrowsePath(mCurrentReqPath);

                if(mIsPlayItemFromBrowseNeeded)
                {
                    DoPlayItemFromBrowse();
                    return ret;
                }
            }

            if(GetCurrentBrowsePath() != NULL)
            {
                    ETG_TRACE_USR3(("AvpChangePath Called Just to get no.of Items in the Current Folder:%s",GetCurrentBrowsePath()));
            }
            ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN Status,IN NumOfItems,IN ErrorMessage,IN argPath);
           ret = SendAnswer(IN parameterString);
           mCurrentReqPath = "";
           return ret;
         }

          ETG_TRACE_USR3(("Request has failed SetCurrentBrowsedPath failed "));
          ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString, IN size, IN Status, IN NumOfItems,
                  IN ErrorMessage, IN argPath);
          ret = SendAnswer(IN parameterString);
      }
      else
      {
          ETG_TRACE_USR3(("BTConrol :: Change path method return has failed "));
          if(false == mIsAvpChangePathFromStartPlay)
          {
              ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN Status,IN NumOfItems,IN ErrorMessage,IN argPath);
              ret = SendAnswer(IN parameterString);
          }
          setIsPlayItemFromBrowseNeeded(false);
          if(mUIDArray_Address != NULL) free(mUIDArray_Address);
          mUIDArray_Address = NULL;
          mIsStoreInfoNeeded = true;
          mLevelUpCount = 0;
          mLevelDownCount = 0;
          mCurrentReqPath = "";
          return ret;
      }
  }
    return ret;

}

tResult BTControl::AvpGetMediaPlayerItem(const tDeviceInfoString deviceInfoString,const tDeviceVersionUpdated IsDeviceVersionUpdated)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    VARTRACE(IsDeviceVersionUpdated)
    VARTRACE(deviceInfoString);

    if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported() && !LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        mIsDeviceVersionUpdated = IsDeviceVersionUpdated;

        /*mIsDeviceVersionUpdated is true,then the Attribute support will be requested if version updated from 1.0 -> 1.3*/
        if(mIsDeviceVersionUpdated)
        {
            DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
            if(deviceInfo.deviceID == mConnectedDeviceInfo.deviceID)
            {
                if((string(mConnectedDeviceInfo.deviceVersion)) == "1.0" && (string(deviceInfo.deviceVersion)) == "1.3")
                {
                    ret = GetSupportedAttr();
                    return MP_NO_ERROR;
                }
            }
            else
            {
                ETG_TRACE_USR3(("deviceInfo.deviceID != mConnectedDeviceInfo.deviceID"));
                return MP_NO_ERROR;
            }
        }
        /*If an AVRCP 1.3 Device updated/inserted into Database in CS_ATTACHED */
        else if((string(mConnectedDeviceInfo.deviceVersion)) == "1.3")
        {
            ret = GetSupportedAttr();
            return MP_NO_ERROR;
        }
    }

    /*Below AvpGetMediaPlayerItem will get called
    case 1:if the Already Device in CS_ATTACHED/CS_CONNECTED in database whose Version updated from 1.0 ->1.4
    case 2:If an AVRCP 1.4 Device updated/inserted into Database in CS_ATTACHED */
    tNumOfPlayers  NumOfPlayers = 255;

    ETG_TRACE_USR3(("NumOfPlayers is %d",NumOfPlayers));

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tBTMethodRequestStatus status = REQ_NOT_OK;
    tNetworkOrder networkOrder = FALSE;
    tArrayLength arrayLength = 0;
    tByteArray pData = NULL;
    ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_GET_MEDIAPLAYERITEM_METHOD_RETURN(OUT parameterString,IN size,IN status,IN networkOrder,IN pData,IN arrayLength,IN (tErrorMessage)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }

    RegisterReleaseEvent(AVP_GET_MEDIAPLAYERITEM_METHOD_RETURN,parameterString);

    ret = BTDaemonProxy::GetInstance().AvpGetMediaPlayerItem(IN NumOfPlayers);

    if(ret != MP_ERR_DBUS)
    {
        ETG_TRACE_USR3(("AvpGetMediaPlayerItem method Request is Posted in DBus Successfully"));
    }
    else
    {
        ETG_TRACE_USR3(("Error in Posting AvpGetMediaPlayerItem method Request in DBus"));

        /*If posting message in DBus itself fails,then BTControl should return  to IDLE State*/
        ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_ATTACHED);
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}
tResult BTControl::AvpGetMediaPlayerItemMethodReturn(tBTMethodRequestStatus status,
                                                    tNetworkOrder networkOrder,
                                                    tByteArray byteArray,
                                                    tArrayLength arrayLength,
                                                    tErrorMessage errorMessage)

{
    ENTRY
    (void )errorMessage;

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString="";
    size_t size = sizeof(parameterString);

    if(REQ_OK == status)
    {
        bool isPlayerIdFound = false;
        tPlayerId playerId = 0;
        tByteArray byteArrayAddress = NULL;
        if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {

            ETG_TRACE_USR1(("status is %d",status));
            ETG_TRACE_USR1(("networkOrder is %d",networkOrder));
            ETG_TRACE_USR1(("arrayLength is %d",arrayLength));

            byteArrayAddress = byteArray;

            if(arrayLength != 0)
            {
                struct MediaPlayer_Item_info *pMediaPlayerItemData = NULL;

                //Going to Find Player Supports Browsing (If any) and its Player ID
                do
                {
                    pMediaPlayerItemData = (struct MediaPlayer_Item_info*)byteArray; //lint !e826  To suprress LintInfo 826 as the conversion is purposefully done

                    if (MEDIAPLAYER == pMediaPlayerItemData->Item_Type)
                    {
                        ETG_TRACE_USR4(("MEDIAPLAYER Item found"));
                        if(networkOrder)
                        {
                            pMediaPlayerItemData->Item_Length = ntohs (pMediaPlayerItemData->Item_Length);
                            pMediaPlayerItemData->Player_ID   = ntohs (pMediaPlayerItemData->Player_ID);
                            pMediaPlayerItemData->Player_Sub_Type = ntohl(pMediaPlayerItemData->Player_Sub_Type);
                        }

                        ETG_TRACE_USR4(("FEATURE_BIT_MASK_EIGTH_BYTE is %d",*(byteArray + FEATURE_BIT_MASK_EIGTH_BYTE )));
                        ETG_TRACE_USR4(("FEATURE_BIT_MASK_NINETH_BYTE is %d",*(byteArray + FEATURE_BIT_MASK_NINETH_BYTE)));

                        //Atleast AVRCP1.4 Support,Browse support,DBaware,UID Persistency are found
                        bool l_bAVRCP14Support = *(byteArray + FEATURE_BIT_MASK_EIGTH_BYTE ) &  AVRCP_14_SUPPORT_BIT;
                        bool l_bBrowsingSupport = *(byteArray + FEATURE_BIT_MASK_EIGTH_BYTE ) & BROWSE_SUPPORT_BIT;
                        bool l_bDBAware         = *(byteArray + FEATURE_BIT_MASK_EIGTH_BYTE ) & DB_AWARE_BIT;
                        bool l_bIsBrowseOnlyOnAddressed = *(byteArray + FEATURE_BIT_MASK_EIGTH_BYTE ) &  BROWSE_ONLY_ON_ADDRESS_BIT;
                        bool l_bUIDPersistent    = *(byteArray + FEATURE_BIT_MASK_NINETH_BYTE ) & UID_PERSISTENCY_BIT;


                        ETG_TRACE_USR4(("#####PlayerInfo Start#########"));
                        ETG_TRACE_USR4(("pMediaPlayerItemData->Item_Length is %d",pMediaPlayerItemData->Item_Length));
                        ETG_TRACE_USR4(("pMediaPlayerItemData->Player_ID is %d",pMediaPlayerItemData->Player_ID));
                        ETG_TRACE_USR4(("pMediaPlayerItemData->Major_Player_Type is %d",pMediaPlayerItemData->Major_Player_Type));
                        ETG_TRACE_USR4(("pMediaPlayerItemData->Player_Sub_Type is %d",pMediaPlayerItemData->Player_Sub_Type));
                        ETG_TRACE_USR1(("1.l_bAVRCP14Support is %s",l_bAVRCP14Support== true? "TRUE":"FALSE"));
                        ETG_TRACE_USR1(("2.l_bBrowsingSupport is %s",l_bBrowsingSupport== true? "TRUE":"FALSE"));
                        ETG_TRACE_USR1(("3.l_bDBAware is %s",l_bDBAware == true? "TRUE":"FALSE"));
                        ETG_TRACE_USR1(("4.l_bIsBrowseOnlyOnAddressed is %s",l_bIsBrowseOnlyOnAddressed == true? "TRUE":"FALSE"));
                        ETG_TRACE_USR1(("5.l_bUIDPersistent is %s",l_bUIDPersistent == true? "TRUE":"FALSE"));
                        ETG_TRACE_USR4(("#####PlayerInfo End#########"));

                        if(l_bBrowsingSupport)
                        {
                            if(((pMediaPlayerItemData->Major_Player_Type) & (AUDIO_PLAYER + BROADCASTING_AUDIO_PLAYER )) != 0)
                            {
                                ETG_TRACE_USR4(("Audio/Broadcasting Audio Player Found"));

                                if(l_bDBAware && l_bUIDPersistent)
                                {
                                    ETG_TRACE_USR4(("Player with DBAware & UID Persistent support Found."));
                                    ret = ParameterAVP_SET_PLAYER(  OUT parameterString,
                                            IN size,
                                            IN pMediaPlayerItemData->Player_ID,
                                            IN ADDRESSED_PLAYER);
                                    SendEvent(AVP_SET_PLAYER,parameterString);
                                    delete[] byteArrayAddress;
                                    return ret;
                                }
                                else if(l_bDBAware)
                                {
                                    ETG_TRACE_USR4(("Non-UID Persistent but DBaware Player Found.So Storing its UID Temporarily!"));
                                    playerId = pMediaPlayerItemData->Player_ID;
                                    isPlayerIdFound = true;
                                }
                                else
                                {
                                    ETG_TRACE_USR4(("DB unaware Player Foud.So Storing its UID Temporarily!"));
                                    playerId = pMediaPlayerItemData->Player_ID;
                                    isPlayerIdFound = true;
                                }
                            }
                            else
                            {
                                ETG_TRACE_USR4(("It is not Audio/Broadcasting Audio Player Player.So Need to Check for Next MediaPlayerItem!"));
                            }
                        }
                        else
                        {
                            ETG_TRACE_USR4(("It is not a Browse Supported mediaPlayer Item.So Ignore this Item.Need to check for Next Item!"));
                        }

                        //Points to next item
                        byteArray = byteArray +SIZE_OF_ITEM_TYPE_CUM_LENGTH +pMediaPlayerItemData->Item_Length;
                        //Decrement the Length Param
                        arrayLength =arrayLength - (SIZE_OF_ITEM_TYPE_CUM_LENGTH + pMediaPlayerItemData->Item_Length);
                        ETG_TRACE_USR4(("arrayLength Now is %d",arrayLength));
                    }
                    else
                    {
                        //The function will always return MediaPlayerItems.So else will not reach.
                    }

                }while(arrayLength != 0);

                if(isPlayerIdFound)
                {
                    ETG_TRACE_USR4(("SetPlayerEvent is Sent Just Now with playerId: %d",playerId));

                    ret = ParameterAVP_SET_PLAYER(OUT parameterString,
                            IN size,
                            IN playerId,
                            IN ADDRESSED_PLAYER);
                    SendEvent(AVP_SET_PLAYER,IN parameterString);
                }
                else
                {
                    ETG_TRACE_USR4(("No Browsable Player Found.So ONLY Playback of Device is Possible"));
                    if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
                    {
                        ret = UpdateDeviceVersion(AVRCP_METADATA);
                        ret = GetSupportedAttr();
                    }
                    else
                    {
                        ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_CONNECTED);
                    }
                }
                delete[] byteArrayAddress;
            }
            else
            {
                ETG_TRACE_USR4(("arrayLength is zero.But as it is 1.4 Device,It should be managed by MediaPlayer"));
                if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
                {
                    ret = UpdateDeviceVersion(AVRCP_METADATA);
                    ret = GetSupportedAttr();
                }
                else
                {
                    ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_CONNECTED);
                }
            }
        }
        else
        {
            ret = GetPlayerAttributes();
            if(SetupPlayerForBrowsing(IN mPlayerName))
            {
                ret = UpdateDeviceVersion(AVRCP_BROWSING);
            }
            else
            {
                ret = UpdateDeviceVersion(AVRCP_METADATA);
            }
            ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_CONNECTED);

            //Get Current Head unit Volume from Audio Component .
            if((LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT()) && (LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice()))
            {
                char msgToSendString[64];
                strncpy_r(OUT msgToSendString, IN "CustomControlSM::GET_VOLUME_FROM_AUDIO", IN sizeof(msgToSendString));

                ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, NULL);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
    }
    else
    {
        ETG_TRACE_USR4(("GetMediaPlayerItemReq Failed!"));
        if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported() && !LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {
            ret = UpdateDeviceVersion(AVRCP_METADATA);
            ret = GetSupportedAttr();
        }
        else
        {
            ret = UpdateDeviceVersion(AVRCP_METADATA);
            ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_CONNECTED);
        }
    }

    ETG_TRACE_USR4(("Leaving: AvpGetMediaPlayerItemMethodReturn"));
    return ret;
}
tResult BTControl::AvpSetPlayer(tPlayerId PlayerId,tPlayerMode PlayerMode)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    #if 0
    if(ADDRESSED_PLAYER == PlayerMode)
    #endif
    {
        mPlayerId =  PlayerId;
    }
    mPlayerModeCalled = PlayerMode;

    RegisterReleaseEvent(AVP_SET_PLAYER_METHOD_RETURN);
    ret = BTDaemonProxy::GetInstance().AvpSetPlayer(IN mPlayerId,IN PlayerMode);
    if(ret != MP_NO_ERROR)
    {
        ETG_TRACE_USR3(("Error in Posting AvpSetPlayer method Request in DBus"));

        //mConnectedDeviceInfo.connected is TRUE only when the Browsed Player Setup done as a result of Addressed Player Changed
        if(!mConnectedDeviceInfo.connected)
        {
            ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_ATTACHED);
        }
    }
    return ret;
}

tResult BTControl::AvpSetPlayerMethodReturn(tBTMethodRequestStatus Status,
                                            tNumOfItems NumOfItems,
                                            tDBAware DBAware,
                                            tErrorMessage ErrorMessage)
{
    ENTRY
    (void)DBAware;
    (void)ErrorMessage;

    tResult ret = MP_NO_ERROR;

    if (!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {


    tAllParameters parameterString = "";
    size_t size = sizeof(parameterString);



    //Parameter to get Capabilities
    //tCapabilityId CapabilityId = EVENTS_SUPPORTED;

    if(REQ_OK == Status)
    {
        if(BROWSED_PLAYER == mPlayerModeCalled)
        {
            mCurBrowsedPthItemCnt = NumOfItems;

            /*Enable the below one if any issue observed during testing of  AVRCP 1.4 Devices for issue related to
              notification/Shuffle/Repeat*/
            if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
            {
                ret = GetSupportedAttr();
            }
            else
            {
                //mConnectedDeviceInfo.connected is TRUE only when the Browsed Player Setup done as a result of Addressed Player Changed
                if(!mConnectedDeviceInfo.connected)
                {
                    ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_CONNECTED);
                }
            }
        }
        else
        {
            ret = ParameterAVP_SET_PLAYER(  OUT parameterString,
                                            IN size,
                                            IN mPlayerId,
                                            IN BROWSED_PLAYER);
            if (MP_NO_ERROR != ret)
            {
                 ETG_TRACE_ERR(("Error while preparing parameter string"));
            }
            else
            {
                ret = SendEvent(AVP_SET_PLAYER,IN parameterString);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                }
            }
        }
    }
    else
    {
        ETG_TRACE_USR4(("AvpSetPlayerReq Failed!"));
        mCurBrowsedPthItemCnt = 0;

        /*Enable the below one if any issue observed during testing of  AVRCP 1.4 Devices for issue related to
          notification/Shuffle/Repeat*/
        if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
        {
            ret = GetSupportedAttr();
        }
        else
        {
            //mConnectedDeviceInfo.connected is TRUE only when the Browsed Player Setup done as a result of Addressed Player Change
            if(!mConnectedDeviceInfo.connected)
            {
                ETG_TRACE_USR4(("AvpSetPlayerReq Failed!.But as it is 1.4 Device,It should be managed by MediaPlayer.Hence Making it to connected"));
                ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_CONNECTED);
            }
            else
            {
                ret = BTDaemonProxy::GetInstance().AvpListVal(ALPS_ATTR_SHUFFEL);
            }
        }
    }

    }
    else
    {
        ret=GetSupportedAttr();
        if(ret!=MP_NO_ERROR)
        {
            ETG_TRACE_ERR(("Error GetSupportedAttr Failed"));
        }
        if(!mConnectedDeviceInfo.connected)
        {
            ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_CONNECTED);
        }
    }
    return ret;
}
tResult BTControl::AvpGetCapabilitiesMethodReturn(tBTMethodRequestStatus Status,tCapabilityId CapabilityId,tEventsSupported EventsSupported,tErrorMessage ErrorMessage)
{
    ENTRY
    (void)CapabilityId;
    (void)ErrorMessage;

    tResult ret  = MP_NO_ERROR;
    (void)ret;

    //tEventsSupported EventId = 0;

    if(REQ_OK == Status)
    {
        mEventsSupported = EventsSupported;
        ETG_TRACE_USR4(("EventsSupported is %d",mEventsSupported));
        #if 0
        EventId |= ALPS_EVENT_PLAYBACK_STATUS_CHANGED;
        EventId |= ALPS_EVENT_TRACK_CHANGED;
        EventId |= ALPS_EVENT_PLAYBACK_POS_CHANGED;
        EventId |= ALPS_EVENT_PLAYER_APPLICATION_SETTING_CHANGED;

        BTDaemonProxy::GetInstance().AvpConfigNotify(IN EventId);
        #endif
    }
    else
    {
        ETG_TRACE_USR4(("AvpGetCapabilitiesReq Status:REQ_NOT_OK!.But as it should be managed by MediaPlayer.Hence Making it to connected"));
    }

    //mConnectedDeviceInfo.connected is TRUE only when the Browsed Player Setup done as a result of Addressed Player Changed
    if(!mConnectedDeviceInfo.connected)
    {
    ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_CONNECTED);
    }

    return MP_NO_ERROR;
}

// private
tResult BTControl::SendPlaybackStatus(const tPEPlaybackState status)
{
    ENTRY;
    ETG_TRACE_USR3(("BTControl::SendPlaybackStatus()"));
    VARTRACE(status);

    tResult ret = MP_NO_ERROR;
    tMetadata metadata1 = {0};
    tMetadata metadata2 = {0};
    tMetadata metadata3 = {0};
    tMetadata metadata4 = {0};

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    //The invalid state due to remote activity should not be stored internally as it is dummy state and will not be updated to HMI
    if(PE_PBS_LOADINGSTATEFORREMOTEACTIVITY != status)
    {
        mCurrentPlaybackState = status;
    }

    ETG_TRACE_USR1(("The Current Playback State is %d", mCurrentPlaybackState));

    if ((PE_PBS_PLAYINGSTATE == mCurrentPlaybackState) || (PE_PBS_PAUSEDSTATE == mCurrentPlaybackState) || (PE_PBS_FASTFORWARDSTATE == mCurrentPlaybackState) || (PE_PBS_FASTREVERSESTATE == mCurrentPlaybackState) || (PE_PBS_SEEKTOSTATE == mCurrentPlaybackState))
    {
        BTDaemonProxy::GetInstance().GetNowPlayingMetadata(OUT metadata1, OUT metadata2, OUT metadata3, OUT metadata4);
    }

    ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata2, IN metadata3, IN metadata4 ,IN m_CurrentMediaObject.objectID);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("BTControl::SendPlaybackStatus() - Error while preparing parameter string"));
        parameterString[0] = '\0';
    }
    return SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
}


tResult BTControl::Umount(const tDeviceID deviceID, const tMountPoint mountPoint) // finished: 0%
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(mountPoint);

    //NOT SUPPORTED BY BT - send an answer back to DeviceDispatcher
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    SMF::Marshal(parameterString, size - 1, "i", MP_ERR_UMOUNT_NOT_SUPPORTED);
    SendAnswer(IN parameterString);

    return MP_NO_ERROR;
}

tResult BTControl::StartAllocateAudioInput(const tDeviceID deviceID, const tMountPoint mountPoint)
{
    ENTRY;

    VARTRACE(deviceID);
    VARTRACE(mountPoint);

    tResult ret = MP_NO_ERROR;

    if(mConnectedDeviceInfo.deviceID == DEVICE_ID_NOT_SET) /*No device available*/
    {
        ETG_TRACE_ERR(("BTControl::StartAllocateAudioInput -> No device available "));

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ret = ParameterACTION_ERROR(OUT parameterString, IN size, IN REASON_DEVICE_ERROR);
        ret = SendEvent(ACTION_ERROR, parameterString);

        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending event ACTION_ERROR via SMF (ErrorCode:%s)", errorString(ret)));
        }

        return MP_NO_ERROR;
    }

    RegisterReleaseEvent(START_AUDIO_PIPE_METHOD_RETURN);

    if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        VARTRACE(mConnectedDeviceInfo.mountPoint);
        ret = BTDaemonProxy::GetInstance().StartAudioPipe(IN mConnectedDeviceInfo.mountPoint);
        if (ret != MP_NO_ERROR) {
        ETG_TRACE_ERR(("BTDaemonProxy::StartAudioPipe() failed"));
        }
    }
    else
    {
        tMountPoint deviceAddress  = {0};
        for (unsigned iter = 0; iter < 6; iter ++ )
        {
            unsigned char sum;
            sum  = 16*BTDaemonProxy::getHexInDecimal( (unsigned char)(mConnectedDeviceInfo.serialNumber[iter*2]) );
            sum += BTDaemonProxy::getHexInDecimal( (unsigned char)(mConnectedDeviceInfo.serialNumber[(iter*2)+1]) );
            deviceAddress[iter] = sum;
        }
        ret = BTDaemonProxy::GetInstance().StartAudioPipe(IN deviceAddress);
        if (ret != MP_NO_ERROR) {
        ETG_TRACE_ERR(("BTDaemonProxy::StartAudioPipe() failed"));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::StartAudioPipeMethodReturn(tPipeName PipeName,tCodecType CodecType,tBitRate BitRate,tErrorMessage ErrorMessage)
{

    ENTRY
    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);



    if(PipeName == NULL)
    {
        ret = 1;
        if(ErrorMessage != NULL)
        {
            delete[] ErrorMessage;
        }
        ret = ParameterACTION_ERROR(OUT parameterString, IN size, IN REASON_DEVICE_ERROR);
        ret = SendEvent(ACTION_ERROR, parameterString);
        return MP_NO_ERROR;

    }
    else
    {
        const char *l_PipeName =(char *)PipeName;
        strncpy_r(OUT m_AudioInputDevice,IN l_PipeName,IN sizeof(m_AudioInputDevice));
        ETG_TRACE_USR4(("PipeName is %s",PipeName));
        ETG_TRACE_USR4(("AudioInputDevice is %s",m_AudioInputDevice));
        ETG_TRACE_USR4(("CodecType is %d",CodecType));
        ETG_TRACE_USR4(("BitRate is %d",BitRate));
        ETG_TRACE_USR4(("ErrorMessage is %s",ErrorMessage));

        mCodecType = CodecType;
        mBitRate = BitRate;

        if(LocalSPM::GetDataProvider().UseMediaEngine()) { //pip2hi

            ret = SendEvent(METHOD_RETURN, IN "0");
            if(MP_NO_ERROR != ret) {
                ETG_TRACE_ERR(("iPodControl::StartAllocateAudioInput() - Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        } else {

            RegisterReleaseEvent(METHOD_RETURN);
            ret = LocalSPM::GetIPCProvider().AssignAudioInputDevice(IN this, IN m_AudioInputDevice);
            if (ret != MP_NO_ERROR)
            {
                ETG_TRACE_ERR(("BTControl::StartAllocateAudioInput() - AssignAudioInputDevice() failed"));
            }
        }

        delete[] PipeName;
        PipeName = NULL;
    }
    /* There is no need of audio pipe for IKOMBI */


    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::StartStop(const tDeviceType deviceType,const tDeviceID deviceID, const tURL URL, const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(deviceType);
    VARTRACE(deviceID);
    VARTRACE(URL);
    VARTRACE(mountPoint);

    tResult ret = MP_NO_ERROR;

    SetStateOfPlayinStartPlay(PLAY_NOT_SENT);
    //Source activity is stopped for BT Audio , so stop the play retrial timer, to avoid retrial play command to device.
    StopRetryPlayTimer();

    /*Logic:BTDaemonProxy::mBTActivePlaybackstate holds the PlaybackState of the Device,while it is the active source in HMI
     Updating it from BTControl added to overcome an error scenario described below
     Use Case:
     Pre Condition:BT was active and playback is PAUSED  source switch to FM in HMI
     Action:User Press PLAY in the Phone Device.
     Result:    1.PlaybackState Change of the Device will not be updated to mBTActivePlaybackstate(as Logic mentioned).
                2.On doing SA_OFF->SA_ON Now,mBTActivePlaybackstate will be PAUSED,Hence PLAY not send to Device -->ERROR
     */
    if(mCurrentPlaybackState == PE_PBS_PLAYINGSTATE)
    {
        BTDaemonProxy::GetInstance().SetLastActivePlaybackState(PE_PBS_PLAYINGSTATE);
    }

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::STOP", NULL, "BTControlSM::STOP_ANSWER");

    } else {

        RegisterReleaseEvent(STOP_ANSWER); //GMMY16-24734
        ret = LocalSPM::GetIPCProvider().StopSlot(this);
        if (ret != MP_NO_ERROR)
        {
            ETG_TRACE_ERR(("BTControl::StartStop - stopping PE failed"));
        }
    }


    //RegisterReleaseEvent(AVP_CTRL_CMD_METHOD_RETURN);
    /*StartStop will be invoked on Device Removal or Source Switching.
      So Avoid sending command to stack if it is on device Removal */
    if(mConnectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET)
    {
        /*GMMY17-7852:If StartStop called while FFWD/FREV in progress,then send
          Release the FFWD/FREV respectively.Follow this with PAUSE command*/
        if(PE_PBS_FASTFORWARDSTATE == mCurrentPlaybackState)
        {
            ret = BTDaemonProxy::GetInstance().AvpCtrlCmd(BT_CMD_FORWARD,BUTTON_RELEASE);
        }
        else if((PE_PBS_FASTREVERSESTATE == mCurrentPlaybackState) || mIsFastRevInProgress)
        {
            ret = BTDaemonProxy::GetInstance().AvpCtrlCmd(BT_CMD_REWIND,BUTTON_RELEASE);
            mIsFastRevInProgress = false;
        }
        //If source deallocated due to SIRI, Device will pause music. It is not required to send pause from mediaplayer in that case.
        if(!(LocalSPM::GetDataProvider().BTSourcePausedBySIRI()))
        {
        // Send pause to BT device
            if(!LocalSPM::GetIPODControl().IsActiveAsCarPlay(mConnectedDeviceInfo.deviceName))
            { //do not Pause on CarPlay activation NCG3D-15134
            ret = BTDaemonProxy::GetInstance().AvpCtrlCmd(BT_CMD_PAUSE,BUTTON_CLICK);
        }
    }
    }
    mConnectedDeviceInfo.activeSource = 0x00;
    mIsBTControlActive = false;
    BTDaemonProxy::GetInstance().UpdateBTDeviceControlState((tBoolean)false);
    ETG_TRACE_USR1(("mConnectedDeviceInfo.activeSource:%d",mConnectedDeviceInfo.activeSource));
    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}
tResult BTControl::AvpListAttrMethodReturn(tBTMethodRequestStatus Status,tAttributesBit AttributesBit,tErrorMessage Message)
{

    ENTRY

    (void)Message;
    tResult ret = MP_NO_ERROR;
    (void)ret;
    if(REQ_NOT_OK == Status || !(BITFLAG_SHUFFEL & AttributesBit))
    {

        mConnectedDeviceInfo.isShuffleSupported = false;
        const size_t size = sizeof(tAllParameters);
        char *parameterString = new char[size];
        SMF::Marshal(parameterString, size-1, tDeviceID_format tShuffleSupport_format, mConnectedDeviceInfo.deviceID, (tShuffleSupport)false);

        LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DB_CHANGE_SHUFFLE_SUPPORT, IN parameterString);
    }
    else
    {
        mConnectedDeviceInfo.isShuffleSupported = true;
        VARTRACE(mConnectedDeviceInfo.isShuffleSupported);
    }
    if(REQ_NOT_OK == Status ||  !(BITFLAG_REPEAT & AttributesBit))
    {
        mConnectedDeviceInfo.isRepeatSupported = false;
        const size_t size = sizeof(tAllParameters);
        char *parameterString = new char[size];
        SMF::Marshal(parameterString, size-1, tDeviceID_format tRepeatSupport_format, mConnectedDeviceInfo.deviceID, (tRepeatSupport)false);

        LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DB_CHANGE_REPEAT_SUPPORT, IN parameterString);
    }
    else
    {
        mConnectedDeviceInfo.isRepeatSupported = true;
        VARTRACE(mConnectedDeviceInfo.isRepeatSupported);
    }

    //If device doesn't support Repeat and shuffle,Get the supported Change Notifications
    if(!mConnectedDeviceInfo.isShuffleSupported && !mConnectedDeviceInfo.isRepeatSupported)
    {
        ret = ReqDevNotificationCapabilities();
    }
    else
    {
        if(mConnectedDeviceInfo.isShuffleSupported)
        {
            ret = GetSupportedAttrValue(ALPS_ATTR_SHUFFEL);
        }
        else if(mConnectedDeviceInfo.isRepeatSupported)
        {
            ret = GetSupportedAttrValue(ALPS_ATTR_REPEAT);
        }
    }
    return MP_NO_ERROR;
}
tResult  BTControl::AvpListValMethodReturn(tBTMethodRequestStatus Status,tBTPlayerSettingAttributeMode attributeId,tByteArray SettingValuesArray,tArrayLength ArrayLength,tCurrentValue CurrentValue,tErrorMessage Message)
{

    ENTRY
    (void)ArrayLength;
    (void)Message;
    tResult ret = MP_NO_ERROR;
    (void)ret;

    ETG_TRACE_USR4(("AvpListValMethodReturn Status:%d attributeId:%d CurrentValue:%d",Status,attributeId,CurrentValue));

        if(ALPS_ATTR_SHUFFEL == attributeId)
        {
        if(REQ_OK == Status)
        {
            tPlaybackMode playbackMode = PBM_INVALID;
            switch(CurrentValue)
            {
               case ALPS_SHUFFLE_OFF:
                   playbackMode = PBM_NORMAL;
                   break;
               case ALPS_SHUFFLE_ALL:
                    playbackMode = PBM_RANDOM;
                   break;
               case ALPS_SHUFFLE_GROUP:  //Currently BT Devices doesnt support this value.
               default:
                   break;
            }
            if(playbackMode != PBM_INVALID)
            {
                ForwardPlaybackModeStatus(playbackMode);
            }
        }
        if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
            {
            //If RepeatMode supported,get the current RepeatMode from Device
            if(mConnectedDeviceInfo.isRepeatSupported)
            {
                ret = GetSupportedAttrValue(ALPS_ATTR_REPEAT);
            }
            else
            {
                ret = ReqDevNotificationCapabilities();
            }
            }
        }
        else if(ALPS_ATTR_REPEAT == attributeId)
        {
        if(REQ_OK == Status)
        {
            tRepeatMode repeatMode = RPT_INVALID;
                switch(CurrentValue)
                {
                    case ALPS_REPEAT_OFF:
                        repeatMode = RPT_NONE;
                        break;
                    case ALPS_REPEAT_SINGLE:
                        repeatMode = RPT_ONE;
                        break;
                    case ALPS_REPEAT_ALL:
                        repeatMode = RPT_LIST;
                        break;
                    case ALPS_REPEAT_GROUP: //Currently BT Devices doesnt support this value.
                        repeatMode = RPT_LIST;
                        break;
                    default:
                    break;
                }

                if(repeatMode != RPT_INVALID)
                {
                    ForwardRepeatModeStatus(repeatMode);
                }
        }
                ret = ReqDevNotificationCapabilities();
            }

        delete[] SettingValuesArray;

    //mAttributeValueRequested = ALPS_ATTR_ERROR;
    return MP_NO_ERROR;
}
tResult  BTControl::MediaPlayerApplicationSettingsDone(tDeviceID deviceID,tConnectionState connectionState)
{

    ENTRY
    tResult ret = MP_NO_ERROR;

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    /*If the mIsDeviceVersionUpdated is true,then the Do not send DEVICE_INITIALIZED event.
    But,Update the MediaplayerDeviceConnection Property to clients (i.e here HMI)to inform about the Shuffle,Repeat and DeviceControlSupport*/
    if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported() && mIsDeviceVersionUpdated)
    {
        mIsDeviceVersionUpdated = false;
        ret = LocalSPM::GetOutputWrapper().UpdateMediaPlayerDeviceConnections();
        return MP_NO_ERROR;
    }
    ret = LocalSPM::GetIndexer().ParameterDEVICE_INITIALIZED(OUT parameterString, IN size, IN mConnectedDeviceInfo.deviceName, IN deviceID, IN connectionState);

    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter ParameterDEVICE_INITIALIZED (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }
    if(CS_CONNECTED != connectionState)
    {
        ETG_TRACE_USR3(("Device is not in CS_CONNECTED !!"));
        ClearDeviceDetails();
    }
    else
    {
        if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
        {
            //For PSA,AIVI Projects the BT Device Signals are listened from Startup by MP.
        }
        else
        {
            ret = BTDaemonProxy::GetInstance().RegisterForBTSignals();
            if(!ret)
            {
                ETG_TRACE_USR3(("BTDaemonProxy RegisterForBTSignals Successful"));
            }
            else
            {
                ETG_TRACE_USR3(("BTDaemonProxy RegisterForBTSignals failed"));
            }
        }
        mConnectedDeviceInfo.connected = true;
    }

    ret = LocalSPM::GetIndexer().SendEventByName("DEVICE_INITIALIZED", IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer DEVICE_INITIALIZED via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}
tResult  BTControl::AvpCtrlCmdMethodReturn(tBTControlCmd Command,tBTButtonEvent ButtonAction,tBTMethodRequestStatus Status,tErrorMessage ErrorMessage)
{
    ENTRY
    (void)ErrorMessage;
    (void)ButtonAction;
    tResult ret = MP_NO_ERROR;
    tPEPlaybackState playbackState;

    MapBTControlCommandToPlaybackState(OUT playbackState, IN Command);

    if(BT_CMD_PAUSE == Command && !mIsBTControlActive)
    {
        /*The Below lines commented for GMMY16-17238*/
#ifndef TARGET_BUILD
        mCurrentPlaybackState = PE_PBS_STOPPEDSTATE;
        ETG_TRACE_USR1(("mCurrentPlaybackState:%d",mCurrentPlaybackState));
#endif

        if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported() && !(mEventsSupported & ALPS_EVENT_PLAYBACK_STATUS_CHANGED))
        {
            SendPlaybackStatus(IN playbackState);
        }

        ETG_TRACE_USR4(("Invoking Stop Audio Pipe Now!"));

        ret = BTDaemonProxy::GetInstance().StopAudioPipe();
        if (ret != MP_NO_ERROR)
        {
             ETG_TRACE_ERR(("StopAudioPipe failed"));
        }
        return ret;
    }
    if(REQ_OK == Status)
    {
#ifndef TARGET_BUILD
        SendPlaybackStatus(IN playbackState);
#endif
        if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported() && !(mEventsSupported & ALPS_EVENT_PLAYBACK_STATUS_CHANGED))
        {
            SendPlaybackStatus(IN playbackState);
        }
    }
    else
    {
        ETG_TRACE_USR4(("REQ_NOT_K"));
    }

    return ret;
}
tResult BTControl::AvpNotifySetCompleteInd(tEventId EventID)
{
    ENTRY
    (void)EventID;
    tResult ret = MP_NO_ERROR;

#if 0

    tAllParameters parameterString ="";
    //size_t size = sizeof(parameterString);
    //ret = ParameterMEDIA_PLAYER_APPLICATION_SETTINGS_DONE(OUT parameterString,IN size,IN mCurBrowsedPthItemCnt);
    if (MP_NO_ERROR != ret)
    {
         ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
     else
     {
         ret = SendEvent(MEDIA_PLAYER_APPLICATION_SETTINGS_DONE,parameterString);
     }
#endif
    return ret;
}

tResult BTControl::AvpSetValMethodReturn(tBTMethodRequestStatus Status,tErrorMessage Message)
{
    ENTRY
    (void)Message;

    tResult ret = MP_NO_ERROR;
    if(REQ_OK == Status)
    {
        ret = SendAnswer((char*)NULL);
    }
    else
    {
        ETG_TRACE_USR4(("AvpSetValReq Failed!"));
    }
    return ret;
}

tResult BTControl::HandleAnswerTimeout() // finished: 100%
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Send releasing event to own waiting state machine */
    ret = ReleaseWaiting();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while releasing waiting via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult BTControl::IsInitRequired(const tDeviceInfoString deviceInfoString) // finished: 100%
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    DataProvider::UnMarshalDeviceInfo(deviceInfoString, mConnectedDeviceInfo);
    VARTRACE(mConnectedDeviceInfo);
    LocalSPM::GetDataProvider().BTSourcePausedBySIRI = 0;

    if(!LocalSPM::GetDataProvider().AVRCPLowerProfileSupported() &&(string(mConnectedDeviceInfo.deviceVersion)) == "1.3") // connected device does not support AVRCP 1.4
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetIndexer().ParameterDEVICE_INITIALIZED(OUT parameterString, IN size, IN mConnectedDeviceInfo.deviceName, IN mConnectedDeviceInfo.deviceID, IN CS_ATTACHED);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter ParameterDEVICE_INITIALIZED (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = LocalSPM::GetIndexer().SendEventByName("DEVICE_INITIALIZED", IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer DEVICE_INITIALIZED via SMF (ErrorCode:%s)", errorString(ret)));
        }

        /*we don't initialize the device which does not support AVRCP 1.4*/
        return NoInitAnswer(IN deviceInfoString); //former false case
    }
    if(mConnectedDeviceInfo.connected)
    {
        /*initialization not required if device is already in connected state*/
        return NoInitAnswer(IN deviceInfoString); //former false case
    }
    else
    {
        return SendInitInit(IN deviceInfoString); //former true case
    }
}

tResult BTControl::SendInitInit(const tDeviceInfoString deviceInfoString) // finished: 100%
{
    ENTRY
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, mConnectedDeviceInfo);
    VARTRACE(mConnectedDeviceInfo);

    /*override device specific dbus object path for Audio Visual interface of bt-daemon dbus interface*/
    string dbusObjectPath;
    if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        //dbusObjectPath = "/org/bluez/hci1/" + string(mConnectedDeviceInfo.mountPoint);
        //LocalSPM::GetIPCProvider().OverridePath(IPC_EVOLUTION_AVP_INTERFACE,dbusObjectPath.c_str());
       // LocalSPM::GetIPCProvider().OverridePath(IPC_EVOLUTION_PROPERTY_INTERFACE,dbusObjectPath.c_str());
    }
    else
    {
        dbusObjectPath = "/com/alps/bt/" + string(mConnectedDeviceInfo.mountPoint);
        LocalSPM::GetIPCProvider().OverridePath(IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE,dbusObjectPath.c_str());
    }

    if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
    {
        if((string(mConnectedDeviceInfo.deviceVersion)) == "1.4" || (string(mConnectedDeviceInfo.deviceVersion)) == "1.3")
        {
            /*Start initialization setup for the device to be initialized*/
            SendEvent(DO_MEDIA_PLAYER_APPLICATION_SETTINGS,NULL);
        }
        else
        {
            /*For AVRCP 1.0 moved to CS_CONNECTED*/
            MediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID ,CS_CONNECTED);
        }
        return MP_NO_ERROR;
    }

    /*Start initialization setup for the device to be initialized*/
    SendEvent(DO_MEDIA_PLAYER_APPLICATION_SETTINGS,NULL);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult BTControl::RemoveDeviceConnection(const tMountPoint mountPoint,
        const tDeviceID deviceID)
{
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    VARTRACE(mountPoint);
    VARTRACE(deviceID);
    tResult ret = MP_NO_ERROR;

    m_RemoteActivityDeviceID = DEVICE_ID_NOT_SET;

    /* Send releasing event to own waiting state machine */
    ret = ReleaseWaiting();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while releasing waiting via SMF (ErrorCode:%s)", errorString(ret)));
    }
    if(deviceID == mConnectedDeviceInfo.deviceID)
    {
        if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
        {
            BTDaemonProxy::GetInstance().ClearDeviceInfoflags();
        }
        else
        {
            ret = BTDaemonProxy::GetInstance().UnRegisterForBTSignals();
            if(ret)
            {
                ETG_TRACE_USR3(("UnRegisterForBTSignals failed"));
            }
        }
        /* Delete related VTBluetooth cache */

        const size_t size = sizeof(tAllParameters);
        char *parameterString = new char[size];
        SMF::Marshal(parameterString, size-1, tDeviceID_format tMountPoint_format, mConnectedDeviceInfo.deviceID, mountPoint);

        LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DELETE_VT_BLUETOOTH_CACHE, IN parameterString);

    }
    tBool isInit=false;
    ClearFlags(isInit);
    ClearDeviceDetails();
    if(mTaskVector.size() > 0)
    {
        mTaskVector.clear();
    }
    SendEvent(TASK_FINISHED,NULL);
    RemoveMessageByName("PLAYBACK_ACTION");
    sem_init(&m_TaskSyncSem, 0, 0);
    return MP_NO_ERROR;
}
tResult BTControl::AvpPlayItem(tScope Scope,tItemUID ItemUID)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {

    int itr;
    for(itr =0;itr<8;itr++)
    {
        ETG_TRACE_USR3(("ItemUID[%d] is %d",itr,ItemUID[itr]));
    }

    ETG_TRACE_USR1(("The Current Playback State is %d",mCurrentPlaybackState));
    BTDaemonProxy::GetInstance().AvpPlayItem(Scope,ItemUID);
    delete[] ItemUID;
    }
    else
    {
        LocalSPM::GetIPCProvider().OverridePath(IPC_EVOLUTION_MEDIAITEM_INTERFACE,(const char*)ItemUID);
        BTDaemonProxy::GetInstance().AvpPlayItem((tScope)0,ItemUID);
    }

    SendRemoteActivity(IN mConnectedDeviceInfo.mountPoint);

#if 0 //sada
    /*Send REMOTE_ACTIVITY to playerManager to change the Currently playing list ListType = LTY_BLUETOOTH_FILELIST and path = now-playing
    which is considered to be the to LTY_CURRENT_SELECTION of BT Device.*/
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::REMOTE_ACTIVITY", IN sizeof(messageString));

    ret = LocalSPM::GetPlayerManager().ParameterREMOTE_ACTIVITY(OUT parameterString, IN size, IN mConnectedDeviceInfo.deviceID);
    if (ret)return ret;

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (ret)return ret;
#endif
    return ret;

}

tResult BTControl::SendRemoteActivity(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ParameterREMOTE_ACTIVITY(OUT parameterString, IN size, IN mountPoint);
    SendEvent(REMOTE_ACTIVITY, IN parameterString);

    return MP_NO_ERROR;
}

tResult BTControl::RemoteActivity(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;


    m_RemoteActivityDeviceID = mConnectedDeviceInfo.deviceID; // sada need necessary checks

    /* Send REMOTE_ACTIVITY message to PlayerManger */
    char messageString[64];
    strncpy_r(messageString, "PlayerManagerSM::REMOTE_ACTIVITY", sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    LocalSPM::GetPlayerManager().ParameterREMOTE_ACTIVITY(
            OUT parameterString, IN size, IN  mConnectedDeviceInfo.deviceID);
    Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    return ret;
}
void BTControl::AvpPlayItemMethodReturn(tBTMethodRequestStatus Status)
{
    ENTRY;
    (void)Status;
#if 0
    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;

    parameterString[0] = Status;
    parameterString[1] = '\0';

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }
#endif
}

tResult BTControl::StreamingModeOn(const tDeviceType DeviceType, const tDeviceID DeviceID, const tMountPoint MountPoint)
{
    ENTRY;
    (void)DeviceType;
    (void)DeviceID;
    (void)MountPoint;
    tResult ret = MP_NO_ERROR;
    //m_RemoteActivityDeviceID = DEVICE_ID_NOT_SET
    return ret;
}

int BTControl::SetCurrentBrowsedPath(unsigned char *ReqPath)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    VARTRACE(ReqPath);
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
    unsigned int l_uiCurlevelCnt = 0;
    unsigned int l_uiBrowselevelCnt   = 0;
    unsigned int l_uiLevelDiff = 0;
    unsigned int l_uiLevelDownCnt  =0;
    unsigned int l_uiLevelUpCnt  =0;
    unsigned int found =0;
    tDirection Direction = LEVEL_CHANGE_INVALID;
    tLevelCount LevelUpCount = 0;
    tLevelCount LevelDownCount = 0;
    tItemUIDArray ItemUIDArray = NULL;
        ret = MP_NO_ERROR;
    if(GetCurrentBrowsePath()!= NULL)
    {
        ETG_TRACE_USR3(("mCurrentBrowsePath is %s",GetCurrentBrowsePath()));
    }
    ETG_TRACE_USR3(("ReqPath is %s",ReqPath));
    if(GetCurrentBrowsePath()!= NULL)
    {
        if((strlen_r((const char*)GetCurrentBrowsePath()))>1)
        {
            if(!strcmp((const char*)GetCurrentBrowsePath(),(const char*)ReqPath))
            {
                ETG_TRACE_USR3(("mCurrentBrowsePath == ReqPath."));
                return ret;
            }
            l_uiCurlevelCnt = FastUTF8::Count(GetCurrentBrowsePath(),(unsigned char *)const_cast<char*>(PATH_DELIMITER));
            l_uiBrowselevelCnt = FastUTF8::Count(ReqPath,(unsigned char *)const_cast<char*>(PATH_DELIMITER));
            if(l_uiCurlevelCnt>l_uiBrowselevelCnt)
            {
                l_uiLevelDiff = l_uiCurlevelCnt - l_uiBrowselevelCnt;
            }
            else
            {
                l_uiLevelDiff = l_uiBrowselevelCnt - l_uiCurlevelCnt;
            }
            ETG_TRACE_USR3(("l_uiCurlevelCnt of the CurrentChangePath is %d",l_uiCurlevelCnt));
            ETG_TRACE_USR3(("l_uiBrowselevelCnt of the BrowsePath is %d",l_uiBrowselevelCnt));
            ETG_TRACE_USR3(("l_uiLevelDiff is %d",l_uiLevelDiff));
            int level = l_uiCurlevelCnt + 1; //Added 1 to include the ROOT Folder
            bool l_bIsParentFound = false;
            string parent_current,parent_browsed,browsed_truncate,l_CurrentPath,l_BrowsePath,l_DownFolder;
            l_CurrentPath = string((const char*)GetCurrentBrowsePath());
            l_BrowsePath  = string((const char*)ReqPath);
            if(l_uiCurlevelCnt != l_uiBrowselevelCnt)
            {
                unsigned int TruncCount = l_uiLevelDiff;
                if(l_uiCurlevelCnt > l_uiBrowselevelCnt)
                {
                    ETG_TRACE_USR3(("l_uiCurlevelCnt > l_uiBrowselevelCnt"));
                    ETG_TRACE_USR3(("Going to Truncate the The Current Path equal to l_uiBrowselevelCnt"));

                    do
                    {
                        found = l_CurrentPath.find_last_of("/\\");
                        l_CurrentPath = l_CurrentPath.substr(0,found);
                        TruncCount --;

                    }while(TruncCount);

                    ETG_TRACE_USR3(("Truncated l_CurrentPath is %s",l_CurrentPath.c_str()));

                    //Increment the Level up Count
                    l_uiLevelUpCnt = l_uiLevelDiff;
                }
                else
                {
                    ETG_TRACE_USR3(("l_uiCurlevelCnt < l_uiBrowselevelCnt"));
                    ETG_TRACE_USR3(("Going to Truncate the The BrowsedPath equal to l_uiCurlevelCnt"));

                    do
                    {
                        found = l_BrowsePath.find_last_of("/\\");
                        l_BrowsePath = l_BrowsePath.substr(0,found);
                        TruncCount --;
                    }while(TruncCount);

                    ETG_TRACE_USR3(("Truncated l_BrowsePath is %s",l_BrowsePath.c_str()));

                    //Increment the Level Down Count
                    l_uiLevelDownCnt = l_uiLevelDiff;
                }
            }
            else
            {
                //Truncate both the Paths by one level
                found = l_CurrentPath.find_last_of("/\\");
                l_CurrentPath = l_CurrentPath.substr(0,found);


                found = l_BrowsePath.find_last_of("/\\");
                l_BrowsePath = l_BrowsePath.substr(0,found);

            }
            do
            {
                found = l_CurrentPath.find_last_of("/\\");
                parent_current = l_CurrentPath.substr(found+1);

                found = l_BrowsePath.find_last_of("/\\");
                parent_browsed = l_BrowsePath.substr(found+1);

                if(parent_current == parent_browsed)
                {
                    ETG_TRACE_USR3(("Parent Folder of current & browsed is same!"));
                    if(parent_browsed.size())
                    {
                        ETG_TRACE_USR3(("Parent is %s",parent_browsed.c_str()));
                    }
                    else
                    {
                        ETG_TRACE_USR3(("Parent is ROOT Folder"));
                    }

                    //Parent Folder is found.
                    l_bIsParentFound = true;


                    if(!l_uiLevelDiff)
                    {
                        //Increment the Levelup count
                        l_uiLevelUpCnt++;

                        //Increment the Level Down Count
                        l_uiLevelDownCnt++;
                    }
                }
                else
                {
                    ETG_TRACE_USR3(("Parent Folder of current & browsed differs!!!"));
                    ETG_TRACE_USR3(("Going to check the Next level of Parent is same"));

                    found = l_CurrentPath.find_last_of("/\\");
                    l_CurrentPath = l_CurrentPath.substr(0,found);

                    found = l_BrowsePath.find_last_of("/\\");
                    l_BrowsePath = l_BrowsePath.substr(0,found);

                    //Increment the Levelup count
                    l_uiLevelUpCnt++;

                    //Increment the Level Down Count
                    l_uiLevelDownCnt++;
                }

                //Decrement Level as one level is checked
                level--;

                ETG_TRACE_USR3(("l_uiLevelUpCnt is %d",l_uiLevelUpCnt));
                ETG_TRACE_USR3(("l_uiLevelDownCnt is %d",l_uiLevelDownCnt));

                ETG_TRACE_USR3(("level is %d",level));

            }while((!l_bIsParentFound) && level);

            ETG_TRACE_USR3(("Total Number of Level_up Need to be done is %d",l_uiLevelUpCnt));
            ETG_TRACE_USR3(("Total Number of Level_down Need to be done is %d",l_uiLevelDownCnt));


            ETG_TRACE_USR3(("Going to Retrieve the UID of the Folders to Do Level Down"));

            // thoemel: replaced with following line because of a valgrind finding at teh delete[] ItemUIDArray = new unsigned char[l_uiLevelDownCnt*SIZE_OF_ITEM_UID];
            ItemUIDArray = (tItemUIDArray) malloc(l_uiLevelDownCnt*SIZE_OF_ITEM_UID);

            if(ItemUIDArray!= NULL)
            {
                tBoolean isFolderUIDRetrieved = BTGetFolderUID(ReqPath,l_uiLevelDownCnt,ItemUIDArray);

                if(!isFolderUIDRetrieved)
                {
                    return MP_ERR_SM_GENERAL_ERROR;
                }
                LevelUpCount = l_uiLevelUpCnt;
                LevelDownCount = l_uiLevelDownCnt;

                if(LevelUpCount)
                {
                    Direction = FOLDER_UP;
                }
                else
                {
                    Direction = FOLDER_DOWN;
                }

                ret = DoChangePath(Direction,LevelUpCount,LevelDownCount,ItemUIDArray);
            }
            else
            {
                ETG_TRACE_USR3(("ItemUIDArray is NULL"));
                return MP_ERR_SM_GENERAL_ERROR;
            }
        }
        else if((strlen_r((const char*)GetCurrentBrowsePath())) == 1)
        {
            ETG_TRACE_USR3(("We are trying to Enter a folder a Level down from being in ROOT Folder..."));

            l_uiLevelDownCnt =1;

            ETG_TRACE_USR3(("Going to Retrieve the UID of the Folders to Do Level Down"));

            // thoemel: replaced with following line because of a valgrind finding at teh delete[] ItemUIDArray = new unsigned char[SIZE_OF_ITEM_UID];
            ItemUIDArray = (tItemUIDArray)malloc(SIZE_OF_ITEM_UID);

            if(ItemUIDArray!= NULL)
            {
                tBoolean isFolderUIDRetrieved = BTGetFolderUID(ReqPath,l_uiLevelDownCnt,ItemUIDArray);
                if(!isFolderUIDRetrieved)
                {
                    return MP_ERR_SM_GENERAL_ERROR;
                }

                Direction = FOLDER_DOWN;
                LevelUpCount = l_uiLevelUpCnt;
                LevelDownCount = l_uiLevelDownCnt;

                ret = DoChangePath(Direction,LevelUpCount,LevelDownCount,ItemUIDArray);
            }
            else
            {
                ETG_TRACE_USR3(("ItemUIDArray is NULL"));
                return MP_ERR_SM_GENERAL_ERROR;
            }
        }
    }
    else if(string((const char*)ReqPath) == PATH_DELIMITER)
    {
        ETG_TRACE_USR3(("mCurrentBrowsePath is empty.SetCurrentBrowsedPath is Called for a ROOT Folder"));
        if(mCurBrowsedPthItemCnt)
        {
        ETG_TRACE_USR3(("It should Have already Set to ROOT Folder!So Going to ROOT Folder Item Count."));

        Direction = LEVEL_CHANGE_NOT_NEEDED;

        ret = DoChangePath(Direction,LevelUpCount,LevelDownCount,ItemUIDArray);
    }
        else
        {
            ETG_TRACE_USR3(("mCurBrowsedPthItemCnt is 0.User would have Browsed on a Non-Browsable AVRCP 1.4 Device"));
            ret = MP_ERR_SM_GENERAL_ERROR;
        }
    }
    else
    {
        ETG_TRACE_USR3(("mCurrentBrowsePath is empty.But ReqPath is not a ROOT Path"));
        ret = MP_ERR_SM_GENERAL_ERROR;
    }
    if(MP_NO_ERROR == ret)
    {
        ETG_TRACE_USR3(("DoChangePath Successful"));
    }
    else
    {
        ETG_TRACE_USR3(("DoChangePath Failed"));
    }
    }else
    {
        ret = DoChangePath(LEVEL_CHANGE_INVALID,0,0,(unsigned char*)ReqPath);
    }
    return ret;
}

int BTControl::findFolderPathToMove(char *requestPath, string &PathToMove)
{
    ENTRY;
    VARTRACE(requestPath);
    if (!strcmp((char*) requestPath, "/") && GetCurrentBrowsePath() == NULL)
    {
        PathToMove.append("/");
        ETG_TRACE_USR3(("findFolderPathToMove assume this will come for very first time"));
        return MP_NO_ERROR;


    }
    else if(!strcmp((char*) requestPath, "/NowPlaying") && GetCurrentBrowsePath() == NULL)
    {
        PathToMove.append("/NowPlaying");
        ETG_TRACE_USR3(("findFolderPathToMove : /NowPlaying"));
        return MP_NO_ERROR;
    }
    if (GetCurrentBrowsePath() != NULL)
    {
        string strRequestPath(requestPath);
        string strCurrentPath((char*) GetCurrentBrowsePath());

        if (strRequestPath == strCurrentPath)
        {

            ETG_TRACE_USR3(("findFolderPathToMove DoChangePath current path request path are same"));
            PathToMove = strRequestPath;

        }
        else if (!strRequestPath.find(strCurrentPath.c_str())) // check strRequestPath contains strCurrentPath
        {
            /* Example:
             requestPath:/My Music/Genere/Artist/Albums
             currentPath:/My Music/Genere
             `   */
            string item;
            if (strCurrentPath == "/")
            {
                /* strCurrentPath: /  strRequestPath:/Playlist result:Playlist*/
                item = strRequestPath.substr(strlen_r(PATH_DELIMITER), strRequestPath.size());
            }
            else
            {
                //strRequestPath - strCurrentPath result:/Artist/Albums
                // +1 is added to avoid  copying the fist / as result : Artist/Albums
                item = strRequestPath.substr(strlen_r(strCurrentPath.c_str()) + 1, strRequestPath.size());
            }
            //getting item to move forward result:Artist
            int index = item.find("/");
            item = item.substr(0, index);
            //Populating item to move forward result:/My Music/Genere/Artist
            string movePath = strCurrentPath;
            if (!(movePath == "/"))
            {
                movePath.append("/");
            }
            movePath.append(item.c_str());
            PathToMove = movePath;
            ETG_TRACE_USR3(("move back item :%s",movePath.c_str()));

        }
        else
        {

            /* Example:
             currentPath:/My Music/Genere/Artist/Albums
             requestPath:/playlist
             `   */
            //Populating item to move backward result:/My Music/Genere/Artist
            int found = strCurrentPath.find_last_of("/");
            string item = strCurrentPath.substr(0, found);

            if (item.size() == 0)
            {
                item.append("/");
            }
            ETG_TRACE_USR3(("move back item :%s",item.c_str()));
            PathToMove = item;
        }
    }
    else
    {
        ETG_TRACE_USR3(("Error: mCurrentBrowsePath is null"));
    }
    return MP_NO_ERROR;
}

int BTControl::DoChangePath(tDirection Direction,tLevelCount LevelUpCount,
                tLevelCount LevelDownCount,
                tItemUIDArray ItemUIDArray)
{

    ENTRY;

    tResult ret = MP_NO_ERROR;

    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
    int iter;
    tItemUID ItemUID  = NULL;

    ETG_TRACE_USR3(("Direction:%d",Direction));
    ETG_TRACE_USR3(("LevelUpCount:%d",LevelUpCount));
    ETG_TRACE_USR3(("LevelDownCount:%d",LevelDownCount));


    if(LEVEL_CHANGE_NOT_NEEDED == Direction)
    {
        RegisterReleaseEvent(AVP_CHANGE_PATH_METHOD_RETURN);

        mDirectionRequested = Direction;
        /* Send releasing event to own waiting state machine */
        ret = ReleaseWaiting();

        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while releasing waiting via SMF (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            //Release event successfull
        }
    }
    else
    {
        //Copying to the Private Member variables
        if(mIsStoreInfoNeeded)
        {
            ETG_TRACE_USR3(("DoChangePath Called from Outside the Class!So Store Info!"));
            mLevelUpCount = LevelUpCount ;
            mLevelDownCount = LevelDownCount;
            mUIDArray = ItemUIDArray;
            mUIDArray_Address = ItemUIDArray;

            mIsStoreInfoNeeded = false;

        }
        mDirectionRequested = Direction;

        if(mLevelUpCount>0)
        {
            #if 0
            for(iter=0;iter<8;iter++)
            {
                ItemUID[iter] = 0;
            }
            #endif
            ETG_TRACE_USR3(("%d Level-up Needed !",mLevelUpCount));
        }

        else if(mLevelDownCount > 0)
        {
            ETG_TRACE_USR3(("%d Level-Down Needed !",mLevelDownCount));
            // TODO: here is a valgrind finding: This memcpy reads from memory that is never written because it reads SIZE_OF_ITEM_UID bytes but the source adress points to less than 8 bytes:
            /*
==24807==    at 0x439894B: memmove (Utils.cpp:90)
==24807==    by 0x43988C9: memcpy (Utils.cpp:61)
==24807==    by 0x8544EB7: BTControl::DoChangePath(tDirection, unsigned int, unsigned int, unsigned char*) (BTControl.cpp:2111)
==24807==    by 0x8542CAD: BTControl::SetCurrentBrowsedPath(unsigned char*) (BTControl.cpp:2007)
==24807==    by 0x852EB03: BTControl::AvpChangePath(tDirection, unsigned int, unsigned int, unsigned char*) (BTControl.cpp:817)
==24807==    by 0x81881B2: BTControlSM::AvpChangePathCall(void*) (BTControlSM.h:1039)
==24807==    by 0x438BF41: SMF::DoTransition(SMF::tTransition*) (SMF.cpp:873)
==24807==    by 0x438E9B0: SMF::NextEventProcess(char*, char*) (SMF.cpp:1605)
==24807==    by 0x438F92A: SMF::CheckForInternalMessage() (SMF.cpp:1868)
==24807==    by 0x438F332: SMF::StateMachine_Main() (SMF.cpp:1770)
==24807==    by 0x85267CA: BTControl::Do(int, void*) (BTControl.cpp:97)
==24807==    by 0x4395EAE: ThreadFactory::startFunction(void*) (ThreadFactory.cpp:129)
             */

            ItemUID = new unsigned char[SIZE_OF_ITEM_UID];
            if(ItemUID)
            {
                memset(ItemUID,0,SIZE_OF_ITEM_UID);
                memcpy(ItemUID,mUIDArray,SIZE_OF_ITEM_UID);
                for(iter =0;iter<8;iter++)
                {
                    ETG_TRACE_USR3(("UID[%d] :%d",iter,ItemUID[iter]));
                }
            }
        }

        RegisterReleaseEvent(AVP_CHANGE_PATH_METHOD_RETURN);
        ret = BTDaemonProxy::GetInstance().AvpChangePath(IN Direction,IN ItemUID);
    }
    if(ItemUID) delete[] ItemUID;
    }
    else
    {
        if(((GetCurrentBrowsePath() == NULL) || !strcmp((const char*)GetCurrentBrowsePath(),PATH_DELIMITER)) && !strcmp((char*) ItemUIDArray,PATH_DELIMITER))
        {
            ETG_TRACE_USR3(("New Device has been connected so default it will be in root folder"));
            ret = BTDaemonProxy::GetInstance().AvpGetNumberOfItemsInCurrentFolder();

        }
        else
        {

            string pathToMove;

            findFolderPathToMove((char*) ItemUIDArray, pathToMove);
            ETG_TRACE_USR3(("DoChangePath PathToMove:%s",pathToMove.c_str()));
            string ObjectPath;

            if(GetCurrentBrowsePath() == NULL || pathToMove.compare((const char *)GetCurrentBrowsePath()) != 0)
            {
                if (pathToMove == "/")
                {
                    if(!mPlayerName.empty())
                    {
                        ObjectPath = mPlayerName + "/Filesystem";
                    }
                    else
                    {
                        ETG_TRACE_USR3(("DoChangePath PlayerName is empty"));
                    }
                }
                else if("/NowPlaying" == pathToMove)
                {
                    if(!mPlayerName.empty())
                    {
                        ObjectPath = mPlayerName + "/NowPlaying";
                        ETG_TRACE_USR3(("DoChangePath Objectpath :%s",ObjectPath.c_str()));
                    }
                    else
                    {
                        ETG_TRACE_USR3(("DoChangePath PlayerName is empty"));
                    }

                }
                else
                {
                    BTGetItemObjectPath(pathToMove, ObjectPath);
                }

                if (ObjectPath.size())
                {
                    SetCurrentReqPathForChange(pathToMove.c_str());
                    ret = BTDaemonProxy::GetInstance().AvpChangePath(IN LEVEL_CHANGE_INVALID, IN (unsigned char*) ObjectPath.c_str(),IN false,IN mPlayerName);
                }
                else
                {
                    ETG_TRACE_USR3(("Error: Couldn't Find the Object Path"));
                    ret = MP_ERR_BT_BROWSE_FAILED;
                }
            }
            else
            {
                    if("/NowPlaying" == pathToMove) // removed the condition to check evolution stack, as this part would be entered aready only if it is evolution stack.
                    {
                        tAllParameters parameterString="";
                        size_t size = sizeof(parameterString);
                        tBTMethodRequestStatus status = REQ_OK;
                        tNumOfItems numOfItems = 0 ;
                        tErrorMessage errorMessage = NULL;
                        ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN errorMessage,IN pathToMove.c_str());
                        SendEvent(AVP_CHANGE_PATH_METHOD_RETURN,parameterString);
                        return ret;
                    }
                SendEvent(AVP_CHANGE_PATH_METHOD_RETURN,NULL);
            }
        }
    }
    return ret;
}
void BTControl::DoPlayItemFromBrowse()
{
    ENTRY;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        setIsPlayItemFromBrowseNeeded(false);
        ETG_TRACE_USR3(("mPlayItemUID is %s",mPlayItemUID));
        tItemUID ItemUID = NULL;
        tScope Scope = SCOPE_MP_VFS;
        ItemUID = new unsigned char[SIZE_OF_ITEM_UID];
        if(ItemUID != NULL && strlen_r(mPlayItemUID) == (SIZE_OF_ITEM_UID*2))
        {
            unsigned int iter,value;
            for(iter=0;iter<SIZE_OF_ITEM_UID;iter++)
            {
                sscanf(mPlayItemUID+2*iter,"%2X",&value);
                ItemUID[iter] = (unsigned char)value;
                ETG_TRACE_USR3(("ItemUID[%d] is %d",iter,ItemUID[iter]));
            }

            AvpPlayItem(Scope,ItemUID);
        }
        //if(ItemUID) delete[] ItemUID;
    }
    else
    {
        string objectPath;
        string path=mSelectedItemParentPath;
        int item_pos=-1;
        path.append("/");
        path.append(mSelectedItemName);


        if(mIsRequestListItemNeeded)
        {
            mIsRequestListItemNeeded=false;

            if(BTGetPosItemInFolder(path,item_pos))
            {

                tAllParameters parameterString;
                size_t size = sizeof(parameterString);
                tScope scope=SCOPE_INVALID;
                tStartItem start=item_pos;
                tEndItem end=item_pos;
                tResult ret = MP_NO_ERROR;
                ret=ParameterAVP_GET_FOLDER_ITEM(OUT parameterString,IN size,IN scope,IN start,IN end);
                if(ret==MP_NO_ERROR)
                {
                    ret=SendEvent(AVP_GET_FOLDER_ITEM,parameterString);
                    if(ret!=MP_NO_ERROR)
                    {
                        ETG_TRACE_ERR(("SendEvent Failed"));
                    }
                }

            }

        }
        else
        {
            setIsPlayItemFromBrowseNeeded(false);
            if(BTGetItemObjectPath(path,objectPath))
            {
                AvpPlayItem(SCOPE_INVALID,(unsigned char*)objectPath.c_str());
            }

        }

    }
   mCurrentReqPath = "";
   setIsAvpChangePathFromStartPlay(false); // Only here IsAvpChangePathFromStartPlay is cleared independent of IsPlayItemFromBrowseNeeded
} //lint !e429  To suprress LintWarning 429 as the Custodial pointer 'ItemUID' will be freed by BTControl::AvpPlayItem
void BTControl::ClearFlags(tBool isInit)
{
    ENTRY;

    ClearBrowseInfoFlags(isInit);

    //mItemUID = NULL;
    //mScope = SCOPE_INVALID

    mCurrentPlaybackState = PE_PBS_STOPPEDSTATE;
    NowPlayingListID = LIST_ID_NONE;
    //mIsBTControlActive = false;
    mEventsSupported = 0;
    mBitRate = 0;
    mCodecType = CODEC_TYPE_INVALID;
    m_AudioInputDevice[0] = '\0';
    mHandle = HANDLE_NONE;
    mIsBTControlActive = false;
    mIsDeviceVersionUpdated = false;
    mIsFastRevInProgress = false;
    ClearRemoteActivityFlags();
    ClearSiriSessionFlags();
    mPlayerName = "";
    mNowplayingListAvilable = false;
}
void BTControl::ClearDeviceDetails()
{
    ENTRY
    InitDeviceInfo(mConnectedDeviceInfo);
    InitMediaObject(m_CurrentMediaObject);

    if(LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt())
    {
        ClearCoverArtInfo();
        DeleteCurrentAlbumart();
    }
}
void BTControl::ForwardPlaybackModeStatus(tPlaybackMode playbackMode)
{
    ENTRY
    VARTRACE(playbackMode);
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_MODE_STATUS", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    LocalSPM::GetPlayerManager().ParameterPLAYBACK_MODE_STATUS( OUT parameterString, IN size, IN mConnectedDeviceInfo.deviceID, IN playbackMode);
    Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
}

tBoolean BTControl::IsBatchPlayable(const tDeviceID deviceID)
{
    ENTRY;
    VARTRACE(deviceID);
    return 0;
}

tDeviceInfo BTControl::GetConnectedDeviceInfo()
{
    ENTRY;
    return mConnectedDeviceInfo;
}
void BTControl::ForwardRepeatModeStatus(tRepeatMode repeatMode)
{
    ENTRY
    VARTRACE(repeatMode);
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::REPEAT_MODE_STATUS", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    LocalSPM::GetPlayerManager().ParameterREPEAT_MODE_STATUS( OUT parameterString, IN size, IN mConnectedDeviceInfo.deviceID, IN repeatMode);
    Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
}
tResult BTControl::MapBTControlCommandToPlaybackState(tPEPlaybackState &playbackState, const tBTControlCmd command)
{
    ENTRY

    switch(command)
    {
        case BT_CMD_PLAY:
        case BT_CMD_NEXTTRACK:
        case BT_CMD_PREVTRACK:
        case BT_CMD_MEDIARESUME:
            playbackState = PE_PBS_PLAYINGSTATE;
            break;
        case BT_CMD_PAUSE:
        case BT_CMD_MEDIASUSPEND:
            playbackState = PE_PBS_PAUSEDSTATE;
            break;
        case BT_CMD_STOP:
            playbackState = PE_PBS_STOPPEDSTATE;
            break;
        case BT_CMD_FORWARD:
            playbackState = PE_PBS_FASTFORWARDSTATE;
            break;
        case BT_CMD_REWIND:
            playbackState = PE_PBS_FASTREVERSESTATE;
            break;
        case BT_CMD_UNUSED:
        case BT_CMD_RESERVED1:
        case BT_CMD_RESERVED2:
        default:
            playbackState = PE_PBS_LOADINGSTATE;
            break;
    }
    return MP_NO_ERROR;
}
tResult BTControl::SendMediaPlayerApplicationSettingsDone(tDeviceID deviceID,tConnectionState connectionState)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterMEDIA_PLAYER_APPLICATION_SETTINGS_DONE(OUT parameterString,IN size,IN deviceID,IN connectionState);

    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = SendEvent(MEDIA_PLAYER_APPLICATION_SETTINGS_DONE,parameterString);
    }
    return MP_NO_ERROR;
}
tResult BTControl::GetSupportedAttr()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    ret = BTDaemonProxy::GetInstance().AvpListAttr();
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_USR3(("Posting AvpListAttr Req Failed!"));

        //mConnectedDeviceInfo.connected is TRUE only when the Browsed Player Setup done as a result of Addressed Player Changed
        if(!mConnectedDeviceInfo.connected)
        {
        SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_ATTACHED);
        }
    }
    }
    return ret;
}
tResult BTControl::GetSupportedAttrValue(const tBTPlayerSettingAttributeMode &attributeId)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    ret = BTDaemonProxy::GetInstance().AvpListVal(attributeId);

    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_USR3(("Posting AvpListVal Req Failed!"));

        //mConnectedDeviceInfo.connected is TRUE only when the Browsed Player Setup done as a result of Addressed Player Changed
        if(!mConnectedDeviceInfo.connected)
        {
        SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_ATTACHED);
        }
    }
    return ret;
}
tResult BTControl::ReqDevNotificationCapabilities()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        ret = BTDaemonProxy::GetInstance().AvpGetCapabilities(IN tCapabilityId(EVENTS_SUPPORTED));
    }
    else
    {
        ret = SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_CONNECTED);
    }
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_USR3(("Posting AvpGetCapabilities Req Failed!"));

        //mConnectedDeviceInfo.connected is TRUE only when the Browsed Player Setup done as a result of Addressed Player Changed
        if(!mConnectedDeviceInfo.connected)
        {
            SendMediaPlayerApplicationSettingsDone(mConnectedDeviceInfo.deviceID,CS_ATTACHED);
        }
    }
    return ret;
}
tResult BTControl::DoDBChangeShuffleSupport(char *parameterStr)
{
    ENTRY;
    VARTRACE(parameterStr)

    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tShuffleSupport shuffleSupport = tShuffleSupport_init;

    SMF::UnMarshal(parameterStr, tDeviceID_format tShuffleSupport_format, &deviceID, &shuffleSupport);
    if (parameterStr) {
        delete[] parameterStr;
    }

    LocalSPM::GetDBManager().UpdateShuffleSupport(IN deviceID, IN shuffleSupport);

    return MP_NO_ERROR;
}
tResult BTControl::DoDBChangeDeviceVersion(char *parameterStr)
{
    ENTRY;
    VARTRACE(parameterStr)

    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tDeviceVersion deviceVersion;
    memset(deviceVersion,0,sizeof(deviceVersion));

    if (parameterStr)
    {
        SMF::UnMarshal(parameterStr, tDeviceID_format tDeviceVersion_format , &deviceID, deviceVersion);
        delete[] parameterStr;

        ETG_TRACE_USR4(("deviceID:%d deviceVersion:%s",deviceID,deviceVersion));
        LocalSPM::GetDBManager().UpdateDeviceVersion(IN deviceID, IN deviceVersion);
    }
    return MP_NO_ERROR;
}
tResult BTControl::DoDBChangeRepeatSupport(char *parameterStr)
{
    ENTRY;
    VARTRACE(parameterStr)

    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tRepeatSupport repeatSupport = tRepeatSupport_init;

    SMF::UnMarshal(parameterStr, tDeviceID_format tRepeatSupport_format, &deviceID, &repeatSupport);
    if (parameterStr) {
        delete[] parameterStr;
    }

    LocalSPM::GetDBManager().UpdateRepeatSupport(IN deviceID, IN repeatSupport);

    return MP_NO_ERROR;
}

tResult BTControl::DoDBChangeNowPlayingListSupport(char *parameterStr)
{
    ENTRY;
    VARTRACE(parameterStr)

    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tNowPlayingListAvailable nowPlayingListSupport = tNowPlayingListAvailable_init;

    SMF::UnMarshal(parameterStr, tDeviceID_format tRepeatSupport_format, &deviceID, &nowPlayingListSupport);
    if (parameterStr) {
        delete[] parameterStr;
    }
    VARTRACE(nowPlayingListSupport);
    LocalSPM::GetDBManager().UpdateNowPlayingListAvailable(IN deviceID, IN nowPlayingListSupport);

    return MP_NO_ERROR;
}

tResult BTControl::DoDeleteVTBluetoothCache(char *parameterStr)
{
    ENTRY;
    VARTRACE(parameterStr)
    tResult ret = MP_NO_ERROR;

    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tMountPoint mountPoint = {0};

    SMF::UnMarshal(parameterStr, tDeviceID_format tMountPoint_format ,&deviceID, &mountPoint);
    if (parameterStr) {
        delete[] parameterStr;
    }

    ret = LocalSPM::GetDBManager().DeleteVTBluetoothCache(IN mountPoint);

    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while deleting VTBluetooth cache for deviceID:%u (ErrorCode:%s)", deviceID, errorString(ret)));
    }

    return ret;
}
tResult BTControl::AvpChangeBrowsedPlayer(const tPlayerName playerName)
{
    ENTRY;

    tResult ret = MP_NO_ERROR;
    SetCurrentPlayer(playerName);
    if(mConnectedDeviceInfo.connected)
    {
        BTDaemonProxy::GetInstance().setPlayerObjectPath(playerName);
        BTDaemonProxy::GetInstance().OverrideEvoObjectPaths(playerName);
        /* Delete related VTBluetooth cache */

        const size_t size = sizeof(tAllParameters);
        char *parameterString = new char[size];
        SMF::Marshal(parameterString, size-1, tDeviceID_format tMountPoint_format, mConnectedDeviceInfo.deviceID, mConnectedDeviceInfo.mountPoint);

        LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DELETE_VT_BLUETOOTH_CACHE, IN parameterString);

        if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {

            //Set the BrowsePath to ROOT in the player being browsed till now
            if((GetCurrentBrowsePath() != NULL) && (strcmp((const char*)GetCurrentBrowsePath(),PATH_DELIMITER)))
            {
                unsigned int numOfLevelUpNeeded = 0;
                numOfLevelUpNeeded = FastUTF8::Count(GetCurrentBrowsePath(),(unsigned char *)const_cast<char*>(PATH_DELIMITER));
                ETG_TRACE_USR4(("No.of Level-up to set to ROOT Path in Ealier Addressed Player:%d",numOfLevelUpNeeded));

                if(numOfLevelUpNeeded)
                {
                    BTDaemonProxy::GetInstance().ResetBrowsePathToRoot(IN numOfLevelUpNeeded);
                }
            }
        }
        //Clear all Browse Related Informations
        tBool isInit = false;
        ClearBrowseInfoFlags(isInit);

        ret = GetPlayerAttributes();

        tBTMethodRequestStatus status = REQ_NOT_OK;
        ret = BTDaemonProxy::GetInstance().GetSupportedAvpNotifications(IN tCapabilityId(EVENTS_SUPPORTED),OUT status,OUT mEventsSupported);


        //Set the Newly Addressed Player(i.e Currently playing player in the Phone Device) as the Browse Player
        if(SetupPlayerForBrowsing(IN playerName))
        {
            ret = UpdateDeviceVersion(AVRCP_BROWSING);
        }
        else
        {
            ret = UpdateDeviceVersion(AVRCP_METADATA);
        }
    }

    if(mIsBTControlActive)
    {
        ret = BTDaemonProxy::GetInstance().RequestMetadata(); //NCG3D-121182
    }
    ret = SendEvent(AVP_BROWSE_PLAYER_CHANGE_DONE,NULL);

    //Remove From the External Queue of the BTControlSM
    RemoveMessageByName("AVP_CHANGE_PATH");
    RemoveMessageByName("AVP_GET_FOLDER_ITEM");
    //When a player changes for the BT device which is active ,and the playback is not playing state , Mediaplayer should trigger play to start playback for the new player.
    //This solves the error , where during device connection player changes from invalid to valid player and in between the transition if play is missed , it will be sent for the valid player  : NCG3D-95970 .
    if(mIsBTControlActive)
    {
        tPEPlaybackState NowPlayingStatus = BTDaemonProxy::GetInstance().GetNowPlayingStatus();
        VARTRACE(NowPlayingStatus);
        if(PE_PBS_PLAYINGSTATE != NowPlayingStatus)
        {
            tPlaybackAction playbackAction = PBA_PLAY;
            SendPlaybackActionToBTControl(playbackAction);
        }
    }
    return ret;
}
void BTControl::ClearBrowseInfoFlags(tBool isInit)
{
    ENTRY;
    mIsStoreInfoNeeded = true;
    mCurBrowsedPthItemCnt = 0;
    if(true == isInit)
    {
        mCurrentBrowsePath = NULL;
        mUIDArray_Address = NULL;
    }

    if(GetCurrentBrowsePath() != NULL)
    {
        ClearCurrentBrowsePath();
    }
    mCurrentReqPathForChange = "";
    mCurrentReqPath = "";
    mSelectedItemParentPath = "";
    mSelectedItemName= "";
    mLevelUpCount = 0;
    mLevelDownCount = 0;
    if(mUIDArray_Address!= NULL)
    {
        free(mUIDArray_Address);
        mUIDArray_Address = NULL;
    }

    setIsPlayItemFromBrowseNeeded(false);
    mDirectionRequested = LEVEL_CHANGE_INVALID;
    memset(mPlayItemUID,0,sizeof(mPlayItemUID));

    mUIDArray = NULL;
    mPlayerModeCalled = INVALID_PLAYER_MODE;
    mPlayerId = 0;

    //TODO:Set Proper Invalid value
    mPlaybackModeRequested = PBM_INVALID;
    mCurrentplaybackMode = PBM_INVALID;
    mRepeatModeRequested = RPT_INVALID;
    mCurrentRepeatMode = RPT_INVALID;
}
tResult BTControl::HandlePlayerChangeWhileChangePathInProgress(const tPlayerName playerName)
{
    ENTRY;
    VARTRACE(playerName)
    tResult ret = MP_NO_ERROR;

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    if(mConnectedDeviceInfo.connected)
    {
        /*Do Not send Answer If mIsPlayItemFromBrowseNeeded is TRUE.
          It means BTControlSM was in WaitingForPathChange State due to "PLAY" event.Hence VTBleutooth is not waiting for Answer.*/
        if(!mIsPlayItemFromBrowseNeeded)
        {
            //Unlock the InternalQueue before bringing it to Idle state by sending the Answer
            ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN REQ_NOT_OK,IN 0,IN NULL,IN NULL);
            SendAnswer(IN parameterString);
        }
        //std::string Temp;
        //stringstream ss;
        //ss << playerId;
        //Temp=ss.str();
        AvpChangeBrowsedPlayer(playerName);
    }
    return ret;
}
tResult BTControl::HandlePlayerChangeWhileGetFolderItemInProgress(const tPlayerName playerName)
{
    ENTRY;
    VARTRACE(playerName)
    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    if(mConnectedDeviceInfo.connected)
    {
        //Unlock the InternalQueue before bringing it to Idle state by sending the Answer
        ParameterAVP_GET_FOLDER_ITEM_METHOD_RETURN(OUT parameterString,IN size,IN REQ_NOT_OK,IN SCOPE_MP_VFS,IN 0,IN NULL,IN 0,IN NULL);
        SendAnswer(IN parameterString);
        //std::string Temp;
        //stringstream ss;
        //ss << playerId;
        //Temp=ss.str();
        AvpChangeBrowsedPlayer(playerName);
    }
    return ret;
}
tResult BTControl::AvpChangePathToRootMethodReturn(tBTMethodRequestStatus status,tNumOfItems numOfItems,tErrorMessage message)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    (void)numOfItems;
    (void)message;

    if(REQ_OK == status)
    {
        if(mLevelUpCount) mLevelUpCount--;

        if(mLevelUpCount)
        {
            ETG_TRACE_USR1(("Remaining Level-up count:%d",mLevelUpCount));

            ret = BTDaemonProxy::GetInstance().AvpChangePath(IN FOLDER_UP ,IN (tItemUID)NULL,(tBoolean)true);

            if(ret != MP_NO_ERROR)
            {
                mLevelUpCount = 0;
                ETG_TRACE_USR4(("Posting Level-up in DBus for Setting-up ROOT Path failed!.Doing AvpSetPlayer"));
                ret = AvpSetPlayer(mPlayerId,mPlayerModeCalled);
            }
        }
        else
        {
            ETG_TRACE_USR1(("Setting-up ROOT Path Done.Doing AvpSetPlayer for New Player!"));
            ret = AvpSetPlayer(mPlayerId,mPlayerModeCalled);
        }
    }
    else
    {
        mLevelUpCount = 0;
        ETG_TRACE_USR1(("Setting-up ROOT Path Failed!.Doing AvpSetPlayer!"));
        ret = AvpSetPlayer(mPlayerId,mPlayerModeCalled);
    }
    return ret;
}
void BTControl::ClearRemoteActivityFlags()
{
    mIsRemoteActivityNeeded = false;
    mActionOnPlayTime = NO_ACTION_NEEDED;
    mTotalPlayTime = PLAYTIME_NONE ;
    mElapsedPlayTime = PLAYTIME_NONE;
}
tResult BTControl::HandleVRSessionStatus(tVRSessionStatus vrstatus,tSiriStatus siristatus,tVRSupportStatus vrsupport)
{
    ENTRY;

    VARTRACE(mIsBTControlActive);
    VARTRACE(mIsSiriSessionActive);
    VARTRACE(bRemoteActivityReqViaSiri);

    /* Enable mIsSiriSessionActive if Siri enabled in device.*/
    if(vrstatus && vrsupport)
    {
        mIsSiriSessionActive = true;
    }
    else
    {
        /* Start a timer for 500m sec if  mIsSiriSessionActive and playback status not received in SIRI session.
         * Because the Playback status from siri session may come after ending the VR session*/
        if((false == mIsBTControlActive)&& (true == mIsSiriSessionActive) && (false == bRemoteActivityReqViaSiri))
        {
            if(StartSiriSessionTimer())
            {
                //Return if timer starts successfully.
                return MP_NO_ERROR;
            }
        }
        //Clear all SIRI session related flags.
        ClearSiriSessionFlags();
    }


    return MP_NO_ERROR;
}
tResult BTControl::ClearSiriSessionFlags()
{
    ENTRY;
    mIsSiriSessionActive = false;
    bRemoteActivityReqViaSiri = false;
    if(m_SiriSessionTimerID)
    {
        StopSiriSessionTimer();
        m_SiriSessionTimerID = 0;
    }
    return MP_NO_ERROR;
}
tBoolean BTControl::StartSiriSessionTimer()
{
    ENTRY;
    /* Set the timeout value */
    long timeoutValue = LocalSPM::GetDataProvider().SiriSessionTimeOutMS();

    /* Start the timer, single shot */
    tBoolean ret = m_SiriSessionTimer.StartTimer(OUT m_SiriSessionTimerID, IN timeoutValue, 0L, &LocalSPM::GetBTControl(), &SiriSessionTimerCallBack, NULL);
    ETG_TRACE_USR3(("StartVRSessionTimer m_SiriSessionTimerID: %p ",m_SiriSessionTimerID));
    return ret;
}
void BTControl::StopSiriSessionTimer()
{
    ENTRY;
    /* Cancel the timer */
    if (m_SiriSessionTimerID)
    {
        m_SiriSessionTimer.CancelTimer(IN m_SiriSessionTimerID);
    }

}
bool BTControl::SiriSessionTimerCallBack(timer_t /*timerID */, void* instance ,const void * /*userData*/)
{
    ENTRY;
    BTControl *self = (BTControl*)instance;
    if(self)
    {
        self->m_SiriSessionTimerID = 0;
        self->ClearSiriSessionFlags();
    }

    return true;
}
void  BTControl::SetCurrentPlayer(string Playername)
{
    mPlayerName = Playername;
    ETG_TRACE_USR3((" BTControl::SetCurrentPlayer mPlayerName : %s ",mPlayerName.c_str()));
}
void  BTControl::GetPlayerId(tPlayerId &PlayerId)
{
    PlayerId = mPlayerId;
}
tPEPlaybackState BTControl::GetCurrentPlaybackState()
{
    Locker locker(&m_Mutex);
    return mCurrentPlaybackState;
}

int BTControl::UpdateDeviceVersion(tBTAvrcpVersion avrcpVersion)
{
    ENTRY;
    int ret = -1;

    VARTRACE(avrcpVersion);

    char *deviceVersionParamString = NULL;
    tSize size = sizeof(tAllParameters);
    deviceVersionParamString = new char[size];
    if(deviceVersionParamString)
    {
        switch(avrcpVersion)
        {
            case AVRCP_NO_METADATA:
                strncpy_r(mConnectedDeviceInfo.deviceVersion,"1.0",sizeof(mConnectedDeviceInfo.deviceVersion));
                break;
            case AVRCP_METADATA:
                strncpy_r(mConnectedDeviceInfo.deviceVersion,"1.3",sizeof(mConnectedDeviceInfo.deviceVersion));
                break;
            case AVRCP_BROWSING:
                strncpy_r(mConnectedDeviceInfo.deviceVersion,"1.4",sizeof(mConnectedDeviceInfo.deviceVersion));
                break;
            case AVRCP_MYMEDIA:
                strncpy_r(mConnectedDeviceInfo.deviceVersion,"1.5",sizeof(mConnectedDeviceInfo.deviceVersion));
                break;
            default:
                strncpy_r(mConnectedDeviceInfo.deviceVersion,"1.0",sizeof(mConnectedDeviceInfo.deviceVersion));
                break;
        }
        //strncpy_r(mConnectedDeviceInfo.deviceVersion,"1.3",sizeof(mConnectedDeviceInfo.deviceVersion));
        SMF::Marshal(deviceVersionParamString, size-1, tDeviceID_format tDeviceVersion_format ,mConnectedDeviceInfo.deviceID,mConnectedDeviceInfo.deviceVersion);
        ret = LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DB_CHANGE_DEVICE_VERSION, IN deviceVersionParamString);
    }
    return ret;
}

tResult BTControl::GetPlayerAttributes()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tBTMethodRequestStatus status = REQ_NOT_OK;
    tPlayerAttributes SupportedAttributes;

    ret = BTDaemonProxy::GetInstance().GetPlayerAttributes(OUT status,OUT SupportedAttributes);

    mConnectedDeviceInfo.isShuffleSupported = false;
    mConnectedDeviceInfo.isRepeatSupported = false;

    if(MP_NO_ERROR == ret)
    {
        mConnectedDeviceInfo.isShuffleSupported = SupportedAttributes.Shuffle.AttributeSupported;
        mConnectedDeviceInfo.isRepeatSupported = SupportedAttributes.Repeat.AttributeSupported;

        const size_t size = sizeof(tAllParameters);
        char *parameterString1 = new char[size];
        char *parameterString2 = new char[size];

        SMF::Marshal(parameterString1, size-1, tDeviceID_format tShuffleSupport_format, mConnectedDeviceInfo.deviceID, (tShuffleSupport)mConnectedDeviceInfo.isShuffleSupported);

        ret = LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DB_CHANGE_SHUFFLE_SUPPORT, IN parameterString1);

        ForwardPlaybackModeStatus((tPlaybackMode)SupportedAttributes.Shuffle.value);


        SMF::Marshal(parameterString2, size-1, tDeviceID_format tRepeatSupport_format, mConnectedDeviceInfo.deviceID, (tRepeatSupport)SupportedAttributes.Repeat.AttributeSupported);

        ret = LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DB_CHANGE_REPEAT_SUPPORT, IN parameterString2);

        ForwardRepeatModeStatus((tRepeatMode)SupportedAttributes.Repeat.value);
    }
    else
    {
        ETG_TRACE_ERR(("Get Attributes for the new player has failed"));
    }
    return ret;
}

tBoolean BTControl::SetupPlayerForBrowsing(string playerName)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tBoolean isSuccess = false;
    tBoolean isBrowsable;

    ret = BTDaemonProxy::GetInstance().IsPlayerBrowsable(IN playerName,OUT isBrowsable);
    if((MP_NO_ERROR == ret) && isBrowsable)
    {
        tNumOfItems numberOfItems;
        ret  =  BTDaemonProxy::GetInstance().SetupPlayerForBrowsing(IN playerName,OUT numberOfItems);
        if(MP_NO_ERROR == ret){
            mCurBrowsedPthItemCnt = numberOfItems;
            isSuccess = true;
        }
    }

    VARTRACE(ret)
    VARTRACE(isBrowsable)
    VARTRACE(isSuccess)

    return isSuccess;
}

int BTControl::StartDoTask()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    ret =  SendEvent(BEGIN_TASK,NULL);
    return ret;
}

tBoolean BTControl::IsTaskAvailable()
{
    ENTRY
    if(mTaskVector.size() > 0)
        return true;
    else
        return false;
}
int BTControl::StartTask()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tTaskContext taskContext = mTaskVector.back();
    mTaskVector.pop_back();
    ret = LocalSPM::GetThreadFactory().Do(IN this, IN taskContext.taskId, IN taskContext.parameters);
    return ret;
}

int BTControl::EndTask()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    if(mConnectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET)
    {
        SetTaskSyncSemWait(true);

        /* wait on counting semaphore */
        struct timespec timeToWait;
        /*get current time*/
        if(clock_gettime(CLOCK_REALTIME , &timeToWait) != -1)
        {
            /*update timeToWait with wait duration */
            timeToWait.tv_sec += 7;
            /* wait for semaphore */
            while(1)
            {
                ret = sem_timedwait(&m_TaskSyncSem, &timeToWait);
                if (!ret) break; // no error
                ret = errno; // get the last error
                if (ret != EINTR) break;

            }
            VARTRACE(ret);
            if (ret != ETIMEDOUT && ret) {
                ETG_TRACE_ERR (("error on sem_timedwait"));
            }
        }
        else
        {
            ETG_TRACE_ERR (("error on sem_timedwait : Real time not obtained"));
        }
        SetTaskSyncSemWait(false);
    }
    return ret;

}

void BTControl::DoCalculateItemCountInGivenPath(char *parameterStr)
{
    ENTRY;
    // Function should not be returned anywhere in between should be returned only in the end.
    tResult ret = MP_NO_ERROR;
    tStartItem startItem = 1;
    int lastSuccessfulGuessCount = 0;
    int lastFailureGuessCount  = 0;
    int itemCountSearchIndex = 0;
    int nowplayingListSize = 0;
    tBoolean isItemCountFound=false;
    int itemCount = 0;
    tURL path;
    tEndItem lastRetrivedItem = 0;
    tBoolean isGetFolderitemsTerminated = false;
    tBoolean isFolderPathChanged = false;
    int lastUpdatedBatch = 0;
    string oldpath;

    tBoolean cacheUpdated = false;
    //Parameters for crating task context.
    const size_t size = sizeof(tAllParameters);
    tTaskContext newTaskContext;
    newTaskContext.taskId = FUNCTION_ID_CALCULATE_ITEM_COUNT;
    newTaskContext.parameters = new char[size];

    if(parameterStr!=NULL)
    {
        SMF::UnMarshal(parameterStr, DOUBLE_MARSHAL_SEPARATOR, "tiiiii", &path,&lastSuccessfulGuessCount,&lastFailureGuessCount,&itemCountSearchIndex,&nowplayingListSize,&isItemCountFound);
        ETG_TRACE_USR3(("DoCalculateItemCountInGivenPath path :%s",path));
        ETG_TRACE_USR3(("DoCalculateItemCountInGivenPath lastSuccessfulGuessCount :%d",lastSuccessfulGuessCount));
        ETG_TRACE_USR3(("DoCalculateItemCountInGivenPath lastFailureGuessCount :%d",lastFailureGuessCount));
        ETG_TRACE_USR3(("DoCalculateItemCountInGivenPath itemCountSearchIndex :%d",itemCountSearchIndex));
        ETG_TRACE_USR3(("DoCalculateItemCountInGivenPath nowplayingListSize :%d",nowplayingListSize));
        ETG_TRACE_USR3(("DoCalculateItemCountInGivenPath isItemCountFound :%d",isItemCountFound));
        delete[] parameterStr;
        if(strlen_r(path) == 0)
        {
            ETG_TRACE_USR3(("DoCalculateItemCountInGivenPath Invalid path "));
        }
        else
        {
            if(GetCurrentBrowsePath()!=NULL)
            {
                oldpath = string((const char*)GetCurrentBrowsePath());
            }
            else
            {
                oldpath = PATH_DELIMITER;
            }

            ETG_TRACE_USR3(("CurrentBrowsePath :%s",oldpath.c_str()));

            if(strcmp(oldpath.c_str(),(const char *)path))
            {
                isFolderPathChanged = true;

                ret = ChangeFolderPath(path);

                if(MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("ChangeFolderPath failed path : %s ",path));
                }
            }
            if(MP_NO_ERROR == ret)
            {
                do
                {
                    tBoolean taskSyncSemWaitValue=GetTaskSyncSemWaitValue();
                    if(taskSyncSemWaitValue)
                    {
                        SMF::Marshal(newTaskContext.parameters, size-1, DOUBLE_MARSHAL_SEPARATOR, "tiiiii",
                                path, lastSuccessfulGuessCount, lastFailureGuessCount, itemCountSearchIndex,
                                nowplayingListSize, isItemCountFound);
                        AddTaskToVector(newTaskContext);
                        break;
                    }

                    if(lastFailureGuessCount == 0)
                    {
                        startItem = ::pow(2, itemCountSearchIndex);
                    }
                    else
                    {
                        startItem  = (lastSuccessfulGuessCount + lastFailureGuessCount)/2;
                    }

                    ret = CheckFolderItem(startItem - 1);

                    if(MP_NO_ERROR == ret)
                    {
                        ret = GetAndUpdateFolderItemsBulk(path, lastSuccessfulGuessCount, startItem-1, lastRetrivedItem, isGetFolderitemsTerminated ,lastUpdatedBatch,cacheUpdated);
                        if(MP_NO_ERROR == ret)
                        {
                            if(isGetFolderitemsTerminated)
                            {
                                ETG_TRACE_USR3(("GetAndUpdateFolderItemsBulk terminated "));

                                lastSuccessfulGuessCount = lastRetrivedItem;
                                SMF::Marshal(newTaskContext.parameters, size-1, DOUBLE_MARSHAL_SEPARATOR, "tiiiii", path,lastSuccessfulGuessCount,lastFailureGuessCount,itemCountSearchIndex,nowplayingListSize,isItemCountFound);
                                AddTaskToVector(newTaskContext);

                                break;
                            }
                            else
                            {
                                lastSuccessfulGuessCount = startItem;
                            }
                            if(lastFailureGuessCount == 0)
                            {
                                itemCountSearchIndex++;
                            }
                        }
                        else
                        {
                            ETG_TRACE_ERR(("GetAndUpdateFolderItemsBulk failed to get startItem:%d endItem:%d ",lastSuccessfulGuessCount,startItem));
                            break;
                        }
                    }
                    else
                    {
                        lastFailureGuessCount = startItem;
                        //If the  first item itself is not found in the path return error.
                        if(startItem == 1)
                        {
                            // Earse Nowplaying items and update list calculation completed.
                            ETG_TRACE_USR4(("Nowplaying list first item not found,Clearing the NowPlaing Cache"));
                            BTCacheEraseNowplaying();
                            isItemCountFound = true;
                            break;
                        }
                    }

                    if((lastFailureGuessCount - lastSuccessfulGuessCount) == 1)
                    {
                        nowplayingListSize = lastSuccessfulGuessCount;
                        isItemCountFound = true;
                        itemCount = nowplayingListSize;
                    }
                }while(!isItemCountFound);

                if(isFolderPathChanged)
                {
                    ret = ChangeFolderPath((char *)oldpath.c_str());
                    if(MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("ChangeFolderPath failed path : %s ",oldpath.c_str()));
                    }
                }
                VARTRACE(itemCount);
                if(isItemCountFound)
                {
                    SendListChangedToHMI();
                }
            }
        }
    }
    else
    {
        ETG_TRACE_USR3(("DoCalculateItemCountInGivenPath Invalid parameterStr "));
    }

    tGeneralString stateName;
    size_t sizeofStateName = sizeof(tGeneralString);
    GetSMStateName(stateName,sizeofStateName);
    const tGeneralString SMstateDoTaskIdle ="doTask_Idle";
    VARTRACE(stateName);

    //If state is not in the "doTask_Idle" state, then task finished and sem_post are not required.
    //when state is "doTask_Idle", then task finished is required only in case where the process is not terminated due to another event.

    if((strlen_r(stateName) == strlen_r(SMstateDoTaskIdle)) && (!(strncmp(stateName,SMstateDoTaskIdle,strlen_r(stateName)))))
    {
        if(!GetTaskSyncSemWaitValue())
        {
            SendEvent(TASK_FINISHED,NULL);
        }
        sem_post(&m_TaskSyncSem);
    }

}


void BTControl::SetTaskSyncSemWait(tBoolean Value)
{
    // ENTRY
    Locker locker(&m_TaskSyncSemMutex);
    m_TaskSyncSemWait = Value;
}

tBoolean BTControl::GetTaskSyncSemWaitValue()
{
    // ENTRY
    Locker locker(&m_TaskSyncSemMutex);
    return m_TaskSyncSemWait;
}

tResult BTControl::CheckFolderItem(tStartItem startItem)
{
    ENTRY
    tResult ret= MP_NO_ERROR;
    VARTRACE(startItem);
    string result;
    ret = BTDaemonProxy::GetInstance().GetFolderItems(IN NOW_PLAYING,startItem,startItem,result);
    if(MP_NO_ERROR == ret)
    {
        ETG_TRACE_USR3(("FolderItem found : %d ",startItem));
    }
    else
    {
        ETG_TRACE_USR3(("FolderItem not found :%d error:%d",startItem,ret));
    }
    return ret;
}


void BTControl::AddTaskToVector(tTaskContext newTaskContext)
{
    ENTRY
    //Add the task only when it is not there in the list.
    if(mTaskVector.size() > 0)
    {
        vector<tTaskContext>::iterator it;
        for(it = mTaskVector.begin(); it != mTaskVector.end();it++)
        {
            if((*it).taskId == newTaskContext.taskId)
            {
                ETG_TRACE_USR3(("AddTaskToVector :Task already in  mTaskVector taskId:%d",newTaskContext.taskId));
                return;
            }
        }

    }
    mTaskVector.push_back(newTaskContext);
    SendEvent(BEGIN_TASK,NULL);
}

int BTControl::ProcessContentChanged()
{
    ENTRY
    tResult ret= MP_NO_ERROR;
    StartNowplayingListUpdate();
    ret = SendEvent(NOWPLAYING_CONTENTCHANGED_DONE,NULL);
    return ret;
}

int BTControl::NowPlayingContentUpdated()
{
    ENTRY
    tResult ret= MP_NO_ERROR;
    RemoveTaskFromVector(FUNCTION_ID_CALCULATE_ITEM_COUNT);
    BTCacheEraseNowplaying();
    return ret;
}

tResult BTControl::GetAndUpdateFolderItemsBulk(string curPath,tStartItem startItem,tEndItem endItem,tEndItem &lastItemretrived,tBoolean &isterminated,int &lastUpdatedBatch,tBoolean& cacheUpdated)
{
    ENTRY
    tResult ret= MP_NO_ERROR;
    cacheUpdated = false;
    VARTRACE(startItem);
    VARTRACE(endItem);
    tStartItem internalStartItem;
    tEndItem internalEndItem;
    string result;
    int itemRetrieved = 0;
    map<unsigned int,tBrowseElement> ElementsRetrieved;
    ElementsRetrieved.clear();

    internalStartItem = startItem;
    internalEndItem = endItem;

    lastItemretrived = internalStartItem;

    isterminated = false;
    int itemIndex;
    int batchToBeUpdated = 50;

    if(endItem < startItem)
    {
        ETG_TRACE_ERR(("Invalid inputs"));
    }

    do
    {
        tBoolean taskSyncSemWaitValue=GetTaskSyncSemWaitValue();
        if(taskSyncSemWaitValue)
        {
            isterminated = true;
            ETG_TRACE_USR3(("Thread waiting , closing"));
            break;
        }
        if(internalEndItem < startItem)
        {
            ETG_TRACE_ERR(("Invalid inputs"));
        }
        tNumOfItems Count = endItem - internalStartItem;


        if(Count > FOLDER_ITEM_BATCH_SIZE)
        {
            internalEndItem = internalStartItem + (FOLDER_ITEM_BATCH_SIZE-1);
        }
        else
        {
            internalEndItem = endItem;
        }


        ret = BTDaemonProxy::GetInstance().GetFolderItems(IN NOW_PLAYING,internalStartItem,internalEndItem,result);

        if(MP_NO_ERROR == ret)
        {
            if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
            {
                itemIndex = internalStartItem;
                int literalCount = 0;
                const char* tempParam = result.c_str();

            char *ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
            while (ptr != NULL) {
                ptr = strchr((char*) ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }
            ETG_TRACE_USR3(("literalCount :%d",literalCount));
            std::string strFromChar;
            strFromChar.append(tempParam);
            std::istringstream ss(strFromChar);
            std::string token[literalCount];
            for (int index = 0; index < literalCount; index++)
            {
                std::getline(ss, token[index],IPC_DBUS_PARAM_DELIMITER_CHAR);
            }
            for (int index = 0; index < literalCount; )
            {
                //Check the string is a Media Item object path.
                //If so Create a new  tBrowseElement and fill all other filed by iterating through the available string array.
                if ((token[index].find("/org/bluez/hci1/") != string::npos) && ((token[index].find("/Filesystem/item") != string::npos) || (token[index].find("/NowPlaying/item") != string::npos)) )
                {

                    tBrowseElement item;
                    item.isPlayable = false;
                    item.objectPath = token[index];
                    item.type = INVALID;
                    //ETG_TRACE_USR3(("item.objectPath :%s",item.objectPath.c_str()));
                    //ETG_TRACE_USR3((" DoGetFolderItem index :%d",index));
                    int itemindex = index + 1;

                    //Iterate through the next items in the string array to find the neccessary informations.
                    for (itemindex; itemindex < literalCount;itemindex++)
                    {
                        //Check the string is Media Item object path.
                        //If so end parsing the substrings for the Browse element.It will be startinf of the new media object.
                        if ((token[itemindex].find("/org/bluez/hci1/") != string::npos) && ((token[itemindex].find("/Filesystem/item") != string::npos) || (token[itemindex].find("/NowPlaying/item") != string::npos)))
                        {
                            break;
                        }
                        else if (token[itemindex].compare("Type") == 0)
                        {
                            if((itemindex + 1) < literalCount)
                            {
                                if (!strcmp(token[itemindex + 1].c_str(), "Folder"))
                                {
                                    item.type = FOLDER;
                                    item.isPlayable = false;
                                    itemindex++;
                                }
                                else if (!strcmp(token[itemindex + 1].c_str(), "Audio"))
                                {
                                    item.type = AUDIO_FILE;
                                    item.isPlayable = true;
                                    itemindex++;
                                }
                                else if (!strcmp(token[itemindex + 1].c_str(), "Video"))
                                {
                                    item.type = VIDEO_FILE;
                                    item.isPlayable = false;
                                    itemindex++;
                                }
                                //ETG_TRACE_USR3(("item.type :%d",item.type));
                                //ETG_TRACE_USR3(("item.isPlayable :%d",item.isPlayable));
                            }
                        }
                        else if (token[itemindex].compare("Name") == 0)
                        {
                            if((itemindex + 1) < literalCount)
                            {
                                unsigned int lastIndex = token[itemindex + 1].find_last_of("/");
                                if(string::npos != lastIndex)
                                {
                                    item.name.append(token[itemindex + 1].substr(lastIndex + 1).c_str());
                                }
                                else
                                {
                                    item.name.append(token[itemindex + 1].c_str());
                                }
                                ETG_TRACE_USR3(("item.name :%s",item.name.c_str()));
                                itemindex++;
                            }

                        }
                        else if(token[itemindex].compare("Title") == 0)
                        {
                            if(((itemindex + 1) < literalCount) && item.name.empty())
                            {
                                item.name.append(token[itemindex + 1].c_str());
                                ETG_TRACE_USR3(("item.name :%s",item.name.c_str()));
                            }
                            itemindex++;

                        }

                        }
                        index = itemindex;
                        itemRetrieved++;
                        ElementsRetrieved[itemIndex] = item;
                        //Value will be used as Key in BTCache
                        itemIndex++;
                    }
                    else
                    {
                        index++;
                    }
                }

            }
            else
            {
                struct FolderItem_Item_info *l_spcFolderData = NULL;
                struct MediaElement_Item_info *l_spcMediaElementData = NULL;
                unsigned char* ItemName = NULL;
                tNetworkOrder NetworkOrder = false;
                tByteArray ByteArray = NULL;
                tArrayLength ArrayLength = 0;
                tNumOfItems ItemRetrieved = 0;
                tBTMethodRequestStatus status = REQ_NOT_OK;
                tScope scope = SCOPE_INVALID;
                const char* param = result.c_str();

                if((param != NULL) && strlen_r(param) > 0)
                {
                    sscanf(param,"%u,%u,%u,%u,%p",&status,&scope,&NetworkOrder,&ArrayLength,&ByteArray);
                    ETG_TRACE_USR3(("ByteArray :%s",ByteArray));
                    tNumOfItems retrievedItemIndex = startItem;
                    do
                    {
                        tBrowseElement item;
                        memset(&item, 0, sizeof(item));
                        item.type = (tBTItemType)*ByteArray;
                        ByteArray++;
                        ArrayLength--;

                        /*Before Parsing the ByteArray to collect Information of FolderItem or MediaItem,
                         * Ensure the data of Expected size available for FolderItem or MediaItem respectively
                         */
                        if(((item.type == MEDIA_ELEMENT) && (ArrayLength >= sizeof(struct MediaElement_Item_info))) ||
                                ((item.type == FOLDER) &&(ArrayLength >= sizeof(struct FolderItem_Item_info))))
                        {
                            //Retrieving the Item-type,length,UID,SubType,CharSetId into a structure.
                            if(MEDIA_ELEMENT == item.type)
                            {
                                l_spcMediaElementData = new struct MediaElement_Item_info ;
                                if(l_spcMediaElementData)
                                {
                                    memcpy(l_spcMediaElementData,ByteArray,sizeof(struct MediaElement_Item_info));
                                    if((l_spcMediaElementData->Item_Sub_Type == AUDIO_FILE) || (l_spcMediaElementData->Item_Sub_Type == VIDEO_FILE))
                                        item.type = (tBTItemType)l_spcMediaElementData->Item_Sub_Type;

                                    ETG_TRACE_USR3(("l_spcMediaElementData UID :%d,%d,%d,%d,%d,%d,%d,%d",l_spcMediaElementData->Item_UID[0],l_spcMediaElementData->Item_UID[1],l_spcMediaElementData->Item_UID[2],l_spcMediaElementData->Item_UID[3],l_spcMediaElementData->Item_UID[4],l_spcMediaElementData->Item_UID[5],l_spcMediaElementData->Item_UID[6],l_spcMediaElementData->Item_UID[7]));
                                }

                                //As MEDIA_ELEMENT information parsing over,decrement the arrayLength
                                ArrayLength = ArrayLength - sizeof(struct MediaElement_Item_info);
                                ByteArray= ByteArray+ START_OF_MEDIAELEMENT_NAME;
                            }
                            else if(FOLDER == item.type)
                            {
                                //l_spcFolderData=(struct FolderItem_Item_info *)ByteArray;
                                l_spcFolderData = new struct FolderItem_Item_info;
                                if(l_spcFolderData)
                                {
                                    memcpy(l_spcFolderData,ByteArray,sizeof(struct FolderItem_Item_info));

                                    ETG_TRACE_USR3(("l_spcFolderData UID :%d,%d,%d,%d,%d,%d,%d,%d",l_spcFolderData->Item_UID[0],l_spcFolderData->Item_UID[1],l_spcFolderData->Item_UID[2],l_spcFolderData->Item_UID[3],l_spcFolderData->Item_UID[4],l_spcFolderData->Item_UID[5],l_spcFolderData->Item_UID[6],l_spcFolderData->Item_UID[7]));
                                }

                                //As FOLDER information parsing over,decrement the arrayLength
                                ArrayLength = ArrayLength - sizeof(struct FolderItem_Item_info);
                                ByteArray = ByteArray + START_OF_FOLDER_NAME;
                            }

                            if(NetworkOrder)
                            {
                                if((FOLDER == item.type) && (l_spcFolderData != NULL))
                                {
                                    l_spcFolderData->Item_Length=ntohs(l_spcFolderData->Item_Length);
                                    l_spcFolderData->Item_Name_Length=ntohs(l_spcFolderData->Item_Name_Length);
                                }
                                else if(( VIDEO_FILE == item.type || AUDIO_FILE == item.type) && (l_spcMediaElementData != NULL))
                                {
                                    l_spcMediaElementData->Item_Length=ntohs(l_spcMediaElementData->Item_Length);
                                    l_spcMediaElementData->Item_Name_Length=ntohs(l_spcMediaElementData->Item_Name_Length);
                                }
                            }

                            /*find and set item name*/
                            if(FOLDER == item.type)
                            {
                                if(l_spcFolderData != NULL)
                                {
                                    ETG_TRACE_USR3(("l_spcFolderData Itemlength:%d , name_length:%d",l_spcFolderData->Item_Length,l_spcFolderData->Item_Name_Length));

                                    //If ItemName Length and Array available to parse are Non-zero,then parse and prepare name.Else,let the name be Empty
                                    if(l_spcFolderData->Item_Name_Length && ArrayLength)
                                    {
                                        ItemName = new unsigned char[(l_spcFolderData->Item_Name_Length)+1];

                                        if(ItemName != NULL)
                                        {
                                            //Validate the byteArray available to find ItemName is atleast of size of  Item Name Length
                                            if(ArrayLength >= l_spcFolderData->Item_Name_Length)
                                            {
                                                memcpy(ItemName,ByteArray,l_spcFolderData->Item_Name_Length);
                                                ItemName[l_spcFolderData->Item_Name_Length]='\0';

                                                ArrayLength = ArrayLength - (l_spcFolderData->Item_Name_Length);
                                                ByteArray += l_spcFolderData->Item_Name_Length;
                                            }
                                            else //Prepare the ItemName with available ByteArray eventhough it is lesser size
                                            {
                                                memcpy(ItemName,ByteArray,ArrayLength);
                                                ItemName[ArrayLength]='\0';
                                                ArrayLength = 0 ;
                                            }
                                            item.name = string((const char*)ItemName);
                                            delete[] ItemName;
                                            ItemName = NULL;
                                        }
                                    }
                                    ETG_TRACE_USR3(("Folder Item name is %s",item.name.c_str()));
                                    ETG_TRACE_USR3(("ArrayLength Now is %d",ArrayLength));
                                }
                            }
                            else if(VIDEO_FILE == item.type || AUDIO_FILE == item.type)
                            {
                                if(l_spcMediaElementData != NULL)
                                {
                                    ETG_TRACE_USR3(("l_spcMediaElementData Itemlength:%d , name_length:%d",l_spcMediaElementData->Item_Length,l_spcMediaElementData->Item_Name_Length));

                                    //If ItemName Length and Array available to parse are Non-zero,then parse and prepare name.Else,let the name be Empty
                                    if(l_spcMediaElementData->Item_Name_Length && ArrayLength)
                                    {
                                        ItemName = new unsigned char[(l_spcMediaElementData->Item_Name_Length)+1];

                                        if(ItemName!= NULL )
                                        {
                                            //Validate the byteArray available to find ItemName is atleast of size of  Item Name Length
                                            if(ArrayLength >= l_spcMediaElementData->Item_Name_Length)
                                            {
                                                memcpy(ItemName,ByteArray,l_spcMediaElementData->Item_Name_Length);
                                                ItemName[l_spcMediaElementData->Item_Name_Length]='\0';

                                                ArrayLength = ArrayLength-(l_spcMediaElementData->Item_Name_Length);
                                                ByteArray += l_spcMediaElementData->Item_Name_Length;

                                                //If MediaElement Present,then zero is sent additionally .So Parsing that byte.
                                                if(ArrayLength)
                                                {
                                                    ArrayLength--;
                                                    ByteArray++;
                                                }
                                            }
                                            else //Prepare the ItemName with available ByteArray eventhough it is lesser size
                                            {
                                                memcpy(ItemName,ByteArray,ArrayLength);
                                                ItemName[ArrayLength]='\0';
                                                ArrayLength = 0;
                                            }

                                            item.name = string((const char*)ItemName);
                                            delete[] ItemName;
                                            ItemName = NULL;
                                        }
                                        ETG_TRACE_USR3(("Media Item name is %s",item.name.c_str()));
                                        ETG_TRACE_USR3(("ArrayLength Now is %d",ArrayLength));
                                    }
                                }
                            }

                            /*copy uid*/
                            if(FOLDER == item.type)
                            {
                                if(l_spcFolderData)
                                {
                                    memcpy(item.uid,l_spcFolderData->Item_UID,sizeof(item.uid));
                                    item.isPlayable = (tBoolean)l_spcFolderData->IsPlayable;

                                    delete l_spcFolderData;
                                    l_spcFolderData = NULL;
                                }
                            }
                            else if(VIDEO_FILE == item.type || AUDIO_FILE == item.type)
                            {
                                if(l_spcMediaElementData)
                                {
                                    memcpy(item.uid,l_spcMediaElementData->Item_UID,sizeof(item.uid));
                                    item.isPlayable = true;

                                    delete l_spcMediaElementData;
                                    l_spcMediaElementData = NULL;

                                }
                            }

                            ETG_TRACE_USR3(("Prepared new item type:%d,name:%s",item.type,item.name.c_str()));
                            ETG_TRACE_USR3(("Prepared new item playable:%d",item.isPlayable));
                            ETG_TRACE_USR3(("Prepared new item uid: %d,%d,%d,%d,%d,%d,%d,%d",item.uid[0],item.uid[1],item.uid[2],item.uid[3],item.uid[4],item.uid[5],item.uid[6],item.uid[7]));

                            ElementsRetrieved[retrievedItemIndex] =item;
                            ItemRetrieved ++;
                            retrievedItemIndex++;
                        }
                        else
                        {
                            //Parsing the received data may lead to errors.Just Exit
                            break;
                        }
                    }
                    while (ArrayLength != 0);


                }
            }
            tNumOfItems TotNumOfItems,ElementsInCache;

            //TODO: Check and confirm BTStoreBrowseLevelInfo() for /NowPlaying called before this.
            if(!BTGetLevelInfo(IN curPath,OUT TotNumOfItems,OUT ElementsInCache))
            {
                BTStoreBrowseLevelInfo(curPath,itemRetrieved);
            }
            else
            {
                // For "/NowPlaying" path the BrowseLevelInfo will update from BTCacheWrite.
            }

            ETG_TRACE_USR3(("ItemRetrieved in this batch read is :%d",itemRetrieved));


            //If any item retrieved,then push to Cache
            if(!ElementsRetrieved.empty())
            {
                //The below function[BTCachCheckAndUpdate] will check the cache entries and update only if it finds a mismatch.
                //Also it will clear the remaining entries from the cache, if it finds a mismatch.
                tBoolean cacheItemsErased = false;
                BTCachCheckAndUpdate(curPath,ElementsRetrieved,cacheUpdated,cacheItemsErased);
                ElementsRetrieved.clear();
                itemRetrieved = 0;
                VARTRACE(cacheUpdated);
                VARTRACE(cacheItemsErased);

                //Updated list content change to HMI some contents in the now playing list is changed
                if(cacheItemsErased)
                {
                    SendListChangedToHMI();
                }
            }

            internalStartItem = internalEndItem + 1;

            if(endItem < internalStartItem)
            {
                break;
            }
            lastItemretrived = internalEndItem;
            if(static_cast<int>(lastItemretrived) > (lastUpdatedBatch + batchToBeUpdated))
            {
                //For Updating the list to HMI.
                if(cacheUpdated)
                {
                    SendListChangedToHMI();
                }
                lastUpdatedBatch = (lastItemretrived / batchToBeUpdated) * batchToBeUpdated;
                VARTRACE(lastItemretrived);
                VARTRACE(lastUpdatedBatch);
            }
        }
        else if(MP_ERR_FILE_NOT_EXIST == ret)
        {
            ETG_TRACE_ERR(("GetAndUpdateFolderItemsBulk: Folder items not found in the range StartItem:%d EndItem:%d",internalStartItem,internalEndItem));
            break;
        }
        else
        {
            ETG_TRACE_ERR(("GetAndUpdateFolderItemsBulk: Dbus error occurred while trying to get FolderItems"));
            break;
        }

    }while(1);

    VARTRACE(isterminated);

    return ret;
}

void BTControl::SetCurrentBrowsePath(string path)
{
    ENTRY
    Locker locker(&m_Mutex);
    mCurrentBrowsePath = (unsigned char*)strdup(path.c_str());

}

unsigned char* BTControl::GetCurrentBrowsePath()
{
    Locker locker(&m_Mutex);
    return mCurrentBrowsePath;
}

void BTControl::ClearCurrentBrowsePath()
{
    ENTRY
    Locker locker(&m_Mutex);
    free(mCurrentBrowsePath);
    mCurrentBrowsePath = NULL;
}

tResult BTControl::ChangeFolderPath(const char * reqPath)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {

    if(reqPath!=NULL)
    {
        ETG_TRACE_USR3(("ChangeFolderPath reqPath :%s",reqPath));
        string pathToMove;
        do
        {
            findFolderPathToMove((char *)reqPath,pathToMove);
            ETG_TRACE_USR3(("pathToMove :%s",pathToMove.c_str()));
            string ObjectPath;
            if(GetCurrentBrowsePath() == NULL || pathToMove.compare((const char *)GetCurrentBrowsePath()) != 0)
            {
                if (pathToMove == "/")
                {
                    if(!mPlayerName.empty())
                    {
                        ObjectPath = mPlayerName + "/Filesystem";
                    }
                    else
                    {
                        ETG_TRACE_ERR(("PlayerName is empty"));
                    }
                }
                else if("/NowPlaying" == pathToMove)
                {
                    if(!mPlayerName.empty())
                    {
                        ObjectPath = mPlayerName + "/NowPlaying";
                        ETG_TRACE_USR3(("Objectpath :%s",ObjectPath.c_str()));
                    }
                    else
                    {
                        ETG_TRACE_ERR(("PlayerName is empty"));
                    }
                }
                else
                {
                    BTGetItemObjectPath(pathToMove, ObjectPath);
                }

                if (ObjectPath.size())
                {
                    ret = BTDaemonProxy::GetInstance().ChangeFolderPath(IN LEVEL_CHANGE_INVALID, IN (unsigned char*) ObjectPath.c_str());
                }
                else
                {
                    ETG_TRACE_USR3(("Error: Couldn't Find the Object Path"));
                }
            }
            if(MP_NO_ERROR == ret)
            {
                SetCurrentBrowsePath(pathToMove);
            }
            else
            {
                break;
            }


        }while(pathToMove.compare(reqPath));
    }
    }
    else
    {
        //fusion stack-do nothing
    }

    return ret;
}
void BTControl::RemoveTaskFromVector(int TaskId)
{
    ENTRY
    if(mTaskVector.size() > 0)
    {
        vector<tTaskContext>::iterator it;
        for(it = mTaskVector.begin(); it < mTaskVector.end();it++)
        {
            if((*it).taskId == TaskId)
            {
                ETG_TRACE_USR3(("RemoveTaskFromVector:Task in mTaskVector taskId:%d",TaskId));
                mTaskVector.erase(it);
                return;
            }
        }
    }
}
tResult BTControl::SendNoResponseMsg(const tResponseMsg response)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tBool bSend = false;

    ETG_TRACE_USR3(("SendNoResponseMsg %d - %d",m_response, response));
    if(m_response != response)
    {
       switch(response)
       {
           case REASON_BUFFER_UNAVAILABLE:
           case REASON_STREAM_INPROGRESS:
               m_response = REASON_STREAM_INPROGRESS;
               break;
           case REASON_OK:
           case REASON_BUFFER_AVAILABLE:
               m_response=REASON_OK;
               break;
           default:
        m_response = response;
               break;
    }

       //Send Stream in progress in case of only playing state for BT .
       if(m_response == REASON_OK)
       {
           bSend = true;
       }
       else if(mCurrentPlaybackState==PE_PBS_PLAYINGSTATE)
       {
           bSend = true;
       }

       if(true == bSend)
       {
           //ret = LocalSPM::GetOutputWrapper().UpdateStreamingInfo();
           tAllParameters parameterString;
           size_t size = sizeof(parameterString);
           ETG_TRACE_USR3(("Btcontrol :  Forward no response message %d device %d", m_response, mConnectedDeviceInfo.deviceID));
           char messageString[64];
           strncpy_r(OUT messageString, IN "PlayerManagerSM::SET_NORESPONSE_PROPERTY", IN sizeof(messageString));
           ret = LocalSPM::GetPlayerManager().ParameterSET_NORESPONSE_PROPERTY(OUT parameterString, size,m_response,
                   mConnectedDeviceInfo.deviceID,mConnectedDeviceInfo.deviceType);
           if(ret == MP_NO_ERROR)
           {
               Dispatcher::GetInstance().SendMessage( IN messageString, IN parameterString);
           }
       }
    }

    return ret;
}

tBoolean BTControl::getIsAvpChangePathFromStartPlay()
{
    return mIsAvpChangePathFromStartPlay;
}

void BTControl::setIsAvpChangePathFromStartPlay(tBoolean isAvpChangePathFromStartPlay)
{
    mIsAvpChangePathFromStartPlay = isAvpChangePathFromStartPlay;
}

tBoolean BTControl::getIsPlayItemFromBrowseNeeded()
{
    return mIsPlayItemFromBrowseNeeded;
}

void BTControl::setIsPlayItemFromBrowseNeeded(tBoolean isPlayItemFromBrowseNeeded)
{
    mIsPlayItemFromBrowseNeeded = isPlayItemFromBrowseNeeded;
    //mIsAvpChangePathFromStartPlay should always be mIsPlayItemFromBrowseNeeded except in one place in BTControl::DoPlayItemFromBrowse()
    setIsAvpChangePathFromStartPlay(isPlayItemFromBrowseNeeded);
}

tResult BTControl::UpdateShuffleSupportToDB(int ShuffleSupport)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    if(mConnectedDeviceInfo.isShuffleSupported != ShuffleSupport)
    {
        const size_t size = sizeof(tAllParameters);
        char *parameterString1 = new char[size];

        SMF::Marshal(parameterString1, size-1, tDeviceID_format tShuffleSupport_format, mConnectedDeviceInfo.deviceID, (tShuffleSupport)ShuffleSupport);

        ret = LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DB_CHANGE_SHUFFLE_SUPPORT, IN parameterString1);
        if(ret ==  MP_NO_ERROR)
        {
            mConnectedDeviceInfo.isShuffleSupported = ShuffleSupport;
        }
    }
    else
    {
        ETG_TRACE_USR3(("BTControl::UpdateShuffleSupportToDB not update , as trying to update the same value"));
    }

    return ret;
}


tResult BTControl::UpdateRepeatSupportToDB(int RepeatSupport)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    if(mConnectedDeviceInfo.isRepeatSupported != RepeatSupport)
    {
        const size_t size = sizeof(tAllParameters);
        char *parameterString2 = new char[size];

        SMF::Marshal(parameterString2, size-1, tDeviceID_format tRepeatSupport_format, mConnectedDeviceInfo.deviceID, (tRepeatSupport)RepeatSupport);

        ret = LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_DB_CHANGE_REPEAT_SUPPORT, IN parameterString2);
        if(ret == MP_NO_ERROR)
        {
            mConnectedDeviceInfo.isRepeatSupported = RepeatSupport;
        }
    }
    else
    {
        ETG_TRACE_USR3(("BTControl::UpdateRepeatSupportToDB not update , as trying to update the same value"));
    }

    return ret;
}

string BTControl::GetCurrentReqPathForChange()
{
    ENTRY
    return mCurrentReqPathForChange;
}
void BTControl::SetCurrentReqPathForChange(string CurrentReqPathForChange)
{
    ENTRY
    mCurrentReqPathForChange = CurrentReqPathForChange;
}

string BTControl::GetStringWithoutSlash(string name)
{
    int found = name.find_first_of('/');
    while (found != string::npos)
    {
        string name1;
        if(found < name.length())
        {
            name1 = name.substr(found+1);
        }
        else
        {
            name1="";
        }
        name = name.substr(0,found);
        name.append(name1);
        found = name.find_first_of('/');
    }
    int found1 = findFirstofDivisionSlash(name);
    while (found1 != -1)
    {
        string name1;
        if(found1 < name.length())
        {
            name1 = name.substr(found1+3);
        }
        else
        {
            name1="";
        }
        name = name.substr(0,found1);
        name.append(name1);
        found1 = findFirstofDivisionSlash(name);
    }
    VARTRACE(name.c_str());
    return name;

}
int BTControl::findFirstofDivisionSlash(string name)
{
    int found;
    found = name.find_first_of(char(226));
    if(found != string::npos)
    {
        if((!(name.length() > (found+2))) || (!((name[found+1] == char(136)) && (name[found+2] == char(149)))))
        {
            found = -1;
        }
    }
    return found;
}

tResult BTControl::UpdateVolumeToDevice(tVolume AudioVolume)
{
    ENTRY

    if(AUDIO_MAX_VOLUME >= AudioVolume) //Minimum value is not checked as tVolume is Unsigned int ,Audio volume cannot be less than 0.
    {
        //Conversion since Volume range of device is 0-127 and Volume range of Audio of headunit is 0-40
        int DeviceVolume = 0;
        int QoutientValue = DEVICE_MAX_VOLUME / AUDIO_MAX_VOLUME; //Since 127/40 = 3 , every value of audiovolume corresponds to the third value in devicevolume
        if(AudioVolume < (AUDIO_MAX_VOLUME - 1))
        {
            DeviceVolume = AudioVolume * QoutientValue;
        }
        else if(AudioVolume == (AUDIO_MAX_VOLUME - 1)) // since 40*3 = 120 which is not the maximum of the device, the range between (114 to 117) in device volume is split (38 -> 114 , 39 ->120 ,40 ->127)
        {
            DeviceVolume = AUDIO_MAX_VOLUME * QoutientValue;
        }
        else if(AudioVolume == AUDIO_MAX_VOLUME )
        {
            DeviceVolume = DEVICE_MAX_VOLUME;
        }
        ETG_TRACE_USR4(("BTControl::SetVolumetoDevice AudioVolume : % d is converted to DeviceVolume : %d",AudioVolume,DeviceVolume));
        BTDaemonProxy::GetInstance().UpdateVolumeToDevice(DeviceVolume , AudioVolume);
    }
    else
    {
        ETG_TRACE_USR4(("BTControl::SetVolumetoDevice AudioVolume is not within the expected range"));
    }

    return MP_NO_ERROR;
}

tResult BTControl::UpdateVolumeToAudio(tVolume DeviceVolume)
{
    ENTRY
    tResult result = MP_NO_ERROR;
    //Conversion since Volume range of device is 0-127 and Volume range of Audio of headunit is 0-40
    int QoutientValue = DEVICE_MAX_VOLUME / AUDIO_MAX_VOLUME; //Since 127/40 = 3 , every 3 values of devicevolume corresponds to 1 value in audiovolume
    int AudioVolume = 0;

    if(DeviceVolume <= ((AUDIO_MAX_VOLUME - 1)*QoutientValue)) //since values from device volume 118 to 127 would correspond to more than 39 , it split for corresponding 39 and 40.
    {
        AudioVolume = DeviceVolume/QoutientValue;
        AudioVolume = (((DeviceVolume % QoutientValue)== 0) ? AudioVolume : (AudioVolume+1));
    }
    else if (DeviceVolume <= (((AUDIO_MAX_VOLUME - 1)*QoutientValue)+(QoutientValue)))
    {
        AudioVolume = AUDIO_MAX_VOLUME - 1;
    }
    else if((DeviceVolume > (((AUDIO_MAX_VOLUME - 1)*QoutientValue)+QoutientValue)) && (DeviceVolume <= DEVICE_MAX_VOLUME))
    {
        AudioVolume = AUDIO_MAX_VOLUME;
    }
    ETG_TRACE_USR4(("BTControl::UpdateVolumeFromDevice DeviceVolume : % d is converted to AudioVolume : %d",DeviceVolume,AudioVolume));
    LocalSPM::GetOutputWrapper().UpdateVolumeToAudio(AudioVolume);
    return result;
}


tResult BTControl::SendListChangedToHMI()
{
    ENTRY
    tResult Result = MP_NO_ERROR;
    if(mConnectedDeviceInfo.activeSource)
    {
        if(LIST_ID_NONE != NowPlayingListID)
        {
            tNumOfItems TotNumOfItems=0,ElementsInCache = 0;
            string CursorPath = "/NowPlaying";
            BTGetLevelInfo(IN CursorPath,OUT TotNumOfItems,OUT ElementsInCache);

            tListChangeType listChangeType = LCH_CONTENT_CHANGED;
            vector<tPosition> changedItems;
            Result = LocalSPM::GetOutputWrapper().SendMediaPlayerListChanged(
                    IN NowPlayingListID,
                    IN listChangeType,
                    IN ElementsInCache,
                    IN changedItems);

            //Update the NowPlayingList availability to Database Devicetable.
            //This is to inform HMI about the Nowplayinglist availability
            tBoolean isNowPlayingListDBUpdateRequired = false;
            tBoolean nowPLayinglIstAvailability = false;
            if(ElementsInCache && !mNowplayingListAvilable)
            {

                mNowplayingListAvilable = true;
                nowPLayinglIstAvailability = true;
                isNowPlayingListDBUpdateRequired = true;

            }
            else if(!ElementsInCache && mNowplayingListAvilable)
            {
                mNowplayingListAvilable = false;
                nowPLayinglIstAvailability = false;
                isNowPlayingListDBUpdateRequired = true;
            }

            if(isNowPlayingListDBUpdateRequired)
            {
                const size_t size = sizeof(tAllParameters);
                char *parameterString = new char[size];
                SMF::Marshal(parameterString, size-1, tDeviceID_format tNowPlayingListAvailable_format, mConnectedDeviceInfo.deviceID, nowPLayinglIstAvailability);

                LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_NOWPLAYINGLISTAVAILABILITY, IN parameterString);
            }
        }
    }
    if((MP_NO_ERROR != Result) || (LIST_ID_NONE == NowPlayingListID))
    {
        ETG_TRACE_USR4(("BTControl::SendListChangedToHMI : Error in sending listchanged for NowPlaying list to HMI"));
    }

    return Result;
}


int BTControl::AvpChangePathReturnError()
{
    ENTRY
    tAllParameters parameterString="";
    size_t size = sizeof(parameterString);
    tBTMethodRequestStatus status = REQ_NOT_OK;
    tNumOfItems numOfItems = 0 ;
    tErrorMessage errorMessage = NULL;
    tPath path={0};

    if(false == mIsAvpChangePathFromStartPlay)
    {
        ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN errorMessage,IN path);
        SendAnswer(IN parameterString);
    }
    setIsPlayItemFromBrowseNeeded(false);
    return 1;
}

int BTControl::AvpGetFolderItemReturnError()
{
    ENTRY


    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    //Unlock the InternalQueue before bringing it to Idle state by sending the Answer
    ParameterAVP_GET_FOLDER_ITEM_METHOD_RETURN(OUT parameterString,IN size,IN REQ_NOT_OK,IN SCOPE_MP_VFS,IN 0,IN NULL,IN 0,IN NULL);
    SendAnswer(IN parameterString);
    return 1;
}
tResult BTControl::StartRetryPlayTimer()
{
    ENTRY
    tResult result = MP_NO_ERROR;
    long timerMS = RETRIAL_TIME_INTERVAL;

    //Stop already existing timer for retrial of play.
    if(DEFAULT_TIMER_ID != mRetryPlayTimerID)
    {
        result = StopRetryPlayTimer();
    }

    if(MP_NO_ERROR == result)
    {
        /* create play retrial timer */
        mRetryPlayTimer.StartTimer(OUT mRetryPlayTimerID, IN timerMS, IN timerMS, IN this, IN &RetryPlayTimerCallBack, IN (void *)NULL);
        mRetryPlayTimerCount = 0;
    }
    else
    {
        ETG_TRACE_USR4(("BTControl::StartRetryPlayTimer : StopRetryPlayTimer has failed , hence not Starting a timer for retrial of play"));
    }

    return MP_NO_ERROR;
}

tResult BTControl::StopRetryPlayTimer()
{
    ENTRY

    /* delete play retial timer */
    if(mRetryPlayTimerID)
    {
        mRetryPlayTimer.CancelTimer(IN mRetryPlayTimerID);
        mRetryPlayTimerID = DEFAULT_TIMER_ID;
        mRetryPlayTimerCount = 0;
    }

    return MP_NO_ERROR;
}

bool BTControl::RetryPlayTimerCallBack(timer_t timerID , void* instance, const void *userData)
{
    ENTRY
    ETG_TRACE_USR4(("BTControl::RetryPlayTimerCallBack is called for retrial of play"));
    BTControl *self = (BTControl *)instance;
    if(self != NULL)
    {
        if(PLAY_SENT != self->GetStateOfPlayinStartPlay())
        {
            tPlaybackAction playbackAction = PBA_PLAY;
            self->SendPlaybackActionToBTControl(playbackAction);
        }
        self->mRetryPlayTimerCount++;
        if(self->mRetryPlayTimerCount == MAX_NO_OF_PLAY_RETRIES)
        {
            //Time for Max number of retries is completed, so stop the play retrial timer, to avoid play command to device.
            self->StopRetryPlayTimer();
        }
    }
    return MP_NO_ERROR;
}

tResult BTControl::SetStateOfPlayinStartPlay(tStateOfPlayinStartPlay stateOfPlayinStartPlay)
{
    ENTRY
    Locker locker(&m_LockForStateOfPlayinStartPlay);
    VARTRACE(stateOfPlayinStartPlay);
    mStateOfPlayinStartPlay = stateOfPlayinStartPlay;
    return MP_NO_ERROR;
}

tStateOfPlayinStartPlay BTControl::GetStateOfPlayinStartPlay()
{
    ENTRY
    Locker locker(&m_LockForStateOfPlayinStartPlay);
    return mStateOfPlayinStartPlay;
}

void BTControl::SendPlaybackActionToBTControl(tPlaybackAction playbackAction)
{
    ENTRY

    tAllParameters parameterString="";
    size_t size = sizeof(parameterString);
    tNextPrevSkipCount nextPrevSkipCount = 1;
    tResult ret;
    ret = ParameterPLAYBACK_ACTION(OUT parameterString,
            IN size,
            IN m_CurrentMediaObject.deviceType,   //Not used in specific DeviceControl
            IN m_CurrentMediaObject.deviceID,     //Not used in specific DeviceControl
            IN m_CurrentMediaObject.fileName,     //Not used in specific DeviceControl
            IN m_CurrentMediaObject.mountPoint,
            IN playbackAction,
            IN nextPrevSkipCount);
    if(MP_NO_ERROR == ret)
    {
        ret = SendEventAnswerByName("PLAYBACK_ACTION" , "BTControlSM::PLAYBACK_ACTION_ANSWER_INTERNAL" , parameterString);
        RegisterReleaseEvent(PLAYBACK_ACTION_ANSWER_INTERNAL);
    }
    else
    {
        ETG_TRACE_ERR(("BTControl::SendPlaybackActionToBTControl PLAYBACK_ACTION parameter not formed sucessfully"));
    }
}

tResult BTControl::MoveToRootAndClearBTCache()
{
    ENTRY

    RegisterReleaseEvent(MOVE_TO_ROOT_AND_CLEAR_BT_CACHE_DONE);
    //Move the path to Root before clearing the cache.

    const char* path = "/";

    tResult Result = ChangeFolderPath((const char*)path);
    VARTRACE(GetCurrentBrowsePath());



    // Delete related VTBluetooth cache .
    BTCacheDeleteOtherThanNowPlaying();

    //Clear all Browse Related Informations.

    tBool isInit = false;
    ClearBrowseInfoFlags(isInit);

    //Update to the clients(HMI) , that the Browse structure has been cleared.
    char msgToSendString[64];
    tAllParameters parameters;
    size_t paramSize = sizeof(parameters);

    strncpy_r(OUT msgToSendString, IN "CustomControlSM::UPDATE_FOLDER_BROWSE_STRUCTURE_CLEARED", IN sizeof(msgToSendString));

    Result = LocalSPM::GetCustomControl().ParameterUPDATE_FOLDER_BROWSE_STRUCTURE_CLEARED(OUT parameters, IN paramSize, IN mConnectedDeviceInfo.deviceID);
    if (MP_NO_ERROR != Result)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(Result)));
        parameters[0] = '\0';
    }

    Result = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameters);
    if (MP_NO_ERROR != Result)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(Result)));
    }

    StartNowplayingListUpdate();

    //Move SM back to idle.

    Result = SendEvent(MOVE_TO_ROOT_AND_CLEAR_BT_CACHE_DONE, IN NULL);

    return MP_NO_ERROR;
}

tMimeType ConvertToMimeType(const char* mimeType)
{
    ENTRY

    if((!strcmp(mimeType,"image/png")) || (!strcmp(mimeType,"png")))
        return MMT_PNG;

    if((!strcmp(mimeType,"image/x-ms-bmp")) || (!strcmp(mimeType,"bmp")))
        return MMT_BMP;

    if((!strcmp(mimeType,"image/gif")) || (!strcmp(mimeType,"gif")))
        return MMT_GIF;

    if((!strcmp(mimeType,"image/jpeg")) || (!strcmp(mimeType,"jpeg")) || (!strcmp(mimeType,"jpg")))
        return MMT_JPG;

    ETG_TRACE_ERR(("Unknown mime type (%s)",mimeType));

    return MMT_PNG;
}

void BTControl::DoGetAlbumArtThread (const tAlbumArt albumArtString)
{
    ENTRY;

    tResult result = MP_NO_ERROR;

    tAlbumArtObjectPtr albumArtObjectPtr = 0;

    //Remove mountpoint to get the file path
    string sAlbumArtString = string((const char*)albumArtString);
    size_t pos = sAlbumArtString.find_first_of("/");
    string albumArtpath  = sAlbumArtString.substr(pos);

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    result = GetAlbumArtFromSeparateFile(OUT albumArtObjectPtr, IN albumArtpath);


    if((MP_NO_ERROR == result) && albumArtObjectPtr)
    {
        ETG_TRACE_USR4(("BTControl:: DoGetAlbumArtThread:: Read succesfull "));
        VARTRACE(albumArtString);
        strncpy_r(OUT albumArtObjectPtr->albumArtString, IN albumArtString, IN sizeof(albumArtObjectPtr->albumArtString));

        ParameterGET_ALBUM_ART_ANSWER(parameterString, size, IN albumArtObjectPtr);
    }
    else
    {
        ETG_TRACE_ERR(("BTControl:: DoGetAlbumArtThread:: Read albumArtObjectPtr is invalid "));
        ParameterGET_ALBUM_ART_ANSWER(parameterString, size, IN NULL);
    }

    SendEvent(GET_ALBUM_ART_ANSWER, IN parameterString);
}

tResult BTControl::GetAlbumArtFromSeparateFile(tAlbumArtObjectPtr &albumArtObjectPtr, const std::string albumArtpath)
{
    ENTRY
    tResult result = MP_NO_ERROR;

    if(!albumArtpath.empty())
    {
        VARTRACE(albumArtpath.c_str());

        /* get the file size */
        struct stat statBuffer;
        unsigned long imageSize = 0;

        /* allocate memory */
        if (albumArtObjectPtr)
        {
            delete albumArtObjectPtr;
        }

        albumArtObjectPtr = new tAlbumArtObject;    //Has to be deleted by the user i.e DataProvider
        if(NULL != albumArtObjectPtr)
        {
            FILE *fpImage = NULL;

            /* read in the file */
            fpImage = fopen(albumArtpath.c_str(), "rb");
            if (fpImage)
            {
                if (!fstat(fileno(fpImage), &statBuffer))
                {
                    if (statBuffer.st_size >= 0)
                    {
                       imageSize = statBuffer.st_size;
                    }
                }
                unsigned long maxImageSize = (unsigned long)(LocalSPM::GetDataProvider().MaximumAlbumArtSizeInMB() * 1024 * 1024);

                if((imageSize == 0) || (imageSize > maxImageSize))
                {
                    ETG_TRACE_USR4((" Invalid ImageSize (%lu)", imageSize));
                    result= MP_ERR_BT_ALBUMART_FAILURE;
                }
                else
                {
                    /* Fill in required fields */
                    albumArtObjectPtr->imageSize = (tImageSize)imageSize;

                    /* Store image data */
                    albumArtObjectPtr->imageData = (tImageData)malloc(imageSize);
                    if(albumArtObjectPtr->imageData)
                    {
                        size_t readResult = fread(albumArtObjectPtr->imageData, 1, imageSize, fpImage);
                        if(readResult != imageSize)
                        {
                            ETG_TRACE_ERR((" Reading error! "));
                            VARTRACE(readResult);
                            result = MP_ERR_BT_ALBUMART_FAILURE;
                        }
                        //TODO get extension from image
                        albumArtObjectPtr->mimeType = MMT_PNG;
                    }
                    else
                    {
                        ETG_TRACE_ERR(("invalid  albumArtObjectPtr->imageData  error! "));
                        delete albumArtObjectPtr;
                        albumArtObjectPtr = NULL;
                        result = MP_ERR_BT_ALBUMART_FAILURE;
                    }
                }

                fclose(fpImage);

                if(result == MP_NO_ERROR )
                {
                    FillImageInfo(IN albumArtpath,OUT albumArtObjectPtr);
                }
            }
            else
            {
                ETG_TRACE_ERR((" Image open failed! "));
                result = MP_ERR_BT_ALBUMART_FAILURE;
            }
        }
        else
        {
            ETG_TRACE_ERR((" Memory allocation failed! "));
            result = MP_ERR_BT_ALBUMART_FAILURE;
        }
    }
    else
    {
        ETG_TRACE_ERR((" invalid albumart path! "));
        result = MP_ERR_BT_ALBUMART_FAILURE;
    }
    VARTRACE(result);

    return result;
}


tResult BTControl::AlbumArtAnswerNotConsumed(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY;

    if (ptrToAlbumArtObject)
    {
        if (ptrToAlbumArtObject->imageData)
        {
            free(ptrToAlbumArtObject->imageData);
        }
        delete ptrToAlbumArtObject;
        ETG_TRACE_USR3(("AlbumArt buffer cleared"));
    }

    return MP_NO_ERROR;
}


tResult BTControl::AvpGetImageMethodReturn(tURL fullpath)
{
    ENTRY

    VARTRACE(fullpath);

    /* Form albumartstring with mountpoint so that when GetAlbumArt is requested from HMI, device ID can be obtained from DB using the mountpoint - DBManager::GetDeviceFromAlbumArtString().*/
    tURL albumartstring;
    strncpy_r(OUT albumartstring, IN (const char *)(mConnectedDeviceInfo.mountPoint), IN sizeof(albumartstring));
    strncat_r(OUT albumartstring, IN (const char *)(fullpath), IN sizeof(albumartstring));

    mCurrentAlbumartPath = albumartstring;
    std::string objectIDmatcher=GetObjectIDMatcher(m_CurrentMediaObject.objectID);

    //Update the albumart only if the album art received for current track.
    if(mCurrentAlbumartPath.find(objectIDmatcher) != std::string::npos)
    {
        /* Set album art */
        strncpy_r(OUT m_CurrentMediaObject.albumArtString, IN albumartstring, IN sizeof(m_CurrentMediaObject.albumArtString));

        /* Update Now Playing status */
        tResult ret = MP_NO_ERROR;
        tAllParameters parameterString;
        size_t size_1 = sizeof(parameterString);
        char messageString_1[64];
        strncpy_r(OUT messageString_1, IN "PlayerManagerSM::NOW_PLAYING_STATUS", IN sizeof(messageString_1));
        ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString, IN size_1, IN m_CurrentMediaObject.objectID, IN m_CurrentMediaObject.MetadataField1,
                IN m_CurrentMediaObject.MetadataField2, IN m_CurrentMediaObject.MetadataField3, IN m_CurrentMediaObject.MetadataField4, IN m_CurrentMediaObject.MetadataField3,IN MTY_AUDIO_STREAM, IN (tBitRate)0, IN (me::samplerate_i)0, IN ACF_UNKNOWN,IN (tConvertFlag)0,IN NULL,IN m_CurrentMediaObject.albumArtString);
        if (MP_NO_ERROR != ret) {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
            parameterString[0] = '\0';
        }
        Dispatcher::GetInstance().SendMessage( IN messageString_1, IN parameterString);

        SendAlbumArtStatusToPlayerManager(true);
    }

    return MP_NO_ERROR;
}


void BTControl::SetCoverArtConStatus(tCoverArtConStatus coverArtConStatus)
{
    ENTRY
    mConnectedDeviceInfo.coverArtConStatus = coverArtConStatus;
}

void BTControl::StartNowplayingListUpdate()
{
    ENTRY
    if(LocalSPM::GetDataProvider().BtNowPlayingListSupport())
    {
        RemoveTaskFromVector(FUNCTION_ID_CALCULATE_ITEM_COUNT);
        tTaskContext newTaskContext;
        try
        {
            newTaskContext.parameters = new char[sizeof(tAllParameters)];
        }
        catch(...)
        {
            ETG_TRACE_ERR(("Exception in StartNowplayingListUpdate()"));
            return;
        }

        std::string argPath = "/NowPlaying";
        newTaskContext.taskId = FUNCTION_ID_CALCULATE_ITEM_COUNT;

        SMF::Marshal(newTaskContext.parameters, (sizeof(tAllParameters) - 1), DOUBLE_MARSHAL_SEPARATOR, "tiiiii", argPath.c_str(),0,0,0,0,0);
        AddTaskToVector(newTaskContext);
    }
    else
    {
        ETG_TRACE_USR4(("Bluetooth NowPlaying list not supported."));
    }
}
tResult BTControl::PlayReturnError()
{
    ENTRY;
    tResult result = MP_NO_ERROR;

    //Workaround(TRY TO REMOVE FOR SCOPE 3.0 WITH CLEAN SOLUTION) - Unlock BTControlSM InternalQueue for Read.
    /*Issue Resolved: Being in "WaitingForPathChange" state,BTControl thread read "PLAY" event and locked the InternalQueue.
     *MessageNotConsumed(..) handled PLAY and it left InternalQueue remain locked! - NO HEALING in this IGN CYCLE. */

    tMetadata metadata = { 0 };
    result = PlaybackStatus(IN PE_PBS_LOADINGSTATE, IN metadata, IN metadata, IN metadata, IN metadata,IN OBJECT_ID_NONE);
    return result;
}
tResult BTControl::PlaybackAction(const tDeviceType deviceType, const tDeviceID deviceID, const tURL URL,const tMountPoint mountPoint, const tPlaybackAction playbackAction, const tNextPrevSkipCount skipcount)
{
    ENTRY

    // Send error as this event is not consumed in the idle state.
    tPEHandle handle = 0;
    tPEPlaybackState playbackState = GetCurrentPlaybackState();
    me::reason_e reason = REASON_OK;
    me::speed_e speed = ME_SPEED_NONE;

    PlaybackStatusNew(handle , playbackState , reason ,speed);
    (void) deviceType;
    (void) deviceID;
    (void) URL;
    (void) mountPoint;
    (void) playbackAction;
    (void) skipcount;
    return MP_NO_ERROR;

}

tResult BTControl::StartSeekTo(const tDeviceType deviceType, const tDeviceID deviceID, const tURL URL, const tMountPoint mountPoint, const tPlaytime position)
{
    ENTRY;

    ETG_TRACE_USR3(("BTControl::StartSeekTo()"));
    VARTRACE(deviceType);
    VARTRACE(deviceID);
    VARTRACE(URL);
    VARTRACE(mountPoint);
    VARTRACE(position);

    /*
     * SeekToPosition is not supported due to restriction in BT Stack
     */

    //Send SEEK_TO_ANSWER message to release own waiting state
    SendEvent(SEEK_TO_ANSWER, IN NULL);

    //Send answer to calling SM(DeviceDispatcherSM)
    SendAnswer(IN NULL);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

void BTControl::FillImageInfo(const std::string imagePath, tAlbumArtObjectPtr & albumArtObjectPtr)
{
    ENTRY

    FREE_IMAGE_FORMAT fif = FIF_UNKNOWN;
    fif = FreeImage_GetFileType(imagePath.c_str(), 0);
    FIBITMAP *dib = FreeImage_Load(fif, imagePath.c_str());
    BITMAPINFO * imageInfo = NULL;

    //TODO this function has to be improved for getting image size and image type also.
    albumArtObjectPtr->sizeX = 256;
    albumArtObjectPtr->sizeY = 256;

    if((NULL != dib) && (NULL != dib->data))
    {
        BITMAPINFO * imageInfo = FreeImage_GetInfo(dib);
        if(imageInfo)
        {
            albumArtObjectPtr->sizeX = imageInfo->bmiHeader.biHeight;
            albumArtObjectPtr->sizeY = imageInfo->bmiHeader.biWidth;
        }
        FreeImage_Unload(dib);
    }
}

tResult BTControl::SendAlbumArtStatusToPlayerManager(const tBool albumartAvailable)
{
    ENTRY

    VARTRACE(albumartAvailable);
    tResult ret = MP_NO_ERROR;

    /* Send ALBUM_ART_STATUS message to PlayerManger to update album art */
    char messageString[64];
    strncpy_r(messageString, "PlayerManagerSM::ALBUM_ART_STATUS",
            sizeof(messageString) - 1);
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterALBUM_ART_STATUS(OUT parameterString, IN size, IN m_CurrentMediaObject.objectID, IN albumartAvailable);
    if (MP_NO_ERROR != ret) {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
        parameterString[0] = '\0';
    }
    return Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
}

void BTControl::SetCoverArtInfo(const tBTCoverArtInfo coverartInfo)
{
    ENTRY

    Locker locker(&m_CoverartInfoLock);

    mLatestCoverartInfo = coverartInfo;
}

void BTControl::ClearCoverArtInfo()
{
    ENTRY

    Locker locker(&m_CoverartInfoLock);

    InitBTCoverArtInfo(mLatestCoverartInfo);
}

tBTCoverArtInfo BTControl::GetCoverArtInfo()
{
    ENTRY

    Locker locker(&m_CoverartInfoLock);

    return mLatestCoverartInfo;
}

void BTControl::DeleteCurrentAlbumart()
{
    ENTRY

    if(!mCurrentAlbumartPath.empty())
    {
        size_t pos = mCurrentAlbumartPath.find_first_of("/");
        string albumArtpath  = mCurrentAlbumartPath.substr(pos);
        mCurrentAlbumartPath.clear();

        VARTRACE(albumArtpath.c_str());
        if(unlink(albumArtpath.c_str())!=0)
        {
            ETG_TRACE_ERR(("Failed to unlink CurrentAlbumArt :%s ",albumArtpath.c_str()));
        }
        else
        {
            ETG_TRACE_USR3(("Unlinked CurrentAlbumArt :%s ",albumArtpath.c_str()));
        }
    }
}

std::string BTControl::GetObjectIDMatcher(const tObjectID &objectID)
{
    ENTRY

    std::stringstream ss;
    ss<< objectID;
    return ("nowplaying_" + ss.str() + "_");
}

int BTControl::TrackChanged()
{
    ENTRY

    tResult ret= MP_NO_ERROR;
    DeleteCurrentAlbumart();
    ret = SendEvent(TRACK_CHANGED_DONE,NULL);
    return ret;
}

