/**
 * @addtogroup iPodControl
 * @author Ulrich Deuper
 *
 * iPod common header
 * @{
 */

#ifndef IPODCONTROLCOMMON_H_
#define IPODCONTROLCOMMON_H_

//*** ADIT / PLATFORM ****
//IAP1 defines
#define IPOD_USB
#define IPOD_USB_AUDIO_NO_STREAMING
#define IPOD_MULTIPLE_IPOD

//macro for Gen3 support, additional id parameter is handed over with each iAP call
#ifdef TARGET_BUILD_GEN3
#define IPODCONTROL_ID_TYPE U32
#define IPODCONTROL_ID_FRONT (U32) m_HandleMap.GetiPodID(m_MountPoint),
#define IPODCONTROL_ID_END , (U32) iPodID
#define IPODCONTROL_ID_ONLY (U32) m_HandleMap.GetiPodID(m_MountPoint)
#define IPODCONTROL_ID_END_PARAM , const U32 iPodID
#else
#define IPODCONTROL_ID_TYPE S32
#define IPODCONTROL_ID_FRONT
#define IPODCONTROL_ID_END
#define IPODCONTROL_ID_ONLY
#define IPODCONTROL_ID_END_PARAM
#endif

#ifdef TARGET_BUILD
# define IAP1_DLT_ENABLE
#endif

//IAP1 includes

#ifdef TARGET_BUILD
#include "iap_common.h"
#include "ipodcommon.h"
#else
#include "x86/ipod/iap_common.h"
#include "x86/ipod/ipodcommon.h"
#endif

//IAP2 defines
#if !defined(TARGET_BUILD) || defined(TARGET_BUILD_GEN3)
#define IPODCONTROL_IAP2_PF_AVAIL //obsolete once PF supports IAP2
#endif

#define IPODCONTROL_IAP2_PF_CONFIGFS
#ifdef VARIANT_S_FTR_ENABLE_CONFIGFS
#define IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
#endif
#ifdef TARGET_BUILD
#define IPODCONTROL_IAP2_PF_CONTROLSESSION_CONFIG
#endif

#ifndef IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
#  define IPODCONTROL_IAP2_PF_UDC
#endif

#ifndef GEN3X86
# define IPODCONTROL_IAP2_PF_R22 //enable R22 and R23 extensions
#endif

#ifdef TARGET_BUILD
#define IPODCONTROL_IAP2_PF_R26 //R26 extensions
#endif
#ifdef IPODCONTROL_IAP2_PF_AVAIL

#ifdef TARGET_BUILD
# define IAP2_DLT_ENABLE
#endif

#define IAP2_USB_MAX_STRING_DESCRIPTOR_LENGTH              255
#define IPODCONTROL_IAP2_POLL_TIMEOUT_SECS                    1

#define IAP2_HID_COMPONENT_IDENTIFIER                         0x0000
#define IAP2_APPLE_VENDOR_IDENTIFIER                         0x05AC
#define IAP2_APPLE_PRODUCT_IDENTIFIER                       0x1200
#define STR_IAP2_APPLE_VENDOR_IDENTIFIER                    "05ac"
#define STR_IAP2_APPLE_PRODUCT_IDENTIFIER                   "1200"
#define IAP2_STRING_MAX                                        256
#define IAP2_NOW_PLAYING_UPDATE_PLAYBACK_APP_NAME_MUSIC     "Music"
#define IAP2_NOW_PLAYING_UPDATE_PLAYBACK_APP_BUNDLE_MUSIC   "com.apple.Music"

#define IAP2_NOW_PLAYING_UPDATE_PLAYBACK_APP_NAME_PANDORA   "Pandora"
#define IAP2_NOW_PLAYING_UPDATE_PLAYBACK_APP_BUNDLE_PANDORA "com.pandora"

//Role switch
#define MODULE_NAME_G_FFS                       "g_ffs"
#define MODULE_NAME_USB_F_NCM                   "usb_f_ncm"
#define MODULE_NAME_USB_F_UAC2                  "usb_f_uac2"
#define MODULE_NAME_U_EITHER                    "u_ether"
#define MODULE_NAME_USB_F_FS                    "usb_f_fs"
#define MODULE_NAME_LIBCOMPOSITE                "libcomposite"
#define MODULE_NAME_CONFIGFS                    "configfs"

#define FUNCTION_FS_NAME                        "ffs"
#define FUNCTION_FS_PATH                        "/dev/ffs"
#define FUNCTION_FS_TYPE                        "functionfs"
#define FUNCTION_FS_PATH_EP                     "/dev/ffs/ep0"

#define CONFIGFS_NAME                           "config"
#define CONFIGFS_PATH                           "/sys/kernel/config"
#define CONFIGFS_TYPE                           "configfs"
#define CONFIGFS_USB_GADGET_PATH                "/sys/kernel/config/usb_gadget"

#define STR_ROLE                                "role"
#define STR_GADGET                              "gadget"
#define STR_BRIDGE                              "bridgeport"
#define STR_HOST                                "host"

#define STR_VBUS_AUTO                           "vbus_auto"
#define STR_VBUS_AUTO_USB1                      "usb1/vbus_auto"
#define STR_ENABLE                              "enable"
#define STR_DISABLE                             "disable"

#define STR_UDC_PATH                            "/sys/class/udc"
#define STR_FORCE_UDC                           "udc_force"
#define STR_DEFAULT_UDC                         "defaultudc"

#define STR_ON                                  "on"
#define STR_OFF                                 "off"

#define STR_VALUE                               "value"
#define STR_DIRECTION                           "direction"
#define STR_OUT                                 "out"

#define STR_USB_ROLE_SWITCH_OTG_GLOB           "/sys/devices/soc.0/21*/2184*/*"
#define STR_USB_ROLE_SWITCH_OTG_GLOB2          "/sys/devices/soc0/soc.0/21*/2184*/*"    //kernel 3.14

#define STR_VBUS_GLOB                          "/sys/class/udc/*/device"

#define STR_VBUS                                "vbus"
#define STR_PORTPOWER                           "portpower"
#define STR_CONTROL                             "control"

//Microchip hub
/*

Mitsumi CarPlay_Sequence_Ver0.0.2_bosch.xlsx

bit   name            description
   0  RESERVED        This bit has no function, always 0?
   1  DIS_P1          Disables Port 1 after switching directions.
   2  DIS_P2          Disables Port 2 after switching directions.
   3  DIS_P3          Disables Port 3 after switching directions.
   4  DIS_P4          Disables Port 4 after switching directions.
   5  DIS_P5          Disables Port 5 after switching directions.
   6  FLEXCONNECT     The value of FLEXCONNECT after the Hub is re-attached.
   7  CHNG_PIN_FUNCT  This pin will change the digital pin controls back to the default
                      state. For example VBUS_DET has the same functionality
                      regardless of the FLEX state.
8-10  HD_TMR          Host Detect Timeout - The time the hub will wait for a Host to
                      enumerate before returning to the default state.
                      000 = No timeout
                      001 = 10ms
                      010 = 100ms
                      011 = 500ms
                      100 = 1s
                      101 = 5s
                      110 = 10s
                      111 = 20s
11-13  RESERVED       These bits have no function.
   14  DCP_EN         Enables the universal dedicated charging algorithm to be used
                      on disabled ports. This will cause the hub to enumerate limited
                      ports, but the VBUS and battery charging handshake will still
                      be present on the disabled ports.
   15  1              This must always be 1

*/

/*
Bit Name    Description
0   Reserved    Always 0 ?                                  0   0
1   DISP_P1 USE for Carplay (Value:0)                       0   0
2   DISP_P2 Don't use this port in carplay mode (Value:1)   1   1
3   DISP_P3 Don't use this port in carplay mode (Value:1)   1   1
4   DISP_P4 Don't use this port in carplay mode (Value:1)   1   1
5   DISP_P5 Don't use this port in carplay mode (Value:1)   1   1
6   FLEXCONNECT                                             1   1
        FLEXCONNECT signals after re-atach
        0=Carplay inactive
        1=Carplay active
7   CHG_PIN_FUNCT 0?                                        0   0
8   HD_TMR                                                  0   0
        Host detect time out
        000 = No time out
        001 = 10ms
        010 = 100ms
        011 = 500ms
        100 = 1s
        101 = 5s
        110 = 10s
        111 = 20s
9                                                           0   0
10                                                          1   1
11  Reserved    Always 0 ?                                  0   0
12  Reserved    Always 0 ?                                  0   0
13  Reserved    Always 0 ?                                  0   0
14  DCP_EN  Don't care (Always 0)                           0   0
15  Always 1                                                1   1

                1000    0100    0111    1100
                8   4   7   C
*/
#define MICROCHIP_CMD 0x847C

/* recipient is the bridge device, not the hub */
#define MICROCHIP_VID   0x0424
#define USB84604_PID    0x2530

#define MICROCHIP_VID_STR   "0424"
#define USB84604_PID_STR    "2530"

/* PIO 16-23 Direction Register */
#define PIO23_DIR 0x0831
/* PIO 16-23 Output Register */
#define PIO23_OUT 0x0835

#define MICROCHIP_PATH  "1-1.3" //"1-1.3.3"
#define MITSUMIPORT2ES2_PATH  MICROCHIP_PATH //"1-1.3.3"
#define MITSUMIPORT2ES4_PATH  MICROCHIP_PATH //"1-1.3.3"

//IAP2 includes
#include <sys/select.h>
#include <sys/poll.h>
#ifdef __cplusplus
extern "C" {
#endif

#ifdef TARGET_BUILD
# include "iap2_commands.h"
# include "iap2_external_accessory_protocol_session.h"
# include "iap2_parameter_free.h"
# include "iap2_usb_role_switch.h"
# ifdef IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
#  include "iap2_initialize_usb_gadget.h"
# endif
#else
# include "x86/ipod/iap2_commands.h"
# include "x86/ipod/iap2_external_accessory_protocol_session.h"
# include "x86/ipod/iap2_parameter_free.h"
# include "x86/ipod/iap2_usb_role_switch.h"
# include "x86/ipod/iap2_initialize_usb_gadget.h"
#endif

#ifdef __cplusplus
}
#endif
#endif

//*** GMP / APPLICATION ****
//defines
#define IPODCONTROL_HID_DEFAULT "/dev/usb/hiddev0"
#define IPODCONTROL_ALSA_DEFAULT "hw:1,0"
#define IPODCONTROL_UUID_FORMAT "%016llx"

#define IPODCONTROL_ITUNES_PLYLST_NAME "Radio"
#define IPODCONTROL_ITUNES_PLYLST_UUID 0xFFF0FFF0FFF0FFF0ULL

//defined for albumart
#define IPODCONTROL_ARTWORK_MAX 64

//defines for app control
#define IPODCONTROL_RESUME_IPOD 0x0E //should be defined in iap_types.h
#define IPODCONTROL_FOCUSAPP_RETRYS 10
#define IPODCONTROL_FOCUSAPP_RETRY_TIME 300
#define IPODCONTROL_FILE_WRITE_CHUNK 100

//defines for suspending iOS communication, due to e.g. ATS requirements, HID commands
#define IPODCONTROL_SUSPEND_MAX_MS 10000 //10secs max delay
#define IPODCONTROL_SLEEP_INTERVAL_MS 100

//basic includes
#include <map>
#include <string>
#include <string.h>
#include "TypeDefinitions.h"

//typedefs
#define IPODCONTROL_MARSHAL_FORMAT "tiiiiiiillti"
#define IPODCONTROL_MARSHAL_FORMAT_VTRECORD "iitttii"
#define IPODCONTROL_MARSHAL_FORMAT_FINGERPRINT_IAP2 "tttt"
#define IPODCONTROL_MARSHAL_FORMAT_APPCONTROL_COMMANDBUFFER "ttii" tCommandBufferPtr_format
#define IPODCONTROL_MARSHAL_SEPARATOR DOUBLE_MARSHAL_SEPARATOR

typedef map<int, string> tIPODDBRecords;
typedef map<unsigned, tIPODDBRecords *> tIPODDBRecordPtrMap;
typedef map<int, string> tIPODCategoryNames;
typedef map<int, int> tIPODCategoryCounts;

typedef struct {
    IPOD_TRACK_INFORMATION_TYPE type;
    IPOD_TRACK_INFORMATION_DATA data;
    string str;
} tIPODTrackInfo;

typedef multimap<int, tIPODTrackInfo> tIPODTrackInfos;
typedef map<unsigned int, tIPODTrackInfos *> tIPODTrackInfoPtrMap;
typedef map<int, string> tIPODChapterInfos;

typedef tIPODTrackInfos *tIPODTrackInfosPtr;
typedef tIPODDBRecords *tIPODDBRecordsPtr;

typedef struct
{
    tU8* buffer;
    tU64 size;
    tU64 rxLen;
    tU64 parentUUID;
} tPlaylistFileTransferObj;

typedef map<tU8, tPlaylistFileTransferObj> tIPODPlaylistFileTransfer; //key = FileTransferID

typedef struct {
    IPOD_TRACK_INFO_TYPE type;
    int artworkCount;
    int artworkFormatID;
    string str;
} tIPODPlayingTrackInfo;
typedef map<unsigned int, tIPODPlayingTrackInfo *> tIPODPlayingTrackInfoPtrMap;

typedef struct {
    tAppName appName;
    tProtocolName protocol;
    tBundleSeedID bundleID;
    tSessionID sessionID;
    tAppInfoOption option;
}tIPODAppInfo;

typedef enum {
    hasIAP2Option = 0,         /**< IAP2 support */
    hasVideoOption,         /**< video support */
    hasTrackInfoOption,     /**< advanced metadata extraction */
    hasTaggingOption,         /**< iTunes song tagging  */
    hasAlbumArtOption,         /**< album art */
    hasDeselectDBOption,     /**< call ReturnToPreviousDBRecord needed for old iPods */
    hasPlaySelectionOption, /**< call PlayCurrentSelection needed for old iPods */
    hasPlayPauseOption,     /**< separate play/pause commands */
    hasAppLaunchOption,     /**< launching iOS apps */
    hasExtPlayStatusOption, /**< extended play status notification */
    hasRemoteControlOption, /**< RC support via touch or Siri commands (iOS only) */
    hasDisplayImageOption,  /**< display image */
    hasBluetoothiAP2Link,   /**< bt iap link */
    hasLastOption = 31
} tiPodOptions;

typedef enum {
    atsPlayStatus = 0,         /**< call iPodGetPlayStatus */
    atsPlayingTrackInfo,     /**< call iPodGetIndexedPlayingTrackInfo */
    pbNotifications,         /**< playback notifications expected during this time window */
    hidSeekLead,            /**< fast forward/rewind detection via hid commands requires a time slice on iPod side (~1 second)  */
    iap2InitCallbacks,        /**< give some time to mediaLibraryInfo callback */
    iap2LastHostModeError,  /**< host mode error timeout */
    iapInitElapsed          /**< elapsed time since device init */
} tiPodElaspedTime;

typedef enum {
    IPODCONTROL_EXTENDED_STATUS_STOPPED = 0x02,             /**< stopped */
    IPODCONTROL_EXTENDED_STATUS_FFW_START = 0x05,         /**< FFW seek started */
    IPODCONTROL_EXTENDED_STATUS_REW_START = 0x06,         /**< REW seek started */
    IPODCONTROL_EXTENDED_STATUS_FFW_REW_STOPPED = 0x07,     /**< FFW/REW seek stopped */
    IPODCONTROL_EXTENDED_STATUS_PLAYING = 0x0A,             /**< playing */
    IPODCONTROL_EXTENDED_STATUS_PAUSED = 0x0B             /**< paused */
} IPODCONTROL_EXTENDED_PLAY_STATUS;

typedef enum {
    IPOD_INDEXER_STRATEGY_UNKNOWN = 0,         /*!< strategy uninitialized */
    IPOD_INDEXER_STRATEGY_IAP1_LEGACY,         /*!< STRATEGY 1 (iAP1 - Legacy, no trackinfos) */
    IPOD_INDEXER_STRATEGY_IAP1_TRACKINFO,    /*!< STRATEGY 2 (iAP1 - Trackinfo support) */
    IPOD_INDEXER_STRATEGY_IAP2                /*!< STRATEGY 3 (iAP2) */
} IPOD_INDEXER_STRATEGY;

typedef enum {
    IPOD_HID_REPORT_BUTTON_RELEASED = 0x00,        /*!< no button pressed*/
    IPOD_HID_REPORT_PLAY = 0x01,
    IPOD_HID_REPORT_PAUSE = 0x02,
    IPOD_HID_REPORT_SCAN_NEXT_TRACK = 0x04,
    IPOD_HID_REPORT_SCAN_PREVIOUS_TRACK = 0x08,
    IPOD_HID_REPORT_SHUFFLE = 0x10,
    IPOD_HID_REPORT_REPEAT = 0x20
} IPOD_HID_REPORT;

typedef enum {
    IPOD_OTG_NONE = 0,
    IPOD_OTG_TARGET,
    IPOD_OTG_UNWIRED,
    IPOD_OTG_MICROCHIP,
    IPOD_OTG_MITSUMI_PORT2ES2,
    IPOD_OTG_MITSUMI_PORT2ES4,
    IPOD_OTG_MOLEX
} IPOD_OTG_TYPE;

typedef struct
{
    U8* buffer;
    U64 size;
    U64 rxLen;
    U8 transferID;
} tFileXferBuf;

typedef struct
{
    U16 idVendor;
    U16 idProduct;
    char serial[255];
    char sysPath[256];
} iAP2USBDeviceInfo_t;

typedef struct
{
    struct udev* udev;
    struct udev_monitor* monitor;
    iAP2USBDeviceInfo_t deviceInfo;
} iAP2USBVendorRequestMonitor_t;

#endif /*IPODCONTROLCOMMON_H_*/

/** @} */
