
/**
 * @addtogroup Ipc
 * @author Dinesh D
 *
 * Define the IPC method calls to Player service
 *
 * @{
 */

#ifndef PLAYERENGINEIPCIF_H_
#define PLAYERENGINEIPCIF_H_

#include "IpcTypes.h"

#define IPC_PLAYER_ENGINE_SERVICE				"DBus.PlayerEngine"

/***PlayerEngine****************************************************************************************************************************************************************/

#define IPC_PLAYER_ENGINE_PATH					"/PlayerEngine"
#define IPC_PLAYER_ENGINE_INTERFACE				"local.PlayerEngine.PlayerEngine"

IPC_DECLARE_MESSAGE( ipc_PlayerEngine_CreatePlayerInstance, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_PATH,IPC_PLAYER_ENGINE_INTERFACE, "CreatePlayerInstance");

/***PlayerInstance********************************************************************************************************************************************************/

/*Note : Instance path is dynamically provide by the MV PlayerEngine .Here its assumed as "/PlayerEngine/0" for reference*/
#define IPC_PLAYER_ENGINE_INSTANCE_PATH			"/PlayerEngine/0"
#define IPC_PLAYER_ENGINE_INSTANCE_INTERFACE	"DBus.PlayerEngine"

IPC_DECLARE_MESSAGE( ipc_PlayerEngine_SwitchObserver	, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "SwitchObserver");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_RegisterObserver	, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "RegisterObserver");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_UnregisterObserver, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "UnregisterObserver");

IPC_DECLARE_MESSAGE( ipc_PlayerEngine_DeAllocateInDevice	 , IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "DeAllocateInDevice");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_DeAllocateOutDevice	 , IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "DeAllocateOutDevice");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_AssignAudioInputDevice , IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "AssignAudioInputDevice");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_AssignAudioOutputDevice, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "AssignAudioOutputDevice");

IPC_DECLARE_MESSAGE( ipc_PlayerEngine_PlaySlot	    , IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "PlaySlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_NewPlaySlot	, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "NewPlaySlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_DisplaySize       , IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "SetDisplaySize");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_PauseSlot     , IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "PauseSlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_ResumePlaySlot, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "ResumePlaySlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_StopSlot	    , IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "StopSlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_StartFfSlot	, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "StartFfSlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_StopFfSlot	, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "StopFfSlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_StartFrevSlot	, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "StartFrevSlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_StopFrevSlot	, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "StopFrevSlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_SeekToSlot	, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "SeekToSlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_CurrentTimeSlot,IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "CurrentTimeSlot");
IPC_DECLARE_MESSAGE( ipc_PlayerEngine_PlayFromDeviceSlot,IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "PlayFromDeviceSlot");

IPC_DECLARE_MESSAGE( ipc_PlayerEngine_SetVideoLayer	, IPC_PLAYER_ENGINE_SERVICE, IPC_PLAYER_ENGINE_INSTANCE_PATH,IPC_PLAYER_ENGINE_INSTANCE_INTERFACE, "SetVideoLayer");

/*******************************************************************************************************************************************************************/

#endif /*PLAYERENGINEIPCIF_H_*/

/** @} */
