/**
 * @addtogroup DeviceControl
 * @author Christian Koechling
 *
 * Public interface for MTP control
 * @{
 */

#ifndef _MTPLIBWRAPPER_H_
#define _MTPLIBWRAPPER_H_

#include "src/libmtp.h"

#define ISEQUAL   ( 0)
//----------------------------LIBMTP-Wrapper to ease simulating LIBMTP-functions for tests - see test/MTPLibWrapperTest----------------------------


class MTPLibWrapper
{
    public:

	MTPLibWrapper();
	virtual ~MTPLibWrapper();
    virtual void  wLIBMTP_INIT();
    virtual void  wLIBMTP_SetDebug(int const level);
    virtual void  wLIBMTP_destroy_file_t(LIBMTP_file_t *file);
    virtual char* wLIBMTP_Get_Modelname(IN LIBMTP_mtpdevice_t *pDevice);
    virtual char* wLIBMTP_Get_Friendlyname(IN LIBMTP_mtpdevice_t *pDevice);
    virtual char* wLIBMTP_Get_Serialnumber(IN LIBMTP_mtpdevice_t *pDevice);
    virtual char* wLIBMTP_Get_Deviceversion(IN LIBMTP_mtpdevice_t *pDevice);
    virtual char* wLIBMTP_Get_Manufacturername(IN LIBMTP_mtpdevice_t *pDevice);
    virtual char const* wLIBMTP_Get_Filetype_Description  ( LIBMTP_filetype_t const intype );

    virtual int   wLIBMTP_Get_Track_To_File (LIBMTP_mtpdevice_t *pDevice, uint32_t const id, char const *const path, LIBMTP_progressfunc_t const callback, void const *const  data);
    virtual void  wLIBMTP_destroy_track_t(LIBMTP_track_t * track);
    virtual void  wLIBMTP_Release_Device(IN LIBMTP_mtpdevice_t* device);

    virtual LIBMTP_track_t          *wLIBMTP_Get_Trackmetadata(IN LIBMTP_mtpdevice_t *device, IN uint32_t const trackid);
    virtual LIBMTP_error_number_t   wLIBMTP_Get_Connected_Devices(INOUT LIBMTP_mtpdevice_t **  device_list);
    virtual int                     wLIBMTP_Get_Storage(IN LIBMTP_mtpdevice_t* device, IN int const sortby);
    virtual LIBMTP_mtpdevice_t      *matchDevice2MountPoint(IN char* serialNumber,IN char* deviceVersion, IN char* deviceName);
    tFileFormat                     ConvertMTPFileType( LIBMTP_filetype_t const intype );
    virtual LIBMTP_file_t           *wLIBMTP_Get_Item(IN LIBMTP_mtpdevice_t* device, IN uint32_t const storageid, IN uint32_t const parentid,IN int32_t *readindex);
    virtual tU16                    wLIBMTP_ReadFiles(IN LIBMTP_mtpdevice_t *pDevice, IN uint32_t const storageid, IN uint32_t const parentid);

private:
    bool m_bInitialised;
    Lock m_MTPWrapperLock;

};

#endif

/** @} */
