/*
 * BTDaemonProxy.h
 *
 *  Created on: Oct 16, 2013
 *      Author: din3kor
 */

#ifndef GRACENOTEPROXY_H_
#define GRACENOTEPROXY_H_

#include <map>
#include <sstream>
#include <iostream>
#include <netinet/in.h>
#include "IPCProvider.h"
#include "Timer.h"

class GracenoteProxy : public IPCListener
{
public:
    /*
     * returns singleton instance of BTDaemony proxy class
     **/
    static GracenoteProxy &GetInstance();

    /*
     * constructor
     */
    GracenoteProxy(void);

    /*
     * returns true if the message name belongs to Gracenote service interface
     */
    bool belongs(const char* messageName, const char* params) ;

    /*
     * returns true if the serial belongs to Gracenoteservice communication
     */
    bool belongs(tU32 serial) ;

    /*
     * receives the dbus signal from the Gracenote and taken necessary action
     */
    void RouteSignal(const char* name, const char* params) ;

    /*
     * receives the dbus method answer from the Gracenote                                  and taken necessary action
     */
    void RouteMethodAnswer(tU32 serial, const char* params) ;

    /*
     * receives the dbus method request from the Gracenote and taken necessary action
     */
    void RouteMethodRequest(tU32 serial, const char* name, const char* params) ;

    /*
     * receives the dbus error message from the Gracenote and taken necessary action
     */
    void RouteError(tU32 serial, const char* error) ;


    /*Method calls to Gracenote Agent*/
    tResult InitSettingsMethodCall(tGracenoteLookupMode lookupMode );
    tResult FetchAlbumInfoMethodCall(tU32 numberOfTracks,tStartAddressArray startingAddress);
    tResult FetchMetadataInfoMethodCall(tU32 albumID);
    tResult FetchAlbumArtInfoMethodCall(const tAlbumArtPath path,tU32 albumID);
    tResult FetchAlbumInfoMethodCall(const char* TOCInfo);


    tResult SwitchObserver(const tDeviceType smName);
    void SetGracenoteDatabseLookUpMode(tGracenoteLookupMode lookupMode);
    void GetGracenoteDatabseLookUpMode(tGracenoteLookupMode &lookupMode);

    void GetGracenoteVersion(tGracenoteVersion &version);
private:

    /*Method Response / Error response callback handlers */
    void InitSettingsMethodReturn(const char* params,bool isError);
    void FetchAlbumInfoMethodReturn(const char* params,bool isError);
    void FetchMetadataInfoMethodReturn(const char* params,bool isError);
    void FetchAlbumArtInfoMethodReturn(const char* params,bool isError);

    //void propertiesChangedSignal(const char* params);





    typedef void (GracenoteProxy::*MessageHandler)(const char* params,bool isError); /**< signature of generic message/error handler function */
    typedef void (GracenoteProxy::*SignalHandler)(const char* params); /**< signature of generic message handler function */
    map<tU32, MessageHandler> mMessageHandlers;	/**< map of DBus serial and specific message handler function */
    Lock mMessageHandlersMutex;                                       /**< lock for accessing mMessageHandlers map */
    tBoolean mIsCDRipperControlActive;

    void setRipperControlState(bool bIsActive);
};

#endif /* GRACENOTEPROXY_H_ */
