/**
 * @addtogroup Ipc
 * @author Reenuhaa Pechi S
 *
 * Define the IPC me::speed_ethod calls to Alps-bt-daemon service
 *
 * @{
 */

#ifndef GRACENOTEIPCIF_H_
#define GRACENOTEIPCIF_H_

#include "IpcTypes.h"


/***gracenote dbus service****************************************************************************************************************************************************************/

#define IPC_GRACENOTE_SERVICE	"com.bosch.MediaAgentService"
#define IPC_GRACENOTE_PATH	"/com/bosch/MediaAgent/Gracenote"
#define IPC_GRACENOTE_BASEOBJECT_PATH "/com/bosch/MediaAgent/Gracenote"
#define IPC_GRACENOTE_INTERFACE                             "com.bosch.MediaAgentService.GracenoteInterface"
#define IPC_GRACENOTE_PROPERTY_INTERFACE                    "org.freedesktop.DBus.Properties"
#define IPC_GRACENOTE_OBJECT_PATH                           "/com/bosch/MediaAgent/Gracenote"


//Methods Related to Playback
IPC_DECLARE_MESSAGE( ipc_Gracenote_InitSettings , IPC_GRACENOTE_SERVICE, IPC_GRACENOTE_PATH,IPC_GRACENOTE_INTERFACE  , "InitSettings");
IPC_DECLARE_MESSAGE( ipc_Gracenote_FetchAlbumInfo  , IPC_GRACENOTE_SERVICE, IPC_GRACENOTE_PATH,IPC_GRACENOTE_INTERFACE  , "FetchAlbumInfo");
IPC_DECLARE_MESSAGE( ipc_Gracenote_FetchMetadataInfo , IPC_GRACENOTE_SERVICE, IPC_GRACENOTE_PATH, IPC_GRACENOTE_INTERFACE  , "FetchMetadataInfo");
IPC_DECLARE_MESSAGE( ipc_Gracenote_FetchAlbumArtInfo  , IPC_GRACENOTE_SERVICE, IPC_GRACENOTE_PATH, IPC_GRACENOTE_INTERFACE  , "FetchAlbumArtInfo");


//Methods Related to Properties
IPC_DECLARE_MESSAGE ( ipc_Gracenote_Get , IPC_GRACENOTE_SERVICE, IPC_GRACENOTE_PATH,IPC_GRACENOTE_PROPERTY_INTERFACE  , "Get");
IPC_DECLARE_MESSAGE ( ipc_Gracenote_Set , IPC_GRACENOTE_SERVICE, IPC_GRACENOTE_PATH,IPC_GRACENOTE_PROPERTY_INTERFACE  , "Set");


#endif /*GRACENOTEIPCIF_H__*/

/** @} */
