/*
 * CDDADeviceInterface.h
 *
 *  Created on: Jun 11, 2015
 *      Author: thm3hi
 */

#ifndef _CDDA_DEVICE_INTERFACE_H_
#define _CDDA_DEVICE_INTERFACE_H_

#include "TypeDefinitions.h"
#include "Timer.h"

#include <sys/ioctl.h>
#include <scsi/sg.h> /* take care: fetches glibc's /usr/include/scsi/sg.h */
#include <scsi/scsi.h>
#include <linux/cdrom.h>

#define CD_INVALID 0
#define CD_VALID   1

#define CD_SCSI_IF_TOC_ENTRY_LEN           8
#define CD_SECONDS_PER_MINUTE       60
#define CD_SECTORS_PER_SECOND       75
#define CDAUDIO_CDTEXT_TEXT_BUFFER_LEN      256 /*255 bytes text+trailing zero*/

//#define CD_SCSI_IF_SG_CMD_00_1F_LEN        6
//#define CD_SCSI_IF_SG_CMD_20_5F_LEN        10
//#define CD_SCSI_IF_SG_CMD_A0_BF_LEN        12
//#define CD_SCSI_IF_SG_RESPONSE_HEADER_LEN  4
//#define CD_SCSI_IF_SG_RESPONSE_BUFFER_LEN  96
//#define CD_SCSI_IF_SG_TOC_BUFFER_LEN       1200
//#define CD_SCSI_IF_SG_SENSE_BUFFER_LEN     18
//#define CD_SCSI_IF_SG_INQUIRY_BUFFER_LEN   96
#define CD_SCSI_IF_SG_CMD_TIMEOUT_MS       20000
#define CD_SCSI_IF_SG_TOC_BUFFER_LEN       1200
#define CDAUDIO_ATA_CDTEXT_RAW_BUFFER_LEN  5000

#define CD_8TO16(_HI_,_LO_)   ((((unsigned short)(_HI_)) << 8) | ((unsigned short)(_LO_)&0xFF))
#define CD_MSF2ZLBA(M,S,F)     (((unsigned int)(M) * CD_SECONDS_PER_MINUTE  \
                               + (unsigned int)(S)) * CD_SECTORS_PER_SECOND \
                               + (unsigned int)(F))
#define CD_8TO32(_3_,_2_,_1_,_0_) (((unsigned int)(_3_) << 24) |\
                                   ((unsigned int)(_2_) << 16) |\
                                   ((unsigned int)(_1_) << 8 ) |\
                                   ((unsigned int)(_0_)))

#define CD_32BIT_B0(_X_) ((unsigned char)((_X_) & 0xFF))
#define CD_32BIT_B1(_X_) ((unsigned char)(((_X_) & 0x0000FF00UL) >> 8))
#define CD_32BIT_B2(_X_) ((unsigned char)(((_X_) & 0x00FF0000UL) >> 16))
#define CD_32BIT_B3(_X_) ((unsigned char)(((_X_) & 0xFF000000UL) >> 24))

#define RESPONSE_ON true
#define RESPONSE_OFF false

typedef struct
{
  unsigned int u32StartZLBA;
  unsigned char u8AdrCtrl;
} tCDTrack;

typedef struct
{
    unsigned char u8Valid;
    unsigned char u8MinTrack;
    unsigned char u8MaxTrack;
    unsigned int u32LastZLBA;
  tCDTrack arTrack[CD_TRACK_ARRAY_SIZE + 1]; /*+1: satisfy l i n t*/

} tCDTOC;

typedef struct
{
  unsigned char u8Min;
  unsigned char u8Sec;
  unsigned char u8Frm;
} tCDMSF;

typedef enum
{
    CD_AUDIO_STATUS_INVALID = 0x00,
    CD_AUDIO_STATUS_PROGRESS = 0x11,
    CD_AUDIO_STATUS_PAUSED = 0x12,
    CD_AUDIO_STATUS_COMPLETED = 0x13,
    CD_AUDIO_STATUS_ERROR = 0x14,
    CD_AUDIO_STATUS_NONE = 0x15
} tCDAudioStatus;

typedef enum
{
    eCDS_AUDIO = 100,
	eCDS_DATA_1,
	eCDS_DATA_2,
	eCDS_XA_2_1,
	eCDS_XA_2_2,
	eCDS_MIXED
}tCdromDiskStatus;
using namespace me;
struct cdstate_t {
      cdstate_t() : playstate(PLAYSTATE_NOP), reason(REASON_OK), handle(-1),
         speed(ME_SPEED_NONE),url("none"){
          pos_bytes = 0;
          pos_pct = 0;
          pos_ms = 0;
          dur_bytes = 0;
          dur_ms=0;
      }
      cdstate_t(playstate_e const &ps0) : playstate(PLAYSTATE_NOP),
         reason(REASON_OK), handle(-1), speed(ME_SPEED_NONE),url("none"){ // ctor delegation;
         playstate = ps0;
         pos_bytes = 0;
         pos_pct = 0;
         pos_ms = 0;
         dur_bytes = 0;
         dur_ms=0;
      }
      me::playstate_e     playstate;
      me::reason_e           reason;
      tPEHandle              handle;
      tS64               pos_bytes;
      tS64                 pos_pct;
      tS64                  pos_ms;
      tS64               dur_bytes;
      tS64                  dur_ms;
      me::speed_e             speed;
      std::string               url;	  
   };

class CDDADeviceInterfaceCallback {
public:
    virtual void update(cdstate_t const &currentState) { };
    virtual void resendNowPlaying(tBoolean resend) { };   //NCG3D-22900
};

class CDDADeviceInterface
{
public:
    CDDADeviceInterface();
    virtual ~CDDADeviceInterface();

    tResult init();
    void registerCallbacks(CDDADeviceInterfaceCallback *callbacks);
    tResult getToc(OUT tFiles *tocDataOneTrack, IN const tMountPoint mountpoint, IN const tPath path, IN const tIndex index);
    tResult play(IN const tURL url, IN const me::speed_e speed, IN const tPlaytime position, IN const tPEHandle handle);
    tResult pause();
    tResult resume();
    tResult stop();
    tResult seek(IN const me::speed_e speed, IN const tPlaytime position);
    tResult frevStart(tCueingRate rate);
    tResult frevStop();
    tResult ffwdStart(tCueingRate rate);
    tResult ffwdStop();
    void getParameter(OUT tPEHandle &handle,
            OUT tPEPlaybackState &peState, OUT me::reason_e &reason, OUT me::speed_e &speed);
    CDDADeviceInterfaceCallback *mCallbacks;
    cdstate_t mCurrentState;
    tPEPlaybackState mCurrentPlaybackState;
    tPEPlaybackState mPreviousPlaybackState;
    tPEMilliseconds mScanEndElapsedTime;

    int cdIOControl(int command, void *buffer);
    void resetToc();
    void resetAudioStatus();    //NCG3D-22900
    void update();
    void startUpdateTimer();
	#if !defined(TARGET_BUILD) 
    void TestsetCDText(unsigned char *ref, tU16 size, tU8 totalTrack);
	#endif
private:
    static bool TimerCallBack(timer_t /*timerID*/ , void* /*instance*/,const void *userData);
    //void startUpdateTimer();    //NCG3D-22900. moved to public
    void stopUpdateTimer();
    //void update();    //NCG3D-22900. moved to public
    void extractDeviceFileNames(const tMountPoint mountpoint);
    int run_SG_IO_Command();
    void prepare_SG_IO_Command(bool awaitingResponse, int commandLen);
    tResult setCDText(unsigned int u32ATACDTextLen);
    void vZLBA2MSF(unsigned int u32ZLBA, tCDMSF *pMSF);
    void vMSFBCD2Decimal(const cdrom_msf0 &bcd, tCDMSF &dec);
    tResult readToc(IN const tMountPoint mountpoint);
    int cdGetCmdLen(int SGIOCommand);
    tResult SetSpeed(int speed);
    int convertBCDtoDecimal(char bcd);
    tResult playAfterStop(cdrom_subchnl pSubChnl);
    int cdCtrlInfo(int command);
    timer_t mUpdateTimerID;
    Timer mUpdateTimer;
    bool mTimerAlreadyRunning;
    bool mStartPlay;
    tGeneralString mDevSr;
    sg_io_hdr_t mSCSICommandBuffer;
    unsigned char mCommandBuffer[16];
    unsigned char mSenseBuffer[18];
    unsigned char mResponseBuffer[CDAUDIO_ATA_CDTEXT_RAW_BUFFER_LEN];
    tCDTOC mToc;
    bool mTocRead;
    tFiles *mCDContents;
    int mTrackCount;
    int mCurrentTrackPlaying;
    int mAudioStatus;    //NCG3D-22900
    tCdromDiskStatus mCdRomType;
};

#endif /* _CDDA_DEVICE_INTERFACE_H_ */
