/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/DatapoolTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

#include <memory.h>
#include <glib.h>
#include <ListControl.h>
#include <string.h>

#include "DatapoolTest.h"
#include <FunctionTracer.h>
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"


DatapoolTest::DatapoolTest()
{
}

void DatapoolTest::setUp()
{
    ticks.begin();
}

void DatapoolTest::tearDown()
{
    ticks.elapsed();
}

/**********************************************************************
 * Test cases
 *********************************************************************/
#ifdef TARGET_BUILD
void DatapoolTest::verifyCallControlsConfiguration()
{
    ENTRY;
    ETG_TRACE_USR1((" *** Start DatapoolTest::verifyCallControlsSetting***"));

    tResult ret = MP_NO_ERROR;
    const tU8 writeConfigValue = 7;
    tU8 readConfigValue;

    ret = dpObj.writeCallControlsSetting(writeConfigValue);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    readConfigValue = dpObj.readCallControlsSetting();
    ETG_TRACE_USR3(("DatapoolTest::verifyCallControlsConfiguration: readConfigValue = %u \n",
            readConfigValue));

    GMPTEST_EXPECT_NE(readConfigValue, writeConfigValue);

}
#endif
