#ifndef _CDDA_METADATA_INFO_H_
#define _CDDA_METADATA_INFO_H_

#define CDAUDIO_CDTEXT_ATA_BUFFER_BYTES_PER_LINE  18
#define CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE   12
#define CDAUDIO_CDTEXT_ATA_BUFFER_CHARPOS_MASK 0x0f
#define CDTEXT_MAX_BUFFER  256

enum
{
  enCDAUDIO_CDTEXT_TYPE_TITLE = 0x80,
  enCDAUDIO_CDTEXT_TYPE_ARTIST = 0x81,
  enCDAUDIO_CDTEXT_TYPE_SONGWRITER = 0x82,
  enCDAUDIO_CDTEXT_TYPE_COMPOSER = 0x83,
  enCDAUDIO_CDTEXT_TYPE_SIZEINFO = 0x8F,
};
typedef struct
{
    tU8 ID;
    tU8 pos;
    tU8 startpos;
    tU8 srtPack[CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE+1];
}tCDTextInfo;
typedef std::map<tU8,tCDTextInfo> MapCDCode;
typedef std::map<tU8, string>  MapCDDAMetadata;
#define CDAUDIO_ATABYTE(pu8,row,col) (pu8\
                                     [(CDAUDIO_CDTEXT_ATA_BUFFER_BYTES_PER_LINE\
                                       * (tU32)(row)) + (tU32)(col)])
#define CD_MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#endif // if _CDDA_METADATA_INFO_H_
