#ifndef _ALBUM_ART_CAHCE_H_
#define _ALBUM_ART_CAHCE_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <vector>
#include <algorithm>
#include <utility>

#include "TypeDefinitions.h"

#define FAKE_ALBUM_ART 0

class AlbumArtCache
{
public:
    enum {mNoOfCachelines = 100};

private:
    typedef struct {
        tBoolean valid;
        tUInt age;
        tAlbumArt albumArt;
        tAlbumArtObjectPtr albumArtPtr;
    } tAlbumArtPair;
    tAlbumArtPair mAlbumArtCache[mNoOfCachelines];
    tAlbumArtObject mAAObject; // simulation object
    tUInt mAgeCounter;

    int FindInCache(tUInt &index, const tAlbumArt albumArt);
public:

    void AddToCache(const tAlbumArt albumArt, const tAlbumArtObjectPtr albumArtPtr);
    AlbumArtCache();
    tResult IsAlbumArtInCache(const tAlbumArt albumArtString);
    tResult GetAlbumArtObjectFromCache(tAlbumArtObjectPtr &aaObjectPtr, const tAlbumArt albumArtString);
    static tImageData ReadPicture(tImageSize &imageSize, const tAlbumArt albumArt);
    tResult LoadAlbumArtIntoCache(const tAlbumArt albumArtString);
    int GetCacheCount();
    void clearCache();
};

#endif // if _ALBUM_ART_CAHCE_H_
