#ifndef _CDDAVTTest_H_
#define _CDDAVTTest_H_

/*lint -save -e578 */

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>
#include <sqlite3.h>
#include <vector>

class CDDAVTTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( CDDAVTTest );
    CPPUNIT_TEST( CreateVT );
	CPPUNIT_TEST( QueryFirstLevel );
	CPPUNIT_TEST( DeleteVT );
    CPPUNIT_TEST_SUITE_END();

public:

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    int Query(char *deviceMountPoint, char *path, int flags, vector<char *> expectedNames, vector<char *> expectedTitles, int doAssert);
    void QueryCount(char *deviceMountPoint, char *path, int countMediaObjects);

    /*test cases*/	
	void QueryFirstLevel();

	void CreateVT();
	void DeleteVT();

private:
    TimeTrace	 	 ticks;			/**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;	/**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;		/**< lock used during asynchronous test case execution*/
};

#endif  // _CDDAVTTest_H_
