
/*
 * BluetoothVTTest.h
 *
 *  Created on: Oct 23, 2013
 *      Author: pee1cob
 */

#ifndef BLUETOOTHVTTEST_H_
#define BLUETOOTHVTTEST_H_


#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>
#include <sqlite3.h>
#include <vector>

class BluetoothVTTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( BluetoothVTTest );
    CPPUNIT_TEST( CreateVT );
    CPPUNIT_TEST(QueryFirstLevel);
	CPPUNIT_TEST( QuerySecondLevel );
	CPPUNIT_TEST( QueryThirdLevel );
	CPPUNIT_TEST( DeleteVT );
    CPPUNIT_TEST_SUITE_END();

public:

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    int Query(char *mountPoint, char *path, char *comparePath,vector<char *> expectedNames, vector<int> expectedTypes, int doAssert = 1);
    void QueryCount(char *mountPoint, char *path, int countDirectories, int countMediaObjects);

    /*test cases*/
	void CreateVT();
	void DeleteVT();
	void QueryFirstLevel();
	void QuerySecondLevel();
	void QueryThirdLevel();


private:
    TimeTrace	 	 ticks;			/**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;	/**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;		/**< lock used during asynchronous test case execution*/
};


#endif /* BLUETOOTHVTTEST_H_ */
