#ifndef _DBManagerTest_H_
#define _DBManagerTest_H_

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>
#include "ThreadFactory.h"

class DBManagerTest : public CppUnit::TestFixture, public TFThread
{
    CPPUNIT_TEST_SUITE( DBManagerTest );
    CPPUNIT_TEST( InitTestsuite );
    CPPUNIT_TEST( CheckSortLib );
    CPPUNIT_TEST( CheckSortLibNumberSort );
    CPPUNIT_TEST( CheckSortLibListSortOnNumbers );
    CPPUNIT_TEST( ExplainSelectsDevice );
    CPPUNIT_TEST( ExplainSelectsMyMedia );
    CPPUNIT_TEST( SelectCDDASongs );

    CPPUNIT_TEST( StoreBTMACAddress );
    CPPUNIT_TEST( InsertNewDevice_TriggerTest );
    CPPUNIT_TEST( UpdateDevice_TriggerTest );
    CPPUNIT_TEST( CreateList_GetMediaObjects_LTY_SONG_Forward );
    CPPUNIT_TEST( CreateList_GetMediaObjects_LTY_SONG_JumpBack );
    CPPUNIT_TEST( CreateList_GetMediaObjects_LTY_SONG_MyMedia );
    CPPUNIT_TEST( CreateList_GetMediaObjects_LTY_GENRE );
    CPPUNIT_TEST( CreateList_GetMediaObjects_LTY_ARTIST );
    CPPUNIT_TEST( CreateList_GetMediaObjects_LTY_IPOD );
	CPPUNIT_TEST( CreateList_GetMediaObjects_LTY_IMAGE_FOLDER );
    CPPUNIT_TEST( CreateList_GetMediaObjects_LTY_IMAGE_FOLDER_ITEM );
    CPPUNIT_TEST( GetNumberofImagesByPath );
    CPPUNIT_TEST( SetPosition );
    CPPUNIT_TEST( GetMediaObjectWrongID );
    CPPUNIT_TEST( MaxDeviceCountAndID );
    CPPUNIT_TEST( MaxDeviceLimit );
    CPPUNIT_TEST( GetDeviceIDFromObjectID );
    CPPUNIT_TEST( SetActiveDevice );
    CPPUNIT_TEST( GetActiveDevice );
    CPPUNIT_TEST( GetDeviceInfo_USB );
    CPPUNIT_TEST( GetIndexingState );
    CPPUNIT_TEST( SetIndexingState );
    CPPUNIT_TEST( SetFingerprint );
    CPPUNIT_TEST( DecrementNumberOfFiles );
    CPPUNIT_TEST( SetDiPOParameters );
    CPPUNIT_TEST( SetAlbumArtIndexingComplete );
    CPPUNIT_TEST( SetConnectionState );
    CPPUNIT_TEST( GetMetatdataIDs );
    CPPUNIT_TEST( GetObjectUUID );
    CPPUNIT_TEST( CreateFileLists_Concurrent);
    CPPUNIT_TEST( CreateFileList_GetMediaObjects_LTY_FILELIST );
    CPPUNIT_TEST( CreatePlayableFileList_LTY_FILELIST_MEDIAOBJECTS );
    CPPUNIT_TEST( Performance_CreateFileList_GetMediaObjects_LTY_FILELIST );
    CPPUNIT_TEST( Performance_CreateFileList_GetMediaObjects_LTY_FILELIST_UNSORTED );
    CPPUNIT_TEST( CreateList_GetListSize_LTY_SONG );
    CPPUNIT_TEST( CreateMediaObjectwithCompilationFlagSet );
    CPPUNIT_TEST( CreateMediaPlayerIndexedList_COMPILATIONS );
    CPPUNIT_TEST( GetLastModeDevices );
    CPPUNIT_TEST( ClearLastMode );
    CPPUNIT_TEST( GetLastPlaytime );
    CPPUNIT_TEST( StoreAlbumArt );

    CPPUNIT_TEST( EnableBrowseList );
    CPPUNIT_TEST( CreateFileList_GetMediaObjects_LTY_BROWSELIST );
    CPPUNIT_TEST( CreatePlayableFileList_LTY_BROWSELIST_MEDIAOBJECTS );
    CPPUNIT_TEST( Performance_CreateFileList_GetMediaObjects_LTY_BROWSELIST );
    CPPUNIT_TEST( DetermineFolderContentPerformanceTest );
    CPPUNIT_TEST( DisableBrowseList );

    // my media test cases
    CPPUNIT_TEST( AddSecondUSBDeviceToDB );
    CPPUNIT_TEST( InsertUniqueSpecialString );
    CPPUNIT_TEST( Performance_InsertUniqueString );
    CPPUNIT_TEST( MyMediaUpdateManager ); // this test must be after the Performance_InsertUniqueString test
    CPPUNIT_TEST( UpdateMyMedia ); // this test needs at least all tests from AddSecondUSBDeviceToDB
#if 0 // only for select performance test, test afterwards will fail
    CPPUNIT_TEST( MyMediaSelectTest );
#endif
#if 0// only for select performance test, test afterwards will fail
    CPPUNIT_TEST( DeviceSelectTest );
#endif
#if 0 // only for SetObject performance test, test afterwards will fail
    CPPUNIT_TEST( GetPositionInListTest );
#endif
    CPPUNIT_TEST( MoveDeviceToVirtualTableAndBack );
    CPPUNIT_TEST( RemoveSecondUSBDevice );
    CPPUNIT_TEST( MyMediaReUpdateTest );
#if 0 // enable it only in case of performance meas.
    CPPUNIT_TEST( MyMediaPerformanceTest );
#endif
    CPPUNIT_TEST( DeleteAllElementsForSecondDevice );

#ifndef TARGET_BUILD
    CPPUNIT_TEST( HandleMP3WithHughTags );
#endif
    CPPUNIT_TEST( InsertVideoObject );
    CPPUNIT_TEST( InsertImageObject );
    CPPUNIT_TEST( ConcurrentDBRead );

    CPPUNIT_TEST( CreateMediaObject );
    CPPUNIT_TEST( CreateMediaObject_WithNoMetadata );
    CPPUNIT_TEST( UpdateMediaObject );
    CPPUNIT_TEST( RemoveMediaObject );
    CPPUNIT_TEST( RemoveMediaObjectByUUID );

    CPPUNIT_TEST( InsertNewDevice );
    CPPUNIT_TEST( UpdateDeviceSize );
    CPPUNIT_TEST( ConnectMyMediaByInternalTrigger );

    // these tests modifies the test database
    CPPUNIT_TEST( UpdateMediaObjects_Select_Update );
    CPPUNIT_TEST( UpdateMediaObjects_Select_Delete_Before );
    CPPUNIT_TEST( UpdateMediaObjects_Select_Delete_After );

    CPPUNIT_TEST( InitTestsuite ); //Recreate Test database for LiveTags test
    CPPUNIT_TEST( LiveTagsInsert );
    CPPUNIT_TEST( SyncLiveTagsAndGenres );
    CPPUNIT_TEST( SyncLiveTagsAndArtists);
    CPPUNIT_TEST( SyncLiveTagsAndComposers);
    CPPUNIT_TEST( SyncLiveTagsAndAlbums);
    CPPUNIT_TEST( SyncLiveTagsAndMediaObject);
    CPPUNIT_TEST( FillupMetaDataIDs );
    CPPUNIT_TEST( CreateList_GetMediaObjects_LTY_COMPILATIONS );
    CPPUNIT_TEST(DVDStorageTableTest);
    CPPUNIT_TEST( CheckAllQueryLength );
    CPPUNIT_TEST( MusicBoxPopertyTableTest);
	CPPUNIT_TEST( YomiMetadataTest );
	CPPUNIT_TEST( RemoveYomiMetadataTest );
	CPPUNIT_TEST( MusicBoxToCTest );
	CPPUNIT_TEST( UUIDfromAlbumNameTest );
	CPPUNIT_TEST( UpdateGNdatainMediaObjectTest );
    CPPUNIT_TEST( InsertCurrentUserforPersonalization);
    CPPUNIT_TEST( StoreFavoriteforPersonalization);
    CPPUNIT_TEST( EndTestsuite ); // this recreates the test DB for the following tests
    CPPUNIT_TEST_SUITE_END();

public:
    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    void InitTestsuite();
    void EndTestsuite();
    void EnableBrowseList();
    void DisableBrowseList();
    void CreateMediaObject();
    void CreateMediaObject_WithNoMetadata();
    void UpdateMediaObject();
    void CreateList_GetMediaObjects_LTY_SONG_Forward();
    void CreateList_GetMediaObjects_LTY_SONG_JumpBack();
    void CreateList_GetMediaObjects_LTY_SONG_MyMedia();
    void CreateList_GetMediaObjects_LTY_GENRE();
    void SetPosition();
    void GetMediaObjectWrongID();
    void CreateList_GetMediaObjects_LTY_ARTIST();
    void CreateList_GetMediaObjects_LTY_IPOD();
    void CreateFileLists_Concurrent();
    void CreateFileList_GetMediaObjects_LTY_FILELIST();
    void CreatePlayableFileList_LTY_FILELIST_MEDIAOBJECTS();
    void CreateFileList_GetMediaObjects_LTY_BROWSELIST();
    void CreatePlayableFileList_LTY_BROWSELIST_MEDIAOBJECTS();
    void Performance_CreateFileList_GetMediaObjects_LTY_FILELIST();
    void Performance_CreateFileList_GetMediaObjects_LTY_FILELIST_UNSORTED();
    void Performance_CreateFileList_GetMediaObjects_LTY_BROWSELIST();
    void CreateList_GetListSize_LTY_SONG();
    void MaxDeviceCountAndID();
    void MaxDeviceLimit();
    void GetDeviceIDFromObjectID();
    void SetActiveDevice();
    void GetActiveDevice();
    void GetDeviceInfo_USB();
    void GetIndexingState();
    void SetIndexingState();
    void SetFingerprint();
    void DecrementNumberOfFiles();
    void SetDiPOParameters();
    void SetAlbumArtIndexingComplete();
    void SetConnectionState();
    void GetMetatdataIDs();
    void GetObjectUUID();
    void GetArtistOfAlbum();
    void GetGenreOfAlbum();
    void InsertNewDevice();
    void UpdateDeviceSize();
    void ConnectMyMediaByInternalTrigger();
    void InsertNewDevice_TriggerTest();
    void UpdateDevice_TriggerTest();
    void Performance_InsertUniqueString();
    void CreateID();
    void UpdateMediaObjects_Select_Update();
    void UpdateMediaObjects_Select_Delete_Before();
    void UpdateMediaObjects_Select_Delete_After();
    void AddSecondUSBDeviceToDB();
    void PrintMyMedia();
    void UpdateMyMedia();
    void RemoveSecondUSBDevice();
    void MoveDeviceToVirtualTableAndBack();
    void MyMediaPerformanceTest();
    void MyMediaReUpdateTest();
    void DetermineFolderContentPerformanceTest();
    void MyMediaSelectTest();
    void GetPositionInListTest();
    void DeviceSelectTest();
    void DeleteAllElementsForSecondDevice();
    void ExplainSelectsDevice();
    void ExplainSelectsMyMedia();
    void CheckSortLib();
    void CheckSortLibNumberSort();
    void CheckSortLibListSortOnNumbers();
    void InsertUniqueSpecialString();
    void LiveTagsInsert();
    void SyncLiveTagsAndGenres();
    void SyncLiveTagsAndArtists();
    void SyncLiveTagsAndComposers();
    void SyncLiveTagsAndAlbums();
    void SyncLiveTagsAndMediaObject();
    void FillupMetaDataIDs();
    void LiveTags();
    void InsertVideoObject();
    void InsertImageObject();
    void HandleMP3WithHughTags();
    void MyMediaUpdateManager();
    void GetLastModeDevices();
    void ClearLastMode();
    void GetLastPlaytime();
    void StoreAlbumArt();
    void RemoveMediaObject();
    void RemoveMediaObjectByUUID();
    void StoreBTMACAddress();
    void ConcurrentDBRead();
    void SelectCDDASongs();
    void CreateList_GetMediaObjects_LTY_IMAGE_FOLDER();
    void CreateList_GetMediaObjects_LTY_IMAGE_FOLDER_ITEM();
    void GetNumberofImagesByPath();
    void CreateMediaObjectwithCompilationFlagSet();
    void CreateMediaPlayerIndexedList_COMPILATIONS();
    void CreateList_GetMediaObjects_LTY_COMPILATIONS();
    void DVDStorageTableTest();
    void CheckAllQueryLength();
    void MusicBoxPopertyTableTest();
    void InsertCurrentUserforPersonalization();
    void StoreFavoriteforPersonalization();
    void Do(int functionID, void *ptr);
    void YomiMetadataTest();
    void RemoveYomiMetadataTest();
    void MusicBoxToCTest();
    void UUIDfromAlbumNameTest();
    void UpdateGNdatainMediaObjectTest();

private:
    typedef struct {
        tListType listType;
        tFilterTag filterTag1;
        tFilterTag filterTag2;
        tFilterTag filterTag3;
        tFilterTag filterTag4;
        tPath path;
        const char *cListname;
        int indexPresent;
        int tempBTreePresent;
    } tTestPlan;

    TimeTrace        ticks;         /**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;    /**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;        /**< lock used during asynchronous test case execution*/

    void GenRandom(char *s, const int len);
    void MyMediaSelectTestRunner(const tDeviceID deviceID);
    void ExplainSelects(const vector<tTestPlan> testPlan, const tDeviceID deviceID);
    void Performance_CreateFileList_GetMediaObjects(int &noOfObjects, const int listID, int offset, int count);
    void ValidateSearchKeyList(const tListID listID);
};

#endif  // _DBManagerTest_H_
