/*lint -save -e1773 -e578 */

/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/DBManagerTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

#include <stdio.h>
#include <errno.h>
#include <memory.h>
#include <DBManager.h>
#include <Query.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>

#include "DBManagerTest.h"
#include "LocalSPM.h"
#include "RequestResponseSM.h"
#include "CppUnitDefinitions.h"

void DBManagerTest::setUp()
{
    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&condition,NULL);
    ticks.begin();
}

void DBManagerTest::tearDown()
{
    ticks.elapsed();
    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&condition);
}

/**********************************************************************
 * Test cases
 *********************************************************************/

void DBManagerTest::InitTestsuite()
{
    ENTRY

    tResult res = MP_NO_ERROR;

    /* recreate the test database */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::EndTestsuite()
{
    ENTRY

    tResult res = MP_NO_ERROR;

    /* stop the player manager (in case it is still running) */
    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN SA_OFF);
    CPPUNIT_ASSERT(res == 0);

    /* De Allocate Audio */
    res = LocalSPM::GetPlayerManager().SendDeAllocate();
    CPPUNIT_ASSERT(res == 0);

    sleep(2);

    /* create the test database */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::EnableBrowseList()
{
    ENTRY

    /* Enable DBFileBrowsingByDB configuration */
    int browsingByDB = LocalSPM::GetDataProvider().DBFileBrowsingByDB();
    if (0 == browsingByDB)
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = 1;
        LocalSPM::GetDataProvider().DBFileListWhileIndexing = 1;
    }

    /* recreate the test database */
    InitTestsuite();
}

void DBManagerTest::DisableBrowseList()
{
    ENTRY

    /* Disable DBFileBrowsingByDB configuration */
    int browsingByDB = LocalSPM::GetDataProvider().DBFileBrowsingByDB();
    if (0 != browsingByDB)
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = 0;
        LocalSPM::GetDataProvider().DBFileListWhileIndexing = 0;
    }

    /* recreate the test database */
    InitTestsuite();
}

void DBManagerTest::CreateList_GetMediaObjects_LTY_SONG_Forward()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tMediaObject mediaObject;
    tIndex rowNumber;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test for a specific device
     */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    listType = LTY_SONG;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        /* do a compare or what? */
        ETG_TRACE_USR2(("GetMediaObject: Tag4=%d->%s", mediaObject.MetadataTag4,mediaObject.MetadataField4));

        // next row
        rowNumber++;
    }

    ValidateSearchKeyList(listID);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateList_GetMediaObjects_LTY_SONG_JumpBack()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tMediaObject mediaObject;
    tIndex rowNumber;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test for a specific device
     */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);
    listType = LTY_SONG;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        // next row
        rowNumber++;
    }

    /* get a media objects, jump back a slice and get the rest */
    rowNumber = 5;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        /* do a compare or what? */
        ETG_TRACE_USR2(("GetMediaObject: Tag4=%d->%s", mediaObject.MetadataTag4,mediaObject.MetadataField4));

        // next row
        rowNumber++;
    }

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateList_GetMediaObjects_LTY_SONG_MyMedia()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tMediaObject mediaObject;
    tIndex rowNumber;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /* create a my media list */
    deviceID = MY_MEDIA; // list for my media
    listType = LTY_SONG;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        /* do a compare or what? */
        ETG_TRACE_USR2(("GetMediaObject: Tag4=%d->%s", mediaObject.MetadataTag4,mediaObject.MetadataField4));

        // next row
        rowNumber++;
    }

    ValidateSearchKeyList(listID);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateList_GetMediaObjects_LTY_GENRE()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tMediaObject mediaObject;
    tIndex rowNumber;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test list of genres
     */
    deviceID = MY_MEDIA; // list for my media
    listType = LTY_GENRE;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        /* do a compare or what? */
        ETG_TRACE_USR2(("GetMediaObject: Tag1=%d->%s", mediaObject.MetadataTag1,mediaObject.MetadataField1));

        // next row
        rowNumber++;
    }

    ValidateSearchKeyList(listID);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateList_GetMediaObjects_LTY_ARTIST()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tMediaObject mediaObject;
    tIndex rowNumber;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test list of Artists
     */
    deviceID = MY_MEDIA; // list for my media
    listType = LTY_ARTIST;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        /* do a compare or what? */
        ETG_TRACE_USR2(("GetMediaObject: Tag2=%d->%s", mediaObject.MetadataTag2,mediaObject.MetadataField2));

        // next row
        rowNumber++;
    }

    ValidateSearchKeyList(listID);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::SetPosition()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tMediaObject mediaObject;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test list of Artists
     */
    deviceID = MY_MEDIA; // list for my media
    listType = LTY_ARTIST;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get the first entry (Garbage) */
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN 0);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    /* create a song list of this artist */
    filterTag2.tag = mediaObject.MetadataTag2;

    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN LTY_ARTIST_SONG,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get the size of this list */
    tListSize listSize;
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize > 1); //At least 2 elements
    ETG_TRACE_USR2(("listSize=%d", listSize));

    /* create a compare list with all object id's */
    vector<tObjectID> objectIDs;
    for(unsigned int i=0; i<listSize; i++) {

        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN i);
        CPPUNIT_ASSERT(res == 0);

        objectIDs.push_back(mediaObject.objectID);
    }

    /* do some tests in a loop */
    tPosition position;
    for(unsigned int loop = 0; loop < listSize; loop++) {

        /* set the row to test */
        tRowID row;
        row = (tRowID)(((float)rand()*(float)(listSize-1)) / (float)RAND_MAX);

        ETG_TRACE_USR2(("test(%d) row=%d", loop, row));

        /* get the last object in the list */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN row);
        CPPUNIT_ASSERT(res == 0);

        /* save the object id */
        tObjectID objectID;
        objectID = mediaObject.objectID;
        ETG_TRACE_USR2(("test(%d) objectID=%d", loop, objectID));

        /* retest the position */
        res = LocalSPM::GetDBManager().GetPositionInList(OUT position, IN listID, IN objectID);
        CPPUNIT_ASSERT(res == 0);
        CPPUNIT_ASSERT(position == row);

        /* dummy: get another element */
        tRowID anotherRow = row;
        while(anotherRow == row) {
            anotherRow = (tRowID)(((float)rand()*(float)(listSize-1)) / (float)RAND_MAX);
        }
        ETG_TRACE_USR2(("test(%d) anotherRow=%d", loop, anotherRow));

        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN anotherRow);
        CPPUNIT_ASSERT(res == 0);

        /* set position to there */
        res = LocalSPM::GetDBManager().SetPosition(IN mediaObject.objectID, IN listID);
        CPPUNIT_ASSERT(res == 0);

        /* get the current object */
        InitMediaObject(OUT mediaObject);
        res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listID);
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR2(("test(%d) another current object=%d", loop, mediaObject.objectID));

        /* must be other than saved object id */
        CPPUNIT_ASSERT(mediaObject.objectID != objectID);

        /* correct position? */
        CPPUNIT_ASSERT(objectIDs[anotherRow] == mediaObject.objectID);

        /* retest the position */
        res = LocalSPM::GetDBManager().GetPositionInList(OUT position, IN listID, IN mediaObject.objectID);
        CPPUNIT_ASSERT(res == 0);
        CPPUNIT_ASSERT(position == anotherRow);

        /* do a set position to the object id */
        InitMediaObject(OUT mediaObject);

        /* set the position */
        res = LocalSPM::GetDBManager().SetPosition(IN objectID, IN listID);
        CPPUNIT_ASSERT(res == 0);

        /* get the current object */
        res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listID);
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR2(("test(%d) SetPosition/GetCurrentMediaObject object=%d ?== %d", loop, mediaObject.objectID, objectID));

        /* must be the same as saved object id */
        CPPUNIT_ASSERT(mediaObject.objectID == objectID);

        /* correct position? */
        CPPUNIT_ASSERT(objectIDs[row] == mediaObject.objectID);
    }

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::GetMediaObjectWrongID()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tMediaObject mediaObject;

    tMediaObjectID objectID = 250000;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN objectID, CTY_SONG);
    CPPUNIT_ASSERT(res != MP_NO_ERROR);
}

void DBManagerTest::CreateList_GetMediaObjects_LTY_IPOD()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tMediaObject mediaObject;
    tIndex rowNumber;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test for a specific device
     */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_IPOD, IN "IPOD");
    CPPUNIT_ASSERT(res == 0);

    listType = LTY_GENRE;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        /* do a compare or what? */
        ETG_TRACE_USR2(("GetMediaObject: Tag4=%d->%s", mediaObject.MetadataTag4,mediaObject.MetadataField4));

        // next row
        rowNumber++;
    }

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateFileLists_Concurrent()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB,"USB");
    CPPUNIT_ASSERT(res == 0);

    /*cleanup the cache*/
    res = LocalSPM::GetDBManager().DeleteVTFileCache(deviceID);

    /*create unsorted filelist*/
    tListID listID_Unsorted = LIST_ID_NONE;
    tListType listType = LTY_FILELIST_UNSORTED;
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID_Unsorted, INOUT listType, IN "", IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /*create sorted filelist for the same path*/
    tListID listID_Sorted = LIST_ID_NONE;
    listType = LTY_FILELIST;
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID_Sorted, INOUT listType, IN "", IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /*partial read of unsorted file list*/
    tIndex row;
    for(row = 0 ; row < 4; row++)
    {
        tMediaObject listElement;
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT listElement, IN listID_Unsorted, IN row);
        CPPUNIT_ASSERT(res == 0);

        ETG_TRACE_ERR(("unsorted file list element(%d) ->%s",row,listElement.fileName));
    }

    /*complete read of sorted filelist*/
    row = 0;
    while(1) {
        tMediaObject listElement;
        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT listElement, IN listID_Sorted, IN row);
        if (res != 0) break;

        /* do a compare or what? */
        ETG_TRACE_USR2(("sorted filelist element(%d)->%s",row, listElement.fileName));

        // next row
        row++;
    }
    CPPUNIT_ASSERT(row == 7);

    /*remaining elements from unsroted file list*/
    for(row = 4 ; row < 7; row++)
    {
        tMediaObject listElement;
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT listElement, IN listID_Unsorted, IN row);
        CPPUNIT_ASSERT(res == 0);

        ETG_TRACE_ERR(("unsorted file list element(%d) ->%s",row,listElement.fileName));
    }
}

void DBManagerTest::CreateFileList_GetMediaObjects_LTY_FILELIST()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID = LIST_ID_NONE;
    tDeviceID deviceID;
    tMediaObject mediaObject;
    tIndex rowNumber;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    char *path = (char *)"/";
    tListType listType = LTY_FILELIST;
    //tPosition position;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* create a file list from root directory */
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID, INOUT listType, IN path, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_FILELIST);

    /* get the counts */
    res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfMediaObjects == 3);
    CPPUNIT_ASSERT(numberOfFolders == 4);
    CPPUNIT_ASSERT(numberOfPlayLists == 0);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        ETG_TRACE_USR2(("CreateFileList GetMediaObject: objectID:%d title:%s", mediaObject.objectID, mediaObject.title));
        CPPUNIT_ASSERT(mediaObject.objectID != 0);
        CPPUNIT_ASSERT(0 < strlen_r(mediaObject.title));

        //Cannot work because these objects were never been played
        //res = LocalSPM::GetDBManager().GetPositionInList(OUT position, IN listID, IN mediaObject.objectID);
        //CPPUNIT_ASSERT(res == 0);
        //CPPUNIT_ASSERT(rowNumber == position);

        // next row
        rowNumber++;
    }
    CPPUNIT_ASSERT(rowNumber == 7);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreatePlayableFileList_LTY_FILELIST_MEDIAOBJECTS()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID = LIST_ID_NONE;
    tDeviceID deviceID;
    tMediaObject mediaObject;
    tIndex rowNumber;
    tListType listType = LTY_FILELIST_MEDIAOBJECTS;
    char *path = (char *)"/music/";

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* create a list */
    res = LocalSPM::GetDBManager().CreateFileListOfMediaObjects(
            INOUT listID,
            INOUT listType,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_FILELIST_MEDIAOBJECTS);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        ETG_TRACE_USR2(("CreatePlayableFileList GetMediaObject: objectID:%d title:%s", mediaObject.objectID, mediaObject.title));
        CPPUNIT_ASSERT(mediaObject.objectID != 0);
        CPPUNIT_ASSERT(0 < strlen_r(mediaObject.title));

        // next row
        rowNumber++;
    }
    CPPUNIT_ASSERT(rowNumber == 7);

    tListSize listSize = 0;
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listID);
    CPPUNIT_ASSERT(listSize == 7);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    /*------------ test include subfolder option for playable file list ---------------------*/
    /* create a list */
    listID = LIST_ID_NONE;
    listType = LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS;
    res = LocalSPM::GetDBManager().CreateFileListOfMediaObjects(
                INOUT listID,
                INOUT listType,
                IN path,
                IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS);

    /* set the current media object in a created list to the first element */
    tRowNumber newRow = 0;
    res = LocalSPM::GetDBManager().SetCurrentRow(IN listID, IN newRow);
    CPPUNIT_ASSERT(res == 0);

    /* get the current media object */
    res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listID);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR2(("CreatePlayableFileList  includeSubfolder GetCurrentMediaObject: objectID:%d title:%s", mediaObject.objectID, mediaObject.title));
    CPPUNIT_ASSERT(mediaObject.objectID != 0);
    CPPUNIT_ASSERT(0 < strlen_r(mediaObject.title));

    /* get a media objects forward */
    rowNumber = 0;
    while(1)
    {
        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        ETG_TRACE_USR2(("CreatePlayableFileList includeSubfolder GetMediaObject: objectID:%d title:%s", mediaObject.objectID, mediaObject.title));
        CPPUNIT_ASSERT(mediaObject.objectID != 0);
        CPPUNIT_ASSERT(0 < strlen_r(mediaObject.title));

        // next row
        rowNumber++;
    }
    CPPUNIT_ASSERT(rowNumber == 28);

    listSize = 0;
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize , IN listID);
    CPPUNIT_ASSERT(listSize == 28);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateFileList_GetMediaObjects_LTY_BROWSELIST()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID = LIST_ID_NONE;
    tDeviceID deviceID;
    tMediaObject mediaObject;
    tIndex rowNumber;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    char *path = (char *)"/";
    tListType listType = LTY_FILELIST;
    tPosition position;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

#if 0
    /* set indexingState to IDS_COMPLETE */
    tIndexingState indexingState = IDS_COMPLETE;
    tIndexingPercentComplete percent = 100;
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN indexingState, IN percent);
    CPPUNIT_ASSERT(res == 0);

    /* get the device information*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(IDS_COMPLETE == deviceInfo.indexedState);
#endif

    /* create a file list from root directory */
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID, INOUT listType, IN path, IN deviceID, IN false/*=streaming*/, IN FTS_ALL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_BROWSELIST);

    /* get the counts */
    res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfMediaObjects == 3);
    CPPUNIT_ASSERT(numberOfPlayLists == 0);
    CPPUNIT_ASSERT(numberOfFolders == 3);
    CPPUNIT_ASSERT(listSize == 6);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        ETG_TRACE_USR2(("CreateFileList GetMediaObject: objectID:%d title:%s", mediaObject.objectID, mediaObject.title));
        CPPUNIT_ASSERT(mediaObject.objectID != 0);
        CPPUNIT_ASSERT(0 < strlen_r(mediaObject.title));

        res = LocalSPM::GetDBManager().GetPositionInList(OUT position, IN listID, IN mediaObject.objectID);
        CPPUNIT_ASSERT(res == 0);
        CPPUNIT_ASSERT(rowNumber == position);

        // next row
        rowNumber++;
    }
    CPPUNIT_ASSERT(rowNumber == listSize);

#if 0
    /* reset indexingState to IDS_NOT_STARTED again */
    indexingState = IDS_NOT_STARTED;
    percent = 0;
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN indexingState, IN percent);
    CPPUNIT_ASSERT(res == 0);
#endif

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreatePlayableFileList_LTY_BROWSELIST_MEDIAOBJECTS()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID = LIST_ID_NONE;;
    tDeviceID deviceID;
    tMediaObject mediaObject;
    tIndex rowNumber;
    tListType listType = LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS;
    char *path = (char *)"/music/";

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

#if 0
    /* set indexingState to IDS_COMPLETE */
    tIndexingState indexingState = IDS_COMPLETE;
    tIndexingPercentComplete percent = 100;
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN indexingState, IN percent);
    CPPUNIT_ASSERT(res == 0);

    /* get the device information*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(IDS_COMPLETE == deviceInfo.indexedState);
#endif

    /* create a list */
    res = LocalSPM::GetDBManager().CreateFileListOfMediaObjects(
            INOUT listID,
            INOUT listType,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS);

    tListSize listSize = 0;
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listID);
    CPPUNIT_ASSERT(listSize == 28);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        ETG_TRACE_USR2(("CreateFileList GetMediaObject: objectID:%d title:%s", mediaObject.objectID, mediaObject.title));
        CPPUNIT_ASSERT(mediaObject.objectID != 0);
        CPPUNIT_ASSERT(0 < strlen_r(mediaObject.title));

        // next row
        rowNumber++;
    }
    CPPUNIT_ASSERT(rowNumber == listSize);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

#if 0
    /* reset indexingState to IDS_NOT_STARTED again */
    indexingState = IDS_NOT_STARTED;
    percent = 0;
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN indexingState, IN percent);
    CPPUNIT_ASSERT(res == 0);
#endif

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::GetDeviceIDFromObjectID()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Create a song list and get an object as compare object */
    tListID listID;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    res = LocalSPM::GetDBManager().CreateList(OUT listID,
            IN MY_MEDIA,
            IN LTY_SONG,
            IN PC_NO_REPEAT,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4);
    CPPUNIT_ASSERT(res == 0);

    /* get the current object */
    tMediaObject mediaObject;
    res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObject, IN listID);
    CPPUNIT_ASSERT(res == 0);

    /* get the USB device ID */
    tDeviceID deviceIDCompare;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceIDCompare, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetObjectDeviceID(OUT deviceID, IN mediaObject.objectID, CTY_SONG);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceID == deviceIDCompare);

    res = LocalSPM::GetDBManager().GetObjectDeviceID(OUT deviceID, IN mediaObject.MetadataTag1, CTY_GENRE);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceID == deviceIDCompare);

    res = LocalSPM::GetDBManager().GetObjectDeviceID(OUT deviceID, IN mediaObject.MetadataTag2, CTY_ARTIST);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceID == deviceIDCompare);

    res = LocalSPM::GetDBManager().GetObjectDeviceID(OUT deviceID, IN mediaObject.MetadataTag4, CTY_ALBUM);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceID == deviceIDCompare);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::SetActiveDevice()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().SetActiveDevice(deviceID);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::GetActiveDevice()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tDeviceID deviceIDCompare;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceIDCompare, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceID == deviceIDCompare);
}

void DBManagerTest::GetDeviceInfo_USB()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tDeviceInfo deviceInfo;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceInfo.deviceID == deviceID);
    CPPUNIT_ASSERT(deviceInfo.connected == 1);
    CPPUNIT_ASSERT(deviceInfo.deviceType == DTY_USB);
    CPPUNIT_ASSERT(deviceInfo.indexedState == IDS_COMPLETE);
    CPPUNIT_ASSERT(strcmp(deviceInfo.serialNumber, "987654321") == 0);
    CPPUNIT_ASSERT(strcmp(deviceInfo.deviceName, "USB") == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::GetIndexingState()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;;
    vector<tIndexingStateResult> indexingStateResults;

    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetIndexingState(OUT indexingStateResults);
    CPPUNIT_ASSERT(res == 0);

    unsigned int i;
    for(i =0;i< indexingStateResults.size();i++)
    {
        if(indexingStateResults[i].deviceID == deviceID) break;
    }

    ETG_TRACE_USR1(("indexingState.size()=%d", indexingStateResults.size()));

    CPPUNIT_ASSERT(i < indexingStateResults.size());
    CPPUNIT_ASSERT(indexingStateResults[i].state == IDS_COMPLETE);
    CPPUNIT_ASSERT(indexingStateResults[i].percent == 100);
}

void DBManagerTest::SetIndexingState()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* set indexingState to IDS_PARTIAL */
    tIndexingState indexingState = IDS_PARTIAL;
    tIndexingPercentComplete percent = 66;
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN indexingState, IN percent);
    CPPUNIT_ASSERT(res == 0);

    /* get vector of indexing states of all devices */
    vector<tIndexingStateResult> indexingStateResult;
    tUInt i;
    res = LocalSPM::GetDBManager().GetIndexingState(OUT indexingStateResult);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(indexingStateResult.size() > 0);

    for(i=0; i<indexingStateResult.size(); i++)
    {
        if(deviceID == indexingStateResult[i].deviceID) break;
    }
    CPPUNIT_ASSERT(i < indexingStateResult.size());
    CPPUNIT_ASSERT(IDS_PARTIAL == indexingStateResult[i].state);
    CPPUNIT_ASSERT(66 == indexingStateResult[i].percent);

    /* reset indexingState to IDS_COMPLETE */
    indexingState = IDS_COMPLETE;
    percent = 100;
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN indexingState, IN percent);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::SetFingerprint()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* set fingerprint */
    tFingerprint fingerprint;
    strncpy_r(OUT fingerprint, "USB-Fingerprint: 987654321", IN sizeof(fingerprint));
    tNumberOfFiles numberOfAudioFiles = 100000;
    tNumberOfFiles numberOfVideoFiles = 0;

    res = LocalSPM::GetDBManager().SetFingerprint(IN deviceID, IN fingerprint, IN numberOfAudioFiles, IN numberOfVideoFiles);
    CPPUNIT_ASSERT(res == 0);

    /* get fingerprint */
    tFingerprint newFingerprint;
    res = LocalSPM::GetDBManager().GetFingerprint(OUT newFingerprint, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(strcmp(newFingerprint, fingerprint) == 0);
}

void DBManagerTest::DecrementNumberOfFiles()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tListID listID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* set number of files */
    tNumberOfFiles numberOfAudioFiles = 12;

    res = LocalSPM::GetDBManager().SetNumberOfAudioFiles(IN deviceID, IN numberOfAudioFiles);
    CPPUNIT_ASSERT(res == 0);

    /* set notPlayable flag of two media objects to NOT_PLAYABLE */
    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* create a list for that device */
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* get the first media object from that list */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 2);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 1);

    /* update two media objects */
    tNotPlayable localNotPlayableFlag1 = mediaObjectVector[0].notPlayable;
    mediaObjectVector[0].notPlayable = FNP_DRM_PROTECTED;
    res = LocalSPM::GetDBManager().UpdateMediaObject(IN mediaObjectVector[0]);
    CPPUNIT_ASSERT(res == 0);

    tNotPlayable localNotPlayableFlag2 = mediaObjectVector[1].notPlayable;
    mediaObjectVector[1].notPlayable = FNP_PLAY_RESTRICTION;
    res = LocalSPM::GetDBManager().UpdateMediaObject(IN mediaObjectVector[1]);
    CPPUNIT_ASSERT(res == 0);

    /* get the device information*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(10 == deviceInfo.numberOfAudioFiles);

    /* reset to original setting */
    mediaObjectVector[0].notPlayable = localNotPlayableFlag1;
    res = LocalSPM::GetDBManager().UpdateMediaObject(IN mediaObjectVector[0]);
    CPPUNIT_ASSERT(res == 0);

    mediaObjectVector[1].notPlayable = localNotPlayableFlag2;
    res = LocalSPM::GetDBManager().UpdateMediaObject(IN mediaObjectVector[1]);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::SetDiPOParameters()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* set DiPO parameters */
    tDiPOCaps diPOCaps = DIPO_CAP_CARPLAY;
    tDiPOActive diPOActive = false;
    tDiPOVersion diPOVersion;
    strncpy_r(OUT diPOVersion, "DiPO-Version: 999999", IN sizeof(diPOVersion));

    res = LocalSPM::GetDBManager().SetDiPOParameters(IN deviceID, IN diPOCaps, IN diPOActive, IN diPOVersion);
    CPPUNIT_ASSERT(res == 0);

    /* get the device information*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(diPOCaps == deviceInfo.diPOCaps);
    CPPUNIT_ASSERT(diPOActive == deviceInfo.diPOActive);
    CPPUNIT_ASSERT(strcmp(diPOVersion, deviceInfo.diPOVersion) == 0);
}

void DBManagerTest::SetAlbumArtIndexingComplete()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* get album art indexing complete flag */
    tAlbumArtIndexingComplete completeFlag;
    res = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(!completeFlag);

    /* set album art indexing complete flag to true */
    completeFlag = true;
    res = LocalSPM::GetDBManager().SetAlbumArtIndexingComplete(IN deviceID, IN completeFlag);
    CPPUNIT_ASSERT(res == 0);

    /* get album art indexing complete flag */
    res = LocalSPM::GetDBManager().GetAlbumArtIndexingComplete(OUT completeFlag, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(completeFlag);

    /* reset album art indexing complete flag to false */
    completeFlag = false;
    res = LocalSPM::GetDBManager().SetAlbumArtIndexingComplete(IN deviceID, IN completeFlag);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::SetConnectionState()
{
    ENTRY_TEST

    tResult res;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* get the device information*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* set new connection state */
    tConnectionState connectionState = CS_ON_HOLD;
    CPPUNIT_ASSERT(connectionState !=  deviceInfo.connectionState);

    res = LocalSPM::GetDBManager().SetConnectionState(IN deviceID, IN connectionState);
    CPPUNIT_ASSERT(res == 0);

    //check result
    tDeviceInfo deviceInfoNew;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfoNew, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceInfoNew.connectionState == connectionState);

    //set back to original state
    res = LocalSPM::GetDBManager().SetConnectionState(IN deviceID, IN CS_ATTACHED); //IC violation: onhold -> connected
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().SetConnectionState(IN deviceID, IN deviceInfo.connectionState);
    CPPUNIT_ASSERT(res == 0);

    //check result
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfoNew, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceInfoNew.connectionState == deviceInfo.connectionState);
}

void DBManagerTest::CreateList_GetListSize_LTY_SONG()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test for a specific device
     */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    listType = LTY_SONG;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get the count */
    tListSize listSize;
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN listID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize > 20);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::InsertNewDevice()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    tNumberOfDevices lastNumberOfDevices;

    res = LocalSPM::GetDBManager().GetConnectedDeviceCount(OUT lastNumberOfDevices);
    CPPUNIT_ASSERT(res == 0);

    /* set the device data */
    InitDeviceInfo(OUT deviceInfo);
    strncpy_r(OUT deviceInfo.UUID, "643722572i4698", IN sizeof(deviceInfo.UUID));
    strncpy_r(OUT deviceInfo.serialNumber, "0987654321", IN sizeof(deviceInfo.serialNumber));
    strncpy_r(OUT deviceInfo.deviceVersion, "ver 1.0", IN sizeof(deviceInfo.deviceVersion));
    strncpy_r(OUT deviceInfo.deviceName, "SD-Card", IN sizeof(deviceInfo.deviceName));
    strncpy_r(OUT deviceInfo.mountPoint, "/mnt", IN sizeof(deviceInfo.mountPoint));
    strncpy_r(OUT deviceInfo.accessoryName, "/dev/mmcblk0", IN sizeof(deviceInfo.accessoryName));
    deviceInfo.deviceType = DTY_SD;
    deviceInfo.connectionState = CS_CONNECTED;
    deviceInfo.fileSystemType = FSTY_FAT;
    deviceInfo.partitionNumber = 1;
    deviceInfo.totalSize = 0; //0, Device Manager during first notification sends total size and free size as 0.
    deviceInfo.freeSize = 0; //0
    deviceInfo.productID = 9876;
    deviceInfo.connectionType = DCT_USB;

    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);

    tNumberOfDevices numberOfDevices;
    res = LocalSPM::GetDBManager().GetConnectedDeviceCount(OUT numberOfDevices);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfDevices == (lastNumberOfDevices+1));

    vector<tDeviceInfo> deviceInfos;
    res = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfDevices == deviceInfos.size());
    CPPUNIT_ASSERT(numberOfDevices > 3);

    /* search for added device */
    unsigned int i;
    for(i=0; i<numberOfDevices; i++) {
        ETG_TRACE_USR4(("test: deviceID=%d, serialNumber=%s", deviceInfos[i].deviceID, deviceInfos[i].serialNumber));
        if (!strncmp(deviceInfos[i].serialNumber, deviceInfo.serialNumber, strlen_r(deviceInfo.serialNumber))) break; // found
    }
    CPPUNIT_ASSERT(i < numberOfDevices);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

/*Device Manager during first notification sends total size and free size as 0.
  The actual total and free size is sent as part of second notification. The below function tests that scenario*/
void DBManagerTest::UpdateDeviceSize()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tNumberOfDevices numberOfDevices;
    tDeviceSerialNumber serialNumber;
    strncpy_r(serialNumber,"0987654321",sizeof(serialNumber));

    vector<tDeviceInfo> deviceInfos;
    res = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);
    CPPUNIT_ASSERT(res == 0);
    unsigned int i;
    for(i=0; i<numberOfDevices; i++) {
        ETG_TRACE_USR4(("test: deviceID=%d, serialNumber=%s", deviceInfos[i].deviceID, deviceInfos[i].serialNumber));
        if (!strncmp(deviceInfos[i].serialNumber,serialNumber,strlen_r(serialNumber))) break; // found
    }
    CPPUNIT_ASSERT(i < numberOfDevices);
    CPPUNIT_ASSERT(deviceInfos[i].totalSize == 0);
    CPPUNIT_ASSERT(deviceInfos[i].freeSize == 0);

    //change total size and free size
    deviceInfos[i].totalSize = 10485760; //10GB
    deviceInfos[i].freeSize =5242880; //5GB
    deviceInfos[i].connectionState = CS_ATTACHED;
    res = LocalSPM::GetDBManager().DeviceChanged(deviceInfos);
    CPPUNIT_ASSERT(res == 0);

    //get the device info from DB
    deviceInfos.clear();
    numberOfDevices = 0;
    res = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);
    CPPUNIT_ASSERT(res == 0);
    for(i=0; i<numberOfDevices; i++) {
        ETG_TRACE_USR4(("test: deviceID=%d, serialNumber=%s", deviceInfos[i].deviceID, deviceInfos[i].serialNumber));
        if (!strncmp(deviceInfos[i].serialNumber,serialNumber,strlen_r(serialNumber))) break; // found
    }
    CPPUNIT_ASSERT(deviceInfos[i].totalSize == 10485760);
    CPPUNIT_ASSERT(deviceInfos[i].freeSize == 5242880);

    //change total size and free size again
    deviceInfos[i].totalSize = 67108864; //64GB
    deviceInfos[i].freeSize =33554432; //32GB
    deviceInfos[i].connectionState = CS_ATTACHED;
    res = LocalSPM::GetDBManager().DeviceChanged(deviceInfos);
    CPPUNIT_ASSERT(res == 0);

    //get the device info from DB
    deviceInfos.clear();
    numberOfDevices = 0;
    res = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);
    CPPUNIT_ASSERT(res == 0);
    for(i=0; i<numberOfDevices; i++) {
        ETG_TRACE_USR4(("test: deviceID=%d, serialNumber=%s", deviceInfos[i].deviceID, deviceInfos[i].serialNumber));
        if (!strncmp(deviceInfos[i].serialNumber,serialNumber,strlen_r(serialNumber))) break; // found
    }
    CPPUNIT_ASSERT(deviceInfos[i].totalSize == 67108864);
    CPPUNIT_ASSERT(deviceInfos[i].freeSize == 33554432);

    //change total size and free size to, it should not change
    deviceInfos[i].totalSize = 0;
    deviceInfos[i].freeSize = 0;
    deviceInfos[i].connectionState = CS_ATTACHED;
    res = LocalSPM::GetDBManager().DeviceChanged(deviceInfos);
    CPPUNIT_ASSERT(res == 0);

    //get the device info from DB
    deviceInfos.clear();
    numberOfDevices = 0;
    res = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);
    CPPUNIT_ASSERT(res == 0);
    for(i=0; i<numberOfDevices; i++) {
        ETG_TRACE_USR4(("test: deviceID=%d, serialNumber=%s", deviceInfos[i].deviceID, deviceInfos[i].serialNumber));
        if (!strncmp(deviceInfos[i].serialNumber,serialNumber,strlen_r(serialNumber))) break; // found
    }
    CPPUNIT_ASSERT(deviceInfos[i].totalSize == 67108864);
    CPPUNIT_ASSERT(deviceInfos[i].freeSize == 33554432);

}

void DBManagerTest::ConnectMyMediaByInternalTrigger()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tNumberOfDevices numberOfDevices;
    tDeviceInfo deviceInfo;

    /* recreate the test database without devices */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(false, false);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetConnectedDeviceCount(OUT numberOfDevices);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfDevices == 0);

    /* add 1st device (USB) */
    InitDeviceInfo(OUT deviceInfo);
    strncpy_r(OUT deviceInfo.serialNumber, "Kingston_DataTraveler_400_5B9302000047_AE9E-1ED8", IN sizeof(deviceInfo.serialNumber));
    strncpy_r(OUT deviceInfo.deviceVersion, "0110", IN sizeof(deviceInfo.deviceVersion));
    strncpy_r(OUT deviceInfo.deviceName, "KINGSTON", IN sizeof(deviceInfo.deviceName));
    strncpy_r(OUT deviceInfo.mountPoint, "/media/AAM_dev_sda1", IN sizeof(deviceInfo.mountPoint));
    strncpy_r(OUT deviceInfo.accessoryName, "/dev/sda", IN sizeof(deviceInfo.accessoryName));
    deviceInfo.deviceType = DTY_USB;
    deviceInfo.connectionState = CS_CONNECTED;

    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetConnectedDeviceCount(OUT numberOfDevices);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfDevices == 1);

    /* add 2nd device (BT) */
    InitDeviceInfo(OUT deviceInfo);
    strncpy_r(OUT deviceInfo.serialNumber, "f0dbe2df53b6", IN sizeof(deviceInfo.serialNumber));
    strncpy_r(OUT deviceInfo.deviceVersion, "1.4", IN sizeof(deviceInfo.deviceVersion));
    strncpy_r(OUT deviceInfo.deviceName, "BT Phone", IN sizeof(deviceInfo.deviceName));
    strncpy_r(OUT deviceInfo.mountPoint, "dev_f0_db_e2_df_53_b6", IN sizeof(deviceInfo.mountPoint));
    strncpy_r(OUT deviceInfo.accessoryName, "", IN sizeof(deviceInfo.accessoryName));
    deviceInfo.deviceType = DTY_BLUETOOTH;
    deviceInfo.connectionState = CS_CONNECTED;

    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().SetActiveDevice(MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetConnectedDeviceCount(OUT numberOfDevices);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfDevices == 3); //should be 3 because MyMedia is set to CS_CONNECTED by internal trigger

    /* Set indexing state to IDS_NOT_SUPPORTED */
    tIndexingState indexingState = IDS_NOT_SUPPORTED;
    tIndexingPercentComplete percent = 0;
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceInfo.deviceID, IN indexingState, IN percent);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetConnectedDeviceCount(OUT numberOfDevices);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfDevices == 3); //should still be 3 because MyMedia hold CS_CONNECTED state

    res = LocalSPM::GetDBManager().SetActiveDevice(deviceInfo.deviceID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetConnectedDeviceCount(OUT numberOfDevices); //should change to 2 because MyMedia change to CS_DISCONNECTED because BT does not count anymore due to unsupported indexing state
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfDevices == 2);

    res = LocalSPM::GetDBManager().SetActiveDevice(MY_MEDIA);
    CPPUNIT_ASSERT(res != 0); //should not work because MyMedia is not connected anymore

    /* recreate the test database */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::InsertNewDevice_TriggerTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* use a request / response state machine for testing the trigger */
    class TriggerTestRR : public RequestResponseSM
    {

        int HandleInitRequest()
        {
            return 0;
        }

        int HandleLoopBackMessage(const char *allParameters)
        {
            (void)allParameters;

            tResult res = MP_NO_ERROR; //lint !e578
            tDeviceInfo deviceInfo;

            InitDeviceInfo(OUT deviceInfo);
            /* in the init handler: add a new device */
            strncpy_r(OUT deviceInfo.UUID, "44967559464", IN sizeof(deviceInfo.UUID));
            strncpy_r(OUT deviceInfo.deviceVersion, "ver 1.1", IN sizeof(deviceInfo.deviceVersion));
            strncpy_r(OUT deviceInfo.serialNumber, "7576575", IN sizeof(deviceInfo.serialNumber));
            strncpy_r(OUT deviceInfo.deviceName, "AndroidMTP", IN sizeof(deviceInfo.deviceName));
            strncpy_r(OUT deviceInfo.mountPoint, "/mnt/android", IN sizeof(deviceInfo.mountPoint));
            strncpy_r(OUT deviceInfo.accessoryName, "#7", IN sizeof(deviceInfo.accessoryName));
            deviceInfo.deviceType = DTY_MTP;
            deviceInfo.connectionState = CS_CONNECTED;
            deviceInfo.fileSystemType = FSTY_UNKNOWN;
            deviceInfo.partitionNumber = PARTITION_NUMBER_NONE;
            deviceInfo.totalSize = 0;
            deviceInfo.freeSize = 0;
            deviceInfo.productID = 1111;
            deviceInfo.connectionType = DCT_USB;

            /* register a trigger on DB */
            switch(mTestPath) {
            case 0: // insert test
                triggerID = LocalSPM::GetDBManager().OnInsertTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST", IN "Devices", IN NULL);
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
                CPPUNIT_ASSERT(res == 0);
                break;

            case 1: // replace test
                triggerID = LocalSPM::GetDBManager().OnInsertTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST", IN "Devices", IN NULL);
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
                CPPUNIT_ASSERT(res == 0);
                break;

            case 2: // update test
                triggerID = LocalSPM::GetDBManager().OnUpdateTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST", IN "Devices", IN "Active", IN "WHEN OLD.Active=0 AND NEW.Active=1");
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                res = LocalSPM::GetDBManager().SetActiveDevice(IN mDeviceID);
                CPPUNIT_ASSERT(res == 0);
                break;

            case 3: // delete test
                triggerID = LocalSPM::GetDBManager().OnDeleteTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST", IN "Devices", IN NULL);
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                res = LocalSPM::GetDBManager().RemoveDevice(IN mDeviceID);
                CPPUNIT_ASSERT(res == 0);
                break;
            default:
                CPPUNIT_ASSERT(false);
                break;
            }

            return 0;
        }

        int HandleSuccessRequest(const char *allParameters)
        {
            tResult res = MP_NO_ERROR;

            /* check the incoming values */
            ETG_TRACE_USR3(("HandleSuccessRequest(%s)", allParameters));

            /* read out the returned values */
            UnMarshal(allParameters, "ii", &mCount, &mDeviceID);

#if 1
            /* deregister the trigger */
            res = LocalSPM::GetDBManager().UnregisterTrigger(IN triggerID);
            CPPUNIT_ASSERT(res == 0);
#endif
            /* do a send answer to unlock the EventAnswer mechanism */
            SendAnswer(NULL);

            return 0;
        }
    public:
        tTriggerID triggerID;
        int mTestPath;

        int mDeviceID;
        int mCount;
    };


    /* send LOOP_BACK_MESSAGE to start the tests */
    TriggerTestRR rrTriggerTest;
    char message[128];
    strncpy_r(OUT message, IN rrTriggerTest.GetSMNameFull(), IN sizeof(message));
    strncat_r(OUT message, "::LOOP_BACK_MESSAGE", IN sizeof(message));

    // insert test
    ETG_TRACE_USR2(("Insert Trigger Test"));
    rrTriggerTest.mCount = 0;
    rrTriggerTest.mDeviceID = MY_MEDIA;
    rrTriggerTest.mTestPath = 0;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(rrTriggerTest.mCount != 0);
    CPPUNIT_ASSERT(rrTriggerTest.mDeviceID != 0);

    // replace test
    ETG_TRACE_USR2(("Replace Trigger Test"));
    int oldCount = rrTriggerTest.mCount;
    int oldDeviceID = rrTriggerTest.mDeviceID;
    rrTriggerTest.mTestPath = 1;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(oldCount == rrTriggerTest.mCount);
    CPPUNIT_ASSERT((oldDeviceID+1) == rrTriggerTest.mDeviceID);

    // update test
    ETG_TRACE_USR2(("Update Trigger Test"));
    oldCount = rrTriggerTest.mCount;
    oldDeviceID = rrTriggerTest.mDeviceID;
    rrTriggerTest.mTestPath = 2;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(oldCount == rrTriggerTest.mCount);
    CPPUNIT_ASSERT(oldDeviceID == rrTriggerTest.mDeviceID);

    // delete test
    ETG_TRACE_USR2(("Delete Trigger Test"));
    oldCount = rrTriggerTest.mCount;
    oldDeviceID = rrTriggerTest.mDeviceID;
    rrTriggerTest.mTestPath = 3;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT((oldCount-1) == rrTriggerTest.mCount);
    CPPUNIT_ASSERT(oldDeviceID == rrTriggerTest.mDeviceID);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::UpdateDevice_TriggerTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* use a request / response state machine for testing the trigger */
    class TriggerTestRR : public RequestResponseSM
    {

        int HandleInitRequest()
        {
            triggerID  = 0;
            triggerID2 = 0;
            return 0;
        }

        int HandleLoopBackMessage(const char *allParameters)
        {
            (void)allParameters;

            tResult res = MP_NO_ERROR;//lint !e578

            switch(mTestPath) {
            case 1: // ends with timeout, because connection state does not match
                triggerID = LocalSPM::GetDBManager().OnUpdateTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST",
                        IN "Devices", IN "ConnectionState", IN "WHEN NEW.ConnectionState=1000"); // must not work!
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN mDeviceID, IN "MyNewName",
                        IN CS_HW_MALFUNCTION, IN DS_INITIALIZING);
                CPPUNIT_ASSERT(res == 0);
                break;
            case 2: // ends with timeout, because connection state does not match
                triggerID = LocalSPM::GetDBManager().OnUpdateTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST",
                        IN "Devices", IN "ConnectionState", IN "WHEN OLD.ConnectionState<>3 AND NEW.ConnectionState=3");
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN mDeviceID, IN "MyNewName",
                        IN (tConnectionState)1000, IN DS_INITIALIZING);
                CPPUNIT_ASSERT(res == 0);
                break;
            case 3: // ends with trigger call
                triggerID = LocalSPM::GetDBManager().OnUpdateTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST",
                        IN "Devices", IN "ConnectionState", IN "WHEN OLD.ConnectionState<>3 AND NEW.ConnectionState=3");
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN mDeviceID, IN "MyNewName",
                        IN (tConnectionState)CS_HW_MALFUNCTION, IN DS_INITIALIZING);
                CPPUNIT_ASSERT(res == 0);
                break;
            case 4: // ends with timeout because ConnectionState is already 3
                triggerID = LocalSPM::GetDBManager().OnUpdateTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST",
                        IN "Devices", IN "ConnectionState", IN "WHEN OLD.ConnectionState<>3 AND NEW.ConnectionState=3");
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN mDeviceID, IN "MyNewName",
                        IN (tConnectionState)CS_HW_MALFUNCTION, IN DS_INITIALIZING);
                CPPUNIT_ASSERT(res == 0);
                break;
            case 5: // ends ONE trigger
                triggerID = LocalSPM::GetDBManager().OnUpdateTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST",
                        IN "Devices", IN "ConnectionState", IN "WHEN OLD.ConnectionState<>3 AND NEW.ConnectionState=3");
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                triggerID2 = LocalSPM::GetDBManager().OnUpdateTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST",
                        IN "Devices", IN "ConnectionState", IN "WHEN NEW.ConnectionState=1000");
                ETG_TRACE_USR2(("triggerID2=%d", triggerID2));
                res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN mDeviceID, IN "MyNewName",
                        IN (tConnectionState)1000, IN DS_INITIALIZING);
                CPPUNIT_ASSERT(res == 0);
                break;
            case 6: // ends with timeout because IndexingState is not involved
                triggerID = LocalSPM::GetDBManager().OnUpdateTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST",
                        IN "Devices", IN "IndexingState", IN "WHEN OLD.IndexingState<>NEW.IndexingState");
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN mDeviceID, IN "MyNewName",
                        IN (tConnectionState)CS_HW_MALFUNCTION, IN DS_INITIALIZING);
                CPPUNIT_ASSERT(res == 0);
                break;
            default:
                CPPUNIT_ASSERT(false);
                break;
        }

            return 0;
        } //lint !e578

        int HandleSuccessRequest(const char *allParameters)
        {
            (void)allParameters;

            tResult res = MP_NO_ERROR;//lint !e578

            /* check the incoming values */
            if (allParameters && strlen_r(allParameters)) {
                mCallbackCallCount++;
                ETG_TRACE_USR3(("HandleSuccessRequest(%40s): %d", allParameters, mCallbackCallCount));
            } else {
                ETG_TRACE_USR3(("HandleSuccessRequest() called on timeout"));
            }

            /* read out the returned values */
            UnMarshal(allParameters, "ii", &mCount, &mDeviceID);

            /* deregister the trigger */
            res = LocalSPM::GetDBManager().UnregisterTrigger(IN triggerID);
            CPPUNIT_ASSERT(res == 0);

            if (triggerID2) {
                res = LocalSPM::GetDBManager().UnregisterTrigger(IN triggerID2);
                CPPUNIT_ASSERT(res == 0);
            }

            /* this state machine ends on timeout */
            SendAnswer(NULL);

            return 0;
        }

    public:
        tTriggerID triggerID;
        tTriggerID triggerID2;
        int mTestPath;

        tDeviceID mDeviceID;
        int mCount;
        int mCallbackCallCount;
    };

    tDeviceInfo deviceInfo;

    /* send LOOP_BACK_MESSAGE to start the tests */
    TriggerTestRR rrTriggerTest;
    char message[128];
    strncpy_r(OUT message, IN rrTriggerTest.GetSMNameFull(), IN sizeof(message));
    strncat_r(OUT message, "::LOOP_BACK_MESSAGE", IN sizeof(message));

    res = LocalSPM::GetDBManager().GetDevice(OUT rrTriggerTest.mDeviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    // update test
    ETG_TRACE_USR2(("Update Trigger Test - 1"));
    rrTriggerTest.mTestPath = 1;
    rrTriggerTest.mCallbackCallCount = 0;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(rrTriggerTest.mCallbackCallCount == 0);

    // update test
    ETG_TRACE_USR2(("Update Trigger Test - 2"));
    rrTriggerTest.mTestPath = 2;
    rrTriggerTest.mCallbackCallCount = 0;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(rrTriggerTest.mCallbackCallCount == 0);

    // update test
    ETG_TRACE_USR2(("Update Trigger Test - 3"));
    rrTriggerTest.mTestPath = 3;
    rrTriggerTest.mCallbackCallCount = 0;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(rrTriggerTest.mCallbackCallCount == 1);

    // update test
    ETG_TRACE_USR2(("Update Trigger Test - 4"));
    rrTriggerTest.mTestPath = 4;
    rrTriggerTest.mCallbackCallCount = 0;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(rrTriggerTest.mCallbackCallCount == 0);

    // update test
    ETG_TRACE_USR2(("Update Trigger Test - 5"));
    rrTriggerTest.mTestPath = 5;
    rrTriggerTest.mCallbackCallCount = 0;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(rrTriggerTest.mCallbackCallCount == 1);

    // update test
    ETG_TRACE_USR2(("Update Trigger Test - 6"));
    rrTriggerTest.mTestPath = 6;
    rrTriggerTest.mCallbackCallCount = 0;
    res = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(rrTriggerTest.mCallbackCallCount == 0);

    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN rrTriggerTest.mDeviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(!strcmp(deviceInfo.deviceName, "MyNewName"));
    CPPUNIT_ASSERT(deviceInfo.deviceState == DS_INITIALIZING);
    //CPPUNIT_ASSERT(deviceInfo.connectionType == DCT_BLUETOOTH);

    /* correct the test entry */
    res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN rrTriggerTest.mDeviceID, IN "USB", IN CS_CONNECTED, IN DS_OK);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::Performance_CreateFileList_GetMediaObjects(int &noOfObjects, const int listID, int offset, int count)
{
    ENTRY_INTERNAL

    tResult res = MP_NO_ERROR;
    tMediaObject mediaObject;

    /* get a media objects forward */
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN offset);
        if (res != 0) break;

        // next row
        offset++;
        noOfObjects++;
        count--;
        if (!count) break;
    }

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::Performance_CreateFileList_GetMediaObjects_LTY_FILELIST()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID = LIST_ID_NONE;
    tDeviceID deviceID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    const char *path = (const char *)"/music/Garbage/";
    tListType listType = LTY_FILELIST;
    timeval startTime;
    timeval endTime;
    unsigned long durationUS;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    // meas the start time
    durationUS = 0;
    gettimeofday(&startTime, NULL);

    /* create a file list from directory "/music/Garbage/" */
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID, INOUT listType, IN path, IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* get the counts */
    res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listID);
    CPPUNIT_ASSERT(res == 0);

    // meas the end time
    gettimeofday(&endTime, NULL);

    // calc the duration and sum it up
    durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    ETG_TRACE_USR4(("perf: CreateMediaPlayerFileList: %lf us", (double)(durationUS)));

    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_FILELIST);

    /*
     * get a media objects forward
     * Attention: file list is sorted
     */
    int offset;
    int count;
    enum {noOfTests = 2};
    int noOfObjects;

    durationUS = 0;
    noOfObjects = 0;

    for (int i=0; i<noOfTests; i++) {

        /* set the parameter randomly */
        offset = (numberOfMediaObjects * rand()) / RAND_MAX;
        count = (15 * rand()) / RAND_MAX;

        // meas the start time
        gettimeofday(&startTime, NULL);

        /* request slice / data */
        Performance_CreateFileList_GetMediaObjects(INOUT noOfObjects, IN listID, IN offset, IN count);

        // meas the end time
        gettimeofday(&endTime, NULL);

        // calc the duration and sum it up
        durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    }

    if (!noOfObjects) noOfObjects = 1;
    ETG_TRACE_USR4(("perf: mean time: Performance_CreateFileList_GetMediaObjects: %lf us", ((double)durationUS/(double)noOfObjects))); // lint !e653

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::Performance_CreateFileList_GetMediaObjects_LTY_FILELIST_UNSORTED()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID = LIST_ID_NONE;
    tDeviceID deviceID;
    const char *path = (const char *)"/music/Garbage/";
    tListType listType = LTY_FILELIST_UNSORTED;
    timeval startTime;
    timeval endTime;
    unsigned long durationUS;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    // meas the start time
    durationUS = 0;
    gettimeofday(&startTime, NULL);

    /* create a list */
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID, INOUT listType, IN path, IN deviceID);

    // meas the end time
    gettimeofday(&endTime, NULL);

    // calc the duration and sum it up
    durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    ETG_TRACE_USR4(("perf: CreateMediaPlayerFileListUnsorted: %lf us", (double)(durationUS)));

    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_FILELIST_UNSORTED);

    /*
     * get a media objects forward
     * Attention: file list is sorted
     */
    enum {noOfTests = 2};
    int noOfObjects;

    durationUS = 0;
    noOfObjects = 0;

    for (int i=0; i<noOfTests; i++) {

        // meas the start time
        gettimeofday(&startTime, NULL);

        /* request slice / data */
        Performance_CreateFileList_GetMediaObjects(INOUT noOfObjects, IN listID, IN 0, IN 100000);

        // meas the end time
        gettimeofday(&endTime, NULL);

        // calc the duration and sum it up
        durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    }

    if (!noOfObjects) noOfObjects=1;

    ETG_TRACE_USR4(("perf: mean time: Performance_CreateFileList_GetMediaObjects: %lf us", (double)((double)durationUS/(double)noOfObjects))); // lint !e653

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::Performance_CreateFileList_GetMediaObjects_LTY_BROWSELIST()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID = LIST_ID_NONE;
    tDeviceID deviceID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    const char *path = (const char *)"/music/Garbage/";
    tListType listType = LTY_FILELIST;
    timeval startTime;
    timeval endTime;
    unsigned long durationUS;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

#if 0
    /* set indexingState to IDS_COMPLETE */
    tIndexingState indexingState = IDS_COMPLETE;
    tIndexingPercentComplete percent = 100;
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN indexingState, IN percent);
    CPPUNIT_ASSERT(res == 0);

    /* get the device information*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(IDS_COMPLETE == deviceInfo.indexedState);
#endif

    // meas the start time
    durationUS = 0;
    gettimeofday(&startTime, NULL);

    /* create a browse list from directory "/music/Garbage/" */
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID, INOUT listType, IN path, IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* get the counts */
    res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listID);
    CPPUNIT_ASSERT(res == 0);

    // meas the end time
    gettimeofday(&endTime, NULL);

    // calc the duration and sum it up
    durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    ETG_TRACE_USR4(("perf: CreateMediaPlayerBrowseList: %lf us", (double)(durationUS)));

    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_BROWSELIST);

    /*
     * get a media objects forward
     * Attention: browse list is sorted in another way
     */
    int offset;
    int count;
    enum {noOfTests = 2};
    int noOfObjects;

    durationUS = 0;
    noOfObjects = 0;

    for (int i=0; i<noOfTests; i++) {

        /* set the parameter randomly */
        offset = (numberOfMediaObjects * rand()) / RAND_MAX;
        count = (15 * rand()) / RAND_MAX;

        // meas the start time
        gettimeofday(&startTime, NULL);

        /* request slice / data */
        Performance_CreateFileList_GetMediaObjects(INOUT noOfObjects, IN listID, IN offset, IN count);

        // meas the end time
        gettimeofday(&endTime, NULL);

        // calc the duration and sum it up
        durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    }

    if (!noOfObjects) noOfObjects = 1;
    ETG_TRACE_USR4(("perf: mean time: Performance_CreateFileList_GetMediaObjects: %lf us", (double)((double)durationUS/(double)noOfObjects))); // lint !e653

#if 0
    /* reset indexingState to IDS_NOT_STARTED again */
    indexingState = IDS_NOT_STARTED;
    percent = 0;
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN indexingState, IN percent);
    CPPUNIT_ASSERT(res == 0);
#endif

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::InsertUniqueSpecialString()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    Query query;

    tUUID UUID;
    tTitle title;
    tMetadata tag1;
    tMetadata tag2;
    tMetadata tag3;
    tMetadata tag4;
    tURL URL;
    tDateTime dateTime;
    tDeviceID deviceID = 0x9999;

    snprintf(UUID, sizeof(UUID), "uuid_x_%d", UUID);
    snprintf(title, sizeof(title), "title_x_%d", 99999);
    snprintf(tag1, sizeof(tag1), "tag1_x_%d", tag1);
    snprintf(tag2, sizeof(tag2), "tag2_x_%d", tag2);
    snprintf(tag3, sizeof(tag3), "tag3_x_%d", tag3);
    snprintf(tag4, sizeof(tag4), "tag4_x_%d", tag4);

    time_t rawtime;
    time(&rawtime);
    struct tm *timeinfo;
    timeinfo = localtime(&rawtime);
    strftime(dateTime, sizeof(dateTime), "%Y:%m:%d %H:%M:%S", timeinfo);

    /* prepare insert */
    res = query.Insert(LTY_MEDIAOBJECTS_INSERT);
    CPPUNIT_ASSERT(res == 0);

    /* create first IPOD URL */
    LocalSPM::GetCustomControl().Marshal(OUT URL, sizeof(URL), 0xfe, "iiiit", 1,2,3,4,"mt");

    /* insert first object */
    res = query.Put("iittttttttiiititiiltiii",
            IN deviceID,
            IN CTY_SONG,
            IN URL,
            IN UUID,
            IN UUID,
            IN title,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN 0,       //metadataConvertFlag
            IN 0,       //compilationFlag
            IN 30000,   //totalPlaytime
            IN URL,     //albumArtString
            IN 1,       //trackNumber
            IN URL,     //path
            IN FNP_PLAYABLE,
            IN MTY_MUSIC_FILE,
            IN 4300000LL, //fileSize
            IN dateTime,
            IN 356,     //fileMode = 544(octal)
            IN 1400,    //userID
            IN 1401);   //groupID
    CPPUNIT_ASSERT(res == 0);

    /* create second IPOD URL */
    LocalSPM::GetCustomControl().Marshal(OUT URL, sizeof(URL), 0xfe, "iiiit", 1,2,3,5,"mt");

    /* insert second object */
    res = query.Put("iittttttttiiititiiltiii",
            IN deviceID,
            IN CTY_SONG,
            IN URL,
            IN UUID,
            IN UUID,
            IN title,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN 0,       //metadataConvertFlag
            IN 0,       //compilationFlag
            IN 30000,   //totalPlaytime
            IN URL,     //albumArtString
            IN 1,       //trackNumber
            IN URL,     //path
            IN FNP_PLAYABLE,
            IN MTY_MUSIC_FILE,
            IN 4300000LL, //fileSize
            IN dateTime,
            IN 356,     //fileMode = 544(octal)
            IN 1400,    //userID
            IN 1401);   //groupID
    CPPUNIT_ASSERT(res == 0);

    /* prepare delete */
    res = query.Delete(LTY_MEDIAOBJECTS_DELETE);
    CPPUNIT_ASSERT(res == 0);

    /* try to remove the given object */
    res = query.Remove("it", IN deviceID, IN URL);
    CPPUNIT_ASSERT(res == 0);

    /* prepare insert again */
    res = query.Insert(LTY_MEDIAOBJECTS_INSERT);
    CPPUNIT_ASSERT(res == 0);

    /* insert second object twice */
    res = query.Put("iittttttttiiititiiltiii",
            IN deviceID,
            IN CTY_SONG,
            IN URL,
            IN UUID,
            IN UUID,
            IN title,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN 0,       //metadataConvertFlag
            IN 0,       //compilationFlag
            IN 10000,   //totalPlaytime
            IN URL,     //albumArtString
            IN 99,      //trackNumber
            IN URL,     //path
            IN MTY_MUSIC_FILE,
            IN FNP_NOT_PLAYABLE,
            IN 9171000LL, //fileSize
            IN dateTime,
            IN 511,     //fileMode = 777(octal)
            IN 0,       //userID
            IN 0);      //groupID
    CPPUNIT_ASSERT(res == 0); //Reinsert should work (if failed then ignore insert)

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::Performance_InsertUniqueString()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    timeval startTime;
    timeval endTime;
    unsigned long durationUS;
    Query query;
    //int ID;
    FILE *fp;
    int iTest;
    tURL URL;
    struct tm *timeinfo;
    tDateTime dateTime;
    tDeviceID deviceID = 0x9999;

    // delete the old tests records in DB
    res = query.Delete(LTY_MEDIAOBJECTS_DELETE);
    CPPUNIT_ASSERT(res == 0);
    query.Remove("i", IN deviceID);

    // prepare insert
    res = query.Insert(LTY_MEDIAOBJECTS_INSERT);
    CPPUNIT_ASSERT(res == 0);

    // do an ls over the root file system to get valid URL's
    res = system("find /var > /tmp/filelist.txt");
    fp = fopen("/tmp/filelist.txt", "r");
    CPPUNIT_ASSERT(fp != NULL);

    durationUS = 0;
    enum {noOfTests = 2000};
    enum {printModulo = 200};
    //ID = 0x100000;

    /* open an transaction */
    query.BeginTransaction(LTY_MEDIAOBJECTS_INSERT);

    /* loop over some inserts */
    for(iTest=1; iTest < 1+noOfTests; iTest++) {

        // read in one name
        if (fgets(URL, sizeof(URL), fp) == NULL) break;

        // meas the start time
        gettimeofday(&startTime, NULL);

        tUUID UUID;
        tTitle title;
        tMetadata tag1;
        tMetadata tag2;
        tMetadata tag3;
        tMetadata tag4;

        snprintf(UUID, sizeof(UUID), "uuid_x_%d", UUID);
        snprintf(title, sizeof(title), "title_x_%d", iTest);
        snprintf(tag1, sizeof(tag1), "tag1_x_%d", tag1);
        snprintf(tag2, sizeof(tag2), "tag2_x_%d", tag2);
        snprintf(tag3, sizeof(tag3), "tag3_x_%d", tag3);
        snprintf(tag4, sizeof(tag4), "tag4_x_%d", tag4);

        timeinfo = localtime(&endTime.tv_sec);
        strftime(dateTime, sizeof(dateTime), "%Y:%m:%d %H:%M:%S", timeinfo);

        // insert the object
        res = query.Put("iittttttttiiititiiltiii",
                IN deviceID,
                IN CTY_SONG,
                IN URL,
                IN UUID,
                IN UUID,
                IN title,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                IN 0,       //metadataConvertFlag
                IN 0,       //compilationFlag
                IN 30000,   //totalPlaytime
                IN URL,     //albumArtString
                IN 1,       //trackNumber
                IN URL,     //path
                IN FNP_PLAYABLE,
                IN MTY_MUSIC_FILE,
                IN 4300000LL, //fileSize
                IN dateTime,
                IN 356,     //fileMode = 544(octal)
                IN 1400,    //userID
                IN 1401);   //groupID

        if (!(iTest % printModulo)) {
            query.EndTransaction();

            // meas the end time
            gettimeofday(&endTime, NULL);

            query.BeginTransaction(LTY_MEDIAOBJECTS_INSERT);
        } else {

            // meas the end time
            gettimeofday(&endTime, NULL);
        }

        // calc the duration and sum it up
        durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);

        // print result
        if (!(iTest % printModulo)) {
            ETG_TRACE_USR4(("perf: Performance_InsertUniqueString: %lf us/Put()", ((double)durationUS/(double)printModulo)));
            durationUS = 0;
        }
    }
    query.EndTransaction();
    CPPUNIT_ASSERT(iTest > (noOfTests/2));

    fclose(fp);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::MyMediaUpdateManager()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    Query query;
    tDeviceID deviceID = 0x9999;
    int countMain;
    int countMyMe;

    /* count the objects for test device in main database */
    res = query.Select(LTY_MEDIAOBJECTS_PLAYABLE_FILTER_COUNT, IN deviceID, "iiiiiii",
        IN 0, IN CTY_SONG, IN CTY_VIDEO, IN CTY_PODCAST, IN CTY_AUDIOBOOK,
        IN 0, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    res = query.Get("i", OUT &countMain);
    query.End();
    CPPUNIT_ASSERT(res == 0);

    /* start update my media and interrupt it several times */
    srand(0);
    for(unsigned int i=0; i<30; i++) {

        /* add it to my media */
        res = LocalSPM::GetDBManager().UpdateMyMediaDatabase(IN deviceID);
        CPPUNIT_ASSERT(res == 0);

        /* wait a random time */
        usleep(300000L+((unsigned long)rand()*1000000L)/RAND_MAX);

        /* remove it again, it is  not fully added right now */
        res = LocalSPM::GetDBManager().RemoveDeviceFromMyMedia(IN deviceID);
        CPPUNIT_ASSERT(res == 0);

        /* wait a random time */
        usleep(300000L+((unsigned long)rand()*1000000L)/RAND_MAX);
    }

    /* finally add it and cozunt the entries in my media */
    res = LocalSPM::GetDBManager().UpdateMyMediaDatabase(IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    /* count the objects for test device in main database */
    res = query.Select(LTY_MEDIAOBJECTS_MYME_PLAYABLE_FILTER_COUNT, IN deviceID, "iiiiiii",
        IN 0, IN CTY_SONG, IN CTY_VIDEO, IN CTY_PODCAST, IN CTY_AUDIOBOOK,
        IN 0, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    res = query.Get("i", OUT &countMyMe);
    query.End();
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(countMain == countMyMe);

    /* finally remove the test device from my media */
    res = LocalSPM::GetDBManager().RemoveDeviceFromMyMedia(IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    /* count the objects for test device in main database */
    res = query.Select(LTY_MEDIAOBJECTS_MYME_PLAYABLE_FILTER_COUNT, IN deviceID, "iiiiiii",
        IN 0, IN CTY_SONG, IN CTY_VIDEO, IN CTY_PODCAST, IN CTY_AUDIOBOOK,
        IN 0, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    res = query.Get("i", OUT &countMyMe);
    query.End();
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(countMyMe == 0);
}

void DBManagerTest::CreateMediaObject()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    res = LocalSPM::GetDBManager().GetDevice(OUT mediaObject.deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    mediaObject.catType = CTY_SONG;
    strncpy_r(OUT mediaObject.fileName, "/mydir/myfile.mp3", IN sizeof(mediaObject.fileName));
    strncpy_r(OUT mediaObject.UUID, "any UUID", IN sizeof(mediaObject.UUID));
    strncpy_r(OUT mediaObject.parentUUID, "any parent UUID", IN sizeof(mediaObject.parentUUID));
    strncpy_r(OUT mediaObject.title, "My Song", IN sizeof(mediaObject.title)); //song title
    strncpy_r(OUT mediaObject.MetadataField1, "Rock", IN sizeof(mediaObject.MetadataField1)); //genre
    strncpy_r(OUT mediaObject.MetadataField2, "Thoemel", IN sizeof(mediaObject.MetadataField2)); //artist
    strncpy_r(OUT mediaObject.MetadataField3, "Ghostwriter", IN sizeof(mediaObject.MetadataField3)); //composer
    strncpy_r(OUT mediaObject.MetadataField4, "my first album", IN sizeof(mediaObject.MetadataField4)); //album
    mediaObject.metadataConvertFlag = 0;
    mediaObject.compilationFlag = 0;
    mediaObject.totalPlaytime = 30000;
    strncpy_r(OUT mediaObject.albumArtString, "/mydir/myfile.mp3", IN sizeof(mediaObject.albumArtString));
    mediaObject.trackNumber = 7;
    strncpy_r(OUT mediaObject.path, "/mydir/", IN sizeof(mediaObject.path));
    mediaObject.notPlayable = FNP_PLAYABLE;
    mediaObject.fileSize = 1567000LL;
    strncpy_r(OUT mediaObject.dateTime, "2016:07:08 14:56:00", IN sizeof(mediaObject.dateTime));
    mediaObject.fileMode = 356;
    mediaObject.userID = 190;
    mediaObject.groupID = 49;

    // get the DB info for the device
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN mediaObject.deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* put the device information into the media object */
    strncpy_r(OUT mediaObject.deviceVersion, IN deviceInfo.deviceVersion, IN sizeof(mediaObject.deviceVersion));
    strncpy_r(OUT mediaObject.mountPoint, IN deviceInfo.mountPoint, IN sizeof(mediaObject.mountPoint));
    mediaObject.deviceType = deviceInfo.deviceType;

    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);

    /* get the media object to compare */
    tMediaObject newMediaObject;
    InitMediaObject(OUT newMediaObject);
    res = LocalSPM::GetDBManager().GetObjectID(OUT newMediaObject.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetMediaObject(OUT newMediaObject, INOUT newMediaObject.objectID);
    CPPUNIT_ASSERT(res == 0);
    VARTRACE(newMediaObject);
    CPPUNIT_ASSERT(mediaObject.deviceID == newMediaObject.deviceID);
    CPPUNIT_ASSERT(mediaObject.catType == newMediaObject.catType);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, newMediaObject.fileName) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.UUID, newMediaObject.UUID) == 0);
    //CPPUNIT_ASSERT(strcmp(mediaObject.parentUUID, newMediaObject.parentUUID) == 0); //not part of Get query yet
    CPPUNIT_ASSERT(strcmp(mediaObject.title, newMediaObject.title) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField1, newMediaObject.MetadataField1) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField2, newMediaObject.MetadataField2) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField3, newMediaObject.MetadataField3) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField4, newMediaObject.MetadataField4) == 0);
    CPPUNIT_ASSERT(mediaObject.metadataConvertFlag == newMediaObject.metadataConvertFlag);
    CPPUNIT_ASSERT(mediaObject.compilationFlag == newMediaObject.compilationFlag);
    CPPUNIT_ASSERT(mediaObject.totalPlaytime == newMediaObject.totalPlaytime);
    CPPUNIT_ASSERT(strstr(newMediaObject.albumArtString, mediaObject.albumArtString)); //DBManager add mount point to album art string
    CPPUNIT_ASSERT(mediaObject.trackNumber == newMediaObject.trackNumber);
    CPPUNIT_ASSERT(strcmp(mediaObject.path, newMediaObject.path) == 0);
    CPPUNIT_ASSERT(mediaObject.notPlayable == newMediaObject.notPlayable);
    CPPUNIT_ASSERT(mediaObject.fileSize == newMediaObject.fileSize);
    CPPUNIT_ASSERT(strcmp(mediaObject.dateTime, newMediaObject.dateTime) == 0);
    CPPUNIT_ASSERT(mediaObject.fileMode == newMediaObject.fileMode);
    CPPUNIT_ASSERT(mediaObject.userID == newMediaObject.userID);
    CPPUNIT_ASSERT(mediaObject.groupID == newMediaObject.groupID);
    CPPUNIT_ASSERT(strcmp(mediaObject.deviceVersion, newMediaObject.deviceVersion) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.mountPoint, newMediaObject.mountPoint) == 0);
    CPPUNIT_ASSERT(mediaObject.deviceType == newMediaObject.deviceType);
}

void DBManagerTest::CreateMediaObject_WithNoMetadata()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    res = LocalSPM::GetDBManager().GetDevice(OUT mediaObject.deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    mediaObject.catType = CTY_SONG;
    strncpy_r(OUT mediaObject.fileName, "/FOLDER_VIEW_TEST/FOLDER_VIEW/Main_folder/Folder2/Folder3/folder4/Folder5/Folder6/Folder7/09 - Aimee Mann_Humpty Dumpty Bonus, C D_Nightmare Girl.mp3", IN sizeof(mediaObject.fileName));
    strncpy_r(OUT mediaObject.UUID, "any UUID", IN sizeof(mediaObject.UUID));
    strncpy_r(OUT mediaObject.parentUUID, "any parent UUID", IN sizeof(mediaObject.parentUUID));
    // No metadata
    //strncpy_r(OUT mediaObject.title, "", IN sizeof(mediaObject.title));
    //strncpy_r(OUT mediaObject.MetadataField1, "", IN sizeof(mediaObject.MetadataField1));
    //strncpy_r(OUT mediaObject.MetadataField2, "", IN sizeof(mediaObject.MetadataField2));
    //strncpy_r(OUT mediaObject.MetadataField3, "", IN sizeof(mediaObject.MetadataField3));
    //strncpy_r(OUT mediaObject.MetadataField4, "", IN sizeof(mediaObject.MetadataField4));
    mediaObject.metadataConvertFlag = 0;
    mediaObject.compilationFlag = 0;
    mediaObject.totalPlaytime = 30000;
    strncpy_r(OUT mediaObject.albumArtString, "/FOLDER_VIEW_TEST/FOLDER_VIEW/Main_folder/Folder2/Folder3/folder4/Folder5/Folder6/Folder7/09 - Aimee Mann_Humpty Dumpty Bonus, C D_Nightmare Girl.mp3", IN sizeof(mediaObject.albumArtString));
    mediaObject.trackNumber = 1;
    strncpy_r(OUT mediaObject.path, "/FOLDER_VIEW_TEST/FOLDER_VIEW/Main_folder/Folder2/Folder3/folder4/Folder5/Folder6/Folder7/", IN sizeof(mediaObject.path));
    mediaObject.notPlayable = FNP_PLAYABLE;
    mediaObject.fileSize = 3867000LL;
    strncpy_r(OUT mediaObject.dateTime, "2016:07:08 15:17:00", IN sizeof(mediaObject.dateTime));
    mediaObject.fileMode = 511;
    mediaObject.userID = 133;
    mediaObject.groupID = 151;

    // get the DB info for the device
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN mediaObject.deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* put the device information into the media object */
    strncpy_r(OUT mediaObject.deviceVersion, IN deviceInfo.deviceVersion, IN sizeof(mediaObject.deviceVersion));
    strncpy_r(OUT mediaObject.mountPoint, IN deviceInfo.mountPoint, IN sizeof(mediaObject.mountPoint));
    mediaObject.deviceType = deviceInfo.deviceType;

    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);

    /* get the media object to compare */
    tMediaObject newMediaObject;
    InitMediaObject(OUT newMediaObject);
    res = LocalSPM::GetDBManager().GetObjectID(OUT newMediaObject.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetMediaObject(OUT newMediaObject, INOUT newMediaObject.objectID);
    CPPUNIT_ASSERT(res == 0);
    VARTRACE(newMediaObject);
    CPPUNIT_ASSERT(mediaObject.deviceID == newMediaObject.deviceID);
    CPPUNIT_ASSERT(mediaObject.catType == newMediaObject.catType);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, newMediaObject.fileName) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.UUID, newMediaObject.UUID) == 0);
    //CPPUNIT_ASSERT(strcmp(mediaObject.parentUUID, newMediaObject.parentUUID) == 0); //not part of Get query yet
    //CPPUNIT_ASSERT(strcmp(mediaObject.title, newMediaObject.title) == 0); //if title is empty the filename is taken
    CPPUNIT_ASSERT(strcmp(newMediaObject.MetadataField1, LocalSPM::GetDataProvider().DBUnknownText().c_str()) == 0);
    CPPUNIT_ASSERT(strcmp(newMediaObject.MetadataField2, LocalSPM::GetDataProvider().DBUnknownText().c_str()) == 0);
    CPPUNIT_ASSERT(strcmp(newMediaObject.MetadataField3, LocalSPM::GetDataProvider().DBUnknownText().c_str()) == 0);
    CPPUNIT_ASSERT(strcmp(newMediaObject.MetadataField4, LocalSPM::GetDataProvider().DBUnknownText().c_str()) == 0);
    CPPUNIT_ASSERT(mediaObject.metadataConvertFlag == newMediaObject.metadataConvertFlag);
    CPPUNIT_ASSERT(mediaObject.compilationFlag == newMediaObject.compilationFlag);
    CPPUNIT_ASSERT(mediaObject.totalPlaytime == newMediaObject.totalPlaytime);
    CPPUNIT_ASSERT(strstr(newMediaObject.albumArtString, mediaObject.albumArtString)); //DBManager add mount point to album art string
    CPPUNIT_ASSERT(mediaObject.trackNumber == newMediaObject.trackNumber);
    CPPUNIT_ASSERT(strcmp(mediaObject.path, newMediaObject.path) == 0);
    CPPUNIT_ASSERT(mediaObject.notPlayable == newMediaObject.notPlayable);
    CPPUNIT_ASSERT(mediaObject.fileSize == newMediaObject.fileSize);
    CPPUNIT_ASSERT(strcmp(mediaObject.dateTime, newMediaObject.dateTime) == 0);
    CPPUNIT_ASSERT(mediaObject.fileMode == newMediaObject.fileMode);
    CPPUNIT_ASSERT(mediaObject.userID == newMediaObject.userID);
    CPPUNIT_ASSERT(mediaObject.groupID == newMediaObject.groupID);
    CPPUNIT_ASSERT(strcmp(mediaObject.deviceVersion, newMediaObject.deviceVersion) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.mountPoint, newMediaObject.mountPoint) == 0);
    CPPUNIT_ASSERT(mediaObject.deviceType == newMediaObject.deviceType);
}

void DBManagerTest::UpdateMediaObject()
{
    // this test is for the race condition problem in the query object
    ENTRY
    ETG_TRACE_USR1(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    tListID listID;
    tMediaObject mediaObject;

    InitMediaObject(OUT mediaObject);
    strncpy_r(OUT mediaObject.fileName, "/Unheilig/Grosse_Freiheit/Unheilig_-_Grosse_Freiheit_-_16_-_Neuland.mp3", IN sizeof(mediaObject.fileName));

    res = LocalSPM::GetDBManager().GetDevice(OUT mediaObject.deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);

    /* get media object*/
    tObjectID idFromMediaObjects = OBJECT_ID_NONE;
    res = LocalSPM::GetDBManager().GetObjectID(OUT idFromMediaObjects, IN mediaObject.deviceID, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(idFromMediaObjects != OBJECT_ID_NONE);

    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, INOUT idFromMediaObjects);
    CPPUNIT_ASSERT(res == 0);

    /* update the notPlayable in MediaObjects table */
    mediaObject.notPlayable = FNP_DRM_PROTECTED;
    res = LocalSPM::GetDBManager().UpdateMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    /* create a browsable list out of the filter tag which is an object id for a album, artist, genre, ... */
    res = LocalSPM::GetDBManager().CreateList(OUT listID, IN mediaObject.objectID, IN LTY_SONG, IN PC_NO_REPEAT, IN MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);

    /* update the notPlayable in MediaObjects table */
    mediaObject.notPlayable = FNP_NOT_PLAYABLE;
    res = LocalSPM::GetDBManager().UpdateMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::UpdateMediaObjects_Select_Update()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test for a specific device
     */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN LTY_SONG,
            IN PC_NO_REPEAT,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media object */
    tIndex index = 15;
    tMediaObject mediaObject;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN index);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR2(("title=%s", mediaObject.title));
    CPPUNIT_ASSERT(strcmp(mediaObject.title, "Not My Idea") == 0);

    res = LocalSPM::GetDBManager().ReleaseAccess(IN listID);
    CPPUNIT_ASSERT(res == 0);


    /* modify the object */
    tTitle newTitle;
    strncpy_r(OUT newTitle, IN mediaObject.title, IN sizeof(newTitle));
    strncat_r(OUT newTitle, " - part 2", IN sizeof(newTitle));
    strncpy_r(OUT mediaObject.title, IN newTitle, IN sizeof(mediaObject.title));

    tMetadata newMetadataField1;
    strncpy_r(OUT newMetadataField1, IN mediaObject.MetadataField1, IN sizeof(newMetadataField1));
    strncat_r(OUT newMetadataField1, "_2", IN sizeof(newMetadataField1));
    strncpy_r(OUT mediaObject.MetadataField1, IN newMetadataField1, IN sizeof(mediaObject.MetadataField1));

    tMetadata newMetadataField2;
    strncpy_r(OUT newMetadataField2, IN mediaObject.MetadataField2, IN sizeof(newMetadataField2));
    strncat_r(OUT newMetadataField2, "_2", IN sizeof(newMetadataField2));
    strncpy_r(OUT mediaObject.MetadataField2, IN newMetadataField2, IN sizeof(mediaObject.MetadataField2));

    tMetadata newMetadataField3;
    strncpy_r(OUT newMetadataField3, IN mediaObject.MetadataField3, IN sizeof(newMetadataField3));
    strncat_r(OUT newMetadataField3, "_2", IN sizeof(newMetadataField3));
    strncpy_r(OUT mediaObject.MetadataField3, IN newMetadataField3, IN sizeof(mediaObject.MetadataField3));

    tMetadata newMetadataField4;
    strncpy_r(OUT newMetadataField4, IN mediaObject.MetadataField4, IN sizeof(newMetadataField4));
    strncat_r(OUT newMetadataField4, "_2", IN sizeof(newMetadataField4));
    strncpy_r(OUT mediaObject.MetadataField4, IN newMetadataField4, IN sizeof(mediaObject.MetadataField4));

    tConvertFlag newMetadataConvertFlag;
    if(mediaObject.metadataConvertFlag) newMetadataConvertFlag = false;
    else                                newMetadataConvertFlag = true;
    mediaObject.metadataConvertFlag = newMetadataConvertFlag;

    tCompilation newCompilationFlag;
    if(mediaObject.compilationFlag) newCompilationFlag = false;
    else                            newCompilationFlag = true;
    mediaObject.compilationFlag = newCompilationFlag;

    tPlaytime newTotalPlaytime = mediaObject.totalPlaytime + 1999;
    mediaObject.totalPlaytime = newTotalPlaytime;

    tAlbumArt newAlbumArtString;
    strncpy_r(OUT newAlbumArtString, IN "/tmp/Folder12/AlbumXY/image.jpg", IN sizeof(newAlbumArtString));
    strncpy_r(OUT mediaObject.albumArtString, IN newAlbumArtString, IN sizeof(mediaObject.albumArtString));

    tTrackNumber newTrackNumber = mediaObject.trackNumber + 9;
    mediaObject.trackNumber = newTrackNumber;

    tNotPlayable newNotPlayable;
    if(FNP_NOT_PLAYABLE != mediaObject.notPlayable) newNotPlayable = FNP_NOT_PLAYABLE;
    else                                            newNotPlayable = FNP_PLAYABLE;
    mediaObject.notPlayable = newNotPlayable;

    tFileSize newFileSize = mediaObject.fileSize + 1999999;
    mediaObject.fileSize = newFileSize;

    time_t rawtime;
    time(&rawtime);
    struct tm *timeinfo;
    timeinfo = localtime(&rawtime);
    tDateTime newDateTime;
    strftime(newDateTime, sizeof(newDateTime), "%Y:%m:%d %H:%M:%S", timeinfo);
    strncpy_r(OUT mediaObject.dateTime, IN newDateTime, IN sizeof(mediaObject.dateTime));

    tFileMode newFileMode;
    if(S_IWOTH & mediaObject.fileMode) newFileMode = mediaObject.fileMode & ~S_IWOTH;
    else                               newFileMode = mediaObject.fileMode | S_IWOTH;
    mediaObject.fileMode = newFileMode;

    tUserID newUserID;
    if(0 != mediaObject.userID) newUserID = 0;
    else                        newUserID = 1234;
    mediaObject.userID = newUserID;

    tGroupID newGroupID;
    if(0 != mediaObject.groupID) newGroupID = 0;
    else                         newGroupID = 9876;
    mediaObject.groupID = newGroupID;


    /* store this object in the Songs table, which is locked by the CreateList above: */
    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    /* re-get the old media object, should have the old title */
    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN index);
    CPPUNIT_ASSERT(res == 0);
    VARTRACE(mediaObject);
    CPPUNIT_ASSERT(strcmp(mediaObject.title, newTitle) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField1, newMetadataField1) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField2, newMetadataField2) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField3, newMetadataField3) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField4, newMetadataField4) == 0);
    CPPUNIT_ASSERT(mediaObject.metadataConvertFlag == newMetadataConvertFlag);
    CPPUNIT_ASSERT(mediaObject.compilationFlag == newCompilationFlag);
    CPPUNIT_ASSERT(mediaObject.totalPlaytime == newTotalPlaytime);
    CPPUNIT_ASSERT(strstr(mediaObject.albumArtString, newAlbumArtString)); //DBManager add mount point to album art string
    CPPUNIT_ASSERT(mediaObject.trackNumber == newTrackNumber);
    CPPUNIT_ASSERT(mediaObject.notPlayable == newNotPlayable);
    CPPUNIT_ASSERT(mediaObject.fileSize == newFileSize);
    CPPUNIT_ASSERT(strcmp(mediaObject.dateTime, newDateTime) == 0);
    CPPUNIT_ASSERT(mediaObject.fileMode == newFileMode);
    CPPUNIT_ASSERT(mediaObject.userID == newUserID);
    CPPUNIT_ASSERT(mediaObject.groupID == newGroupID);
}

void DBManagerTest::UpdateMediaObjects_Select_Delete_Before()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test for a specific device
     */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN LTY_SONG,
            IN PC_NO_REPEAT,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media object to be deleted */
    tIndex index = 12;
    tMediaObject mediaObjectDelete;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObjectDelete, IN listID, IN index);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR2(("title=%s", mediaObjectDelete.title));
    CPPUNIT_ASSERT(strcmp(mediaObjectDelete.title, "Milk") == 0);

    /* get a media object to be tested */
    index = 15;
    tMediaObject mediaObject;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN index);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR2(("title=%s", mediaObject.title));
    CPPUNIT_ASSERT(strcmp(mediaObject.title, "Not My Idea - part 2") == 0);

    res = LocalSPM::GetDBManager().ReleaseAccess(IN listID);
    CPPUNIT_ASSERT(res == 0);

    /* delete media object */
    res = LocalSPM::GetDBManager().RemoveMediaObject(IN mediaObjectDelete.objectID);
    CPPUNIT_ASSERT(res == 0);

    /* re-get the old media object, should have the old title */
    index = 14;
    InitMediaObject(INOUT mediaObject);
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN index);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR2(("title=%s", mediaObject.title));
    CPPUNIT_ASSERT(strcmp(mediaObject.title, "Not My Idea - part 2") == 0);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::UpdateMediaObjects_Select_Delete_After()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test for a specific device
     */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN LTY_SONG,
            IN PC_NO_REPEAT,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media object to be deleted */
    tIndex index = 16;
    tMediaObject mediaObjectDelete;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObjectDelete, IN listID, IN index);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR2(("title=%s", mediaObjectDelete.title));
    CPPUNIT_ASSERT(strcmp(mediaObjectDelete.title, "Only Happy When It Rains") == 0);

    /* get a media object to be tested */
    index = 14;
    tMediaObject mediaObject;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN index);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR2(("title=%s", mediaObject.title));
    CPPUNIT_ASSERT(strcmp(mediaObject.title, "Not My Idea - part 2") == 0);

    res = LocalSPM::GetDBManager().ReleaseAccess(IN listID);
    CPPUNIT_ASSERT(res == 0);

    /* delete media object */
    res = LocalSPM::GetDBManager().RemoveMediaObject(IN mediaObjectDelete.objectID);
    CPPUNIT_ASSERT(res == 0);

    /* re-get the old media object, should have the old title */
    index = 14;
    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN index);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR2(("title=%s", mediaObject.title));
    CPPUNIT_ASSERT(strcmp(mediaObject.title, "Not My Idea - part 2") == 0);

    res = LocalSPM::GetDBManager().ReleaseAccess(IN listID);
    CPPUNIT_ASSERT(res == 0);

    /* delete this song to restore the songlist */
    res = LocalSPM::GetDBManager().RemoveMediaObject(IN mediaObject.objectID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::AddSecondUSBDeviceToDB()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    /* scan the second USB test data */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().ScanDirForTest(deviceID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::PrintMyMedia()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    Query query;

    res = query.Select(LTY_MEDIAOBJECTS_MYME, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);

    tUInt counter = 0;
    while(1) {

        tDeviceID deviceID;
        tTitle title;
        tMetadata MetadataField1;
        tMetadata MetadataField2;
        tMetadata MetadataField3;
        tMetadata MetadataField4;
        counter++;

        res = query.Get("-i-------------TTTTT",
                OUT &deviceID,
                OUT title, IN sizeof(title),
                OUT MetadataField1, IN sizeof(MetadataField1),
                OUT MetadataField2, IN sizeof(MetadataField2),
                OUT MetadataField3, IN sizeof(MetadataField3),
                OUT MetadataField4, IN sizeof(MetadataField4));
        if (res) break;

        ETG_TRACE_USR3(("%d: %d, %32s, %32s, %32s, %32s", counter, deviceID, title, MetadataField1, MetadataField2, MetadataField4));
    }

    query.End();

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::UpdateMyMedia()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID1;
    tDeviceID deviceID2;
    tDeviceInfo deviceInfo;

    /* set the both USB devices to connected state and build the my media DB */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID1, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID1);
    CPPUNIT_ASSERT(res == 0);
    if(CS_CONNECTED != deviceInfo.connectionState)
    {
        res = LocalSPM::GetDBManager().DeviceAttached(IN deviceID1);
        CPPUNIT_ASSERT(res == 0);
        res = LocalSPM::GetDBManager().DeviceConnected(IN deviceID1);
        CPPUNIT_ASSERT(res == 0);
    }
    res = LocalSPM::GetDBManager().RemoveDeviceFromMyMedia(IN deviceID1);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID2, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID2);
    CPPUNIT_ASSERT(res == 0);
    if(CS_CONNECTED != deviceInfo.connectionState)
    {
        res = LocalSPM::GetDBManager().DeviceAttached(IN deviceID2);
        CPPUNIT_ASSERT(res == 0);
        res = LocalSPM::GetDBManager().DeviceConnected(IN deviceID2);
        CPPUNIT_ASSERT(res == 0);
    }
    res = LocalSPM::GetDBManager().RemoveDeviceFromMyMedia(IN deviceID2);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().UpdateMyMediaDatabase(IN deviceID1);
    CPPUNIT_ASSERT(res == 0);
    LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID1);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().UpdateMyMediaDatabase(IN deviceID2);
    CPPUNIT_ASSERT(res == 0);
    LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID2);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    // debug
    PrintMyMedia();

    /* check contents of my media table */
    Query query;
    int count;

    res = query.Select(LTY_MEDIAOBJECTS_MYME_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get("i", OUT &count);
    query.End();

    // debug printf("count=%d\n", count);
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(count == 126);
    }
    else
    {
        CPPUNIT_ASSERT(count == 112);
    }

    /* remove the objects from the second device */
    res = LocalSPM::GetDBManager().RemoveMediaObjects(IN deviceID2);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID2);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = query.Select(LTY_MEDIAOBJECTS_COUNT, 1 /* dummy */, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get("i", OUT &count);
    query.End();
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(count == 2065);
    }
    else
    {
        CPPUNIT_ASSERT(count == 2059);
    }

    /* add objects from second device */
    res = LocalSPM::GetDBManager().ScanDirForTest(IN deviceID2);
    CPPUNIT_ASSERT(res == 0);

    res = query.Select(LTY_MEDIAOBJECTS_COUNT, 1 /* dummy */, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get("i", OUT &count);
    query.End();
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(count == 2128);
    }
    else
    {
        CPPUNIT_ASSERT(count == 2114);
    }

#if 1
    /* find a object id for the following tests */
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID2);
    CPPUNIT_ASSERT(res == 0);

    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, listSize-5, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);


    /* check the special get device id select - 1st time */
    tObjectID objectID;
    objectID = mediaObjectVector[0].objectID;
    res = query.Select(LTY_MEDIAOBJECTS_DEVICEID_OBJECTID_FILTER, MY_MEDIA, "ii", IN 0, IN objectID);
    CPPUNIT_ASSERT(res == 0);
    tDeviceID deviceIDRead1;
    res = query.Get("i", OUT &deviceIDRead1);
    query.End();
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceIDRead1 == deviceID2);
#endif

    /* remove the new device from my media only */
    res = LocalSPM::GetDBManager().RemoveDeviceFromMyMedia(IN deviceID2);
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID2);
    CPPUNIT_ASSERT(res == 0);

#if 1
    /* check the special get device id select - 2nd time */
    res = query.Select(LTY_MEDIAOBJECTS_DEVICEID_OBJECTID_FILTER, MY_MEDIA, "ii", IN 0, IN objectID);
    CPPUNIT_ASSERT(res == 0);
    tDeviceID deviceIDRead2;
    res = query.Get("i", OUT &deviceIDRead2);
    query.End();
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceIDRead1 == deviceID2);
#endif

    /* count the my media objects now */
    res = query.Select(LTY_MEDIAOBJECTS_MYME_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get("i", OUT &count);
    query.End();
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(count == 63);
    }
    else
    {
        CPPUNIT_ASSERT(count == 57);
    }

    /* the new objects are NOT in my media, now cleanup main again */
    res = LocalSPM::GetDBManager().UpdateMain(deviceID2);
    CPPUNIT_ASSERT(res == 0);

    res = query.Select(LTY_MEDIAOBJECTS_COUNT, 1 /* dummy */, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get("i", OUT &count);
    query.End();
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(count == 2065);
    }
    else
    {
        CPPUNIT_ASSERT(count == 2059);
    }

    res = query.Select(LTY_MEDIAOBJECTS_MYME_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get("i", OUT &count);
    query.End();
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(count == 63);
    }
    else
    {
        CPPUNIT_ASSERT(count == 57);
    }

    /* add objects from second device only to main data base */
    res = LocalSPM::GetDBManager().ScanDirForTest(IN deviceID2);
    CPPUNIT_ASSERT(res == 0);

    res = query.Select(LTY_MEDIAOBJECTS_MYME_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get("i", OUT &count);
    query.End();
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(count == 126);
    }
    else
    {
        CPPUNIT_ASSERT(count == 112);
    }

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::DeleteAllElementsForSecondDevice()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listIDMyMedia1;
    tListID listIDMyMedia2;
    tListInfo listInfoMyMedia1;
    tListInfo listInfoMyMedia2;
    tDeviceID deviceID;
    tListSize sizeMyMedia1;
    tListSize sizeMyMedia2;
    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tBoolean withListSize = true;

    /* scan the second USB test data */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* create an all songs my media list */
    res = LocalSPM::GetListControl().CreatePlayList(OUT listIDMyMedia1,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetListControl().GetListInfo(OUT listInfoMyMedia1, IN listIDMyMedia1, IN withListSize);
    CPPUNIT_ASSERT(res == 0);
    sizeMyMedia1 = listInfoMyMedia1.listSize;

    /* now delete everything from first USB stick */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().RemoveMediaObjects(IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* now create a second list */
    res = LocalSPM::GetListControl().CreatePlayList(OUT listIDMyMedia2,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetListControl().GetListInfo(OUT listInfoMyMedia2, IN listIDMyMedia2, IN withListSize);
    CPPUNIT_ASSERT(res == 0);
    sizeMyMedia2 = listInfoMyMedia2.listSize;

    /* compare the sizes */
    CPPUNIT_ASSERT(sizeMyMedia1 > sizeMyMedia2);

    /* release the list */
    LocalSPM::GetListControl().ReleaseList(IN listIDMyMedia1);
    LocalSPM::GetListControl().ReleaseList(IN listIDMyMedia2);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::RemoveSecondUSBDevice()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    /* get device id for second usb */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);

    /* mark it as DISCONNECTED in DB */
    res = LocalSPM::GetDBManager().DeviceDisconnected(IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* wait because update is done by a thread */
    LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID);

    // debug
    // PrintMyMedia();

    /* check the my media data base if it was recreated */
    Query query;

    res = query.Select(LTY_MEDIAOBJECTS_MYME_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);

    int count;
    res = query.Get("i", OUT &count);
    query.End();

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(count == 36);
    }
    else
    {
        CPPUNIT_ASSERT(count == 57);
    }

    /* reactivate it for next test */
    res = LocalSPM::GetDBManager().DeviceAttached(IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().DeviceConnected(IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::MoveDeviceToVirtualTableAndBack()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tDeviceInfo deviceInfo;
    tDeviceInfo virtualDeviceInfo;

    /* get device id for second usb */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);

    /* set fingerprint of USB device */
    tFingerprint fingerprint;
    strncpy_r(OUT fingerprint, "USB-Fingerprint: 987654321", IN sizeof(fingerprint));
    tNumberOfFiles numberOfAudioFiles = 100000;
    tNumberOfFiles numberOfVideoFiles = 0;

    res = LocalSPM::GetDBManager().SetFingerprint(IN deviceID, IN fingerprint, IN numberOfAudioFiles, IN numberOfVideoFiles);
    CPPUNIT_ASSERT(res == 0);

    /* get the device information */
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID, IN false /*virtualDevice*/);
    CPPUNIT_ASSERT(res == 0);

    /* add same device as BT device */
    strncpy_r(OUT deviceInfo.serialNumber, "aabbccddeeff", IN sizeof(deviceInfo.serialNumber));
    strncpy_r(OUT deviceInfo.mountPoint, "dev_aa_bb_cc_dd_ee_ff", IN sizeof(deviceInfo.mountPoint));
    deviceInfo.deviceType = DTY_IPHONE;
    deviceInfo.connectionState = CS_CONNECTED;
    deviceInfo.connectionType = DCT_BLUETOOTH;

    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);

    /* move a device from the device table to the virtual devices table of DB */
    res = LocalSPM::GetDBManager().MoveDeviceToFromVirtualTable(IN false /*fromVirtual*/, IN true /*toVirtual*/, IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* get the virtual device information */
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT virtualDeviceInfo, IN deviceID, IN true /*virtualDevice*/);
    CPPUNIT_ASSERT(res == 0);

    /* set device ID of BT device to the one of USB */
    res = LocalSPM::GetDBManager().SetDeviceID(IN deviceInfo.deviceID /*old*/, IN deviceID /*new*/);
    CPPUNIT_ASSERT(res == 0);

    /* set fingerprint of BT device too */
    res = LocalSPM::GetDBManager().SetFingerprint(IN deviceID, IN fingerprint, IN numberOfAudioFiles, IN numberOfVideoFiles);
    CPPUNIT_ASSERT(res == 0);

    /* get the device information */
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID, IN false /*virtualDevice*/);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceInfo.deviceID == virtualDeviceInfo.deviceID);
    CPPUNIT_ASSERT(strcmp(deviceInfo.deviceName, virtualDeviceInfo.deviceName) == 0);

    /* get fingerprint of BT device */
    tFingerprint checkFingerprint;
    res = LocalSPM::GetDBManager().GetFingerprint(OUT checkFingerprint, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(strcmp(fingerprint, checkFingerprint) == 0);


    /* the way back */

    /* checks if the device is in both devices table */
    CPPUNIT_ASSERT(LocalSPM::GetDBManager().IsInBothDeviceTables(IN deviceInfo.deviceName));

    /* moves a device back from the virtual device table to the devices table of DB */
    res = LocalSPM::GetDBManager().MoveDeviceToFromVirtualTable(IN true /*fromVirtual*/, IN false /*toVirtual*/, IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* get the device information */
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID, IN false /*virtualDevice*/);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceInfo.deviceID == virtualDeviceInfo.deviceID);
    CPPUNIT_ASSERT(strcmp(deviceInfo.serialNumber, virtualDeviceInfo.serialNumber) == 0);
    CPPUNIT_ASSERT(strcmp(deviceInfo.deviceName, virtualDeviceInfo.deviceName) == 0);

    /* get fingerprint of USB device */
    res = LocalSPM::GetDBManager().GetFingerprint(OUT checkFingerprint, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(strcmp(fingerprint, checkFingerprint) == 0);
}

void DBManagerTest::MyMediaPerformanceTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tMediaObject mo;
    tListID listID;

    /* get device id for second usb */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);

    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* create a list for that device */
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* get the first media object from that list */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    timeval startTime;
    timeval endTime;
    unsigned long durationUS;

    /* start time sampling */
    durationUS = 0;
    gettimeofday(&startTime, NULL);

    /* now insert 90000 media objects into the data base for the second usb device (rest was done by test before) */
    mo = mediaObjectVector[0];
    for(int i=0; i<90000; i++) {

        /* modify the title and url */
        snprintf(mo.title, sizeof(mo.title), "title_a_%06d", i);
        snprintf(mo.fileName, sizeof(mo.fileName), "filename_a_%06d", i);

        /* add it to the data base */
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mo);
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    /* end time sampling */
    gettimeofday(&endTime, NULL);

    /* get the total number of media objects in DB */
    tNumberOfMediaObjects noOfObjects;
    res = LocalSPM::GetDBManager().GetNumberOfMediaObjectsInDB(OUT noOfObjects);

    /* calc the performance */
    durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    ETG_TRACE_USR2(("UpdateMyMediaDatabase(%d obj)=%lf ms; %lf ms/obj", noOfObjects, (double)(durationUS / 1000.), ((double)(durationUS / 1000.) / noOfObjects)));

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::MyMediaReUpdateTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tMediaObject mo;
    tListID listID;

    /* get device id for second USB */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);

    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* create a list for that device */
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* get the first media object from that list */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

#if TARGET_BUILD
    /* now insert 1000 media objects into the data base for the second usb device */
    const int noOfObjects = 1000;
#else
    /* now insert 10000 media objects into the data base for the second usb device */
    const int noOfObjects = 10000;
#endif
    mo = mediaObjectVector[0];
    for(int i=0; i<noOfObjects; i++) {

        /* modify the title and url */
        snprintf(mo.title, sizeof(mo.title), "title_%06d", i);
        snprintf(mo.fileName, sizeof(mo.fileName), "filename_%06d", i);

        /* add it to the data base */
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mo);
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    timeval startTime;
    timeval endTime;
    unsigned long durationUS;

    /* start time sampling */
    durationUS = 0;
    gettimeofday(&startTime, NULL);

    /* create my media DB */
    res = LocalSPM::GetDBManager().UpdateMyMediaDatabase();
    CPPUNIT_ASSERT(res == 0);

    /* wait for 1 second */
    sleep(1);

    /* try to restart the update */
    res = LocalSPM::GetDBManager().UpdateMyMediaDatabase();
    CPPUNIT_ASSERT(res == 0);

    /* end time sampling */
    gettimeofday(&endTime, NULL);
    durationUS = (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    durationUS -= 1000000L; // subtract the sleep time
    ETG_TRACE_USR2(("Abort time of UpdateMyMediaDatabase(10000 obj)=%lf ms", (double)(durationUS / 1000.)));

    /* wait for end of second update */
    LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    CPPUNIT_ASSERT((double)(durationUS / 1000.) < 2000.);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::DetermineFolderContentPerformanceTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tUInt i = 0;
    tDeviceID deviceID;

    /* get device id for second USB */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);

    /* get the device information*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    timeval startTime;
    timeval endTime;
    unsigned long durationUS = 0;

    /* start time sampling */
    gettimeofday(&startTime, NULL);

    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    mediaObject.deviceID = deviceID;
    strncpy_r(mediaObject.deviceVersion, deviceInfo.deviceVersion, sizeof(mediaObject.deviceVersion));
    strncpy_r(mediaObject.mountPoint, deviceInfo.mountPoint, sizeof(mediaObject.mountPoint));
    mediaObject.deviceType = deviceInfo.deviceType;
    strncpy_r(OUT mediaObject.dateTime, "2016:08:12 11:18:00", IN sizeof(mediaObject.dateTime));
    mediaObject.metadataConvertFlag = 0;
    mediaObject.compilationFlag = 0;
    mediaObject.fileSize = 5444000LL;
    mediaObject.fileMode = 0;
    mediaObject.userID = 9;
    mediaObject.groupID = 75;

    /* now insert some media objects (songs, videos and images) into the data base */
    //for(i=0; i<90000; i++) { //Increase no. of loops for performance measurement
    for(i=0; i<900; i++) {

        snprintf(mediaObject.title, sizeof(mediaObject.title), "title_%06d", i);

        int modulo = i%3;
        if (0 == modulo) {      //audio
            mediaObject.mediaType = MTY_MUSIC_FILE;
            mediaObject.catType = CTY_SONG;
            mediaObject.totalPlaytime = 180000;
            mediaObject.trackNumber = 3;
            mediaObject.notPlayable = FNP_PLAYABLE;

            snprintf(mediaObject.fileName, sizeof(mediaObject.fileName), "/audio/song_%06d", i);
            strncpy_r(OUT mediaObject.path, "/audio/", IN sizeof(mediaObject.path));
            strncpy_r(OUT mediaObject.albumArtString, IN mediaObject.fileName, IN sizeof(mediaObject.albumArtString));
            strncpy_r(OUT mediaObject.MetadataField1, "Genre", IN sizeof(mediaObject.MetadataField1));
            strncpy_r(OUT mediaObject.MetadataField2, "Artist", IN sizeof(mediaObject.MetadataField2));
            strncpy_r(OUT mediaObject.MetadataField3, "Composer", IN sizeof(mediaObject.MetadataField3));
            strncpy_r(OUT mediaObject.MetadataField4, "Album", IN sizeof(mediaObject.MetadataField4));
        }
        else if(1 == modulo) {  //video
            mediaObject.mediaType = MTY_VIDEO;
            mediaObject.catType = CTY_VIDEO;
            mediaObject.totalPlaytime = 1500000;
            mediaObject.trackNumber = 1;
            mediaObject.notPlayable = FNP_PLAYABLE;

            snprintf(mediaObject.fileName, sizeof(mediaObject.fileName), "/video/movie_%06d", i);
            strncpy_r(OUT mediaObject.path, "/video/", IN sizeof(mediaObject.path));
            strncpy_r(OUT mediaObject.albumArtString, IN "", IN sizeof(mediaObject.albumArtString));
            strncpy_r(OUT mediaObject.MetadataField1, "VideoName", IN sizeof(mediaObject.MetadataField1));
            strncpy_r(OUT mediaObject.MetadataField2, "Resolution", IN sizeof(mediaObject.MetadataField2));
            strncpy_r(OUT mediaObject.MetadataField3, "", IN sizeof(mediaObject.MetadataField3));
            strncpy_r(OUT mediaObject.MetadataField4, "", IN sizeof(mediaObject.MetadataField4));
        }
        else {                  //image
            mediaObject.mediaType = MTY_IMAGE;
            mediaObject.catType = CTY_IMAGE;
            mediaObject.totalPlaytime = 0;
            mediaObject.trackNumber = 0;
            mediaObject.notPlayable = FNP_NOT_PLAYABLE;

            snprintf(mediaObject.fileName, sizeof(mediaObject.fileName), "/image/picture_%06d", i);
            strncpy_r(OUT mediaObject.path, "/image/", IN sizeof(mediaObject.path));
            strncpy_r(OUT mediaObject.albumArtString, IN "", IN sizeof(mediaObject.albumArtString));
            strncpy_r(OUT mediaObject.MetadataField1, "Density", IN sizeof(mediaObject.MetadataField1));
            strncpy_r(OUT mediaObject.MetadataField2, "Resolution", IN sizeof(mediaObject.MetadataField2));
            strncpy_r(OUT mediaObject.MetadataField3, "", IN sizeof(mediaObject.MetadataField3));
            strncpy_r(OUT mediaObject.MetadataField4, "", IN sizeof(mediaObject.MetadataField4));
        }

        /* add it to the data base */
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
        CPPUNIT_ASSERT(res == 0);
    }

    /* add some special media types to the data base like podcast and playlist too */
    mediaObject.mediaType = MTY_PODCAST;
    mediaObject.catType = CTY_PODCAST;
    mediaObject.totalPlaytime = 1500000;
    mediaObject.trackNumber = 1;
    mediaObject.notPlayable = FNP_PLAYABLE;

    snprintf(mediaObject.title, sizeof(mediaObject.title), "title_%06d", i);
    snprintf(mediaObject.fileName, sizeof(mediaObject.fileName), "/audio/podcast_%06d", i);
    strncpy_r(OUT mediaObject.path, "/audio/", IN sizeof(mediaObject.path));
    strncpy_r(OUT mediaObject.albumArtString, IN "", IN sizeof(mediaObject.albumArtString));
    strncpy_r(OUT mediaObject.MetadataField1, "PodcastName", IN sizeof(mediaObject.MetadataField1));
    strncpy_r(OUT mediaObject.MetadataField2, "Resolution", IN sizeof(mediaObject.MetadataField2));
    strncpy_r(OUT mediaObject.MetadataField3, "", IN sizeof(mediaObject.MetadataField3));
    strncpy_r(OUT mediaObject.MetadataField4, "", IN sizeof(mediaObject.MetadataField4));

    /* add it to the data base */
    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    i++;

    mediaObject.mediaType = MTY_PLAYLIST;
    mediaObject.catType = CTY_PLAYLIST;
    mediaObject.totalPlaytime = 0;
    mediaObject.trackNumber = 0;
    mediaObject.notPlayable = FNP_PLAYABLE;

    snprintf(mediaObject.title, sizeof(mediaObject.title), "title_%06d", i);
    snprintf(mediaObject.fileName, sizeof(mediaObject.fileName), "/audio/playlist_%06d", i);
    strncpy_r(OUT mediaObject.path, "/audio/", IN sizeof(mediaObject.path));
    strncpy_r(OUT mediaObject.albumArtString, IN "", IN sizeof(mediaObject.albumArtString));
    strncpy_r(OUT mediaObject.MetadataField1, "PlaylistName", IN sizeof(mediaObject.MetadataField1));
    strncpy_r(OUT mediaObject.MetadataField2, "", IN sizeof(mediaObject.MetadataField2));
    strncpy_r(OUT mediaObject.MetadataField3, "", IN sizeof(mediaObject.MetadataField3));
    strncpy_r(OUT mediaObject.MetadataField4, "", IN sizeof(mediaObject.MetadataField4));

    /* add it to the data base */
    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    /* end time sampling */
    gettimeofday(&endTime, NULL);

    /* get the total number of media objects in DB */
    tNumberOfMediaObjects noOfObjects;
    res = LocalSPM::GetDBManager().GetNumberOfMediaObjectsInDB(OUT noOfObjects);

    /* calc the performance */
    durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    ETG_TRACE_USR2(("DetermineFolderContentPerformanceTest(%d obj)=%lf ms; %lf ms/obj", noOfObjects, (double)(durationUS / 1000.), ((double)(durationUS / 1000.) / noOfObjects)));

    /* start time sampling */
    gettimeofday(&startTime, NULL);

    res = LocalSPM::GetDBManager().UpdateMain(deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* end time sampling */
    gettimeofday(&endTime, NULL);

    /* calc the performance */
    durationUS += (endTime.tv_usec - startTime.tv_usec) + ((endTime.tv_sec - startTime.tv_sec)*1000000L);
    ETG_TRACE_USR2(("DetermineFolderContentPerformanceTest(%d obj)=%lf ms; %lf ms/obj", noOfObjects, (double)(durationUS / 1000.), ((double)(durationUS / 1000.) / noOfObjects)));

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);

    /* create a file list from root directory */
    tListID listID = LIST_ID_NONE;
    tListType listType = LTY_FILELIST;
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID, INOUT listType, IN "/", IN deviceID, IN false, IN FTS_ALL);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_BROWSELIST);

    /* get the counts */
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize >= 3);
    CPPUNIT_ASSERT(numberOfFolders == 3);

    /* loop to get the objects */
    for(tUInt index = 0; index < listSize; index++)
    {
        /* get one object */
        tMediaObject mediaObject;
        res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN index);
        if(strcmp(mediaObject.fileName, "/audio") == 0) {
            CPPUNIT_ASSERT((MTY_MUSIC_FILE | MTY_PODCAST | MTY_PLAYLIST) == mediaObject.mediaType);
        }
        else if(strcmp(mediaObject.fileName, "/video") == 0) {
            CPPUNIT_ASSERT((MTY_VIDEO) == mediaObject.mediaType);
        }
        else if(strcmp(mediaObject.fileName, "/image") == 0) {
            CPPUNIT_ASSERT((MTY_IMAGE) == mediaObject.mediaType);
        }
    }
}

void DBManagerTest::ValidateSearchKeyList(const tListID listID)
{
    ENTRY_INTERNAL

    tResult res = MP_NO_ERROR;

    /********************************************************************************************************************************/
    vector<tSearchKey> searchKeys;
    res = LocalSPM::GetDBManager().GetSearchKeyList(OUT searchKeys, IN listID);
    CPPUNIT_ASSERT(res == 0);

    unsigned int iter;
    for(iter=0; iter<searchKeys.size(); iter++)
    {
        ETG_TRACE_USR2(("Search Keys from list with Id:%d are (%10s,%d)", listID, searchKeys[iter].letter,searchKeys[iter].count));
    }

    /********************************************************************************************************************************/

    //res = LocalSPM::GetDBManager().SetLanguage(LNG_GREEK);
    //CPPUNIT_ASSERT(res == 0);

    vector<tSearchKeyboard> searchKeyboardList;
    res = LocalSPM::GetDBManager().GetSearchKeyboard(OUT searchKeyboardList,IN listID );
    CPPUNIT_ASSERT(res == 0);

    for(iter=0; iter<searchKeyboardList.size(); iter++)
    {
        ETG_TRACE_USR2(("Search Keyboard (Key:%10s,Available:%d,StartID:%d,EndID:%d)",searchKeyboardList[iter].letter,
        searchKeyboardList[iter].available,searchKeyboardList[iter].startIndex,searchKeyboardList[iter].endIndex ));
    }
    /********************************************************************************************************************************/

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::GenRandom(char *s, const int len)
{
    ENTRY_INTERNAL

    static const char alphanum[] =
        "0123456789"
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        "abcdefghijklmnopqrstuvwxyz";

    for (int i = 0; i < len; ++i) {
        s[i] = alphanum[rand() % (int)(sizeof(alphanum) - 1)];
    }

    s[len] = 0;

    s[0] = 'z'; // this guaranties that all random titles are at the end of a all songs list
}

void DBManagerTest::MyMediaSelectTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    MyMediaSelectTestRunner(MY_MEDIA);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::DeviceSelectTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;

    /* get device id for second usb */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);

    /* get the device information*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if(CS_CONNECTED != deviceInfo.connectionState)
    {
        res = LocalSPM::GetDBManager().DeviceAttached(IN deviceID);
        CPPUNIT_ASSERT(res == 0);

        res = LocalSPM::GetDBManager().DeviceConnected(IN deviceID);
        CPPUNIT_ASSERT(res == 0);
    }

    MyMediaSelectTestRunner(deviceID);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::GetPositionInListTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tMediaObject mo;
    tListID listID;

    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    tDeviceID deviceID;

    /* get device id for second usb */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == 0);

    /* create a list for that device */
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    //tListSize numberOfOldObjects;
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res == 0);
    //numberOfOldObjects = listInfo.listSize;

    /* get the first media object from that list */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    /* now insert 10000 media objects into the data base for the second usb device */
    mo = mediaObjectVector[0];

    srand(0); // seed the random number generator to get always the same random strings

#define REALISTIC_LENS_POSITION 1
#if REALISTIC_LENS_POSITION
    const size_t lSong = 20;
    const size_t lAlbum = 20;
    const size_t lArtist = 16;
    const size_t lGenre = 16;
    const size_t lComposer = 16;
#else
    const size_t lSong = sizeof(Song);
    const size_t lAlbum = sizeof(Album);
    const size_t lArtist = sizeof(Artist);
    const size_t lGenre = sizeof(Genre);
    const size_t lComposer = sizeof(Composer);
#endif

    // insert songs
    tMetadata Genre;
    tMetadata Artist;
    tMetadata Album;
    tMetadata Song;
    tMetadata Composer;

    GenRandom(Genre, sizeof(Genre)-1);
    GenRandom(Artist, sizeof(Artist)-1);
    GenRandom(Album, sizeof(Album)-1);
    GenRandom(Song, sizeof(Song)-1);
    GenRandom(Composer, sizeof(Composer)-1);

    int noOfTestObjects = 10000;
    for(int i=0; i<noOfTestObjects; i++) {

        /* modify the url to get multiple genres, artists, albums and songs */

        // generate a song name
        GenRandom(Song, lSong-1);

        if (!(i%12)) { // every 12th song: generate a new album
            GenRandom(Album, lAlbum-1);
        }

        if (!(i%75)) { // every 75th song: generate a new composer
            GenRandom(Composer, lComposer-1);
        }

        if (!(i%150)) { // every 150th song: generate a new Artist
            GenRandom(Artist, lArtist-1);
        }

        if (!(i%1000)) { // every 1000th song: generate a new Genre
            GenRandom(Genre, lGenre-1);
        }

        /* modify genre, artist, album and song */
        strncpy_r(OUT mo.MetadataField1, IN Genre, IN sizeof(mo.MetadataField1));
        strncpy_r(OUT mo.MetadataField2, IN Artist, IN sizeof(mo.MetadataField2));
        strncpy_r(OUT mo.MetadataField3, IN Composer, IN sizeof(mo.MetadataField3));
        strncpy_r(OUT mo.MetadataField4, IN Album, IN sizeof(mo.MetadataField4));
        strncpy_r(OUT mo.title, IN Song, IN sizeof(mo.title));

        /* modify the filename */
        snprintf(mo.fileName, sizeof(mo.fileName), "/%s/%s/%s/%s", Genre, Artist, Album, Song);
        strncpy_r(OUT mo.albumArtString, IN mo.fileName, IN sizeof(mo.albumArtString));

        /* add it to the data base */
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mo);
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    /* create an all songs list */
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    tListID dbListID;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tPlayContinuation playContinuation;

    playContinuation = PC_NO_REPEAT;
    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    res = LocalSPM::GetDBManager().CreateList(
            OUT dbListID,
            IN deviceID,
            IN LTY_SONG,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get the size of this list */
    tListSize listSize;
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize, IN dbListID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize > 0);
    ETG_TRACE_USR2(("listSize=%d", listSize));

    /* create a compare list with all object id's */
    vector<tObjectID> objectIDs;
    for(unsigned int i=0; i<listSize; i++) {
        tMediaObject mediaObject;

        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN dbListID, IN i);
        CPPUNIT_ASSERT(res == 0);

        objectIDs.push_back(mediaObject.objectID);
    }

    /* do some tests in a loop */
    tPosition position;
    unsigned long minTimeUS = 100000000L;
    unsigned long maxTimeUS = 0;
    unsigned long meanTimeMS = 0;
    ElapsedTimer timeGetPositionInList;
    for(unsigned int loop = 0; loop < listSize; loop++) {

        /* set the row to test */
        tRowID row;
        row = ((float)rand()*(float)(listSize-1)) / (float)RAND_MAX; //lint !e524

        tObjectID objectID = objectIDs[row];

        /* get the position of this object */
        timeGetPositionInList.Restart();
        res = LocalSPM::GetDBManager().GetPositionInList(OUT position, IN dbListID, IN objectID);
        unsigned long timeGetPositionInListUS = timeGetPositionInList.ElapsedUS();
        CPPUNIT_ASSERT(res == 0);

        /* add measured time */
        if (timeGetPositionInListUS > maxTimeUS) {
            maxTimeUS = timeGetPositionInListUS;
        } else if (timeGetPositionInListUS < minTimeUS) {
            minTimeUS = timeGetPositionInListUS;
        }
        meanTimeMS += (timeGetPositionInListUS / 1000);
    }

    ETG_TRACE_USR1(("Perf: GetPositionInList: min=%d, max=%d, mean=%d", minTimeUS/1000, maxTimeUS/1000, meanTimeMS/listSize));

    res = LocalSPM::GetDBManager().ReleaseDBList(IN dbListID);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::MyMediaSelectTestRunner(const tDeviceID deviceID)
{
    ENTRY_INTERNAL

    tResult res = MP_NO_ERROR;
    tMediaObject mo;
    tListID listID;

    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* create a list for that device */
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    tListSize numberOfOldObjects;
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res == 0);
    numberOfOldObjects = listInfo.listSize;

    /* get the first media object from that list */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    /* now insert 10000 media objects into the data base for the second usb device */
    mo = mediaObjectVector[0];

    srand(0); // seed the random number generator to get always the same random strings

#define REALISTIC_LENS_SELECT 1
#if REALISTIC_LENS_SELECT
    const size_t lSong = 20;
    const size_t lAlbum = 20;
    const size_t lArtist = 16;
    const size_t lGenre = 16;
    const size_t lComposer = 16;

    const size_t lPodcast = 16;
    const size_t lEpisode = 20;
    const size_t lVideo = 16;
    const size_t lPlayList = 16;
    const size_t lPLSong = 20;
    const size_t lBook = 16;
    const size_t lAuthor = 16;
    const size_t lChapter = 20;
#else
    const size_t lSong = sizeof(Song);
    const size_t lAlbum = sizeof(Album);
    const size_t lArtist = sizeof(Artist);
    const size_t lGenre = sizeof(Genre);
    const size_t lComposer = sizeof(Composer);

    const size_t lPodcast = sizeof(Podcast);
    const size_t lEpisode = sizeof(Episode);
    const size_t lVideo = sizeof(Video);
    const size_t lPlayList = sizeof(PlayList);
    const size_t lPLSong = sizeof(PLSong);
    const size_t lBook = sizeof(Book);
    const size_t lAuthor = sizeof(Author);
    const size_t lChapter = sizeof(Chapter);
#endif

    // insert songs
    tMetadata Genre;
    tMetadata Artist;
    tMetadata Album;
    tMetadata Song;
    tMetadata Composer;

    GenRandom(Genre, sizeof(Genre)-1);
    GenRandom(Artist, sizeof(Artist)-1);
    GenRandom(Album, sizeof(Album)-1);
    GenRandom(Song, sizeof(Song)-1);
    GenRandom(Composer, sizeof(Composer)-1);

    int noOfTestObjects = 10000;
    int noOfTestObjectsTotal = noOfTestObjects;
    for(int i=0; i<noOfTestObjects; i++) {

        /* modify the url to get multiple genres, artists, albums and songs */

        // generate a song name
        GenRandom(Song, lSong-1);

        if (!(i%12)) { // every 12th song: generate a new album
            GenRandom(Album, lAlbum-1);
        }

        if (!(i%75)) { // every 75th song: generate a new composer
            GenRandom(Composer, lComposer-1);
        }

        if (!(i%150)) { // every 150th song: generate a new Artist
            GenRandom(Artist, lArtist-1);
        }

        if (!(i%1000)) { // every 1000th song: generate a new Genre
            GenRandom(Genre, lGenre-1);
        }

        /* modify genre, artist, album and song */
        strncpy_r(OUT mo.MetadataField1, IN Genre, IN sizeof(mo.MetadataField1));
        strncpy_r(OUT mo.MetadataField2, IN Artist, IN sizeof(mo.MetadataField2));
        strncpy_r(OUT mo.MetadataField3, IN Composer, IN sizeof(mo.MetadataField3));
        strncpy_r(OUT mo.MetadataField4, IN Album, IN sizeof(mo.MetadataField4));
        strncpy_r(OUT mo.title, IN Song, IN sizeof(mo.title));

        /* modify the filename */
        snprintf(mo.fileName, sizeof(mo.fileName), "/%s/%s/%s/%s", Genre, Artist, Album, Song);
        strncpy_r(OUT mo.albumArtString, IN mo.fileName, IN sizeof(mo.albumArtString));

        /* add it to the data base */
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mo);
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    // insert podcasts
    tMetadata Podcast;
    tMetadata Episode;

    GenRandom(Podcast, sizeof(Podcast)-1);
    GenRandom(Episode, sizeof(Episode)-1);

    // reset metadata fields
    strncpy_r(OUT mo.MetadataField1, "", IN sizeof(mo.MetadataField1));
    strncpy_r(OUT mo.MetadataField2, "", IN sizeof(mo.MetadataField2));
    strncpy_r(OUT mo.MetadataField3, "", IN sizeof(mo.MetadataField3));
    strncpy_r(OUT mo.MetadataField4, "", IN sizeof(mo.MetadataField4));
    strncpy_r(OUT mo.title, "", IN sizeof(mo.title));
    mo.catType = CTY_PODCAST;
    mo.mediaType = MTY_PODCAST;

    noOfTestObjects = 1000;
    noOfTestObjectsTotal += noOfTestObjects;
    for(int i=0; i<noOfTestObjects; i++) {

        // generate a episode name
        GenRandom(Episode, lEpisode-1);

        if (!(i%24)) { // every 24th song: generate a new podcast
            GenRandom(Podcast, lPodcast-1);
        }

        /* modify genra, artist, album and song */
        strncpy_r(OUT mo.MetadataField1, IN Podcast, IN sizeof(mo.MetadataField1));
        strncpy_r(OUT mo.title, IN Episode, IN sizeof(mo.title));

        /* modify the filename */
        snprintf(mo.fileName, sizeof(mo.fileName), "/%s/%s", Podcast, Episode);
        strncpy_r(OUT mo.albumArtString, IN mo.fileName, IN sizeof(mo.albumArtString));

        /* add it to the data base */
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mo);
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    // insert videos
    tMetadata Video;

    GenRandom(Video, sizeof(Video)-1);
    GenRandom(Episode, sizeof(Episode)-1);

    // reset metadata fields
    strncpy_r(OUT mo.MetadataField1, "", IN sizeof(mo.MetadataField1));
    strncpy_r(OUT mo.MetadataField2, "", IN sizeof(mo.MetadataField2));
    strncpy_r(OUT mo.MetadataField3, "", IN sizeof(mo.MetadataField3));
    strncpy_r(OUT mo.MetadataField4, "", IN sizeof(mo.MetadataField4));
    strncpy_r(OUT mo.title, "", IN sizeof(mo.title));
    mo.catType = CTY_VIDEO;
    mo.mediaType = MTY_VIDEO;

    noOfTestObjects = 1000;
    noOfTestObjectsTotal += noOfTestObjects;
    for(int i=0; i<noOfTestObjects; i++) {

        // generate a episode name
        GenRandom(Episode, lEpisode-1);

        if (!(i%20)) { // every 24th song: generate a new video
            GenRandom(Video, lVideo-1);
        }

        /* modify genra, artist, album and song */
        strncpy_r(OUT mo.MetadataField1, IN Video, IN sizeof(mo.MetadataField1));
        strncpy_r(OUT mo.title, IN Episode, IN sizeof(mo.title));

        /* modify the filename */
        snprintf(mo.fileName, sizeof(mo.fileName), "/%s/%s", Video, Episode);
        strncpy_r(OUT mo.albumArtString, IN mo.fileName, IN sizeof(mo.albumArtString));

        /* add it to the data base */
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mo);
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    // insert playlists
    tMetadata PlayList;
    tMetadata PLSong;

    GenRandom(PlayList, sizeof(PlayList)-1);
    GenRandom(PLSong, sizeof(PLSong)-1);

    // reset metadata fields
    strncpy_r(OUT mo.MetadataField1, "", IN sizeof(mo.MetadataField1));
    strncpy_r(OUT mo.MetadataField2, "", IN sizeof(mo.MetadataField2));
    strncpy_r(OUT mo.MetadataField3, "", IN sizeof(mo.MetadataField3));
    strncpy_r(OUT mo.MetadataField4, "", IN sizeof(mo.MetadataField4));
    strncpy_r(OUT mo.title, "", IN sizeof(mo.title));
    mo.catType = CTY_PLAYLIST;
    mo.mediaType = MTY_PLAYLIST;

    noOfTestObjects = 1000;
    noOfTestObjectsTotal += noOfTestObjects;
    for(int i=0; i<noOfTestObjects; i++) {

        // generate a episode name
        GenRandom(PLSong, lPLSong-1);

        if (!(i%20)) { // every 24th song: generate a new video
            GenRandom(PlayList, lPlayList-1);
        }

        /* modify genra, artist, album and song */
        strncpy_r(OUT mo.MetadataField1, IN PlayList, IN sizeof(mo.MetadataField1));
        strncpy_r(OUT mo.title, IN PLSong, IN sizeof(mo.title));

        /* modify the filename */
        snprintf(mo.fileName, sizeof(mo.fileName), "/%s/%s", PlayList, PLSong);
        strncpy_r(OUT mo.albumArtString, IN mo.fileName, IN sizeof(mo.albumArtString));

        /* add it to the data base */
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mo);
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    // insert audiobooks
    tMetadata Book;
    tMetadata Author;
    tMetadata Chapter;

    GenRandom(Book, sizeof(Book)-1);
    GenRandom(Author, sizeof(Author)-1);
    GenRandom(Chapter, sizeof(Chapter)-1);

    // reset metadata fields
    strncpy_r(OUT mo.MetadataField1, "", IN sizeof(mo.MetadataField1));
    strncpy_r(OUT mo.MetadataField2, "", IN sizeof(mo.MetadataField2));
    strncpy_r(OUT mo.MetadataField3, "", IN sizeof(mo.MetadataField3));
    strncpy_r(OUT mo.MetadataField4, "", IN sizeof(mo.MetadataField4));
    strncpy_r(OUT mo.title, "", IN sizeof(mo.title));
    mo.catType = CTY_AUDIOBOOK;
    mo.mediaType = MTY_AUDIOBOOK;

    noOfTestObjects = 1000;
    noOfTestObjectsTotal += noOfTestObjects;
    for(int i=0; i<noOfTestObjects; i++) {

        // generate a episode name
        GenRandom(Chapter, lChapter-1);

        if (!(i%27)) { // every 27th song: generate a new book
            GenRandom(Book, lBook-1);
        }

        if (!(i%27)) { // every 200th song: generate a new author
            GenRandom(Author, lAuthor-1);
        }

        /* modify genra, artist, album and song */
        strncpy_r(OUT mo.MetadataField1, IN Author, IN sizeof(mo.MetadataField1));
        strncpy_r(OUT mo.MetadataField2, IN Book, IN sizeof(mo.MetadataField2));
        strncpy_r(OUT mo.title, IN Chapter, IN sizeof(mo.title));

        /* modify the filename */
        snprintf(mo.fileName, sizeof(mo.fileName), "/%s/%s/%s", Book, Author, Chapter);
        strncpy_r(OUT mo.albumArtString, IN mo.fileName, IN sizeof(mo.albumArtString));

        /* add it to the data base */
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mo);
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

#if 0
    /* create a song list for fetching the filter tag ids for the following tests */
    tListID referenceListID;
    res = LocalSPM::GetListControl().CreatePlayList(OUT referenceListID,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);
#endif
    vector<tListID> listIDs;
    tListID referenceListID = LIST_ID_NONE;

    const int noOfRuns = 2;
    for(int irun = 0; irun<noOfRuns; irun++) {
        ETG_TRACE_USR1(("Run=%d", irun));

        srand(0); // seed the random number generator
        listIDs.clear();

    /*
     * create all possible lists on the generated objects and measure the access times
     */
    for (tListType listType=LTY_GENRE; listType<LTY_CURRENT_SELECTION; listType = (tListType)((int)listType+1)) {

        tMediaObject referenceObject;
        vector<tMediaObject> referenceObjectVector;
        int restarts = 5;
        int getReferenceObject;

        InitMediaObject(OUT referenceObject);

        /*list name*/
        const char *cListname;
        switch(listType) {
            case LTY_GENRE: cListname=(const char *)"LTY_GENRE"; break;
            case LTY_ARTIST: cListname=(const char *)"LTY_ARTIST"; break;
            case LTY_ALBUM: cListname=(const char *)"LTY_ALBUM"; break;
            case LTY_SONG: cListname=(const char *)"LTY_SONG"; break;
            case LTY_GENRE_ARTIST: cListname=(const char *)"LTY_GENRE_ARTIST"; break;
            case LTY_GENRE_ARTIST_ALBUM: cListname=(const char *)"LTY_GENRE_ARTIST_ALBUM"; break;
            case LTY_GENRE_ARTIST_ALBUM_SONG: cListname=(const char *)"LTY_GENRE_ARTIST_ALBUM_SONG"; break;
            case LTY_GENRE_ARTIST_SONG: cListname=(const char *)"LTY_GENRE_ARTIST_SONG"; break;
            case LTY_GENRE_ALBUM: cListname=(const char *)"LTY_GENRE_ALBUM"; break;
            case LTY_GENRE_ALBUM_SONG: cListname=(const char *)"LTY_GENRE_ALBUM_SONG"; break;
            case LTY_GENRE_SONG: cListname=(const char *)"LTY_GENRE_SONG"; break;
            case LTY_ARTIST_ALBUM: cListname=(const char *)"LTY_ARTIST_ALBUM"; break;
            case LTY_ARTIST_ALBUM_SONG: cListname=(const char *)"LTY_ARTIST_ALBUM_SONG"; break;
            case LTY_ARTIST_SONG: cListname=(const char *)"LTY_ARTIST_SONG"; break;
            case LTY_ALBUM_SONG: cListname=(const char *)"LTY_ALBUM_SONG"; break;
            case LTY_PODCAST: cListname=(const char *)"LTY_PODCAST"; break;
            case LTY_PODCAST_EPISODE: cListname=(const char *)"LTY_PODCAST_EPISODE"; break;
            case LTY_AUDIOBOOK: cListname=(const char *)"LTY_AUDIOBOOK"; break;
            case LTY_BOOKTITLE_CHAPTER: cListname=(const char *)"LTY_BOOKTITLE_CHAPTER"; break;
            case LTY_AUTHOR: cListname=(const char *)"LTY_AUTHOR"; break;
            case LTY_AUTHOR_BOOKTITLE: cListname=(const char *)"LTY_AUTHOR_BOOKTITLE"; break;
            case LTY_AUTHOR_BOOKTITLE_CHAPTER: cListname=(const char *)"LTY_AUTHOR_BOOKTITLE_CHAPTER"; break;
            case LTY_COMPOSER: cListname=(const char *)"LTY_COMPOSER"; break;
            case LTY_COMPOSER_ALBUM: cListname=(const char *)"LTY_COMPOSER_ALBUM"; break;
            case LTY_COMPOSER_ALBUM_SONG: cListname=(const char *)"LTY_COMPOSER_ALBUM_SONG"; break;
            case LTY_COMPOSER_SONG: cListname=(const char *)"LTY_COMPOSER_SONG"; break;
            case LTY_VIDEO: cListname=(const char *)"LTY_VIDEO"; break;
            case LTY_VIDEO_EPISODE: cListname=(const char *)"LTY_VIDEO_EPISODE"; break;
            //Playlist cannot work because only DB is expanded not physical data on file system where VTFile will look for playable objects
            case LTY_PLAYLIST: cListname=(const char *)"LTY_PLAYLIST"; continue; //don't take into consideration
            case LTY_PLAYLIST_SONG: cListname=(const char *)"LTY_PLAYLIST_SONG"; continue; //don't take into consideration
            default:
                cListname=(const char *)"unknown";
                break;
        }

restart:
        /* select a reference song */
        tIndex row;

        /* get the reference object, if list type under test need it */
        tListType referenceListType = LTY_SONG;
        tListType referenceRootListType;

        switch(listType) {
        case LTY_GENRE:
            referenceRootListType = LTY_END_OF_EXTERNAL_LIST_TYPES;
            referenceListType = LTY_SONG;
            getReferenceObject = 1;
            row = (rand() % (10000-1))+numberOfOldObjects; // use only the random objects
            break;
        case LTY_PODCAST:
            referenceRootListType = LTY_PODCAST;
            referenceListType = LTY_PODCAST_EPISODE;
            getReferenceObject = 1;
            row = 0;
            break;
        case LTY_AUDIOBOOK:
            referenceRootListType = LTY_AUDIOBOOK;
            referenceListType = LTY_BOOKTITLE_CHAPTER;
            getReferenceObject = 1;
            row = 0;
            break;
        case LTY_COMPOSER:
            referenceRootListType = LTY_END_OF_EXTERNAL_LIST_TYPES;
            referenceListType = LTY_SONG;
            getReferenceObject = 1;
            row = (rand() % (10000-1))+numberOfOldObjects; // use only the random objects
            break;
        case LTY_VIDEO:
            referenceRootListType = LTY_VIDEO;
            referenceListType = LTY_VIDEO_EPISODE;
            getReferenceObject = 1;
            row = 0;
            break;
        case LTY_PLAYLIST:
            referenceRootListType = LTY_PLAYLIST;
            referenceListType = LTY_PLAYLIST_SONG;
            getReferenceObject = 1;
            row = 0;
            break;
        default:
            referenceRootListType = LTY_END_OF_EXTERNAL_LIST_TYPES;
            getReferenceObject = 0;
            row = 0;
            break;
        }

        if (getReferenceObject) {

            LocalSPM::GetListControl().ReleaseList(IN referenceListID);

            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;

            /* create a root list first if needed */
            if (referenceRootListType != LTY_END_OF_EXTERNAL_LIST_TYPES) {
                res = LocalSPM::GetListControl().CreatePlayList(
                        OUT referenceListID,
                        IN referenceRootListType,
                        IN streaming,
                        IN tag1,
                        IN tag2,
                        IN tag3,
                        IN tag4,
                        PC_NO_REPEAT,
                        IN deviceID);
                CPPUNIT_ASSERT(res == 0);

                res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT referenceObjectVector, IN referenceListID, 0, 1);
                CPPUNIT_ASSERT(res == 0);
                if (referenceObjectVector.size() == 0) {
                    printf("debug");
                }
                CPPUNIT_ASSERT(referenceObjectVector.size() != 0);
                referenceObject = referenceObjectVector[0];

                /* set the tags */
                switch(listType) {
                case LTY_PODCAST:
                    tag1.tag = referenceObject.MetadataTag1;
                    break;
                case LTY_AUDIOBOOK:
                    tag2.tag = referenceObject.MetadataTag2;
                    break;
                case LTY_VIDEO:
                    tag1.tag = referenceObject.MetadataTag1;
                    break;
                case LTY_PLAYLIST:
                    tag1.tag = referenceObject.MetadataTag1;
                    break;
                default:
                    break;
                }
                LocalSPM::GetListControl().ReleaseList(IN referenceListID);
            }

            /* create the reference list with playable object */
            res = LocalSPM::GetListControl().CreatePlayList(
                    OUT referenceListID,
                    IN referenceListType,
                    IN streaming,
                    IN tag1,
                    IN tag2,
                    IN tag3,
                    IN tag4,
                    PC_NO_REPEAT,
                    IN deviceID);
            CPPUNIT_ASSERT(res == 0);

            res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT referenceObjectVector, IN referenceListID, row, 1);
            CPPUNIT_ASSERT(res == 0);
            if (referenceObjectVector.size() == 0) {
                printf("debug");
            }
            CPPUNIT_ASSERT(referenceObjectVector.size() > 0);
            referenceObject = referenceObjectVector[0];
        }

        /* set the filter tags according to the list type */
        getReferenceObject = 0;
        switch(listType) {
        case LTY_GENRE:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            getReferenceObject = 1;
            break;
        case LTY_ARTIST:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_ALBUM:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_SONG:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_GENRE_ARTIST:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_GENRE_ARTIST_ALBUM:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = referenceObject.MetadataTag2;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_GENRE_ARTIST_ALBUM_SONG:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = referenceObject.MetadataTag2;
            tag3.tag = 0;
            tag4.tag = referenceObject.MetadataTag4;
            break;
        case LTY_GENRE_ARTIST_SONG:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = referenceObject.MetadataTag2;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_GENRE_ALBUM:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_GENRE_ALBUM_SONG:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = referenceObject.MetadataTag4;
            break;
        case LTY_GENRE_SONG:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_ARTIST_ALBUM:
            tag1.tag = 0;
            tag2.tag = referenceObject.MetadataTag2;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_ARTIST_ALBUM_SONG:
            tag1.tag = 0;
            tag2.tag = referenceObject.MetadataTag2;
            tag3.tag = 0;
            tag4.tag = referenceObject.MetadataTag4;
            break;
        case LTY_ARTIST_SONG:
            tag1.tag = 0;
            tag2.tag = referenceObject.MetadataTag2;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_ALBUM_SONG:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = referenceObject.MetadataTag4;
            break;
        case LTY_PODCAST:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_PODCAST_EPISODE:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_AUDIOBOOK:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_BOOKTITLE_CHAPTER:
            tag1.tag = 0;
            tag2.tag = referenceObject.MetadataTag2;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_AUTHOR:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_AUTHOR_BOOKTITLE:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_AUTHOR_BOOKTITLE_CHAPTER:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = referenceObject.MetadataTag2;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_COMPOSER:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_COMPOSER_ALBUM:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = referenceObject.MetadataTag3;
            tag4.tag = 0;
            break;
        case LTY_COMPOSER_ALBUM_SONG:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = referenceObject.MetadataTag3;
            tag4.tag = referenceObject.MetadataTag4;
            break;
        case LTY_COMPOSER_SONG:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = referenceObject.MetadataTag3;
            tag4.tag = 0;
            break;
        case LTY_VIDEO:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_VIDEO_EPISODE:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_PLAYLIST:
            tag1.tag = 0;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        case LTY_PLAYLIST_SONG:
            tag1.tag = referenceObject.MetadataTag1;
            tag2.tag = 0;
            tag3.tag = 0;
            tag4.tag = 0;
            break;
        default:
            continue;
        }

        /* create a test list */
        ElapsedTimer timeCreatePlayListMeas;
        tListID testListID;
        res = LocalSPM::GetListControl().CreatePlayList(OUT testListID,
                listType,
                IN streaming,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                PC_NO_REPEAT,
                IN deviceID);
        unsigned long timeCreatePlayListUS = timeCreatePlayListMeas.ElapsedUS();
        CPPUNIT_ASSERT(res == 0);

        /* store list id for later list removal */
        listIDs.push_back(testListID);

        /* get list information */
        ElapsedTimer timeGetListInfoMeas;
        tListInfo testListInfo;
        tBoolean withListSize = true; //lint !e578
        res = LocalSPM::GetListControl().GetListInfo(OUT testListInfo, IN testListID, IN withListSize);
        unsigned long timeGetListInfoUS = timeGetListInfoMeas.ElapsedUS();
        CPPUNIT_ASSERT(res == 0);

        /* are any elements in the list? */
        if (testListInfo.listSize == 0) {
            if (restarts == 0) {
                ETG_TRACE_ERR(("No Elements in test list, type=%d", listType));
                continue; // skip this list type if not possible to create a test list
            }
            CPPUNIT_ASSERT(restarts != 0);
            ETG_TRACE_USR1(("restart list creation, restarts=%d", restarts));
            restarts--;
            goto restart; //lint !e801
        }

        /* create vertical keyboard */
        ElapsedTimer timeSearchKeyboardMeas;
        vector<tSearchKeyboard> searchKeyboardList;
        res = LocalSPM::GetListControl().SearchKeyboardMediaPlayerList(OUT searchKeyboardList, IN testListID);
        unsigned long timeSearchKeyboardUS = timeSearchKeyboardMeas.ElapsedUS();

        if(res != MP_ERR_DB_SEARCHKEYS_NOT_SUPPORTED)
        {
            if (res || searchKeyboardList.size() == 0) {
                ETG_TRACE_ERR(("error in SearchKeyboardMediaPlayerList: size=%d, error=%d/%s", searchKeyboardList.size(), res, errorString(res)));
            }
            CPPUNIT_ASSERT(res == 0);
            CPPUNIT_ASSERT(searchKeyboardList.size() != 0);
        }
        else
        {
            ETG_TRACE_USR1(("Search keyboard not supported for list type : %s \n",cListname));
        }

        /* do request list slice commands on the list */
        ElapsedTimer timeRequestListSliceMeas;
        unsigned long timeRequestListSliceUS = 0;
        const int testLoops = 20;
        const int noOfRows = 25;
        vector<tObjectID> objectIDs;
        objectIDs.clear();
        for(int loop=0; loop<testLoops; loop++) {

            tIndex testRow = (tIndex)((int)rand() % (int)testListInfo.listSize);
            vector<tMediaObject> testObjectVector;

            timeRequestListSliceMeas.Restart();
            res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT testObjectVector, IN testListID, IN testRow, IN noOfRows);
            timeRequestListSliceUS += timeRequestListSliceMeas.ElapsedUS();
            CPPUNIT_ASSERT(res == 0);

            /* save the object id for the position test later on */
            if (testObjectVector.size()) {
                objectIDs.push_back(IN testObjectVector[0].objectID);
            }
        }
        unsigned long timeRequestListSliceMeanUS = timeRequestListSliceUS/testLoops;

        /* get position in list test */
        ElapsedTimer timeGetPositionInListMeas;
        unsigned long timeGetPositionInListUS = 0;
        for(tUInt loop=0; loop<objectIDs.size(); loop++) {
            tPosition position;

            timeGetPositionInListMeas.Restart();
            res = LocalSPM::GetListControl().GetPositionInList(OUT position, IN testListID, IN objectIDs[loop]);
            timeGetPositionInListUS += timeGetPositionInListMeas.ElapsedUS();
            CPPUNIT_ASSERT(res == 0);
        }
        unsigned long timeGetPositionInListMeanUS = timeGetPositionInListUS/testLoops;

        /* record performance */

        ETG_TRACE_USR1(("Perf: %32s: len= %d, create= %d ms, listInfo= %d ms, keyboard= %d ms, request= %d ms, position= %d ms",
                cListname, testListInfo.listSize, timeCreatePlayListUS/1000, timeGetListInfoUS/1000,
                timeSearchKeyboardUS/1000, timeRequestListSliceMeanUS/1000, timeGetPositionInListMeanUS/1000));

    } // loop listtypes

        /* remove all created lists */
        for(unsigned int j=0; j<listIDs.size(); j++) {
            res = LocalSPM::GetListControl().ReleaseList(IN listIDs[j]);
            if (res) {
                ETG_TRACE_ERR(("ReleaseList for ID=%d failed", listIDs[j]));
                CPPUNIT_ASSERT(res == 0);
            }
        }

    } // loop irun

    /*
     * release the lists
     */
    res = LocalSPM::GetListControl().ReleaseList(IN referenceListID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

}

void DBManagerTest::ExplainSelectsDevice()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    vector<tTestPlan> testPlanVector;
    tTestPlan testPlanElem;
    tTestPlan testPlan[] = {
        {LTY_GENRE, 0, 0, 0, 0, "", (const char *)"LTY_GENRE", 2, 0},
        {LTY_ARTIST, 0, 0, 0, 0, "", (const char *)"LTY_ARTIST", 2, 0},
        {LTY_ALBUM, 0, 0, 0, 0, "", (const char *)"LTY_ALBUM", 2, 0},
        {LTY_SONG, 0, 0, 0, 0, "", (const char *)"LTY_SONG", 2, 0},
        {LTY_GENRE_ARTIST, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ARTIST", 2, 0},
        {LTY_GENRE_ARTIST_ALBUM, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_ALBUM", 2, 0},
        {LTY_GENRE_ARTIST_ALBUM_SONG, 1, 1, 0, 1, "", (const char *)"LTY_GENRE_ARTIST_ALBUM_SONG", 2, 0},
        {LTY_GENRE_ARTIST_SONG, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_SONG", 2, 0},
        {LTY_GENRE_ALBUM, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ALBUM", 2, 0},
        {LTY_GENRE_ALBUM_SONG, 1, 0, 0, 1, "", (const char *)"LTY_GENRE_ALBUM_SONG", 2, 0},
        {LTY_GENRE_SONG, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_SONG", 2, 0},
        {LTY_ARTIST_ALBUM, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_ALBUM", 2, 0},
        {LTY_ARTIST_ALBUM_SONG, 0, 1, 0, 1, "", (const char *)"LTY_ARTIST_ALBUM_SONG", 2, 0},
        {LTY_ARTIST_SONG, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_SONG", 2, 0},
        {LTY_ALBUM_SONG, 0, 0, 0, 1, "", (const char *)"LTY_ALBUM_SONG", 2, 0},
        {LTY_PODCAST, 0, 0, 0, 0, "", (const char *)"LTY_PODCAST", 2, 0},
        {LTY_PODCAST_EPISODE, 1, 0, 0, 0, "", (const char *)"LTY_PODCAST_EPISODE", 2, 0},
        {LTY_AUDIOBOOK, 0, 0, 0, 0, "", (const char *)"LTY_AUDIOBOOK", 2, 0},
        {LTY_BOOKTITLE_CHAPTER, 0, 1, 0, 0, "", (const char *)"LTY_BOOKTITLE_CHAPTER", 2, 0},
        {LTY_AUTHOR, 0, 0, 0, 0, "", (const char *)"LTY_AUTHOR", 2, 0},
        {LTY_AUTHOR_BOOKTITLE, 1, 0, 0, 0, "", (const char *)"LTY_AUTHOR_BOOKTITLE", 2, 0},
        {LTY_AUTHOR_BOOKTITLE_CHAPTER, 1, 1, 0, 0, "", (const char *)"LTY_AUTHOR_BOOKTITLE_CHAPTER", 2, 0},
        {LTY_COMPOSER, 0, 0, 0, 0, "", (const char *)"LTY_COMPOSER", 2, 0},
        {LTY_COMPOSER_ALBUM, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_ALBUM", 2, 0},
        {LTY_COMPOSER_ALBUM_SONG, 0, 0, 1, 1, "", (const char *)"LTY_COMPOSER_ALBUM_SONG", 2, 0},
        {LTY_COMPOSER_SONG, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_SONG", 2, 0},
        {LTY_VIDEO, 0, 0, 0, 0, "", (const char *)"LTY_VIDEO", 2, 0},
        {LTY_VIDEO_EPISODE, 1, 0, 0, 0, "", (const char *)"LTY_VIDEO_EPISODE", 2, 0},
        {LTY_PLAYLIST, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST", 2, 0},
        {LTY_PLAYLIST_SONG, 1, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_SONG", 2, 0},
        {LTY_IMAGE, 0, 0, 0, 0, "", (const char *)"LTY_IMAGE", 2, 0},
        {LTY_PLAYLIST_INTERNAL, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_INTERNAL", 2, 0},
        {LTY_EPISODE_OF_VIDEO, 0, 0, 0, 0, "", (const char *)"LTY_EPISODE_OF_VIDEO", 2, 0},
        {LTY_IMAGE_FOLDER, 0, 0, 0, 0, "", (const char *)"LTY_IMAGE_FOLDER", 2, 0},
        {LTY_IMAGE_FOLDER_ITEM, 0, 0, 0, 0, "/images/", (const char *)"LTY_IMAGE_FOLDER_ITEM", 2, 0},
        {LTY_COMPILATION, 0, 0, 0, 0, "", (const char *)"LTY_COMPILATION", 2, 0},
        {LTY_COMPILATION_SONG, 0, 0, 0, 1, "", (const char *)"LTY_COMPILATION_SONG", 2, 0},
        {LTY_BROWSELIST, 0, 0, 0, 0, "/music/", (const char *)"LTY_BROWSELIST", 1, 2},
        {LTY_BROWSELIST_MEDIAOBJECTS, 0, 0, 0, 0, "/music/", (const char *)"LTY_BROWSELIST_MEDIAOBJECTS", 2, 0},
        {LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS, 0, 0, 0, 0, "/music/", (const char *)"LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS", 4, 0},
        {LTY_BROWSELIST_MEDIAOBJECTS_ALL, 0, 0, 0, 0, "", (const char *)"LTY_BROWSELIST_MEDIAOBJECTS_ALL", 2, 0},
        {LTY_MEDIAOBJECTS_BY_UUID, 0, 0, 0, 0, "fedcba9876543210", (const char *)"LTY_MEDIAOBJECTS_BY_UUID", 1, 0},

        {LTY_GENRE_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_GENRE_COUNT", 1, 0},
        {LTY_ARTIST_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_ARTIST_COUNT", 1, 0},
        {LTY_ALBUM_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_ALBUM_COUNT", 1, 0},
        {LTY_SONG_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_SONG_COUNT", 1, 0},
        {LTY_GENRE_ARTIST_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_COUNT", 1, 0},
        {LTY_GENRE_ARTIST_ALBUM_COUNT, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_ALBUM_COUNT", 1, 0},
        {LTY_GENRE_ARTIST_ALBUM_SONG_COUNT, 1, 1, 0, 1, "", (const char *)"LTY_GENRE_ARTIST_ALBUM_SONG_COUNT", 1, 0},
        {LTY_GENRE_ARTIST_SONG_COUNT, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_SONG_COUNT", 1, 0},
        {LTY_GENRE_ALBUM_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ALBUM_COUNT", 1, 0},
        {LTY_GENRE_ALBUM_SONG_COUNT, 1, 0, 0, 1, "", (const char *)"LTY_GENRE_ALBUM_SONG_COUNT", 1, 0},
        {LTY_GENRE_SONG_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_SONG_COUNT", 1, 0},
        {LTY_ARTIST_ALBUM_COUNT, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_ALBUM_COUNT", 1, 0},
        {LTY_ARTIST_ALBUM_SONG_COUNT, 0, 1, 0, 1, "", (const char *)"LTY_ARTIST_ALBUM_SONG_COUNT", 1, 0},
        {LTY_ARTIST_SONG_COUNT, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_SONG_COUNT", 1, 0},
        {LTY_ALBUM_SONG_COUNT, 0, 0, 0, 1, "", (const char *)"LTY_ALBUM_SONG_COUNT", 1, 0},
        {LTY_PODCAST_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_PODCAST_COUNT", 1, 0},
        {LTY_PODCAST_EPISODE_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_PODCAST_EPISODE_COUNT", 1, 0},
        {LTY_AUDIOBOOK_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_AUDIOBOOK_COUNT", 1, 0},
        {LTY_BOOKTITLE_CHAPTER_COUNT, 0, 1, 0, 0, "", (const char *)"LTY_BOOKTITLE_CHAPTER_COUNT", 1, 0},
        {LTY_AUTHOR_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_AUTHOR_COUNT", 1, 0},
        {LTY_AUTHOR_BOOKTITLE_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_AUTHOR_BOOKTITLE_COUNT", 1, 0},
        {LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT, 1, 1, 0, 0, "", (const char *)"LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT", 1, 0},
        {LTY_COMPOSER_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_COMPOSER_COUNT", 1, 0},
        {LTY_COMPOSER_ALBUM_COUNT, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_ALBUM_COUNT", 1, 0},
        {LTY_COMPOSER_ALBUM_SONG_COUNT, 0, 0, 1, 1, "", (const char *)"LTY_COMPOSER_ALBUM_SONG_COUNT", 1, 0},
        {LTY_COMPOSER_SONG_COUNT, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_SONG_COUNT", 1, 0},
        {LTY_VIDEO_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_VIDEO_COUNT", 1, 0},
        {LTY_VIDEO_EPISODE_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_VIDEO_EPISODE_COUNT", 1, 0},
        {LTY_PLAYLIST_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_COUNT", 1, 0},
        {LTY_PLAYLIST_SONG_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_SONG_COUNT", 1, 0},
        {LTY_IMAGE_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_IMAGE_COUNT", 1, 0},
        {LTY_PLAYLIST_INTERNAL_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_INTERNAL_COUNT", 1, 0},
        {LTY_EPISODE_OF_VIDEO_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_EPISODE_OF_VIDEO_COUNT", 1, 0},
        {LTY_IMAGE_FOLDER_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_IMAGE_FOLDER_COUNT", 1, 0},
        {LTY_IMAGE_FOLDER_ITEM_COUNT, 0, 0, 0, 0, "/images/", (const char *)"LTY_IMAGE_FOLDER_ITEM_COUNT", 1, 0},
        {LTY_COMPILATION_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_COMPILATION_COUNT", 1, 0},
        {LTY_COMPILATION_SONG_COUNT, 0, 0, 0, 1, "", (const char *)"LTY_COMPILATION_SONG_COUNT", 1, 0},
        {LTY_BROWSELIST_COUNT, 0, 0, 0, 0, "/music/", (const char *)"LTY_BROWSELIST_COUNT", 1, 0},
        {LTY_BROWSELIST_MEDIAOBJECTS_COUNT, 0, 0, 0, 0, "/music/", (const char *)"LTY_BROWSELIST_MEDIAOBJECTS_COUNT", 1, 0},
        {LTY_BROWSELIST_MEDIAOBJECTS_COUNT_WITH_SUBFOLDERS, 0, 0, 0, 0, "/music/", (const char *)"LTY_BROWSELIST_MEDIAOBJECTS_COUNT_WITH_SUBFOLDERS", 3, 0},
        {LTY_BROWSELIST_MEDIAOBJECTS_COUNT_ALL, 0, 0, 0, 0, "", (const char *)"LTY_BROWSELIST_MEDIAOBJECTS_COUNT_ALL", 1, 0},

        {LTY_ALBUM_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_ARTIST_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_ARTIST_SEARCH_KEY", 1, 0},
        {LTY_GENRE_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_GENRE_SEARCH_KEY", 1, 0},
        {LTY_SONG_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_SONG_SEARCH_KEY", 1, 0},
        {LTY_COMPOSER_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_COMPOSER_SEARCH_KEY", 1, 0},
        {LTY_GENRE_ARTIST_ALBUM_SEARCH_KEY, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_GENRE_ARTIST_SONG_SEARCH_KEY, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_SONG_SEARCH_KEY", 1, 0},
        {LTY_GENRE_ARTIST_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_SEARCH_KEY", 1, 0},
        {LTY_GENRE_ALBUM_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_GENRE_SONG_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_SONG_SEARCH_KEY", 1, 0},
        {LTY_ARTIST_ALBUM_SEARCH_KEY, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_ARTIST_SONG_SEARCH_KEY, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_SONG_SEARCH_KEY", 1, 0},
        {LTY_COMPOSER_ALBUM_SEARCH_KEY, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_COMPOSER_SONG_SEARCH_KEY, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_SONG_SEARCH_KEY", 1, 0},
        {LTY_PLAYLIST_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_SEARCH_KEY", 1, 0},
        {LTY_VIDEO_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_VIDEO_SEARCH_KEY", 1, 0},
        {LTY_VIDEO_EPISODE_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_VIDEO_EPISODE_SEARCH_KEY", 1, 0},
        {LTY_PODCAST_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_PODCAST_SEARCH_KEY", 1, 0},
        {LTY_PODCAST_EPISODE_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_PODCAST_EPISODE_SEARCH_KEY", 1, 0},
        {LTY_AUDIOBOOK_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_AUDIOBOOK_SEARCH_KEY", 1, 0},
        {LTY_COMPILATION_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_COMPILATION_SEARCH_KEY", 1, 0},
    };

    for(tUInt iTestPlan = 0; iTestPlan<(sizeof(testPlan)/sizeof(tTestPlan)); iTestPlan++) {

        testPlanElem.listType = testPlan[iTestPlan].listType;
        testPlanElem.filterTag1 = testPlan[iTestPlan].filterTag1;
        testPlanElem.filterTag2 = testPlan[iTestPlan].filterTag2;
        testPlanElem.filterTag3 = testPlan[iTestPlan].filterTag3;
        testPlanElem.filterTag4 = testPlan[iTestPlan].filterTag4;
        strncpy_r(OUT testPlanElem.path, IN testPlan[iTestPlan].path, IN sizeof(testPlanElem.path));
        testPlanElem.cListname = testPlan[iTestPlan].cListname;
        testPlanElem.indexPresent = testPlan[iTestPlan].indexPresent;
        testPlanElem.tempBTreePresent = testPlan[iTestPlan].tempBTreePresent;

        testPlanVector.push_back(testPlanElem);
    }

    ExplainSelects(IN testPlanVector, IN 1);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::ExplainSelectsMyMedia()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    vector<tTestPlan> testPlanVector;
    tTestPlan testPlanElem;
    tTestPlan testPlan[] = {
        {LTY_GENRE, 0, 0, 0, 0, "", (const char *)"LTY_GENRE", 1, 1},
        {LTY_ARTIST, 0, 0, 0, 0, "", (const char *)"LTY_ARTIST", 1, 1},
        {LTY_ALBUM, 0, 0, 0, 0, "", (const char *)"LTY_ALBUM", 1, 1},
        {LTY_SONG, 0, 0, 0, 0, "", (const char *)"LTY_SONG", 1, 1},
        {LTY_GENRE_ARTIST, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ARTIST", 1, 1},
        {LTY_GENRE_ARTIST_ALBUM, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_ALBUM", 1, 1},
        {LTY_GENRE_ARTIST_ALBUM_SONG, 1, 1, 0, 1, "", (const char *)"LTY_GENRE_ARTIST_ALBUM_SONG", 1, 1},
        {LTY_GENRE_ARTIST_SONG, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_SONG", 1, 1},
        {LTY_GENRE_ALBUM, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ALBUM", 1, 1},
        {LTY_GENRE_ALBUM_SONG, 1, 0, 0, 1, "", (const char *)"LTY_GENRE_ALBUM_SONG", 1, 1},
        {LTY_GENRE_SONG, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_SONG", 1, 1},
        {LTY_ARTIST_ALBUM, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_ALBUM", 1, 1},
        {LTY_ARTIST_ALBUM_SONG, 0, 1, 0, 1, "", (const char *)"LTY_ARTIST_ALBUM_SONG", 1, 1},
        {LTY_ARTIST_SONG, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_SONG", 1, 1},
        {LTY_ALBUM_SONG, 0, 0, 0, 1, "", (const char *)"LTY_ALBUM_SONG", 1, 1},
        {LTY_PODCAST, 0, 0, 0, 0, "", (const char *)"LTY_PODCAST", 1, 1},
        {LTY_PODCAST_EPISODE, 1, 0, 0, 0, "", (const char *)"LTY_PODCAST_EPISODE", 1, 1},
        {LTY_AUDIOBOOK, 0, 0, 0, 0, "", (const char *)"LTY_AUDIOBOOK", 1, 1},
        {LTY_BOOKTITLE_CHAPTER, 0, 1, 0, 0, "", (const char *)"LTY_BOOKTITLE_CHAPTER", 1, 1},
        {LTY_AUTHOR, 0, 0, 0, 0, "", (const char *)"LTY_AUTHOR", 1, 1},
        {LTY_AUTHOR_BOOKTITLE, 1, 0, 0, 0, "", (const char *)"LTY_AUTHOR_BOOKTITLE", 1, 1},
        {LTY_AUTHOR_BOOKTITLE_CHAPTER, 1, 1, 0, 0, "", (const char *)"LTY_AUTHOR_BOOKTITLE_CHAPTER", 1, 1},
        {LTY_COMPOSER, 0, 0, 0, 0, "", (const char *)"LTY_COMPOSER", 1, 1},
        {LTY_COMPOSER_ALBUM, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_ALBUM", 1, 1},
        {LTY_COMPOSER_ALBUM_SONG, 0, 0, 1, 1, "", (const char *)"LTY_COMPOSER_ALBUM_SONG", 1, 1},
        {LTY_COMPOSER_SONG, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_SONG", 1, 1},
        {LTY_VIDEO, 0, 0, 0, 0, "", (const char *)"LTY_VIDEO", 1, 1},
        {LTY_VIDEO_EPISODE, 1, 0, 0, 0, "", (const char *)"LTY_VIDEO_EPISODE", 1, 1},
        {LTY_PLAYLIST, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST", 1, 2},
        {LTY_PLAYLIST_SONG, 1, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_SONG", 1, 1},
        {LTY_IMAGE, 0, 0, 0, 0, "", (const char *)"LTY_IMAGE", 1, 1},
        {LTY_PLAYLIST_INTERNAL, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_INTERNAL", 1, 1},
        {LTY_EPISODE_OF_VIDEO, 0, 0, 0, 0, "", (const char *)"LTY_EPISODE_OF_VIDEO", 1, 1},
        {LTY_IMAGE_FOLDER, 0, 0, 0, 0, "", (const char *)"LTY_IMAGE_FOLDER", 1, 1},
        {LTY_IMAGE_FOLDER_ITEM, 0, 0, 0, 0, "/images/", (const char *)"LTY_IMAGE_FOLDER_ITEM", 1, 1},
        {LTY_COMPILATION, 0, 0, 0, 0, "", (const char *)"LTY_COMPILATION", 1, 1},
        {LTY_COMPILATION_SONG, 0, 0, 0, 1, "", (const char *)"LTY_COMPILATION_SONG", 1, 1},
//        {LTY_BROWSELIST, 0, 0, 0, 0, "/music/", (const char *)"LTY_BROWSELIST", 1, 1}, makes no sense because the browse list is a kind of file list related to a device
        {LTY_MEDIAOBJECTS_BY_UUID, 0, 0, 0, 0, "fedcba9876543210", (const char *)"LTY_MEDIAOBJECTS_BY_UUID", 1, 0},

        {LTY_GENRE_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_GENRE_COUNT", 1, 0},
        {LTY_ARTIST_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_ARTIST_COUNT", 1, 0},
        {LTY_ALBUM_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_ALBUM_COUNT", 1, 0},
        {LTY_SONG_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_SONG_COUNT", 1, 0},
        {LTY_GENRE_ARTIST_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_COUNT", 1, 0},
        {LTY_GENRE_ARTIST_ALBUM_COUNT, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_ALBUM_COUNT", 1, 0},
        {LTY_GENRE_ARTIST_ALBUM_SONG_COUNT, 1, 1, 0, 1, "", (const char *)"LTY_GENRE_ARTIST_ALBUM_SONG_COUNT", 1, 0},
        {LTY_GENRE_ARTIST_SONG_COUNT, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_SONG_COUNT", 1, 0},
        {LTY_GENRE_ALBUM_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ALBUM_COUNT", 1, 0},
        {LTY_GENRE_ALBUM_SONG_COUNT, 1, 0, 0, 1, "", (const char *)"LTY_GENRE_ALBUM_SONG_COUNT", 1, 0},
        {LTY_GENRE_SONG_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_SONG_COUNT", 1, 0},
        {LTY_ARTIST_ALBUM_COUNT, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_ALBUM_COUNT", 1, 0},
        {LTY_ARTIST_ALBUM_SONG_COUNT, 0, 1, 0, 1, "", (const char *)"LTY_ARTIST_ALBUM_SONG_COUNT", 1, 0},
        {LTY_ARTIST_SONG_COUNT, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_SONG_COUNT", 1, 0},
        {LTY_ALBUM_SONG_COUNT, 0, 0, 0, 1, "", (const char *)"LTY_ALBUM_SONG_COUNT", 1, 0},
        {LTY_PODCAST_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_PODCAST_COUNT", 1, 0},
        {LTY_PODCAST_EPISODE_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_PODCAST_EPISODE_COUNT", 1, 0},
        {LTY_AUDIOBOOK_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_AUDIOBOOK_COUNT", 1, 0},
        {LTY_BOOKTITLE_CHAPTER_COUNT, 0, 1, 0, 0, "", (const char *)"LTY_BOOKTITLE_CHAPTER_COUNT", 1, 0},
        {LTY_AUTHOR_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_AUTHOR_COUNT", 1, 0},
        {LTY_AUTHOR_BOOKTITLE_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_AUTHOR_BOOKTITLE_COUNT", 1, 0},
        {LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT, 1, 1, 0, 0, "", (const char *)"LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT", 1, 0},
        {LTY_COMPOSER_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_COMPOSER_COUNT", 1, 0},
        {LTY_COMPOSER_ALBUM_COUNT, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_ALBUM_COUNT", 1, 0},
        {LTY_COMPOSER_ALBUM_SONG_COUNT, 0, 0, 1, 1, "", (const char *)"LTY_COMPOSER_ALBUM_SONG_COUNT", 1, 0},
        {LTY_COMPOSER_SONG_COUNT, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_SONG_COUNT", 1, 0},
        {LTY_VIDEO_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_VIDEO_COUNT", 1, 0},
        {LTY_VIDEO_EPISODE_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_VIDEO_EPISODE_COUNT", 1, 0},
        {LTY_PLAYLIST_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_COUNT", 1, 0},
        {LTY_PLAYLIST_SONG_COUNT, 1, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_SONG_COUNT", 1, 0},
        {LTY_IMAGE_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_IMAGE_COUNT", 1, 0},
        {LTY_PLAYLIST_INTERNAL_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_INTERNAL_COUNT", 1, 0},
        {LTY_EPISODE_OF_VIDEO_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_EPISODE_OF_VIDEO_COUNT", 1, 0},
        {LTY_IMAGE_FOLDER_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_IMAGE_FOLDER_COUNT", 1, 0},
        {LTY_IMAGE_FOLDER_ITEM_COUNT, 0, 0, 0, 0, "/images/", (const char *)"LTY_IMAGE_FOLDER_ITEM_COUNT", 1, 0},
        {LTY_COMPILATION_COUNT, 0, 0, 0, 0, "", (const char *)"LTY_COMPILATION_COUNT", 1, 0},
        {LTY_COMPILATION_SONG_COUNT, 0, 0, 0, 1, "", (const char *)"LTY_COMPILATION_SONG_COUNT", 1, 0},
//        {LTY_BROWSELIST_COUNT, 0, 0, 0, 0, "/music/", (const char *)"LTY_BROWSELIST_COUNT", 1, 0}, makes no sense because the browse list is a kind of file list related to a device

        {LTY_ALBUM_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_ARTIST_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_ARTIST_SEARCH_KEY", 1, 0},
        {LTY_GENRE_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_GENRE_SEARCH_KEY", 1, 0},
        {LTY_SONG_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_SONG_SEARCH_KEY", 1, 0},
        {LTY_COMPOSER_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_COMPOSER_SEARCH_KEY", 1, 0},
        {LTY_GENRE_ARTIST_ALBUM_SEARCH_KEY, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_GENRE_ARTIST_SONG_SEARCH_KEY, 1, 1, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_SONG_SEARCH_KEY", 1, 0},
        {LTY_GENRE_ARTIST_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ARTIST_SEARCH_KEY", 1, 0},
        {LTY_GENRE_ALBUM_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_GENRE_SONG_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_GENRE_SONG_SEARCH_KEY", 1, 0},
        {LTY_ARTIST_ALBUM_SEARCH_KEY, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_ARTIST_SONG_SEARCH_KEY, 0, 1, 0, 0, "", (const char *)"LTY_ARTIST_SONG_SEARCH_KEY", 1, 0},
        {LTY_COMPOSER_ALBUM_SEARCH_KEY, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_ALBUM_SEARCH_KEY", 1, 0},
        {LTY_COMPOSER_SONG_SEARCH_KEY, 0, 0, 1, 0, "", (const char *)"LTY_COMPOSER_SONG_SEARCH_KEY", 1, 0},
        {LTY_PLAYLIST_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_PLAYLIST_SEARCH_KEY", 1, 1},
        {LTY_VIDEO_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_VIDEO_SEARCH_KEY", 1, 0},
        {LTY_VIDEO_EPISODE_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_VIDEO_EPISODE_SEARCH_KEY", 1, 0},
        {LTY_PODCAST_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_PODCAST_SEARCH_KEY", 1, 0},
        {LTY_PODCAST_EPISODE_SEARCH_KEY, 1, 0, 0, 0, "", (const char *)"LTY_PODCAST_EPISODE_SEARCH_KEY", 1, 0},
        {LTY_AUDIOBOOK_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_AUDIOBOOK_SEARCH_KEY", 1, 0},
        {LTY_COMPILATION_SEARCH_KEY, 0, 0, 0, 0, "", (const char *)"LTY_COMPILATION_SEARCH_KEY", 1, 0},
    };

    for(tUInt iTestPlan = 0; iTestPlan<(sizeof(testPlan)/sizeof(tTestPlan)); iTestPlan++) {

        testPlanElem.listType = testPlan[iTestPlan].listType;
        testPlanElem.filterTag1 = testPlan[iTestPlan].filterTag1;
        testPlanElem.filterTag2 = testPlan[iTestPlan].filterTag2;
        testPlanElem.filterTag3 = testPlan[iTestPlan].filterTag3;
        testPlanElem.filterTag4 = testPlan[iTestPlan].filterTag4;
        strncpy_r(OUT testPlanElem.path, IN testPlan[iTestPlan].path, IN sizeof(testPlanElem.path));
        testPlanElem.cListname = testPlan[iTestPlan].cListname;
        testPlanElem.indexPresent = testPlan[iTestPlan].indexPresent;
        testPlanElem.tempBTreePresent = testPlan[iTestPlan].tempBTreePresent;

        testPlanVector.push_back(testPlanElem);
    }

    ExplainSelects(IN testPlanVector, IN MY_MEDIA);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::ExplainSelects(const vector<tTestPlan> testPlan, const tDeviceID deviceID)
{
    ENTRY_INTERNAL

    tResult res = MP_NO_ERROR;
    Query query;
    char planResult[2048];
    int indexPresent;
    int tempBTreePresent;
    const char *cListname;
    tListType listType;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tPath path;

    /* wait until background speed up has finished */
    LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();

    vector<string> usedIndixes;
    //int adjustIDFrom = -1;
    tGeneralString formatBuffer;

    for(tUInt iTestPlan = 0; iTestPlan<testPlan.size(); iTestPlan++) {

        listType = testPlan[iTestPlan].listType;
        filterTag1.tag = testPlan[iTestPlan].filterTag1;
        filterTag2.tag = testPlan[iTestPlan].filterTag2;
        filterTag3.tag = testPlan[iTestPlan].filterTag3;
        filterTag4.tag = testPlan[iTestPlan].filterTag4;
        strncpy_r(OUT path, IN testPlan[iTestPlan].path, IN sizeof(path));
        cListname = testPlan[iTestPlan].cListname;
        indexPresent = testPlan[iTestPlan].indexPresent;
        tempBTreePresent = testPlan[iTestPlan].tempBTreePresent;

        if (strlen_r(path) > 0)
        {
            res = query.Select(IN listType, IN deviceID, "t", IN path);
        }
        else
        {
            tSearchString searchString;/*due Roadmap 16014*/
            searchString[0] = '\0';
            LocalSPM::GetDBManager().SelectFormatString(INOUT formatBuffer, IN filterTag1, IN filterTag2, IN filterTag3, IN filterTag4, IN searchString);
            res = query.Select(IN listType, IN deviceID, IN formatBuffer, IN filterTag1.tag, IN filterTag2.tag, IN filterTag3.tag, IN filterTag4.tag);
        }
        if (res) break;

        query.Explain(OUT planResult, IN sizeof(planResult));

        /* trace out the plan */
        ETG_TRACE_USR4(("ListType: %s:", cListname));
        char *cptr = planResult;
        while(*cptr) {
            char *cptrEnd = strstr(cptr, "\n");
            if (!cptrEnd) break;
            *cptrEnd = 0;
            ETG_TRACE_USR4(("plan: %s", cptr));
            *cptrEnd = '\n';
            cptr = cptrEnd+1;
        }

        /* check the plan */
        int count;

#if 1 // =0: for readjusting the test expectations by hand
        /* count the 'USING COVERING INDEX' parts */
        count = 0;
        cptr = planResult;
        while(1) {
            cptr = strstr(cptr, "INDEX");
            if (!cptr) break;
            /* figure out the name of the index */
            cptr += 6; // points now behind the word INDEX
            char *cptr2 = strstr(cptr, " ");
            if (cptr2) {
                *cptr2 = 0; // end the string here, for now
                string indexName(cptr);
                usedIndixes.push_back(indexName);
                *cptr2 = ' ';
                cptr = cptr2;
            }

            count++;
        }
        ETG_TRACE_USR4(("listtype:%48s, count:%d,indexPresent:%d\n",cListname, count ,indexPresent));
        CPPUNIT_ASSERT_MESSAGE(cListname, count == indexPresent);

        /* count the 'USE TEMP B-TREE FOR' parts */
        count = 0;
        cptr = planResult;
        while(1) {
            cptr = strstr(cptr, "USE TEMP B-TREE FOR");
            if (!cptr) break;
            count++;
            cptr++;
        }

        ETG_TRACE_USR4(("listtype:%48s, count:%d,tempBTreePresent:%d\n",cListname, count ,tempBTreePresent));
        if (tempBTreePresent >= 0) { // normal b-tree check on count
            CPPUNIT_ASSERT_MESSAGE(cListname, count == tempBTreePresent);
        } else { // special check: count may be zero or abs(tempBTreePresent)
            if (count) {
                CPPUNIT_ASSERT_MESSAGE(cListname, count == abs(tempBTreePresent));
            }
        }
#else
        if (listType == LTY_PLAYLIST || iTestPlan >= adjustIDFrom) {
            adjustIDFrom = iTestPlan;
            printf(" break here ");
        }
#endif

#if 0 // todo: for test - remove later on
        if (listType < LTY_GENRE_COUNT) {

            /* check also the positioning select */
            Query pos;

            res = pos.PositionSelect(IN &query, IN deviceID, "");
            if (res) break;

            pos.Explain(OUT planResult, IN sizeof(planResult));

            /* trace out the plan */
            ETG_TRACE_USR4(("ListType(Positioning): %s:", cListname));
            char *cptr = planResult;
            while(*cptr) {
                char *cptrEnd = strstr(cptr, "\n");
                if (!cptrEnd) break;
                *cptrEnd = 0;
                ETG_TRACE_USR4(("plan: %s", cptr));
                *cptrEnd = '\n';
                cptr = cptrEnd+1;
            }
            printf(" end ");
        }
#endif
    }

    ETG_TRACE_USR1(("ExplainSelects: used indexes"));
    for(unsigned int i=0; i < usedIndixes.size(); i++) {
        ETG_TRACE_USR1(("%s", usedIndixes[i].c_str()));
    }
    ETG_TRACE_USR1(("ExplainSelects: end"));
}

extern "C" int sortlib_compare(const void *string1, const void *string2);

void DBManagerTest::CheckSortLib()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    char *A;
    char *B;
    char *C;
    int res1;
    int res2;
    int res3;

    A = B = C = (char *)"A Text";
    res1 = sortlib_compare(A, B);
    res2 = sortlib_compare(B, A);
    CPPUNIT_ASSERT_MESSAGE("A==B then B==A", res1 == 0 && res2 == 0);

    res1 = sortlib_compare(A, B);
    res2 = sortlib_compare(B, C);
    res3 = sortlib_compare(C, A);
    CPPUNIT_ASSERT_MESSAGE("A==B and B==C then A==C", res1 == 0 && res2 == 0 && res3 == 0);

    A = (char *)"Affe";
    B = (char *)"Baum";
    res1 = sortlib_compare(A, B);
    res2 = sortlib_compare(B, A);
    CPPUNIT_ASSERT_MESSAGE("A<B then B>A", res1 < 0 && res2 > 0);

    C = (char *)"Check";
    res1 = sortlib_compare(A, B);
    res2 = sortlib_compare(B, C);
    res3 = sortlib_compare(A, C);
    CPPUNIT_ASSERT_MESSAGE("A<B and B<C then A<C", res1 < 0 && res2 < 0 && res3 < 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CheckSortLibNumberSort()
{
    ENTRY_TEST

    char testStrings[3][10];
    char compStrings[3][10];

    strcpy(testStrings[0], "01-Title");
    strcpy(testStrings[1], "02-Title");
    strcpy(testStrings[2], "001-Title");

    strcpy(compStrings[0], "01-Title");
    strcpy(compStrings[1], "001-Title");
    strcpy(compStrings[2], "02-Title");

    qsort(testStrings, 3, 10, sortlib_compare);

    // debug
    for(int i=0; i<3; i++) {
        ETG_TRACE_USR1(("CheckSortLibNumberSort: testStrings[%d]=%10s, compStrings[%d]=%s", i, testStrings[i], i, compStrings[i]));
    }

    /* compare the result */
    for(int i=0; i<3; i++) {
        CPPUNIT_ASSERT(!strcmp(testStrings[i], compStrings[i]));
    }
}

void DBManagerTest::CheckSortLibListSortOnNumbers()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tListID listID;
    tListSize listSize;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* create a song list to get one mediaobject as template */
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    vector<tMediaObject> mediaObjectVector;
    res =  LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    /* create media objects with test titles with numbers */
    tMediaObject mediaObject = mediaObjectVector[0];

    char *titles[] = {
            (char *)"01-Title",
            (char *)"02-Title",
            (char *)"001-Title"
    };

    for(unsigned int i=0; i<sizeof(titles)/sizeof(char *); i++) {
        strncpy_r(OUT mediaObject.title, IN titles[i], IN sizeof(mediaObject.title));
        strncpy_r(OUT mediaObject.fileName, IN titles[i], IN sizeof(mediaObject.fileName));
        res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
        CPPUNIT_ASSERT(res == 0);
    }
    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    /* recreate the song list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    mediaObjectVector.clear();
    res =  LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 3);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 3);

    /* check the sequence */
    char *compare[] = {
            (char *)"01-Title",
            (char *)"001-Title",
            (char *)"02-Title"
    };
    // debug
    for(unsigned int i=0; i<sizeof(compare)/sizeof(char *); i++) {
        ETG_TRACE_USR1(("CheckSortLibListSortOnNumbers: mediaObjectVector[%d].title=%s",
                i, mediaObjectVector[i].title))
    }
    for(unsigned int i=0; i<sizeof(compare)/sizeof(char *); i++) {
        CPPUNIT_ASSERT(!strcmp(compare[i], mediaObjectVector[i].title));
    }

    /* remove the new objects */
    for(unsigned int i=0; i<mediaObjectVector.size(); i++) {
        res = LocalSPM::GetDBManager().RemoveMediaObject(IN mediaObjectVector[i].objectID);
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::MaxDeviceCountAndID()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    Query query;
    tDeviceCount deviceCount = 0;
    vector<tDeviceID> deviceIDs;

    InitDeviceInfo(OUT deviceInfo);

    /* set the general device infos */
    deviceInfo.activeSource = 1;
    deviceInfo.connected = 1;
    strncpy_r(OUT deviceInfo.deviceName, "USB", IN sizeof(deviceInfo.deviceName));
    deviceInfo.deviceType = DTY_USB;
    deviceInfo.connectionState = CS_DISCONNECTED;
    strncpy_r(OUT deviceInfo.UUID, "987654321", IN sizeof(deviceInfo.UUID));
    strncpy_r(OUT deviceInfo.deviceVersion, "1.0", IN sizeof(deviceInfo.deviceVersion));
    strncpy_r(OUT deviceInfo.mountPoint, "/media/any-mount-point", IN sizeof( deviceInfo.mountPoint));
    strncpy_r(OUT deviceInfo.accessoryName, "/dev/sda", IN sizeof(deviceInfo.accessoryName));
    deviceInfo.fileSystemType = FSTY_FAT;
    deviceInfo.partitionNumber = 1;
    deviceInfo.totalSize = 33554432; //32GB
    deviceInfo.freeSize = 20971520; //20GB
    deviceInfo.productID = 1234;
    deviceInfo.connectionType = DCT_USB;

    /* loop to add devices */
    for(int i=0; i < LocalSPM::GetDataProvider().MaxNoOfDevicesInDB()+6; i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        /* check the count of devices */
        res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
        CPPUNIT_ASSERT(res == 0);
        res = query.Get(IN "i", OUT &deviceCount);
        query.End();
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR3(("DBManagerTest::MaxDeviceCountAndID --> deviceCount: %d",deviceCount));
        if ((int)deviceCount > LocalSPM::GetDataProvider().MaxNoOfDevicesInDB()+1) break;

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    /* check the given id's */
    query.Select(LTY_DEVICES, MY_MEDIA, "");
    tDeviceID testDeviceID;
    tDeviceID deviceID = 0;
    for(testDeviceID=0; (int)testDeviceID<LocalSPM::GetDataProvider().MaxNoOfDevicesInDB()+1; testDeviceID++) {
        res = query.Get(IN "i", OUT &deviceID);
        if (res) break;
        if (testDeviceID != deviceID) break;
    }
    query.End();

    /* remove all test devices */
    for(unsigned int i = 0; i<deviceIDs.size(); i++) {
        LocalSPM::GetDBManager().RemoveDevice(IN deviceIDs[i]);
    }

    /* recreate the original devices */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(res == 0);

    CPPUNIT_ASSERT_MESSAGE("No of devices exceeds max definition", (int)deviceCount <= LocalSPM::GetDataProvider().MaxNoOfDevicesInDB()+1);
    CPPUNIT_ASSERT_MESSAGE("ID sequence not ok", testDeviceID-1 == deviceID);
    CPPUNIT_ASSERT_MESSAGE("Error reading device table for test", res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::MaxDeviceLimit()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    Query query;
    tDeviceCount initialDeviceCount = 0;
    tDeviceCount cleanedUpDeviceCount = 0;
    tDeviceCount deviceCount = 0;
    tDeviceCount deviceCountInDB = 0;
    tDeviceCount totalIndexableDeviceCountDB = 0;
    vector<tDeviceID> deviceIDs;
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo oldestDevice;
    tNumberOfDevices numberOfDevices = 0;

    InitDeviceInfo(OUT deviceInfo);

    /* set the general device infos */
    deviceInfo.activeSource = 1;
    deviceInfo.connected = 1;
    strncpy_r(OUT deviceInfo.deviceName, "USB", IN sizeof(deviceInfo.deviceName));
    deviceInfo.deviceType = DTY_USB;
    deviceInfo.connectionState = CS_DISCONNECTED;
    strncpy_r(OUT deviceInfo.UUID, "987654321", IN sizeof(deviceInfo.UUID));
    strncpy_r(OUT deviceInfo.deviceVersion, "1.0", IN sizeof(deviceInfo.deviceVersion));
    strncpy_r(OUT deviceInfo.mountPoint, "/media/any-mount-point", IN sizeof( deviceInfo.mountPoint));
    strncpy_r(OUT deviceInfo.accessoryName, "/dev/sda", IN sizeof(deviceInfo.accessoryName));
    deviceInfo.fileSystemType = FSTY_FAT;
    deviceInfo.partitionNumber = 1;
    deviceInfo.totalSize = 33554432; //32GB
    deviceInfo.freeSize = 20971520; //20GB
    deviceInfo.productID = 1234;
    deviceInfo.connectionType = DCT_USB;

    res = LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: numberOfDevices = %d",numberOfDevices));

    /* remove all devices from existing db file */
    vector<tDeviceInfo>::iterator itr = deviceInfos.begin();
    while(itr != deviceInfos.end())
    {
        if(itr->deviceID > 1) //exclude static devices: MyMedia & music_box
            LocalSPM::GetDBManager().RemoveDevice(IN itr->deviceID);
        itr++;
    }

    /* Count current number of devices in db file */
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &initialDeviceCount);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* Use case 1 - DB has total 10 indexable devices */
    /* loop to add 10 indexable devices */
    for(int i=0; i < LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB(); i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
        CPPUNIT_ASSERT(res == 0);
        res = query.Get(IN "i", OUT &deviceCount);
        query.End();
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit --> indexable deviceCount: %d",deviceCount));
        if ((int)deviceCount > LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+1) break;

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    InitDeviceInfo(oldestDevice);
    res = query.Select(LTY_INDEXABLEDEVICES_OLDEST, MY_MEDIA,"");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i-T", OUT &oldestDevice.deviceID, OUT oldestDevice.serialNumber, IN sizeof(oldestDevice.serialNumber));
    query.End();
    CPPUNIT_ASSERT(res == 0);

    /* User connect Indexable device */
    /* set the serial number, UUID, serialNumber */
    int i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB() + 50;
    strncpy_r(OUT deviceInfo.UUID, "123456789", IN sizeof(deviceInfo.UUID));
    snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

    /* put this into the data base */
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);
    deviceIDs.push_back(deviceInfo.deviceID);

    //remove all added deviceIDs
    for(unsigned int j = 0; j < deviceIDs.size(); j++)
    {
        LocalSPM::GetDBManager().RemoveDevice(deviceIDs[j]);
    }

    //Count total devices after cleaning up.
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &cleanedUpDeviceCount);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* VERIFY: Compare Device ID of oldest and newly added device. both should be same.*/
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Use case 1 :oldest_removed_ID = %d",oldestDevice.deviceID));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Use case 1 : new_added_ID = %d",deviceInfo.deviceID));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: initialDeviceCount = %d",initialDeviceCount));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: cleanedUpDeviceCount = %d",cleanedUpDeviceCount));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_device_serial = %s",deviceInfo.serialNumber));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: old_device_serial = %s",oldestDevice.serialNumber));

    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device IDs not matching",deviceInfo.deviceID == oldestDevice.deviceID);
    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device serialID should not match",strcmp(deviceInfo.serialNumber,oldestDevice.serialNumber));
    CPPUNIT_ASSERT_MESSAGE("Initial and Final device count not matching",initialDeviceCount == cleanedUpDeviceCount);

/*----------------------------------------------------------------------------------------------------------------------------------------*/

    /* Use case 2 - DB has total 14 devices ( 9 indexable devices and 5 non-indexable ) */
    deviceIDs.clear();
    /* loop to add 9 indexable devices */
    for(int i=0; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()-1); i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
        CPPUNIT_ASSERT(res == 0);
        res = query.Get(IN "i", OUT &deviceCount);
        query.End();
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit --> indexable deviceCount: %d",deviceCount));
        if ((int)deviceCount > LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+1) break;

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    /* loop to add 5 Non-indexable devices */
    deviceInfo.deviceType = DTY_BLUETOOTH;
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB();
    strncpy_r(OUT deviceInfo.UUID, "345678912", IN sizeof(deviceInfo.UUID));

    for(i; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+5); i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    InitDeviceInfo(oldestDevice);
    res = query.Select(LTY_INDEXABLEDEVICES_OLDEST, MY_MEDIA,"");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i-T", OUT &oldestDevice.deviceID, OUT oldestDevice.serialNumber, IN sizeof(oldestDevice.serialNumber));
    query.End();
    CPPUNIT_ASSERT(res == 0);

    /* User connect Non-indexable device */
    /* set the serial number, UUID, serialNumber */
    deviceInfo.deviceType = DTY_BLUETOOTH;
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB() + 60;
    strncpy_r(OUT deviceInfo.UUID, "123456789", IN sizeof(deviceInfo.UUID));
    snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

    /* put this into the data base */
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);
    deviceIDs.push_back(deviceInfo.deviceID);

    /* check total number of devices in db */
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &deviceCountInDB);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* check totla number of Indexable devices in db */
    res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &totalIndexableDeviceCountDB);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    //remove all added deviceIDs
    for(unsigned int j = 0; j < deviceIDs.size(); j++)
    {
        LocalSPM::GetDBManager().RemoveDevice(deviceIDs[j]);
    }

    //Count total devices after cleaning up.
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &cleanedUpDeviceCount);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* VERIFY: Compare Device ID of oldest and newly added device. both should not be same.*/
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Use case 2 : Number of devices in db = %d",deviceCountInDB));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Number of Indexable devices in db = %d",totalIndexableDeviceCountDB));

    CPPUNIT_ASSERT_MESSAGE("Number of devices in db", (int)deviceCountInDB == LocalSPM::GetDataProvider().MaxNoOfDevicesInDB()-4);
    CPPUNIT_ASSERT_MESSAGE("Number of Indexable devices in db", (int)totalIndexableDeviceCountDB == LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()-1);

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: oldest_removed_ID = %d",oldestDevice.deviceID));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_added_ID = %d",deviceInfo.deviceID));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: initialDeviceCount = %d",initialDeviceCount));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: cleanedUpDeviceCount = %d",cleanedUpDeviceCount));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_device_serial = %s",deviceInfo.serialNumber));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: old_device_serial = %s",oldestDevice.serialNumber));

    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device IDs are matching",deviceInfo.deviceID != oldestDevice.deviceID);
    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device serialID should not match",strcmp(deviceInfo.serialNumber, oldestDevice.serialNumber));
    CPPUNIT_ASSERT_MESSAGE("Initial and Final device count not matching",initialDeviceCount == cleanedUpDeviceCount);

/*----------------------------------------------------------------------------------------------------------------------------------------*/

    /* Use case 3 - DB has total 14 devices ( 10 indexable devices and 4 non-indexable ) */
    deviceIDs.clear();
    deviceInfo.deviceType = DTY_USB;
    /* loop to add 10 indexable devices */
    for(int i=0; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()); i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
        CPPUNIT_ASSERT(res == 0);
        res = query.Get(IN "i", OUT &deviceCount);
        query.End();
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit --> indexable deviceCount: %d",deviceCount));
        if ((int)deviceCount > LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+1) break;

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    /* loop to add 4 Non-indexable devices */
    deviceInfo.deviceType = DTY_BLUETOOTH;
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB();
    strncpy_r(OUT deviceInfo.UUID, "345678912", IN sizeof(deviceInfo.UUID));

    for(i; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+4); i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    InitDeviceInfo(oldestDevice);
    res = query.Select(LTY_INDEXABLEDEVICES_OLDEST, MY_MEDIA,"");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i-T", OUT &oldestDevice.deviceID, OUT oldestDevice.serialNumber, IN sizeof(oldestDevice.serialNumber));
    query.End();
    CPPUNIT_ASSERT(res == 0);

    /* User connect Non-Indexable device */
    deviceInfo.deviceType = DTY_BLUETOOTH;
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB() + 70;
    strncpy_r(OUT deviceInfo.UUID, "123456789", IN sizeof(deviceInfo.UUID));
    snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

    /* put this into the data base */
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);
    deviceIDs.push_back(deviceInfo.deviceID);

    /* check total number of devices in db */
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &deviceCountInDB);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* check totla number of Indexable devices in db */
    res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &totalIndexableDeviceCountDB);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    //remove all added deviceIDs
    for(unsigned int j = 0; j < deviceIDs.size(); j++)
    {
        LocalSPM::GetDBManager().RemoveDevice(deviceIDs[j]);
    }

    //Count total devices after cleaning up.
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &cleanedUpDeviceCount);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* VERIFY: Compare Device ID of oldest and newly added device. both should not be same.*/
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Use case 3 : Number of devices in db = %d",deviceCountInDB));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Number of Indexable devices in db = %d",totalIndexableDeviceCountDB));

    CPPUNIT_ASSERT_MESSAGE("Number of devices in db", (int)deviceCountInDB == LocalSPM::GetDataProvider().MaxNoOfDevicesInDB()-4);
    CPPUNIT_ASSERT_MESSAGE("Number of Indexable devices in db", (int)totalIndexableDeviceCountDB == LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB());

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: oldest_removed_ID = %d",oldestDevice.deviceID));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_added_ID = %d",deviceInfo.deviceID));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: initialDeviceCount = %d",initialDeviceCount));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: cleanedUpDeviceCount = %d",cleanedUpDeviceCount));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_device_serial = %s",deviceInfo.serialNumber));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: old_device_serial = %s",oldestDevice.serialNumber));

    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device IDs are matching",deviceInfo.deviceID != oldestDevice.deviceID);
    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device serialID should not match",strcmp(deviceInfo.serialNumber, oldestDevice.serialNumber));
    CPPUNIT_ASSERT_MESSAGE("Initial and Final device count not matching",initialDeviceCount == cleanedUpDeviceCount);

/*----------------------------------------------------------------------------------------------------------------------------------------*/

    /* Use case 4 - DB has total 14 devices ( 9 indexable devices and 5 non-indexable ) */
    deviceIDs.clear();
    deviceInfo.deviceType = DTY_USB;
    /* loop to add 9 indexable devices */
    for(int i=0; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB())-1; i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
        CPPUNIT_ASSERT(res == 0);
        res = query.Get(IN "i", OUT &deviceCount);
        query.End();
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit --> indexable deviceCount: %d",deviceCount));
        if ((int)deviceCount > LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+1) break;

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    /* loop to add 5 Non-indexable devices */
    deviceInfo.deviceType = DTY_BLUETOOTH;
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB();
    strncpy_r(OUT deviceInfo.UUID, "345678912", IN sizeof(deviceInfo.UUID));

    for(i; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+5); i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }
    InitDeviceInfo(oldestDevice);
    res = query.Select(LTY_INDEXABLEDEVICES_OLDEST, MY_MEDIA,"");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i-T", OUT &oldestDevice.deviceID, OUT &oldestDevice.serialNumber, IN sizeof(oldestDevice.serialNumber));
    query.End();
    CPPUNIT_ASSERT(res == 0);

    /* User connect Indexable device */
    /* set the serial number, UUID, serialNumber */
    deviceInfo.deviceType = DTY_USB;
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB() + 80;
    strncpy_r(OUT deviceInfo.UUID, "123456789", IN sizeof(deviceInfo.UUID));
    snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

    /* put this into the data base */
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);
    deviceIDs.push_back(deviceInfo.deviceID);

    /* check total number of devices in db */
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &deviceCountInDB);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* check totla number of Indexable devices in db */
    res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &totalIndexableDeviceCountDB);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    //remove all added deviceIDs
    for(unsigned int j = 0; j < deviceIDs.size(); j++)
    {
        LocalSPM::GetDBManager().RemoveDevice(deviceIDs[j]);
    }

    //Count total devices after cleaning up.
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &cleanedUpDeviceCount);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* VERIFY: Compare Device ID of oldest and newly added device. both should not be same.*/
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Use case 4 : Number of devices in db = %d",deviceCountInDB));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Number of Indexable devices in db = %d",totalIndexableDeviceCountDB));

    CPPUNIT_ASSERT_MESSAGE("Number of devices in db", (int)deviceCountInDB == LocalSPM::GetDataProvider().MaxNoOfDevicesInDB()-4);
    CPPUNIT_ASSERT_MESSAGE("Number of Indexable devices in db", (int)totalIndexableDeviceCountDB == LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB());

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: oldest_removed_ID = %d",oldestDevice.deviceID));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_added_ID = %d",deviceInfo.deviceID));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: initialDeviceCount = %d",initialDeviceCount));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: cleanedUpDeviceCount = %d",cleanedUpDeviceCount));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_device_serial = %s",deviceInfo.serialNumber));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: old_device_serial = %s",oldestDevice.serialNumber));

    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device IDs are matching",deviceInfo.deviceID != oldestDevice.deviceID);
    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device serialID should not match",strcmp(deviceInfo.serialNumber, oldestDevice.serialNumber));
    CPPUNIT_ASSERT_MESSAGE("Initial and Final device count not matching",initialDeviceCount == cleanedUpDeviceCount);


/*----------------------------------------------------------------------------------------------------------------------------------------*/

     /* Use case 5 - DB has total 21 devices (  10 indexable devices and 11 non-indexable ) */
    deviceIDs.clear();
    deviceInfo.deviceType = DTY_USB;

    /* loop to add 10 indexable devices */
    for(int i=0; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()); i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
        CPPUNIT_ASSERT(res == 0);
        res = query.Get(IN "i", OUT &deviceCount);
        query.End();
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit --> indexable deviceCount: %d",deviceCount));
        if ((int)deviceCount > LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+1) break;

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    /* loop to add 11 Non-indexable devices */
    deviceInfo.deviceType = DTY_BLUETOOTH;
    deviceInfo.connectionType = DCT_BLUETOOTH;
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB();
    strncpy_r(OUT deviceInfo.UUID, "345678912", IN sizeof(deviceInfo.UUID));

    for(i; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+11); i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    InitDeviceInfo(oldestDevice);
    res = query.Select(LTY_INDEXABLEDEVICES_OLDEST, MY_MEDIA,"");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i-T", OUT &oldestDevice.deviceID, OUT oldestDevice.serialNumber, IN sizeof(oldestDevice.serialNumber));
    query.End();
    CPPUNIT_ASSERT(res == 0);

    /* User connect Non-Indexable device */
    deviceInfo.deviceType = DTY_BLUETOOTH;
    deviceInfo.connectionType = DCT_BLUETOOTH;
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB() + 90;
    strncpy_r(OUT deviceInfo.UUID, "123456789", IN sizeof(deviceInfo.UUID));
    snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

    /* put this into the data base */
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);
    deviceIDs.push_back(deviceInfo.deviceID);

    /* check total number of devices in db */
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &deviceCountInDB);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* check totla number of Indexable devices in db */
    res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &totalIndexableDeviceCountDB);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    //remove all added deviceIDs
    for(unsigned int j = 0; j < deviceIDs.size(); j++)
    {
        LocalSPM::GetDBManager().RemoveDevice(deviceIDs[j]);
    }

    //Count total devices after cleaning up.
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &cleanedUpDeviceCount);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* VERIFY: Compare Device ID of oldest and newly added device. both should not be same.*/
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Use case 5 : Number of devices in db = %d",deviceCountInDB));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Number of Indexable devices in db = %d",totalIndexableDeviceCountDB));

    CPPUNIT_ASSERT_MESSAGE("Number of devices in db", (int)deviceCountInDB == LocalSPM::GetDataProvider().MaxNoOfDevicesInDB());
    CPPUNIT_ASSERT_MESSAGE("Number of Indexable devices in db", (int)totalIndexableDeviceCountDB == LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB());

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: oldest_removed_ID = %d",oldestDevice.deviceID));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_added_ID = %d",deviceInfo.deviceID));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: initialDeviceCount = %d",initialDeviceCount));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: cleanedUpDeviceCount = %d",cleanedUpDeviceCount));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_device_serial = %s",deviceInfo.serialNumber));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: old_device_serial = %s",oldestDevice.serialNumber));

    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device IDs are matching",deviceInfo.deviceID != oldestDevice.deviceID);
    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device serialID should not match",strcmp(deviceInfo.serialNumber, oldestDevice.serialNumber));
    CPPUNIT_ASSERT_MESSAGE("Initial and Final device count not matching",initialDeviceCount == cleanedUpDeviceCount);


/*----------------------------------------------------------------------------------------------------------------------------------------*/

    /* Use case 6 - DB has total 21 devices(including MusicBox and MyMedia.db) so, adding more 9 indexable devices and 10 non-indexable */
    tDeviceCount deviceCountInDBBefore = 0;
    tDeviceCount deviceCountInDBAfter = 0;
    deviceIDs.clear();
    deviceInfo.deviceType = DTY_USB;
    deviceInfo.connectionType = DCT_USB;

    /* loop to add 9 indexable devices */
    for(int i=0; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB())-1; i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
        CPPUNIT_ASSERT(res == 0);
        res = query.Get(IN "i", OUT &deviceCount);
        query.End();
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit --> indexable deviceCount: %d",deviceCount));
        if ((int)deviceCount > LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+1) break;

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    /* Adding one more Non-indexable DTY_IPHONE device having connectionType = DCT_BLUETOOTH */
    strncpy_r(OUT deviceInfo.deviceName, "iPhone", IN sizeof(deviceInfo.deviceName));
    deviceInfo.deviceType = DTY_BLUETOOTH;
    deviceInfo.connectionType = DCT_BLUETOOTH;
    strncpy_r(OUT deviceInfo.appleDeviceMACAddress, "9c04eb023219", IN sizeof(deviceInfo.appleDeviceMACAddress));
    strncpy_r(OUT deviceInfo.UUID, "112233445", IN sizeof(deviceInfo.UUID));
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+80;
    snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", 200);

    /* put this into the data base */
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);
    deviceIDs.push_back(deviceInfo.deviceID);

    /* wait a little bit to get a new timestamp on insertion of a device */
    sleep(1);

    /* Adding one more Non-indexable DTY_IPHONE device having connectionType = DCT_WIFI */
    strncpy_r(OUT deviceInfo.deviceName, "iPhone", IN sizeof(deviceInfo.deviceName));
    deviceInfo.deviceType = DTY_IPHONE;
    deviceInfo.connectionType = DCT_WIFI;
    strncpy_r(OUT deviceInfo.appleDeviceMACAddress, "9c04eb023219", IN sizeof(deviceInfo.appleDeviceMACAddress));
    strncpy_r(OUT deviceInfo.UUID, "123454321", IN sizeof(deviceInfo.UUID));
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+70;
    snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", 201);

    /* put this into the data base */
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);
    deviceIDs.push_back(deviceInfo.deviceID);

    /* wait a little bit to get a new timestamp on insertion of a device */
    sleep(1);

    /* loop to add 8 Non-indexable devices */
    strncpy_r(OUT deviceInfo.deviceName, "DEMO", IN sizeof(deviceInfo.deviceName));
    deviceInfo.deviceType = DTY_BLUETOOTH;
    deviceInfo.connectionType = DCT_BLUETOOTH;
    strncpy_r(OUT deviceInfo.appleDeviceMACAddress, "", IN sizeof(deviceInfo.appleDeviceMACAddress));
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB();
    strncpy_r(OUT deviceInfo.UUID, "345678912", IN sizeof(deviceInfo.UUID));

    for(i; i < (LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()+8); i++) {

        /* set the serial number */
        snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", i+20);

        /* put this into the data base */
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);
        deviceIDs.push_back(deviceInfo.deviceID);

        /* wait a little bit to get a new timestamp on insertion of a device */
        sleep(1);
    }

    InitDeviceInfo(oldestDevice);
    res = query.Select(LTY_NONINDEXABLEDEVICES_OLDEST, MY_MEDIA,"");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i-T", OUT &oldestDevice.deviceID, OUT oldestDevice.serialNumber, IN sizeof(oldestDevice.serialNumber));
    query.End();
    CPPUNIT_ASSERT(res == 0);

    /* check total number of devices in db before adding new device*/
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &deviceCountInDBBefore);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* User connect Non-Indexable device */
    strncpy_r(OUT deviceInfo.deviceName, "ABC", IN sizeof(deviceInfo.deviceName));
    deviceInfo.deviceType = DTY_BLUETOOTH;
    i = LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB() + 90;
    strncpy_r(OUT deviceInfo.UUID, "987654321", IN sizeof(deviceInfo.UUID));
    snprintf(OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber), "%d", 300);

    /* put this into the data base */
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);
    deviceIDs.push_back(deviceInfo.deviceID);

    /* check total number of devices in db after adding new device */
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &deviceCountInDBAfter);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* check totla number of Indexable devices in db */
    res = query.Select(LTY_INDEXABLEDEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &totalIndexableDeviceCountDB);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    //remove all added deviceIDs
    for(unsigned int j = 0; j < deviceIDs.size(); j++)
    {
        LocalSPM::GetDBManager().RemoveDevice(deviceIDs[j]);
    }

    //Count total devices after cleaning up.
    res = query.Select(LTY_DEVICES_COUNT, MY_MEDIA, "");
    CPPUNIT_ASSERT(res == 0);
    res = query.Get(IN "i", OUT &cleanedUpDeviceCount);
    CPPUNIT_ASSERT(res == 0);
    query.End();

    /* VERIFY: Compare Device ID of oldest and newly added device. both should not be same.*/
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Use case 6 : Number of devices in db Before adding new device = %d",deviceCountInDBBefore));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Number of devices in db After adding new device = %d",deviceCountInDBAfter));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: Number of Indexable devices in db = %d",totalIndexableDeviceCountDB));

    CPPUNIT_ASSERT_MESSAGE("Number of devices in db", (int)deviceCountInDBAfter == (int)deviceCountInDBBefore-1);
    CPPUNIT_ASSERT_MESSAGE("Number of Indexable devices in db", (int)totalIndexableDeviceCountDB == LocalSPM::GetDataProvider().MaxNoOfIndexableDevicesInDB()-1);
    CPPUNIT_ASSERT_MESSAGE("Number of Total devices in db", (int)deviceCountInDBBefore == (int)deviceCountInDBAfter+1);

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: initialDeviceCount = %d",initialDeviceCount));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: cleanedUpDeviceCount = %d",cleanedUpDeviceCount));

    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: new_device_serial = %s",deviceInfo.serialNumber));
    ETG_TRACE_USR3(("DBManagerTest::MaxDeviceLimit: old_device_serial = %s",oldestDevice.serialNumber));

    CPPUNIT_ASSERT_MESSAGE("Oldest Device and New Device serialID should not match",strcmp(deviceInfo.serialNumber, oldestDevice.serialNumber));
    CPPUNIT_ASSERT_MESSAGE("Initial and Final device count not matching",initialDeviceCount == cleanedUpDeviceCount);

    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(res == 0);

}

void DBManagerTest::LiveTagsInsert()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    Query query;
    tDeviceID deviceID = MY_MEDIA;
    tTag artistName;
    strncpy_r(artistName, "Superman", sizeof(artistName));
    tCategoryType catType = CTY_ARTIST;
    tNotPlayable notPlayable = FNP_PLAYABLE;

    /* store one tag */
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN artistName, IN catType, IN deviceID, IN notPlayable);
    CPPUNIT_ASSERT(res == 0);

    /* read it back */
    res = query.Select(LTY_LIVETAGS_SELECT, MY_MEDIA, "--ii", IN 0, IN CTY_ARTIST);
    CPPUNIT_ASSERT(res == 0);

    strncpy_r(artistName, "         ", sizeof(artistName));
    tTagID tagID;
    res = query.Get("iiiTi",
            OUT &tagID,
            OUT &deviceID,
            OUT &catType,
            OUT artistName, IN sizeof(artistName),
            OUT &notPlayable);
    query.End();
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(tagID != 0);
    CPPUNIT_ASSERT(deviceID == MY_MEDIA);
    CPPUNIT_ASSERT(catType == CTY_ARTIST);
    CPPUNIT_ASSERT(!strcmp(artistName, "Superman"));
    CPPUNIT_ASSERT(notPlayable == FNP_PLAYABLE);

    tTagID tagID2;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT tagID2, IN CTY_ARTIST, IN artistName);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(tagID == tagID2);

    strncpy_r(OUT artistName, "         ", IN sizeof(artistName));
    catType = CTY_NONE;
    tDeviceID deviceID2;
    notPlayable = FNP_NOT_PLAYABLE;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT artistName, OUT catType, OUT deviceID2, OUT notPlayable, IN tagID2);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceID == deviceID2);
    CPPUNIT_ASSERT(catType == CTY_ARTIST);
    CPPUNIT_ASSERT(!strcmp(artistName, "Superman"));
    CPPUNIT_ASSERT(notPlayable == FNP_PLAYABLE);
}

void DBManagerTest::SyncLiveTagsAndAlbums()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID = MY_MEDIA;

    // sync test for Albums table and LiveTags table for category=Album
    /*Case 1 : Store a new album tag into LiveTag and check if Album table also updated with the same new tag and ID as in LiveTags*/
    tTag albumName;

    /* store one tag */
    strncpy_r(OUT albumName, "Malgudi", IN sizeof(albumName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN albumName, IN CTY_ALBUM, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    tTagID idFromLiveTags;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_ALBUM, IN albumName);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(idFromLiveTags != OBJECT_ID_NONE);

    /*Case 2 : Try to store already existing tag from Albums table into LiverTags , then LiveTag should take the ID from Albums table*/
    strncpy_r(OUT albumName, "Bleibt Alles Anders", IN sizeof(albumName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN albumName, IN CTY_ALBUM, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    idFromLiveTags = OBJECT_ID_NONE;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_ALBUM, IN albumName);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR4(("idFromLiveTags %d",idFromLiveTags));
#ifndef TARGET_BUILD
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(idFromLiveTags == 27);
    }
    else
    {
        CPPUNIT_ASSERT(idFromLiveTags == 60);
    }
#endif
}

void DBManagerTest::SyncLiveTagsAndArtists()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID = MY_MEDIA;

    // sync test for Artists table and LiveTags table for category=Artist
    /*Case 1 : Store a new Artist tag into LiveTag and check if Artist table also updated with the same new tag and ID as in LiveTags*/
    tTag artistName;

    /* store one tag */
    strncpy_r(OUT artistName, "A.R.Rehman", IN sizeof(artistName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN artistName, IN CTY_ARTIST, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    tTagID idFromLiveTags;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_ARTIST, IN artistName);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(idFromLiveTags != OBJECT_ID_NONE);

    /*Case 2 : Try to store already existing tag from Albums table into LiverTags , then LiveTag should take the ID from Albums table*/
    strncpy_r(OUT artistName, "Mando Diao", IN sizeof(artistName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN artistName, IN CTY_ARTIST, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    idFromLiveTags = OBJECT_ID_NONE;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_ARTIST, IN artistName);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR4(("idFromLiveTags %d",idFromLiveTags));
#ifndef TARGET_BUILD
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(idFromLiveTags == 33);
    }
    else
    {
        CPPUNIT_ASSERT(idFromLiveTags == 67);
    }
#endif
}

void DBManagerTest::SyncLiveTagsAndComposers()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID = MY_MEDIA;

    // sync test for Composers table and LiveTags table for category=Composer
    /*Case 1 : Store a new composer tag into LiveTag and check if Composers table also updated with the same new tag and ID as in LiveTags*/
    tTag composerName;

    /* store one tag */
    strncpy_r(OUT composerName, "Hamsalekha", IN sizeof(composerName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN composerName, IN CTY_COMPOSER, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    tTagID idFromLiveTags;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_COMPOSER, IN composerName);
    CPPUNIT_ASSERT(res == 0);

    /*Case 2 : Try to store already existing tag from Albums table into LiverTags , then LiveTag should take the ID from Albums table*/
    strncpy_r(OUT composerName, LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(composerName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN composerName, IN CTY_COMPOSER, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_COMPOSER, IN composerName);
    CPPUNIT_ASSERT(res == 0);
    ETG_TRACE_USR4(("idFromLiveTags %d",idFromLiveTags));
#ifndef TARGET_BUILD
    CPPUNIT_ASSERT(idFromLiveTags == 44);
#endif
}
void DBManagerTest::SyncLiveTagsAndGenres()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID = MY_MEDIA;

    // sync test for Albums table and LiveTags table for category=Album
    /*Case 1 : Store a new album tag into LiveTag and check if Album table also updated with the same new tag and ID as in LiveTags*/
    tTag genreName;

    /* store one tag */
    strncpy_r(OUT genreName, "Jazz", IN sizeof(genreName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN genreName, IN CTY_GENRE, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    tTagID idFromLiveTags;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_GENRE, IN genreName);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(idFromLiveTags != OBJECT_ID_NONE);

    /*Case 2 : Try to store already existing tag from Albums table into LiverTags , then LiveTag should take the ID from Albums table*/
    strncpy_r(OUT genreName, "German Pop", IN sizeof(genreName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN genreName, IN CTY_GENRE, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    idFromLiveTags = OBJECT_ID_NONE;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_GENRE, IN genreName);
    CPPUNIT_ASSERT(res == 0);

    ETG_TRACE_USR4(("idFromLiveTags %d",idFromLiveTags));
#ifndef TARGET_BUILD
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        CPPUNIT_ASSERT(idFromLiveTags == 25);
    }
    else
    {
        CPPUNIT_ASSERT(idFromLiveTags == 58);
    }
#endif
}

void DBManagerTest::SyncLiveTagsAndMediaObject()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tTag fileName;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* store file as a tag in Livetags*/
    strncpy_r(OUT fileName, "/Supertramp/Breakfast_In_America/Supertramp_-_Breakfast_in_America_-_02_-_The_Logical_Song.mp3", IN sizeof(fileName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN fileName, IN CTY_SONG, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    /*check if tagID is valid*/
    tTagID idFromLiveTags;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_SONG, IN fileName);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(idFromLiveTags != 0);

    /*update livetags element*/
    tNotPlayable notPlayable = FNP_NOT_PLAYABLE;
    res = LocalSPM::GetDBManager().UpdateLiveTagsElement(IN idFromLiveTags, IN notPlayable);
    CPPUNIT_ASSERT(res == 0);

    /*check if tagID is valid*/
    tCategoryType catType;
    tDeviceID liveDeviceID;
    notPlayable = FNP_PLAYABLE;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT fileName, OUT catType, OUT liveDeviceID, OUT notPlayable, IN idFromLiveTags);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(liveDeviceID == deviceID);
    CPPUNIT_ASSERT(notPlayable == FNP_NOT_PLAYABLE);

    /*insert the same file into MediaObjects table and check if it gets the same ID as LiveTags element ID*/
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    strncpy_r(OUT mediaObject.albumArtString, "/Supertramp/Breakfast_In_America/Supertramp_-_Breakfast_in_America_-_02_-_The_Logical_Song.mp3", IN sizeof(mediaObject.albumArtString));
    strncpy_r(OUT mediaObject.fileName, "/Supertramp/Breakfast_In_America/Supertramp_-_Breakfast_in_America_-_02_-_The_Logical_Song.mp3", IN sizeof(mediaObject.fileName));
    strncpy_r(OUT mediaObject.path, "/Supertramp/Breakfast_In_America/", IN sizeof(mediaObject.path));
    strncpy_r(OUT mediaObject.title, "The Logical Song", IN sizeof(mediaObject.title));
    strncpy_r(OUT mediaObject.MetadataField1, "Classic Rock", IN sizeof(mediaObject.MetadataField1));
    strncpy_r(OUT mediaObject.MetadataField2, "Supertramp", IN sizeof(mediaObject.MetadataField2));
    strncpy_r(OUT mediaObject.MetadataField3, "Supertramp", IN sizeof(mediaObject.MetadataField3));
    strncpy_r(OUT mediaObject.MetadataField4, "Breakfast in America", IN sizeof(mediaObject.MetadataField4));
    strncpy_r(OUT mediaObject.dateTime, "2016:07:08 17:01:00", IN sizeof(mediaObject.dateTime));
    mediaObject.deviceID = deviceID;
    mediaObject.catType = CTY_SONG;
    mediaObject.metadataConvertFlag = 0;
    mediaObject.compilationFlag = 0;
    mediaObject.totalPlaytime = 180000;
    mediaObject.trackNumber = 3;
    mediaObject.notPlayable = notPlayable;
    mediaObject.fileSize = 5444000LL;
    mediaObject.fileMode = 0;
    mediaObject.userID = 9;
    mediaObject.groupID = 75;

    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);
    /*-----------------------------------------------------------------------------------------------------*/
    tObjectID idFromMediaObjects;
    res = LocalSPM::GetDBManager().GetObjectID(OUT idFromMediaObjects, IN mediaObject.deviceID, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == 0);

    /*Validate if MediaObjects gets the same ID as from the LiveTags element ID for a given URL in a device*/
    CPPUNIT_ASSERT(idFromMediaObjects == idFromLiveTags);


    /*other way : insert a file element into livetag which is already part of Mediaobjects table, then it should get the same ID from MediaObjects's element*/
    /* store known file from Mediaobject table into Livetags*/
    strncpy_r(OUT fileName, "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/07-paralyzed-evighet.mp3", IN sizeof(fileName));
    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN fileName, IN CTY_SONG, IN deviceID, IN FNP_PLAYABLE);
    CPPUNIT_ASSERT(res == 0);

    idFromLiveTags = OBJECT_ID_NONE;
    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT idFromLiveTags, IN CTY_SONG, IN fileName);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetObjectID(OUT idFromMediaObjects, IN deviceID, IN fileName);
    CPPUNIT_ASSERT(res == 0);

    /*since file was already present in the mediaobject table , LiveTag element should receive the ID from the MediaObjects table*/
    CPPUNIT_ASSERT(idFromMediaObjects == idFromLiveTags);
}

void DBManagerTest::FillupMetaDataIDs()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    mediaObject.mediaType = MTY_MUSIC_FILE;

    strncpy_r(OUT mediaObject.albumArtString, "/Supertramp/Breakfast_In_America/Supertramp_-_Breakfast_in_America_-_03_-_Goodbye_Stranger.mp3", IN sizeof(mediaObject.albumArtString));
    strncpy_r(OUT mediaObject.fileName, "/Supertramp/Breakfast_In_America/Supertramp_-_Breakfast_in_America_-_03_-_Goodbye_Stranger.mp3", IN sizeof(mediaObject.fileName));
    strncpy_r(OUT mediaObject.MetadataField1, "Oldies", IN sizeof(mediaObject.MetadataField1));
    strncpy_r(OUT mediaObject.MetadataField2, "Supertramp", IN sizeof(mediaObject.MetadataField2));
    strncpy_r(OUT mediaObject.MetadataField3, "Supertramp", IN sizeof(mediaObject.MetadataField3));
    strncpy_r(OUT mediaObject.MetadataField4, "Breakfast in America", IN sizeof(mediaObject.MetadataField4));
    strncpy_r(OUT mediaObject.title, "Goodbye Stranger", IN sizeof(mediaObject.title));
    strncpy_r(OUT mediaObject.dateTime, "2016:07:08 17:01:00", IN sizeof(mediaObject.dateTime));
    mediaObject.deviceID = deviceID;
    mediaObject.catType = CTY_SONG;
    mediaObject.metadataConvertFlag = 0;
    mediaObject.compilationFlag = 0;
    mediaObject.totalPlaytime = 180000;
    mediaObject.trackNumber = 3;
    mediaObject.notPlayable = FNP_PLAYABLE;
    mediaObject.fileSize = 5444000LL;
    mediaObject.fileMode = 0;
    mediaObject.userID = 9;
    mediaObject.groupID = 75;

    /* store file as a tag in Livetags (normally done while selecting a file in a file list)*/
    tObjectID idFromMediaObjects = OBJECT_ID_NONE;
    res = LocalSPM::GetDBManager().GetObjectID(OUT idFromMediaObjects, IN mediaObject.deviceID, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == MP_ERR_DB_END_OF_LIST);
    CPPUNIT_ASSERT(idFromMediaObjects == OBJECT_ID_NONE);

    res = LocalSPM::GetDBManager().StoreLiveTagsElement(IN mediaObject.fileName, IN mediaObject.catType, IN mediaObject.deviceID, IN mediaObject.notPlayable);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetLiveTagsElement(OUT mediaObject.objectID, IN mediaObject.catType, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObject.objectID != OBJECT_ID_NONE);

    /*fill up new tags via Livetags*/
    mediaObject.notPlayable = FNP_NOT_PLAYABLE;
    res = LocalSPM::GetDBManager().FillupMetaDataIDs(INOUT mediaObject);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag1 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag2 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag3 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag4 != 0);

    /*insert media object into MediaObjects table and check if it gets the same ID as LiveTags element ID*/
    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);
    /*-----------------------------------------------------------------------------------------------------*/
    res = LocalSPM::GetDBManager().GetObjectID(OUT idFromMediaObjects, IN mediaObject.deviceID, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == 0);

    /*Validate if MediaObjects gets the same ID as from the LiveTags element ID for a given URL in a device*/
    CPPUNIT_ASSERT(idFromMediaObjects == mediaObject.objectID);


    /*other way : insert a file element into livetag which is already part of Mediaobjects table, then it should get the same ID from MediaObjects's element*/
    /* store known file from Mediaobject table into Livetags*/
    mediaObject.deviceID = deviceID;
    strncpy_r(OUT mediaObject.fileName, "/music/Garbage/Garbage-Garbage-09-Dog_New_Tricks.mp3", IN sizeof(mediaObject.fileName));

    /* get media object*/
    idFromMediaObjects = OBJECT_ID_NONE;
    res = LocalSPM::GetDBManager().GetObjectID(OUT idFromMediaObjects, IN mediaObject.deviceID, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(idFromMediaObjects != OBJECT_ID_NONE);

    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, INOUT idFromMediaObjects);
    CPPUNIT_ASSERT(res == 0);

    /*fill up new tags via Livetags*/
    res = LocalSPM::GetDBManager().FillupMetaDataIDs(INOUT mediaObject);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag1 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag2 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag3 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag4 != 0);

    /*since file was already present in the mediaobject table , LiveTags element should receive the ID from the MediaObjects table*/
    CPPUNIT_ASSERT(idFromMediaObjects == mediaObject.objectID);
}

void DBManagerTest::LiveTags()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* create only the test devices */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, false);
    CPPUNIT_ASSERT(res == 0);

    /* get the main USB test device */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* generate a file list and browse one title */
    tListID listID = LIST_ID_NONE;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    char *path = (char *)"/";
    tListType listType = LTY_FILELIST;

    /* create a file list from root directory */
    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID, INOUT listType, IN path, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listType == LTY_FILELIST);

    /* get the counts */
    res = LocalSPM::GetDBManager().GetFileListSize(OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists, OUT numberOfFolders, IN listID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfMediaObjects == 3);
    CPPUNIT_ASSERT(numberOfFolders == 4);
    CPPUNIT_ASSERT(numberOfPlayLists == 0);

    /* request an object from this list (to trigger live tags fill up with CTY_SONG entry) */
    vector<tFiles> mediaFileVector; /* resulting entries */

    /* get the list slice */
    res= LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaFileVector.size() == 1);

    /* Allocate Audio */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));
    res = LocalSPM::GetPlayerManager().SendAllocate(IN audioOutputDevice);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN SA_ON);
    CPPUNIT_ASSERT(res == 0);

    /* play first item from created list */
    res = LocalSPM::GetCustomControl().PlayItemFromList(OUT listSize, IN listID, 0, 0);
    CPPUNIT_ASSERT(res == 0);

    /* wait a little */
    sleep(5);

    /* the currently played object (with live filled tag id's) */
    tMediaObject mediaObject;
    res = LocalSPM::GetPlayerManager().GetMediaObject(OUT mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN SA_OFF);
    CPPUNIT_ASSERT(res == 0);

    /* De Allocate Audio */
    res = LocalSPM::GetPlayerManager().SendDeAllocate();
    CPPUNIT_ASSERT(res == 0);

    /* now the live tags table should have entries for the first object in the list */
    CPPUNIT_ASSERT(mediaObject.MetadataTag1 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag2 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag3 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag4 != 0);

    tCategoryType objectType;
    res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, IN mediaObject.MetadataTag1);
    CPPUNIT_ASSERT(objectType == CTY_GENRE);
    res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, IN mediaObject.MetadataTag2);
    CPPUNIT_ASSERT(objectType == CTY_ARTIST);
    res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, IN mediaObject.MetadataTag3);
    CPPUNIT_ASSERT(objectType == CTY_COMPOSER);
    res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, IN mediaObject.MetadataTag4);
    CPPUNIT_ASSERT(objectType == CTY_ALBUM);
}

void DBManagerTest::HandleMP3WithHughTags()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* add a special test device */
    tDeviceInfo deviceInfo;
    InitDeviceInfo(OUT deviceInfo);
    strncpy_r(OUT deviceInfo.UUID, "643722572i4698as", IN sizeof(deviceInfo.UUID));
    strncpy_r(OUT deviceInfo.serialNumber, "0987654300", IN sizeof(deviceInfo.serialNumber));
    strncpy_r(OUT deviceInfo.deviceVersion, "ver 1.1", IN sizeof(deviceInfo.deviceVersion));
    strncpy_r(OUT deviceInfo.deviceName, "USB-Prob", IN sizeof(deviceInfo.deviceName));
    deviceInfo.deviceType = DTY_USB;
    deviceInfo.connectionState = CS_CONNECTED;
#ifndef TARGET_BUILD
    strncpy_r(OUT deviceInfo.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfo.mountPoint));
    strncat_r(OUT deviceInfo.mountPoint, "/Customer/Simulation/CustomControl/problematicFiles", IN sizeof(deviceInfo.mountPoint));
#else
    strncpy_r(OUT deviceInfo.mountPoint, "/opt/bosch/test/data/GMP/problematicFiles", IN sizeof(deviceInfo.mountPoint));
#endif
    strncpy_r(OUT deviceInfo.accessoryName, "/dev/sdc", IN sizeof(deviceInfo.accessoryName));
    deviceInfo.fileSystemType = FSTY_FAT;
    deviceInfo.partitionNumber = 1;
    deviceInfo.totalSize = 167772160; //160GB
    deviceInfo.freeSize = 62914560; //60GB
    deviceInfo.productID = 5432;
    deviceInfo.connectionType = DCT_USB;

    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);

    tDeviceID deviceID = deviceInfo.deviceID;

    /* add problematic files to the DB */
    res = LocalSPM::GetDBManager().ScanDirForTest(IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* generate an all songs list */
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize == 2);

    /* request an object from this list (to trigger live tags fill up with CTY_SONG entry) */
    vector<tMediaObject> mediaObjectsVector; /* resulting entries */

    /* get the list slice */
    res= LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectsVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectsVector.size() == 1);

    /* Allocate Audio */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));
    res = LocalSPM::GetPlayerManager().SendAllocate(IN audioOutputDevice);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN SA_ON);
    CPPUNIT_ASSERT(res == 0);

    /* play first item from created list */
    res = LocalSPM::GetCustomControl().PlayItemFromList(OUT listSize, IN listID, 0, 0);
    CPPUNIT_ASSERT(res == 0);

    /* wait a little */
    sleep(5);

    /* the the currently played object (with live filled tag id's) */
    tMediaObject mediaObject;
    res = LocalSPM::GetPlayerManager().GetMediaObject(OUT mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN SA_OFF);
    CPPUNIT_ASSERT(res == 0);

    /* De Allocate Audio */
    res = LocalSPM::GetPlayerManager().SendDeAllocate();
    CPPUNIT_ASSERT(res == 0);

    /* now the live tags table should have entries for the first object in the list */
    CPPUNIT_ASSERT(mediaObject.MetadataTag1 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag2 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag3 != 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag4 != 0);

    tCategoryType objectType;
    res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, IN mediaObject.MetadataTag1);
    CPPUNIT_ASSERT(objectType == CTY_GENRE);
    res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, IN mediaObject.MetadataTag2);
    CPPUNIT_ASSERT(objectType == CTY_ARTIST);
    res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, IN mediaObject.MetadataTag3);
    CPPUNIT_ASSERT(objectType == CTY_COMPOSER);
    res = LocalSPM::GetDBManager().GetObjectType(OUT objectType, IN mediaObject.MetadataTag4);
    CPPUNIT_ASSERT(objectType == CTY_ALBUM);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::InsertVideoObject()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    res = LocalSPM::GetDBManager().GetDevice(OUT mediaObject.deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* store a video */
    mediaObject.catType = CTY_VIDEO;
    strncpy_r(OUT mediaObject.fileName, "/video/Garfield_Pizza.mp4", IN sizeof(mediaObject.fileName));
    strncpy_r(OUT mediaObject.title, "I like Pizza", IN sizeof(mediaObject.title)); //episode title
    strncpy_r(OUT mediaObject.MetadataField1, "Garfield", IN sizeof(mediaObject.MetadataField1)); //video
    strncpy_r(OUT mediaObject.MetadataField2, "510x300", IN sizeof(mediaObject.MetadataField2)); //resolution
    strncpy_r(OUT mediaObject.MetadataField3, "", IN sizeof(mediaObject.MetadataField3));
    strncpy_r(OUT mediaObject.MetadataField4, "", IN sizeof(mediaObject.MetadataField4));
    mediaObject.metadataConvertFlag = 0;
    mediaObject.compilationFlag = 0;
    mediaObject.totalPlaytime = 1500000;
    strncpy_r(OUT mediaObject.albumArtString, "", IN sizeof(mediaObject.albumArtString));
    mediaObject.trackNumber = 1;
    strncpy_r(OUT mediaObject.path, "/video/", IN sizeof(mediaObject.path));
    mediaObject.notPlayable = FNP_PLAYABLE;
    mediaObject.fileSize = 314158000LL;
    strncpy_r(OUT mediaObject.dateTime, "2012:05:15 14:56:00", IN sizeof(mediaObject.dateTime));
    mediaObject.fileMode = 0;
    mediaObject.userID = 0;
    mediaObject.groupID = 0;

    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    /* get the media object to compare */
    tMediaObject newMediaObject;
    InitMediaObject(OUT newMediaObject);
    res = LocalSPM::GetDBManager().GetObjectID(OUT newMediaObject.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetMediaObject(OUT newMediaObject, INOUT newMediaObject.objectID);
    CPPUNIT_ASSERT(res == 0);
    VARTRACE(newMediaObject);
    CPPUNIT_ASSERT(mediaObject.deviceID == newMediaObject.deviceID);
    CPPUNIT_ASSERT(mediaObject.catType == newMediaObject.catType);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, newMediaObject.fileName) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.title, newMediaObject.title) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField1, newMediaObject.MetadataField1) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField2, newMediaObject.MetadataField2) == 0);
    CPPUNIT_ASSERT(strcmp(newMediaObject.MetadataField3, LocalSPM::GetDataProvider().DBUnknownText().c_str()) == 0);
    CPPUNIT_ASSERT(strcmp(newMediaObject.MetadataField4, LocalSPM::GetDataProvider().DBUnknownText().c_str()) == 0);
    CPPUNIT_ASSERT(mediaObject.metadataConvertFlag == newMediaObject.metadataConvertFlag);
    CPPUNIT_ASSERT(mediaObject.compilationFlag == newMediaObject.compilationFlag);
    CPPUNIT_ASSERT(mediaObject.totalPlaytime == newMediaObject.totalPlaytime);
    CPPUNIT_ASSERT(strstr(newMediaObject.albumArtString, mediaObject.albumArtString)); //DBManager add mount point to album art string
    CPPUNIT_ASSERT(mediaObject.trackNumber == newMediaObject.trackNumber);
    CPPUNIT_ASSERT(strcmp(mediaObject.path, newMediaObject.path) == 0);
    CPPUNIT_ASSERT(mediaObject.notPlayable == newMediaObject.notPlayable);
    CPPUNIT_ASSERT(mediaObject.fileSize == newMediaObject.fileSize);
    CPPUNIT_ASSERT(strcmp(mediaObject.dateTime, newMediaObject.dateTime) == 0);
    CPPUNIT_ASSERT(mediaObject.fileMode == newMediaObject.fileMode);
    CPPUNIT_ASSERT(mediaObject.userID == newMediaObject.userID);
    CPPUNIT_ASSERT(mediaObject.groupID == newMediaObject.groupID);
}

void DBManagerTest::InsertImageObject()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    res = LocalSPM::GetDBManager().GetDevice(OUT mediaObject.deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    /* store a video */
    mediaObject.catType = CTY_IMAGE;
    strncpy_r(OUT mediaObject.fileName, "/image/Landscape_23.jpg", IN sizeof(mediaObject.fileName));
    strncpy_r(OUT mediaObject.title, "Tyrolean Alps", IN sizeof(mediaObject.title)); //image title
#if 0
    strncpy_r(OUT mediaObject.MetadataField1, "5432543", IN sizeof(mediaObject.MetadataField1)); //size
    strncpy_r(OUT mediaObject.MetadataField2, "2009:02:08 10:40:27", IN sizeof(mediaObject.MetadataField2)); //date time
    strncpy_r(OUT mediaObject.MetadataField3, "4256x2832", IN sizeof(mediaObject.MetadataField3)); //resolution
    strncpy_r(OUT mediaObject.MetadataField4, "72x72", IN sizeof(mediaObject.MetadataField4)); //density
#else
    strncpy_r(OUT mediaObject.MetadataField1, "72x72", IN sizeof(mediaObject.MetadataField1)); //density
    strncpy_r(OUT mediaObject.MetadataField2, "4256x2832", IN sizeof(mediaObject.MetadataField2)); //resolution
    strncpy_r(OUT mediaObject.MetadataField3, "", IN sizeof(mediaObject.MetadataField3));
    strncpy_r(OUT mediaObject.MetadataField4, "", IN sizeof(mediaObject.MetadataField4));
#endif
    mediaObject.metadataConvertFlag = 0;
    mediaObject.compilationFlag = 0;
    mediaObject.totalPlaytime = 0;
    strncpy_r(OUT mediaObject.albumArtString, "", IN sizeof(mediaObject.albumArtString));
    mediaObject.trackNumber = 0;
    strncpy_r(OUT mediaObject.path, "/image/", IN sizeof(mediaObject.path));
    mediaObject.notPlayable = FNP_NOT_PLAYABLE;
    mediaObject.fileSize = 5432543LL;
    strncpy_r(OUT mediaObject.dateTime, "2009:02:08 10:40:27", IN sizeof(mediaObject.dateTime));
    mediaObject.fileMode = 0;
    mediaObject.userID = 0;
    mediaObject.groupID = 0;

    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    /* get the media object to compare */
    tMediaObject newMediaObject;
    InitMediaObject(OUT newMediaObject);
    res = LocalSPM::GetDBManager().GetObjectID(OUT newMediaObject.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetMediaObject(OUT newMediaObject, INOUT newMediaObject.objectID);
    CPPUNIT_ASSERT(res == 0);
    VARTRACE(newMediaObject);
    CPPUNIT_ASSERT(mediaObject.deviceID == newMediaObject.deviceID);
    CPPUNIT_ASSERT(mediaObject.catType == newMediaObject.catType);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, newMediaObject.fileName) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.title, newMediaObject.title) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField1, newMediaObject.MetadataField1) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField2, newMediaObject.MetadataField2) == 0);
#if 0
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField3, newMediaObject.MetadataField3) == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField4, newMediaObject.MetadataField4) == 0);
#else
    CPPUNIT_ASSERT(strcmp(newMediaObject.MetadataField3, LocalSPM::GetDataProvider().DBUnknownText().c_str()) == 0);
    CPPUNIT_ASSERT(strcmp(newMediaObject.MetadataField4, LocalSPM::GetDataProvider().DBUnknownText().c_str()) == 0);
#endif
    CPPUNIT_ASSERT(mediaObject.metadataConvertFlag == newMediaObject.metadataConvertFlag);
    CPPUNIT_ASSERT(mediaObject.compilationFlag == newMediaObject.compilationFlag);
    CPPUNIT_ASSERT(mediaObject.totalPlaytime == newMediaObject.totalPlaytime);
    CPPUNIT_ASSERT(strstr(newMediaObject.albumArtString, mediaObject.albumArtString)); //DBManager add mount point to album art string
    CPPUNIT_ASSERT(mediaObject.trackNumber == newMediaObject.trackNumber);
    CPPUNIT_ASSERT(strcmp(mediaObject.path, newMediaObject.path) == 0);
    CPPUNIT_ASSERT(mediaObject.notPlayable == newMediaObject.notPlayable);
    CPPUNIT_ASSERT(mediaObject.fileSize == newMediaObject.fileSize);
    CPPUNIT_ASSERT(strcmp(mediaObject.dateTime, newMediaObject.dateTime) == 0);
    CPPUNIT_ASSERT(mediaObject.fileMode == newMediaObject.fileMode);
    CPPUNIT_ASSERT(mediaObject.userID == newMediaObject.userID);
    CPPUNIT_ASSERT(mediaObject.groupID == newMediaObject.groupID);
}

void DBManagerTest::GetLastModeDevices()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Get device ID for first USB */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    tListID listID;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* Create a list for that device */
    res = LocalSPM::GetDBManager().CreateList(OUT listID,
            IN deviceID,
            IN LTY_SONG,
            IN PC_NO_REPEAT,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4);
    CPPUNIT_ASSERT(res == 0);

    /* Store the last mode */
    tPosition position = 0;
    tPlaytime playtime = 300000;
    tMediaObject mediaObject;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN (tIndex)position);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().StoreLastPlayed(IN listID, IN mediaObject.objectID, IN position, IN playtime);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    //test LTY_LASTMODE for MY_MEDIA
    tListID lastMyMeModeListID;
    tObjectID lastMyMeModeObjectID;
    tPlaytime lastMyMeModePlaytime;
    res = LocalSPM::GetDBManager().GetLastPlayed(OUT lastMyMeModeListID, OUT lastMyMeModeObjectID, OUT lastMyMeModePlaytime, IN MY_MEDIA);
    CPPUNIT_ASSERT(res == MP_ERR_DB_END_OF_LIST);

    /* Get device with active flag = true */
    tDeviceID lastModeDeviceID;
    res = LocalSPM::GetDBManager().GetLastActiveDevice(OUT lastModeDeviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(lastModeDeviceID == deviceID);

    /* Get all last mode devices */
    tNumberOfDevices numberOfDevices;
    vector<tDeviceID> deviceIDs;
    res = LocalSPM::GetDBManager().GetLastModeDevices(OUT numberOfDevices, OUT deviceIDs);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(numberOfDevices > 0);
    CPPUNIT_ASSERT(numberOfDevices == deviceIDs.size());

    tUInt i;
    for(i=0; i<deviceIDs.size(); i++)
    {
        if(deviceIDs[i] == deviceID) break;
    }
    CPPUNIT_ASSERT(i < deviceIDs.size()); //device should be found

    /* Get the last mode for a specific device */
    tListID lastModeListID;
    tObjectID lastModeObjectID;
    tPlaytime lastModePlaytime;
    res = LocalSPM::GetDBManager().GetLastPlayed(OUT lastModeListID, OUT lastModeObjectID, OUT lastModePlaytime, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(lastModeObjectID == mediaObject.objectID);
    CPPUNIT_ASSERT(lastModePlaytime == playtime);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN lastModeListID);
    CPPUNIT_ASSERT(res == 0);

    /* Clear last mode for this device */
    res = LocalSPM::GetDBManager().RemoveLastPlayed(IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* Get device with active flag = true */
    res = LocalSPM::GetDBManager().GetLastActiveDevice(OUT lastModeDeviceID);
    CPPUNIT_ASSERT(res == MP_ERR_DB_END_OF_LIST);

    /* Get all last mode devices */
    res = LocalSPM::GetDBManager().GetLastModeDevices(OUT numberOfDevices, OUT deviceIDs);
    CPPUNIT_ASSERT(res == 0);

    for(i=0; i<deviceIDs.size(); i++)
    {
        if(deviceIDs[i] == deviceID) break;
    }
    CPPUNIT_ASSERT(i == deviceIDs.size()); //device should not be found

    /* Get the last mode for a specific device */
    res = LocalSPM::GetDBManager().GetLastPlayed(OUT lastModeListID, OUT lastModeObjectID, OUT lastModePlaytime, IN deviceID);
    CPPUNIT_ASSERT(res == MP_ERR_DB_END_OF_LIST);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::ClearLastMode()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tListID listID;

    /* Enable ClearLastMode configuration */
    int clearLastMode = LocalSPM::GetDataProvider().ClearLastMode();
    if (0 == clearLastMode)
    {
        LocalSPM::GetDataProvider().ClearLastMode = 1;
    }

    /* Set FileErrorHandling configuration to FEH_MARK_OBJECT */
    int fileErrorHandling = LocalSPM::GetDataProvider().FileErrorHandling();
    if (FEH_MARK_OBJECT != (tFileErrorHandling)fileErrorHandling)
    {
        LocalSPM::GetDataProvider().FileErrorHandling = (int)FEH_MARK_OBJECT;
    }

    /* Get device ID for first USB */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* Create a list for that device */
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* Get the first media object from that list */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    /* Shift device related settings to non default values */
    res = LocalSPM::GetDBManager().SetPlaybackMode(IN deviceID, IN PBM_RANDOM);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().SetRepeatMode(IN deviceID, IN RPT_ONE);
    CPPUNIT_ASSERT(res == 0);

    /* Set notPlayable flag for first media object of the list */
    mediaObjectVector[0].notPlayable = FNP_NOT_PLAYABLE;
    res = LocalSPM::GetDBManager().UpdateMediaObject(IN mediaObjectVector[0]);
    CPPUNIT_ASSERT(res == 0);

    /* Store the last mode */
    tPlaytime playtime = 76543;
    res = LocalSPM::GetListControl().StoreLastPlayedList(IN listID, IN playtime);
    CPPUNIT_ASSERT(res == 0);


    /* Clear last mode for this device */
    res = LocalSPM::GetDBManager().ClearLastMode(IN deviceID);
    CPPUNIT_ASSERT(res == 0);


    /* Check test results */
    tPlaybackMode playbackMode;
    res = LocalSPM::GetDBManager().GetPlaybackMode(OUT playbackMode, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(PBM_NORMAL == playbackMode);

    tRepeatMode repeatMode;
    res = LocalSPM::GetDBManager().GetRepeatMode(OUT repeatMode, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(RPT_LIST == repeatMode);

    /* Check notPlayable flag of media object */
    tMediaObject mediaObject;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN mediaObjectVector[0].objectID, IN mediaObjectVector[0].catType, IN mediaObjectVector[0].deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(FNP_PLAYABLE == mediaObject.notPlayable);

    /* Get the last mode info */
    tListID lastModeListID;
    tIndex listIndex;
    res = LocalSPM::GetListControl().GetLastPlayedList(OUT lastModeListID, OUT listIndex, OUT playtime, IN deviceID);
    CPPUNIT_ASSERT(res == MP_ERR_DB_END_OF_LIST);

    /* Reset configuration */
    LocalSPM::GetDataProvider().ClearLastMode = clearLastMode;
    LocalSPM::GetDataProvider().FileErrorHandling = fileErrorHandling;

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::GetLastPlaytime()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tListID listID;

    /* Get device ID for first USB */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* Create a list for that device */
    res = LocalSPM::GetDBManager().CreateList(OUT listID,
            IN deviceID,
            IN LTY_SONG,
            IN PC_NO_REPEAT,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4);
    CPPUNIT_ASSERT(res == 0);

    /* Store the last playtime position */
    tPosition position = 0;
    tPlaytime playtime = 23000;
    tMediaObject mediaObject;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN (tIndex)position);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(OBJECT_ID_NONE != mediaObject.objectID);

    res = LocalSPM::GetDBManager().StoreLastPlaytime(IN mediaObject.objectID, IN playtime);
    CPPUNIT_ASSERT(res == 0);

    /* Get the last playtime position for a specific object */
    tPlaytime lastPlaytime;
    res = LocalSPM::GetDBManager().GetLastPlaytime(OUT lastPlaytime, IN mediaObject.objectID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(lastPlaytime == playtime);

    /* Remove the last playtime position for a specific object */
    res = LocalSPM::GetDBManager().RemoveLastPlaytime(IN mediaObject.objectID);
    CPPUNIT_ASSERT(res == 0);

    /* Get the last playtime position for the removed object */
    res = LocalSPM::GetDBManager().GetLastPlaytime(OUT lastPlaytime, IN mediaObject.objectID);
    CPPUNIT_ASSERT(res == MP_ERR_DB_END_OF_LIST);
}

void DBManagerTest::StoreAlbumArt()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID = 3;
    tAlbumID albumID = 12357;
    tAlbumArt coverArtPath;
    tTitle title = "Aaoromale";
    tDateTime lastModifiedTime = "2017:05:17 17:38:06";
    strncpy_r(OUT coverArtPath, IN "/var/opt/bosch/dynamic/media/coverart/dev03/ABBA_280_280.png", IN sizeof(coverArtPath));

    const tU8 image[] = {0xaf, 0xfe, 0x0, 0x12, 0x34, 0x56, 0x78};
    tImageBlob thumbnailBlob;
    thumbnailBlob.imageSize = sizeof(image);
    thumbnailBlob.imageData = (tImageData)malloc(thumbnailBlob.imageSize);
    memcpy(thumbnailBlob.imageData, image, thumbnailBlob.imageSize);
    for(tUInt i=0; i<thumbnailBlob.imageSize; i++)
    {
        ETG_TRACE_USR1(("image: %2x, thumbnailBlob.imageData: %2x",image[i], thumbnailBlob.imageData[i]));
    }

    /* store cover art path and thumbnail blob */
    res = LocalSPM::GetDBManager().StoreAlbumArt(IN deviceID, IN albumID, IN title, IN coverArtPath, IN thumbnailBlob, IN lastModifiedTime);
    CPPUNIT_ASSERT(res == 0);

    if (thumbnailBlob.imageData) free(thumbnailBlob.imageData);

    /* check cover art path */
    tAlbumArt newCoverArtPath;
    res = LocalSPM::GetDBManager().GetCoverArtPath(OUT newCoverArtPath, IN deviceID, IN albumID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(!strcmp(coverArtPath, newCoverArtPath));

    /* check thumbnail blob */
    tImageBlob newThumbnailBlob;
    res = LocalSPM::GetDBManager().GetThumbnailImage(OUT newThumbnailBlob, IN deviceID, IN albumID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(newThumbnailBlob.imageSize == sizeof(image));
    for(tUInt i=0; i<newThumbnailBlob.imageSize; i++)
    {
        ETG_TRACE_USR1(("image: %2x, newThumbnailBlob.imageData: %2x",image[i], newThumbnailBlob.imageData[i]));
    }
    CPPUNIT_ASSERT(!memcmp(image, newThumbnailBlob.imageData, newThumbnailBlob.imageSize));

    if (newThumbnailBlob.imageData) free(newThumbnailBlob.imageData);

    /* deletes all entries for the device and check if they are really removed */
    res = LocalSPM::GetDBManager().RemoveAlbumArts(IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetCoverArtPath(OUT newCoverArtPath, IN deviceID, IN albumID);
    CPPUNIT_ASSERT(res == MP_ERR_DB_END_OF_LIST);
    res = LocalSPM::GetDBManager().GetThumbnailImage(OUT newThumbnailBlob, IN deviceID, IN albumID);
    CPPUNIT_ASSERT(res == MP_ERR_DB_END_OF_LIST);

    /* store empty cover art entry */
    thumbnailBlob.imageSize = 0;
    thumbnailBlob.imageData = NULL;
    res = LocalSPM::GetDBManager().StoreAlbumArt(IN deviceID, IN albumID,IN title, IN "", IN thumbnailBlob,IN lastModifiedTime);
    CPPUNIT_ASSERT(res == 0);

    /* check cover art path */
    res = LocalSPM::GetDBManager().GetCoverArtPath(OUT newCoverArtPath, IN deviceID, IN albumID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(strlen_r(newCoverArtPath) == 0);

    /* check thumbnail blob */
    res = LocalSPM::GetDBManager().GetThumbnailImage(OUT newThumbnailBlob, IN deviceID, IN albumID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(newThumbnailBlob.imageSize == 0);

    /* deletes all entries for the device again */
    res = LocalSPM::GetDBManager().RemoveAlbumArts(IN deviceID);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::RemoveMediaObject()
{
    ENTRY
    ETG_TRACE_USR1(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    vector<tMediaObject> mediaObjectVector;
    tMediaObjectID removedObjectID;

    /* create a song list */
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize > 0);

    /* get the last object */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            IN listSize - 1,
            1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    /* remember it */
    removedObjectID = mediaObjectVector[0].objectID;

    /* remove this */
    res = LocalSPM::GetDBManager().RemoveMediaObject(IN removedObjectID);
    CPPUNIT_ASSERT(res == 0);

    /* get the list information */
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listInfo.listSize > 0);

    /* get the last of list again */
    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            IN listInfo.listSize - 1,
            1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    /* check against removed */
    CPPUNIT_ASSERT(removedObjectID != mediaObjectVector[0].objectID);
}

void DBManagerTest::RemoveMediaObjectByUUID()
{
    ENTRY
    ETG_TRACE_USR1(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    vector<tMediaObject> mediaObjectVector;
    tMediaObjectID removedObjectID;

    /* create a song list */
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize > 0);

    /* get the last object */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            IN listSize - 1,
            1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    /* remember it */
    removedObjectID = mediaObjectVector[0].objectID;

    /* remove this */
    res = LocalSPM::GetDBManager().RemoveMediaObjectByUUID(IN mediaObjectVector[0].deviceID, IN mediaObjectVector[0].UUID);
    CPPUNIT_ASSERT(res == 0);

    /* get the list information */
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listInfo.listSize > 0);

    /* get the last of list again */
    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            IN listInfo.listSize - 1,
            1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    /* check against removed */
    CPPUNIT_ASSERT(removedObjectID != mediaObjectVector[0].objectID);
}

void DBManagerTest::StoreBTMACAddress()
{
    ENTRY
    ETG_TRACE_USR1(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    tBTMACAddress lastBTMACAddress;
    tBTMACAddress currentBTMACAddress;
    tBTMACAddress newBTMACAddress = "38C096CCEEAE";

    /* get last BT MAC address of DataProvider */
    strncpy_r(OUT lastBTMACAddress, IN LocalSPM::GetDataProvider().iPodControlBTMACAddress().c_str(), IN sizeof(lastBTMACAddress));

    /* store new BT MAC address */
    res = LocalSPM::GetDBManager().StoreBTMACAddress(IN newBTMACAddress);
    CPPUNIT_ASSERT(res == 0);

    /* get current BT MAC address via DB */
    res = LocalSPM::GetDBManager().GetBTMACAddress(OUT currentBTMACAddress);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(0 < strlen_r(currentBTMACAddress));
    CPPUNIT_ASSERT(strcmp(currentBTMACAddress, newBTMACAddress) == 0);

    /* get current BT MAC address via DataProvider */
    strncpy_r(OUT currentBTMACAddress, IN LocalSPM::GetDataProvider().iPodControlBTMACAddress().c_str(), IN sizeof(currentBTMACAddress));
    CPPUNIT_ASSERT(0 < strlen_r(currentBTMACAddress));
    CPPUNIT_ASSERT(strcmp(currentBTMACAddress, newBTMACAddress) == 0);

    /* restore last BT MAC address */
    res = LocalSPM::GetDBManager().StoreBTMACAddress(IN lastBTMACAddress);
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::GetMetatdataIDs()
{
    ENTRY_TEST

    tResult res;
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    /*
     * test for a specific device
     */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    mediaObject.deviceID = deviceID;
    strncpy_r(OUT mediaObject.UUID, "", IN sizeof(mediaObject.UUID));

    /* get the object IDs*/
    res = LocalSPM::GetDBManager().GetMetatdataIDs(INOUT mediaObject);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObject.MetadataTag1 > 0);
}

void DBManagerTest::GetObjectUUID()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tIndex index;
    tMediaObject mediaObject;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test for a specific device
     */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    listType = LTY_SONG;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media object */
    index = 15;
    res = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObject, IN listID, IN index);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().ReleaseAccess(IN listID);
    CPPUNIT_ASSERT(res == 0);

    tDeviceID checkDeviceID;
    tUUID checkUUID;

    res = LocalSPM::GetDBManager().GetObjectUUID(checkDeviceID, checkUUID, mediaObject.objectID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(checkDeviceID == deviceID);
    CPPUNIT_ASSERT(!strcmp(checkUUID, mediaObject.UUID));
}

typedef struct {
    int stage;
    int goOn;
} tConcurrentDBRead;

void DBManagerTest::ConcurrentDBRead()
{
    ENTRY

    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tConcurrentDBRead dbReadThread1, dbReadThread2;
    memset(&dbReadThread1, 0, sizeof(tConcurrentDBRead));
    memset(&dbReadThread2, 0, sizeof(tConcurrentDBRead));

    /* starts 1st thread which opens a query */
    LocalSPM::GetThreadFactory().Do(this, 1, (void *)&dbReadThread1);

    /* wait for end of Get call */
    while(dbReadThread1.stage != 2) sleep(1);

    /* starts the 2nd thread which does the same */
    LocalSPM::GetThreadFactory().Do(this, 1, (void *)&dbReadThread2);

    /* see if the second thread comes to stage 2, this means that two threads have read the database in parallel */
    int concurrentSuccess = 0;
    int nonConcurrentSuccess = 0;
    int retry = 20;
    while(dbReadThread2.stage != 2) {
        sleep(1);
        retry--;
        if (!retry) break;
    }
    if (!retry) {
        concurrentSuccess = 0;
    } else {
        concurrentSuccess = 1;
    }

    /* let the first thread continue */
    dbReadThread1.goOn = 1;

    /* wait until the first thread has finished */
    while(dbReadThread1.stage != 3) sleep(1);

    /* check the 2nd thread if not successfull before */
    if (!concurrentSuccess) {
        int retry = 20;
        while(dbReadThread2.stage != 2) {
            sleep(1);
            retry--;
            if (!retry) break;
        }
        if (retry) {
            nonConcurrentSuccess = 1;
        }
    }

    /* let the 2nd thread run to its end */
    dbReadThread2.goOn = 1;

    /* wait until the 2nd thread has finished */
    while(dbReadThread2.stage != 3) sleep(1);

    /* evaluate the result */
    ETG_TRACE_USR1(("concurrentSuccess=%d",concurrentSuccess));
    ETG_TRACE_USR1(("nonConcurrentSuccess=%d",nonConcurrentSuccess));
    CPPUNIT_ASSERT(concurrentSuccess == 1);
}

void DBManagerTest::Do(int functionID, void *ptr)
{
    tResult res;
    tDeviceInfo deviceInfo;
    tDeviceID deviceID;
    Query query;
    tConcurrentDBRead *dbReadThread = (tConcurrentDBRead *)ptr;

    InitDeviceInfo(OUT deviceInfo);

    /* get the device id of the first USB device - just to have one */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    switch(functionID)
    {
        case 2:

            /* setup the select */
            res = query.Select(LTY_DEVICES, IN deviceID, "");
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            dbReadThread->stage = 1;

            /* do the select */
            res = query.Get("iTTTTTi--i----iii--TiiiiiiiiiTiiii",
                    OUT &deviceInfo.deviceID,
                    OUT deviceInfo.UUID, IN sizeof(deviceInfo.UUID),
                    OUT deviceInfo.serialNumber, IN sizeof(deviceInfo.serialNumber),
                    OUT deviceInfo.deviceVersion, IN sizeof(deviceInfo.deviceVersion),  //FirmwareVersion
                    OUT deviceInfo.deviceName, IN sizeof(deviceInfo.deviceName),        //FriendlyName
                    OUT deviceInfo.mountPoint, IN sizeof(deviceInfo.mountPoint),
                    OUT &deviceInfo.connectionCount,
                    OUT &deviceInfo.activeSource,
                    OUT &deviceInfo.deviceType,
                    OUT &deviceInfo.indexedState,
                    OUT &deviceInfo.connectionState,
                    OUT deviceInfo.accessoryName, IN sizeof(deviceInfo.accessoryName),
                    OUT &deviceInfo.deviceState,
                    OUT &deviceInfo.fileSystemType,
                    OUT &deviceInfo.partitionNumber,
                    OUT &deviceInfo.totalSize,
                    OUT &deviceInfo.freeSize,
                    OUT &deviceInfo.productID,
                    OUT &deviceInfo.numberOfAudioFiles,
                    OUT &deviceInfo.diPOCaps,
                    OUT &deviceInfo.diPOActive,
                    OUT deviceInfo.diPOVersion, IN sizeof(deviceInfo.diPOVersion),
                    OUT &deviceInfo.connectionType,
                    OUT &deviceInfo.disconnectReason,
                    OUT &deviceInfo.isShuffleSupported,
                    OUT &deviceInfo.isRepeatSupported);
            dbReadThread->stage = 2;

            /* check the result */
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(deviceInfo.deviceID == deviceID);
            CPPUNIT_ASSERT(deviceInfo.deviceType == DTY_USB);
            CPPUNIT_ASSERT(strcmp(deviceInfo.serialNumber, "987654321") == 0);
            CPPUNIT_ASSERT(strcmp(deviceInfo.deviceName, "USB") == 0);

            /* keep the data base connection "open" - not doing the sqlite_reset - waiting for signal to go on with test */
            while(!dbReadThread->goOn) sleep(1);

            query.End();
            dbReadThread->stage = 3;

            break;

        case 1:

            /* get the device info to get the mount point */
            res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
            CPPUNIT_ASSERT(res == 0);

            /* setup the select */
            res = query.Select(LTY_FILELIST, IN deviceID, "tt", IN deviceInfo.mountPoint, IN "/");
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            dbReadThread->stage = 1;

            /* do the select */
            int rowid = -1;
            tMountPoint mountPoint;
            mountPoint[0] = 0;
            res = query.Get("iT",
                    OUT &rowid,
                    OUT mountPoint, IN sizeof(mountPoint));
            dbReadThread->stage = 2;

            /* check the result */
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(strcmp(mountPoint, deviceInfo.mountPoint) == 0);

            /* keep the data base connection "open" - not doing the sqlite_reset - waiting for signal to go on with test */
            while(!dbReadThread->goOn) sleep(1);

            query.End();
            dbReadThread->stage = 3;

        break;
    }
}

void DBManagerTest::SelectCDDASongs()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tDeviceID deviceID;
    tResult res;
    tListType listType;
    tListID listID = LIST_ID_NONE;
    tMediaObject mediaObject;
    tIndex rowNumber;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_CDDA, IN "CDDA");
    CPPUNIT_ASSERT(res == 0);

    listType = LTY_CD;

    res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(
            INOUT listID,
            INOUT listType,
            IN "", // path
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    vector<char *> expectedTitles;
    expectedTitles.push_back((char *)   "Frontera / Trigger"    );
    expectedTitles.push_back((char *)   "Epic"  );
    expectedTitles.push_back((char *)   "The News About William"    );
    expectedTitles.push_back((char *)   "Black Heart"   );
    expectedTitles.push_back((char *)   "Minas De Cobre"    );
    expectedTitles.push_back((char *)   "Inspiration"   );
    expectedTitles.push_back((char *)   "Two Silver Trees"  );
    expectedTitles.push_back((char *)   "Para"  );
    expectedTitles.push_back((char *)   "Quattro"   );

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        /* do a compare or what? */
        ETG_TRACE_USR2(("GetMediaObject: Tag3=%d->%64s, Title=%s", mediaObject.MetadataTag2, mediaObject.MetadataField2, mediaObject.title));
        CPPUNIT_ASSERT(strcmp(mediaObject.title, expectedTitles[rowNumber]) == 0);

        // next row
        rowNumber++;
    }

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

}

void DBManagerTest::CreateList_GetMediaObjects_LTY_IMAGE_FOLDER()
{
    ENTRY_TEST
    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tMediaObject mediaObject;
    tIndex rowNumber;
    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;
    deviceID = MY_MEDIA; // list for my media
    listType = LTY_IMAGE_FOLDER;
    playContinuation = PC_NO_REPEAT;
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);
    rowNumber = 0;
    while(1) {
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;
        ETG_TRACE_USR2(("Getpath: Path=%s", mediaObject.path));
        rowNumber++;
    }
    tListSize listSize;
    res = LocalSPM::GetDBManager().GetListSize(OUT listSize,IN listID);
    ETG_TRACE_USR2(("GetlistSize: listSize=%d", listSize));
        CPPUNIT_ASSERT(res == 0);
        CPPUNIT_ASSERT(listSize == 2);
    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateList_GetMediaObjects_LTY_IMAGE_FOLDER_ITEM()
{
    ENTRY_TEST
    tResult res = MP_NO_ERROR;
        tListID listID;
        tDeviceID deviceID;
        tListType listType;
        tPlayContinuation playContinuation;
        tFilterTag1 filterTag1;
        tFilterTag2 filterTag2;
        tFilterTag3 filterTag3;
        tFilterTag4 filterTag4;
        tMediaObject mediaObject;
        tIndex rowNumber;
        filterTag1.tag = 0;
        filterTag2.tag = 0;
        filterTag3.tag = 0;
        filterTag4.tag = 0;
            deviceID = MY_MEDIA; // list for my media
            listType = LTY_IMAGE_FOLDER;
            playContinuation = PC_NO_REPEAT;
            ETG_TRACE_USR2(("deviceID: deviceID=%d",deviceID));
          res = LocalSPM::GetDBManager().CreateList(
                  OUT listID,
                  IN deviceID,
                  IN listType,
                  IN playContinuation,
                  IN filterTag1,
                  IN filterTag2,
                  IN filterTag3,
                  IN filterTag4);
          CPPUNIT_ASSERT(res == 0);
          rowNumber = 0;
          res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
          listType = LTY_IMAGE_FOLDER_ITEM;
        tListID listID1=0;
        res = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT listID1, INOUT listType, IN mediaObject.path, IN mediaObject.deviceID);
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR2(("Gettitle: listType=%d", listType));
        CPPUNIT_ASSERT(listType == LTY_IMAGE_FOLDER_ITEM);
          rowNumber = 0;
          while(1) {
              res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID1, IN rowNumber);
              if (res != 0) break;
              ETG_TRACE_USR2(("Gettitle: Title=%s", mediaObject.title));
              ETG_TRACE_USR2(("Getpath: Path=%s", mediaObject.path));
              ETG_TRACE_USR2(("Getfilename: fileName=%s", mediaObject.fileName));
              rowNumber++;
          }
          tListSize listSize;
               res = LocalSPM::GetDBManager().GetListSize(OUT listSize,IN listID1);
               ETG_TRACE_USR2(("GetListSize: listSize=%d", listSize));
               CPPUNIT_ASSERT(res == 0);
               CPPUNIT_ASSERT(listSize == 8);
        res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
        CPPUNIT_ASSERT(res == 0);
        res = LocalSPM::GetDBManager().ReleaseDBList(IN listID1);
               CPPUNIT_ASSERT(res == 0);
        res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
        CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::GetNumberofImagesByPath()
{
    ENTRY_TEST
    tResult res = MP_NO_ERROR;
    tListID listID = 0;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;
    deviceID = MY_MEDIA; // list for my media
    listType = LTY_IMAGE_FOLDER;
    playContinuation = PC_NO_REPEAT;

    res = LocalSPM::GetDBManager().CreateList(
        OUT listID,
        IN deviceID,
        IN listType,
        IN playContinuation,
        IN filterTag1,
        IN filterTag2,
        IN filterTag3,
        IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    tMediaObject mediaObject;
    tIndex rowNumber = 0;
    while (1) {
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0)
            break;
        ETG_TRACE_USR2(("Getpath: Path=%s", mediaObject.path));
        tNumberOfMediaObjects numberOfImages = 0;
        LocalSPM::GetDBManager().GetNumberofImagesByPath(OUT numberOfImages, IN mediaObject.deviceID,
                IN mediaObject.path);
        CPPUNIT_ASSERT(res == 0);
        ETG_TRACE_USR2(("GetnumberOfImages: numberOfImages=%d", numberOfImages));
        rowNumber++;
    }

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateMediaObjectwithCompilationFlagSet()
{
    ENTRY_TEST

    /* get the device information*/
    tDeviceInfo deviceInfo;
    tResult res = MP_NO_ERROR;
    Query query;
    FILE *fp;
    tURL URL;

    res = system("find /var > /tmp/filelist.txt");
    fp = fopen("/tmp/filelist.txt", "r");
    CPPUNIT_ASSERT(fp != NULL);

    /* set the device data */
    InitDeviceInfo(OUT deviceInfo);
    strncpy_r(OUT deviceInfo.UUID, "64372258988559", IN sizeof(deviceInfo.UUID));
    strncpy_r(OUT deviceInfo.serialNumber, "8903660323", IN sizeof(deviceInfo.serialNumber));
    strncpy_r(OUT deviceInfo.deviceVersion, "ver 1.0", IN sizeof(deviceInfo.deviceVersion));
    strncpy_r(OUT deviceInfo.deviceName, "Iphone6", IN sizeof(deviceInfo.deviceName));
    strncpy_r(OUT deviceInfo.mountPoint, "dev_aa_bb_cc_dd_ee_ff", IN sizeof(deviceInfo.mountPoint));
    strncpy_r(OUT deviceInfo.accessoryName, "/dev/mmcblk0", IN sizeof(deviceInfo.accessoryName));
    deviceInfo.deviceType = DTY_USB;
    deviceInfo.connectionState = CS_CONNECTED;
    deviceInfo.fileSystemType = FSTY_FAT;
    deviceInfo.partitionNumber = 1;
    deviceInfo.totalSize = 67108864; //64GB
    deviceInfo.freeSize = 33554432; //32GB
    deviceInfo.productID = 9889;
    deviceInfo.connectionType = DCT_USB;

    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    CPPUNIT_ASSERT(res == 0);

    time_t rawtime;
    time(&rawtime);
    struct tm *timeinfo;
    timeinfo = localtime(&rawtime);
    tDateTime dateTime;
    strftime(dateTime, sizeof(dateTime), "%Y:%m:%d %H:%M:%S", timeinfo);

    /* prepare insert */
    res = query.Insert(LTY_MEDIAOBJECTS_INSERT);
    CPPUNIT_ASSERT(res == 0);

    tIndex row;
    for (row = 0; row < 10; row++) {

        // read in one name
        if (fgets(URL, sizeof(URL), fp) == NULL) {
            break;
        }

        tUUID UUID;
        tTitle title;
        tMetadata tag1;
        tMetadata tag2;
        tMetadata tag3;
        tMetadata tag4;
        tCompilation compilationFlag = 0;

        snprintf(UUID, sizeof(UUID), "uuid_x_%d", UUID);
        snprintf(title, sizeof(title), "title_x_%d", 99999);
        snprintf(tag1, sizeof(tag1), "tag1_x_%d", tag1);
        snprintf(tag2, sizeof(tag2), "tag2_x_%d", tag2);
        snprintf(tag3, sizeof(tag3), "tag3_x_%d", tag3);
        snprintf(tag4, sizeof(tag4), "tag4_x_%d", tag4);

        if (!(row % 2)) {
            compilationFlag = 1;
        }

        res = query.Put("iittttttttiiititiiltiii",
                IN deviceInfo.deviceID, //deviceID
                IN CTY_SONG,
                IN URL,
                IN UUID,
                IN UUID,
                IN title,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                IN 0,       //metadataConvertFlag
                IN compilationFlag,
                IN 10000,   //totalPlaytime
                IN URL,     //albumArtString
                IN row,     //trackNumber
                IN URL,     //path
                IN FNP_PLAYABLE,
                IN MTY_MUSIC_FILE,
                IN 3531000LL, //fileSize
                IN dateTime,
                IN 511,     //fileMode = 777(octal)
                IN 0,       //userID
                IN 0);      //groupID
        CPPUNIT_ASSERT(res == 0);
    }

    fclose(fp);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateMediaPlayerIndexedList_COMPILATIONS()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res;
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.album = 0x0;

    /* Get device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "Iphone6");
    CPPUNIT_ASSERT(res == 0);

    /* first create a list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList( OUT listID, OUT listSize, LTY_COMPILATION,
            IN streaming, IN tag1, IN tag2, IN tag3, IN tag4, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize == 1);

    /* second ask for all albums */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice( OUT mediaObjectVector, IN listID, 0, 5);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() == listSize);

    // set the filter tags
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.album = mediaObjectVector[0].MetadataTag4;

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList( OUT listID, OUT listSize, LTY_COMPILATION_SONG,
            IN streaming, IN tag1, IN tag2, IN tag3, IN tag4, IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice( OUT mediaObjectVector, IN listID, 0, 15);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() == listSize);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().RemoveMediaObjects(IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::CreateList_GetMediaObjects_LTY_COMPILATIONS()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    tListID listID;
    tDeviceID deviceID;
    tListType listType;
    tPlayContinuation playContinuation;
    tFilterTag1 filterTag1;
    tFilterTag2 filterTag2;
    tFilterTag3 filterTag3;
    tFilterTag4 filterTag4;
    tMediaObject mediaObject;
    tIndex rowNumber;

    filterTag1.tag = 0;
    filterTag2.tag = 0;
    filterTag3.tag = 0;
    filterTag4.tag = 0;

    /*
     * test list of genres
     */
    deviceID = MY_MEDIA; // list for my media
    listType = LTY_COMPILATION;
    playContinuation = PC_NO_REPEAT;

    /* create a list */
    res = LocalSPM::GetDBManager().CreateList(
            OUT listID,
            IN deviceID,
            IN listType,
            IN playContinuation,
            IN filterTag1,
            IN filterTag2,
            IN filterTag3,
            IN filterTag4);
    CPPUNIT_ASSERT(res == 0);

    /* get a media objects forward */
    rowNumber = 0;
    while(1) {

        /* get the object data */
        res = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT mediaObject, IN listID, IN rowNumber);
        if (res != 0) break;

        /* do a compare or what? */
        ETG_TRACE_USR2(("GetMediaObject: Tag1=%d->%s", mediaObject.MetadataTag1,mediaObject.MetadataField1));

        // next row
        rowNumber++;
    }

    ValidateSearchKeyList(listID);

    res = LocalSPM::GetDBManager().ReleaseDBList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::DVDStorageTableTest()
{
ENTRY_TEST
   // for checking DB Mgr , DVDStorage Table
    unsigned char resumeBuffer[256];
    memset(resumeBuffer,0x00,256);
    unsigned char resumeBufferfromdb[256];
    unsigned char setupBuffer[50];
    memset(setupBuffer,0x00,50);
    unsigned char setupBufferfromdb[50];
      // copy resume info
    for(unsigned int count=0 ; count<5 ; count++)
    {
      memset(resumeBufferfromdb,0x00,256);
      memset(setupBufferfromdb,0x00,50);
      tDVDInfoBlob dvdblob;
      dvdblob.data = resumeBufferfromdb;
      dvdblob.dataSize = sizeof(resumeBufferfromdb);
      LocalSPM::GetDBManager().GetDVDResumeInfo(dvdblob);
      //@@@ code?
      printf("\n resume data retrived cycle no %d : \n",count);
      for(int i=0 ; i< sizeof(resumeBufferfromdb);i++)
      {
          printf("\t %x ",resumeBufferfromdb[i] );
      }
      sleep(2);

      dvdblob.data = setupBufferfromdb;
      dvdblob.dataSize = sizeof(setupBufferfromdb);
      LocalSPM::GetDBManager().GetDVDSetupInfo(dvdblob);
      //@@@ code?
      printf("\n setup data retrived cycle no %d : \n",count);
      for(int j=0 ; j< sizeof(setupBufferfromdb);j++)
      {
          printf("\t %x ",setupBufferfromdb[j] );
      }

      unsigned int resumeCheck = memcmp(resumeBufferfromdb,resumeBuffer,256);

      CPPUNIT_ASSERT(resumeCheck == 0);

      unsigned int setupCheck = memcmp(setupBufferfromdb,setupBuffer,50);

      CPPUNIT_ASSERT(setupCheck == 0);


      memset(resumeBuffer,0x00,256);
      resumeBuffer[0]= 0x60;
      resumeBuffer[1]= (unsigned char) count;
      dvdblob.data = resumeBuffer;
      dvdblob.dataSize = sizeof(resumeBuffer);
      LocalSPM::GetDBManager().StoreDVDResumeInfo(dvdblob);
      printf("\n resume data stored in cycle no %d is : \n",count);
      for(int k=0 ; k< dvdblob.dataSize ;k++)
      {
          printf("\t %x ",dvdblob.data[k]);
      }

      memset(setupBuffer,0x00,50);
      setupBuffer[0]= 0x02;
      setupBuffer[1]= (unsigned char) count;
      dvdblob.data = setupBuffer;
      dvdblob.dataSize = sizeof(setupBuffer);
      LocalSPM::GetDBManager().StoreDVDSetupInfo(dvdblob);
      printf("\n setup data stored in cycle no %d is : \n",count);
      for(int l=0 ; l< dvdblob.dataSize ;l++)
      {
          printf("\t %x ",dvdblob.data[l]);
      }
      sleep(2);
    }
      return;
}

void DBManagerTest::CheckAllQueryLength()
{
    ENTRY_TEST
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    tListType listType = LTY_GENRE;

    while(listType != LTY_COMPILATION_SEARCH_KEY)
    {
        int length = Query::QueryLengthForListType(listType);
        ETG_TRACE_USR1(("Query length for list type %d is %d",listType,length));
        CPPUNIT_ASSERT(length < MAX_QUERY_LENGTH);
        listType = (tListType)((int)listType + 1);
    }
}

void DBManagerTest::MusicBoxPopertyTableTest()
{

ENTRY_TEST
tBoolean bAutoRipping = false;
tBoolean bAutoRippingRecv = false;
tResult result =  LocalSPM::GetDBManager().GetMusicBoxAutoRipping(bAutoRippingRecv);
ETG_TRACE_USR1(("GetMusicBoxAutoRipping %d ",bAutoRippingRecv));
CPPUNIT_ASSERT(bAutoRippingRecv == TRUE);

tU32 rippingEncodingQuality = 0;
tU32 rippingEncodingQualityRecv = 1;
result  = LocalSPM::GetDBManager().GetMusicBoxEncodingQuality(rippingEncodingQualityRecv);
ETG_TRACE_USR1(("GetMusicBoxEncodingQuality  %d ",rippingEncodingQualityRecv));
CPPUNIT_ASSERT(rippingEncodingQualityRecv == 0);

bAutoRipping = FALSE;
result =  LocalSPM::GetDBManager().SetMusicBoxAutoRipping(bAutoRipping);
result =  LocalSPM::GetDBManager().GetMusicBoxAutoRipping(bAutoRippingRecv);
ETG_TRACE_USR1(("GetMusicBoxAutoRipping changed from %d  to %d",bAutoRipping,bAutoRippingRecv));
CPPUNIT_ASSERT(bAutoRippingRecv == bAutoRipping);

rippingEncodingQuality = 192;
result  = LocalSPM::GetDBManager().SetMusicBoxEncodingQuality(rippingEncodingQuality);
result  = LocalSPM::GetDBManager().GetMusicBoxEncodingQuality(rippingEncodingQualityRecv);
ETG_TRACE_USR1(("GetMusicBoxEncodingQuality changed from %d  to %d ",rippingEncodingQuality,rippingEncodingQualityRecv));
CPPUNIT_ASSERT(rippingEncodingQuality == rippingEncodingQualityRecv);

}

void DBManagerTest::InsertCurrentUserforPersonalization()
{

ENTRY_TEST
tResult res;

tUserID retuserID = 1;

//------  Setting new User as current
tUserID userID1 = 1;
res = LocalSPM::GetDBManager().SetCurrentUser(userID1);
CPPUNIT_ASSERT(res == 0);

res = LocalSPM::GetDBManager().GetCurrentUser(retuserID);
ETG_TRACE_USR1(("retuserID %d ",retuserID));
ETG_TRACE_ERR(("GetCurrentUser  Error=%d/%s", res, errorString(res)));
CPPUNIT_ASSERT(res == 0);
CPPUNIT_ASSERT(retuserID == userID1);

//------  Setting new User as current
tUserID userID2 = 2;
res = LocalSPM::GetDBManager().SetCurrentUser(userID2);
CPPUNIT_ASSERT(res == 0);

res = LocalSPM::GetDBManager().GetCurrentUser(retuserID);
ETG_TRACE_USR1(("retuserID %d ",retuserID));
ETG_TRACE_ERR(("GetCurrentUser  Error=%d/%s", res, errorString(res)));
CPPUNIT_ASSERT(res == 0);
CPPUNIT_ASSERT(retuserID == userID2);

//------ Setting new User as current
tUserID userID3 = 3;
res = LocalSPM::GetDBManager().SetCurrentUser(userID3);
CPPUNIT_ASSERT(res == 0);

res = LocalSPM::GetDBManager().GetCurrentUser(retuserID);
ETG_TRACE_USR1(("retuserID %d ",retuserID));
ETG_TRACE_ERR(("GetCurrentUser  Error=%d/%s", res, errorString(res)));
CPPUNIT_ASSERT(res == 0);
CPPUNIT_ASSERT(retuserID == userID3);

//------ Setting already stored User as current
res = LocalSPM::GetDBManager().SetCurrentUser(userID1);
CPPUNIT_ASSERT(res == 0);

res = LocalSPM::GetDBManager().GetCurrentUser(retuserID);
ETG_TRACE_USR1(("retuserID %d ",retuserID));
ETG_TRACE_ERR(("GetCurrentUser  Error=%d/%s", res, errorString(res)));
CPPUNIT_ASSERT(res == 0);
CPPUNIT_ASSERT(retuserID == userID1);

}

void DBManagerTest::StoreFavoriteforPersonalization()
{

ENTRY_TEST
tResult res;

tLabelText labelText;
tDescriptorText descripterText;
tTitle title;
tMediaObject mediaObject;

tCategoryType objectType;
tObjectID objectID;
tUserID userID;
memset(labelText,0,sizeof(tLabelText));
memset(descripterText,0,sizeof(tDescriptorText));


objectType = CTY_SONG;

/* Create LabelText and DescripterText from title(stored above)*/
strncpy_r(labelText,"Default",sizeof(tLabelText));
strncpy_r(descripterText,"Default",sizeof(tDescriptorText));

tFavoriteID retFavID;
tObjectID retObjectID;
tUserID retuserID;
tFavoriteInfo favoriteInfo;
//----------
userID = 1;
objectID = 35;
/*Store the User favorite in the Database*/
res = LocalSPM::GetDBManager().StorePersonalizedFavorite(OUT retFavID, IN objectID, IN objectType, IN labelText, IN descripterText, IN userID);
CPPUNIT_ASSERT(res == 0);
ETG_TRACE_USR1(("retFavID %d ",retFavID));


InitFavoriteInfo(OUT favoriteInfo);
res = LocalSPM::GetDBManager().GetFavoriteInfo(favoriteInfo,retFavID);
CPPUNIT_ASSERT(res == 0);

CPPUNIT_ASSERT(objectID == favoriteInfo.objectID);
//------------------
tIsFavorite isuserfav;

tUserID userID1 = 1;
res = LocalSPM::GetDBManager().SetCurrentUser(userID1);
CPPUNIT_ASSERT(res == 0);

isuserfav = LocalSPM::GetDBManager().IsUserFavoriteObject(IN objectID);
ETG_TRACE_USR1(("isuserfav %d ",isuserfav));
CPPUNIT_ASSERT(isuserfav == 1);
//------------------
//----------
userID = 1;
objectID = 39;
/*Store the User favorite in the Database*/
res = LocalSPM::GetDBManager().StorePersonalizedFavorite(OUT retFavID, IN objectID, IN objectType, IN labelText, IN descripterText, IN userID);
CPPUNIT_ASSERT(res == 0);
ETG_TRACE_USR1(("retFavID %d ",retFavID));


InitFavoriteInfo(OUT favoriteInfo);
res = LocalSPM::GetDBManager().GetFavoriteInfo(favoriteInfo,retFavID);
CPPUNIT_ASSERT(res == 0);

CPPUNIT_ASSERT(objectID == favoriteInfo.objectID);

//----------------
objectID = 39;
/*Store the User favorite in the Database*/
res = LocalSPM::GetDBManager().StorePersonalizedFavorite(OUT retFavID, IN objectID, IN objectType, IN labelText, IN descripterText, IN userID);
CPPUNIT_ASSERT(res == 0);
ETG_TRACE_USR1(("retFavID %d ",retFavID));


InitFavoriteInfo(OUT favoriteInfo);
res = LocalSPM::GetDBManager().GetFavoriteInfo(favoriteInfo,retFavID);
CPPUNIT_ASSERT(res == 0);

CPPUNIT_ASSERT(objectID == favoriteInfo.objectID);

//-------------
objectID = 42;
/*Store the User favorite in the Database*/
res = LocalSPM::GetDBManager().StorePersonalizedFavorite(OUT retFavID, IN objectID, IN objectType, IN labelText, IN descripterText, IN userID);
CPPUNIT_ASSERT(res == 0);
ETG_TRACE_USR1(("retFavID %d ",retFavID));


InitFavoriteInfo(OUT favoriteInfo);
res = LocalSPM::GetDBManager().GetFavoriteInfo(favoriteInfo,retFavID);
CPPUNIT_ASSERT(res == 0);

CPPUNIT_ASSERT(objectID == favoriteInfo.objectID);


}
void DBManagerTest::YomiMetadataTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tYomiMetadata yomiMetadata, res_yomiMetadata;
    tObjectID MediaObjectTag = 3;


    strncpy_r(OUT yomiMetadata.YomiTitle,IN "TitleTest",IN sizeof(tMetadata));
    strncpy_r(OUT yomiMetadata.YomiArtist,IN "ArtistTest",IN sizeof(tMetadata));
    strncpy_r(OUT yomiMetadata.YomiAlbum,IN "AlbumTest",IN sizeof(tMetadata));

    res = LocalSPM::GetDBManager().AddYomiMetadata(MediaObjectTag, yomiMetadata);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetYomiMetadata(MediaObjectTag, res_yomiMetadata);

    ETG_TRACE_USR4(("YomiTitle %s ",res_yomiMetadata.YomiTitle));
    ETG_TRACE_USR4(("YomiArtist %s ",res_yomiMetadata.YomiArtist));
    ETG_TRACE_USR4(("YomiAlbum %s ",res_yomiMetadata.YomiAlbum));
    CPPUNIT_ASSERT(res == 0);

}
void DBManagerTest::RemoveYomiMetadataTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tObjectID MediaObjectTag = 3;

    res = LocalSPM::GetDBManager().RemoveYomiMetadata(MediaObjectTag);
    CPPUNIT_ASSERT(res == 0);



}

void DBManagerTest::MusicBoxToCTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tMetadata ToCString;
    tUUID uuid;

    strncpy_r(OUT ToCString,IN "150 21757 86962 148262 175405 202816",IN sizeof(tMetadata));
    VARTRACE(ToCString);
    strncpy_r(OUT uuid,IN "d0e4b2843d9876c9dbfaf8d3c884aebc",IN sizeof(tUUID));
    VARTRACE(uuid);

    res = LocalSPM::GetDBManager().AddMusicBoxToC(ToCString,uuid);
    CPPUNIT_ASSERT(res == 0);

    std::string res_ToCString;
    res = LocalSPM::GetDBManager().GetMusicBoxToC(IN uuid,OUT res_ToCString);
    VARTRACE(res_ToCString.c_str());

    ETG_TRACE_USR4(("ToCString %s ",res_ToCString.c_str()));
    CPPUNIT_ASSERT(res == 0);
}

void DBManagerTest::UUIDfromAlbumNameTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tMetadata albumName;
    tUUID uuid;

    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    mediaObject.deviceID = MUSICBOX_DEVICE_ID;
    mediaObject.catType = CTY_SONG;
    strncpy_r(OUT mediaObject.fileName, "/mydir/myfile.mp3", IN sizeof(mediaObject.fileName));
    strncpy_r(OUT mediaObject.UUID, "d0e4b2843d9876c9dbfaf8d3c884aebc", IN sizeof(mediaObject.UUID));
    strncpy_r(OUT mediaObject.parentUUID, "any parent UUID", IN sizeof(mediaObject.parentUUID));
    strncpy_r(OUT mediaObject.title, "My Song", IN sizeof(mediaObject.title)); //song title
    strncpy_r(OUT mediaObject.MetadataField1, "Rock", IN sizeof(mediaObject.MetadataField1)); //genre
    strncpy_r(OUT mediaObject.MetadataField2, "Thoemel", IN sizeof(mediaObject.MetadataField2)); //artist
    strncpy_r(OUT mediaObject.MetadataField3, "Ghostwriter", IN sizeof(mediaObject.MetadataField3)); //composer
    strncpy_r(OUT mediaObject.MetadataField4, "my first album", IN sizeof(mediaObject.MetadataField4)); //album
    mediaObject.metadataConvertFlag = 0;
    mediaObject.compilationFlag = 0;
    mediaObject.totalPlaytime = 30000;
    strncpy_r(OUT mediaObject.albumArtString, "/mydir/myfile.mp3", IN sizeof(mediaObject.albumArtString));
    mediaObject.trackNumber = 7;
    strncpy_r(OUT mediaObject.path, "/mydir/", IN sizeof(mediaObject.path));
    mediaObject.notPlayable = FNP_PLAYABLE;
    mediaObject.fileSize = 1567000LL;
    strncpy_r(OUT mediaObject.dateTime, "2016:07:08 14:56:00", IN sizeof(mediaObject.dateTime));
    mediaObject.fileMode = 356;
    mediaObject.userID = 190;
    mediaObject.groupID = 49;

    // get the DB info for the device
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN mediaObject.deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* put the device information into the media object */
    strncpy_r(OUT mediaObject.deviceVersion, IN deviceInfo.deviceVersion, IN sizeof(mediaObject.deviceVersion));
    strncpy_r(OUT mediaObject.mountPoint, IN deviceInfo.mountPoint, IN sizeof(mediaObject.mountPoint));
    mediaObject.deviceType = deviceInfo.deviceType;

    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    strncpy_r(OUT albumName,IN "my first album",IN sizeof(tMetadata));

    res = LocalSPM::GetDBManager().GetUUIDfromAlbumName(IN albumName,OUT uuid);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.UUID, uuid) == 0);
}

void DBManagerTest::UpdateGNdatainMediaObjectTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tRippedTrackInfo rippedTrackData;

    tTrackNumber tracknumber = 3;
    tDeviceID deviceID = MUSICBOX_DEVICE_ID;
    tUUID uuid;
    strncpy_r(OUT uuid,IN "d0e4b2843d9876c9dbfaf8d3c884aebc",IN sizeof(tUUID));

    strncpy_r(OUT rippedTrackData.title, "Unheilig_-_Grosse_Freiheit_-_16_-_Neuland", IN sizeof(tTitle));
    strncpy_r(OUT rippedTrackData.MetadataField1,IN "Metadata1Test",IN sizeof(tMetadata));
    strncpy_r(OUT rippedTrackData.MetadataField2,IN "Metadata2Test",IN sizeof(tMetadata));
    strncpy_r(OUT rippedTrackData.MetadataField3,IN "Metadata3Test",IN sizeof(tMetadata));
    strncpy_r(OUT rippedTrackData.MetadataField4,IN "Metadata4Test",IN sizeof(tMetadata));
    rippedTrackData.CompilationFlag = 1;


    res = LocalSPM::GetDBManager().UpdateGNmetadatainMediaObject(rippedTrackData,deviceID,uuid,tracknumber);
    CPPUNIT_ASSERT(res == 0);
}
