/*******************************************************************************
*
* FILE:          sortlib_helper.h
*
* SW-COMPONENT:  Sorting Lib
*
* PROJECT:       Bosch-GM-NextGen
*
* DESCRIPTION:   Sorting Lib for Sqlite
*
* AUTHOR:        Nishant Parashar
*
* COPYRIGHT:     (c) 2011 MontaVista Software LLC
*
*******************************************************************************/
#ifndef SORTLIB_HELPER_H
#define SORTLIB_HELPER_H

#ifndef FALSE
 #define FALSE (0)
#endif

#ifndef TRUE
 #define TRUE (1)
#endif

#define SORTLIB_LESS       -1
#define SORTLIB_EQUAL      0
#define SORTLIB_GREATER    1
#define SORTLIB_UTF_CODE_0 48
#define SORTLIB_UTF_CODE_9 57

#define SORTLIB_IS_DIGIT(c)  ( (SORTLIB_UTF_CODE_0 <= (c)) && (SORTLIB_UTF_CODE_9 >= (c)) )

#define SORTLIB_COMPARE_NUMS(num1,num2) ( ( num1 > num2 ) ? SORTLIB_GREATER : ( ( num1 < num2 ) ? SORTLIB_LESS : SORTLIB_EQUAL ) )

#define SORTLIB_ARRAY_SIZE 65535

#define SORTLIB_COLLATE_NAME "SORT_LIB"

#define SORTLIB_DEFAULT_TABLE_VALUE 0xFFFF
//#define SORTLIB_DEFAULT_TABLE_VALUE 0x0000

typedef struct _sortlib_dataArray__
{
  unsigned short* data;
  unsigned len;
} sortlib_dataArray;

typedef struct _sortlib_inputData__
{
  const char* s1;
  unsigned len1;
  unsigned index1;
  unsigned lastIndex1;

  const char* s2;
  unsigned len2;
  unsigned index2;
  unsigned lastIndex2;

  unsigned ucs1;
  unsigned ucs2;

} sortlib_inputData;

unsigned short* sortlib_calloc_ushort( unsigned long numElements );
int sortlib_isdigit( unsigned short c );
int sortlib_compare_nums( unsigned num1, unsigned num2 );
sortlib_dataArray sortlib_utf8_to_utf16( const char* utf8String, unsigned len );
//unsigned sortlib_next_ucs_char(char *s, unsigned *index);


#endif //SORTLIB_HELPER_H
