/*
 * VTMTP.cpp
 *
 *  Created on: Dec 26, 2013
 *      Author: Dinesh
 */


#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string>
#include <sqlite3ext.h>
SQLITE_EXTENSION_INIT1

#include "MTPCursor.h"
#include "FastUTF8.h"
#include "Utils.h"
#include "TypeDefinitions.h"

/*lint -save -e1773 */

/* DDL defining the structure of the vtable */
static const char* ddl = "create table vtable (" \
        "mountpoint text, " \
        "path text, " \
        "filename text, " \
        "itemid integer, " \
        "type integer, " \
        "format integer " \
        ") ";

static int VTMTPDestructor(sqlite3_vtab *pVtab) // finished: 100%
{
    tVTMTP *p = (tVTMTP*)pVtab; //lint !e826

    if(NULL != p){
        /* free the virtual table */
        sqlite3_free(p);
    }

    return 0;
}

static int VTMTPCreate( sqlite3 *db, void *p_aux, int argc, const char * const* argv , sqlite3_vtab **pp_vt,   char **pzErr ) // finished: 100%
{
    (void)argc;
    (void)argv;
    (void)p_aux;
    (void)pzErr;

    sqlite3_vtab *vTabObject;
    int rc;

    /* allocate the virtual table object */
    vTabObject = (sqlite3_vtab *)sqlite3_malloc(sizeof(sqlite3_vtab));
    if (!vTabObject) return SQLITE_NOMEM;
    memset(vTabObject, 0, sizeof(sqlite3_vtab));

    /* declare the table to the sqlite */
    rc = sqlite3_declare_vtab(db, ddl);
    if(rc != SQLITE_OK)
    {
        sqlite3_free(vTabObject);
        return SQLITE_ERROR;
    }

    /* set the resulting pointer to new vtab struct */
    *pp_vt = vTabObject;

    return SQLITE_OK;
}

static int VTMTPConnect( sqlite3 *db, void *p_aux, int argc, const char * const *argv, sqlite3_vtab **pp_vt, char **pzErr ) // finished: 100%
{
    return VTMTPCreate(db, p_aux, argc, argv, pp_vt, pzErr);
}

static int VTMTPDisconnect(sqlite3_vtab *pVtab) // finished: 100%
{
    return VTMTPDestructor(pVtab);
}

static int VTMTPDestroy(sqlite3_vtab *pVtab) // finished: 100%
{
    return VTMTPDestructor(pVtab);
}

static int VTMTPOpen(sqlite3_vtab *pVTab, sqlite3_vtab_cursor **pp_cursor) // finished: 100%
{
    tVTMTP* p_vt         = (tVTMTP*)pVTab; //lint !e826
    p_vt->base.zErrMsg = NULL;
    tVTMTPCursor *cursor = (tVTMTPCursor*)sqlite3_malloc(sizeof(tVTMTPCursor));
    if (cursor == NULL) {
        return SQLITE_NOMEM;
    }

    /* reset memory */
    memset(cursor, 0, sizeof(tVTMTPCursor));
    cursor->rrMTPControl = NULL;
    cursor->rrMTPControl =(RequestResponseMTPControl*) new RequestResponseMTPControl;
    if(NULL == (cursor->rrMTPControl))
    {
        return SQLITE_NOMEM;
    }
    /* return the pointer to the cursor memory */
    *pp_cursor = (sqlite3_vtab_cursor*)cursor;

    return SQLITE_OK;
}

static int VTMTPClose(sqlite3_vtab_cursor *cur) // finished: 100%
{
    tVTMTPCursor *cursor = (tVTMTPCursor*)cur; //lint !e826

    /* free cursor memory */
    if(cursor)
    {
        delete cursor->rrMTPControl;
        sqlite3_free(cursor);
    }
    return SQLITE_OK;
}

static int VTMTPEof(sqlite3_vtab_cursor *cur) // finished: 100%
{
    if((NULL != ((tVTMTPCursor*)cur)) && (NULL != ((tVTMTPCursor*)cur)->rrMTPControl)) //lint !e826
    {
        if(false == ((tVTMTPCursor*)cur)->rrMTPControl->isEOF) //lint !e826
        {
            return 0 ; // end of result set
        }
    }
    return 1;
}

static int VTMTPNext(sqlite3_vtab_cursor *cur) // finished: 100%
{
    tVTMTPCursor *cursor = (tVTMTPCursor*)cur; //lint !e826
    if((NULL != cursor) && (NULL != cursor->rrMTPControl))
    {
       return MTPCursorNext(cursor); //lint !e826
    }
    else
        return SQLITE_ERROR;
}

static int VTMTPColumn(sqlite3_vtab_cursor *cur, sqlite3_context *ctx, int i) // finished: 100%
{
    tVTMTPCursor *cursor = (tVTMTPCursor*)cur; //lint !e826
    if((NULL != cursor) && (NULL != cursor->rrMTPControl))
    {
        switch (i) {
            case 0: // mountpoint
                sqlite3_result_text(ctx, cursor->mountPoint, strlen_r(cursor->mountPoint), SQLITE_STATIC);
                break;

            case 1: // path
                sqlite3_result_text(ctx, cursor->path, strlen_r(cursor->path), SQLITE_STATIC);
                break;

            case 2: // name
                sqlite3_result_text(ctx, cursor->rrMTPControl->mFileInfo.fileName, strlen_r(cursor->rrMTPControl->mFileInfo.fileName), SQLITE_STATIC);
                break;

            case 3: // itemid
                sqlite3_result_int(ctx,  cursor->rrMTPControl->mFileInfo.trackNumber);
                break;

            case 4: // type
                sqlite3_result_int(ctx,  cursor->rrMTPControl->mFileInfo.type);
                break;

            case 5: // format
                sqlite3_result_int(ctx,  cursor->rrMTPControl->mFileInfo.fileFormat);
                break;

            default:
                sqlite3_result_int(ctx, 0);
                break;
        }
        return SQLITE_OK;
    }
    else
        return SQLITE_ERROR;
}

static int VTMTPRowid(sqlite3_vtab_cursor *cur, sqlite_int64 *p_rowid) // finished: 100%
{
    tVTMTPCursor *cursor = (tVTMTPCursor*)cur; //lint !e826

    if(NULL != cursor){
        /* Just use the current row count as the rowid. */
        *p_rowid = cursor->rowIndex;
        return SQLITE_OK;
    }
    else
        return SQLITE_ERROR;
}

static int VTMTPFilter( sqlite3_vtab_cursor *p_vtc, int idxNum, const char *idxStr, int argc, sqlite3_value **argv ) // finished: 80%
{
    (void)idxNum;
    (void)idxStr;

     tVTMTPCursor *cursor = (tVTMTPCursor*)p_vtc; //lint !e826

    if((NULL != cursor) && (NULL != cursor->rrMTPControl))
    {
        /* set the filter criteria */
        if (argc == 2)
        {
            strncpy_r(cursor->mountPoint, (const char *)sqlite3_value_text(argv[0]), sizeof(cursor->mountPoint));
            strncpy_r(cursor->path, (const char *)sqlite3_value_text(argv[1]), sizeof(cursor->path));
        }
        else
        {
            return SQLITE_ERROR;
        }

        /* reset the control information */
        cursor->rrMTPControl->isEOF = false;
        cursor->rowIndex = 1;
        return MTPCursorNext(cursor);
    }
    else
        return SQLITE_ERROR;
}

/******************************/
static int VTMTPHasConstraint(sqlite3_index_info *p_info, int col, int opmask) // finished: 100%
{
    int i;
    for(i = 0; i < p_info->nConstraint; i++)
    {
        if(p_info->aConstraint[i].iColumn == col)
        {
            /* If specific operations are specified */
            if(opmask != 0)
            {
                /* Check that at least one is satisfied */
                if(p_info->aConstraint[i].op & opmask)
                {
                    return i;
                }
            }
            return i;
        }
    }
    return -1;
}
static int VTMTPBestIndex(sqlite3_vtab *tab, sqlite3_index_info *pIdxInfo) // finished: 100%
{
    //ENTRY_TRACE

    (void) tab;

    int i = 0;
    int ops = SQLITE_INDEX_CONSTRAINT_MATCH | SQLITE_INDEX_CONSTRAINT_EQ;

    // mountpoint in where
    if((i = VTMTPHasConstraint(pIdxInfo, 0, ops)) > -1)
    {
        /* Then we want the value to be passed to xFilter() */
        pIdxInfo->aConstraintUsage[i].argvIndex = 1;
    }

    // path in where
    if((i = VTMTPHasConstraint(pIdxInfo, 1, ops)) > -1)
    {
        /* Then we want the value to be passed to xFilter() */
        pIdxInfo->aConstraintUsage[i].argvIndex = 2;
    }

    return SQLITE_OK;
}

static void VTMTPMatchFunction(sqlite3_context* ctx, int argc, sqlite3_value** argv) // finished: 100%
{
    (void)argc;
    (void)argv;

    sqlite3_result_int(ctx, 1);
}

static int VTMTPFindFunction( sqlite3_vtab *pVtab, // finished: 100%
                      int nArg,
                      const char *zName,
                      void (**pxFunc)(sqlite3_context*,int,sqlite3_value**),
                      void **ppArg )
{
    (void)nArg;
    (void)pVtab;
    (void)ppArg;

    if(strcmp(zName, "match") == 0)
    {
        *pxFunc = VTMTPMatchFunction;

        return 1;
    }
    return SQLITE_OK;
}

/////////////////////////////////////////////////////////////////////////////////////////////
static sqlite3_module VTMTPModule =
{
    0, /* iVersion */
    VTMTPCreate, /* xCreate - create a vtable */
    VTMTPConnect, /* xConnect - associate a vtable with a connection */
    VTMTPBestIndex, /* xBestIndex - best index */
    VTMTPDisconnect, /* xDisconnect - disassociate a vtable with a connection */
    VTMTPDestroy, /* xDestroy - destroy a vtable */
    VTMTPOpen, /* xOpen - open a cursor */
    VTMTPClose, /* xClose - close a cursor */
    VTMTPFilter, /* xFilter - configure scan constraints */
    VTMTPNext, /* xNext - advance a cursor */
    VTMTPEof, /* xEof - inidicate end of result set*/
    VTMTPColumn, /* xColumn - read data */
    VTMTPRowid, /* xRowid - read data */
    NULL, /* xUpdate - write data */
    NULL, /* xBegin - begin transaction */
    NULL, /* xSync - sync transaction */
    NULL, /* xCommit - commit transaction */
    NULL, /* xRollback - rollback transaction */
    VTMTPFindFunction, /*  xFindFunction - function overloading */
    NULL, /* *xRename */
    NULL, /* *xSavepoint */
    NULL, /* *xRelease */
    NULL  /* *xRollbackTo */
};

int VTMTP_register(sqlite3 *db) // finished: 100%
{
    return sqlite3_create_module(db, "MTPVT", &VTMTPModule, NULL);
}

extern "C" int sqlite3_extension_init( sqlite3 *db, char **pzErrMsg, const sqlite3_api_routines *pApi ) // finished: 100%
{
    (void)pzErrMsg;

    SQLITE_EXTENSION_INIT2(pApi);

    if(VTMTP_register(db) != SQLITE_OK)
    {
        return SQLITE_ERROR;
    }
    return SQLITE_OK;
}
