/**************************************************************************//**
* \file      VTFSEntry.cpp
* \ingroup   MediaPlayer
*
*            Implementation of Filesystem VT extension module entry.
*			 The virtual table is named "FileSystemVT"
*
* \remark    Copyright: 2012, Robert Bosch Car Multimedia GmbH, Hildesheim
* \remark    Scope:     MediaPlayer
* \remark    Authors:
*            - CM-AI/PJ-CD6 Xu Benny
******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "VTIPOD.h"
SQLITE_EXTENSION_INIT1


extern "C" int sqlite3_extension_init( sqlite3 *db, char **pzErrMsg, const sqlite3_api_routines *pApi ) // finished: 100%
{
    (void)pzErrMsg;

    SQLITE_EXTENSION_INIT2(pApi);

    if(VTIPOD_register(db) != SQLITE_OK)
    {
        return SQLITE_ERROR;
    }
    return SQLITE_OK;
}
