/**************************************************************************//**
* \file      VTFS.h
* \ingroup   MediaPlayer
*
*            Interface header of Filesystem virtual table.
*			 The virtual table is named "FileSystemVT"
*            See .h file for description.
*
* \remark    Copyright: 2012, Robert Bosch Car Multimedia GmbH, Hildesheim
* \remark    Scope:     MediaPlayer
* \remark    Authors:
*            - CM-AI/PJ-CD6 Xu Benny
******************************************************************************/

#ifndef IPOD_VTABLE_DECL
#define IPOD_VTABLE_DECL

#include <sqlite3ext.h>

/**
 * @brief register this filesystem VT implementation which have name "FileSystemVT".
 * @return SQLITE if succeed, otherwise return error or error code. 
 */	
int VTIPOD_register(sqlite3 *db);

#endif
