/**************************************************************************//**
* \file      VTCursor.h
* \ingroup   MediaPlayer
*
*            Interface header of Filesystem virtual table.
*			 The functions defined here implement cursor and relevant functions.
*            See .h file for description.
*
* \remark    Copyright: 2012, Robert Bosch Car Multimedia GmbH, Hildesheim
* \remark    Scope:     MediaPlayer
* \remark    Authors:
* 			 - Matthias Thömel
*            - CM-AI/PJ-CD6 Xu Benny
******************************************************************************/

#ifndef IPOD_CURSOR_H_
#define IPOD_CURSOR_H_

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h> 
#include <sqlite3.h>
#include <dirent.h>
#include <vector>
#include <string>
using namespace std;

#include "RequestResponseSM.h"

typedef tUInt tIPODID;

#include "FakeTheIPOD.h"
static FakeTheIPOD iPodFake;

typedef struct tIPODNode_tag
{
} tIPODNode;

typedef struct
{
    sqlite3_vtab base;
    sqlite3 *db;
} tVTIPOD;

/* the implementation for the request to the ipod control */
class RequestResponseIPODControl : public RequestResponseSM
{
	int HandleInitRequest()
	{
		return 0;
	}

	int HandleLoopBackMessage(const char *allParameters)
	{
		tListType listType;
		tFilterTag1 tag1;
		tFilterTag2 tag2;
		tFilterTag3 tag3;
		tFilterTag4 tag4;
		int rowID;
		char parameters[1024] = {0};
		int fakeIPODCount;
		tIPODName fakeIPODName = {0};
		tIPODID fakeIPODID;
		tIPODURL fakeIPODURL = {0};
		tMountPoint IPODMountpoint = {0};
		tUUID fakeUUID = {0};
		int fakeIPODActive = 0;
		tTrackNumber fakeTrackNumber = 0;
		int limit;
		int offset;

		/* read out the parameters */
		UnMarshal(allParameters, "tiiiiiiii", IPODMountpoint, (int *)&listType, &tag1.tag, &tag2.tag, &tag3.tag, &tag4.tag, &rowID, &limit, &offset);

		/* ask the fake class for values */
		fakeIPODID = 0;
		fakeIPODCount = 0;
		iPodFake.GetDBRecords(OUT fakeIPODCount, OUT fakeIPODName, OUT fakeIPODID, OUT fakeIPODURL, OUT fakeUUID, OUT fakeIPODActive,
				IN IPODMountpoint, IN listType, IN tag1, IN tag2, IN tag3, IN tag4, IN rowID, IN limit, IN offset);

		/* format the answer parameters */
		Marshal(parameters, sizeof(parameters), "iitttii", fakeIPODCount, fakeIPODID, fakeIPODName, fakeIPODURL, fakeUUID, fakeIPODActive, fakeTrackNumber );

		/* fake the answer from the ipod control */
		SendAnswer(parameters);

		return 0;
	}

public:

	int HandleSuccessRequest(const char *allParameters)
	{
		// the request/expect state machine has a general SUCCESS_REQUEST message which is not
		// specialized to a service sate machined be called. so all kind of parameters must
		// be processed by hand in this method.
		UnMarshal(allParameters, "iitttii", &IPODCount, &IPODID, IPODName, IPODURL, IPODUUID, &IPODActive, &IPODTrackNumber);

		return 0;
	}

	int IPODCount;
	char IPODName[1024];
	char IPODURL[1024];
	tIPODID IPODID;
	tUUID IPODUUID;
	int IPODActive;
	tTrackNumber IPODTrackNumber;
};

typedef struct
{
    sqlite3_vtab_cursor base;

    int 			objectCount_rowID;
    int 			endOfDataset;

    int				listType;
    tFilterTag1		tag1;
    tFilterTag2		tag2;
    tFilterTag3		tag3;
    tFilterTag4		tag4;
    int 			IPODCount;
    char 			IPODName[1024];
    tIPODID 		IPODID;
	RequestResponseIPODControl *rrIPODControl;
	char 			IPODURL[1024];
	tMountPoint 	IPODMountpoint;
	tUUID			IPODUUID;
	int 			IPODActive;
	tTrackNumber    IPODTrackNumber;
	int 			limit;
	int 			offset;
} tVTIPODCursor;

/* Update cursor to point to next top-level directory to search, if any. */
int IPODCursorNext(tVTIPODCursor *p_cur);

#endif /* FS_CURSOR_H_ */
